/* Copyright (c) 2008 Synology Inc. All rights reserved. */

#ifndef __SYNO_H_
#define __SYNO_H_

#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#endif
#define SYNO_HAVE_KERNEL_VERSION(a,b,c) (LINUX_VERSION_CODE >= KERNEL_VERSION((a),(b),(c)) )
#define SYNO_HAVE_GCC_VERSION(a,b) (__GNUC__ > (a) || (__GNUC__ == (a) && __GNUC_MINOR__ >= (b)))
#define SYNO_HAVE_GLIBC_VERSION(a,b) ( __GLIBC__ > (a) || (__GLIBC__ == (a) && __GLIBC_MINOR__ >= (b)))

/******************************* Platform Arch ************************************/
#if defined(CONFIG_ARCH_FEROCEON)
#define SYNO_ARM_LZMA_BACKPORT
#endif

/**
 * fix fast read/write bug
*/
#ifdef CONFIG_SYNO_PLX_PORTING 
#define SYNO_FAST_RW_FIX
#endif

/**
 * Dsc: This define is used for open synology related system call
 */
#define SYNO_SYSTEM_CALL

/**
 * Fix: no bug entry
 * Dsc: support hibernate to disk
 */
#if defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64)
#define SYNO_HIBERNATE_TO_DISK
#endif

/**
 * Fix: no bug entry
 * Dsc: support x86 wake up by rtc alarm match
 */
#if defined(CONFIG_SYNO_X64)
#define SYNO_X86_AUTO_POWER_ON
#endif

/**
 * Fix: no bug entry
 * Dsc: support x86 system temperature r/w
 */
#if defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64)
#define SYNO_PINEVIEW_SYSTEMP
#endif

/**
 * Fix: no bug entry
 * Dsc: support pineview superio pins r/w.
 *      writable pins are defined in table writable_pin_setting[].
 */
#if defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64)
#define SYNO_PINEVIEW_SUPERIO_RW
#endif

/**
 * Fix: no bug entry
 * Dsc: fix on board usb flash device name as "synoboot"
 */
#if defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64) || defined(CONFIG_SYNO_MV88F6281_USBSTATION)
#define SYNO_USB_FLASH_BOOT
#define SYNO_USB_FLASH_DEVICE_INDEX 255
#define SYNO_USB_FLASH_DEVICE_NAME  "synoboot"
#define SYNO_USB_FLASH_DEVICE_PATH  "/dev/synoboot"
/**
 * See bug #26535, #22204, #21688, this is a workaround for factory mis-use 0xF401 in bromolow & pineview as synoboot device
 * We fix #22204, #21688 first, then create #26535, so further workaround is required
 */
#if defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64)
#define IS_SYNO_USBBOOT_ID_VENDOR(VENDOR) (0xF400 == (VENDOR) || 0xF401 == (VENDOR))
#define IS_SYNO_USBBOOT_ID_PRODUCT(PRODUCT) (0xF400 == (PRODUCT) || 0xF401 == (PRODUCT))
#else
#define IS_SYNO_USBBOOT_ID_VENDOR(VENDOR) (0xF400 == (VENDOR))
#define IS_SYNO_USBBOOT_ID_PRODUCT(PRODUCT) (0xF400 == (PRODUCT))
#endif
#endif

/**
 * Fix: no bug entry
 * Dsc: support pineview lpc pins r/w to control sata led
 *      writable pins are defined in table writable_pin[]
 */
#if defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64)
#define SYNO_PCH_GPIO_CTRL
#endif

/**
 * Fix: no bug entry
 * Dsc: synobios rtc transformation is not matched with x86 rtc driver, 
 *      so we modify some codes to correct it.
 */
#if defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64)
#define SYNO_PINEVIEW_RTC
#endif

/**
 * Fix: no bug entry
 * Dsc: support reading CPU core temperature
 */
#if defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64)
#define SYNO_PINEVIEW_CORETEMP
#define SYNO_BROMOLOW_CORETEMP
#define SYNO_CEDARVIEW_CORETEMP
#endif

/**
 * Dsc: Let 6281 BSP can use sata_mv to drive the soc sata controller
 */
#if defined(CONFIG_ARCH_FEROCEON) && defined(CONFIG_SATA_MV)
#define SYNO_6281_SOC_USE_OPENSOURCE_SATA
#endif

/**
 * Dsc: Let 6281 BSP can use open source spi driver
 */
#if defined(CONFIG_ARCH_FEROCEON) && !defined(CONFIG_MV_INCLUDE_SPI)
/* #define SYNO_6281_SPI_USE_OPENSOURCE */
#endif

#if defined(CONFIG_ARCH_FEROCEON) && !defined(CONFIG_MV_INCLUDE_USB)
#define SYNO_6281_SOC_USE_OPENSOURCE_USB
#endif

/**
 * Dsc: Let 6281 soc register before 7042.
 */
#if defined(CONFIG_ARCH_FEROCEON) || defined(CONFIG_ARCH_KIRKWOOD)
#define SYNO_ESATA_7042
#endif
/******************************* Kernel Core **************************************/

/**
 * Fix: DS20 bug #1454
 * Dsc: Keeps UTC time in Kernel and RTC, donot wrap time.
 *      our user space code will handle this.
 */
#define SYNO_KERNEL_UTC_TIME

/**
 * Fix: DS20 bug #7262
 * Dsc: 1. Some customers have ever experience oom killer because cpu/memory
 *         is very heavy. However, after observing their system swap size, it's
 *         still almost full.
 *      2. The root cause is due to our original MMU threshold settings
 *         (1024/1024/1280/1536 = 4MB[reserved]/4MB[reclaim]/5MB[kswapd]/6MB[safe]).
 *         The kwapd active threshold to reserved threshold is only 1MB(5MB-4MB).
 *         Thus when system loading is extremly heavy, system is almost no chance
 *         to swapout(kswapd) or reclaim(MMU) any memory page. OOM killer is activate then,
 *         and most of time, postgresql is selected to be killed.
 *      3. After self test, CS407e is relative easy to reproduce this case when executing
 *         rtorrent, aMule and build raid5 in the background. Some customers said that when
 *         rtorrent speed is over 800KB, the OOM killer is activated.
 *      4. The final threshold we tuned is 1024/1024/2048/4096 = 4MB/4MB/8MB/16MB.
 */
#define SYNO_MMU_THRESHOLD_ADJUSTMENT

/**
 * Dsc: Set memory overcommit policy to overcommit to fix the fork error problem
 */
#define SYNO_MM_OVERCOMMIT_ALWAYS

/**
 * Fix: DS20 bug #7262
 * Dsc: Never kill the important process which would interact
 *      with user until there is no other process.
 *      1. scemd  we would never kill scemd even there is no any
 *                other process
 *      2. httpd  not include the cgi which forked by httpd
 *      3. findhostd
 *      4. hotplugd
 *      5. postgres
 *      6. syslogd
 *      7. klogd
 */
#define SYNO_OOM_POLICY

/**
 * Fix: no bug entry
 * Dsc: Avoid on board usb flash to be mounted by user.
 *      if user want to mount "synoboot" partition, 
 *      user need to echo "1" to /proc/sys/kernel/syno_install_flag first.
 */
#if defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64) 
#define SYNO_INSTALL_FLAG
#endif

/**
 * Fix: DSM 3.1 bug #19092
 * Dsc: Don't print message while cpu frequency changing 
 * IN : arch/arm/mach-feroceon-kw/cpufreq.c
 */
#define SYNO_NO_PRINT_WHILE_SWITCH_CPUFREQ

/**
 * Fix: DSM bug #21036
 * Dsc: Do not show nowait page allocation fail warning to prevent 
 *      QC team panic when they stress new platform.
 */
#define SYNO_HIDE_LOWMEM_WARNING

/******************************* Bootloader ***************************************/
/**
 * Dsc: Pass hardware version from uboot or other boot loader.
 *      So user mode can get the hardware version by using the
 *      following command:
 *    $ cat /proc/sys/kernel/syno_hw_version
 */
#define SYNO_HW_VERSION

/**
 * Dsc: The HD probing delay is executed based on the HD port 
 *      originallly. However, we have cases that there are some
 *      ports not used for internal hardisk. To reduce the delay
 *      probing time, a kernel environment variable "ihd_num" is
 *      defined.
 * Yet: arch/arm/plat-feroceon/mv_hal/sata/CoreDriver/mvSata.c
 *      drivers/ata/mvSata/mvSata.c
 *      drivers/ata/mvSata_4_2_2/CoreDriver/mvSata.c
 */
#define SYNO_INTERNAL_HD_NUM

/**
 * Ref: LKP2.6.32 #112
 * Dsc: Just parse bootloader command to judge how many network 
 *      interface used. A kernel environment variable "netif_num" 
 *      is defined.
 * Yet: arch/arm/plat-feroceon/mv_drivers_lsp/mv_network/mv_ethernet/mv_netdev.c
 *      arch/arm/mach-feroceon-kw/kw_family/ctrlEnv/mvCtrlEnvLib.c
 */
#define SYNO_INTERNAL_NETIF_NUM

/**
 * Dec: Switch the AHCI functions on/off at run time
 */
#define SYNO_AHCI_SWITCH

/**
 * Dec: Added argument "SataLedSpecial" to support special Sata LED/GPIO Setting.
 *      For RS2211, RS2211rp, RS2211rp+, and RS3611rp+ only.
 */
#define SYNO_SATA_LED_SPECIAL

/**
 * Dsc: Read MAC Address from bootloader or flash
 */
#define SYNO_MAC_ADDRESS

/**
 * Dsc: Enable use sysctl to set the value of SynoDebugFlag. We
 *      can use it to be a flag the turn on printk or do other
 *      debug actions.
 *
 *      To set the SynoDebugFlag:
 *
 *      $ sysctl -w kernel.syno_debug_flag=1
 * IN : mm/memory.c, lib/synolib/synocrond.c,
 *      lib/synolib/syno_process_name_get.c, kernel/sysctl.c,
 *      kernel/fork.c, include/linux/synolib.h, fs/open.c,
 *      fs/stat.c, fs/ext4/super.c, fs/ext4/super.c, arch/x86/ia32/sys_ia32.c
 * 		
 */
#define SYNO_DEBUG_FLAG

/**
 * Dsc: Support for serial number stored in vender partition
 */
#define SYNO_SERIAL

/******************************* MTD Driver ***************************************/
/**
 * Dsc: Capability for modifying partition information and FIS content in flash.
 */
#define SYNO_MTD_INFO

/**
 * Dsc: add mtd->lock and mtd->unlock function
 */
#define SYNO_MTD_LOCK_UNLOCK

/**
 * Dsc: Malloc before mtd write.
 * Dep: SYNO_SYSTEM_CALL
 */
#ifdef SYNO_SYSTEM_CALL
#define SYNO_MTD_ALLOC
#endif

/**
 * Dsc: For Synology flash. While parsing redboot fis directory, can not sort by
 *      mtd partition starting address. Should keeps the order in fis directory,
 *      ie, ppcboot/redboot maps to mtd0, zImage maps to mtd1.
 */
#define SYNO_MTD_PARTS_KEEP_ORDER

/******************************* Serial Driver ************************************/
/**
 * Dsc: Support for directly accessing the serial ttys device. 
 *      We use syno_ttys_write() to command uP (/dev/ttyS1) in scemd/synobios 
 *      to prevent breaking disk hibernation because it will bypass the vfs layer.
 */
#define SYNO_TTYS_WRITE

/**
 * Dsc:
 *   1.In pinview, com1(ttyS0) is used to control microp, com2(ttyS1) is
 *     console debug port. Other platforms/models are reversed.
 *   2. This define let pineview can output to console
*/
#if defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64)
#define SYNO_X86_TTY_CONSOLE_OUTPUT
#endif

/** 
 * Fix: DSM #14938 
 * Dsc:
 *   When poweroff/reboot, busybox will one: send SIGTERM, two: unmount
 *     fs, three: poweroff/reboot
 *   For one, uart1 will be closed, and after that, we can never ctrl microp.
 *     So we should avoid uart1 be closed(serial_core.c/uart_close).
 *   For two, we can only write register directly, but not write cmd
 *     to /dev/ttyS0.
 *   In three,kernel will shutdown all device driver first, so we should
 *     write register before that(kerenl/sys.c).
 */
#if defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64)
#define SYNO_X86_MICROP_CTRL
#endif

/**
 * Fix: DS2.0 #14368, #14321
 * Dsc:
 *  2.6.32 kernel ttyS1 driver tty->ops->put_char (will call uart_put_char)
 *  seems not write immediately, just write to the buffer.
 *  So the behavior is not we want, we use tty->ops->write 
 *  instead of tty->ops->put_char in MicroP case (ttyS1)
 * IN: drivers/char/tty_io.c 
 */
#define SYNO_FIX_MICROP_NOT_WRITE_IMMEDIATELY

/******************************* Network Driver ***********************************/
/**
 * Dsc: Add WOL support to Marvell BSP net driver.
 */
#define SYNO_NET_MV_WOL_WITH_UP

/**
 * Dsc: Add RGMII capability/setting to Freescale TSEC(Gianfar) driver.
 */
#define SYNO_TSEC_RGMII

/**
 * Dsc: change MgmtClk in MIIMCFG from 7 to 3
 * 		14.5.3.6.6 MII Management Configuration Register (MIIMCFG) 
 */
#define SYNO_MIIMCFG_VALUE

/**
 * Fix: LKP2.6.32 #12, #211
 * Dsc: We only have one network interface, there is no need to have atalk
 * 		routing. If we don't do this, when appletalk zone range bigger than
 * 		4096, the kernel will not enable appletalk at all. If we enlarge the
 * 		limit zone range, it would take a long long time to start atalkd.
 */
#define	SYNO_ATALK_ROUTERLESS

/**
 * Dsc: Fix marvell 8001 network chip bug. The rx and tx checksum field is swapped.
 *      Affected Models: <ppc824x>, <ppc853x:DS109+, DS209+, DS409+>
 */
#define SYNO_SKGE_CSUM_FIX

/**
 * Dsc: Fix Marvell 88E8001 driver link state bug. Set carrier state after
 *      netdev is registered so userspace can correctly get link status by
 *      checking "RUNNING" state of interface.
 */
#define SYNO_SKGE_LINKSTATE_FIX

/**
 * Dsc: Fix 853x, 854x gianfar driver link state bug. Set carrier state after
 *      netdev is registered so userspace can correctly get link status by
 *      checking "RUNNING" state of interface.
 */
#define SYNO_GIANFAR_LINKSTATE_FIX

/**
 * Dsc: Fix marvell 8071 network chip bug. The rx and tx checksum field is swapped.
 *      Affected Models: <mv6281:DS110j, DS210j>
 */
#define SYNO_SKY2_CSUM_FIX

/**
 * Fix: #1037
 * Dsc: change sk98lin's blinking behavior.
 */
#define SYNO_SK98_BLINK_BEHAVIOR

/**
 * Fix: #9579
 * Dsc: change mv8071's blinking behavior
 */
#define SYNO_SKY2_BLINK_BEHAVIOR

/**
 * Fix: #10984
 * Dsc: On pineview platform, some rx_missed_errors are reported
 *      during stressing. That is because the NAPI buffer is not
 *      sufficient between polling. Thus we enlarge the napi weight
 *      from 64 to 128.
 */
#define SYNO_E1000E_RX_MISSED_FIX

/**
 * Fix: #14746
 * Dsc: the ethtool always report e1000e's wol being not supported
 *      this fixes the problem.
 *	x86 platforms do not need to enable this definition,
 *	853x platforms needs this definition to make wol function
 *	     work.
 */
#define SYNO_E1000E_WOL

/* Fix: DS2.0 #11508, LKP2.6.32 #64
 * Dsc: remove some useless debug message
 */
#define SYNO_REMOVE_TCP_DEBUG

/**
 * Fix: DSM #22083
 * Dsc: Add support for Intel X520-T2 10GBASE-T network adapter.
 */
#define SYNO_IXGBE_SUPPORT_T2

/**
 * Fix: no bug entry
 * Dsc: switch net device name to collocate with hardware design
 */
#if defined(CONFIG_SYNO_MPC854X) || defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64) || defined(CONFIG_ARCH_FEROCEON)
#define SYNO_SWITCH_NET_DEVICE_NAME

#ifdef SYNO_SWITCH_NET_DEVICE_NAME
#define SYNO_MAX_SWITCHABLE_NET_DEVICE 8
#define SYNO_NET_DEVICE_ENCODING_LENGTH 6
#endif  /* SYNO_SWITCH_NET_DEVICE_NAME */
#endif

/**
 * DSM 3.0 #19064
 * Dsc: Support yota usb wimax dongle name.
 */
#define SYNO_YOTAWIMAX_SUPPORT
#ifdef SYNO_YOTAWIMAX_SUPPORT
#define SYNO_YOTAWIMAX_DESC          "SYNO CDC Ethernet Device for YotaKey"
#define SYNO_YOTAWIMAX_ETHERNET_NAME "wm"
#define SYNO_YOTAWIMAX_NET_NOLINK_EVENT (0xffffffff)
#endif

/**
 * Fix: DSM #30328
 * Dsc: Fix MPC854x ERRATA eTSEC #79:
 *      Generation of Ethernet pause frames may cause Tx lockup and false BD close
 */
#define SYNO_MPC854X_ERRATA

/**
 * Fix: DS2.0 #4712, DS2.0 #4713, LKP2.6.32 #162
 * Dsc: if network cable is not plugged in, system
 *      will try slower speed to detect link. However, we
 *      should set link status to "off" and speed to "0" when
 *      autoneg state is timeout to let upper application to
 *      know "link is not available"
 */
#ifdef CONFIG_SYNO_MPC85XX_COMMON
#define SYNO_NET_PHY_NOLINK_SPEED_INIT
#endif

/**
 * Dsc: 6281 has MTU issue when MTU larger than 1600. This fix that.
 */
#ifdef CONFIG_MACH_SYNOLOGY_6281
#define SYNO_6281_MTU_WA
#endif

/**
 * Dsc: porting BONDING from kernel 2.6.24 to 2.6.32,
 *      Bonding feature with a new name here.
 */
#define SYNO_NET_BOND
/**
 * Fix: DSM #20710
 * Dsc: Patch to fix bonding on NIC drivers using page-based sk_buff.
 *      Namely ixgbe.
 * Ref: linux-2.6:
 *      commit ab12811c89e88f2e66746790b1fe4469ccb7bdd9
 *      bonding: correctly process non-linear skbs
 */
#define SYNO_NET_BOND_FIX_NONLINEAR_SKB

/**
 * Dsc: change DAD default behavior to meet RFC 4862
 * 		ref: linux-2.6.git commit 1b34be74cbf18f5d58cc85c7c4afcd9f7d74accd
 */
#define SYNO_IPV6_RFC_4862

/**
 * Fix: DS3.0 #14939
 * Dsc: remove scope id check while the address is a local link.
 * Note: this violates the ipv6 standard and may cause problems in the future.
 */
#define SYNO_IPV6_LINKLOCAL

/**************************** BUG please fix it in the future ****************************/
/**
 * TODO
 * Dsc: for RFC 4862 after 2 hours timeout kill address
 *		because this scheme doesn't work over 110p, so modify jiffies
 */
#if defined(CONFIG_PPC_85xx)
#define SYNO_IPV6_110p_IPV6_READY
#endif

/******************************* USB Driver ***************************************/

/**
 * Dsc: hid ups will use user mode driver, so kernel hid module will not bind the hid ups 
 */
#define SYNO_USB_UPS

/**
 * Dsc: When keyboard or mouse plugged in, we will make it has static minor
 *      number from hiddev5.
 *      This is for our RF remote controller. The controller is keyboard+mouse.
 */
#define SYNO_STATIC_HIDDEV_MINOR

/**
 * Dsc: USB copy support
 *      use port number 99 to indicate USBCOPY port
 */
#define SYNO_USB_COPY
#define USBCOPY_PORT_LOCATION 99

/**
 * Dsc: When there is no serial in USB device, we will generate
 *      a serial from product. Futhermore, when product is empty also,
 *      we will generate a dummy name for it. If there are the same
 *      serial in other USB device, we will add number in the suffix.
 */
#define SYNO_USB_SERIAL_FIX

/**
 * Dsc: For USBIP project. Modify code for multiconnection.
 */
#define SYNO_USB_USBIP

/**
 * Dsc: For Internal SD Cardreader only.
 */
#define SYNO_HAS_SDCARDREADER

#ifdef SYNO_HAS_SDCARDREADER
#define SYNO_SD_COPY
#define SDCOPY_PORT_LOCATION 98
#endif

/**
 * Dsc: This is a very dirty compatibility fix for USB compatibility with
 *      JMicron USB chip (and others). We slow down its speed for more compatibility.
 */
#define SYNO_USB_STOR_COMP_ENHANCE

/**
 * Dsc:
 */
#define SYNO_USB_UPS_COMP_ENHANCE

/**
 * Fix: DSM #27097
 * Dsc: during poweroff, sometimes after disable device,
 * khubd want to handle connection, then null access
 */
#define SYNO_USB_SKIP_DISABLE_IN_SHUTDOWN

/**
 * Dsc: fix xhci problem
 */
#define SYNO_USB3_Q
#define SYNO_USB3_TIMEOUT
#define SYNO_USB3_BACKPORT
#define SYNO_USB3_RESET_WAIT
#define SYNO_USB3_SURPRESS_WARN
#define SYNO_USB3_RESET_RETRY
#define SYNO_USB3_STALL_WAIT

/**
 * Dsc: for factory test, disable usb3, only usb2
 */
#define SYNO_USB3_DISABLE_USB3

/**
 * Dsc: in factory test, some flashs do not response sometimes,
 * and the original timeout is 30/60s(SD_TIMEOUT), it is too long for factory test.
 * So let the timeout as 3s for factory test.
 * IN. block/blk-timeout.c, drivers/usb/host/xhci.c
 */
#define SYNO_USB_FAST_RESET


/******************************* MD Driver ****************************************/
/** 
 * Fix: DSM #19874
 * Dsc: Fix a null pointer access when reboot
 */
#define SYNO_RAID_FIX_FREE_NULL_SYSFS

/** 
 * Fix: DSM 3 #18934
 * Dsc: Let our system can detect raid with 0.9 sb from others x86
 */
#define SYNO_RAID_READ_09SB_ENDIANLESS

/** 
 * Fix: DS 2.0 #2215 #4541 #4542 #4674 #3294, LKP2.6.32 #76
 * Dsc: this define is used to notify raid that device has
 *      changed, usally is a driver hotplug event
 * IN : scsi_sysfs.c, md.c raid0.c raid1.c raid5.c
 *      include/linux/raid/md_k.h include/linux/raid/md.h
 */
#define SYNO_RAID_DEVICE_NOTIFY

/**
 * Fix: DS 2.0 #3046 #4286 #3063, LKP2.6.32 #70, #74
 * Dsc: this define is used to help SDK determind raid status. 
 *      In raid0, this define is used to consist mdstatus with
 *      other raid disk. When reboot, even if raid0 has problem,
 *      we must pretend it can be assemble
 * IN : md.c include/linux/raid/md_u.h raid0.c, raid1.c
 */
#define SYNO_RAID_STATUS

/**
 * Fix: DS2.0 #5798, DS2.0 #4438, LKP2.6.32 #77
 * Dsc: Let autorun md array from first disk. This is keep the 
 *      same as 2.6.15 with our modify Default is from 
 *      last disk. 
 * IN : md.c 
 */
#define SYNO_RAID_AUTOSTART_SEQUENCE

/**
 * Fix: DS 2.0 #5799 #14433, LKP2.6.32 #69
 * Dsc: We add a new status in md for bad sector use
 * IN : md.c md_k.h raid0.c, raid1.c, raid5.c, raid5.h
 */
#define SYNO_RAID_STATUS_DISKERROR

/**
 * Fix: DS 2.0 #5791, LKP2.6.32 #71
 * Dsc: Let raid read/write error can report to user through
 *      scemd and synobios
 * IN : synobios.c, md.c raid0.c, md.h, raid1.c, raid1.h
 */
#define SYNO_RAID_SECTOR_STATUS_REPORT

/**
 * Fix: DS 2.0 #2453, #5835 
 * Dsc: This can enhance 10% write performance.
 * IN : raid5.c, raid5.h
 */
#ifndef CONFIG_SYNO_BROMOLOW
#define SYNO_RAID5_WRITE_BIO_PAGE
#endif

/**
 * Fix: DS 2.0 #6373, LKP2.6.32 #125
 * Dsc: force starting dirty degraded raid 4/5/6 array. Please 
 *      refer linux-2.6.24/Documentation/md.txt
 *      Section: "Boot time assembly of degraded/dirty arrays"
 * IN : md.c
 */
#define SYNO_FORCE_START_DIRTY_DEGRADED_RAID456

/**
 * Fix: DS 2.0 #6961, #11857, LKP2.6.32 #99
 * Dsc: Do not assemble devices which derived from expansion box
 *      Do not assemble devices which is not belong to root devices
 * IN : md.c 
 */
#define SYNO_MD_BOOT_CONDITIONAL_ASSEMBLE

/**
 * Fix: DS 2.0 #6995, LKP2.6.32 #75
 * Dsc: Assemble linear raid while we extend the hot_remove_disk
 * IN : md.c
 */
#ifdef SYNO_RAID_DEVICE_NOTIFY
#define SYNO_RAID_LINEAR_ASM
#endif

/**
 * Fix: DS 2.0 #7873, LKP2.6.32
 * Dsc: Support hotplug while reshape
 */
#define SYNO_RAID_RESHAPE_HOTPLUG

/******************************* SATA Driver **************************************/
#if defined(CONFIG_SYNO_X64)
/**
 * Fix: No Bug Entry
 * Dsc: added features to control the leds via ICH9
 */
#define SYNO_ATA_AHCI_LED_MSG
#endif

/**
 * Fix: #22029, #22030, #22031
 * Dsc: Let internal/eunit disk can spinup simultaneity to speedup boot time.
 */
#define SYNO_ATA_FAST_PROBE

/**
 * Fix: #21684
 * Dsc: Force set some disk to 1.5Gbps in driver mode to enhance compatibility.
 * Disks:Hitachi HDS723020BLA642
 */
#define SYNO_SATA_FORCE_1_5GBPS

/**
 * Fix: #19706
 * Dsc: enlarge noise threshold to prevent recieve too many noise while normal stress.
 */
#ifdef CONFIG_SYNO_X64
#define SYNO_ENLARGE_RX_NOISE_TRRESHOLD
#endif

/**
 * Fix: #19052
 * Dsc: Let disk in blacklist cannot enable disk write cache and apply it during device starting
 */
#define SYNO_SATA_WCACHE_DISABLE

/**
 * Fix: #18974, #18975, #18976
 * Dsc: Fix 3726 cannot detect hotplug event in all sata chips
 */
#define SYNO_SATA_3726_HOTPLUG_FIX

/**
 *
 * Dsc: Let 6281 soc and 7042 can control phy power
 */
#define SYNO_SATA_MV_SHUTDOWN_PHY

/**
 * Fix: #18827, #19394
 * Dsc: Make 7042 can control phy gpio
 * IN : sata_mv.c
 */
#define SYNO_SATA_MV_GPIO_RW

/**
 * Fix: DS20 bug #10476
 * Dsc: Correct the vendor and model information showed in /proc/scsi/scsi
 * IN : libata-scsi.c
 */
#define SYNO_INQUIRY_STANDARD

/**
 * FIX: No Bug entry
 * Dsc: Allow user space to use ioctl() to get SATA hibernation status.
 * IN : libata-scsi.c
 */
#define SYNO_CHECK_DISK_SLEEP

/**
 *  Fix: DS20 bug #2345
 *  Dsc: add HDIO_GET_DMA for SCSI SATA
 *  IN : libata-scsi.c
 */
#define SYNO_IOCTL_HDIO_GET_DMA

/**
 * Fix : DS20 bug #2165, #5608, #5786
 * Dsc : add for scsi-idle.patch
 *       We using ata command 0xe0 for implement hibernation.
 *       This may need a idel timer for others query.
 * IN :  usb/storage/usb.c, usb/storage/usb.h, include/linux/major.h, include/scsi/scsi_device.h
 *       scsi/sd.c, scsi/scsi_ioctl.c, scsi/scsi.c, block/scsi_ioctl.c
 */
#define SYNO_DISK_HIBERNATION

/**
 * Fix: Related #14299, #14524 
 * Dsc: Prevent harddisks spin-up currently from standby
 *      mode. Add small amount of delay between each two disks
 *      so they do not consume too much power.
 * IN : mvLinuxIalLib.c, mvSata.c, mvSata.h, drivers/ata/libata-core.c,
 *      drivers/ata/libata-scsi.c, include/linux/libata.h, drivers/ata/libata-eh.c, drivers/ata/sata_mv.c,
 *      drivers/ata/libata-sff.c, kernel/sysctl.c
 */
#ifdef SYNO_INTERNAL_HD_NUM
#define SYNO_SPINUP_DELAY
#endif

/**
 * Fix: DS 2.0 #6006 
 * Dsc: get device index from scsi layer 
 * IN : synolib.h scsi_get_disk_index.c
 */
#define SYNO_SCSI_DEVICE_INDEX

/**
 * Fix: DS 2.0 #8450
 * Dsc: implement bad sector auto remap in SATA layer
 * IN: drivers/ata/libata-eh.c drivers/md/md.c drivers/md/md.h
 *     drivers/scsi/scsi_sysfs.c drivers/scsi/sd.c fs/partitions/check.c
 *     include/linux/genhd.h include/scsi/scsi_device.h
 */
#define SYNO_SATA_BAD_SECTOR_AUTO_REMAP

/**
 * Fix: DS 2.0 #2577 #5929, LKP2.6.32 #79
 * Dsc: Let raid5 can re-write and read back again when build
 *      parity.
 *      Oringinal raid5 would not retry any filed reads while
 *      create a new raid5. But some disk really need this.
 * IN : raid5.c
 */
#ifdef SYNO_SATA_BAD_SECTOR_AUTO_REMAP
#define SYNO_RAID5_BS_REWRITE
#endif

/**
 * Fix: No Bug entry
 * Dsc: when we unplug disk in 2.6.32, it may hang whole system.
 *      The reason is libata try to mirror taskfile between sata
 *      disk and chip shadow. But it does not exist such device.
 *      So it would hang.
 * IN:  drivers/ata/sata_sil.c
 */
#define SYNO_SATA_HOTPLUG_FIX

/**
 * Fix : No Bug entry
 * Dsc : Make internal SATA disk use fixed device name. For example, the
 *       first channel is sda, the second is sdb, etc. All USB disk would
 *       start from sdq.
 * IN  : drivers/scsi/sd.c, drivers/usb/storage/scsiglue.c, 
 *       lib/idr.c, drivers/ata/libata-scsi.c,
 *       drivers/ata/ahci.c, drivers/ata/sata_sil24.c, 
 *       include/linux/libata.h, include/linux/syno.h,
 *       include/scsi/scsi_device.h, include/scsi/scsi_host.h
 */
#define SYNO_FIXED_DISK_NAME

#if	defined(SYNO_FIXED_DISK_NAME) || defined(SYNO_BADSECTOR_TEST)
/**
 * Maximum SCSI internal disk. We will reserve device name for
 * internal disks.
 *
 * User mode "cardreaderd" would poll on external disk only.
 */
#if defined(CONFIG_SYNO_BROMOLOW)
#define SYNO_MAX_INTERNAL_DISK 19
#else
#define SYNO_MAX_INTERNAL_DISK	15
#endif

/**
 * Fix : DSM #23229, #23277, #23278, 23280
 * Dsc : Check the bootcmd parameters for disk naming sequence reversing.
 *       The input parameters is an array of port numbers for each ata chip.
 *       The numbers stand for the number of ports from the first one that is
 *       to be reserved. 0 for not reserving the sequences, 1 is meaningless.
 * IN  : arch/arm/kernel/setup.c, arch/powerpc/kernel/setup_32.c, arch/x86/kernel/setup.c
 *       drivers/ata/libata-scsi.c, include/linux/libata.h, include/linux/syno.h
 *       kernel/sysctl.c
 */
#define SYNO_SATA_DISK_SEQ_REVERSE

#endif

/**
 * Fix : DS 3.0 #18789
 * Dsc : Reads Sata-Port-Mapping information and forces the 7042 Sata 
 *       Hosts to initialize specified number of ports. This makes the
 *       disk name not skip some characters.
 *
 *       Notice - Do NOT set the port number out of the range that [0-9].
 *                It supports as most 9 ports now, and 0 means start all
 *                ports that ATA host supports.
 * IN  : arch/x86/kernel/setup.c, drivers/ata/sata_mv.c, drivers/ata/libata-core.c
 *       include/linux/libata.h, kernel/sysctl.c
 */
#define SYNO_SATA_PORT_MAP

/**
 * Fix : DS 2.0 #2308
 * Dsc : Make eSata could be detect quickly .
 * IN  : sata_sil.c
 */
#define SYNO_SATA_RAISE_TX_VOLT

/**
 * Fix : No Bug entry
 * Dsc : Make 2.6.32 phy ready change messages be the same with
 *       2.6.15. And make all sata driver has the same define.
 * IN  : sata_sil.c, sata_sil24.c, sata ahci.c, sata libata-core.c, sata libata.h
 */
#define SYNO_SATA_INFO

/**
 * Fix: DS 2.0 #5857
 * Dsc: limit libata error retry time interval from 5 to 2
 *      second.
 * IN : libata-eh.c
 */
#define SYNO_SATA_REDUCE_RETRY_TIMER

/**
 * Fix: DS 2.0 #6820
 * Dsc: Provide some gpio function in Sysfs
 *      Power off scsi port. Driver should implement their own
 * 		power off method
 * IN : scsi_host.h, libata-scsi.c, thor/linux/linux_main.c,
 *      mvSata/mvLinuxIalHt.h, mvSata/mvLinuxIalHt.c,
 *      sata_sil24.c, scsi_sysfs.c, ata.h, synosata.h, libata.h,
 *      ata.h, libata-pmp.c, mvSata/mvIALCommonUtils.c,
 *      mvSata/mvIALCommon.c, mvSata/mvIALCommon.h, drivers/ata/libata-sff.c
 */
#if defined(CONFIG_SATA_PMP) && defined(SYNO_INTERNAL_HD_NUM)
#define SYNO_SATA_PM_DEVICE_GPIO
#endif

/**
 * Fix: DS 2.0 #4931, #8509
 * Dsc: Deny some command in SSD disks. Note that, this is not essentail
 * 		for those model who are not support power in sequence.
 *
 * 		So, 2.4 sereis models could ignore whole
 * 		SYNO_SATA_SSD_CMD_DENY define
 *
 * 		Because the biggest problem is in our spinup delay code.
 * 		Sometimes those ssd just cannot wake up normally. So you
 * 		would see lots of wake up from hibernate in the syslog.
 */
#define SYNO_SATA_SSD_DETECT
 
/**
 * Fix: DS 2.0 #6890
 * Dsc: Some disk could not probe with sata_sil24.c . The reason
 *      is they always encounter "SRST command error". So we
 *      retry SRST and insert a sata_std_hardrest before retry
 *      it.
 *
 *      Disks: 9611-HD-005(WD10EACS-00ZJB0),
 *      9704-HD-019(WD7500AACS)
 *
 *      We have many disks which have the same models as above,
 *      but they would not have the same problem.
 *
 *      Note. When you port this to newer kernel, please try to
 *      reproduce firstly. If it still that, and i suggest port
 *      this define. Otherwise, please don't port this.
 */
#define SYNO_SATA_SIL3132_HD_DETECT

/**
 * Fix: DS 3.2 #26139
 * Dsc: Sending hotplug Event while inserting ebox with no disk.
 */
#define SYNO_PMP_HOTPLUG_TASK

/**
 * Fix: DS 2.0 #7872
 * Dsc: Hotplug in Samsung disk in fan out port is not easy to
 *      probe. The only way is to force hardreset pmp link in
 *      hotplug disk, no matter what kind of disk hotplug in.
 *      Because we cannot recocnize what kind of disk be plugged
 *      in.
 *
 *      So we force hard reset pmp link while any disk is plug
 *      in.
 *
 *      Disks: SAMSUNG HD103UJ.
 *
 *      Note. This problem only happen in hotplug in SAMSUNG
 *      		HD103UJ
 */
/**
 *		This situation still found in kernel 2.6.32. We can solve
 *		this problem by increase retry time which has done in
 *		porting #47 SYNO_SATA_SIL3132_HD_DETECT.
 *		We still port this define for compatibility.
 *
 *		Commiter: Eric C.Y.Chang
 *
 */
#define SYNO_SATA_PM_SAMSUNG_PROBE_TIME_FIX

/**
 * Fix: DS 2.0 # 7761
 * Dsc: Send ebox refresh event throught synobios to
 *      scemd for the ebox hotplug event.
 */
#ifdef SYNO_SATA_PM_DEVICE_GPIO
#define SYNO_SATA_EBOX_REFRESH
#endif

/**
 * Ref: LKP2.6.32 #182
 * Dsc: When plugged/unplugged disks, MV 7042 sata chip may missing IRQ,
 *      so disks can't be detected again. We find some workround in MV BSP:
 *      it didn't negotiated 1.5/3 G sata speed at first reset and also re-enable 
 *      interrupts, clear error whenn do hardware reset. So we back porting this 
 *      workaround.
 * IN   drivers/ata/sata_mv.c
 */
#define SYNO_FIX_MV_IRQ_MISSING

/**
 * Fix: [DSM] #22226, #22262
 * Dsc: Some sata chip (sil3132, 7042, 6281soc) apply horkage 1.5G,
 *      and then reset link, the speed will back to 3G. So we add
 *      some workround code on these chip drivers
 * In: drivers/ata/libata-core.c drivers/ata/sata_mv.c
 *     drivers/ata/sata_sil24.c include/linux/libata.h
 *     include/linux/syno.h
 * Parent: SYNO_FIX_MV_IRQ_MISSING
 */
#ifdef SYNO_FIX_MV_IRQ_MISSING
#define SYNO_FIX_HORKAGE_15G_MISSING
#endif

/**
 * Fix: DS 3.1 #19779
 * Dsc: 1.Drop IRQ requests from the ata ports offline,
 *        this prevents system hanging because that it
 *        cannot find correct data in the given address.
 *      2.When in deep sleep mode, we'll powoff disk, 
 *        we need off irq too
 * In: drivers/ata/libata-scsi.c drivers/ata/libata-eh.c 
 *	   drivers/ata/sata_mv.c drivers/ata/ahci.c 
 *	   drivers/ata/sata_sil24.c include/linux/libata.h 
 *	   drivers/scsi/sd.c include/scsi/scsi_ioctl.h 
 *	   include/linux/syno.h
 */
#if defined(SYNO_SATA_PM_DEVICE_GPIO) && defined(SYNO_SPINUP_DELAY)
#if defined(CONFIG_SYNO_X64) || defined(CONFIG_SYNO_MV88F6281)
#define SYNO_SATA_IRQ_OFF
#define SYNO_MAX_SATA_ID 20
#define SYNO_PWRPIN_ENCODE_LEN 2
#define SYNO_PORT_SIGN 'N'
/* one item is Nxxxx */
#define SYNO_PWRPIN_ITEM_LEN 1 + SYNO_PWRPIN_ENCODE_LEN*2
#endif /* defined(CONFIG_SYNO_X64) || defined(CONFIG_SYNO_MV88F6281) */
#endif /* defined(SYNO_SATA_PM_DEVICE_GPIO) && defined(SYNO_SPINUP_DELAY) */

/**
 * Fix: DS 2.0 # 8311
 * Dsc: SIL3132 cannot well communicate with a Hitachi hard
 *      disk which list below:
 *      Model Family:     Hitachi Travelstar 5K100 series
 *		Device Model:     HTS541040G9SA00
 *		Serial Number:    MPBB20X2GTZRKM
 *		Firmware Version: MB2OC40J
 *		User Capacity:    40,007,761,920 bytes
 *		ATA Version is:   6
 *      ATA Standard is:  ATA/ATAPI-6 T13 1410D revision 3a
 *
 *      We force the IPM and communication speed on this kind of
 *      disk. Let SIL3132 can play nicely with this disk.
 *
 *      This disk is taken from robenh.
 */
#define SYNO_SATA_SIL3132_HITACHI_WORKAROUND

/**
 * Fix: DS 2.0 #7197
 * Dsc: Seagate Disk would not stagger spin up when we power on the ebox.
 *      If we do not reset pmp link first, those disk would not spin up after next
 *      time we reset pmp link.
 *
 *      So we force hard reset pmp link if we power on our ebox.
 *
 *      Disks: 9711-HD-012, 9711-HD-002, 9711-HD-003(ST380815AS),
 *      9704-HD-019(WD7500AACS). Other bigger size Seagate disk would also has this symptom
 *
 *      Note. This problem only happen in power on ebox. If the ebox has poweron already,
 *            It would not happen.
 */
#define SYNO_SATA_PM_SEAGATE_PROBE_TIME_FIX

/**
 * Fix: DS 2.2 #10983
 * Dsc: let pmp device send cable event to user space
 */
#define SYNO_LIBATA_PMP_UEVENT

/**
 * Let JMB could has the same behavior as other sat controller in 6281 platform
 * My test: JMB + pineview with the same kernel would not has the same problem.
 * (Can not probe DX5 when booting if the power of DX5is on)
 */
#ifdef CONFIG_SYNO_MV88F6281
#define SYNO_LIBATA_JMB_BEHAVIOR
#endif

/**
 * Fix: LKP2.6.32 #218
 * Dsc: In order to make LED static when disk present and blinking when
 *      disk active, we have to set the offset 0x104F0 bit 0-1
 *      to 0x00 and bit 2-3 to 1. See data sheet page 282 (Table
 *      232: GPIO port control register), this is for open source mv driver
 *      SYNO_MV_SATA_LED is for BSP MV sata driver
 * IN : sata_mv.c
 */
#define SYNO_OSS_SATA_LED

/**
 * Fix: DS 2.0 #14275, LKP2.6.32 #233
 * Dsc: When disks device revalidate fail, handle dev fail function
 *      didn't kick this dev off. This may cause raid in error state.
 *      (ex. Seems these disks are ok, and keep resync)
 *      So we add condition to kick these disks off. When handle device
 *      fail is because -EIO, we kick this device off
 * IN : drivers/ata/libata-eh.c
 */ 
#define SYNO_HANDLE_EIO_DISKS

/**
 * Dsc: Upgrade libata error handling code from kernel tree
 *      6013ef [PATCH] libata: retry failed FLUSH if device didn't fail it
 * IN : drivers/ata/libata-eh.c include/linux/libata.h
 */ 
#define SYNO_LIBATA_EH_UPGRADE

/**
 * Dsc: fix if revalidate success, libata-eh still not retry flush 
 * IN : drivers/ata/libata-eh.c include/linux/libata.h 
 * Parent: SYNO_LIBATA_EH_UPGRADE
 */ 
#define SYNO_FIX_LIBATA_NOT_REFLUSH

/**
 * Dsc: let sata disk export its serial number 
 * IN : drivers/ata/libata-scsi.c drivers/ata/ahci.c
 * Parent: SYNO_SATA_PM_DEVICE_GPIO 
 * NOTE: I didn't porting this define to MV BSP driver, so if we use MV BSP driver later
 *       must porting this define to drivers/ata/mvSata_4_2_2
 */ 
#define SYNO_SATA_DISK_SERIAL

/******************************* File System **************************************/
/**
 * Fix bug #15588
 * Kernel native hfsplus has problem with multi-process write. We add the mutex for each write.
 * FIXME: We should make the lock smaller.
 */
#define SYNO_HFSPLUS_ADD_MUTEX_FOR_VFS_OPERATION

/**
 * Fix bug #20845
 * There is online resize boundary with 16TB.  One problem is ioctl only reconizes _u32 input. The other is reserved GDT maximum limitation with 1024.
 * This fix will make it reconizes _u64, and break the maximum of GDT limitation to 8192.
 * 8192 limitation: Because of the maximum jbd2 transaction size is 8192 (the volume should more than 8G).
 */
#ifdef CONFIG_64BIT
#define SYNO_RESIZE_INODE_SIZE_EXTEND
#endif

/**
 * Fix bug #17810
 * Original write_begin will add inode to orphan list twice if write failed.  It is no problem in normal case.
 * But in recvfile.  It will call write_begin() 8 times, and journal credits are not enough.  It will hit ASSERT, then stock.
 * ext3/4 have the same case.
 * This part is the same with ext4_da_write_begin() now.
 * see also 1938a150.
 */
#define SYNO_REDUCE_ADD_INODE_ORPHAN_TWICE

/**
 * Fix bug #25749
 * The "Native OS" in SMB packets sent by cifs.mount will be replaced with "Linux version 2.6.32".
 * However, we have to identify those packets to export @eaDir for such clients.
 * Therefore we change the Native OS to "Synology Linux version 2.6.32" for identification.
 */
#define SYNO_REPLACE_SMB_NATIVE_OS

/**
 * Fix bugs [DSM] #26543, #26544
 * When upload a file with icon from mac to ds, and the destination on ds is a cifs mount point of
 * another mac share, the upload action fail in mac os 10.6.2, or lose ea in mac os 10.6.8/
 * The reason is that icon is store in 'icon\r', and '\r' will be conver by mac.
 * Therefore we change '/r' (0x0d) to (0xf00d).
 */
#define SYNO_CIFS_SPECIAL_CHAR_CONVER

/**
 * Fix bug #16765
 * Apply patch 9f37622f.  It will put the error msg of ecryptfs_lookup failed into debug.
 */
#define SYNO_ECRYPTFS_IGNORE_LOOKUP_FAIL_MSG

/**
 * Fix bug #15401
 * FAT grow file size in write_begin state not write_end via recvfile.  
 * It could be well error handling while write_begin failed and do vmtruncate now.
 */
#define SYNO_ENHANCE_FAT_WRITE_BEGIN

/**
 * Fix bug #14852 
 * Add mutex for quota file while mount. patch c56818d7.
 */
#define SYNO_ADD_MUTEX_WHEN_GET_QUOTA_FILE

/**
 * Fix bug #14372
 * Ignore do quotacheck warning after volume creating. 
 * New version kernel patch(62af9b52) will put it in debug, too.
 */
#define SYNO_IGNORE_QUOTACHECK_WARNING

/**
 * Fix bug #15018
 * Upgrade dquot for correct.
 * patches: 26245c9, 44338711, 5dd4056d, 56246f9a, 0e05842b, 72b8ab9.
 */
#define SYNO_DQUOT_UPGRADE

/**
 * Dsc: Add syno force umount function.  It will scan all the
 * opened files which are on the mounted file system. And force
 * to decrease it's f_ount, d_count, and mnt_count.  After
 * working, move the file structure to /proc/invalidfile, and
 * mark it as invalid.
 */
#define SYNO_FORCE_UNMOUNT


/**
 * Dsc: A switch to turn on/off syno xattr handler.
 * Add syno xattr handler includes related functions.
 * Use "syno." for namespace.
 * Add ext3_xattr_syno_handler is the handler for ext3,
 * ext4_xattr_syno_handler is for ext4.
 */

#define SYNO_XATTR
#ifdef SYNO_XATTR
/**
 * Dsc: Add syno archive version for backup. Each inode and 
 * superblock all keep a version info. Once a file or directory 
 * is modified, inode's version will be set to super block's 
 * version plus 1. Super block's version could be increased by
 * user program when complete a backup. With each inode's 
 * version comparing to backup's version, we could quickly find 
 * out modified files. May refer to SYNO_ARCHIVE_BIT.
 * Archive version shall supported by syno xattr.
 */
#define SYNO_ARCHIVE_VERSION
#endif

/**
 * Fix bug #14250
 * EcryptFs will print a lots error code if the lower has no space/quota.  Stop this.
 */
#define SYNO_ECRYPTFS_SKIP_EDQUOT_WARNING 

/**
 * Fix bug #14281
 * Ext4 default mount option with journal_checksum.
 */
#define SYNO_EXT4_DEFAULT_JOURNAL_CHECKSUM

/**
 * Default mount fat with "flush".
 * It will flush data to disk ASAP.  User may remove the external device without umount.
 * It can protect data lose.
 */
#define SYNO_FAT_DEFAULT_MNT_FLUSH

/**
 * When truncate, only write file metadata to lower, don't write file body
 */
#define SYNO_ECRYPTFS_REMOVE_TRUNCATE_WRITE

/**
 * Dsc: Add two syscalls for encryptfs.  They could convert file
 * name from cipher to plaintext, and from plaintext to cipher. 
 * From plaintext to cipher, it needs only plaintext full 
 * pathname and return encrypt file name.  From cipher to 
 * plaintext, it needs both full encrypted pathname (not 
 * including plaintext part) and ecryptfs mount point path, then 
 * it will return plaintext full pathname.  This function should 
 * be called at ecryptfs mounted. 
 */
#define SYNO_ECRYPTFS_FILENAME_SYSCALL

/**
 * Dsc: A switch to turn on/off our FAT modification.
 */
#define SYNO_FAT
#ifdef SYNO_FAT
/**
 * Fix: #3371
 * Dsc: All error handling we added for FAT should use this define
 *        1. Added a new error "ECORRUPT" for FAT. After FAT is panic,
 *            it will be mounted read-only and we will see "corrupt" in
 *            /proc/mounts.
 */
#define SYNO_FAT_ERR_HANDLE

/**
 * Fix: DS20 bug #1978
 * Dsc: Load default NLS table for FAT if modules not found.
 */
#define SYNO_FAT_LOAD_DEF_NLS

/**
 * Fix: DS20 bug #2182
 * Dsc: Skip checking boot indicator while checking MS_DOS partion.
 */
#define SYNO_FAT_SKIP_BOOT_INDICATOR_CHK
#endif

/**
 * Fix: DS20 bug #5787
 * Dsc: Skip printing kernel warning message when buffer head
 *      isn't up to date.
 */
#define SYNO_SKIP_BH_WARNON

/**
 * Fix: DS 2.2 #11447 
 * Dsc: In oldalloc, it will allocate inode in the group whose 
 * free inode count fewer than average.  But it is approximate. 
 * In SMP, it will find that all group's inode count is equal 
 * to average, then fs couldn't find available group. We force 
 * it to find one available group. 
 */
#define SYNO_FORCE_GET_AVAILABLE_GROUP

/**
 * Fix: DS20 bug #2195
 * Dsc: Make Quota related functions more robust.
 *      - Quota function won't loop forever when system unmount
 *        a readonly volume.
 */
#define SYNO_QUOTA_ROBUSTNESS

/**
 * Fix: DS20 bug #867
 * Dsc: Empty
 */
#define SYNO_DS20_BUG_867

/**
 *  Ignore fsck needed warning
*/
#define SYNO_REMOVE_CHECKTIME_WARNING

/**
 * Dsc: Ignore unuse mount attribute, such as barrier.
 */
#define SYNO_IGNORE_MNT_OPT

/**
 * Dsc: Keep the created time of files/directories for Ext3. This 
 *      modify should sync with samba 
 */
#define SYNO_CREATE_TIME

/**
 * Dsc: Archive bit support on Ext3 and also the samba archive,
 *      hidden, system bit on Ext3 This modify should sync with
 *      samba.
 */
#define SYNO_ARCHIVE_BIT
#ifdef SYNO_ARCHIVE_BIT
/**
 * Dsc: Support ACL in ext4. 
 *      ACL depends on SYNO_ARCHIVE_BIT
 */
#if !defined(CONFIG_SYNO_MV88F6281_USBSTATION) && !defined(SYNO_MARVELL_88F6180)
#define SYNO_FS_SYNO_ACL
#endif

#if defined (F_CLEAR_ARCHIVE) || defined (F_SETSMB_ARCHIVE) || defined (F_SETSMB_HIDDEN) || \
	defined (F_SETSMB_SYSTEM) || defined (F_CLRSMB_ARCHIVE) || defined (F_CLRSMB_HIDDEN) || \
	defined (F_CLRSMB_SYSTEM) || defined (F_CLEAR_S3_ARCHIVE)
#error "Samba archive bit redefine."
#endif

#if defined(SYNO_FS_SYNO_ACL) || defined(CONFIG_FS_SYNO_ACL)
#if defined (F_CLRSMB_READONLY) || defined (F_SETSMB_READONLY) || \
	defined (F_CLRACL_INHERIT)  || defined (F_SETACL_INHERIT)  || \
	defined (F_CLRACL_OWNER_IS_GROUP) || defined (F_SETACL_OWNER_IS_GROUP)  || \
	defined (F_SETACL_SUPPORT) || defined (F_SETACL_SUPPORT)
#error "ACL archive bit redefine."
#endif /* ACL archive bit redefine. */
#endif /* SYNO_FS_SYNO_ACL */

#define F_CLEAR_ARCHIVE     513
#define F_SETSMB_ARCHIVE    514
#define F_SETSMB_HIDDEN     515
#define F_SETSMB_SYSTEM     516
#define F_CLRSMB_ARCHIVE    517
#define F_CLRSMB_HIDDEN     518
#define F_CLRSMB_SYSTEM     519
#define F_CLEAR_S3_ARCHIVE  520

#ifdef SYNO_FS_SYNO_ACL
#define F_CLRSMB_READONLY   		521
#define F_SETSMB_READONLY   		522
#define F_CLRACL_INHERIT    		523
#define F_SETACL_INHERIT    		524
#define F_CLRACL_HAS_ACL   			525
#define F_SETACL_HAS_ACL   			526
#define F_CLRACL_SUPPORT   			527
#define F_SETACL_SUPPORT   			528
#define F_CLRACL_OWNER_IS_GROUP   	529
#define F_SETACL_OWNER_IS_GROUP   	530
#endif /* SYNO_FS_SYNO_ACL */

#endif /* SYNO_ARCHIVE_BIT */
/**
 * Dsc: Let ext3 file system be case-insensitive.
 *      This modify should sync with Samba and e2fsprogs.
 */
#define SYNO_KERNEL_UNICODE
#ifdef SYNO_KERNEL_UNICODE
#ifdef SYNO_SYSTEM_CALL
#define SYNO_UNICODE_STAT
#endif
/* It's max path string len of smb. we should sync it with smb.*/
#define SYNO_SMB_PSTRING_LEN 1024
#endif

/**
 * Fix: DS2.0 bug #14502
 * Dsc: Prevent possible dead-lock.
 */
#define SYNO_BLKDEV_MUTEX_LOCK

/**
 * Dsc: recvfile syscall
 *      This modify should sync with samba
 */
#ifdef SYNO_SYSTEM_CALL
#define SYNO_RECVFILE
#ifdef SYNO_RECVFILE
/* SYNO_OLD_RECVFILE use prepare_write() and commit_write(), else use write_begin() and write_end(). */
/*#define SYNO_OLD_RECVFILE*/
#endif
#endif

/** 
 * Fix: DS20 bug #8459 
 * Dsc: Hide mount option "oldalloc".
 */
#define SYNO_HIDE_OLDALLOC

/**
 * Fix bug #14416
 * When quota is full, create encrypted may fail and can't create the same file again in the
 * same path. So we delete the fail crate file when QUOTA FULL
 * IN: fs/ecryptfs/inode.c 
 */
 #define SYNO_ECRYPTFS_FIX_CREATE_FAIL_WHEN_QUOTA_FULL

/** 
 * Fix: DS31 bug #20481
 * Dsc: When ext3 volume is full, it will alloc large memory 
 * once. It makes low memory machine OOM.  Apply kennel patch 
 * 8cef107a 
 */
#define SYNO_FIX_EXT3_VOLUME_FULL_OOM

/**
 * Fix: DS31 bug #25869
 * Dsc: Force UDF fs as caseless
 * FIXME We should reference SYNO_KERNEL_UNICODE to let dentry cache work,
 *       let it can use cache to find files
 */
#define SYNO_FORCE_UDF_CASELESS



/******************************* Crypto. ********************************************/

/**
 * Dsc: Talitos channel management has bug on it. This fix that problem.
 *      We let XOR engine can only use one channel. And others can free to select
 */
#define SYNO_TALITOS_CHANNEL_FIX

/**
 * Dsc: Some 8533E board cannot pass boot up crypto self test. 
 *      It makes me curious but we cannot reproduce it in our lab. 
 *      So i just workaround it. I had tested this in customer machine. Support #54591, #55370
 * 
 *      Please do not porting this, kernel has a new way to disable selftest. 
 *	    Just enable it rather than use this define in newer kernel.
 */
#define SYNO_CRYPT_NO_SELFTEST

/**
 * Dsc: Let ocf framework use linux crypto api to offload task
 *      to hw engine for those crypto driver don't implement ocf
 *      support.
 */
#define SYNO_OCF_USE_LINUX_CRYPTOAPI

/*
 * combine ecryptfs and ocf framework.
 * Only open this function when OCF framework is used.
*/
#if defined(CONFIG_SYNO_USE_OCF_LINUX) && !defined(CONFIG_CRYPTO_HW)
#define SYNO_ECRYPTFS_OCF
#endif

/**
 * Dsc: convert blkcipher to ablkcipher , let ecrpytfs can use
 *      both hardware accelerate and software.
 */
#ifndef SYNO_ECRYPTFS_OCF
#define SYNO_ECRYPTFS_WITH_ABLKCIPHER
#endif

/**
 * Dsc: This fix the memory leak issues in ocf_20100325 when we only use 
 *      cryptosoft engine. 
 */
#define SYNO_FIX_OCF_MEMORY_LEAK

/******************************* Linux-iSCSI.org (LIO) ****************************
 *
 * Dsc: Merge http://git.kernel.org/?p=linux/kernel/git/nab/lio-core-2.6.git
 */
#ifdef CONFIG_SYNO_LIO

/**
 * Dsc: Change original vendor identifier "LIO-ORG" to "SYNO"
 */
#define SYNO_LIO_VENDOR_ID

/**
 * Dsc: Support 2T+ file-based LUN. 
 *      For historic reason, the maximum file size in Ext3 is 2 tera bytes.
 *      In order to support 2T+ LUN, we separate 1T+ file-based LUN into 
 *      every 1T file. For example, 3.4T file-based LUN will be separated
 *      into 4 files:
 *          +----+----+----+---+
 *          | 1T | 1T | 1T |.4T|
 *          +----+----+----+---+
 */
#define SYNO_LIO_LARGE_FILEIO

#define SYNO_LIO_DEFAULT_ACL

/**
 * Dsc: Fixed for DSM#15872
 *      Call trace when removing LUN in a enabled target.
 */
#define SYNO_LIO_FREE_DEV_TASKS_CHECK

/**
 * Dsc: Fixed for DSM#16032
 *      Workaround for call trace issue when releasing tpgt_0 configfs
 */
#define SYNO_LIO_CONFIGFS_WORKAROUND

/*
 * Dsc: Fixed for DSM#15910
 *      Workaround for initiator relogin infinitly when target disabled by user.
 */
#define SYNO_LIO_INITIATOR_RELOGIN_WORKAROUND

/**
 * Dsc: Fixed for DSM#14531
 *      Incorrect length if null character exists. 
 */
#define SYNO_LIO_CHAP_CHALLENGE_LENGTH

/**
 * Dsc: Fixed for DSM#16468
 *      MacOSX login will login fail when send capital target-iqn. LIO is NONE case-sensitive.
 */
#define SYNO_LIO_INITIATOR_LOGIN_NONE_CASE_SENSITIVE

/**
 * Dsc: 
 *      Try to reduce the message of lio.
 */
#define SYNO_LIO_REDUCE_MESSAGE

/**
 * Dsc: Due to LIO crashes when max_sectors is 255.
 * Patches:
 *		[PATCH 0/3] tcm: Improvements for struct se_mem <-> SGL mapping logic
 *		[PATCH 1/3] tcm: Remove task_offset parameter from transport_map_sg_to_mem()
 *		[PATCH 2/3] tcm: Make transport_calc_sg_num() properly handle task_offset
 *		[PATCH 3/3] tcm: Make transport_map_mem_to_sg() properly handle task_offset
 */
#define SYNO_LIO_MEM_SGL_MAPPING_PATCH

/**
 * Dsc: Support for active I/O shutdown
 *      [PATCH] tcm: Add T_TASK(cmd)->transport_dev_active usage for active I/O shutdown
 *      [PATCH] tcm: Active I/O shutdown support for transport_generic_wait_for_tasks()
 *      [PATCH] tcm: Active I/O shutdown support for transport_lun_wait_for_tasks()
 *      [PATCH] tcm: Active I/O shutdown support for transport_clear_lun_from_sessions()
 */
#define SYNO_LIO_ACTIVE_IO_SHUTDOWN_PATCH

/**
 * Dsc: This patch also includes a number of misc cleanups in target_core_transport.c for the removal
 *      of se_obj_lun_type_t. SYNO_LIO_ACTIVE_IO_SHUTDOWN_PATCH must be applied before it
 *
 *      [PATCH] tcm: Remove legacy se_obj_lun_type_t API interface
 */
#ifdef SYNO_LIO_ACTIVE_IO_SHUTDOWN_PATCH
#define SYNO_LIO_REMOVE_OBJLUN_PATCH
#endif

/* Dsc: SYNO_LIO_REMOVE_OBJLUN_PATCH must be applied before it
 *
 *      [PATCH] tcm: Convert SE_DIRECTION_* to use enum dma_data_direction
 *      [PATCH] lio-target: Convert ISCSI_* data_direction macros to enum dma_data_direction
 */
#ifdef SYNO_LIO_REMOVE_OBJLUN_PATCH
#define SYNO_LIO_DMA_DIRECTION_PATCH
#endif

/**
 * Dsc: Numerous patches to reduce overhead of transport layer
 *      SYNO_LIO_DMA_DIRECTION_PATCH must be applied before it.
 *
 *      [PATCH] tcm: Add support for fabric module provided struct se_cmd descriptors
 *      [PATCH] lio-target: Convert to use pre-allocated struct se_cmd descriptors
 *      [PATCH] target: remove never changing indirections in se_cmd
 *      [PATCH] target: remove transport_generic_map_buffers_to_tasks
 */
#ifdef SYNO_LIO_DMA_DIRECTION_PATCH 
/* #define SYNO_LIO_TRANSPORT_PATCHES */
#endif

/*
 * Dsc: [PATCH] tcm: Fix incorrect SCF_CMD_PASSTHROUGH check in transport_send_task_abort()
 */
#define SYNO_LIO_SCF_CMD_PASSTHROUGH_PATCH

/**
 * Dsc: This patch adds two task management request/response exception handling conditions for
 *      LUN_RESET with active ABORT_TASK TMRs and TCM I_T nexus reset.
 *
 *      [PATCH] tcm: Add TMR exception handling bugfixes
 */
#define SYNO_LIO_TMR_EXCEPTION_PATCH

/**
 * Dsc: This patch fixes a bug in iscsi_release_commands_from_conn() where outstanding
 *      iSCSI TMRs where not being forced to shutdown via cmd->transport_wait_for_tasks()
 *      as expected.
 *
 *      [PATCH] lio-target: Handle active TMRs in iscsi_release_commands_from_conn()
 */
#define SYNO_LIO_ACTIVE_TMR_PATCH

/**
 * Dsc: add MaxSessions to target portal group
 */
#define SYNO_LIO_MAX_SESSIONS

/*
 * Dsc: Fixed for DSM#16219
 *      return 0x0201 Initiator NOT Auth while single/mutual chap fail.
 */
#define SYNO_LIO_CHAP_FAILED

/*
 * Dsc: Fixed for DSM#16769
 *      printable ipv6 ip address display
 */
#define SYNO_LIO_PRINTABLE_IPV6

/*
 * Dsc: Fixed for DSM#16315 DSM#16320
 *      change the NOPIN time to avoid the connection lost problem.
 */
#define SYNO_LIO_NOPIN_TIMEOUT

/*
 * Dsc: Fixed for DSM#16315 DSM#16320
 *      change the NOPIN time to avoid the connection lost problem.
 */
#define SYNO_LIO_NOPIN_RESPONSE_TIMEOUT

/**
 * Dsc: Fixed for DSM#18693
 *      Compatible with GlobalSAN 4.1 beta (build 246). Set SessionType = Normal as default
 */
#define SYNO_LIO_DEFAULT_SESSITON_TYPE

/**
 * Dsc: Fixed for DSM#18107
 *      lio_rq_cache is still being used when destorying it.
 */
#define SYNO_LIO_REQUEST_QUEUE_DESTROY

/**
 * Dsc: Fixed for DSM#19742
 */
#define SYNO_LIO_VERIFY_16

#define SYNO_LIO_FORCE_LOGOUT

/**
 * Dsc: Force read-only when failed to write data
 */
#ifdef SYNO_LIO_FORCE_LOGOUT
#define SYNO_LIO_FORCE_READ_ONLY
#endif

/**
 * Dsc: Fix LUN_RESET issue during VMware iSCSI Certification
 */
#define SYNO_LIO_LUN_RESET

/**
 * Dsc: Use tha same legnth of MAX_RECV_DATA_SEGMENT of initiator(proposer)
 */
#define SYNO_LIO_MAX_RECV_DATA_SEGMENT_LENGTH

#endif

/******************************* Misc. ********************************************/
/**
 * Fix:
 * Dsc: Slow down hotplug event to prevent oom when plug a drive which has huge partitions
 */
#ifdef CONFIG_SYNO_MV88F6281_USBSTATION
#define SYNO_SLOW_DOWN_UEVENT
#endif
/**
 * Fix: DS20 bug #6585
 * Dsc: Slow reading when DS in Gigabit ethernet.
 *        - Reduce default reading block size from 65536 to
 *          8192.
 *
 */
#ifndef SYNO_TVIX_SLOW
#define SYNO_TVIX_SLOW
#endif

/**
 * Fix: DS 2.0 #5873
 * Dsc: limit handle_bad_sector print messages.
 * IN : block/blk-core.c
 */
#define SYNO_BLOCK_LIMIT_BAD_SECTOR_MSG

/*
 * Fix: DS2.0 #5828, LKP2.6.32 #149
 * Dsc: When MD encounters EIO errors, it will
 *      ask the SCSI layer if the device exists
 *      or not, to determine which error Handler
 *      will be used.
 * IN : sd.c, md.h, md.c, linear.c,
 *      raid0.c, raid5.c, raid1.c, raid10.c,
 *      fs/ext3/balloc.c, fs/ext3/dir.c,
 *      fs/ext4/balloc.c fs/ext4/dir.c
 */
#define SYNO_BLOCK_REQUEST_ERROR_NODEV

/**
 * Dsc: Make mmap work and fixed the mmap > 4G problem
 */
#ifdef SYNO_SYSTEM_CALL
#define SYNO_MMAP
#endif

/**
 * Dsc: Increase default readahead size of block device
 *      from 128KB to 512KB
 */
#define SYNO_INCREASE_READAHEAD

/**
 * Fix: #17260
 * Dsc: Never port this to other platforms
 */
#if defined(CONFIG_SYNO_X86) || defined(CONFIG_SYNO_X64)
#define SYNO_GET_TASK_CRED
#endif

/**
 * Fix: #16748
 * Dsc: CPU speed adjusting while hibernation
 */
#if defined(CONFIG_SYNO_MV88F6281) && !defined(CONFIG_SYNO_MV88F6281_USBSTATION)
#define SYNO_CPUFREQ_ADJUST
#endif

/******************************* MV BSP ********************************************/
/**
 * Fix: No Bug Entry
 * Dsc: Marvell's default BSP is used for 2.6.22, but we use 2.6.24.
 *      This define use to indentify what we porting.
 *      Because there had a little difference betwenn these two major version linux.
 * IN : mvLinuxIalHt.c, mvLinuxIalLib.c, mvLinuxIalSmart.c, thor/linux/linux_helper.c, thor/linux/linux_sense.c, ahci.c
 */
#define SYNO_MV_MODIFY

/**
 * Fix: No Bug Entry
 * Dsc: We use 2.6.32, modify Marvell's BSP related code (defaule is 2.6.22)
 *      This define use to indentify what we porting.
 *      Because there had a little difference betwenn these two major version linux.
 * IN : drivers/ata/mvSata_4_2_2/mvLinuxIalLib.c, drivers/ata/mvSata_4_2_2/mvLinuxIalHt.c,
 *      drivers/ata/mvSata_4_2_2/mvLinuxIalSmart.c
 */
#define SYNO_MV_MODIFY_32

/**
 * Fix: No Bug Entry
 * Dsc: Make mvSata driver accept CHECK_POWER ATA command
 *      (via Marvell SMART interface).
 * IN : mvStorageDev.h, mvLinuxIalSmart.c
 */
#define SYNO_MV_CHECK_HDD_POWER
/**
 * Fix: DS 2.0 #8357
 * Dsc: implement error handle for Marvell mvSata
 */
#define SYNO_SATA_MV_EH

#ifdef SYNO_SATA_MV_EH
#define MAX_CHANNEL_RETRY       2
#define CHANNEL_RETRY_INTERVAL  (3*HZ)

/**
 * Fix: DS 2.2 #10983
 * Dsc: let pmp device send cable event to user space
 */
#define SYNO_MV_PMP_UEVENT
#endif

/**
 * Fix : DS20 bug #5838, #8213
 *
 * Dsc : Some disk can't go through SRST status, so we reset it
 *      and give it one chance for detect disk eg. WD5001ABYS,
 *      Samsung HD103UJ, ST3500641AS
 *
 *      #8213: chip: Sunplus SataLink SPIF225A-HF021 (LC Power
 *      EH-35BE2 esata box)
 */
#define SYNO_SATA_DETECT_FIX

/**
 * Fix: No Bug entry
 * Dsc: In order to make LED static when disk present and blinking when
 *      disk active, we have to set the offset 0x104F0 bit 0-1
 *      to 0x00 and bit 2-3 to 1. See data sheet page 282 (Table
 *      232: GPIO port control register), this is for MV BSP driver
 *      SYNO_OSS_SATA_LED is for open source driver
 * IN : mvSata.c
 */
#define SYNO_MV_SATA_LED

/**
 * Fix DS2.0 #8115
 * Dsc: The port multiplier function of mvSata4.2.2 based driver
 *      is not good for 6281. They have some problem:
 *      1. Some devices can not be reconized by 6281.(Much like
 *         a chip bug)
 *         9410-HD-001
 *      2. Hotplug multiple devices in the same times is not
 *         well maintained.
 *      3. They could only recognize four disks at most.
 *
 * FIXME: I do not try this patch in 7042 with port multiplier.
 *        Because when i fix this problem, it is still not merge
 *        all the 7042 driver in the same package yet.
 */
#define SYNO_SATA_MV422_PM_FIX

/**
 * Fix: DS 2.0 #5942
 * Dsc: Let 2.6.24/15 kernel could use the sil-3726 PM , port
 *      from 2.6.15/drivers/scsi/mv7042/mvIALCommonUtils.c. I
 *      think it may be a version control miss in marvell.
 * IN : mvIALCommonUtils.c
 */
#define SYNO_SATA_MV_PM_WORK

/**
 * Fix: DS 2.0 #7123
 * Dsc: Fix Marvell driver's bug. enlarge the link fault
 *      tolerance
 * Test Disks Info:
 *
 *  Product of China
 *  Device Model:     ST31000340NS
 *  Serial Number:    5QJ0W2RJ
 *  Firmware Version: SN75 -> AN05
 *  P/N:              9CA158-333
 *  User Capacity:    1,000,204,886,016 bytes
 *  ATA Version is:   8
 *  ATA Standard is:  ATA-8-ACS revision 4
 *
 *  Product of Thailand
 *  Device Model:     ST31000340NS
 *  Serial Number:    9QJ1MGC4
 *  Firmware Version: SN05 -> AN05
 *  P/N:              9CA158-303
 *  User Capacity:    1,000,204,886,016 bytes
 *  ATA Version is:   8
 *  ATA Standard is:  ATA-8-ACS revision 4
 *
 *  Product of Thailand
 *  Device Model:     ST31000340NS
 *  Serial Number:    9QJ1J81V
 *  Firmware Version: SN05 -> AN05
 *  P/N:              9CA158-303
 *  User Capacity:    1,000,204,886,016 bytes
 *  ATA Version is:   8
 *  ATA Standard is:  ATA-8-ACS revision 4
 *
 *  Product of Thailand
 *  Device Model:     ST31000340NS
 *  Serial Number:    9QJ1ME10
 *  Firmware Version: SN05 -> AN05
 *  P/N:              9CA158-303
 *  User Capacity:    1,000,203,804,160 bytes
 *  ATA Version is:   8
 *  ATA Standard is:  ATA-8-ACS revision 4
 *
 * IN : mvSata.c
 */
#define SYNO_SATA_MVSATA_PHY_PARM_FIX

#include <linux/syno_user.h>

#include <linux/syno_debug.h>

/**
 * Fix:	DS 2.0 #14452
 * Dsc:	Enlarge max write size of NFS for Vmware to 
 *    write 65536 bytes at once.
 * IN :	fs/nfsd/nfssvc.c
 */
#define SYNO_NFSD_WRITE_SIZE_MIN 131072

/**
 * Fix: DSM #15373 
 * Dsc: VFS has two phase of freezing file system: 
 * SB_FREEZE_WRITE and SB_FREEZE_TRANS. In FREEZE_WRITE phase, 
 * only sync_filesystem could write data, all other operations 
 * should be blocked. In FREEZE_TRANS phase, all operations 
 * must be blocked. In EXT3 and EXT4, it use journal lock to 
 * block write operation. However, journal lock could not 
 * distinguish sync from other operations. Thus it blocks in 
 * FREEZE_TRANS phase only. This will cause leak in FREEZE_WRITE 
 * phase. Some inode operation such as touch will bypass freeze 
 * barrier, causing deadlock while fs freezed. 
 * This fix duplicates another journal starting function to be
 * used in sync functions, and make original functions block on 
 * FREEZE_WRITE phase. 
 */
#define SYNO_AVOID_FREEZE_DEADLOCK

/**
 * Fix: DSM #15373 
 * Dsc: While sync file system, ext4 delay allocation may 
 * redirty inode and leave it to next sync. It will cause 
 * problem in freezing fs when sync was called in freezing 
 * state. Thus we try to sync more times in freezing fs to make 
 * sure there is no dirty inodes.
 */
#define SYNO_EXT4_SYNC_DALLOC
#define SYNO_EXT4_SYNC_DALLOC_RETRY  100

/**
 * Fix: DSM #15373 
 * Dsc: With SYNO_AVOID_FREEZE_DEADLOCK patch, ext3 will block 
 * journal start in FREEZE_WRITE. But ext3_write_begin may be 
 * blocked while holding page lock, cause deadlock when it try 
 * to sync filesystem. Thus we reverse the order of locking page 
 * and starting journal.
 *
 * Fix: DSM #20959
 * Dsc: In some conditions, dirty inodes of file system that is different
 * from current used one could be flushed out to disk and journal could be started.
 * In such case, an assertion occurs because current task has different journal handle from
 * journal that dirty inodes are located at. Add an flag AOP_FLAG_NOFS to grab_cache_page_write_begin()
 * to indicate that file system operation is forbidden.
 */
#define SYNO_CHANGE_EXT3_PAGE_LOCK_ORDER

/**
 * Fix: DSM #16784 
 * Dsc: Freeze ext4 by checking SB_FREEZE_TRANS in 
 * ext4_journal_start_sb() may block thread which already hold 
 * running transaction updates. Induce deadlock when waiting for 
 * transaction locked. 
 */
#define SYNO_EXT4_AVOID_FREEZE_RACING_DEADLOCK

/**
 * Fix: DSM #16783 
 * Dsc: When complete pending exception, we need to wait reading 
 * bios which had been redirected to original block device. But 
 * the redirected bio may be blocked by splited bio (through 
 * recursive list of generic_make_request()), thus we should not 
 * hold snapshot lock and wait. Move waiting after updating 
 * exception table and before flush original bios. 
 */
#define SYNO_SNAPSHOT_AVOID_TRACK_DEADLOCK

/**
 * Fix: DSM #20959 
 * Dsc: Originally thaw_bdev() will hold a write lock of 
 * s_umount to proceed. But if any file system operation (such 
 * as quota control) already hold a read lock of s_umount and 
 * blocked by freezing fs (blocked by journal in ext3/ext4), 
 * deadlock will occur. Since thaw_bdev() didn't change any 
 * critical property, we change the lock from write to read. 
 */
#define SYNO_READ_LOCK_IN_THAW_BDEV

/**
 *Fix: DSM #16952
 *Dsc: Modifies the MPP setting. This is used to switch
 *     the HDD leds off on DS211+
 */
#define SYNO_MPPCTL_REG_W

/**
 * Fix: DSM #19665
 * Dsc: Add ECC notification support
 *		When ECC ram detect 1 bit error, it will correct this error automatically,
 *		but we still need a notification scheme let user know the error just occurred.
 */
#if defined(CONFIG_SYNO_X64) || defined(SYNO_X64)
#define SYNO_ECC_NOTIFICATION
#endif



/**
 * Fix: DSM #23148
 * Dsc: Make iSCSI device nodes to have prefix "ids"
 */
#ifdef SYNO_FIXED_DISK_NAME
#define SYNO_ISCSI_DEVICE
#define SYNO_ISCSI_DEVICE_PREFIX   "isd"
#define SYNO_ISCSI_DEVICE_INDEX    (26 + 25 * 26)    // start from za
#endif


/**
 * Fix: DSM #26625, TimeBackup #350
 * Dsc: Fix the dm sector_to_chunk, see linux kernel git commit 102c6ddb
 */
#define SYNO_DM_SECTOR_TO_CHUNK_FIX
#endif /* __SYNO_H_ */
