#!/usr/bin/perl
#
# This file is part of the IPCop Firewall.
#
# IPCop is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# IPCop is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with IPCop; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# (c) 2009, the IPCop team
#
# $Id: updatekernel.pl 3386 2009-08-01 18:26:47Z owes $
#

use strict;
# require '/usr/lib/ipcop/general-functions.pl';

my $kernelversion = $ARGV[1];

if ($ARGV[0] eq '--remove') {
    # Remove an old kernel

    die "Kernelversion missing" if ($kernelversion eq '');
    die "Kernel $kernelversion not found" if (! -e "/lib/modules/$kernelversion" );

    system("/usr/bin/logger -t ipcop Remove kernel $kernelversion");

    # TODO: really remove

    # TODO: remove labels from extlinux / yaboot /silo
}
elsif ($ARGV[0] eq '--add') {
    # This is where we 'add' a new kernel

    # TODO: tweak extlinux / yaboot / silo
}
else {
    die "Incorrect or missing option";
}
