#!/usr/bin/perl
#
# SmoothWall CGIs
#
# This code is distributed under the terms of the GPL
#
# (c) The SmoothWall Team
#
# $Id: graphs.cgi 3122 2009-06-25 10:55:55Z owes $
#

# Add entries in menu
# MENUENTRY status 040 "system graphs" "system graphs"
# MENUENTRY status 050 "sstraffic graphs" "network traffic graphs" "?graph=network"
#
# Make sure translation exists $Lang::tr{'sstraffic graphs'}

use strict;

# enable only the following on debugging purpose
#use warnings;
#use CGI::Carp 'fatalsToBrowser';

require '/usr/lib/ipcop/general-functions.pl';
require '/usr/lib/ipcop/lang.pl';
require '/usr/lib/ipcop/header.pl';

my %cgiparams=();
my %pppsettings=();
my %netsettings=();
my @cgigraphs=();
my @graphs=();
my $iface='';

&Header::showhttpheaders();

my $graphdir = '/home/httpd/html/graphs';
&General::readhash('/var/ipcop/ethernet/settings', \%netsettings);

$ENV{'QUERY_STRING'} =~ s/&//g;
@cgigraphs = split(/graph=/,$ENV{'QUERY_STRING'});
$cgigraphs[1] = '' unless defined $cgigraphs[1];

if ($cgigraphs[1] =~ /(network|GREEN|BLUE|ORANGE|RED)/) {
    &Header::openpage($Lang::tr{'network traffic graphs'}, 1, '');
}
else {
    &Header::openpage($Lang::tr{'system graphs'}, 1, '');
}
&Header::openbigbox('100%', 'left');

if ($cgigraphs[1] =~ /(GREEN|BLUE|ORANGE|RED|cpu|memory|diskuse|disk)/) {
    my $graph = $cgigraphs[1];
    my $graphname = ucfirst(lc($cgigraphs[1]));
    my ($title, $count) = split('_', $graphname);
    $title = $title." ".$count if ( $count >= 2 );
    my $back = '';
    if ($cgigraphs[1] =~ /(GREEN|BLUE|ORANGE|RED)/) {
        $back = "<a href='/cgi-bin/graphs.cgi?graph=network'>";
    } 
    else {
        $back = "<a href='/cgi-bin/graphs.cgi'>";
    }

    &Header::openbox('100%', 'center', "$title $Lang::tr{'graph'}");

    if (-e "$graphdir/${graph}-day.png") {
        print <<END
<table width='100%'><tr>
    <td width='10%'>$back<img src='/images/back.png' alt='$Lang::tr{'back'}' title='$Lang::tr{'back'}' /></a></td>
    <td>&nbsp;</td>
</tr></table>
<hr />
<img src='/graphs/${graph}-day.png' border='0' alt='${graph}-$Lang::tr{'day'}' /><hr />
<img src='/graphs/${graph}-week.png' border='0' alt='${graph}-$Lang::tr{'week'}' /><hr />
<img src='/graphs/${graph}-month.png' border='0' alt='${graph}-$Lang::tr{'month'}' /><hr />
<img src='/graphs/${graph}-year.png' border='0' alt='${graph}-$Lang::tr{'year'}' />
END
        ;
    } 
    else {
        print $Lang::tr{'no information available'};
    }

    print "<hr /><div align='left'>$back<img src='/images/back.png' alt='$Lang::tr{'back'}' title='$Lang::tr{'back'}' /></a></div>\n";

    &Header::closebox();
}
elsif ($cgigraphs[1] =~ /network/) {
    for my $color ('GREEN', 'ORANGE', 'BLUE') {
        my $icount = $netsettings{"${color}_COUNT"};
        while($icount > 0) {
            push (@graphs, ("${color}_${icount}"));
            $icount--;
        }
    }
    push (@graphs, ("RED_1"));

    foreach my $graphname (@graphs) {
        my ($title, $count) = split('_', $graphname);
        $title = ucfirst(lc($title));
        $title = $title." ".$count if ( $count >= 2 );
        &Header::openbox('100%', 'center', "$title $Lang::tr{'graph'}");

        if (-e "$graphdir/${graphname}-day.png") {
            print "<a href='/cgi-bin/graphs.cgi?graph=$graphname'>";
            print "<img src='/graphs/${graphname}-day.png' alt='${graphname}-$Lang::tr{'day'}' border='0' />";
            print "</a><br />";
        } 
        else {
            print $Lang::tr{'no information available'};
        }
        if ( $graphname eq 'GREEN_1' ) {
            print<<END
<table width='100%'>
<tr>
    <td class='comment1button'>&nbsp;</td>
    <td class='button1button'>&nbsp;</td>
    <td class='onlinehelp'>
        <a href='${General::adminmanualurl}/status-traffic-graphs.html' target='_blank'><img src='/images/web-support.png' alt='$Lang::tr{'online help en'}' title='$Lang::tr{'online help en'}' /></a>
    </td>
</tr>
</table>
END
            ;
        }
        &Header::closebox();
    }
}
else {
    &disp_graph("CPU $Lang::tr{'graph'}", "cpu", "cpu-$Lang::tr{'day'}");
    &disp_graph("Memory $Lang::tr{'graph'}", "memory", "$Lang::tr{'memory'}:-$Lang::tr{'day'}");
    &disp_graph("Diskuse $Lang::tr{'graph'}", "diskuse", "$Lang::tr{'disk usage'}:-$Lang::tr{'day'}");
    &disp_graph("Disk $Lang::tr{'graph'}", "disk", "disk-$Lang::tr{'day'}");
}

&Header::closebigbox();
&Header::closepage();


sub disp_graph
{
    my $title = shift;
    my $file  = shift;
    my $alt   = shift;

    &Header::openbox('100%', 'center', $title);
    if (-e "$graphdir/$file-day.png") {
        print "<a href='/cgi-bin/graphs.cgi?graph=$file'>";
        print "<img src='/graphs/$file-day.png' alt='$alt' border='0' />";
        print "</a><br />";
    } else {
        print $Lang::tr{'no information available'};
    }

    if ( $file eq 'cpu' ) {
        print<<END
<table width='100%'>
<tr>
    <td class='comment1button'>&nbsp;</td>
    <td class='button1button'>&nbsp;</td>
    <td class='onlinehelp'>
        <a href='${General::adminmanualurl}/status-graphs.html' target='_blank'><img src='/images/web-support.png' alt='$Lang::tr{'online help en'}' title='$Lang::tr{'online help en'}' /></a>
    </td>
</tr>
</table>
END
        ;
    }
    &Header::closebox();
}
