#!/usr/bin/perl
#
############################################################################
#                                                                          #
# This file is part of the IPCop Firewall.                                 #
#                                                                          #
# IPCop is free software; you can redistribute it and/or modify            #
# it under the terms of the GNU General Public License as published by     #
# the Free Software Foundation; either version 2 of the License, or        #
# (at your option) any later version.                                      #
#                                                                          #
# IPCop is distributed in the hope that it will be useful,                 #
# but WITHOUT ANY WARRANTY; without even the implied warranty of           #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            #
# GNU General Public License for more details.                             #
#                                                                          #
# You should have received a copy of the GNU General Public License        #
# along with IPCop; if not, write to the Free Software                     #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA #
#                                                                          #
# Copyright (C) 2004-03-12 Mark Wormgoor <mark@wormgoor.com>               #
#                                                                          #
############################################################################
#
# $Id: check_strings.pl 402 2007-06-11 20:19:11Z gespinasse $
#

my (%tr2, $basedir);

use Cwd;
use File::Find;

$basedir = cwd();

sub wanted
{
	if ( -f "$basedir/$File::Find::name" && open(FILE, "$basedir/$File::Find::name")) {
		#print "$File::Find::name\n";
		while (<FILE>) {
			# for each match in a line
			# match both $Lang::tr and $tr
			while ( $_ =~ /tr{'([\(\)A-Za-z0-9,:_\s\/\.-]+)'}/g ) {
				$tr2{$1} = 'empty string';
			}
		}
		close(FILE);
	}
}

## Main
( my $prog = $0 ) =~ s!^.*/!!; #prog name without path
if ( !-d "langs" ) {
	die "Script should be started from IPCop Source base directory like:\n./tools/$prog\n";
}

# path where we look for
my @array=("src/scripts", "html", "config/cfgroot", "config/rc.d");
print "Search strings on @array\n";

# pass an array of directories where we look
find (\&wanted , @array );

# use eval to avoid an error if not the right path
eval { require "${basedir}/langs/en/cgi-bin/en.pl"; };

print "\nThose translation strings appear unused\n (or may include a variable part like ls_)\n";
my $st="                                       "; # to fill the line
for my $key ( sort (keys %tr) ) {
	my $value = $tr{$key};
	if (! $tr2{$key}) {
		# align first part at 30 lenght and print translation
		print substr("$key $st", 0, 30)."  ".substr("$value", 0, 45)."\n";
	}
}

print "\n\nUntranslated string\n(XY_ from base.cgi example are normal)\n";
for my $key ( sort(keys %tr2) ) {
	my $value = $tr2{$key};
	if (! $tr{$key}) {
		print "$key\n";
	}
}
