/*
 * setaliases - configure red aliased interfaces
 *
 * This program is distributed under the terms of the GNU General Public
 * Licence.  See the file COPYING for details.
 *
 * (c) Steve Bootes, 2002/04/15
 *
 * 21/04/03 Robert Kerr Changed to link directly to libsmooth rather than
 *                      using a copy & paste
 *
 * $Id: setaliases.c 1773 2008-09-01 17:35:29Z owes $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "common.h"
#include "setuid.h"

FILE *file = NULL;

void exithandler(void)
{
    if (file)
        fclose(file);
}

int main(void)
{
    char s[STRING_SIZE];
    char command[STRING_SIZE];
    char *aliasip;
    char *enabled;
    char *sptr;
    char *comment;
    int alias;
    int count;

    if (!(initsetuid())) {
        fprintf(stderr, "Cannot run setuid\n");
        exit(1);
    }

    atexit(exithandler);


    /* Fetch ethernet/settings, exit on error */
    read_ethernet_settings(1);


    /* Check for RED_COUNT=1 (or higher) i.e. RED ethernet present. If not,
     * exit gracefully.  This is not an error... */
    if (ipcop_ethernet.count[RED] == 0)
        exit(0);

    /* Now check the RED_TYPE - aliases only work with STATIC.
     * At least, that's what /etc/rc.d/rc.netaddress.up thinks.. */
    if (strcmp(ipcop_ethernet.red_type[1], "STATIC"))
        exit(0);


    /* down the aliases in turn until ifconfig complains */
    alias = 0;
    do {
        memset(command, 0, STRING_SIZE);
        snprintf(command, STRING_SIZE - 1, "/sbin/ifconfig %s:%d down 2>/dev/null", ipcop_ethernet.device[RED][1],
                 alias++);
    } while (safe_system(command) == 0);

    /* Now set up the new aliases from the config file */
    if (!(file = fopen("/var/ipcop/ethernet/aliases", "r"))) {
        fprintf(stderr, "Unable to open aliases configuration file\n");
        exit(1);
    }

    alias = 0;
    int linecounter = 0;
    while (fgets(s, STRING_SIZE, file) != NULL) {
        linecounter++;
        if (s[strlen(s) - 1] == '\n')
            s[strlen(s) - 1] = '\0';
        count = 0;
        aliasip = NULL;
        enabled = NULL;
        comment = NULL;
        sptr = strtok(s, ",");
        while (sptr) {
            if (count == 0)
                aliasip = sptr;
            if (count == 1)
                enabled = sptr;
            else
                comment = sptr;
            count++;
            sptr = strtok(NULL, ",");
        }

        if (!(aliasip && enabled)) {
            fprintf(stderr, "Incomplete data line: in %s(%d)\n", "/var/ipcop/ethernet/aliases", linecounter);
            exit(1);
        }
        if (!strcmp(enabled, "on") == 0)        /* disabled rule? */
            continue;

        if (!VALID_IP(aliasip)) {
            fprintf(stderr, "Bad alias : %s in %s(%d)\n", aliasip, "/var/ipcop/ethernet/aliases", linecounter);
            exit(1);
        }

        memset(command, 0, STRING_SIZE);
        snprintf(command, STRING_SIZE - 1,
                 "/sbin/ifconfig %s:%d %s netmask %s broadcast %s up",
                 ipcop_ethernet.device[RED][1], alias, aliasip, ipcop_ethernet.netmask[RED][1],
                 ipcop_ethernet.broadcast[RED][1]);
        safe_system(command);
        memset(command, 0, STRING_SIZE);
        snprintf(command, STRING_SIZE - 1,
                 "/usr/sbin/arping -q -c 1 -w 1 -i %s -S %s %s",
                 ipcop_ethernet.device[RED][1], aliasip, ipcop_ethernet.default_gateway);
        safe_system(command);
        alias++;
    }
    return 0;
}
