#!/usr/bin/perl
#
# SmoothWall CGIs
#
# This code is distributed under the terms of the GPL
#
# (c) The SmoothWall Team
#
# $Id: updates.cgi 3122 2009-06-25 10:55:55Z owes $
#

# Add entry in menu
# MENUENTRY system 030 "updates" "updates"

use LWP::UserAgent;
use File::Copy;
use strict;

# enable only the following on debugging purpose
#use warnings; no warnings 'once';# 'redefine', 'uninitialized';
#use CGI::Carp 'fatalsToBrowser';

require '/usr/lib/ipcop/general-functions.pl';
require '/usr/lib/ipcop/lang.pl';
require '/usr/lib/ipcop/header.pl';
use POSIX qw(uname);

my $errormessage  = '';
my @av            = ('');    #list of available patch
my @pf            = ('');    #list of installed patch
my @pending       = ('');    # information from just uploaded patch
my @signature     = ('');    # signature from just uploaded patch
my $showfreespace = 0;

sub get_error() {
    my $exit_code = shift || return '';

    if ($exit_code == 0) {
        return '';
    }
    elsif ($exit_code == 2) {
        return "$Lang::tr{'could not create directory'}";
    }
    elsif ($exit_code == 3) {
        return "$Lang::tr{'this is not an authorised update'}";
    }
    elsif ($exit_code == 4) {
        return "$Lang::tr{'this is not a valid archive'}";
    }
    elsif ($exit_code == 5) {
        return "$Lang::tr{'could not open update information file'}";
    }
    elsif ($exit_code == 6) {
        return "$Lang::tr{'could not open installed updates file'}";
    }
    elsif ($exit_code == 7) {
        return "$Lang::tr{'this update is already installed'}";
    }
    elsif ($exit_code == 11) {
        return "$Lang::tr{'not enough disk space'}";
    }
    else {
        return "$Lang::tr{'package failed to install'}";
    }
}

&Header::showhttpheaders();

my %uploadsettings = ();
$uploadsettings{'ACTION'} = '';
&General::getcgihash(\%uploadsettings, {'wantfile' => 1, 'filevar' => 'FH'});

if ($uploadsettings{'ACTION'} eq $Lang::tr{'upload'}) {
    if (copy($uploadsettings{'FH'}, '/var/patches/patch.tgz.gpg') != 1) {
        $errormessage = $!;
    }
    else {
        $errormessage = &get_error(system('/usr/local/bin/installpackage --read >/dev/null') >> 8);
    }
}
elsif ($uploadsettings{'ACTION'} eq $Lang::tr{'download'}) {

    # we do not use URL include in information for 2 reasons
    #- does not support different arch
    #- available list is not refreshed after update, so position of next update vary in the array
    # URL will remain for compatibility (at least on 1.4)
    my @tmp = split(/[.]/, $General::version);
    ++$tmp[2];
    my $arch = (POSIX::uname())[4];
    if   ($arch =~ /^alpha/) { $arch = 'alpha'; }
    else                     { $arch = 'i486'; }
    my $URL = "http://prdownloads.sourceforge.net/ipcop/ipcop-$tmp[0].$tmp[1].$tmp[2]-update.$arch.tgz.gpg?download";
    my $databuf = &General::download($URL);

    if ($databuf && $databuf->is_success) {

        # write the datastream to a file
        open(FILE, '>/var/patches/patch.tgz.gpg');
        binmode(FILE);
        syswrite(FILE, $databuf->content);
        close(FILE);
        $errormessage = &get_error(system('/usr/local/bin/installpackage --read >/dev/null') >> 8);
    }
    else {
        unless (-e "${General::swroot}/red/active") {
            $errormessage = $Lang::tr{'connection is down'};
        }
        else {
            $errormessage = "$! $URL";
        }
    }
}
elsif ($uploadsettings{'ACTION'} eq $Lang::tr{'apply'}) {
    my $errormessage = &get_error(system('/usr/local/bin/installpackage --install >/dev/null') >> 8);
    if ($errormessage eq '') {

        #Hack to get correct version displayed after update
        open(XX, "/usr/bin/perl -e \"require'/usr/lib/ipcop/general-functions.pl';print \\\$General::version\"|");
        $General::version = <XX>;
        close(XX);
    }
}
elsif ($uploadsettings{'ACTION'} eq $Lang::tr{'delete'}) {
    my $errormessage = &get_error(system('/usr/local/bin/installpackage --delete >/dev/null') >> 8);
}
elsif ($uploadsettings{'ACTION'} eq $Lang::tr{'refresh update list'}) {
    my $return = &General::download();
    if ($return && $return->is_success) {
        if (open(LIST, ">${General::swroot}/patches/available")) {
            flock LIST, 2;
            my @this = split(/----START LIST----\n/, $return->content);
            print LIST $this[1];
            close(LIST);
            &General::log($Lang::tr{'successfully refreshed updates list'});
        }
        else {
            $errormessage = $Lang::tr{'could not open available updates file'};
        }
    }
    else {
        unless (-e "${General::swroot}/red/active") {
            $errormessage = $Lang::tr{'connection is down'};
        }
        else {
            $errormessage = $Lang::tr{'could not download the available updates list'};
        }
    }
}
elsif ($uploadsettings{'ACTION'} eq "$Lang::tr{'clear cache'} (squid)") {
    system('/usr/local/bin/restartsquid', '-f');
}

# Read-in the list files installed/ready to install
if (!open(AV, "<${General::swroot}/patches/available")) {
    $errormessage = $Lang::tr{'could not open available updates file'};
}
else {
    @av = <AV>;
    close(AV);
}
if (!open(PF, "<${General::swroot}/patches/installed")) {
    $errormessage = $Lang::tr{'could not open installed updates file'};
}
else {
    @pf = <PF>;
    close(PF);

    #substract installed patch from list displayed
    # 'available' file has not changed on update installation
    foreach my $P (@pf) {
        $P =~ /^(...)/;
        my $order = $1;
        my $idx   = 0;
        foreach my $A (@av) {
            $A =~ /^(...)/;
            if ($1 eq $order) {    # match
                splice(@av, $idx, 1);
                last;
            }
            $idx++;
        }
    }
}
if (open(PENDING, '</var/patches/information')) {
    @pending = <PENDING>;
    close(PENDING);
}
if (open(SIGNATURE, '</var/patches/signature')) {
    @signature = <SIGNATURE>;
    close(PENDING);
}
&Header::openpage($Lang::tr{'updates'}, 1, '');
&Header::openbigbox('100%', 'left', '');

if ($errormessage) {
    &Header::openbox('100%', 'left', "$Lang::tr{'error messages'}:", 'error');
    print $errormessage;
    print "&nbsp;";
    &Header::closebox();
}

my $age = &General::age("${General::swroot}/patches/available");
if ($age =~ m/(\d{1,3})d/) {
    if ($1 >= 7) {
        &Header::openbox('100%', 'left', $Lang::tr{'warning messages'}, 'warning');
        print "$Lang::tr{'updates is old1'} $1 $Lang::tr{'updates is old3'}";
        &Header::closebox();
    }
}

&Header::openbox('100%', 'left', "$Lang::tr{'available updates'}:");
print "<form method='post' action='/cgi-bin/updates.cgi' enctype='multipart/form-data'>";
if (defined $av[0]) {
    $showfreespace = 1;
    print <<END
<table width='100%' border='0'><tr>
    <td><b>$Lang::tr{'there are updates available'}</b></td>
<td width='20%'><input type='submit' name='ACTION' value='$Lang::tr{'refresh update list'}' /></td>
</tr></table>
<br /><br />
    <table width='100%' border='0' cellpadding='2' cellspacing='0'>
    <tr>
    <td width='5%'><b>$Lang::tr{'id'}</b></td>
    <td width='10%'><b>$Lang::tr{'title'}</b></td>
    <td><b>$Lang::tr{'description'}</b></td>
    <td width='10%'><b>$Lang::tr{'released'}</b></td>
    <td width='20%'><b>$Lang::tr{'download'}</b></td>
    </tr>
END
        ;
    my $number = 0;    # display download button only on first update
    foreach (@av) {
        my @temp = split(/\|/, $_);
        $number++;

        #field4 is an URL, make a link.
        $temp[4] =~ /^http.*\/(.*)\?/;    # get filename
        chomp($temp[4]);
        $temp[4] = "<a href='$temp[4]' target='_blank'>$1</a>";
        if ($number == 1) {
            $temp[4] .= "<br /><br /><input type='submit' name='ACTION' value='$Lang::tr{'download'}' />";
        }
        print "<tr><td valign='top'>" . join("</td><td valign='top'>", @temp) . "</td></tr>";
    }
    print '</table>';
}
else {
    print <<END
<table width='100%' border='0'><tr>
    <td>$Lang::tr{'all updates installed'}</td>
    <td width='20%'><input type='submit' name='ACTION' value='$Lang::tr{'refresh update list'}' /></td>
</tr></table>
END
        ;
}

print <<END
<hr />
<br />$Lang::tr{'to install an update'}:<br />
<table>
  <tr>
    <td align='right' class='base'><b>$Lang::tr{'upload update file'}:</b></td>
    <td><input type="file" size='40' name="FH" /><input type='submit' name='ACTION' value='$Lang::tr{'upload'}' /></td>
    </tr>
</table>

END
    ;

# check files exist and are uid root (stat(file))[4]=0 except .gpg file wich protected by signature
if (   -e '/var/patches/information'
    && -e '/var/patches/patch.tgz.gpg'
    && -e '/var/patches/signature'
    && (stat('/var/patches/information'))[4] + (stat('/var/patches/signature'))[4] == 0)
{
    $showfreespace = 1;
    $pending[0] =~ s/\|/<\/td><td valign='top'>/g;
    $signature[0] = &Header::cleanhtml($signature[0]);
    $signature[1] = &Header::cleanhtml($signature[1]);
    print <<END
<br /><table width='100%' border='0'>
<tr>
    <td width='5%'><b>$Lang::tr{'id'}</b></td>
    <td width='10%'><b>$Lang::tr{'title'}</b></td>
    <td><b>$Lang::tr{'description'}</b></td>
    <td width='10%'><b>$Lang::tr{'released'}</b></td>
    <td width='20%'>&nbsp;</td>
</tr><tr>
    <td valign='top'>$pending[0]</td><td valign='top'>
        <input type='submit' name='ACTION' value='$Lang::tr{'apply'}' /><br /><br />
        <input type='submit' name='ACTION' value='$Lang::tr{'delete'}' /></td>
</tr><tr>
    <td colspan='2'></td>
    <td><hr /></td>
</tr><tr>
    <td colspan='2'>&nbsp;</td>
    <td colspan='2'>$signature[0]<br />$signature[1]</td>
</tr>
</table>
END
        ;
}

if ($showfreespace) {

    # To show free space on hard disk
    open(XX, '/bin/df -B M -x rootfs -x tmpfs|');
    my @df = <XX>;
    close(XX);

    # skip first line:
    # Filesystem            Size  Used Avail Use% Mounted on
    shift(@df);
    chomp(@df);

    # discount possible patch.tgz.gpg size, (stat())[7] is size
    my $patchsize = 0;
    $patchsize = (stat('/var/patches/patch.tgz.gpg'))[7] / 1024 / 1024 if (-e '/var/patches/patch.tgz.gpg');

    # merge all lines to one single line separated by spaces
    my $all_inOneLine = join(' ', @df);

    # now get all entries in an array
    my @all_entries = split(' ', $all_inOneLine);

    # alert on rootfs available < 32MB, on /var/log 1MB
    my @alert = (32 - $patchsize, 1);
    print <<END
    <hr />
    <table width='100%' border='0'><tr><td width='15%'>&nbsp;</td><td>
        <table border='0'>
            <tr><td colspan='7'><b>$Lang::tr{'disk usage'}:</b></td></tr>
            <tr>
                <td align='left' class='boldbase'><b>$Lang::tr{'device'}</b></td>
                <td align='left' class='boldbase'><b>$Lang::tr{'mounted on'}</b></td>
                <td align='center' class='boldbase'><b>$Lang::tr{'size'}</b></td>
                <td align='center' class='boldbase'><b>$Lang::tr{'used'}</b></td>
                <td align='center' class='boldbase'><b>$Lang::tr{'free'}</b></td>
                <td align='left' class='boldbase'><b>$Lang::tr{'percentage'}</b></td>
            </tr>
END
        ;

    my $count = 0;
    # loop over all entries. Six entries belong together.
    while (@all_entries > 0) {

        my $dev     = shift(@all_entries);
        my $size    = shift(@all_entries);
        my $used    = shift(@all_entries);
        my $free    = shift(@all_entries);
        my $percent = shift(@all_entries);
        my $mount   = shift(@all_entries);

        my $alertstyle = "";
        $alertstyle = "class='ipcop_error'" if ($free <= $alert[$count]);
        print <<END
    <tr $alertstyle>
        <td>$dev</td>
        <td>$mount</td>
        <td align='right'>$size</td>
        <td align='right'>$used</td>
        <td align='right'>$free</td>
        <td align='right'>$percent</td>
    </tr>
END
            ;

        $count++;
    }
    print "</table></td></tr></table>";
}

print <<END
<hr />
<table width='100%'>
<tr>
    <td class='comment1button'>&nbsp;</td>
    <td class='button1button'>&nbsp;</td>
    <td class='onlinehelp'>
    <a href='${General::adminmanualurl}/system-updates.html' target='_blank'>
    <img src='/images/web-support.png' alt='$Lang::tr{'online help en'}' title='$Lang::tr{'online help en'}' /></a></td>
</tr>
</table>
</form>
END
    ;
&Header::closebox();

&Header::openbox('100%', 'left', "$Lang::tr{'installed updates'}:");
print <<END
<table width='100%' border='0' cellpadding='2' cellspacing='0'>
    <tr>
    <td width='5%'><b>$Lang::tr{'id'}</b></td>
    <td width='10%'><b>$Lang::tr{'title'}</b></td>
    <td><b>$Lang::tr{'description'}</b></td>
    <td width='10%'><b>$Lang::tr{'released'}</b></td>
    <td width='10%'><b>$Lang::tr{'installed'}</b></td>
    </tr>
END
    ;

foreach my $pf (reverse(@pf)) {
    next if $pf =~ m/^#/;
    my @temp = split(/\|/, $pf);

    # if field4 is a date ok else replace the unknown string
    $temp[4] = '????' if ($temp[4] !~ /^\d/);
    print "<tr><td valign='top'>" . join("</td><td valign='top'>", @temp) . "</td></tr>";
}
print "</table>";

&Header::closebox();
&Header::closebigbox();
&Header::closepage();
