#!/usr/bin/perl
#
# SmoothWall CGIs
#
# This code is distributed under the terms of the GPL
#
# (c) The SmoothWall Team
#
# Copyright (C) 03-Apr-2002 Guy Ellis <guy@traverse.com.au>
#              - ISDN DOV support
#              - ibod now an option
#              - PCI ADSL support added
#
# $Id: pppsetup.cgi 3122 2009-06-25 10:55:55Z owes $
#

# Add entry in menu
# MENUENTRY network 010 "alt dialup" "dialup settings"
#
# Make sure translation exists $Lang::tr{'alt dialup'} $Lang::tr{'dialup settings'}

use strict;

# enable only the following on debugging purpose
#use warnings;
#use CGI::Carp 'fatalsToBrowser';

require '/usr/lib/ipcop/general-functions.pl';
require '/usr/lib/ipcop/lang.pl';
require '/usr/lib/ipcop/header.pl';

our %pppsettings = ();
my %temppppsettings = ();
our %isdnsettings  = ();
our %netsettings   = ();
my %selected     = ();
my %checked      = ();
my @profilenames = ();
my $errormessage = '';
my $warningmessage = '';
my $maxprofiles  = 5;
my $kernel       = `/bin/uname -r | /usr/bin/tr -d '\012'`;
our $drivererror = '';

# read in the profile names into @profilenames.
my $c = 0;
$profilenames[0] = $Lang::tr{'no profile switch'};
for ($c = 1; $c <= $maxprofiles; $c++) {
    %temppppsettings = ();
    $temppppsettings{'PROFILENAME'} = $Lang::tr{'empty'};
    &General::readhash("/var/ipcop/ppp/settings-$c", \%temppppsettings);
    $profilenames[$c] = $temppppsettings{'PROFILENAME'};
}
for ($c = 1; $c <= $maxprofiles; $c++) {
    $selected{'PROFILE'}{$c} = '';
}

&Header::showhttpheaders();

$pppsettings{'ACTION'} = '';
&initprofile();
&General::getcgihash(\%pppsettings);

if (($pppsettings{'ACTION'} eq '') && (-e '/var/run/ppp-ipcop.pid' || -e "/var/ipcop/red/active")) {
    $warningmessage = $Lang::tr{'unable to alter profiles while red is active'};

    &General::readhash('/var/ipcop/ppp/settings', \%pppsettings);
}
elsif ($pppsettings{'ACTION'} ne ''
    && (-e '/var/run/ppp-ipcop.pid' || -e "/var/ipcop/red/active"))
{
    $errormessage = $Lang::tr{'unable to alter profiles while red is active'};

    # read in the current vars (could be different from actual user input)
    %pppsettings = ();
    # If RED is DHCP/Static we can have a connection without some sensible defaults in ppp/settings.
    # This messes up the screen: no box termination.
    &initprofile();
    &General::readhash("/var/ipcop/ppp/settings", \%pppsettings);
}
elsif ($pppsettings{'ACTION'} eq $Lang::tr{'refresh'}) {
    unless ($pppsettings{'TYPE'} =~
/^(modem|serial|isdn|pppoe|pptp|alcatelusb|alcatelusbk|amedynusbadsl|conexantusbadsl|conexantpciadsl|3cp4218usbadsl|pulsardsl|eciadsl|fritzdsl|bewanadsl|eagleusbadsl|wanpipe-adsl|wanpipe-serial)$/
        )
    {
        $errormessage = $Lang::tr{'invalid input'};
        goto ERROR;
    }
    my $type = $pppsettings{'TYPE'};
    &General::readhash("/var/ipcop/ppp/settings", \%pppsettings);
    $pppsettings{'TYPE'} = $type;
}
elsif ($pppsettings{'ACTION'} eq $Lang::tr{'save'}) {
    if (   $pppsettings{'TYPE'} =~ /^(modem|serial|isdn)$/
        && $pppsettings{'COMPORT'} !~
/^(ttyS0|ttyS1|ttyS2|ttyS3|ttyS4|ttyUSB0|ttyUSB1|usb\/ttyACM0|usb\/ttyACM1|usb\/ttyACM2|usb\/ttyACM3|isdn1|isdn2)$/
        )
    {
        $errormessage = $Lang::tr{'invalid input'};
        goto ERROR;
    }
    if (   $pppsettings{'TYPE'} =~ /^(modem|serial)$/
        && $pppsettings{'DTERATE'} !~ /^(9600|19200|38400|57600|115200|230400|460800|921600)$/)
    {
        $errormessage = $Lang::tr{'invalid input'};
        goto ERROR;
    }
    if ($pppsettings{'TYPE'} eq 'modem' && $pppsettings{'DIALMODE'} !~ /^(T|P)$/) {
        $errormessage = $Lang::tr{'invalid input'};
        goto ERROR;
    }
    if ($pppsettings{'AUTH'} !~ /^(pap-or-chap|pap|chap|standard-login-script|demon-login-script|other-login-script)$/)
    {
        $errormessage = $Lang::tr{'invalid input'};
        goto ERROR;
    }

    if ($pppsettings{'TYPE'} =~ /^(wanpipe-serial)$/) {
        if ($pppsettings{'COMPORT'} !~ /^(ttyWP0|ttyWP1|ttyWP2|ttyWP3|ttyWP4|ttyWP5|ttyWP6|ttyWP7)$/) {
            $errormessage = $Lang::tr{'invalid input'};
            goto ERROR;
        }
    }

    if ($pppsettings{'PROFILENAME'} eq '') {
        $errormessage = $Lang::tr{'profile name not given'};
        $pppsettings{'PROFILENAME'} = '';
        goto ERROR;
    }
    if ($pppsettings{'TYPE'} =~ /^(modem|isdn)$/) {
        if ($pppsettings{'TELEPHONE'} eq '') {
            $errormessage = $Lang::tr{'telephone not set'};
            goto ERROR;
        }
        if (!($pppsettings{'TELEPHONE'} =~ /^[\d\*\#\,]+$/)) {
            $errormessage = $Lang::tr{'bad characters in the telephone number field'};
            goto ERROR;
        }
    }
    unless (($pppsettings{'PROTOCOL'} eq 'RFC1483' && $pppsettings{'METHOD'} =~ /^(STATIC|DHCP)$/)) {
        if ($pppsettings{'USERNAME'} eq '') {
            $errormessage = $Lang::tr{'username not set'};
            goto ERROR;
        }
        if ($pppsettings{'PASSWORD'} eq '') {
            $errormessage = $Lang::tr{'password not set'};
            goto ERROR;
        }
    }

    if ($pppsettings{'TIMEOUT'} eq '') {
        $errormessage = $Lang::tr{'idle timeout not set'};
        goto ERROR;
    }
    if (!($pppsettings{'TIMEOUT'} =~ /^\d+$/)) {
        $errormessage = $Lang::tr{'only digits allowed in the idle timeout'};
        goto ERROR;
    }

    if ($pppsettings{'LOGINSCRIPT'} =~ /[.\/ ]/) {
        $errormessage = $Lang::tr{'bad characters in script field'};
        goto ERROR;
    }

    if ($pppsettings{'DNS1'}) {
        if (!(&General::validip($pppsettings{'DNS1'}))) {
            $errormessage = $Lang::tr{'invalid primary dns'};
            goto ERROR;
        }
    }
    if ($pppsettings{'DNS2'}) {
        if (!(&General::validip($pppsettings{'DNS2'}))) {
            $errormessage = $Lang::tr{'invalid secondary dns'};
            goto ERROR;
        }
    }

    if ($pppsettings{'MAXRETRIES'} eq '') {
        $errormessage = $Lang::tr{'max retries not set'};
        goto ERROR;
    }
    if (!($pppsettings{'MAXRETRIES'} =~ /^\d+$/)) {
        $errormessage = $Lang::tr{'only digits allowed in max retries field'};
        goto ERROR;
    }

    if (!($pppsettings{'HOLDOFF'} =~ /^\d+$/)) {
        $errormessage = $Lang::tr{'only digits allowed in holdoff field'};
        goto ERROR;
    }

    if ($pppsettings{'TYPE'} =~ /^(alcatelusb|alcatelusbk)$/) {
        my $modem      = '';
        my $speedtouch = &Header::speedtouchversion;
        if ($speedtouch >= 0 && $speedtouch <= 4) {
            if   ($speedtouch == 4) { $modem = 'v4_b'; }
            else                    { $modem = 'v0123'; }
            $pppsettings{'MODEM'} = $modem;
        }
        else {
            $modem        = 'v0123';
            $errormessage = "$Lang::tr{'unknown'} Rev $speedtouch";
            goto ERROR;
        }
        if (!-e "/var/ipcop/alcatelusb/firmware.$modem.bin") {
            $errormessage = $Lang::tr{'no alcatelusb firmware'};
            $drivererror  = 1;
            goto ERROR;
        }
    }

    if ($pppsettings{'TYPE'} eq 'eciadsl' && (!(-e "/var/ipcop/eciadsl/synch.bin"))) {
        $errormessage = $Lang::tr{'no eciadsl synch.bin file'};
        $drivererror  = 1;
        goto ERROR;
    }

    if ($pppsettings{'TYPE'} eq 'fritzdsl' && (!(-e "/lib/modules/$kernel/misc/fcdslusb.o.gz"))) {
        $errormessage = $Lang::tr{'no fritzdsl driver'};
        $drivererror  = 1;
        goto ERROR;
    }

    if ($pppsettings{'USEIBOD'} eq 'on' && $pppsettings{'COMPORT'} eq 'isdn1') {
        $errormessage = $Lang::tr{'ibod for dual isdn only'};
        goto ERROR;
    }

    if ($pppsettings{'TYPE'} eq 'pptp') {
        $errormessage = '';
        if ($pppsettings{'METHOD'} eq 'STATIC') {
            if (!&General::validip($pppsettings{'ROUTERIP'})) {
                $errormessage = $Lang::tr{'router ip'} . ': ' . $Lang::tr{'invalid ip'};
            }
        }
        else {
            if (($pppsettings{'DHCP_HOSTNAME'} ne '') && (!&General::validfqdn($pppsettings{'DHCP_HOSTNAME'}))) {
                $errormessage = $errormessage . ' ' . $Lang::tr{'hostname'} . ' ' . $Lang::tr{'invalid hostname'};
            }
        }
        if ($errormessage ne '') {
            goto ERROR;
        }
    }

    if ($pppsettings{'TYPE'} =~
/^(alcatelusb|alcatelusbk|amedynusbadsl|conexantusbadsl|conexantpciadsl|3cp4218usbadsl|pulsardsl|eciadsl|fritzdsl|bewanadsl|eagleusbadsl|wanpipe-adsl)$/
        )
    {
        if (($pppsettings{'VPI'} eq '') || ($pppsettings{'VCI'} eq '')) {
            $errormessage = $Lang::tr{'invalid vpi vpci'};
            goto ERROR;
        }
        if ((!($pppsettings{'VPI'} =~ /^\d+$/)) || (!($pppsettings{'VCI'} =~ /^\d+$/))) {
            $errormessage = $Lang::tr{'invalid vpi vpci'};
            goto ERROR;
        }
        if (($pppsettings{'VPI'} eq '0') && ($pppsettings{'VCI'} eq '0')) {
            $errormessage = $Lang::tr{'invalid vpi vpci'};
            goto ERROR;
        }
        if ($pppsettings{'PROTOCOL'} eq '') {
            $errormessage = $Lang::tr{'invalid input'};
            goto ERROR;
        }
    }

    if (   ($pppsettings{'PROTOCOL'} eq 'RFC1483')
        && ($pppsettings{'METHOD'} eq '')
        && \($pppsettings{'TYPE'} !~ /^(alcatelusb|fritzdsl)$/))
    {
        $errormessage = $Lang::tr{'invalid input'};
        goto ERROR;
    }

    if (($pppsettings{'PROTOCOL'} eq 'RFC1483' && $pppsettings{'METHOD'} eq 'DHCP')) {
        if ($pppsettings{'DHCP_HOSTNAME'} ne '') {
            if (!&General::validfqdn($pppsettings{'DHCP_HOSTNAME'})) {
                $errormessage = $errormessage . ' ' . $Lang::tr{'hostname'} . ': ' . $Lang::tr{'invalid hostname'};
            }
        }
    }

    if (($pppsettings{'PROTOCOL'} eq 'RFC1483' && $pppsettings{'METHOD'} eq 'STATIC')) {
        $errormessage = '';
        if (!&General::validip($pppsettings{'IP'})) {
            $errormessage = $Lang::tr{'static ip'} . ' ' . $Lang::tr{'invalid ip'};
        }
        if (!&General::validip($pppsettings{'GATEWAY'})) {
            $errormessage = $errormessage . ' ' . $Lang::tr{'gateway ip'} . ' ' . $Lang::tr{'invalid ip'};
        }
        if (!&General::validmask($pppsettings{'NETMASK'})) {
            $errormessage = $errormessage . ' ' . $Lang::tr{'netmask'} . ' ' . $Lang::tr{'invalid netmask'};
        }
        if ($pppsettings{'BROADCAST'} ne '') {
            if (!&General::validip($pppsettings{'BROADCAST'})) {
                $errormessage = $errormessage . ' ' . $Lang::tr{'broadcast'} . ' ' . $Lang::tr{'invalid broadcast ip'};
            }
        }
        if ($pppsettings{'DNS'} eq 'Automatic') {
            $errormessage = $Lang::tr{'invalid input'};
        }
        if ($errormessage ne '') {
            goto ERROR;
        }
    }

    if (   $pppsettings{'PROTOCOL'} eq 'RFC1483'
        && $pppsettings{'METHOD'} ne 'PPPOE'
        && \$pppsettings{'RECONNECTION'} eq 'dialondemand')
    {
        $errormessage = $Lang::tr{'invalid input'};
        goto ERROR;
    }

    if ($pppsettings{'RECONNECTION'} eq 'dialondemand' && `/bin/cat /var/ipcop/ddns/config` =~ /,on$/m) {
        $errormessage = $Lang::tr{'dod not compatible with ddns'};
        goto ERROR;
    }

    if (($pppsettings{'TYPE'} =~ /^(bewanadsl)$/) && $pppsettings{'MODEM'} eq '') {
        $errormessage = $Lang::tr{'no modem selected'};
        goto ERROR;
    }

    if ($pppsettings{'PROTOCOL'} eq 'RFC1483') {
        $pppsettings{'ENCAP'} = $pppsettings{'ENCAP_RFC1483'};
    }

    if ($pppsettings{'PROTOCOL'} eq 'RFC2364') {
        $pppsettings{'ENCAP'} = $pppsettings{'ENCAP_RFC2364'};
    }
    delete $pppsettings{'ENCAP_RFC1483'};
    delete $pppsettings{'ENCAP_RFC2364'};

ERROR:
    if ($errormessage) {
        $pppsettings{'VALID'} = 'no';
    }
    else {
        $pppsettings{'VALID'} = 'yes';
    }

    # write cgi vars to the file.
    &General::writehash("/var/ipcop/ppp/settings-$pppsettings{'PROFILE'}", \%pppsettings);

    # Activate profile
    &General::SelectProfile($pppsettings{'PROFILE'});

    &General::log("$Lang::tr{'profile saved'}: $pppsettings{'PROFILENAME'}");
    $profilenames[$pppsettings{'PROFILE'}] = $pppsettings{'PROFILENAME'};
}
elsif ($pppsettings{'ACTION'} eq $Lang::tr{'select'}) {

    # save PROFILE, reset hash and recreate default values for empty profil
    my $profile = $pppsettings{'PROFILE'};    # from cgi
    %pppsettings            = ();
    $pppsettings{'PROFILE'} = $profile;       # to be written in file
    &initprofile();
    &General::readhash("/var/ipcop/ppp/settings-$profile", \%pppsettings);

    # need to write default values on disk when profile was empty
    &General::writehash("/var/ipcop/ppp/settings-$profile", \%pppsettings);

    # Activate profile
    &General::SelectProfile($profile);

    &General::log("$Lang::tr{'profile made current'}: $pppsettings{'PROFILENAME'}");
}
elsif ($pppsettings{'ACTION'} eq $Lang::tr{'delete'}) {
    my $profile = $pppsettings{'PROFILE'};
    &General::log("$Lang::tr{'profile deleted'}: $profilenames[$profile]");

    truncate("/var/ipcop/ppp/settings-$profile", 0);

    # save PROFILE, reset hash and recreate default values for empty profil
    %pppsettings = ();
    $pppsettings{'PROFILE'} = $profile;
    &initprofile();
    &General::writehash("/var/ipcop/ppp/settings-$profile", \%pppsettings);

    # Activate profile
    &General::SelectProfile($profile);
    $profilenames[$profile] = $pppsettings{'PROFILENAME'};
}
else {

    # no accepted action set, just read in the current vars
    &General::readhash('/var/ipcop/ppp/settings', \%pppsettings);
}

# For dropdown selection, we have profiles 1-5, profile 0 is special case
$selected{'PROFILE'}{$pppsettings{'PROFILE'}} = "selected='selected'";
for ($c = 0; $c <= $maxprofiles; $c++) {
    $selected{'BACKUPPROFILE'}{$c} = '';
}
$selected{'BACKUPPROFILE'}{$pppsettings{'BACKUPPROFILE'}} = "selected='selected'";

$selected{'TYPE'}{'modem'}              = '';
$selected{'TYPE'}{'serial'}             = '';
$selected{'TYPE'}{'isdn'}               = '';
$selected{'TYPE'}{'pppoe'}              = '';
$selected{'TYPE'}{'pptp'}               = '';
$selected{'TYPE'}{'alcatelusb'}         = '';
$selected{'TYPE'}{'alcatelusbk'}        = '';
$selected{'TYPE'}{'pulsardsl'}          = '';
$selected{'TYPE'}{'eciadsl'}            = '';
$selected{'TYPE'}{'fritzdsl'}           = '';
$selected{'TYPE'}{'bewanadsl'}          = '';
$selected{'TYPE'}{'eagleusbadsl'}       = '';
$selected{'TYPE'}{'conexantusbadsl'}    = '';
$selected{'TYPE'}{'conexantpciadsl'}    = '';
$selected{'TYPE'}{'amedynusbadsl'}      = '';
$selected{'TYPE'}{'3cp4218usbadsl'}     = '';
$selected{'TYPE'}{'wanpipe-adsl'}       = '';
$selected{'TYPE'}{'wanpipe-serial'}     = '';
$selected{'TYPE'}{$pppsettings{'TYPE'}} = "selected='selected'";

$checked{'DEBUG'}{'off'}                 = '';
$checked{'DEBUG'}{'on'}                  = '';
$checked{'DEBUG'}{$pppsettings{'DEBUG'}} = "checked='checked'";

$selected{'COMPORT'}{'ttyS0'}                 = '';
$selected{'COMPORT'}{'ttyS1'}                 = '';
$selected{'COMPORT'}{'ttyS2'}                 = '';
$selected{'COMPORT'}{'ttyS3'}                 = '';
$selected{'COMPORT'}{'ttyS4'}                 = '';
$selected{'COMPORT'}{'usb/ttyACM0'}           = '';
$selected{'COMPORT'}{'usb/ttyACM1'}           = '';
$selected{'COMPORT'}{'usb/ttyACM2'}           = '';
$selected{'COMPORT'}{'usb/ttyACM3'}           = '';
$selected{'COMPORT'}{'ttyUSB0'}               = '';
$selected{'COMPORT'}{'ttyUSB1'}               = '';
$selected{'COMPORT'}{'isdn1'}                 = '';
$selected{'COMPORT'}{'isdn2'}                 = '';
$selected{'COMPORT'}{'ttyWP0'}                = '';
$selected{'COMPORT'}{'ttyWP1'}                = '';
$selected{'COMPORT'}{'ttyWP2'}                = '';
$selected{'COMPORT'}{'ttyWP3'}                = '';
$selected{'COMPORT'}{'ttyWP4'}                = '';
$selected{'COMPORT'}{'ttyWP5'}                = '';
$selected{'COMPORT'}{'ttyWP6'}                = '';
$selected{'COMPORT'}{'ttyWP7'}                = '';
$selected{'COMPORT'}{$pppsettings{'COMPORT'}} = "selected='selected'";

$selected{'DTERATE'}{'9600'}                  = '';
$selected{'DTERATE'}{'19200'}                 = '';
$selected{'DTERATE'}{'38400'}                 = '';
$selected{'DTERATE'}{'57600'}                 = '';
$selected{'DTERATE'}{'115200'}                = '';
$selected{'DTERATE'}{'230400'}                = '';
$selected{'DTERATE'}{'460800'}                = '';
$selected{'DTERATE'}{'921600'}                = '';
$selected{'DTERATE'}{'sync'}                  = '';
$selected{'DTERATE'}{$pppsettings{'DTERATE'}} = "selected='selected'";

$checked{'SPEAKER'}{'off'}                   = '';
$checked{'SPEAKER'}{'on'}                    = '';
$checked{'SPEAKER'}{$pppsettings{'SPEAKER'}} = "checked='checked'";

$selected{'DIALMODE'}{'T'}                      = '';
$selected{'DIALMODE'}{'P'}                      = '';
$selected{'DIALMODE'}{$pppsettings{'DIALMODE'}} = "selected='selected'";

$checked{'RECONNECTION'}{'manual'}                     = '';
$checked{'RECONNECTION'}{'persistent'}                 = '';
$checked{'RECONNECTION'}{'dialondemand'}               = '';
$checked{'RECONNECTION'}{$pppsettings{'RECONNECTION'}} = "checked='checked'";

$checked{'DIALONDEMANDDNS'}{'off'}                           = '';
$checked{'DIALONDEMANDDNS'}{'on'}                            = '';
$checked{'DIALONDEMANDDNS'}{$pppsettings{'DIALONDEMANDDNS'}} = "checked='checked'";

$checked{'AUTOCONNECT'}{'off'}                       = '';
$checked{'AUTOCONNECT'}{'on'}                        = '';
$checked{'AUTOCONNECT'}{$pppsettings{'AUTOCONNECT'}} = "checked='checked'";

$checked{'SENDCR'}{'off'}                    = '';
$checked{'SENDCR'}{'on'}                     = '';
$checked{'SENDCR'}{$pppsettings{'SENDCR'}}   = "checked='checked'";
$checked{'USEDOV'}{'off'}                    = '';
$checked{'USEDOV'}{'on'}                     = '';
$checked{'USEDOV'}{$pppsettings{'USEDOV'}}   = "checked='checked'";
$checked{'USEIBOD'}{'off'}                   = '';
$checked{'USEIBOD'}{'on'}                    = '';
$checked{'USEIBOD'}{$pppsettings{'USEIBOD'}} = "checked='checked'";

$checked{'MODEM'}{'PCIST'}               = '';
$checked{'MODEM'}{'USB'}                 = '';
$checked{'MODEM'}{$pppsettings{'MODEM'}} = "checked='checked'";

$selected{'LINE'}{'WO'}                 = '';
$selected{'LINE'}{'ES'}                 = '';
$selected{'LINE'}{'ES03'}               = '';
$selected{'LINE'}{'FR'}                 = '';
$selected{'LINE'}{'FR04'}               = '';
$selected{'LINE'}{'FR10'}               = '';
$selected{'LINE'}{'IT'}                 = '';
$selected{'LINE'}{$pppsettings{'LINE'}} = "selected='selected'";

$checked{'MODULATION'}{'GDMT'}                     = '';
$checked{'MODULATION'}{'ANSI'}                     = '';
$checked{'MODULATION'}{'GLITE'}                    = '';
$checked{'MODULATION'}{'AUTO'}                     = '';
$checked{'MODULATION'}{$pppsettings{'MODULATION'}} = "checked='checked'";

$checked{'PROTOCOL'}{'RFC1483'}                = '';
$checked{'PROTOCOL'}{'RFC2364'}                = '';
$checked{'PROTOCOL'}{$pppsettings{'PROTOCOL'}} = "checked='checked'";

$selected{'ENCAP'}{'0'}                    = '';
$selected{'ENCAP'}{'1'}                    = '';
$selected{'ENCAP'}{'2'}                    = '';
$selected{'ENCAP'}{'3'}                    = '';
$selected{'ENCAP'}{'4'}                    = '';
$selected{'ENCAP'}{$pppsettings{'ENCAP'}}  = "selected='selected'";
$checked{'METHOD'}{'STATIC'}               = '';
$checked{'METHOD'}{'PPPOE'}                = '';
$checked{'METHOD'}{'PPPOE_PLUGIN'}         = '';
$checked{'METHOD'}{'DHCP'}                 = '';
$checked{'METHOD'}{$pppsettings{'METHOD'}} = "checked='checked'";

$selected{'AUTH'}{'pap-or-chap'}           = '';
$selected{'AUTH'}{'pap'}                   = '';
$selected{'AUTH'}{'chap'}                  = '';
$selected{'AUTH'}{'standard-login-script'} = '';
$selected{'AUTH'}{'demon-login-script'}    = '';
$selected{'AUTH'}{'other-login-script'}    = '';
$selected{'AUTH'}{$pppsettings{'AUTH'}}    = "selected='selected'";

$checked{'DNS'}{'Automatic'}         = '';
$checked{'DNS'}{'Manual'}            = '';
$checked{'DNS'}{$pppsettings{'DNS'}} = "checked='checked'";

if ($drivererror) {
    &Header::openpage($Lang::tr{'upload'}, 0, "<meta http-equiv='refresh' content='2; URL=/cgi-bin/upload.cgi' />");
}
else {
    &Header::openpage($Lang::tr{'ppp setup'}, 1, '');
}

&Header::openbigbox('100%', 'left', '');

if ($errormessage) {
    &Header::openbox('100%', 'left', "$Lang::tr{'error messages'}:", 'error');
    print "$errormessage\n";
    &Header::closebox();
}
elsif ($warningmessage) {
    &Header::openbox('100%', 'left', "$Lang::tr{'warning messages'}:", 'warning');
    print "$warningmessage\n";
    &Header::closebox();
}

###
### Box for selecting profile
###
print "<form method='post' action='$ENV{'SCRIPT_NAME'}'>\n";
&Header::openbox('100%', 'left', "$Lang::tr{'profiles'}:");
print <<END
<table width='100%'>
<tr>
    <td align='right'>$Lang::tr{'profile'}:</td>
    <td>
    <select name='PROFILE'>
END
    ;
for ($c = 1; $c <= $maxprofiles; $c++) {
    print "\t<option value='$c' $selected{'PROFILE'}{$c}>$c. $profilenames[$c]</option>\n";
}
print <<END
    </select></td>
    <td><input type='submit' name='ACTION' value='$Lang::tr{'select'}' /></td>
    <td><input type='submit' name='ACTION' value='$Lang::tr{'delete'}' /></td>
    <td width='25%'><input type='submit' name='ACTION' value='$Lang::tr{'restore'}' /></td>
    <td width='5%' align='right'>
        <a href='${General::adminmanualurl}/network-ppp-settings.html' target='_blank'><img src='/images/web-support.png' alt='$Lang::tr{'online help en'}' title='$Lang::tr{'online help en'}' /></a>
    </td>
</tr>
</table>
END
    ;
&Header::closebox();
&Header::openbox('100%', 'left', $Lang::tr{'connection'} . ':');
print <<END
<table width='100%'>
<tr>
    <td align='right'>$Lang::tr{'interface'}:</td>
    <td>
    <select name='TYPE'>
    <option value='modem' $selected{'TYPE'}{'modem'}>$Lang::tr{'modem'}</option>
    <option value='serial' $selected{'TYPE'}{'serial'}>$Lang::tr{'serial'}</option>
END
    ;
if ($isdnsettings{'ENABLED'} eq 'on') {
    print "\t<option value='isdn' $selected{'TYPE'}{'isdn'}>$Lang::tr{'isdn'}</option>\n";
}
if ($netsettings{'RED_1_TYPE'} eq 'PPPOE') {
    print "\t<option value='pppoe' $selected{'TYPE'}{'pppoe'}>PPPoE</option>\n";
}
if ($netsettings{'RED_1_TYPE'} eq 'PPTP') {
    print "\t<option value='pptp' $selected{'TYPE'}{'pptp'}>PPTP</option>\n";
}
if (-f "/proc/bus/usb/devices") {
    print <<END
    <option value='eciadsl' $selected{'TYPE'}{'eciadsl'}>ECI USB ADSL</option>
    <option value='eagleusbadsl' $selected{'TYPE'}{'eagleusbadsl'}>Eagle USB ADSL (Acer Allied-Telesyn Comtrend D-Link Sagem USR)</option>
    <option value='conexantusbadsl' $selected{'TYPE'}{'conexantusbadsl'}>Conexant USB(Aetra Amigo Draytek Etec Mac Olitec Vitelcom Zoom)</option>
    <option value='amedynusbadsl' $selected{'TYPE'}{'amedynusbadsl'}>Zyxel 630-11 / Asus AAM6000UG USB ADSL</option>
    <option value='3cp4218usbadsl' $selected{'TYPE'}{'3cp4218usbadsl'}>3Com USB AccessRunner</option>
    <option value='alcatelusb' $selected{'TYPE'}{'alcatelusb'}>Speedtouch USB ADSL user mode driver</option>
    <option value='alcatelusbk' $selected{'TYPE'}{'alcatelusbk'}>Speedtouch USB ADSL kernel mode driver</option>
END
        ;
}
print <<END
    <option value='fritzdsl' $selected{'TYPE'}{'fritzdsl'}>Fritz!DSL</option>
    <option value='pulsardsl' $selected{'TYPE'}{'pulsardsl'}>Pulsar ADSL</option>
    <option value='bewanadsl' $selected{'TYPE'}{'bewanadsl'}>Bewan ADSL PCI st/USB st</option>
    <option value='conexantpciadsl' $selected{'TYPE'}{'conexantpciadsl'}>Conexant PCI ADSL</option>
    <option value='wanpipe-adsl' $selected{'TYPE'}{'wanpipe-adsl'}>Sangoma S518 adsl</option>
    <option value='wanpipe-serial' $selected{'TYPE'}{'wanpipe-serial'}>Sangoma S514 serial</option>
    </select></td>
    <td width='50%'><input type='submit' name='ACTION' value='$Lang::tr{'refresh'}' /></td>
    </tr>
END
    ;
if (-f "/proc/bus/usb/devices") {
    print <<END
    <tr>
    <td align='right'>USB:</td>
END
        ;
    my $usb = `/sbin/lsmod | /usr/bin/cut -d ' ' -f1 | /bin/grep -E 'hci'`;
    if ($usb eq '') {
        print "\t<td>$Lang::tr{'not running'}</td></tr>\n";
    }
    else {
        print "\t<td>$usb</td></tr>\n";
    }
}

if ($pppsettings{'TYPE'}) {
    print "</table><table width='100%'>";
    if ($pppsettings{'TYPE'} =~ /^(modem|serial|isdn|wanpipe-serial)$/) {
        print <<END
<tr>
    <td align='right'>$Lang::tr{'interface'}:</td>
    <td><select name='COMPORT'>
END
            ;
        if ($pppsettings{'TYPE'} =~ /^(modem|serial)$/) {
            print <<END
        <option value='ttyS0' $selected{'COMPORT'}{'ttyS0'}>$Lang::tr{'modem on com1'}</option>
        <option value='ttyS1' $selected{'COMPORT'}{'ttyS1'}>$Lang::tr{'modem on com2'}</option>
        <option value='ttyS2' $selected{'COMPORT'}{'ttyS2'}>$Lang::tr{'modem on com3'}</option>
        <option value='ttyS3' $selected{'COMPORT'}{'ttyS3'}>$Lang::tr{'modem on com4'}</option>
        <option value='ttyS4' $selected{'COMPORT'}{'ttyS4'}>$Lang::tr{'modem on com5'}</option>
        <option value='usb/ttyACM0' $selected{'COMPORT'}{'usb/ttyACM0'}>$Lang::tr{'usb modem on acm0'}</option>
        <option value='usb/ttyACM1' $selected{'COMPORT'}{'usb/ttyACM1'}>$Lang::tr{'usb modem on acm1'}</option>
        <option value='usb/ttyACM2' $selected{'COMPORT'}{'usb/ttyACM2'}>$Lang::tr{'usb modem on acm2'}</option>
        <option value='usb/ttyACM3' $selected{'COMPORT'}{'usb/ttyACM3'}>$Lang::tr{'usb modem on acm3'}</option>
        <option value='ttyUSB0' $selected{'COMPORT'}{'ttyUSB0'}>$Lang::tr{'modem on usb0'}</option>
        <option value='ttyUSB1' $selected{'COMPORT'}{'ttyUSB1'}>$Lang::tr{'modem on usb1'}</option>
    </select></td>
END
                ;
        }
        elsif ($pppsettings{'TYPE'} eq 'isdn') {
            print <<END
        <option value='isdn1' $selected{'COMPORT'}{'isdn1'}>$Lang::tr{'isdn1'}</option>
        <option value='isdn2' $selected{'COMPORT'}{'isdn2'}>$Lang::tr{'isdn2'}</option>
    </select></td>
END
                ;
        }
        elsif ($pppsettings{'TYPE'} eq 'wanpipe-serial') {
            print <<END
        <option value='ttyWP0' $selected{'COMPORT'}{'ttyWP0'}>ttyWP0</option>
        <option value='ttyWP1' $selected{'COMPORT'}{'ttyWP1'}>ttyWP1</option>
        <option value='ttyWP2' $selected{'COMPORT'}{'ttyWP2'}>ttyWP2</option>
        <option value='ttyWP3' $selected{'COMPORT'}{'ttyWP3'}>ttyWP3</option>
        <option value='ttyWP4' $selected{'COMPORT'}{'ttyWP4'}>ttyWP4</option>
        <option value='ttyWP5' $selected{'COMPORT'}{'ttyWP5'}>ttyWP5</option>
        <option value='ttyWP6' $selected{'COMPORT'}{'ttyWP6'}>ttyWP6</option>
        <option value='ttyWP7' $selected{'COMPORT'}{'ttyWP7'}>ttyWP7</option>
    </select></td>
END
                ;
        }
        if ($pppsettings{'TYPE'} =~ /^(modem|serial|wanpipe-serial)$/) {
            print <<END
    <td align='right'>$Lang::tr{'computer to modem rate'}:</td>
    <td><select name='DTERATE'>
        <option value='9600' $selected{'DTERATE'}{'9600'}>9600</option>
        <option value='19200' $selected{'DTERATE'}{'19200'}>19200</option>
        <option value='38400' $selected{'DTERATE'}{'38400'}>38400</option>
        <option value='57600' $selected{'DTERATE'}{'57600'}>57600</option>
        <option value='115200' $selected{'DTERATE'}{'115200'}>115200</option>
        <option value='230400' $selected{'DTERATE'}{'230400'}>230400</option>
        <option value='460800' $selected{'DTERATE'}{'460800'}>460800</option>
        <option value='921600' $selected{'DTERATE'}{'921600'}>921600</option>
END
                ;
        }
        if ($pppsettings{'TYPE'} eq 'wanpipe-serial') {
            print "<option value='sync' $selected{'DTERATE'}{'sync'}>sync</option>";
        }
        if ($pppsettings{'TYPE'} =~ /^(modem|serial|wanpipe-serial)$/) {
            print "</select></td></tr>";
        }
        else {
            print "<td colspan='2'>&nbsp;</td></tr>\n";
        }
        if ($pppsettings{'TYPE'} =~ /^(modem|isdn)$/) {
            print "<tr><td align='right'>$Lang::tr{'number'}:</td>\n";
            print "<td><input type='text' name='TELEPHONE' value='$pppsettings{'TELEPHONE'}' /></td>\n";
            if ($pppsettings{'TYPE'} eq 'modem') {
                print "<td align='right'>$Lang::tr{'modem speaker on'}:</td>\n";
                print "<td><input type='checkbox' name='SPEAKER' $checked{'SPEAKER'}{'on'} /></td></tr>\n";
            }
            else {
                print "<td colspan='2'>&nbsp;</td></tr>\n";
            }
        }
    }
    if ($pppsettings{'TYPE'} eq 'modem') {
        print <<END
<tr>
    <td align='right'>$Lang::tr{'dialing mode'}:</td>
    <td><select name='DIALMODE'>
        <option value='T' $selected{'DIALMODE'}{'T'}>$Lang::tr{'tone'}</option>
        <option value='P' $selected{'DIALMODE'}{'P'}>$Lang::tr{'pulse'}</option>
    </select></td>
    <td align='right'>$Lang::tr{'send cr'}:</td>
    <td><input type='checkbox' name='SENDCR' $checked{'SENDCR'}{'on'} /></td>
</tr>
END
            ;
    }

    print <<END
<tr>
    <td align='right'>$Lang::tr{'idle timeout'}:</td>
    <td><input type='text' size='5' name='TIMEOUT' value='$pppsettings{'TIMEOUT'}' /></td>
    <td colspan='2'>&nbsp;</td>
</tr>
END
        ;
    if (   ($netsettings{'RED_COUNT'} >= 1)
        && ($netsettings{'RED_1_TYPE'} eq "DHCP" || $netsettings{'RED_1_TYPE'} eq "STATIC"))
    {
        $pppsettings{'AUTOCONNECT'} = 'on';
        print "<tr><td align='right'>$Lang::tr{'connect on ipcop restart'}:</td>\n";
        print
"<td><input type='checkbox' disabled='disabled' name='AUTOCONNECT' value='on' $checked{'AUTOCONNECT'}{'on'} /></td>\n";
    }
    else {
        print "<tr><td align='right'>$Lang::tr{'connect on ipcop restart'}:</td>\n";
        print "<td><input type='checkbox' name='AUTOCONNECT' value='on' $checked{'AUTOCONNECT'}{'on'} /></td>\n";
    }
    print <<END
    <td align='right'>$Lang::tr{'connection debugging'}:</td>
    <td><input type='checkbox' name='DEBUG' $checked{'DEBUG'}{'on'} /></td>
</tr>
<tr>
    <td colspan='5'><br /><hr /><b>$Lang::tr{'reconnection'}:</b></td>
</tr>
<tr>
    <td colspan='4'>
        <input type='radio' name='RECONNECTION' value='manual' $checked{'RECONNECTION'}{'manual'} />$Lang::tr{'manual'}</td>
</tr>
<tr>
    <td>
        <input type='radio' name='RECONNECTION' value='persistent' $checked{'RECONNECTION'}{'persistent'} />$Lang::tr{'persistent'}</td>
    <td colspan='2' align='right'>$Lang::tr{'backupprofile'}:</td>
    <td>
    <select name='BACKUPPROFILE'>
END
    ;
    print "\t<option value='0' $selected{'BACKUPPROFILE'}{0}>$profilenames[0]</option>\n";
    for ($c = 1; $c <= $maxprofiles; $c++) {
        print "\t<option value='$c' $selected{'BACKUPPROFILE'}{$c}>$c. $profilenames[$c]</option>\n";
    }
    print <<END
    </select></td>
</tr>
<tr>
    <td>
        <input type='radio' name='RECONNECTION' value='dialondemand' $checked{'RECONNECTION'}{'dialondemand'} />$Lang::tr{'dod'}</td>
    <td colspan='2' align='right'>$Lang::tr{'dod for dns'}:</td>
    <td><input type='checkbox' name='DIALONDEMANDDNS' $checked{'DIALONDEMANDDNS'}{'on'} /></td>

</tr>
<tr>
    <td align='right'>$Lang::tr{'holdoff'}:</td>
    <td><input type='text' size='5' name='HOLDOFF' value='$pppsettings{'HOLDOFF'}' /></td>
    <td align='right'>$Lang::tr{'maximum retries'}:</td>
    <td><input type='text' size='5' name='MAXRETRIES' value='$pppsettings{'MAXRETRIES'}' /></td>
</tr>
END
        ;

    if ($pppsettings{'TYPE'} eq 'isdn') {
        print <<END
</table>
<table width='100%'>
<tr>
    <td colspan='5'><br /><hr /><b>$Lang::tr{'isdn settings'}:</b></td>
</tr>
<tr>
    <td align='right'>$Lang::tr{'use ibod'}:</td>
    <td><input type='checkbox' name='USEIBOD' $checked{'USEIBOD'}{'on'} /></td>
    <td align='right'>$Lang::tr{'use dov'}:</td>
    <td><input type='checkbox' name='USEDOV' $checked{'USEDOV'}{'on'} /></td>
</tr>
END
            ;
    }

    if ($pppsettings{'TYPE'} eq 'pptp') {
        print <<END
</table>

<table width='100%'>
<tr>
    <td colspan='5'><br /><hr /><b>$Lang::tr{'pptp settings'}:</b></td>
</tr>
<tr>
    <td colspan='2' align='right'>$Lang::tr{'phonebook entry'}:</td>
    <td><input type='text' name='PHONEBOOK' value='$pppsettings{'PHONEBOOK'}' /></td>
</tr>
<tr>
    <td><input type='radio' name='METHOD' value='STATIC' $checked{'METHOD'}{'STATIC'} />$Lang::tr{'static ip'}</td>
    <td align='right'>$Lang::tr{'router ip'}:</td>
    <td><input type='text' name='ROUTERIP' value='$pppsettings{'ROUTERIP'}' /></td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td colspan='3'><hr /></td>
</tr>
<tr>
    <td><input type='radio' name='METHOD' value='DHCP' $checked{'METHOD'}{'DHCP'} />$Lang::tr{'dhcp mode'}</td>
    <td align='right'>$Lang::tr{'hostname'}:&nbsp;<img src='/blob.gif' alt='*' /></td>
    <td><input type='text' name='DHCP_HOSTNAME' value='$pppsettings{'DHCP_HOSTNAME'}' /></td>
</tr>
END
            ;
    }

    if ($pppsettings{'TYPE'} eq 'pppoe') {
        print <<END
</table>
<table width='100%'>
<tr>
    <td colspan='5'><br /><hr /><b>$Lang::tr{'pppoe settings'}:</b></td>
</tr>
END
            ;
    }

    if ($pppsettings{'TYPE'} =~
/^(alcatelusb|alcatelusbk|amedynusbadsl|conexantusbadsl|conexantpciadsl|3cp4218usbadsl|pulsardsl|eciadsl|fritzdsl|bewanadsl|eagleusbadsl|wanpipe-adsl)$/
        )
    {
        print <<END
</table>
<table width='100%'>
<tr>
    <td colspan='5'><br /><hr /><b>$Lang::tr{'adsl settings'}:</b></td>
</tr>
<tr>
    <td nowrap='nowrap' align='right'>$Lang::tr{'vpi number'}:</td>
    <td><input type='text' size='5' name='VPI' value='$pppsettings{'VPI'}' /></td>
    <td align='right'>$Lang::tr{'vci number'}:</td>
    <td colspan='2'><input type='text' size='5' name='VCI' value='$pppsettings{'VCI'}' /></td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td colspan='4'><hr /></td>
</tr>
END
            ;
    }

    if ($pppsettings{'TYPE'} eq 'bewanadsl') {
        print <<END
<tr>
    <td align='right'>$Lang::tr{'modem'}:</td>
    <td colspan='2' nowrap='nowrap'>
        <input type='radio' name='MODEM' value='PCIST' $checked{'MODEM'}{'PCIST'} />Bewan ADSL PCI st</td>
    <td colspan='2'><input type='radio' name='MODEM' value='USB' $checked{'MODEM'}{'USB'} />Bewan ADSL USB st</td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td colspan='4'><hr /></td>
</tr>
END
            ;
    }

    if ($pppsettings{'TYPE'} =~ /^(3cp4218usbadsl|bewanadsl)$/) {
        print <<END
<tr>
    <td align='right'>$Lang::tr{'modulation'}:</td>
    <td><input type='radio' name='MODULATION' value='AUTO' $checked{'MODULATION'}{'AUTO'} />$Lang::tr{'automatic'}</td>
    <td><input type='radio' name='MODULATION' value='ANSI' $checked{'MODULATION'}{'ANSI'} />ANSI T1.483</td>
    <td><input type='radio' name='MODULATION' value='GDMT' $checked{'MODULATION'}{'GDMT'} />G.DMT</td>
    <td><input type='radio' name='MODULATION' value='GLITE' $checked{'MODULATION'}{'GLITE'} />G.Lite</td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td colspan='4'><hr /></td>
</tr>
END
            ;
    }

    if ($pppsettings{'TYPE'} eq 'eagleusbadsl') {
        print <<END
<tr>
    <td align='right'>$Lang::tr{'country'}:</td>
    <td>
    <select name='LINE'>
    <option value='WO' $selected{'LINE'}{'WO'}>$Lang::tr{'other countries'}</option>
    <option value='ES' $selected{'LINE'}{'ES'}>ESPANA</option>
    <option value='ES03' $selected{'LINE'}{'ES03'}>ESPANA03</option>
    <option value='FR' $selected{'LINE'}{'FR'}>FRANCE</option>
    <option value='FR04' $selected{'LINE'}{'FR04'}>FRANCE04</option>
    <option value='FR10' $selected{'LINE'}{'FR04'}>FRANCE10</option>
    <option value='IT' $selected{'LINE'}{'IT'}>ITALIA</option>
    </select></td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td colspan='4'><hr /></td>
</tr>
END
            ;
    }

    if ($pppsettings{'TYPE'} eq 'eciadsl') {
        print <<END
<tr>
    <td align='right'>$Lang::tr{'modem'}:</td>
    <td colspan='5'>
        <select name='MODEM'>
END
            ;
        open(MODEMS, "/etc/eciadsl/modems.db") or die 'Unable to open modems database.';
        while (my $line = <MODEMS>) {
            $line =~ /^([\S\ ]+).*$/;
            my $modem = $1;
            $modem =~ s/^\s*(.*?)\s*$/$1/;
            print "<option value='$modem'";
            if ($pppsettings{'MODEM'} =~ /$modem/) {
                print " selected";
            }
            print ">$modem</option>\n";
        }
        close(MODEMS);

        print <<END
        </select>
    </td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td colspan='4'><hr /></td>
</tr>
END
            ;
    }

    if ($pppsettings{'TYPE'} =~
/^(alcatelusb|alcatelusbk|amedynusbadsl|conexantusbadsl|conexantpciadsl|3cp4218usbadsl|pulsardsl|eciadsl|fritzdsl|bewanadsl|eagleusbadsl|wanpipe-adsl)$/
        )
    {
        print <<END
<tr>
    <td valign='top' align='right'>$Lang::tr{'protocol'}:</td>
    <td nowrap='nowrap'>
        <input type='radio' name='PROTOCOL' value='RFC2364' $checked{'PROTOCOL'}{'RFC2364'} />RFC2364 PPPoA</td>
END
            ;
    }

    if ($pppsettings{'TYPE'} eq 'alcatelusb') {
        print "<td colspan='3'>&nbsp;</td></tr>";
    }

    if ($pppsettings{'TYPE'} =~
/^(alcatelusbk|amedynusbadsl|conexantusbadsl|conexantpciadsl|3cp4218usbadsl|pulsardsl|eciadsl|bewanadsl|eagleusbadsl|fritzdsl|wanpipe-adsl)$/
        )
    {
        print <<END
    <td align='right'>$Lang::tr{'encapsulation'}:</td>
    <td colspan='2' width='30%'>
        <select name='ENCAP_RFC2364'>
        <option value='0' $selected{'ENCAP'}{'0'}>VCmux</option>
        <option value='1' $selected{'ENCAP'}{'1'}>LLC</option>
        </select>
    </td>
</tr>
END
            ;
    }

    if ($pppsettings{'TYPE'} =~
/^(alcatelusb|alcatelusbk|amedynusbadsl|conexantusbadsl|conexantpciadsl|3cp4218usbadsl|pulsardsl|eciadsl|fritzdsl|bewanadsl|eagleusbadsl|wanpipe-adsl)$/
        )
    {
        print <<END
<tr>
    <td>&nbsp;</td>
    <td colspan='4'><hr /></td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td valign='top'>
        <input type='radio' name='PROTOCOL' value='RFC1483' $checked{'PROTOCOL'}{'RFC1483'} />RFC 1483 / 2684</td>
END
            ;
    }

    if ($pppsettings{'TYPE'} eq 'alcatelusb') {
        print "<td colspan='3'>&nbsp;</td></tr>";
    }

    if ($pppsettings{'TYPE'} =~
/^(alcatelusbk|amedynusbadsl|conexantusbadsl|conexantpciadsl|3cp4218usbadsl|pulsardsl|eciadsl|bewanadsl|eagleusbadsl|fritzdsl|wanpipe-adsl)$/
        )
    {
        if ($pppsettings{'TYPE'} ne 'fritzdsl') {
            print <<END
    <td align='right'>$Lang::tr{'encapsulation'}:</td>
    <td colspan='2'>
        <select name='ENCAP_RFC1483'>
        <option value='0' $selected{'ENCAP'}{'0'}>BRIDGED_ETH_LLC</option>
        <option value='1' $selected{'ENCAP'}{'1'}>BRIDGED_ETH_VC</option>
        <option value='2' $selected{'ENCAP'}{'2'}>ROUTED_IP_LLC</option>
        <option value='3' $selected{'ENCAP'}{'3'}>ROUTED_IP_VC</option>
        </select>
    </td>
</tr>
<tr>
    <td colspan='2'>&nbsp;</td>
    <td colspan='3'><hr /></td>
</tr>
END
                ;
        }
        else {
            print <<END
    <td colspan='4'>PPPoE</td>
</tr>
END
                ;
        }
    }

    if ($pppsettings{'TYPE'} =~
/^(pppoe|alcatelusb|alcatelusbk|amedynusbadsl|conexantusbadsl|conexantpciadsl|3cp4218usbadsl|pulsardsl|eciadsl|bewanadsl|eagleusbadsl|wanpipe-adsl)$/
        )
    {
        print <<END
<tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td><input type='radio' name='METHOD' value='PPPOE_PLUGIN' $checked{'METHOD'}{'PPPOE_PLUGIN'} />PPPoE plugin</td>
    <td align='right'>$Lang::tr{'service name'}:&nbsp;<img src='/blob.gif' alt='*' /></td>
    <td><input type='text' name='SERVICENAME' value='$pppsettings{'SERVICENAME'}' /></td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td><input type='radio' name='METHOD' value='PPPOE' $checked{'METHOD'}{'PPPOE'} />$Lang::tr{'pppoe'}</td>
    <td align='right'>$Lang::tr{'concentrator name'}:&nbsp;<img src='/blob.gif' alt='*' /></td>
    <td><input type='text' name='CONCENTRATORNAME' value='$pppsettings{'CONCENTRATORNAME'}' /></td>
</tr>

END
            ;
    }

    if ($pppsettings{'TYPE'} =~
/^(alcatelusbk|amedynusbadsl|conexantusbadsl|conexantpciadsl|3cp4218usbadsl|pulsardsl|eciadsl|bewanadsl|eagleusbadsl|wanpipe-adsl|wanpipe-serial)$/
        )
    {
        print <<END
<tr>
    <td colspan='2'>&nbsp;</td>
    <td colspan='3'><hr /></td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td rowspan='4'><input type='radio' name='METHOD' value='STATIC' $checked{'METHOD'}{'STATIC'} />$Lang::tr{'static ip'}</td>
    <td align='right'>$Lang::tr{'static ip'}:</td>
    <td><input type='text' size='16' name='IP' value='$pppsettings{'IP'}' /></td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td align='right'>$Lang::tr{'gateway ip'}:</td>
    <td><input type='text' size='16' name='GATEWAY' value='$pppsettings{'GATEWAY'}' /></td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td align='right'>$Lang::tr{'netmask'}:</td>
    <td><input type='text' size='16' name='NETMASK' value='$pppsettings{'NETMASK'}' /></td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td align='right' nowrap='nowrap'>$Lang::tr{'broadcast'}:&nbsp;<img src='/blob.gif' alt='*' /></td>
    <td><input type='text' size='16' name='BROADCAST' value='$pppsettings{'BROADCAST'}' /></td>
</tr>
END
            ;

        if ($pppsettings{'TYPE'} =~ /^(eciadsl|eagleusbadsl)$/) {
            print <<END
<tr>
    <td colspan='2'>&nbsp;</td>
    <td colspan='3'><hr /></td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td><input type='radio' name='METHOD' value='DHCP' $checked{'METHOD'}{'DHCP'} />$Lang::tr{'dhcp mode'}</td>
    <td align='right'>$Lang::tr{'hostname'}:&nbsp;<img src='/blob.gif' alt='*' /></td>
    <td><input type='text' name='DHCP_HOSTNAME' value='$pppsettings{'DHCP_HOSTNAME'}' /></td>
</tr>
END
                ;
        }
    }

    #drivers that need a file upload
    if ($pppsettings{'TYPE'} =~ /^(alcatelusb|alcatelusbk|eciadsl|fritzdsl)$/) {
        print "<tr><td>&nbsp;</td><td colspan='4'><hr /></td></tr>";
    }
    if ($pppsettings{'TYPE'} =~ /^(alcatelusb|alcatelusbk)$/) {
        my $speedtouch = &Header::speedtouchversion;
        if (($speedtouch >= 0) && ($speedtouch <= 4)) {
            my $modem;
            if ($speedtouch == 4) {
                $modem = 'v4_b';
            }
            else {
                $modem = 'v0123';
            }
            print "<tr><td align='right'>$Lang::tr{'firmware'}:</td>";
            if (-e "/var/ipcop/alcatelusb/firmware.$modem.bin") {
                print "<td>$Lang::tr{'present'}</td><td colspan='3'>&nbsp;</td></tr>\n";
            }
            else {
                print "<td>$Lang::tr{'not present'}</td><td colspan='3'>&nbsp;</td></tr>\n";
            }
        }
        else {
            print "<tr><td colspan='5'>$Lang::tr{'unknown'} Rev $speedtouch</td></tr>";
        }
    }
    elsif ($pppsettings{'TYPE'} eq 'eciadsl') {
        print "<tr><td align='right'>$Lang::tr{'driver'}:</td>";
        if (-e "/var/ipcop/eciadsl/synch.bin") {
            print "<td>$Lang::tr{'present'}</td><td colspan='3'>&nbsp;</td></tr>\n";
        }
        else {
            print "<td>$Lang::tr{'not present'}</td><td colspan='3'>&nbsp;</td></tr>\n";
        }
    }
    elsif ($pppsettings{'TYPE'} eq 'fritzdsl') {
        print "<tr><td align='right'>$Lang::tr{'driver'}:</td>";
        if (-e "/lib/modules/$kernel/misc/fcdslusb.o.gz") {
            print "<td>$Lang::tr{'present'}</td><td colspan='3'>&nbsp;</td></tr>\n";
        }
        else {
            print "<td>$Lang::tr{'not present'}</td><td colspan='3'>&nbsp;</td></tr>\n";
        }
    }

    print <<END
</table>
<table width='100%'>
<tr>
    <td colspan='5'><br /><hr /><b>$Lang::tr{'authentication'}:</b></td>
</tr>
<tr>
    <td align='right'>$Lang::tr{'username'}:</td>
    <td><input type='text' name='USERNAME' value='$pppsettings{'USERNAME'}' /></td>
    <td align='right'>$Lang::tr{'password'}:</td>
    <td><input type='password' name='PASSWORD' value='$pppsettings{'PASSWORD'}' /></td>
</tr>
<tr>
    <td align='right'>$Lang::tr{'method'}:</td>
    <td><select name='AUTH'>
        <option value='pap-or-chap' $selected{'AUTH'}{'pap-or-chap'}>$Lang::tr{'pap or chap'}</option>
        <option value='pap' $selected{'AUTH'}{'pap'}>PAP</option>
        <option value='chap' $selected{'AUTH'}{'chap'}>CHAP</option>
END
        ;

    if ($pppsettings{'TYPE'} eq 'modem') {
        print <<END
        <option value='standard-login-script' $selected{'AUTH'}{'standard-login-script'}>$Lang::tr{'standard login script'}</option>
        <option value='demon-login-script' $selected{'AUTH'}{'demon-login-script'}>$Lang::tr{'demon login script'}</option>
        <option value='other-login-script' $selected{'AUTH'}{'other-login-script'}>$Lang::tr{'other login script'}</option>
END
            ;
    }

    print <<END
    </select></td>
    <td align='right'>$Lang::tr{'script name'}:&nbsp;<img src='/blob.gif' alt='*' /></td>
    <td nowrap='nowrap'><input type='text' name='LOGINSCRIPT' value='$pppsettings{'LOGINSCRIPT'}' /></td>
</tr>
</table>
<table width='100%'>
<tr>
    <td colspan='5'><br /><hr /><b>DNS:</b></td>
</tr>
<tr>
    <td colspan='5'><input type='radio' name='DNS' value='Automatic' $checked{'DNS'}{'Automatic'} />$Lang::tr{'automatic'}</td>
</tr>
<tr>
    <td><input type='radio' name='DNS' value='Manual' $checked{'DNS'}{'Manual'} />$Lang::tr{'manual'}</td>
    <td align='right'>$Lang::tr{'primary dns'}:</td>
    <td><input type='text' size='16' name='DNS1' value='$pppsettings{'DNS1'}' /></td>
    <td align='right'>$Lang::tr{'secondary dns'}:</td>
    <td><input type='text' size='16' name='DNS2' value='$pppsettings{'DNS2'}' /></td>
</tr>
<tr>
    <td colspan='5'><br /><hr /></td>
</tr>
<tr>
    <td>&nbsp;</td>
    <td align='right'>$Lang::tr{'profile name'}:</td>
    <td><input type='text' name='PROFILENAME' value='$pppsettings{'PROFILENAME'}' /></td>
    <td><input type='submit' name='ACTION' value='$Lang::tr{'save'}' /></td>
</tr>
<tr>
    <td colspan='5'><br /><hr /></td>
</tr>
<tr>
    <td align='right'>$Lang::tr{'legend'}:</td>
    <td><img src='/blob.gif' alt='*' />&nbsp;$Lang::tr{'this field may be blank'}</td>
</tr>
</table>
END
        ;
    &Header::closebox();
}

print "</form>\n";

&Header::closebigbox();

&Header::closepage();


sub initprofile {

    # if we arrive for the first time, profil 1 is empty
    # others profiles are never empty, because they are selected
    if (!defined($pppsettings{'PROFILE'})) {
        $pppsettings{'PROFILE'} = '1';
    }
    $pppsettings{'AUTH'}             = 'pap-or-chap';
    $pppsettings{'AUTOCONNECT'}      = 'off';
    $pppsettings{'BACKUPPROFILE'}    = '0';
    $pppsettings{'BROADCAST'}        = '';
    $pppsettings{'COMPORT'}          = 'ttyS0';
    $pppsettings{'CONCENTRATORNAME'} = '';
    $pppsettings{'DEBUG'}            = 'off';
    $pppsettings{'DHCP_HOSTNAME'}    = '';
    $pppsettings{'DIALONDEMANDDNS'}  = 'off';
    $pppsettings{'DIALMODE'}         = 'T';
    $pppsettings{'DNS'}              = 'Automatic';
    $pppsettings{'DNS1'}             = '';
    $pppsettings{'DNS2'}             = '';
    $pppsettings{'DTERATE'}          = 115200;
    $pppsettings{'ENCAP'}            = '0';
    $pppsettings{'GATEWAY'}          = '';
    $pppsettings{'HOLDOFF'}          = 30;
    $pppsettings{'IP'}               = '';
    $pppsettings{'LINE'}             = 'WO';
    $pppsettings{'LOGINSCRIPT'}      = '';
    $pppsettings{'MAXRETRIES'}       = 5;
    $pppsettings{'METHOD'}           = 'PPPOE_PLUGIN';
    $pppsettings{'MODEM'}            = 'PCIST';
    $pppsettings{'MODULATION'}       = 'AUTO';
    $pppsettings{'NETMASK'}          = '';
    $pppsettings{'PASSWORD'}         = '';
    $pppsettings{'PHONEBOOK'}        = 'RELAY_PPP1';
    $pppsettings{'PROFILENAME'}      = $Lang::tr{'unnamed'};
    $pppsettings{'PROTOCOL'}         = 'RFC2364';
    $pppsettings{'RECONNECTION'}     = 'manual';
    $pppsettings{'ROUTERIP'}         = '';
    $pppsettings{'SENDCR'}           = 'off';
    $pppsettings{'SERVICENAME'}      = '';
    $pppsettings{'SPEAKER'}          = 'off';
    $pppsettings{'TELEPHONE'}        = '';
    $pppsettings{'TIMEOUT'}          = 15;
    $pppsettings{'USEDOV'}           = 'off';
    $pppsettings{'USEIBOD'}          = 'off';
    $pppsettings{'USERNAME'}         = '';
    $pppsettings{'VALID'}            = '';
    $pppsettings{'VCI'}              = '';
    $pppsettings{'VPI'}              = '';

    # Get ISDN settings so we can see if ISDN is enabled or not.
    $isdnsettings{'ENABLED'} = 'off';
    &General::readhash("/var/ipcop/isdn/settings", \%isdnsettings);

    # Get PPPoE settings so we can see if PPPoE is enabled or not.
    $netsettings{'RED_1_TYPE'} = '';
    &General::readhash("/var/ipcop/ethernet/settings", \%netsettings);

    # empty profile partial pre-initialization
    if ($netsettings{'RED_COUNT'} >= 1) {
        $pppsettings{'TYPE'} = lc($netsettings{'RED_1_TYPE'});
    }
    elsif ($isdnsettings{'ENABLED'} eq 'on') {
        $pppsettings{'TYPE'} = 'isdn';
    }
    else {
        $pppsettings{'TYPE'} = 'modem';
    }
}

