#!/usr/bin/perl
#
# SmoothWall CGIs
#
# This code is distributed under the terms of the GPL
#
# (c) The SmoothWall Team
#
# $Id: netstatus.cgi 3122 2009-06-25 10:55:55Z owes $
#

# Add entry in menu
# MENUENTRY status 030 "ssnetwork status" "network status information"
#
# Make sure translation exists $Lang::tr{'ssnetwork status'}

use strict;

# enable only the following on debugging purpose
#use warnings;
#use CGI::Carp 'fatalsToBrowser';

require '/usr/lib/ipcop/general-functions.pl';
require '/usr/lib/ipcop/lang.pl';
require '/usr/lib/ipcop/header.pl';

my %dhcpsettings=();
my %netsettings=();
my %dhcpinfo=();
my %pppsettings=();
my $output='';
$dhcpinfo{'DOMAIN'}=''; # because it may not be defined in the answer
my $dhcpserver = 0;

&General::readhash('/var/ipcop/dhcp/settings', \%dhcpsettings);
&General::readhash('/var/ipcop/ethernet/settings', \%netsettings);
&General::readhash('/var/ipcop/ppp/settings', \%pppsettings);
&Header::showhttpheaders();
&Header::openpage($Lang::tr{'network status information'}, 1, '');

my @DHCPINTERFACEs=('GREEN','BLUE');
foreach my $interface (@DHCPINTERFACEs) {
    for (my $counter = 1; $counter <= $netsettings{"${interface}_COUNT"}; $counter++) {
        if ( $dhcpsettings{"ENABLED_${interface}_${counter}"} eq 'on' ) {
            $dhcpserver++;
        }
    }
}

&Header::openbigbox('100%', 'left');

print "<table width='100%' cellspacing='0' cellpadding='5'border='0'>\n";
print "<tr><td style='background-color: #FFFFFF;' align='left'>\n";
print "<a href='#interfaces'>$Lang::tr{'interfaces'}:</a> |\n";
if ( ($netsettings{'RED_COUNT'} >= 1) && $netsettings{'RED_1_TYPE'} eq "DHCP") {
    print "<a href='#reddhcp'>RED  $Lang::tr{'dhcp configuration'}:</a> |\n";
}
if ($dhcpserver > 0) {
    print "<a href='#leases'>$Lang::tr{'current dynamic leases'}:</a> |\n";
}
if ($pppsettings{'TYPE'} =~ /^(bewanadsl|alcatelusbk|conexantpciadsl|eagleusbadsl|wanpipe)$/) {
    print "<a href='#adsl'>$Lang::tr{'adsl settings'}</a> |\n";
}
print "<a href='#routing'>$Lang::tr{'routing table entries'}:</a> |\n";
print "<a href='#arp'> $Lang::tr{'arp table entries'}:</a>\n";
print "</td></tr></table>\n";

print "<a name='interfaces'/>\n";
&Header::openbox('100%', 'left', "$Lang::tr{'interfaces'}:");
$output = `/sbin/ifconfig -a`;
$output = &General::color_devices($output);
print "<pre>$output</pre>\n";
&Header::closebox();


if ( ($netsettings{'RED_COUNT'} >= 1)  && $netsettings{'RED_1_TYPE'} eq "DHCP") {

    print "<a name='reddhcp'/>\n";
    &Header::openbox('100%', 'left', "RED $Lang::tr{'dhcp configuration'}:");
    if (-s "/var/log/dhcpclient.info") {

        &General::readhash("/var/log/dhcpclient.info", \%dhcpinfo);

        my $lsetme=0;
        my $leasetime="";
        if ($dhcpinfo{'DHCLIENT_LEASETIME'} ne "") {
            $lsetme=$dhcpinfo{'DHCLIENT_LEASETIME'};
            $lsetme=($lsetme/60);
            if ($lsetme > 59) {
                $lsetme=($lsetme/60); $leasetime=$lsetme." Hour";
            } 
            else {
                $leasetime=$lsetme." Minute";
            }
            if ($lsetme > 1) {
                $leasetime=$leasetime."s";
            }
        }
        my $leaseexpires = localtime($dhcpinfo{'DHCLIENT_EXPIRY'});

        print "<table width='100%'>";
        if ($dhcpinfo{'DHCLIENT_HOSTNAME'}) {
            print "<tr><td width='30%'>$Lang::tr{'hostname'}:</td><td>$dhcpinfo{'DHCLIENT_HOSTNAME'}.$dhcpinfo{'DHCLIENT_DOMAIN'}</td></tr>\n";
        } 
        else {
            print "<tr><td width='30%'>$Lang::tr{'domain'}:</td><td>$dhcpinfo{'DHCLIENT_DOMAIN'}</td></tr>\n";
        }
        print <<END
    <tr><td>$Lang::tr{'gateway'}:</td><td>$dhcpinfo{'DHCLIENT_GATEWAY'}</td></tr>
    <tr><td>$Lang::tr{'primary dns'}:</td><td>$dhcpinfo{'DHCLIENT_DNS1'}</td></tr>
    <tr><td>$Lang::tr{'secondary dns'}:</td><td>$dhcpinfo{'DHCLIENT_DNS2'}</td></tr>
    <tr><td>$Lang::tr{'dhcp server'}:</td><td>$dhcpinfo{'DHCLIENT_SIADDR'}</td></tr>
    <tr><td>$Lang::tr{'def lease time'}:</td><td>$leasetime</td></tr>
    <tr><td>$Lang::tr{'lease expires'}:</td><td>$leaseexpires</td></tr>
</table>
END
    ;
    }
    else {
        print "$Lang::tr{'no dhcp lease'}";
    }
    &Header::closebox();
}

if ($dhcpserver > 0) {
    print "<a name='leases'/>";
    &General::CheckSortOrder;
    &General::PrintActualLeases;
}

if ( ($netsettings{'RED_COUNT'} == 0)  && (exists($pppsettings{'TYPE'})) ) {
    my $output1='';
    my $output2='';
    if ($pppsettings{'TYPE'} eq 'bewanadsl') {
        print "<a name='adsl'/>\n";
        &Header::openbox('100%', 'left', "$Lang::tr{'adsl settings'}:");
        $output1 = `/usr/bin/unicorn_status`;
        $output1 = &Header::cleanhtml($output1,"y");
        $output2 = `/bin/cat /proc/net/atm/UNICORN:*`;
        $output2 = &Header::cleanhtml($output2,"y");
        print "<pre>$output1$output2</pre>\n";
        &Header::closebox();
    }
    if ($pppsettings{'TYPE'} eq 'alcatelusbk') {
        print "<a name='adsl'/>\n";
        &Header::openbox('100%', 'left', "$Lang::tr{'adsl settings'}:");
        $output = `/bin/cat /proc/net/atm/speedtch:*`;
        $output = &Header::cleanhtml($output,"y");
        print "<pre>$output</pre>\n";
        &Header::closebox();
    }
    if ($pppsettings{'TYPE'} eq 'conexantpciadsl') {
        print "<a name='adsl'/>\n";
        &Header::openbox('100%', 'left', "$Lang::tr{'adsl settings'}:");
        $output = `/bin/cat /proc/net/atm/CnxAdsl:*`;
        $output = &Header::cleanhtml($output,"y");
        print "<pre>$output</pre>\n";
        &Header::closebox();
    }
    if ($pppsettings{'TYPE'} eq 'eagleusbadsl') {
        print "<a name='adsl'/>\n";
        &Header::openbox('100%', 'left', "$Lang::tr{'adsl settings'}:");
        $output = `/usr/sbin/eaglestat`;
        $output = &Header::cleanhtml($output,"y");
        print "<pre>$output</pre>\n";
        &Header::closebox();
    }
    if ($pppsettings{'TYPE'} eq 'wanpipe') {
        print "<a name='adsl'/>\n";
        &Header::openbox('100%', 'left', "$Lang::tr{'adsl settings'}:");
        $output = `/bin/cat /proc/net/wanrouter/config | /usr/bin/sort`;
        $output = &Header::cleanhtml($output,"y");
        print "<pre>$output</pre>\n";
        &Header::closebox();
    }
}

print "<a name='routing'/>\n";
&Header::openbox('100%', 'left', "$Lang::tr{'routing table entries'}:");
$output = `/sbin/route -n`;
$output = &Header::cleanhtml($output,"y");
$output = &General::color_devices($output);
print "<pre>$output</pre>\n";
&Header::closebox();

print "<a name='arp'/>\n";
&Header::openbox('100%', 'left', "$Lang::tr{'arp table entries'}:");
$output = `/sbin/arp -n`;
$output = &Header::cleanhtml($output,"y");
$output = &General::color_devices($output);
print "<pre>$output</pre>\n";
&Header::closebox();

&Header::closebigbox();

&Header::closepage();
