#!/usr/bin/perl
#
# SmoothWall CGIs
#
# This code is distributed under the terms of the GPL
#
# (c) The SmoothWall Team
#
# $Id: ddns.cgi 3122 2009-06-25 10:55:55Z owes $
#

# Add entry in menu
# MENUENTRY services 030 "dynamic dns" "dynamic dns client"
#
# Make sure translation exists $Lang::tr{'dynamic dns client'}

use strict;

# enable only the following on debugging purpose
#use warnings; no warnings 'once';# 'redefine', 'uninitialized';
#use CGI::Carp 'fatalsToBrowser';

require '/usr/lib/ipcop/general-functions.pl';
require "/usr/lib/ipcop/lang.pl";
require '/usr/lib/ipcop/header.pl';

my $ddnsprefix = $Lang::tr{'ddns noip prefix'};
$ddnsprefix =~ s/%/$General::noipprefix/;

# Files used
my $setting = '/var/ipcop/ddns/settings';
our $datafile = '/var/ipcop/ddns/config';
my $logDirName = '/var/log/dyndns';

my %settings = ();

#Settings1
$settings{'BEHINDROUTER'}    = 'RED_IP';
$settings{'MINIMIZEUPDATES'} = '';

#Settings2 for editing the multi-line list
#Must not be saved !
$settings{'HOSTNAME'}  = '';
$settings{'DOMAIN'}    = '';
$settings{'LOGIN'}     = '';
$settings{'PASSWORD'}  = '';
$settings{'ENABLED'}   = '';
$settings{'PROXY'}     = '';
$settings{'WILDCARDS'} = '';
$settings{'SERVICE'}   = '';

my @nosaved =
    ('HOSTNAME', 'DOMAIN', 'LOGIN', 'PASSWORD', 'ENABLED', 'PROXY', 'WILDCARDS', 'SERVICE')
    ;    # List here ALL setting2 fields. Mandatory

$settings{'ACTION'} = '';    # add/edit/remove
$settings{'KEY1'}   = '';    # point record for ACTION
$settings{'KEY2'}   = '';    # point record for ACTION

my $errormessage = '';
my $error        = '';
my $warnmessage  = '';

my %va;                      # validate table+listboxname if different from hash name.

# Select mandatory fields for each service
$va{'cjb.net'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 0, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'dhs.org'} =
    {LOGIN => 1, HOSTNAME => 1, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'dnsmadeeasy.com'} =
    {LOGIN => 1, HOSTNAME => 1, DOMAIN => 0, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help dnsmadeeasy'}};

#Note: HOSTNAME as ID may content a list but the comma is not allowed char ...!
$va{'dnspark.com'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'dtdns.com'} =
    {LOGIN => 1, HOSTNAME => 1, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'dyndns.org'} =
    {LOGIN => 1, HOSTNAME => 1, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'dyndns-custom'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'dyndns-static'} =
    {LOGIN => 1, HOSTNAME => 1, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'dyns.cx'} =
    {LOGIN => 1, HOSTNAME => 1, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'dynu.ca'} = {
    LOGIN    => 1,
    HOSTNAME => 1,
    DOMAIN   => 1,
    PASSWORD => 1,
    LBNAME   => 'dynu.ca dyn.ee dynserv.(ca|org|net|com)',
    HELP     => $Lang::tr{'ddns help plus'}
};
$va{'easydns.com'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'editdns.net'} =
    {LOGIN => 0, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'enom.com'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'everydns.net'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'freedns.afraid.org'} = {
    LOGIN    => 1,
    HOSTNAME => 0,
    DOMAIN   => 0,
    PASSWORD => 0,
    LBNAME   => '',
    HELP     => $Lang::tr{'ddns help freedns'}
};    # connect string is in LOGIN field
$va{'namecheap.com'} =
    {LOGIN => 0, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'no-ip.com'} = {LOGIN => 1, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $ddnsprefix};
$va{'nsupdate'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'ods.org'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'opendns.com'} =
    {LOGIN => 1, HOSTNAME => 1, DOMAIN => 0, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'ovh.com'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'regfish.com'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 0, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'registerfly.com'} =
    {LOGIN => 0, HOSTNAME => 1, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'selfhost.de'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 0, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'sitelutions.com'} =
    {LOGIN => 1, HOSTNAME => 1, DOMAIN => 0, PASSWORD => 1, LBNAME => '', HELP => 'Put record-id in hostname field'};
$va{'strato.com'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};
$va{'tiggerswelt.net'} =
    {LOGIN => 1, HOSTNAME => 1, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};

#$va{'tzo.com'}     = { LOGIN=>1,   HOSTNAME=>1, DOMAIN=>1, PASSWORD=>1, LBNAME=>'', HELP=>$Lang::tr{'ddns help plus'} };  # comment this service out until a working fix is developed
$va{'zoneedit.com'} =
    {LOGIN => 1, HOSTNAME => 0, DOMAIN => 1, PASSWORD => 1, LBNAME => '', HELP => $Lang::tr{'ddns help plus'}};

&Header::showhttpheaders();

#Get GUI values
&General::getcgihash(\%settings);

# Load multiline data
our @current = ();
if (open(FILE, "$datafile")) {
    @current = <FILE>;
    close(FILE);
}

#
# Check Settings1 first because they are needed before working on @current
#
if ($settings{'ACTION'} eq $Lang::tr{'save'}) {

    # No user input to check.  !
    #unless ($errormessage) {                   # Everything is ok, save settings
    map (delete($settings{$_}), (@nosaved, 'ACTION', 'KEY1', 'KEY2'));    # Must never be saved
    &General::writehash($setting, \%settings);                            # Save good settings
    $settings{'ACTION'} = $Lang::tr{'save'};                              # Recreate  'ACTION'
    map ($settings{$_} = '', (@nosaved, 'KEY1', 'KEY2'));                 # and reinit var to empty

    # $logDirName/fetchIpState file is not writable from webgui,
    # but if I change the settings I would do a [Force Update] anyway.
    # So don't init the fetchIpState file, if it is already there, it will be re-written
    # in next 5-15 minutes.

    #}
}
else {
    &General::readhash($setting, \%settings);    # Get saved settings and reset to good if needed
}

#
# Now manipulate the multi-line list with Settings2
#
# Toggle enable/disable field.  Field is in second position
if ($settings{'ACTION'} eq $Lang::tr{'toggle enable disable'}) {

    #move out new line
    chomp(@current[ $settings{'KEY1'} ]);
    my @temp = split(/\,/, @current[ $settings{'KEY1'} ]);
    my $K2 = $settings{'KEY2'};
    $temp[$K2] = ($temp[$K2] eq 'on') ? '' : 'on';    # Toggle the field
    @current[ $settings{'KEY1'} ] = join(',', @temp) . "\n";
    $settings{'KEY1'} = '';                           # End edit mode
    &General::log($Lang::tr{'ddns hostname modified'});

    # Write changes to config file.
    &WriteDataFile;                                   # sort newly added/modified entry
}

if ($settings{'ACTION'} eq $Lang::tr{'add'}) {        # Validate inputs

    # list box returns 'service optional synonyms'
    # keep only first name
    $settings{'SERVICE'} =~ s/ .*$//;

    # check HOSTNAME field
    $errormessage = $Lang::tr{'hostname not set'}
        if ($va{$settings{'SERVICE'}}{HOSTNAME} && $settings{'HOSTNAME'} eq '');
    unless ($settings{'HOSTNAME'} =~ /^(|[a-zA-Z_;0-9-]+)$/) {
        $errormessage .= '<br>' . $Lang::tr{'invalid hostname'};
    }

    # check DOMAIN field; must contain at least one point followed by letters (.com => ok; com. => bad)
    $errormessage .= '<br>' . $Lang::tr{'domain not set'}
        if ($va{$settings{'SERVICE'}}{DOMAIN} && $settings{'DOMAIN'} eq '');
    unless ($settings{'DOMAIN'} =~ /^(|[a-zA-Z_0-9.-]*\.[a-zA-Z_0-9.-]+)$/) {
        $errormessage .= '<br>' . $Lang::tr{'invalid domain name'};
    }

    # check LOGIN field
    $errormessage .= '<br>' . $Lang::tr{'username not set'}
        if ($va{$settings{'SERVICE'}}{LOGIN} && $settings{'LOGIN'} eq '');

    # check PASSWORD field
    $errormessage .= '<br>' . $Lang::tr{'password not set'}
        if ($va{$settings{'SERVICE'}}{PASSWORD} && $settings{'PASSWORD'} eq '');

    # PASSWORD cannot contain a comma, it breaks the csv config file.
    $errormessage .= '<br>' . $Lang::tr{'password contains illegal characters'} . ': [,]'
        if ($settings{'PASSWORD'} =~ /,/);

    # proceed if no errors
    unless ($errormessage) {
        if ($settings{'KEY1'} eq '') {

            #add or edit ?
            unshift(@current,
"$settings{'SERVICE'},$settings{'HOSTNAME'},$settings{'DOMAIN'},$settings{'PROXY'},$settings{'WILDCARDS'},$settings{'LOGIN'},$settings{'PASSWORD'},$settings{'ENABLED'}\n"
            );
            &General::log($Lang::tr{'ddns hostname added'});
        }
        else {
            @current[ $settings{'KEY1'} ] =
"$settings{'SERVICE'},$settings{'HOSTNAME'},$settings{'DOMAIN'},$settings{'PROXY'},$settings{'WILDCARDS'},$settings{'LOGIN'},$settings{'PASSWORD'},$settings{'ENABLED'}\n";
            $settings{'KEY1'} = '';    # End edit mode
            &General::log($Lang::tr{'ddns hostname modified'});
        }
        map ($settings{$_} = '', @nosaved);    # Clear fields
                                               # Write changes to config file.
        &WriteDataFile;                        # sort newly added/modified entry
    }
}

if ($settings{'ACTION'} eq $Lang::tr{'edit'}) {

    #move out new line
    my $line = @current[ $settings{'KEY1'} ];    # KEY1 is the index in current
    chomp($line);
    my @temp = split(/\,/, $line);
    $settings{'SERVICE'}   = $temp[0];
    $settings{'HOSTNAME'}  = $temp[1];
    $settings{'DOMAIN'}    = $temp[2];
    $settings{'PROXY'}     = $temp[3];
    $settings{'WILDCARDS'} = $temp[4];
    $settings{'LOGIN'}     = $temp[5];
    $settings{'PASSWORD'}  = $temp[6];
    $settings{'ENABLED'}   = $temp[7];
}

if ($settings{'ACTION'} eq $Lang::tr{'remove'}) {
    splice(@current, $settings{'KEY1'}, 1);    # Delete line
    open(FILE, ">$datafile") or die 'ddns datafile error';
    print FILE @current;
    close(FILE);
    $settings{'KEY1'} = '';                    # End remove mode
    &General::log($Lang::tr{'ddns hostname removed'});

    # Write changes to config file.
    &WriteDataFile;
}

if ($settings{'ACTION'} eq $Lang::tr{'instant update'}) {
    system('/usr/local/bin/setddns.pl', '-f');
}

if ($settings{'SERVICE'} eq '') {
    $settings{'SERVICE'} = 'dyndns.org';
    $settings{'ENABLED'} = 'on';
}

&Header::openpage($Lang::tr{'dynamic dns'}, 1, '');
&Header::openbigbox('100%', 'left', '');

my %checked = ();    # Checkbox manipulations
$checked{'BEHINDROUTER'}{'RED_IP'}                  = '';
$checked{'BEHINDROUTER'}{'FETCH_IP'}                = '';
$checked{'BEHINDROUTER'}{$settings{'BEHINDROUTER'}} = "checked='checked'";
$checked{'MINIMIZEUPDATES'} = ($settings{'MINIMIZEUPDATES'} eq '') ? '' : "checked='checked'";
$checked{'PROXY'}{'on'}     = ($settings{'PROXY'}           eq '') ? '' : "checked='checked'";
$checked{'WILDCARDS'}{'on'} = ($settings{'WILDCARDS'}       eq '') ? '' : "checked='checked'";
$checked{'ENABLED'}{'on'}   = ($settings{'ENABLED'}         eq '') ? '' : "checked='checked'";

if ($errormessage) {
    &Header::openbox('100%', 'left', "$Lang::tr{'error messages'}:", 'error');
    print "<font class='base'>$errormessage&nbsp;</font>";
    &Header::closebox();

    $error = 'error';
}

if ($warnmessage) {
    $warnmessage = "<font color=${Header::colourred}><b>$Lang::tr{'capswarning'}</b></font>: $warnmessage";
}

&Header::openbox('100%', 'left', $Lang::tr{'settings'});
print "<form method='post' action='$ENV{'SCRIPT_NAME'}'>";
print <<END
<table width='100%'>
<tr>
    <td class='base'>$Lang::tr{'dyn dns source choice'}:</td>
</tr><tr>
    <td class='base'><input type='radio' name='BEHINDROUTER' value='RED_IP' $checked{'BEHINDROUTER'}{'RED_IP'} />
    $Lang::tr{'use ipcop red ip'}</td>
</tr><tr>
    <td class='base'><input type='radio' name='BEHINDROUTER' value='FETCH_IP' $checked{'BEHINDROUTER'}{'FETCH_IP'} />
    $Lang::tr{'fetch ip from'} <img src='/blob.gif' alt='*' /></td>
</tr><tr>
    <td class='base'><input type='checkbox' name='MINIMIZEUPDATES' $checked{'MINIMIZEUPDATES'} />
    $Lang::tr{'ddns minimize updates'}</td>
</tr>
</table>
<br /><hr />
END
    ;

print <<END
<table width='100%'>
<tr>
    <td class='comment1button'><img src='/blob.gif' align='top' alt='*' />&nbsp;$Lang::tr{'avoid dod'}</td>
    <td class='button1button'><input type='submit' name='ACTION' value='$Lang::tr{'save'}' /></td>
    <td class='onlinehelp'>
        <a href='${General::adminmanualurl}/services-dyndns.html' target='_blank'><img src='/images/web-support.png' alt='$Lang::tr{'online help en'}' title='$Lang::tr{'online help en'}' /></a>
    </td>
</tr>
</table>
</form>
END
    ;
&Header::closebox();    # end of Settings1

my $buttontext = $Lang::tr{'add'};
if ($settings{'KEY1'} ne '') {
    $buttontext = $Lang::tr{'update'};
    &Header::openbox('100%', 'left', $Lang::tr{'edit an existing host'}, $error);
}
else {
    &Header::openbox('100%', 'left', "$Lang::tr{'add a host'}:", $error);
}

# based selected service, prepare an icon for signaling mandatory fields
my $f1 = $va{$settings{'SERVICE'}}{'HOSTNAME'} ? '&nbsp;<b>+</b>' : '';
my $f2 = $va{$settings{'SERVICE'}}{'DOMAIN'}   ? '&nbsp;<b>+</b>' : '';
my $f3 = $va{$settings{'SERVICE'}}{'LOGIN'}    ? '&nbsp;<b>+</b>' : '';
my $f4 = $va{$settings{'SERVICE'}}{'PASSWORD'} ? '&nbsp;<b>+</b>' : '';

# build the listbox with service names
my $listboxcontent = "<select size='1' name='SERVICE'>";
foreach my $key (sort keys %va) {
    $listboxcontent .= '<option ' . ($settings{'SERVICE'} eq $key ? "selected='selected'>" : '>');
    $listboxcontent .= $va{$key}{'LBNAME'} ? $va{$key}{'LBNAME'} : $key;
    $listboxcontent .= '</option>';
}
$listboxcontent .= '</select>';

#Edited line number (KEY1) passed until cleared by 'save' or 'remove'
print <<END
<form method='post' action='$ENV{'SCRIPT_NAME'}'>
<input type='hidden' name='KEY1' value='$settings{'KEY1'}' />
<table width='100%' border='0'>
<tr>
    <td width='25%' class='base'>$Lang::tr{'service'}:</td>
    <td width='25%'>$listboxcontent</td>
    <td width='5%'>&nbsp;</td>
    <td width='20%' class='base'>$Lang::tr{'hostname'}:</td>
    <td width='20%'><input type='text' name='HOSTNAME' value='$settings{'HOSTNAME'}' /></td>
    <td width='5%'>$f1</td>
</tr><tr>
    <td class='base'>$Lang::tr{'behind a proxy'}:</td>
    <td><input type='checkbox' name='PROXY' value='on' $checked{'PROXY'}{'on'} /></td>
    <td></td>
    <td class='base'>$Lang::tr{'domain'}:</td>
    <td><input type='text' name='DOMAIN' value='$settings{'DOMAIN'}' /></td>
    <td>$f2</td>
</tr><tr>
    <td class='base'>$Lang::tr{'enable wildcards'}:</td>
    <td><input type='checkbox' name='WILDCARDS' value='on' $checked{'WILDCARDS'}{'on'} /></td>
    <td></td>
    <td class='base'>$Lang::tr{'username'}:</td>
    <td><input type='text' name='LOGIN' value='$settings{'LOGIN'}' /></td>
    <td>$f3</td>
</tr><tr>
    <td></td>
    <td></td>
    <td></td>
    <td class='base'>$Lang::tr{'password'}:</td>
    <td><input type='password' name='PASSWORD' value='$settings{'PASSWORD'}' /></td>
    <td>$f4</td>
</tr><tr>
    <td class='base'>$Lang::tr{'enabled'}:</td>
    <td><input type='checkbox' name='ENABLED' value='on' $checked{'ENABLED'}{'on'} /></td>
    <td colspan='4'></td>
</tr>
</table>
<hr />
<table width='100%'>
<tr>
    <td class='comment1button'>&nbsp;$va{ $settings{'SERVICE'} }{'HELP'}</td>
    <td class='button1button'>
    <input type='hidden' name='ACTION' value='$Lang::tr{'add'}' />
    <input type='submit' name='SUBMIT' value='$buttontext' /></td>
    <td class='onlinehelp'>&nbsp;</td>
</tr>
</table>
</form>
END
    ;
&Header::closebox();

#
# Third box shows the list, in columns
#
&Header::openbox('100%', 'left', "$Lang::tr{'current hosts'}:");
print <<END
<table width='100%'>
<tr>
    <td width='15%' align='center' class='boldbase'><b>$Lang::tr{'service'}</b></td>
    <td width='25%' align='center' class='boldbase'><b>$Lang::tr{'hostname'}</b></td>
    <td width='30%' align='center' class='boldbase'><b>$Lang::tr{'domain'}</b></td>
    <td width='10%' align='center' class='boldbase'><b>$Lang::tr{'proxy'}</b></td>
    <td width='10%' align='center' class='boldbase'><b>$Lang::tr{'wildcards'}</b></td>
    <td width='10%' colspan='3' class='boldbase' align='center'><b>$Lang::tr{'action'}</b></td>
</tr>
END
    ;
my $ip  = &General::GetDyndnsRedIP;
my $key = 0;
foreach my $line (@current) {
    chomp($line);    # remove newline
    my @temp = split(/\,/, $line);

    if ($temp[0] eq 'no-ip.com') {
        $temp[1] =~ s!$General::noipprefix(.*)!<b>group:</b>$1 !;
    }

    #Choose icon for checkbox

    my $gifproxy  = '';
    my $descproxy = '';
    if ($temp[3] eq "on") {
        $gifproxy  = 'on.gif';
        $descproxy = $Lang::tr{'click to disable'};
    }
    else {
        $gifproxy  = 'off.gif';
        $descproxy = $Lang::tr{'click to enable'};
    }

    my $gifwildcard  = '';
    my $descwildcard = '';
    if ($temp[4] eq "on") {
        $gifwildcard  = 'on.gif';
        $descwildcard = $Lang::tr{'click to disable'};
    }
    else {
        $gifwildcard  = 'off.gif';
        $descwildcard = $Lang::tr{'click to enable'};
    }

    my $sync  = "blue";
    my $gif   = '';
    my $gdesc = '';
    if ($temp[7] eq "on") {
        $gif   = 'on.gif';
        $gdesc = $Lang::tr{'click to disable'};
        my $ipCacheFile = "$logDirName/$temp[0].$temp[1].$temp[2]";
        $sync = (-e $ipCacheFile && ($ip eq `cat $ipCacheFile`) ? "green" : "red");
    }
    else {
        $gif   = 'off.gif';
        $gdesc = $Lang::tr{'click to enable'};
    }

    #Colorize each line
    if ($settings{'KEY1'} eq $key) {
        print "<tr class='selectcolour'>";
    }
    else {
        print "<tr class='table".int(($key % 2) + 1)."colour'>";
    }

    #if a field is empty, replace it with a '---' to see colorized info!
    $temp[1] = '---' if (!$temp[1]);
    $temp[2] = '---' if (!$temp[2]);

    print <<END
<td align='center'><a href='http://$temp[0]'>$temp[0]</a></td>
<td align='center'><font color='$sync'>$temp[1]</font></td>
<td align='center'><font color='$sync'>$temp[2]</font></td>

<td align='center'>
<form method='post' action='$ENV{'SCRIPT_NAME'}'>
<input type='hidden' name='ACTION' value='$Lang::tr{'toggle enable disable'}' />
<input type='image' name='$Lang::tr{'toggle enable disable'}' src='/images/$gifproxy' alt='$descproxy' title='$descproxy' />
<input type='hidden' name='KEY1' value='$key' />
<input type='hidden' name='KEY2' value='3' />
</form>
</td>

<td align='center'>
<form method='post' action='$ENV{'SCRIPT_NAME'}'>
<input type='hidden' name='ACTION' value='$Lang::tr{'toggle enable disable'}' />
<input type='image' name='$Lang::tr{'toggle enable disable'}' src='/images/$gifwildcard' alt='$descwildcard' title='$descwildcard' />
<input type='hidden' name='KEY1' value='$key' />
<input type='hidden' name='KEY2' value='4' />
</form>
</td>

<td align='center'>
<form method='post' action='$ENV{'SCRIPT_NAME'}'>
<input type='hidden' name='ACTION' value='$Lang::tr{'toggle enable disable'}' />
<input type='image' name='$Lang::tr{'toggle enable disable'}' src='/images/$gif' alt='$gdesc' title='$gdesc' />
<input type='hidden' name='KEY1' value='$key' />
<input type='hidden' name='KEY2' value='7' />
</form>
</td>

<td align='center'>
<form method='post' action='$ENV{'SCRIPT_NAME'}'>
<input type='hidden' name='ACTION' value='$Lang::tr{'edit'}' />
<input type='image' name='$Lang::tr{'edit'}' src='/images/edit.gif' alt='$Lang::tr{'edit'}' title='$Lang::tr{'edit'}' />
<input type='hidden' name='KEY1' value='$key' />
</form>
</td>

<td align='center'>
<form method='post' action='$ENV{'SCRIPT_NAME'}'>
<input type='hidden' name='ACTION' value='$Lang::tr{'remove'}' />
<input type='image' name='$Lang::tr{'remove'}' src='/images/delete.gif' alt='$Lang::tr{'remove'}' title='$Lang::tr{'remove'}' />
<input type='hidden' name='KEY1' value='$key' />
</form>
</td>
</tr>
END
        ;
    $key++;
}
print "</table>";

# If table contains entries, print 'Key to action icons'
if ($key) {
    print <<END
<table width='100%'>
<tr>
    <td class='boldbase'>&nbsp;<b>$Lang::tr{'legend'}:&nbsp;</b></td>
    <td><img src='/images/on.gif' alt='$Lang::tr{'click to disable'}' /></td>
    <td class='base'>$Lang::tr{'click to disable'}</td>
    <td>&nbsp;&nbsp;</td>
    <td><img src='/images/off.gif' alt='$Lang::tr{'click to enable'}' /></td>
    <td class='base'>$Lang::tr{'click to enable'}</td>
    <td>&nbsp;&nbsp;</td>
    <td><img src='/images/edit.gif' alt='$Lang::tr{'edit'}' /></td>
    <td class='base'>$Lang::tr{'edit'}</td>
    <td>&nbsp;&nbsp;</td>
    <td><img src='/images/delete.gif' alt='$Lang::tr{'remove'}' /></td>
    <td class='base'>$Lang::tr{'remove'}</td>
    <form method='post' action='$ENV{'SCRIPT_NAME'}'>
        <td align='center' width='30%'><input type='submit' name='ACTION' value='$Lang::tr{'instant update'}' /></td>
    </form>
</tr>
</table>
END
        ;
}

&Header::closebox();
&Header::closebigbox();
&Header::closepage();

## Ouf it's the end !

# write the "current" array
sub WriteDataFile {

    #Save current
    open(FILE, ">$datafile") or die 'ddns datafile error';
    print FILE @current;
    close(FILE);
}
