#!/usr/bin/perl
#
# This file is part of the IPCop Firewall.
#
# IPCop is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# IPCop is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with IPCop; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# (c) 2006-2008, the IPCop team
#
# $Id: updatelists.pl 2343 2009-01-14 18:51:30Z owes $
#

use strict;
use LWP::UserAgent;
require '/usr/lib/ipcop/general-functions.pl';

if ($ARGV[0] eq 'fcron') {
    exit 0 unless (-e "/var/ipcop/red/active");

    # Connection is up. Check age of file.
    exit 0 unless (system('find /var/ipcop/red/active -mtime +1 | grep active > /dev/null') == 0);

    # spread the load on the servers by waiting a random length of time...
    my $sleepwait = int(rand(600));
    sleep $sleepwait;
}

my @this;
my $return = &General::download();
if ($return && $return->is_success) {
    unless (open(LIST, ">/var/ipcop/patches/available")) {
        die "Could not open available lists database.";
    }
    flock LIST, 2;
    @this = split(/----START LIST----\n/, $return->content);
    print LIST $this[1];
    close(LIST);
}
else {
    die "Could not download patches list.";
}
