#!/usr/bin/perl
#
# IPCop CGIs
#
# This file is part of the IPCop Firewall.
#
# IPCop is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# IPCop is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with IPCop; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# (c) 2007-2008, the IPCop team
#
# Copyright (c) 2007-11-13 owes  This is almost a full cleanup, texts are now fetched from .MO files.
#
# $Id: lang.pl 2343 2009-01-14 18:51:30Z owes $
#

package Lang;
require '/usr/lib/ipcop/general-functions.pl';
use Locale::Maketext::Gettext::Functions;
use strict;

# Get selected language
my %settings = ();
&General::readhash('/var/ipcop/main/settings', \%settings);

# Setup for __('text')
bindtextdomain("ipcop", "/usr/share/locale");
textdomain("ipcop");

# Set language variable used by makegraphs script
our $language;
$language = $settings{'LANGUAGE'};

# Use reload function
reload($settings{'LOCALE'});

# reload is also used when changing languages in the GUI
# call with something like "en_GB", "de_DE", "fr_FR" etc.
sub reload
{
    my $L = shift;

    # Set locale for __('text')
    get_handle($L);

    # Get lexicon for $Lang :: tr{'text'}
    #   (note: 2 spaces intentionally added around :: so 'text' is not added to .po file)
    %Lang::tr = read_mo("/usr/share/locale/$L/LC_MESSAGES/ipcop.mo");

    # set admin manual URL
    if ($L eq 'de_DE') {
        $General::adminmanualurl = 'http://www.ipcop-forum.de/manuals/online/ipcop-admin-chunk-de-2.0.x';
    }
    else {
        $General::adminmanualurl = 'http://www.ipcop.org/2.0.0/en/admin/html';
    }
}

1;
