#!/usr/bin/perl
#
# SmoothWall CGIs
#
# This code is distributed under the terms of the GPL
#
# (c) The SmoothWall Team
#
# $Id: status.cgi 2709 2009-04-13 19:26:06Z owes $
#

use strict;

# enable only the following on debugging purpose
use warnings; no warnings 'once';# 'redefine', 'uninitialized';
use CGI::Carp 'fatalsToBrowser';

require '/usr/lib/ipcop/general-functions.pl';
require '/usr/lib/ipcop/lang.pl';
require '/usr/lib/ipcop/header.pl';

my %netsettings=();
&General::readhash('/var/ipcop/ethernet/settings', \%netsettings);

# Maps a nice printable name to the changing part of the pid file, which
# is also the name of the program
my %servicenames =
(
    $Lang::tr{'dhcp server'} => 'dhcpd',
    $Lang::tr{'dns proxy server'} => 'dnsmasq/dnsmasq',
    $Lang::tr{'web server'} => 'httpd',
    $Lang::tr{'cron server'} => 'fcron',
    $Lang::tr{'logging server'} => 'syslogd',
    $Lang::tr{'kernel logging server'} => 'klogd',
    $Lang::tr{'ntp server'} => 'ntpd',
    $Lang::tr{'secure shell server'} => 'sshd',
    $Lang::tr{'ipsec server'} => 'pluto/pluto',
    $Lang::tr{'openvpn server'}  => 'openvpn',
    $Lang::tr{'web proxy'} => 'squid'
);

&Header::showhttpheaders();

&Header::openpage($Lang::tr{'status information'}, 1, '');

&Header::openbigbox('100%', 'left');

my $araid = '';
$araid = "<a href='#raid'>$Lang::tr{'RAID status'}</a> |" if (-e "/proc/mdstat");

print <<END
<table width='100%' cellspacing='0' cellpadding='5' border='0'>
<tr><td style="background-color: #FFFFFF;" align='left'>
    <a href='#services'>$Lang::tr{'services'}</a> |
    <a href='#memory'>$Lang::tr{'memory'}</a> |
    <a href='#disk'>$Lang::tr{'disk usage'}</a> |
    <a href='#inodes'>$Lang::tr{'inodes usage'}</a> |
    $araid    
    <a href='#uptime'>$Lang::tr{'uptime and users'}</a> |
    <a href='#kernel'>$Lang::tr{'kernel version'}</a>
</td></tr></table>
END
;

print "<a name='services'/>\n";
&Header::openbox('100%', 'left', "$Lang::tr{'services'}:");

print <<END
<div align='center'>
<table width='60%' cellspacing='1' cellpadding='2' border='0'>
END
;

my $lines = 0;
my $key = '';
foreach $key (sort keys %servicenames)
{
    my $tid = ($lines % 2) + 1;
    print "<tr class='table${tid}colour'>\n"; 
    print "<td align='left'>$key</td>\n";
    my $shortname = $servicenames{$key};
    my $status = &General::isrunning($shortname);
    print "$status\n";
    print "</tr>\n";
    $lines++;
}


print "</table></div>\n";

&Header::closebox();

print "<a name='memory'/>\n";
&Header::openbox('100%', 'left', "$Lang::tr{'memory'}:");
print "<table><tr><td><table>";
my $ram=0;
my $size=0;
my $used=0;
my $free=0;
my $percent=0;
my $shared=0;
my $buffers=0;
my $cached=0;
open(FREE,'/usr/bin/free |');
while(<FREE>)
{
    if ($_ =~ m/^\s+total\s+used\s+free\s+shared\s+buffers\s+cached$/ ) {
        print <<END
<tr>
<td>&nbsp;</td>
<td align='center' class='boldbase'>$Lang::tr{'size'}</td>
<td align='center' class='boldbase'>$Lang::tr{'used'}</td>
<td align='center' class='boldbase'>$Lang::tr{'free'}</td>
<td align='left' class='boldbase' colspan='2'>$Lang::tr{'percentage'}</td>
</tr>
END
;
        }
        else {
            if ($_ =~ m/^Mem:\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)$/) {
                ($ram,$size,$used,$free,$shared,$buffers,$cached) = ($1,$1,$2,$3,$4,$5,$6);
                ($percent = ($used/$size)*100) =~ s/^(\d+)(\.\d+)?$/$1%/;
                print <<END
<tr>
<td class='boldbase'>$Lang::tr{'ram'}</td>
<td align='right'>$size</td>
END
;
                } 
                elsif ($_ =~ m/^Swap:\s+(\d+)\s+(\d+)\s+(\d+)$/) {
                    ($size,$used,$free) = ($1,$2,$3);
                    if ($size != 0) {
                        ($percent = ($used/$size)*100) =~ s/^(\d+)(\.\d+)?$/$1%/;
                    }
                    else {
                        ($percent = '');
                    }
                    print <<END
<tr>
<td class='boldbase'>$Lang::tr{'swap'}</td>
<td align='right'>$size</td>
END
;
                    }
                    elsif ($ram and $_ =~ m/^-\/\+ buffers\/cache:\s+(\d+)\s+(\d+)$/ ) {
                        ($used,$free) = ($1,$2);
                        ($percent = ($used/$ram)*100) =~ s/^(\d+)(\.\d+)?$/$1%/;
                        print "<tr><td colspan='2' class='boldbase'>$Lang::tr{'excluding buffers and cache'}</td>"
                    }
                    print <<END
<td align='right'>$used</td>
<td align='right'>$free</td>
<td>
END
;
                    &Header::percentbar($percent);
                    print <<END
</td>
<td align='right'>$percent</td>
</tr>
END
;
    }
}
close FREE;
print <<END
</table></td><td>
<table>
<tr><td class='boldbase'>$Lang::tr{'shared'}</td><td align='right'>$shared</td></tr>
<tr><td class='boldbase'>$Lang::tr{'buffers'}</td><td align='right'>$buffers</td></tr>
<tr><td class='boldbase'>$Lang::tr{'cached'}</td><td align='right'>$cached</td></tr>
</table>
</td></tr></table>
END
;
&Header::closebox();

print "<a name='disk'/>\n";
&Header::openbox('100%', 'left', "$Lang::tr{'disk usage'}:");
print "<table>\n";

print <<END
<tr>
<td align='left' class='boldbase'>$Lang::tr{'device'}</td>
<td align='left' class='boldbase'>$Lang::tr{'mounted on'}</td>
<td align='center' class='boldbase'>$Lang::tr{'size'}</td>
<td align='center' class='boldbase'>$Lang::tr{'used'}</td>
<td align='center' class='boldbase'>$Lang::tr{'free'}</td>
<td align='left' class='boldbase' colspan='2'>$Lang::tr{'percentage'}</td>
</tr>
END
;

open(DF,'/bin/df -B M -x rootfs|');
my @df = <DF>;
close DF;

# skip first line:
# Filesystem            Size  Used Avail Use% Mounted on
shift(@df);
chomp(@df);
# merge all lines to one single line separated by spaces
my $all_inOneLine=join(' ',@df);

# now get all entries in an array
my @all_entries=split(' ',$all_inOneLine);

# loop over all entries. Six entries belong together.
while (@all_entries > 0) {
    my $device=shift(@all_entries);
    my $size=shift(@all_entries);
    my $used=shift(@all_entries);
    my $free=shift(@all_entries);
    my $percent=shift(@all_entries);
    my $mount=shift(@all_entries);
    next if ($mount eq "/dev");
    print <<END
<tr>
<td>$device</td>
<td>$mount</td>
<td align='right'>$size</td>
<td align='right'>$used</td>
<td align='right'>$free</td>
<td>
END
;
    &Header::percentbar($percent);
    print <<END
</td>
<td align='right'>$percent</td>
</tr>
END
;

}
print "</table>\n";
&Header::closebox();

print "<a name='inodes'/>\n";
&Header::openbox('100%', 'left', $Lang::tr{'inodes usage'}.':');
print "<table>\n";

print <<END
<tr>
<td align='left' class='boldbase'>$Lang::tr{'device'}</td>
<td align='left' class='boldbase'>$Lang::tr{'mounted on'}</td>
<td align='center' class='boldbase'>Inodes</td>
<td align='center' class='boldbase'>$Lang::tr{'used'}</td>
<td align='center' class='boldbase'>$Lang::tr{'free'}</td>
<td align='left' class='boldbase' colspan='2'>$Lang::tr{'percentage'}</td>
</tr>
END
;

open(DF,'/bin/df -i -x rootfs|');
@df = <DF>;
close DF;

# skip first line:
# Filesystem            Inodes  IUsed IFree IUse% Mounted on
shift(@df);
chomp(@df);
# merge all lines to one single line seperated by spaces
$all_inOneLine=join(' ',@df);

# now get all entries in an array
@all_entries=split(' ',$all_inOneLine);

# loop over all entries. Six entries belong together.
while (@all_entries > 0) {
    my $device=shift(@all_entries);
    my $size=shift(@all_entries);
    my $used=shift(@all_entries);
    my $free=shift(@all_entries);
    my $percent=shift(@all_entries);
    my $mount=shift(@all_entries);
    next if ($mount eq "/dev");
    print <<END
<tr>
<td>$device</td>
<td>$mount</td>
<td align='right'>$size</td>
<td align='right'>$used</td>
<td align='right'>$free</td>
<td>
END
;
    &Header::percentbar($percent);
    print <<END
</td>
<td align='right'>$percent</td>
</tr>
END
;

}
print "</table>\n";
&Header::closebox();

if (-e "/proc/mdstat") {
    print "<a name='raid'/>\n";
    &Header::openbox('100%', 'left', "$Lang::tr{'RAID status'}:");
    print <<END
<table cellspacing='1' cellpadding='2' border='0'><tr>
    <td align='left' class='boldbase'>$Lang::tr{'device'}</td>
    <td align='left' class='boldbase'>$Lang::tr{'status'}</td>
    <td align='center' class='boldbase'>Active</td>
    <td align='center' class='boldbase'>Working</td>
    <td align='center' class='boldbase'>Failed</td>
</tr>
END
;
    for (my $i=0; $i < 2; $i++) {
        my $state = "";
        my $rowtext = "<td align='center'>md$i</td>";

        open(MDADM, "/usr/local/bin/sysinfo --raid=md$i |");
        while(<MDADM>) {
            if ($_ =~ m/^\s+State\s+:\s+(.*)\s*$/) {
                my $field = &Header::cleanhtml($1,"y");
                $rowtext .= "<td>$field</td>";
                $state = "class='ipcop_error'" if (($field ne 'clean') && ($field ne 'active'));
            }
            elsif ($_ =~ m/^\s*Active Devices\s+:\s+(\d+).*$/) {
                $rowtext .= "<td align='center'>$1</td>";
            }
            elsif ($_ =~ m/^\s*Working Devices\s+:\s+(\d+).*$/) {
                $rowtext .= "<td align='center'>$1</td>";
            }
            elsif ($_ =~ m/^\s*Failed Devices\s+:\s+(\d+).*$/) {
                $rowtext .= "<td align='center'>$1</td>";
            }
        }
        close MDADM;

        print "<tr $state>$rowtext</tr>";
    }
    print "</table>\n";
    &Header::closebox();
}

print "<a name='uptime'/>\n";
&Header::openbox('100%', 'left', "$Lang::tr{'uptime and users'}:");
my $output = `/usr/bin/w`;
$output = &Header::cleanhtml($output,"y");
print "<pre>\n$output</pre>\n";
&Header::closebox();

print "<a name='kernel'/>\n";
&Header::openbox('100%', 'left', "$Lang::tr{'kernel version'}:");
print `/bin/uname -o`." ".`/bin/uname -r`."<br />";
print `/bin/uname -v`."<br />";
print `/bin/uname -m`." ".`/bin/uname -p`." ".`/bin/uname -i`;
&Header::closebox();

&Header::closebigbox();

&Header::closepage();

