#!/usr/bin/perl
#
# SmoothWall CGIs
#
# This code is distributed under the terms of the GPL
#
# (c) The SmoothWall Team
#
# $Id: proxy.cgi 2343 2009-01-14 18:51:30Z owes $
#

use strict;

# enable only the following on debugging purpose
#use warnings;
#use CGI::Carp 'fatalsToBrowser';

require '/usr/lib/ipcop/general-functions.pl';
require '/usr/lib/ipcop/lang.pl';
require '/usr/lib/ipcop/header.pl';

my %proxysettings = ();
my %netsettings   = ();
my %mainsettings  = ();
my $errormessage  = '';
my $NeedDoHTML    = 1;

&General::readhash("/var/ipcop/ethernet/settings", \%netsettings);
&General::readhash("/var/ipcop/main/settings",     \%mainsettings);

&Header::showhttpheaders();

$proxysettings{'ACTION'} = '';
$proxysettings{'VALID'}  = '';

$proxysettings{'UPSTREAM_PROXY'}      = '';
$proxysettings{'UPSTREAM_USER'}       = '';
$proxysettings{'UPSTREAM_PASSWORD'}   = '';
$proxysettings{'ENABLED_GREEN_1'}     = 'off';
$proxysettings{'ENABLED_BLUE_1'}      = 'off';
$proxysettings{'CACHE_SIZE'}          = '50';
$proxysettings{'TRANSPARENT_GREEN_1'} = 'off';
$proxysettings{'TRANSPARENT_BLUE_1'}  = 'off';
$proxysettings{'MAX_SIZE'}            = '4096';
$proxysettings{'MIN_SIZE'}            = '0';
$proxysettings{'MAX_OUTGOING_SIZE'}   = '0';
$proxysettings{'MAX_INCOMING_SIZE'}   = '0';
$proxysettings{'LOGGING'}             = 'off';
$proxysettings{'PROXY_PORT'}          = '800';
$proxysettings{'EXTENSION_METHODS'}   = '';
$proxysettings{'NO_PROXY_LOCAL'}      = 'off';
$proxysettings{'NO_PROXY_EXTEND'}     = '';

&General::getcgihash(\%proxysettings);

my $needhup  = 0;
my $cachemem = '';

if ($proxysettings{'ACTION'} eq $Lang::tr{'save'}) {

    #assume error
    my $configerror = 1;

    if (   $proxysettings{'ENABLED_GREEN_1'} !~ /^(on|off)$/
        || $proxysettings{'TRANSPARENT_GREEN_1'} !~ /^(on|off)$/
        || $proxysettings{'ENABLED_BLUE_1'} !~ /^(on|off)$/
        || $proxysettings{'TRANSPARENT_BLUE_1'} !~ /^(on|off)$/
        || $proxysettings{'LOGGING'} !~ /^(on|off)$/
        || $proxysettings{'NO_PROXY_LOCAL'} !~ /^(on|off)$/)
    {
        $errormessage = $Lang::tr{'invalid input'};
        goto ERROR;
    }

    if (!(&General::validport($proxysettings{'PROXY_PORT'}))) {
        $errormessage = $Lang::tr{'invalid port'};
        goto ERROR;
    }
    if (!($proxysettings{'CACHE_SIZE'} =~ /^\d+/)
        || ($proxysettings{'CACHE_SIZE'} < 10))
    {
        $errormessage = $Lang::tr{'invalid cache size'};
        goto ERROR;
    }
    if (!($proxysettings{'MAX_SIZE'} =~ /^\d+/)) {
        $errormessage = $Lang::tr{'invalid maximum object size'};
        goto ERROR;
    }
    if (!($proxysettings{'MIN_SIZE'} =~ /^\d+/)) {
        $errormessage = $Lang::tr{'invalid minimum object size'};
        goto ERROR;
    }
    if (!($proxysettings{'MAX_OUTGOING_SIZE'} =~ /^\d+/)) {
        $errormessage = $Lang::tr{'invalid maximum outgoing size'};
        goto ERROR;
    }
    if (!($proxysettings{'MAX_INCOMING_SIZE'} =~ /^\d+/)) {
        $errormessage = $Lang::tr{'invalid maximum incoming size'};
        goto ERROR;
    }

    if (!($proxysettings{'EXTENSION_METHODS'} =~ /^(|[A-Z0-9 _-]+)$/)) {
        $errormessage = $Lang::tr{'squid extension methods invalid'};
        goto ERROR;
    }

    # this field is validated field by field to avoid unreadable regexp
    foreach my $term (split(/ +/, $proxysettings{'NO_PROXY_EXTEND'})) {
        if (!&General::validipormask($term)) {
            $errormessage = "$Lang::tr{'invalid input'} : $term";
            goto ERROR;
        }
    }

 # Quick parent proxy error checking of username and password info. If username password don't both exist give an error.
    my $proxy1 = 'YES';
    my $proxy2 = 'YES';
    if (($proxysettings{'UPSTREAM_USER'}     eq '')) { $proxy1 = ''; }
    if (($proxysettings{'UPSTREAM_PASSWORD'} eq '')) { $proxy2 = ''; }
    if ($proxysettings{'UPSTREAM_USER'} eq 'PASS') {
        $proxy1 = $proxy2 = 'PASS';
        $proxysettings{'UPSTREAM_PASSWORD'} = '';
    }
    if (($proxy1 ne $proxy2)) {
        $errormessage = $Lang::tr{'invalid upstream proxy username or password setting'};
        goto ERROR;
    }

    $_ = $proxysettings{'UPSTREAM_PROXY'};
    my ($remotehost, $remoteport) = (
/^(?:[a-zA-Z ]+\:\/\/)?(?:[A-Za-z0-9\_\.\-]*?(?:\:[A-Za-z0-9\_\.\-]*?)?\@)?([a-zA-Z0-9\.\_\-]*?)(?:\:([0-9]{1,5}))?(?:\/.*?)?$/
    );
    $remoteport = 80 if ($remoteport eq '');

    $proxysettings{'VALID'} = 'yes';
    &General::writehash("/var/ipcop/proxy/settings", \%proxysettings);

    #
    # NAH, 03-Jan-2004
    #
    my @free = `/usr/bin/free`;
    $free[1] =~ m/(\d+)/;
    $cachemem = int $1 / 10;
    if ($cachemem < 4096) {
        $cachemem = 4096;
    }
    if ($cachemem > $proxysettings{'CACHE_SIZE'} * 40) {
        $cachemem = ($proxysettings{'CACHE_SIZE'} * 40);
    }

    open(FILE, ">//var/ipcop/proxy/squid.conf") or die "Unable to write squid.conf file";
    flock(FILE, 2);
    print FILE <<END
shutdown_lifetime 5 seconds
icp_port 0
END
        ;
    print FILE "http_port $netsettings{'GREEN_1_ADDRESS'}:$proxysettings{'PROXY_PORT'}";
    print FILE ($proxysettings{'TRANSPARENT_GREEN_1'} eq 'on') ? " transparent\n" : "\n";

    print FILE "\nextension_methods $proxysettings{'EXTENSION_METHODS'}\n"
        if ($proxysettings{'EXTENSION_METHODS'} ne '');

    if (($netsettings{'BLUE_COUNT'} >= 1) && $proxysettings{'ENABLED_BLUE_1'} eq 'on') {
        print FILE "http_port $netsettings{'BLUE_1_ADDRESS'}:$proxysettings{'PROXY_PORT'}";
        print FILE ($proxysettings{'TRANSPARENT_BLUE_1'} eq 'on') ? " transparent\n" : "\n";
    }
    print FILE <<END

acl QUERY urlpath_regex cgi-bin \\?
no_cache deny QUERY

cache_effective_user squid
cache_effective_group squid

pid_filename /var/run/squid.pid

END
        ;

    if ($proxysettings{'LOGGING'} eq 'on') {
        print FILE <<END
cache_access_log /var/log/squid/access.log
cache_log /var/log/squid/cache.log
cache_store_log none

END
            ;
    }
    else {
        print FILE <<END
cache_access_log /dev/null
cache_log /dev/null
cache_store_log none

END
            ;
    }
    print FILE <<END
log_mime_hdrs off
forwarded_for off

END
        ;

    #Evaluate the forbidden proxy destination
    my $no_proxy_dst = '';
    if ($proxysettings{'NO_PROXY_LOCAL'} eq 'on') {
        $no_proxy_dst = "$netsettings{'GREEN_1_NETADDRESS'}/$netsettings{'GREEN_1_NETMASK'}";
        if ($netsettings{'BLUE_COUNT'} >= 1) {
            $no_proxy_dst .= " $netsettings{'BLUE_1_NETADDRESS'}/$netsettings{'BLUE_1_NETMASK'}";
        }
    }
    if ($proxysettings{'NO_PROXY_EXTEND'}) {
        $no_proxy_dst .= " $proxysettings{'NO_PROXY_EXTEND'}";
    }

    #if nothing, set a non annoying value
    $no_proxy_dst = '0/32' if (!$no_proxy_dst);

    #Insert acl file and replace __VAR__ with correct values
    my $blue_net = '';    #BLUE empty by default
    my $blue_ip  = '';
    if (($netsettings{'BLUE_COUNT'} >= 1) && $proxysettings{'ENABLED_BLUE_1'} eq 'on') {
        $blue_net = "$netsettings{'BLUE_1_NETADDRESS'}/$netsettings{'BLUE_1_NETMASK'}";
        $blue_ip  = "$netsettings{'BLUE_1_ADDRESS'}";
    }
    open(ACL, "/var/ipcop/proxy/acl") or die "Unable to open ACL list file";
    while (<ACL>) {
        $_ =~ s/__GREEN_IP__/$netsettings{'GREEN_1_ADDRESS'}/;
        $_ =~ s/__GREEN_NET__/$netsettings{'GREEN_1_NETADDRESS'}\/$netsettings{'GREEN_1_NETMASK'}/;
        $_ =~ s/__BLUE_IP__/$blue_ip/;
        $_ =~ s/__BLUE_NET__/$blue_net/;
        $_ =~ s/__PROXY_PORT__/$proxysettings{'PROXY_PORT'}/;
        $_ =~ s/__NO_PROXY_DST__/$no_proxy_dst/;
        print FILE $_;
    }
    close(ACL);

    # This value is in bytes, so we must turn it from KB into bytes
    my $max_incoming_size = $proxysettings{'MAX_INCOMING_SIZE'} * 1024;

    print FILE <<END

maximum_object_size $proxysettings{'MAX_SIZE'} KB
minimum_object_size $proxysettings{'MIN_SIZE'} KB

cache_mem $cachemem KB
cache_dir aufs /var/log/cache $proxysettings{'CACHE_SIZE'} 16 256

request_body_max_size $proxysettings{'MAX_OUTGOING_SIZE'} KB
reply_body_max_size $max_incoming_size allow all

visible_hostname $mainsettings{'HOSTNAME'}.$mainsettings{'DOMAINNAME'}

END
        ;

    # Write the parent proxy info, if needed.
    if ($remotehost ne '') {
        print FILE "cache_peer $remotehost parent $remoteport 3130 default no-query";

        # Enter authentication for the parent cache. Option format is
        # login=user:password   ($proxy1=YES)
        # login=PASS            ($proxy1=PASS)
        print FILE " login=$proxysettings{'UPSTREAM_USER'}" if ($proxy1);          #YES or PASS
        print FILE ":$proxysettings{'UPSTREAM_PASSWORD'}" if ($proxy1 eq 'YES');
        print FILE "\n\nnever_direct allow all\n";
    }
    close FILE;
    $configerror = 0;                                                              ## a good config!

ERROR:
    &DoHTML;

    if (!$configerror) {
        system('/usr/local/bin/restartsquid');
    }
}

if ($proxysettings{'ACTION'} eq $Lang::tr{'clear cache'}) {
    &DoHTML;
    system('/usr/local/bin/restartsquid', '-f');
}

if ($proxysettings{'ACTION'} eq $Lang::tr{'squid fix cache'}) {
    &DoHTML;
    system('/usr/local/bin/restartsquid', '-r');
}

&DoHTML if $NeedDoHTML;

sub DoHTML {

    $NeedDoHTML = 0;
    &General::readhash("/var/ipcop/proxy/settings", \%proxysettings);

    my %checked = ();

    $checked{'ENABLED_GREEN_1'}{'off'}                             = '';
    $checked{'ENABLED_GREEN_1'}{'on'}                              = '';
    $checked{'ENABLED_GREEN_1'}{$proxysettings{'ENABLED_GREEN_1'}} = "checked='checked'";

    $checked{'TRANSPARENT_GREEN_1'}{'off'}                                 = '';
    $checked{'TRANSPARENT_GREEN_1'}{'on'}                                  = '';
    $checked{'TRANSPARENT_GREEN_1'}{$proxysettings{'TRANSPARENT_GREEN_1'}} = "checked='checked'";

    $checked{'ENABLED_BLUE_1'}{'off'}                            = '';
    $checked{'ENABLED_BLUE_1'}{'on'}                             = '';
    $checked{'ENABLED_BLUE_1'}{$proxysettings{'ENABLED_BLUE_1'}} = "checked='checked'";

    $checked{'TRANSPARENT_BLUE_1'}{'off'}                                = '';
    $checked{'TRANSPARENT_BLUE_1'}{'on'}                                 = '';
    $checked{'TRANSPARENT_BLUE_1'}{$proxysettings{'TRANSPARENT_BLUE_1'}} = "checked='checked'";

    $checked{'LOGGING'}{'off'}                     = '';
    $checked{'LOGGING'}{'on'}                      = '';
    $checked{'LOGGING'}{$proxysettings{'LOGGING'}} = "checked='checked'";

    $checked{'NO_PROXY_LOCAL'}{'off'}                            = '';
    $checked{'NO_PROXY_LOCAL'}{'on'}                             = '';
    $checked{'NO_PROXY_LOCAL'}{$proxysettings{'NO_PROXY_LOCAL'}} = "checked='checked'";

    &Header::openpage($Lang::tr{'web proxy configuration'}, 1, '');

    &Header::openbigbox('100%', 'left', '');

    if ($errormessage) {
        &Header::openbox('100%', 'left', "$Lang::tr{'error messages'}:", 'error');
        print "<font class='base'>$errormessage&nbsp;</font>\n";
        &Header::closebox();
    }

    print "<form method='post' action='$ENV{'SCRIPT_NAME'}'>\n";

    &Header::openbox('100%', 'left', "$Lang::tr{'web proxy'}:");
    print <<END
<table width='100%'>
<tr>
    <td width='25%' class='base'>$Lang::tr{'enabled on'} <span class='ipcop_iface_green' style='font-weight: bold;'>Green</span>:</td>
    <td width='15%'><input type='checkbox' name='ENABLED_GREEN_1' $checked{'ENABLED_GREEN_1'}{'on'} /></td>
    <td width='30%' class='base'>$Lang::tr{'upstream proxy host:port'}:&nbsp;<img src='/blob.gif' alt='*' /></td>
    <td width='30%'><input type='text' name='UPSTREAM_PROXY' value='$proxysettings{'UPSTREAM_PROXY'}' /></td>
</tr>
<tr>
    <td class='base'>$Lang::tr{'transparent on'} <span class='ipcop_iface_green' style='font-weight: bold;'>Green</span>:</td>
    <td><input type='checkbox' name='TRANSPARENT_GREEN_1' $checked{'TRANSPARENT_GREEN_1'}{'on'} /></td>
    <td class='base'>$Lang::tr{'upstream username'}:&nbsp;<img src='/blob.gif' alt='*' /></td>
    <td><input type='text' name='UPSTREAM_USER' value='$proxysettings{'UPSTREAM_USER'}' /></td>
</tr>
<tr>
END
        ;
    if ($netsettings{'BLUE_COUNT'} >= 1) {
        print
"<td class='base'>$Lang::tr{'enabled on'} <span class='ipcop_iface_blue' style='font-weight: bold;'>Blue</span>:</td>";
        print "<td><input type='checkbox' name='ENABLED_BLUE_1' $checked{'ENABLED_BLUE_1'}{'on'} /></td>";
    }
    else {
        print "<td colspan='2'>&nbsp;</td>";
    }
    print <<END
    <td class='base'>$Lang::tr{'upstream password'}:&nbsp;<img src='/blob.gif' alt='*' /></td>
    <td><input type='password' name='UPSTREAM_PASSWORD' value='$proxysettings{'UPSTREAM_PASSWORD'}' /></td>
</tr>
<tr>
END
        ;
    if ($netsettings{'BLUE_COUNT'} >= 1) {
        print
"<td class='base'>$Lang::tr{'transparent on'} <span class='ipcop_iface_blue' style='font-weight: bold;'>Blue</span>:</td>";
        print "<td><input type='checkbox' name='TRANSPARENT_BLUE_1' $checked{'TRANSPARENT_BLUE_1'}{'on'} /></td>";
    }
    else {
        print "<td colspan='2'>&nbsp;</td>";
    }
    print <<END
    <td class='base'>$Lang::tr{'proxy port'}:</td>
    <td><input type='text' name='PROXY_PORT' value='$proxysettings{'PROXY_PORT'}' size='5' /></td>
</tr>
<tr>
    <td class='base'>$Lang::tr{'log enabled'}:</td>
    <td><input type='checkbox' name='LOGGING' $checked{'LOGGING'}{'on'} /></td>
    <td>$Lang::tr{'squid extension methods'}:&nbsp;<img src='/blob.gif' alt='*' /></td>
    <td><input type='text' name='EXTENSION_METHODS' value='$proxysettings{'EXTENSION_METHODS'}' /></td>
</tr>
<tr>
    <td colspan='4'><hr /></td>
</tr>
<tr>
    <td class='base'>$Lang::tr{'proxy no proxy local'}:</td>
    <td><input type='checkbox' name='NO_PROXY_LOCAL' $checked{'NO_PROXY_LOCAL'}{'on'} /></td>
    <td>$Lang::tr{'proxy no proxy extend'}:&nbsp;<img src='/blob.gif' alt='*' /></td>
    <td><input type='text' name='NO_PROXY_EXTEND' value='$proxysettings{'NO_PROXY_EXTEND'}' /></td>
</tr>

<!--TAG FOR ADDONS-->
<tr>
    <td colspan='4'><hr /><b>$Lang::tr{'cache management'}</b></td>
</tr><tr>
    <td width='25%' class='base'>$Lang::tr{'cache size'}:</td>
    <td><input type='text' name='CACHE_SIZE' value='$proxysettings{'CACHE_SIZE'}' size='5' /></td>
    <td></td>
    <td><input type='submit' name='ACTION' value='$Lang::tr{'squid fix cache'}' /></td>
</tr><tr>
    <td class='base'>$Lang::tr{'min size'}:</td>
    <td><input type='text' name='MIN_SIZE' value='$proxysettings{'MIN_SIZE'}' size='5' /></td>
    <td></td>
    <td><input type='submit' name='ACTION' value='$Lang::tr{'clear cache'}' /></td>
</tr><tr>
    <td class='base'>$Lang::tr{'max size'}:</td>
    <td><input type='text' name='MAX_SIZE' value='$proxysettings{'MAX_SIZE'}' size='5' /></td>
</tr><tr>
    <td colspan='4'><hr /><b>$Lang::tr{'transfer limits'}</b></td>
</tr><tr>
    <td class='base'>$Lang::tr{'max incoming size'}:</td>
    <td><input type='text' name='MAX_INCOMING_SIZE' value='$proxysettings{'MAX_INCOMING_SIZE'}' size='5' /></td>
    <td class='base'>$Lang::tr{'max outgoing size'}:</td>
    <td><input type='text' name='MAX_OUTGOING_SIZE' value='$proxysettings{'MAX_OUTGOING_SIZE'}' size='5' /></td>
</tr><tr>
    <td colspan='4'><hr /></td>
</tr>
</table>
<table width='100%'>
<tr>
    <td width='55%'><img src='/blob.gif' align='top' alt='*' />&nbsp;
        <font class='base'>$Lang::tr{'this field may be blank'}</font></td>
    <td align='center' width='40%'>
        <input type='submit' name='ACTION' value='$Lang::tr{'save'}' /></td>
    <td align='right' width='5%'>
        <a href='${General::adminmanualurl}/services.html#services_webproxy' target='_blank'>
        <img src='/images/web-support.png' alt='$Lang::tr{'online help en'}' title='$Lang::tr{'online help en'}' /></a></td>
</tr></table>
END
        ;
    &Header::closebox();

    print "</form>\n";

    &Header::closebigbox();

    &Header::closepage();

}    # end sub DoHTML
1
