#!/usr/bin/perl
#
# This file is part of the IPCop Firewall.
#
# IPCop is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# IPCop is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with IPCop.  If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2004-2008 marco.s - http://www.urlfilter.net
# (c) 2011-2012 The IPCop Team
#
# $Id: logurlfilter.cgi 6296 2012-01-30 18:07:51Z dotzball $
#

# Add entry in menu
# MENU ENTRY logs 050 "urlfilter logs" "urlfilter log viewer"
#
# Make sure translation exists $Lang::tr{'urlfilter logs'}

use strict;

# enable only the following on debugging purpose
#use warnings;
#use CGI::Carp 'fatalsToBrowser';

require '/usr/lib/ipcop/general-functions.pl';
require '/usr/lib/ipcop/lang.pl';
require '/usr/lib/ipcop/header.pl';

use POSIX();

my $logdir = "/var/log/squidGuard";

my %cgiparams=();
my %logsettings=();
my %filtersettings=();

my $errormessage='';

my @ip=();
my %ips=();
my @category=();
my %categories=();
my %usernames=();

my @now  = localtime();
my $year = $now[5] + 1900;

$cgiparams{'ACTION'} = '';

$cgiparams{'DAY'} = $now[3];
$cgiparams{'MONTH'} = $now[4];
$cgiparams{'SECTION'} = 'urlfilter';
$cgiparams{'CATEGORY'} = 'ALL';
$cgiparams{'SOURCE_IP'} = 'ALL';
$cgiparams{'USERNAME'} = 'ALL';

&General::getcgihash(\%cgiparams);
$logsettings{'LOGVIEW_REVERSE'} = 'off';
$logsettings{'LOGVIEW_VIEWSIZE'} = 150;
&General::readhash("/var/ipcop/logging/settings", \%logsettings);

if (-e "/var/ipcop/proxy/filtersettings") {
    &General::readhash("/var/ipcop/proxy/filtersettings", \%filtersettings);
}

my $start = 0;
my @temp_then = ();
if ($ENV{'QUERY_STRING'} && $cgiparams{'ACTION'} ne $Lang::tr{'update'}) {
    @temp_then = split(',', $ENV{'QUERY_STRING'});
    $start                = $temp_then[0];
    $cgiparams{'MONTH'}   = $temp_then[1];
    $cgiparams{'DAY'}     = $temp_then[2];
    $cgiparams{'SECTION'} = $temp_then[3];
    $cgiparams{'CATEGORY'} = $temp_then[4];
    $cgiparams{'SOURCE_IP'} = $temp_then[5];
    $cgiparams{'USERNAME'} = $temp_then[6];
}

if (!($cgiparams{'MONTH'} =~ /^(0|1|2|3|4|5|6|7|8|9|10|11)$/)
    || !($cgiparams{'DAY'} =~
        /^(0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31)$/))
{
    $cgiparams{'DAY'}   = $now[3];
    $cgiparams{'MONTH'} = $now[4];
}
elsif ($cgiparams{'ACTION'} eq '>>') {
    @temp_then = &General::calculatedate($year, $cgiparams{'MONTH'}, $cgiparams{'DAY'}, 1);
    $year               = $temp_then[5]+1900;
    $cgiparams{'MONTH'} = $temp_then[4];
    $cgiparams{'DAY'}   = $temp_then[3];
}
elsif ($cgiparams{'ACTION'} eq '<<') {
    @temp_then = &General::calculatedate($year, $cgiparams{'MONTH'}, $cgiparams{'DAY'}, -1);
    $year               = $temp_then[5]+1900;
    $cgiparams{'MONTH'} = $temp_then[4];
    $cgiparams{'DAY'}   = $temp_then[3];
}
else {
    @temp_then = &General::validatedate(0, $cgiparams{'MONTH'}, $cgiparams{'DAY'});
    $year               = $temp_then[5]+1900;
    $cgiparams{'MONTH'} = $temp_then[4];
    $cgiparams{'DAY'}   = $temp_then[3];
}

# Date to display
my $date = sprintf("%d-%02d-%02d", $year, $cgiparams{'MONTH'}+1, $cgiparams{'DAY'});

my $monthstr = $General::shortMonths[ $cgiparams{'MONTH'} ];
my $daystr   = $cgiparams{'DAY'} == 0 ? '..' : $cgiparams{'DAY'} <= 9 ? " $cgiparams{'DAY'}" : "$cgiparams{'DAY'}";

my @log   = ();

&processevent;

if ($cgiparams{'ACTION'} eq $Lang::tr{'export'}) {
    print "Content-type: text/plain\n";
    print "Content-Disposition: attachment; filename=\"ipcop-$cgiparams{'SECTION'}-$date.log\";\n";
    print "\n";
    print "IPCop URL filter log\r\n";
    print "$Lang::tr{'section'}: $cgiparams{'SECTION'}\n";
    print "$Lang::tr{'date'}: $date\r\n\r\n";

    unless ($cgiparams{'SECTION'} eq 'squidGuard')
    {
        print "Category: $cgiparams{'CATEGORY'}\r\n";
        print "Client: $cgiparams{'SOURCE_IP'}\r\n";
        if ($filtersettings{'ENABLE_USERNAME_LOG'} eq 'on') {
            print "Username: $cgiparams{'USERNAME'}\r\n";
        }
    }
    print "\r\n";

    # Do not reverse log when exporting
    # if ($logsettings{'LOGVIEW_REVERSE'} eq 'on') { @log = reverse @log; }

    foreach $_ (@log) {
        my ($date,$time,$pid,@loginfo) = split(/ /);
        chomp(@loginfo);
        @ip = split(/\//,$loginfo[2]);
        @category = split(/\//,$loginfo[0]);
        my $dsturl = $loginfo[1];
        $loginfo[3] =~ s/\%5c/\\/;
        if ((($cgiparams{'CATEGORY'}  eq 'ALL') || ($category[1] eq $cgiparams{'CATEGORY'})) &&
            (($cgiparams{'SOURCE_IP'} eq 'ALL') || ($ip[0] eq $cgiparams{'SOURCE_IP'})) &&
            (($cgiparams{'USERNAME'}  eq 'ALL') || ($loginfo[3] eq $cgiparams{'USERNAME'})))
        {
            print "$date ";
            print "$time ";
            if ($cgiparams{'SECTION'} eq 'squidGuard')
            {
                print "$pid ";
                print "@loginfo";
                        print "\n";
            }
            else {
                print "$category[1] ";
                print "$ip[0] ";
                if ($filtersettings{'ENABLE_USERNAME_LOG'} eq 'on') { print "$loginfo[3] "; }
                print "$dsturl";
                        print "\n";
            }
        }
        }

    exit;
}

&Header::showhttpheaders();

&Header::openpage($Lang::tr{'urlfilter log viewer'}, 1, '');

&Header::openbigbox('100%', 'left', '');

if ($errormessage) {
    &Header::openbox('100%', 'left', $Lang::tr{'error messages'}, 'error');
    print "<font class='base'>$errormessage&nbsp;</font>\n";
    &Header::closebox();
}

&Header::openbox('100%', 'left', "$Lang::tr{'settings'}:");

my %selected = ();
$selected{'SECTION'}{'urlfilter'} = '';
$selected{'SECTION'}{'squidGuard'} = '';
$selected{'SECTION'}{$cgiparams{'SECTION'}} = "selected='selected'";

if ($cgiparams{'SECTION'} eq 'squidGuard')
{
    $cgiparams{'SOURCE_IP'} = 'ALL';
    $cgiparams{'CATEGORY'}  = 'ALL';
    $cgiparams{'USERNAME'}  = 'ALL';
}

print <<END
<form method='post' action="$ENV{'SCRIPT_NAME'}">
<table width='100%'>
<tr>
    <td class='base' nowrap='nowrap'>$Lang::tr{'section'}:&nbsp;</td>
    <td>
    <select name='SECTION' onchange='this.form.submit()'>
        <option value='urlfilter' $selected{'SECTION'}{'urlfilter'}>$Lang::tr{'url filter'}</option>
        <option value='squidGuard' $selected{'SECTION'}{'squidGuard'}>squidGuard</option>
    </select>
    </td>
    <td class='base' nowrap='nowrap'>&nbsp;&nbsp;$Lang::tr{'month'}:&nbsp;
    </td>
    <td>
    <select name='MONTH'>
END
;
for (my $month = 0; $month < 12; $month++)
{
    print "\t<option ";
    if ($month == $cgiparams{'MONTH'}) {
        print 'selected="selected" ';
    }
    print "value='$month'>$Lang::tr{$General::longMonths[$month]}</option>\n";
}
print <<END
    </select>
    </td>
    <td class='base' nowrap='nowrap'>&nbsp;&nbsp;$Lang::tr{'day'}:&nbsp;
    </td>
    <td>
    <select name='DAY'>
END
;
for (my $day = 1; $day <= 31; $day++)
{
    print "\t<option ";
    if ($day == $cgiparams{'DAY'}) {
        print 'selected="selected" '; }
    print "value='$day'>$day</option>\n";
}
print <<END
    </select>
    </td>
    <td>
        &nbsp;&nbsp;
    </td>
    <td align='center'>
        <input type='submit' name='ACTION' title='$Lang::tr{'day before'}' value='&lt;&lt;' />
        <input type='submit' name='ACTION' title='$Lang::tr{'day after'}' value='&gt;&gt;' />
        <input type='submit' name='ACTION' value='$Lang::tr{'update'}' />&nbsp;
        <input type='submit' name='ACTION' value='$Lang::tr{'export'}' /></td>
    <td class='onlinehelp'>
        <a href='${General::adminmanualurl}/logs-urlfilter.html' target='_blank'><img src='/images/web-support.png' alt='$Lang::tr{'online help en'}' title='$Lang::tr{'online help en'}' /></a>
    </td>
</tr>
</table>
<hr />
END
;

my $selectedAllCat = '';
if($cgiparams{'CATEGORY'} eq 'ALL') {
    $selectedAllCat = "selected='selected'";
}

print <<END
<table width='100%'>
<tr>
    <td width='5%' class='base' nowrap='nowrap'>$Lang::tr{'category'}:&nbsp;</td>
    <td width='20%'>
    <select name='CATEGORY'>
    <option value='ALL' $selectedAllCat>$Lang::tr{'caps all'}</option>
END
;
foreach my $cat (sort(keys %categories)) {
    my $selected = '';
    if($cat eq $cgiparams{'CATEGORY'}) {
        $selected = "selected='selected'";
    }
    print "<option value='$cat' $selected>$cat</option>\n";
}
print <<END
    </select>
    </td>
    <td width='5%' class='base' nowrap='nowrap'>&nbsp;&nbsp;$Lang::tr{'client'}:&nbsp;</td>
END
;

if ($filtersettings{'ENABLE_USERNAME_LOG'} eq 'on') {
    print "<td width='20%'>\n";
}
else {
    print "<td width='70%'>\n";
}

my $selectedAllSrcIp = '';
if($cgiparams{'SOURCE_IP'} eq 'ALL') {
    $selectedAllSrcIp = "selected='selected'";
}

print <<END
    <select name='SOURCE_IP'>
    <option value='ALL' $selectedAllSrcIp>$Lang::tr{'caps all'}</option>
END
;
foreach my $ipaddr (sort(keys %ips)) {
    my $selected = '';
    if($ipaddr eq $cgiparams{'SOURCE_IP'}) {
        $selected = "selected='selected'";
    }

print "<option value='$ipaddr' $selected>$ipaddr</option>\n"; }
print <<END
    </select>
    </td>
END
;

if ($filtersettings{'ENABLE_USERNAME_LOG'} eq 'on') {
    my $selectedAllUser = '';
    if($cgiparams{'USERNAME'} eq 'ALL') {
        $selectedAllUser = "selected='selected'";
    }

    print <<END
    <td width='5%' class='base' nowrap='nowrap'>&nbsp;&nbsp;$Lang::tr{'username'}:&nbsp;</td>
    <td width='45%'>
    <select name='USERNAME'>
        <option value='ALL' $selectedAllUser>$Lang::tr{'caps all'}</option>
END
;
    foreach my $user (sort(keys %usernames)) {
        my $selected = '';
        if($user eq $cgiparams{'USERNAME'}) {
            $selected = "selected='selected'";
        }

        print "<option value='$user' $selected>$user</option>\n";
    }
    print <<END
    </select>
    </td>
END
;
}

print <<END
</tr>
</table>
</form>
END
;

&Header::closebox();

&Header::openbox('100%', 'left', $Lang::tr{'log'});

my $lines = @log;
my $offset = $logsettings{'LOGVIEW_VIEWSIZE'};

if(($start + $offset) > $lines) {
    $offset = $lines - $start;
}

my $prev;
if ($start == 0) {
    $prev = -1;
}
else {
    $prev = $start - $logsettings{'LOGVIEW_VIEWSIZE'};
    $prev = 0 if ($prev < 0);
}

my $next;
if ($start >= $lines - $logsettings{'LOGVIEW_VIEWSIZE'}) {
    $next = -1;
}
else {
    $next = $start + $logsettings{'LOGVIEW_VIEWSIZE'};
}


if ($logsettings{'LOGVIEW_REVERSE'} eq 'on') {
    my $tmp = $prev;
    $prev = $next;
    $next = $tmp;
    @log = reverse @log;
}

if ($lines != 0) { &oldernewer(); }

if ($cgiparams{'SECTION'} eq 'urlfilter') {
    print "<b>$Lang::tr{'web hits'} $year $Lang::tr{$General::longMonths[$cgiparams{'MONTH'}]} $daystr: $lines</b>\n<p>\n";
}

my @slice = splice(@log, $start, $offset);

if ($lines)
{
    $lines = 0;

    print "<table width='100%'>\n";
    unless ($cgiparams{'SECTION'} eq 'squidGuard')
    {
        print <<END

        <tr>
            <td align='center'><b>$Lang::tr{'time'}</b></td>
            <td align='center'><b>$Lang::tr{'category'}</b></td>
            <td align='center'><b>$Lang::tr{'client'}</b></td>
END
;
        if ($filtersettings{'ENABLE_USERNAME_LOG'} eq 'on') {
            print "<td align='center'><b>$Lang::tr{'username'}</b></td>\n";
        }
        print <<END
            <td align='center'><b>$Lang::tr{'destination'}</b></td>
        </tr>
END
;
    }

    foreach $_ (@slice)
    {
        my $attr1 = '';
        my $attr2 = '';
        my ($date,$time,$pid,@loginfo) = split(/ /);
        @ip = split(/\//, $loginfo[2]);
        @category = split(/\//, $loginfo[0]);
        my $dsturl = $loginfo[1];
        if(defined($loginfo[3])) {
            $loginfo[3] =~ s/\%5c/\\/;
        }
        if ((($cgiparams{'CATEGORY'}  eq 'ALL') || ($category[1] eq $cgiparams{'CATEGORY'})) &&
            (($cgiparams{'SOURCE_IP'} eq 'ALL') || ($ip[0] eq $cgiparams{'SOURCE_IP'})) &&
            (($cgiparams{'USERNAME'}  eq 'ALL') || ($loginfo[3] eq $cgiparams{'USERNAME'})))
        {
            $lines++;

            if ($cgiparams{'SECTION'} eq 'squidGuard') {
                if ($loginfo[0] =~ /squidGuard/) { $attr1 .= "<b>"; $attr2 .= "</b>"; }
                if ($loginfo[1] =~ /ready/) { $attr1 .= "<b><font color='$Header::colourgreen'>"; $attr2 .= "</font></b>"; }
                if ($loginfo[2] =~ /emergency/) { $attr1 .= "<b><font color='$Header::colourerr'>"; $attr2 .= "</font></b>"; }
                print "<tr>\n";
            }
            else {
                if ($lines % 2) {
                    print "<tr class='table1colour'>\n";
                }
                else {
                    print "<tr class='table2colour'>\n";
                }
            }

            if ($cgiparams{'SECTION'} eq 'squidGuard') {
                print "<td nowrap>$time &nbsp; $pid &nbsp; $attr1@loginfo$attr2</td>\n";
            }
            else {
                print "<td width='10%' align='center' nowrap>$time</td>\n";
                print "<td width='11%' align='center' nowrap>$category[1]</td>\n";
                print "<td width='15%' align='center' nowrap>$ip[0]</td>\n";
                my $site = '';
                if ($filtersettings{'ENABLE_USERNAME_LOG'} eq 'on')
                {
                    print "<td width='12%' align='center' nowrap>$loginfo[3]</td>\n";
                    $site = substr($dsturl,0,55);
                    if (length($dsturl) > 55) { $site .= "..."; }
                }
                else {
                    $site = substr($dsturl,0,69);
                    if (length($dsturl) > 69) {
                        $site .= "...";
                    }
                }
                print "<td><a href='$dsturl' title='$dsturl' target='_blank'>$site</a></td>\n";
            }
            print "</tr>\n";
        }
    }

    print "</table><br>\n";

}

&oldernewer();

&Header::closebox();

&Header::closebigbox();

&Header::closepage();

# -------------------------------------------------------------------

sub processevent
{
    my $filestr='';

    undef @log;
    if ($cgiparams{'SECTION'} eq 'squidGuard')
    {
        $filestr = "$logdir/squidGuard.log";
        foreach my $logarch (<$filestr*>)
        {
            if($logarch =~ /\.gz$/) {
                open (LOG, "gzip -dc $logarch |");
            }
            else {
                open (LOG, $logarch);
            }

            foreach (<LOG>) {
                my ($date,$time,$pid,@loginfo) = split(/ /);
                my ($logyear,$logmonth,$logday) = split(/-/,$date);

                if (($logyear == $year)
                    && ($logmonth == $cgiparams{'MONTH'}+1)
                    && ($logday == $cgiparams{'DAY'})) {
                        push(@log, $_)
                }
            }
            close(LOG);
        }
    }
    else {
        foreach my $logarch (<$logdir/*>)
        {
            if ($logarch !~ /squidGuard\.log/) {
                if($logarch =~ /\.gz$/) {
                    open (LOG, "gzip -dc $logarch |");
                }
                else {
                    open (LOG, $logarch);
                }
                foreach (<LOG>) {
                    my ($date,$time,$pid,@loginfo) = split(/ /);
                    my ($logyear,$logmonth,$logday) = split(/-/,$date);
                    @category = split(/\//,$loginfo[0]);
                    $categories{$category[1]}++;
                    @ip = split(/\//,$loginfo[2]);
                    $ips{$ip[0]}++;
                    $loginfo[3] =~ s/\%5c/\\/;
                    $usernames{$loginfo[3]}++;

                    if (($logyear == $year)
                        && ($logmonth == $cgiparams{'MONTH'}+1)
                        && ($logday == $cgiparams{'DAY'})) {
                            push(@log,$_)
                    }
                }
                close(LOG);
            }
        }

        my @temp = ();
        foreach (@log)
        {
            my ($date,$time,$pid,@loginfo) = split(/ /);
            @ip = split(/\//,$loginfo[2]);
            @category = split(/\//,$loginfo[0]);
            $loginfo[3] =~ s/\%5c/\\/;
            if ((($cgiparams{'CATEGORY'}  eq 'ALL') || ($category[1] eq $cgiparams{'CATEGORY'}))
                && (($cgiparams{'SOURCE_IP'} eq 'ALL') || ($ip[0] eq $cgiparams{'SOURCE_IP'}))
                && (($cgiparams{'USERNAME'}  eq 'ALL') || ($loginfo[3] eq $cgiparams{'USERNAME'})))
            {
                push(@temp,$_);
            }
        }
        @log = @temp;
        @log = sort { substr($a,11,8) cmp substr($b,11,8) } @log;
    }
}

# -------------------------------------------------------------------

sub oldernewer {
    print <<END
<table width='100%'>
<tr>
    <td align='center' width='50%'>
END
;

    if ($prev != -1) {
        print "<a href='$ENV{'SCRIPT_NAME'}?$prev,$cgiparams{'MONTH'},$cgiparams{'DAY'},$cgiparams{'SECTION'},$cgiparams{'CATEGORY'},$cgiparams{'SOURCE_IP'},$cgiparams{'USERNAME'}'>$Lang::tr{'older'}</a>";
    }
    else {
        print "$Lang::tr{'older'}";
    }
    print "</td>\n";

    print "<td align='center' width='50%'>";
    if ($next >= 0) {
        print "<a href='$ENV{'SCRIPT_NAME'}?$next,$cgiparams{'MONTH'},$cgiparams{'DAY'},$cgiparams{'SECTION'},$cgiparams{'CATEGORY'},$cgiparams{'SOURCE_IP'},$cgiparams{'USERNAME'}'>$Lang::tr{'newer'}</a>";
    }
    else {
        print "$Lang::tr{'newer'}";
    }

    print <<END
    </td>
</tr>
</table>
END
;
}
