#!/usr/bin/perl
#
# This file is part of the IPCop Firewall.
#
# IPCop is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# IPCop is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with IPCop; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# $Id: setreservedports.pl 3568 2009-09-17 12:39:09Z owes $
# 
# Copyright (c) 2009 The IPCop Team
#
#
# Just a note: existing connections will not be cut when changing ports.
#   ESTABLISHED, RELATED can be really amazing
#

use strict;

require '/usr/lib/ipcop/general-functions.pl';
require '/usr/lib/ipcop/DataAccess.pl';

my $port = 0;
if (defined($ARGV[1])) {
    $port = $ARGV[1];
    die "Invalid port: $port" unless (&General::validport($port));
}

if (($ARGV[0] eq '--test') && $port) {
    # This is only a quick hack to do some testing

    my $proto = "tcp";

    $proto = $ARGV[2] if (defined($ARGV[2]));
    print "$proto/$port is ";
    if (&DATA::isReservedPort($proto, $port)) {
        print "reserved\n";
    }
    else {
        print "not reserved\n";
    }
}
elsif (($ARGV[0] eq '--gui') && $port) {
    if (&DATA::isReservedPort("tcp", $port)) {
        print "Cannot change GUI port to $port, port is reserved\n";
        exit 1;
    }

    &setgui();
}
elsif (($ARGV[0] eq '--ssh') && $port) {
    if (&DATA::isReservedPort("tcp", $port)) {
        print "Cannot change SSH port to $port, port is reserved\n";
        exit 1;
    }

    &setssh();
}
else {
    print <<END;
Usage is: [--gui portnumber] [--ssh portnumber] [--test portnumber [proto]]

    --gui port              Change the IPCop GUI to tcp/port
    --ssh port              Change the IPCop SSH to tcp/port
    --test port proto       Run a quick test to see if proto/port is reserved
                            proto is optional, default is tcp

    To change GUI or SSH enter a portnumber between 1 and 65535. 
    Also be very sure to know what you are doing!
END
}


sub setgui()
{
    print "Changing GUI port to $port\n";

    my %mainsettings = ();
    &General::readhash('/var/ipcop/main/settings', \%mainsettings);
    $mainsettings{'GUIPORT'} = $port;
    &General::writehash('/var/ipcop/main/settings', \%mainsettings);

    # Change apache port
    print "Change httpd configuration ... \n";
    system("/bin/sed", "-i", "-e", "s+Listen.*\$+Listen $port+",
                "-e", "s+<VirtualHost _default_.*\$+<VirtualHost _default_:$port>+",
                "/etc/httpd/conf/httpd.conf");
    print "Restarting httpd ... \n";
    system("/usr/bin/killall httpd");
    sleep 2;
    system("/usr/sbin/httpd");

    # Inform squid
    print "Change proxy configuration ... \n";
    if (-e '/var/ipcop/proxy/squid.conf') {
        system("/bin/sed -i 's+acl IPCop_https port.*\$+acl IPCop_https port $port+' /var/ipcop/proxy/squid.conf");

        # Restart squid if enabled
        my %proxysettings = ();
        &General::readhash("/var/ipcop/proxy/settings", \%proxysettings);
        if (($proxysettings{'ENABLED_GREEN_1'} eq 'on') || ($proxysettings{'ENABLED_BLUE_1'} eq 'on')) {
            print "Restarting proxy ... \n";
            system('/usr/local/bin/restartsquid');
        }
    }

    # Rewrite firewall rules
    system("/usr/local/bin/setfwrules --ipcop >/dev/null");

    &General::log("GUI port changed to $port");
}


sub setssh()
{
    print "Changing SSH port to $port\n";

    my %mainsettings = ();
    &General::readhash('/var/ipcop/main/settings', \%mainsettings);
    $mainsettings{'SSHPORT'} = $port;
    &General::writehash('/var/ipcop/main/settings', \%mainsettings);

    # Change sshd port
    print "Change sshd configuration ... \n";
    system("/bin/sed", "-i", "-e", "s+Port .*\$+Port $port+", "/etc/ssh/sshd_config");

    my %sshsettings = ();
    &General::readhash('/var/ipcop/remote/settings', \%sshsettings);
    if ($sshsettings{'ENABLE_SSH'} eq 'on') {
        print "Restarting SSHd ... \n";
        system('/usr/local/bin/restartssh');
    }

    # Rewrite firewall rules
    system("/usr/local/bin/setfwrules --ipcop >/dev/null");

    &General::log("SSH port changed to $port");
}
