#!/usr/bin/perl
#
# This file is part of the IPCop Firewall.
#
# IPCop is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# IPCop is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with IPCop; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# $Id: discover-data-shrink.pl 2995 2009-06-07 13:02:08Z owes $
# 

use strict;

use XML::Simple;
use XML::Parser;


my %classes = ();
# Which devices are we interested in?  Need to keep this in sync with src/installer/hardware.c
# Look here for list of classes: http://pci-ids.ucw.cz/read/PD
$classes{"0100"} = 1;
$classes{"0101"} = 1;
$classes{"0102"} = 1;
$classes{"0103"} = 1;
$classes{"0104"} = 1;
$classes{"0105"} = 1;
$classes{"0106"} = 1;
$classes{"0107"} = 1;
$classes{"0180"} = 1;
$classes{"0200"} = 1;
$classes{"0201"} = 1;
$classes{"0605"} = 1;
$classes{"0607"} = 1;
$classes{"0680"} = 1;
$classes{"0c03"} = 1;


sub pcidevices {
    my $c1 = 0;
    my $c2 = 0;

    my $data = shift;
    my $dataout;

    # bus='pci' will get magically lost otherwise 
    $dataout->{device_list}->{bus} = $data->{device_list}->{bus};

    # walk through all entries and push out the interesting ones
    foreach my $d (@{$data->{device_list}->{device}}) {
        $c1++;
        if (exists($d->{busclass}) && exists($classes{$d->{busclass}})) {
            $c2++;
            push @{$dataout->{device_list}->{device}}, $d; 
        }
    }

    open FILE, ">$ARGV[1]";
    print FILE "<?xml version='1.0' encoding='UTF-8'?>\n";
    print FILE XMLout($dataout, KeepRoot => 1);
    close FILE;

    print "Total input: $c1  Total output $c2\n";
}


unless (defined($ARGV[0]) && defined($ARGV[1])) {
    die "I want an input and an output XML!\n";
}

my $xml = new XML::Simple;
my $data = $xml->XMLin("$ARGV[0]", KeepRoot => 1);

&pcidevices($data);
