#!/usr/bin/perl
#
# SmoothWall CGIs
#
# This code is distributed under the terms of the GPL
#
# (c) The SmoothWall Team
#
# $Id: logsummary.cgi 3122 2009-06-25 10:55:55Z owes $
#

# Add entry in menu
# MENUENTRY logs 020 "log summary" "log summary"

use strict;

# enable only the following on debugging purpose
#use warnings;
#use CGI::Carp 'fatalsToBrowser';

require '/usr/lib/ipcop/general-functions.pl';
require '/usr/lib/ipcop/lang.pl';
require '/usr/lib/ipcop/header.pl';

# $Lang::tr{'ls_dhcpd'}      # Dummy string variables included here
# $Lang::tr{'ls_disk space'} # or gen_strings script will miss them
# $Lang::tr{'ls_free/swan'}
# $Lang::tr{'ls_httpd'}
# $Lang::tr{'ls_init'}
# $Lang::tr{'ls_kernel'}
# $Lang::tr{'ls_modprobe'}
# $Lang::tr{'ls_pam_unix'}
# $Lang::tr{'ls_sshd'}
# $Lang::tr{'ls_syslogd'}

use POSIX();

my %cgiparams    = ();
my $errormessage = '';

my @longmonths = (
    $Lang::tr{'january'},   $Lang::tr{'february'}, $Lang::tr{'march'},    $Lang::tr{'april'},
    $Lang::tr{'may'},       $Lang::tr{'june'},     $Lang::tr{'july'},     $Lang::tr{'august'},
    $Lang::tr{'september'}, $Lang::tr{'october'},  $Lang::tr{'november'}, $Lang::tr{'december'}
);

my @now  = localtime();
my $year = $now[5] + 1900;

$cgiparams{'MONTH'}  = '';
$cgiparams{'DAY'}    = '';
$cgiparams{'ACTION'} = '';

&General::getcgihash(\%cgiparams);

my $start = -1;
if ($ENV{'QUERY_STRING'} && $cgiparams{'ACTION'} ne $Lang::tr{'update'}) {
    my @temp = split(',', $ENV{'QUERY_STRING'});
    $start              = $temp[0];
    $cgiparams{'MONTH'} = $temp[1];
    $cgiparams{'DAY'}   = $temp[2];
}

if (   !($cgiparams{'MONTH'} =~ /^(0|1|2|3|4|5|6|7|8|9|10|11)$/)
    || !($cgiparams{'DAY'} =~ /^(1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31)$/)
    )
{

    # Reports are generated at the end of the day, so if nothing is selected
    # we need to display yesterdays (todays won't have been generated yet)
    my @temp_then = ();
    my @temp_now  = localtime(time);
    $temp_now[4] = $now[4];
    $temp_now[3] = $now[3];
    @temp_then   = localtime(POSIX::mktime(@temp_now) - 86400);
    ## Retrieve the same time on the previous day -
    ## 86400 seconds in a day
    $cgiparams{'MONTH'} = $temp_then[4];
    $cgiparams{'DAY'}   = $temp_then[3];
}
elsif ($cgiparams{'ACTION'} eq '>>') {
    my @temp_then = ();
    my @temp_now  = localtime(time);
    $temp_now[4] = $cgiparams{'MONTH'};
    $temp_now[3] = $cgiparams{'DAY'};
    @temp_then   = localtime(POSIX::mktime(@temp_now) + 86400);
    ## Retrieve the same time on the next day +
    ## 86400 seconds in a day
    $cgiparams{'MONTH'} = $temp_then[4];
    $cgiparams{'DAY'}   = $temp_then[3];
}
elsif ($cgiparams{'ACTION'} eq '<<') {
    my @temp_then = ();
    my @temp_now  = localtime(time);
    $temp_now[4] = $cgiparams{'MONTH'};
    $temp_now[3] = $cgiparams{'DAY'};
    @temp_then   = localtime(POSIX::mktime(@temp_now) - 86400);
    ## Retrieve the same time on the previous day -
    ## 86400 seconds in a day
    $cgiparams{'MONTH'} = $temp_then[4];
    $cgiparams{'DAY'}   = $temp_then[3];
}

if (($cgiparams{'DAY'} ne $now[3]) || ($cgiparams{'MONTH'} ne $now[4])) {
    if (   ($cgiparams{'MONTH'} eq $now[4]) && ($cgiparams{'DAY'} > $now[3])
        || ($cgiparams{'MONTH'} > $now[4]))
    {
        $year = $year - 1;
    }
}

my $monthnum     = $cgiparams{'MONTH'} + 1;
my $monthstr     = $monthnum <= 9 ? "0$monthnum" : "$monthnum";
my $longmonthstr = $longmonths[ $cgiparams{'MONTH'} ];
my $daystr       = $cgiparams{'DAY'} <= 9 ? "0$cgiparams{'DAY'}" : "$cgiparams{'DAY'}";

my $skip    = 0;
my $filestr = "/var/log/logwatch/$year-$monthstr-$daystr";

if (!(open(FILE, $filestr))) {
    $errormessage = "$Lang::tr{'date not in logs'}: $filestr $Lang::tr{'could not be opened'}";
    $skip         = 1;

    # Note: This is in case the log does not exist for that date
}

if (!$skip && $cgiparams{'ACTION'} eq $Lang::tr{'export'}) {
    print "Content-type: text/plain\n\n";

    while (<FILE>) {
        print "$_\r\n";
    }
    close(FILE);
    exit 0;
}

&Header::showhttpheaders();

&Header::openpage($Lang::tr{'log summary'}, 1, '');

&Header::openbigbox('100%', 'left', '');

if ($errormessage) {
    &Header::openbox('100%', 'left', "$Lang::tr{'error messages'}:", 'error');
    print "<font class='base'>$errormessage&nbsp;</font>\n";
    &Header::closebox();
}

&Header::openbox('100%', 'left', "$Lang::tr{'settings'}:");

print <<END
<form method='post' action='$ENV{'SCRIPT_NAME'}'>
<table width='100%'>
<tr>
	<td width='50%' class='base' nowrap='nowrap'>$Lang::tr{'month'}:&nbsp;
	<select name='MONTH'>
END
    ;
for (my $month = 0; $month < 12; $month++) {
    print "\t<option ";
    if ($month == $cgiparams{'MONTH'}) {
        print "selected='selected' ";
    }
    print "value='$month'>$longmonths[$month]</option>\n";
}
print <<END
	</select>
	&nbsp;&nbsp;$Lang::tr{'day'}:&nbsp;
	<select name='DAY'>
END
    ;
for (my $day = 1; $day <= 31; $day++) {
    print "\t<option ";
    if ($day == $cgiparams{'DAY'}) {
        print "selected='selected' ";
    }
    print "value='$day'>$day</option>\n";
}
print <<END
	</select>
	</td>
	<td width='45%'  align='center'>
		<input type='submit' name='ACTION' title='$Lang::tr{'day before'}' value='&lt;&lt;' />
		<input type='submit' name='ACTION' title='$Lang::tr{'day after'}' value='&gt;&gt;' />
		<input type='submit' name='ACTION' value='$Lang::tr{'update'}' />
		<input type='submit' name='ACTION' value='$Lang::tr{'export'}' />
	</td>
    <td class='onlinehelp'>
        <a href='${General::adminmanualurl}/logs-summary.html' target='_blank'><img src='/images/web-support.png' alt='$Lang::tr{'online help en'}' title='$Lang::tr{'online help en'}' /></a>
    </td>
</tr>
</table>
</form>
END
    ;

&Header::closebox();

my $header  = 0;
my @content = ();

if (!$skip) {
    while (<FILE>) {
        if (/^\s*--+ ([^-]+) Begin --+\s*$/) {

            # New Section. open box
            @content = ();
            &Header::openbox('100%', 'left', $Lang::tr{"ls_\L$1"} ? $Lang::tr{"ls_\L$1"} . ":" : "$1:");
            print "<pre>";
        }
        elsif (/^\s*--+ ([^-]+) End --+\s*$/) {

            # End of Section, kill leading and trailing blanks, print info, close
            # box
            while ($content[0]         =~ /^\s*$/) { shift @content; }
            while ($content[$#content] =~ /^\s*$/) { pop @content; }
            foreach $_ (@content) { $_ =~ s/\s*$//; print &Header::cleanhtml($_, "y") . "\n"; }
            print "\n</pre>";
            &Header::closebox();
        }
        elsif (/^\s*#+ LogWatch [^#]+[)] #+\s*$/) {

            # Start of logwatch header, skip it
            $header = 1;
        }
        elsif (/^\s*#+\s*$/) {

            # End of logwatch header
            $header = 0;
        }
        elsif (/^\s*#+ LogWatch End #+\s*$/) {

            # End of report
        }
        elsif ($header eq 0) {
            push(@content, $_);
        }
    }
    close(FILE);
}

&Header::closebigbox();

&Header::closepage();
