#!/usr/bin/perl

# for nice colors
use Term::ANSIColor qw(:constants);

my $f;
my $package;	# without the package version, so we could simply parse different directories in one liners
my $testdir;
my @thefiles=();

if ( $#ARGV == -1 || $#ARGV>1 ) {
	print "Usage: $0 [package] test_<machine>/<date-stamp>\n";
	print "Use gcc or 'gcc|^bc' for [package] to read both gcc and bc summaries\n";
	exit
}
if ( $#ARGV == 1 ) {
	$package=$ARGV[0];
	shift;
}
$testdir=$ARGV[0];

# Check test directory exist
opendir(TESTDIR, $testdir) or die("Cannot open directory");
# Read every present log
@thefiles= readdir(TESTDIR);
closedir(TESTDIR);

@thefiles= sort(@thefiles);

if (defined($package)) {
	# Find the full files that match [package] with version
	# so keep only what is matching
	print "Selecting only packages that match $package\n";
	my @selection=();
	# push package that match into @selection
	for ( my $count = 0; $count < scalar(@thefiles); $count++ )  {
		if ( $thefiles[$count] =~ m!^$package! ) {
			push(@selection, $thefiles[$count]);
		}
	}
	@thefiles=@selection;
}

# Now parse each selected log
foreach $f (@thefiles) {
	my $error=0;
	if ( $f eq "." || $f eq ".." ) { next; }
	if ( $f =~ m!^glibc! && $f =~ m!summary! ) { next; } 	# skip glibc summary
	if ( $f =~ m!^gcc! && $f !~ m!summary! ) { next; }	# skip gcc not the summary

	print "Reading $f";

	if ( $f =~ m!^bc! ) {
		# There is always errors and we don't care if there is not too much
		# Check if Total failed tests is not too big
		# 15 is very arbitrary, just more than 10 that is the usual error count on i486
		open FILE, "$testdir/$f" or die $!;
		while (my $line = <FILE>) {
			if ( $line =~ /^Total failed tests=(\d*)/ ) { $error=$1; }
		}
		close (FILE);
		if ( $error < 15 ) {
			print "\t $error errors considered ok\n";
		} else {
			print BOLD, BLUE, "\t $error errors considered too much\n", RESET;
		}
	} else {
		# FAILED | UNEXPECTED PASS from autoconf lib/general.m4
		# ^ERROR:|^FAIL:|^XPASS: from automake and derivated
		$errorstring= "^FAIL:|^ERROR:|^XPASS:| FAILED | UNEXPECTED PASS ";
		# Add " Error " match on a few package only
		# because XFAIL may generate Error like with sed
		# Those packages are the one with log needing more investigations
		# With Error, we will catch for sure the makefile error but may not print the specific message
		if ( $f =~ m!bash|e2fsprogs|flex|gawk|glibc|gnupg|module-init-tools|openssh|openssl|pcre! ) {
			$errorstring= "$errorstring| Error ";
		}
		if ( $f =~ m!^tcl|^expect! ) {
			# without ending space on FAILED, that would wrongly match on flex
			$errorstring= " .+ .+ FAILED"; # to not match twice on the same error
		}

		open FILE, "$testdir/$f" or die $!;
		while (my $line = <FILE>) {
			if ( $line =~ m!$errorstring! ) {
				if ( $line !~ m! Error \d* \(ignored\)! ) {
					if ($error==0) { print "\n"; }
					$error++;
					print BOLD, BLUE, "$line", RESET;
				}
			}
		}
		close(FILE);
		if ( $error==0 ) {
			print " no error\n";
		} else {
			# we may count more errors than really depending of makefile deepness
			print " Approximately $error error(s) with $f\n";
		}
	}
}

