/* 
 * helper_backup.c: helper functions for backup/restore
 *
 * This file is part of the IPCop Firewall.
 *
 * IPCop is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * IPCop is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with IPCop; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * (c) 2010, the IPCop team
 *
 * $Id: helper_backup.c 4332 2010-03-12 16:35:39Z owes $
 * 
 */


#include <string.h>
#include "common.h"
#include "common_backup.h"


int testbackupversion(char *path)
{
    unsigned int version;

    version = getbackupversion(path);
    if (version == 0) {
        return FAILURE;
    }

    /* TODO: add a clever mechanism here, as soon as we leave beta stage */
    /* For now only accept backups from 1.9.9 - 1.9.15 */
    if ((version >= 0x010909) && (version <= 0x01090F)) {
        return SUCCESS;
    }

    return FAILURE;
}


int getbackupversion(char *path)
{
    char filename[STRING_SIZE];
    FILE *f = NULL;
    unsigned int version = 0;
    unsigned int v_major, v_minor, v_revision;

    snprintf(filename, STRING_SIZE, "%s/var/ipcop/backup/version", path);
    if ((f = fopen(filename, "r")) == NULL) {
        return 0;
    }

    if (fscanf(f, "%u.%u.%u", &v_major, &v_minor, &v_revision) != 3) {
        return 0;
    }

    if ((v_major > 255) || (v_minor > 255) || (v_revision > 255)) {
        return 0;
    }

    version = (v_major << 16) + (v_minor << 8) + v_revision;

    return version;
}
