#!/usr/bin/perl
#
# SmoothWall CGIs
#
# This code is distributed under the terms of the GPL
#
# (c) The SmoothWall Team
#
# $Id: logsystem.cgi 4491 2010-04-19 17:26:33Z owes $
#

# Add entry in menu
# MENUENTRY logs 050 "system logs" "system log viewer"
#
# Make sure translation exists $Lang::tr{'system log viewer'}

use strict;

# enable only the following on debugging purpose
#use warnings;
#use CGI::Carp 'fatalsToBrowser';

require '/usr/lib/ipcop/general-functions.pl';
require '/usr/lib/ipcop/lang.pl';
require '/usr/lib/ipcop/header.pl';

use POSIX();

my %cgiparams    = ();
my %logsettings  = ();
my $errormessage = '';

my @shortmonths = ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
my @longmonths = (
    $Lang::tr{'january'},   $Lang::tr{'february'}, $Lang::tr{'march'},    $Lang::tr{'april'},
    $Lang::tr{'may'},       $Lang::tr{'june'},     $Lang::tr{'july'},     $Lang::tr{'august'},
    $Lang::tr{'september'}, $Lang::tr{'october'},  $Lang::tr{'november'}, $Lang::tr{'december'}
);

my @now  = localtime();
my $dow  = $now[6];
my $doy  = $now[7];
my $tdoy = $now[7];
my $year = $now[5] + 1900;

$cgiparams{'DAY'}     = $now[3];
$cgiparams{'MONTH'}   = $now[4];
$cgiparams{'ACTION'}  = '';
$cgiparams{'SECTION'} = 'ipcop';

my %sections = (
    'ipcop' => '(ipcop|ipcopreboot\[.*\])',
    'red' =>
'(red|connectioncheck|kernel: usb.*|pppd\[.*\]|chat\[.*\]|pppoe\[.*\]|pptp\[.*\]|pppoa\[.*\]|pppoa3\[.*\]|pppoeci\[.*\]|ipppd|ipppd\[.*\]|kernel: ippp\d|kernel: isdn.*|ibod\[.*\]|kernel: eth.*|dhcpcd.*|modem_run\[.*\])',
    'dns'            => '(dnsmasq\[.*\])',
    'dhcp'           => '(dnsmasq-dhcp\[.*\]|dhcpd)',
    'cron'           => '(fcron\[.*\])',
    'ntp'            => '(ntpd(?:ate)?\[.*\])',
    'ssh'            => '(sshd(?:\(.*\))?\[.*\])',
    'auth'           => '(\w+\(pam_unix\)\[.*\])',
    'kernel'         => '(kernel)',
    'ipsec'          => '(vpn|ipsec|ipsec_[\w_]+|pluto\[.*\]|vpn-watch)',
    'openvpn'        => '(vpn|openvpn|OVPN_.*|openvpnserver\[\d+\])',
    'squid'          => '(squid\[.*\])',
    'installpackage' => '(installpackage)'
);

# Translations for the %sections array.
my %trsections = (
    'ipcop'          => 'IPCop',
    'red'            => 'RED',
    'dns'            => 'DNS',
    'dhcp'           => "$Lang::tr{'dhcp server'}",
    'cron'           => 'Cron',
    'ntp'            => 'NTP',
    'ssh'            => 'SSH',
    'auth'           => "$Lang::tr{'loginlogout'}",
    'kernel'         => "$Lang::tr{'kernel'}",
    'ipsec'          => 'IPsec',
    'openvpn'        => 'OpenVPN',
    'squid'          => "$Lang::tr{'proxy'}",
    'installpackage' => "$Lang::tr{'update transcript'}"
);

&General::getcgihash(\%cgiparams);
$logsettings{'LOGVIEW_REVERSE'}  = 'off';
$logsettings{'LOGVIEW_VIEWSIZE'} = 150;
&General::readhash("${General::swroot}/logging/settings", \%logsettings);

my $start = ($logsettings{'LOGVIEW_REVERSE'} eq 'on') ? 0x7FFFF000 : 0;    #index of firts line number to display

if ($ENV{'QUERY_STRING'} && $cgiparams{'ACTION'} ne $Lang::tr{'update'}) {
    my @temp = split(',', $ENV{'QUERY_STRING'});
    $start                = $temp[0];
    $cgiparams{'MONTH'}   = $temp[1];
    $cgiparams{'DAY'}     = $temp[2];
    $cgiparams{'SECTION'} = $temp[3];
}

if (!($cgiparams{'MONTH'} =~ /^(0|1|2|3|4|5|6|7|8|9|10|11)$/)
    || !($cgiparams{'DAY'} =~
        /^(0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31)$/))
{
    $cgiparams{'DAY'}   = $now[3];
    $cgiparams{'MONTH'} = $now[4];
}
elsif ($cgiparams{'ACTION'} eq '>>') {
    my @temp_then = ();
    my @temp_now  = localtime(time);
    $temp_now[4] = $cgiparams{'MONTH'};
    $temp_now[3] = $cgiparams{'DAY'};
    if ($cgiparams{'DAY'}) {
        @temp_then = localtime(POSIX::mktime(@temp_now) + 86400);
        ## Retrieve the same time on the next day +
        ## 86400 seconds in a day
    }
    else {
        $temp_now[3]  = 1;
        $temp_now[4]  = ($temp_now[4] + 1) % 12;
        @temp_then    = localtime(POSIX::mktime(@temp_now));
        $temp_then[3] = 0;
    }
    $cgiparams{'MONTH'} = $temp_then[4];
    $cgiparams{'DAY'}   = $temp_then[3];
}
elsif ($cgiparams{'ACTION'} eq '<<') {
    my @temp_then = ();
    my @temp_now  = localtime(time);
    $temp_now[4] = $cgiparams{'MONTH'};
    $temp_now[3] = $cgiparams{'DAY'};
    if ($cgiparams{'DAY'}) {
        @temp_then = localtime(POSIX::mktime(@temp_now) - 86400);
        ## Retrieve the same time on the next day -
        ## 86400 seconds in a day
    }
    else {
        $temp_now[3]  = 1;
        $temp_now[4]  = ($temp_now[4] - 1) % 12;
        @temp_then    = localtime(POSIX::mktime(@temp_now));
        $temp_then[3] = 0;
    }
    $cgiparams{'MONTH'} = $temp_then[4];
    $cgiparams{'DAY'}   = $temp_then[3];
}

# Find in which file.gz is the log. Can be calculated because WEEKLY ROTATING of access.log
my $gzindex;
my $date = $cgiparams{'DAY'} == 0 ? '' : $cgiparams{'DAY'} <= 9 ? "0$cgiparams{'DAY'}" : "$cgiparams{'DAY'}";
my $month = $cgiparams{'MONTH'}+1;
$month = $month <= 9 ? "0$month" : "$month";

{
    my $xday;

    # Calculate time. If future date, calculate for past year !!!
    if (   ($cgiparams{'MONTH'} eq $now[4]) && ($cgiparams{'DAY'} > $now[3])
        || ($cgiparams{'MONTH'} > $now[4])) {
	$year--;
    }
    $xday = POSIX::mktime(0, 0, 0, $cgiparams{'DAY'}, $cgiparams{'MONTH'}, $year - 1900);
    $date = "$year-$month-$date";

    # calculate end of active week (saturday 23H59)
    my @then = ();
    @then = localtime(time());
    my $sunday = POSIX::mktime(0, 0, 0, $then[3], $then[4], $then[5]);
    $sunday += (6 - $then[6]) * 86400;

    # Convert delta in second to full weeks
    $gzindex = int(($sunday - $xday) / 604800);
}

my $monthstr = $shortmonths[ $cgiparams{'MONTH'} ];
my $daystr   = $cgiparams{'DAY'} == 0 ? '..' : $cgiparams{'DAY'} <= 9 ? " $cgiparams{'DAY'}" : "$cgiparams{'DAY'}";
my $section  = $sections{$cgiparams{'SECTION'}};

my $lines = 0;
my @log   = ();

my $loop    = 1;
my $filestr = 0;
my $lastdatetime;    # for debug
my $search_for_end = 0;

while ($gzindex >= 0 && $loop) {

    # calculate file name
    if ($gzindex == 0) {
        $filestr = "/var/log/messages";
    }
    else {
        $filestr = "/var/log/messages.$gzindex";
        $filestr = "$filestr.gz" if -f "$filestr.gz";
    }

    # now read file if existing
    if (open(FILE, ($filestr =~ /.gz$/ ? "gzip -dc $filestr |" : $filestr))) {

        #&General::log("reading $filestr");
        READ: while (<FILE>) {
            my $line = $_;
            if ($line =~ /^${monthstr} ${daystr} ..:..:.. [\w\-]+ ${section}: (.*)/) {
                # when standart viewing, just keep in memory the correct slice
                # it starts a '$start' and size is $viewport
                # If export, then keep all lines...
                if ($cgiparams{'ACTION'} eq $Lang::tr{'export'}) {
                    $log[ $lines++ ] = "$line";
                }
                else {
                    if ($lines++ < ($start + $logsettings{'LOGVIEW_VIEWSIZE'})) {
                        push(@log, "$line");
                        if (@log > $logsettings{'LOGVIEW_VIEWSIZE'}) {
                            shift(@log);
                        }

                        #} else { dont do this optimisation, need to count lines !
                        #    $datetime = $maxtime; # we have read viewsize lines, stop main loop
                        #    last READ;           # exit read file
                    }
                }
                $search_for_end = 1;    # we find the start of slice, can look for end now
            }
            else {
                if ($search_for_end == 1) {

                    #finish read files when date is over (test month equality only)
                    $line =~ /^(...) (..) ..:..:..*$/;
                    $loop = 0 if (($1 ne $monthstr) || (($daystr ne '..') && ($daystr ne $2)));
                }
            }
        }
        close(FILE);
    }
    $gzindex--;    # will try next gz file eg 40,39,38,.... because it may have holes when ipcop stopped
                   # for a long time
}    # while

#  $errormessage = "$Lang::tr{'date not in logs'}: $filestr $Lang::tr{'could not be opened'}";

if ($cgiparams{'ACTION'} eq $Lang::tr{'export'}) {
    print "Content-type: text/plain\n";
    print "Content-Disposition: attachment; filename=\"ipcop-$cgiparams{'SECTION'}-$date.log\";\n";
    print "\n";
    print "IPCop diagnostics\r\n";
    print "$Lang::tr{'section'}: $cgiparams{'SECTION'}\n";
    print "$Lang::tr{'date'}: $date\r\n\r\n";

    if ($logsettings{'LOGVIEW_REVERSE'} eq 'on') { @log = reverse @log; }

    foreach $_ (@log) {
        /^... (..) (..:..:..) [\w\-]+ ${section}: (.*)$/;
        my $day = $1;
        $day =~ tr / /0/;
        my $time = $cgiparams{'DAY'} ? "$2" : "$day/$2";
        print "$time $3 $4\r\n";
    }
    exit 0;
}

&Header::showhttpheaders();

&Header::openpage($Lang::tr{'system logs'}, 1, '');

&Header::openbigbox('100%', 'left', '');

if ($errormessage) {
    &Header::openbox('100%', 'left', "$Lang::tr{'error messages'}:", 'error');
    print "<font class='base'>$errormessage&nbsp;</font>\n";
    &Header::closebox();
}

&Header::openbox('100%', 'left', "$Lang::tr{'settings'}:");

print <<END
<form method='post' action='$ENV{'SCRIPT_NAME'}'>
<table width='100%'>
<tr>
	<td width='25%' class='base' nowrap='nowrap'>$Lang::tr{'section'}:&nbsp;
	<select name='SECTION'>
END
    ;
foreach $section (keys %sections) {
    print "\t<option ";
    if ($section eq $cgiparams{'SECTION'}) {
        print "selected='selected' ";
    }
    print "value='$section'>$trsections{$section}</option>\n";
}
print <<END
	</select>
	</td>
	<td width='35%' class='base' nowrap='nowrap'>&nbsp;&nbsp;$Lang::tr{'month'}:&nbsp;
	<select name='MONTH'>
END
    ;
for (my $month = 0; $month < 12; $month++) {
    print "\t<option ";
    if ($month == $cgiparams{'MONTH'}) {
        print "selected='selected' ";
    }
    print "value='$month'>$longmonths[$month]</option>\n";
}
print <<END
	</select>
	&nbsp;&nbsp;$Lang::tr{'day'}:&nbsp;
	<select name='DAY'>
END
    ;
print "<option value='0'>$Lang::tr{'all'}</option>\n";
for (my $day = 1; $day <= 31; $day++) {
    print "\t<option ";
    if ($day == $cgiparams{'DAY'}) {
        print "selected='selected' ";
    }
    print "value='$day'>$day</option>\n";
}
print <<END
	</select>
	</td>
	<td width='35%'  align='center'>
		<input type='submit' name='ACTION' title='$Lang::tr{'day before'}' value='&lt;&lt;' />
		<input type='submit' name='ACTION' title='$Lang::tr{'day after'}' value='&gt;&gt;' />
		<input type='submit' name='ACTION' value='$Lang::tr{'update'}' />
		<input type='submit' name='ACTION' value='$Lang::tr{'export'}' />
	</td>
    <td class='onlinehelp'>
        <a href='${General::adminmanualurl}/logs-system.html' target='_blank'><img src='/images/web-support.png' alt='$Lang::tr{'online help en'}' title='$Lang::tr{'online help en'}' /></a>
    </td>
</tr>
</table>
</form>
END
    ;

&Header::closebox();

&Header::openbox('100%', 'left', "$Lang::tr{'log'}:");
print "<p><b>$Lang::tr{'total hits for log section'} $cgiparams{'SECTION'} $date: $lines</b></p>";

$start = $lines - $logsettings{'LOGVIEW_VIEWSIZE'} if ($start >= $lines - $logsettings{'LOGVIEW_VIEWSIZE'});
$start = 0 if ($start < 0);

my $prev;
if ($start == 0) {
    $prev = -1;
}
else {
    $prev = $start - $logsettings{'LOGVIEW_VIEWSIZE'};
    $prev = 0 if ($prev < 0);
}

my $next;
if ($start == $lines - $logsettings{'LOGVIEW_VIEWSIZE'}) {
    $next = -1;
}
else {
    $next = $start + $logsettings{'LOGVIEW_VIEWSIZE'};
    $next = $lines - $logsettings{'LOGVIEW_VIEWSIZE'} if ($next >= $lines - $logsettings{'LOGVIEW_VIEWSIZE'});
}

if ($logsettings{'LOGVIEW_REVERSE'} eq 'on') { @log = reverse @log; }
if ($lines != 0) { &oldernewer(); }

print <<END
<table width='100%'>
<tr>
	<td width='10%' align='center' class='boldbase'><b>$Lang::tr{'time'}</b></td>
	<td width='15%' align='center' class='boldbase'><b>$Lang::tr{'section'}</b></td>
	<td width='75%'>&nbsp;</td>
</tr>
END
    ;

$lines = 0;

#print '<tt>';
foreach $_ (@log) {
    /^... (..) (..:..:..) [\w\-]+ ${section}: (.*)$/;
    my $day = $1;
    $day =~ tr / /0/;
    my $time = $cgiparams{'DAY'} ? "$2" : "$day/$2";
    my $sec  = $3;
    my $data = $4;

    # correct the cut position, just when section=RED
    if (($cgiparams{'SECTION'} eq 'red') && ($sec =~ /(kernel:)(.*)/)) {
        $sec  = 'kernel';
        $data = $2 . ': ' . $data;
    }
    my $d = substr($data, 0, 80);
    while (length($data) > 80) {
        $data = substr($data, 80);
        # Insert a space if none found in last 25 characters to aid line breaking
        $d .= ' ' if (index(substr($d, -25), ' ') == -1);
        $d .= substr($data, 0, 80);
    }

    print "<tr class='table".int(($lines % 2) + 1)."colour'>";
    print "<td>$time</td><td>$sec</td><td>" . &Header::cleanhtml("$d", 'y') . "</td></tr>\n";
    $lines++;
}

#print '</tt>';
print "</table>";

&oldernewer();

&Header::closebox();

&Header::closebigbox();

&Header::closepage();

sub oldernewer {
    print <<END
<table width='100%'>
<tr>
END
        ;

    print "<td align='center' width='50%'>";
    if ($prev != -1) {
        print
"<a href='/cgi-bin/logsystem.cgi?$prev,$cgiparams{'MONTH'},$cgiparams{'DAY'},$cgiparams{'SECTION'}'>$Lang::tr{'older'}</a>";
    }
    else {
        print "$Lang::tr{'older'}";
    }
    print "</td>\n";

    print "<td align='center' width='50%'>";
    if ($next >= 0) {
        print
"<a href='/cgi-bin/logsystem.cgi?$next,$cgiparams{'MONTH'},$cgiparams{'DAY'},$cgiparams{'SECTION'}'>$Lang::tr{'newer'}</a>";
    }
    else {
        print "$Lang::tr{'newer'}";
    }
    print "</td>\n";

    print <<END
</tr>
</table>
END
        ;
}
