#!/usr/bin/perl
#
############################################################################
#                                                                          #
# This file is part of the IPCop Firewall.                                 #
#                                                                          #
# IPCop is free software; you can redistribute it and/or modify            #
# it under the terms of the GNU General Public License as published by     #
# the Free Software Foundation; either version 2 of the License, or        #
# (at your option) any later version.                                      #
#                                                                          #
# IPCop is distributed in the hope that it will be useful,                 #
# but WITHOUT ANY WARRANTY; without even the implied warranty of           #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            #
# GNU General Public License for more details.                             #
#                                                                          #
# You should have received a copy of the GNU General Public License        #
# along with IPCop; if not, write to the Free Software                     #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA #
#                                                                          #
#                                                                          #
# $Id: comp_md5.pl 4011 2009-12-14 14:20:34Z owes $
#                                                                          #
############################################################################


my ( $file_version, $file_previousversion, $file_update, $file_known );
my ( %md5_version, %md5_previousversion, %update, %known );
my $kernel_update = 'ABCnevermatches';

# We want a total of 4 parameters
# BaseDirectory, version, previous version, machine
if (defined($ARGV[0]) && defined($ARGV[1]) && defined($ARGV[2]) && defined($ARGV[3])) {
    $file_version = "$ARGV[0]/doc/IPCop-$ARGV[1]-all-files-list.$ARGV[3].txt.md5";
    $file_previousversion = "$ARGV[0]//doc/IPCop-$ARGV[2]-all-files-list.$ARGV[3].txt.md5";
    $file_update = "$ARGV[0]/updates/$ARGV[1]/ROOTFILES.$ARGV[3]-$ARGV[1]";
    $file_known = "$ARGV[0]/doc/files-with-different-md5";
}
else {
    die "Parameters missing";
}

# Check whether files exist
die "$file_version not found" unless (-e $file_version);
die "$file_previousversion not found" unless (-e $file_previousversion);
die "$file_update not found" unless (-e $file_update);
die "$file_known not found" unless (-e $file_known);

open (LIST, "$file_update") or die "Unable to open $file_update";
while (<LIST>) {
    next if $_ =~ m/^#/;
    chomp($_);
    $update{$_} = 1;
    # Special hack to filter all kernel modules in case of kernel update
    $kernel_update = $_ if ($_ =~ /^\/lib\/modules\/.*\/kernel$/);
}
close (LIST);

open (LIST, "$file_version") or die "Unable to open $file_version";
while (<LIST>) {
    next if $_ =~ m/^#/;
    chomp($_);
    my @temp = split(/ /,$_);
    next if ($temp[2] =~ /^${kernel_update}/);
    $md5_version{$temp[2]} = $temp[0];
}
close (LIST);

open (LIST, "$file_previousversion") or die "Unable to open $file_previousversion";
while (<LIST>) {
    next if $_ =~ m/^#/;
    chomp($_);
    my @temp = split(/ /,$_);
    $md5_previousversion{$temp[2]} = $temp[0];
}
close (LIST);

open (LIST, "$file_known") or die "Unable to open $file_known";
while (<LIST>) {
    next if $_ =~ m/^#/;
    chomp($_);
    my @temp = split(/\s+/,$_);
    $known{$temp[0]} = 1;
}
close (LIST);

open (OUTLIST, ">diff.tmp") or die "Unable to create diff list";
print OUTLIST "# Comparing md5 for each file in $ARGV[1] to $ARGV[2]\n";
print OUTLIST "UPDATEK $kernel_update\n" if ($kernel_update ne 'ABCnevermatches');

for my $file (sort keys %md5_version) {
    if (!defined($md5_previousversion{$file})) {
        if (defined($update{$file})) {
            print OUTLIST "NEWUPD  $file\n";
        }
        else {
            print OUTLIST "NEW     $file\n";
        }
        next;
    }

    next if ($md5_version{$file} eq $md5_previousversion{$file});

    if (defined($update{$file})) {
        # This one is different but we already have it in update
        print OUTLIST "UPDATE  $file\n";
        next;
    }
    
    if (defined($known{$file})) {
        # This one is different and we know about
        print OUTLIST "KNOWN   $file\n";
        next;
    }
    
    print OUTLIST "DIFF    $file\n";
}
close (OUTLIST);

system("sort diff.tmp > $ARGV[0]/doc/IPCop-$ARGV[1]-diff-list.$ARGV[3].txt");
system("rm diff.tmp");
