#!/bin/bash
#
# This file is part of the IPCop Firewall.
# (c) Gilles Espinasse
#
# Universal upgrade script
# - called after every restore (from installation or backup)
# - place a call on update only if a new fix was added
# - every change on data include in backup need to be there
#   and not in update setup
#
# $Id: upgrade.sh 4107 2010-01-10 17:29:40Z owes $
#


# Tweak ntp.conf file if NTPd is running (modified in 1.9.11)
if [ -e /var/run/ntpd.pid ]; then
    /bin/sed -i -e "s+^fudge\s*127\.127\.1\.0.*+fudge  127.127.1.0 stratum 7+" \
                -e "s+^driftfile.*+driftfile /var/log/ntp/drift+" /var/ipcop/time/ntp.conf
fi

# OpenVPN config file, modified in 1.9.11
if [ -e /var/ipcop/openvpn/server.conf ]; then
    TMP=`grep "script-security" /var/ipcop/openvpn/server.conf`
    if [ "x$TMP" == "x" ]; then
        echo "script-security 2" >> /var/ipcop/openvpn/server.conf
    fi
fi
