#!/usr/bin/perl
#
# IPCop CGIs
#
# This code is distributed under the terms of the GPL
#
# (c) The IPCop Team
#
# $Id: logconfig.cgi 3935 2009-12-08 11:47:51Z owes $
#

# Add entry in menu
# MENUENTRY logs 010 "log settings" "log settings"
#
# Make sure translation exists $Lang::tr{'log'}

use strict;

# enable only the following on debugging purpose
#use warnings;
#use CGI::Carp 'fatalsToBrowser';

require '/usr/lib/ipcop/general-functions.pl';
require '/usr/lib/ipcop/lang.pl';
require '/usr/lib/ipcop/header.pl';

my %logsettings  = ();
my %checked      = ();
my %selected     = ();
my $errormessage = '';
my $error        = '';

&Header::showhttpheaders();

$logsettings{'LOGVIEW_REVERSE'}  = 'off';
$logsettings{'LOGVIEW_VIEWSIZE'} = '150';
$logsettings{'LOGWATCH_LEVEL'}   = 'Low';
$logsettings{'LOGWATCH_KEEP'}    = '56';
my @VS = ('15', '50', '100', '150', '250', '500');
$logsettings{'ENABLE_REMOTELOG'} = 'off';
$logsettings{'REMOTELOG_ADDR'}   = '';
$logsettings{'ACTION'}           = '';
&General::getcgihash(\%logsettings);

if ($logsettings{'ACTION'} eq $Lang::tr{'save'}) {
    if ($logsettings{'ENABLE_REMOTELOG'} eq 'on') {
        unless (&General::validfqdn($logsettings{'REMOTELOG_ADDR'})
            || &General::validip($logsettings{'REMOTELOG_ADDR'}))
        {
            $errormessage = $Lang::tr{'invalid logserver address'};
        }
    }
    unless ($logsettings{'LOGWATCH_KEEP'} =~ /^\d+$/) {
        $errormessage = $Lang::tr{'invalid keep time'};
    }
    unless ($logsettings{'LOGWATCH_LEVEL'} =~ /^Low|Med|High$/) {
        $errormessage = $Lang::tr{'invalid input'};
    }
    unless ($errormessage) {
        &General::writehash("${General::swroot}/logging/settings", \%logsettings);
        system('/usr/local/bin/restartsyslogd') == 0
            or $errormessage = "$Lang::tr{'bad return code'} " . $? / 256;
    }

}

&General::readhash("${General::swroot}/logging/settings", \%logsettings);

$checked{'ENABLE_REMOTELOG'}{'off'}                            = '';
$checked{'ENABLE_REMOTELOG'}{'on'}                             = '';
$checked{'ENABLE_REMOTELOG'}{$logsettings{'ENABLE_REMOTELOG'}} = "checked='checked'";

$checked{'LOGVIEW_REVERSE'}{'off'}                           = '';
$checked{'LOGVIEW_REVERSE'}{'on'}                            = '';
$checked{'LOGVIEW_REVERSE'}{$logsettings{'LOGVIEW_REVERSE'}} = "checked='checked'";

$selected{'LOGWATCH_LEVEL'}{'Low'}                          = '';
$selected{'LOGWATCH_LEVEL'}{'Med'}                          = '';
$selected{'LOGWATCH_LEVEL'}{'High'}                         = '';
$selected{'LOGWATCH_LEVEL'}{$logsettings{'LOGWATCH_LEVEL'}} = "selected='selected'";

map ($selected{'LOGVIEW_VIEWSIZE'}{$_} = '', @VS);
$selected{'LOGVIEW_VIEWSIZE'}{$logsettings{'LOGVIEW_VIEWSIZE'}} = "selected='selected'";

&Header::openpage($Lang::tr{'log settings'}, 1, '');

&Header::openbigbox('100%', 'left', '');

if ($errormessage) {
    &Header::openbox('100%', 'left', "$Lang::tr{'error messages'}:", 'error');
    print "<font class='base'>$errormessage&nbsp;</font>\n";
    &Header::closebox();

    $error = 'error';
}

print "<form method='post' action='$ENV{'SCRIPT_NAME'}'>\n";

&Header::openbox('100%', 'left', $Lang::tr{'log settings'}, $error);
print <<END
<table width='100%'>
<tr>
	<td colspan='4' class='base'><b>$Lang::tr{'log viewing options'}</b></td>
</tr><tr>
	<td width='25%' class='base'>$Lang::tr{'reverse sort'}:</td>
	<td width='25%'><input type='checkbox' name='LOGVIEW_REVERSE' $checked{'LOGVIEW_REVERSE'}{'on'} /></td>
	<td width='25%' class='base'>$Lang::tr{'log lines per page'}:</td>
	<td width='25%'><select name='LOGVIEW_VIEWSIZE'>
END
    ;
foreach my $vs (@VS) {
    print "\t<option value='$vs' $selected{'LOGVIEW_VIEWSIZE'}{$vs}>$vs</option>\n";
}
print <<END
	</select></td>
</tr><tr>
	<td colspan='4'><hr /><b>$Lang::tr{'log summaries'}</b></td>
</tr><tr>
	<td width='25%' class='base'>$Lang::tr{'summaries kept'}:</td>
	<td width='25%' class='base'><input type='text' name='LOGWATCH_KEEP' value='$logsettings{'LOGWATCH_KEEP'}' size='4' />&nbsp;$Lang::tr{'days'}</td>
	<td width='25%' class='base'>$Lang::tr{'detail level'}:</td>
	<td  width='25%'>
		<select name='LOGWATCH_LEVEL'>
		<option value='Low' $selected{'LOGWATCH_LEVEL'}{'Low'}>$Lang::tr{'low'}</option>
		<option value='Med' $selected{'LOGWATCH_LEVEL'}{'Med'}>$Lang::tr{'medium'}</option>
		<option value='High' $selected{'LOGWATCH_LEVEL'}{'High'}>$Lang::tr{'high'}</option>
		</select>
	</td>
</tr><tr>
	<td colspan='4'><hr /><b>$Lang::tr{'remote logging'}</b></td>
</tr><tr>
	<td width='25%' class='base'>$Lang::tr{'enabled'}:</td>
	<td width='25%'><input type='checkbox' name='ENABLE_REMOTELOG' $checked{'ENABLE_REMOTELOG'}{'on'} /></td>
	<td width='25%' class='base'>$Lang::tr{'log server address'}:</td>
	<td width='25%'><input type='text' name='REMOTELOG_ADDR' value='$logsettings{'REMOTELOG_ADDR'}' /></td>
</tr>
</table>
<hr />
<table width='100%'>
<tr>
    <td class='comment1button'> &nbsp; </td>
    <td class='button1button'><input type='submit' name='ACTION' value='$Lang::tr{'save'}' /></td>
    <td class='onlinehelp'>
        <a href='${General::adminmanualurl}/logs-settings.html' target='_blank'><img src='/images/web-support.png' alt='$Lang::tr{'online help en'}' title='$Lang::tr{'online help en'}' /></a>
    </td>
</tr>
</table>
END
    ;
&Header::closebox();

print "</form>\n";

&Header::closebigbox();

&Header::closepage();
