/* Copyright (c) 2018 Synology Inc. All rights reserved. */

/*


 SoundManager 2: JavaScript Sound for the Web
 ----------------------------------------------
 http://schillmania.com/projects/soundmanager2/

 Copyright (c) 2007, Scott Schiller. All rights reserved.
 Code provided under the BSD License:
 http://schillmania.com/projects/soundmanager2/license.txt

 V2.97a.20131201
*/
(function(q,j){function db(Db,Eb){function qa(c){return b.preferFlash&&O&&!b.ignoreFlash&&b.flash[c]!==j&&b.flash[c]}function A(c){return function(a){var d=this._s;if(!d||!d._a){d&&d.id?b._wD(d.id+": Ignoring "+a.type):b._wD(Fb+"Ignoring "+a.type);a=null}else a=c.call(this,a);return a}}this.setupOptions={url:Db||null,flashVersion:8,debugMode:true,debugFlash:false,useConsole:true,consoleOnly:true,waitForWindowLoad:false,bgColor:"#ffffff",useHighPerformance:false,flashPollingInterval:null,html5PollingInterval:null,
flashLoadTimeout:1E3,wmode:null,allowScriptAccess:"always",useFlashBlock:false,useHTML5Audio:true,html5Test:/^(probably|maybe)$/i,preferFlash:false,noSWFCache:false,idPrefix:"sound"};this.defaultOptions={autoLoad:false,autoPlay:false,from:null,loops:1,onid3:null,onload:null,whileloading:null,onplay:null,onpause:null,onresume:null,whileplaying:null,onposition:null,onstop:null,onfailure:null,onfinish:null,multiShot:true,multiShotEvents:false,position:null,pan:0,stream:true,to:null,type:null,usePolicyFile:false,
volume:100};this.flash9Options={isMovieStar:null,usePeakData:false,useWaveformData:false,useEQData:false,onbufferchange:null,ondataerror:null};this.movieStarOptions={bufferTime:3,serverURL:null,onconnect:null,duration:null};this.audioFormats={mp3:{type:['audio/mpeg; codecs="mp3"',"audio/mpeg","audio/mp3","audio/MPA","audio/mpa-robust"],required:true},mp4:{related:["m4a","m4b"],type:['audio/mp4; codecs="mp4a.40.2"',"audio/x-m4a","audio/MP4A-LATM","audio/mpeg4-generic"],required:false},ogg:{type:["audio/ogg; codecs=vorbis"],
required:false},opus:{type:["audio/ogg; codecs=opus","audio/opus"],required:false},wav:{type:['audio/wav; codecs="1"',"audio/wav","audio/wave","audio/x-wav"],required:false}};this.movieID="sm2-container";this.id=Eb||"sds_sm2movie";this.debugID="soundmanager-debug";this.debugURLParam=/([#?&])debug=1/i;this.versionNumber="V2.97a.20131201";this.altURL=this.movieURL=this.version=null;this.enabled=this.swfLoaded=false;this.oMC=null;this.sounds={};this.soundIDs=[];this.didFlashBlock=this.muted=false;this.filePattern=
null;this.filePatterns={flash8:/\.mp3(\?.*)?$/i,flash9:/\.mp3(\?.*)?$/i};this.features={buffering:false,peakData:false,waveformData:false,eqData:false,movieStar:false};this.sandbox={type:null,types:{remote:"remote (domain-based) rules",localWithFile:"local with file access (no internet access)",localWithNetwork:"local with network (internet access only, no local access)",localTrusted:"local, trusted (local+internet access)"},description:null,noRemote:null,noLocal:null};this.html5={usingFlash:null};
this.flash={};this.ignoreFlash=this.html5Only=false;var eb,b=this,fb=null,o=null,Fb="HTML5::",L,C=navigator.userAgent,da=q.location.href.toString(),r=document,Fa,gb,Ga,s,P=[],Ha=true,K,ea=false,fa=false,x=false,I=false,ra=false,u,Gb=0,ga,E,Ia,Y,Ja,W,Z,$,hb,Ka,La,Ma,S,sa,Na,aa,Oa,ha,ta,ua,ba,ib,Pa,jb=["log","info","warn","error"],kb,Qa,lb,ia=null,Ra=null,v,Sa,ca,z,mb,va,wa,T,w,ja=false,Ta=false,nb,ob,pb,xa=0,ka=null,ya,X=[],la,G=null,qb,za,ma,U,Aa,Ua,rb,B,sb=Array.prototype.slice,M=false,Va,O,Wa,tb,
Q,ub,Xa,Ba,vb=0,Ca=C.match(/(ipad|iphone|ipod)/i),wb=C.match(/android/i),V=C.match(/msie/i),Hb=C.match(/webkit/i),Da=C.match(/safari/i)&&!C.match(/chrome/i),Ya=C.match(/opera/i),Za=C.match(/(mobile|pre\/|xoom)/i)||Ca||wb,$a=!da.match(/usehtml5audio/i)&&!da.match(/sm2\-ignorebadua/i)&&Da&&!C.match(/silk/i)&&C.match(/OS X 10_6_([3-7])/i),na=q.console!==j&&console.log!==j,ab=r.hasFocus!==j?r.hasFocus():null,Ea=Da&&(r.hasFocus===j||!r.hasFocus()),xb=!Ea,yb=/(mp3|mp4|mpa|m4a|m4b)/i,oa=r.location?r.location.protocol.match(/http/i):
null,zb=!oa?"http://":"",Ab=/^\s*audio\/(?:x-)?(?:mpeg4|flv|mov|mp4||m4v|m4a|m4b|mp4v|3gp|3g2)\s*(?:$|;)/i,Bb=["mpeg4","flv","mov","mp4","m4v","f4v","m4a","m4b","mp4v","3gp","3g2"],Ib=new RegExp("\\.("+Bb.join("|")+")(\\?.*)?$","i");this.mimePattern=/^\s*audio\/(?:x-)?(?:mp(?:eg|3))\s*(?:$|;)/i;this.useAltURL=!oa;z={swfBox:"sm2-object-box",swfDefault:"movieContainer",swfError:"swf_error",swfTimedout:"swf_timedout",swfLoaded:"swf_loaded",swfUnblocked:"swf_unblocked",sm2Debug:"sm2_debug",highPerf:"high_performance",
flashDebug:"flash_debug"};this.hasHTML5=function(){try{return Audio!==j&&(Ya&&opera!==j&&opera.version()<10?new Audio(null):new Audio).canPlayType!==j}catch(c){return false}}();this.setup=function(c){var a=!b.url;if(c!==j&&x&&G&&b.ok()&&(c.flashVersion!==j||c.url!==j||c.html5Test!==j))T(v("setupLate"));Ia(c);if(c){a&&ha&&c.url!==j&&b.beginDelayedInit();!ha&&c.url!==j&&r.readyState==="complete"&&setTimeout(aa,1)}return b};this.supported=this.ok=function(){return G?x&&!I:b.useHTML5Audio&&b.hasHTML5};
this.getMovie=function(c){return L(c)||r[c]||q[c]};this.createSound=function(c,a){function d(){h=va(h);b.sounds[h.id]=new eb(h);b.soundIDs.push(h.id);return b.sounds[h.id]}var g,h;g=null;g="soundManager.createSound(): "+v(!x?"notReady":"notOK");if(!x||!b.ok()){T(g);return false}if(a!==j)c={id:c,url:a};h=E(c);h.url=ya(h.url);if(h.id===undefined)h.id=b.setupOptions.idPrefix+vb++;h.id.toString().charAt(0).match(/^[0-9]$/)&&b._wD("soundManager.createSound(): "+v("badID",h.id),2);b._wD("soundManager.createSound(): "+
h.id+(h.url?" ("+h.url+")":""),1);if(w(h.id,true)){b._wD("soundManager.createSound(): "+h.id+" exists",1);return b.sounds[h.id]}if(za(h)){g=d();b._wD(h.id+": Using HTML5");g._setup_html5(h)}else{if(b.html5Only){b._wD(h.id+": No HTML5 support for this sound, and no Flash. Exiting.");return d()}if(b.html5.usingFlash&&h.url&&h.url.match(/data\:/i)){b._wD(h.id+": data: URIs not supported via Flash. Exiting.");return d()}if(s>8){if(h.isMovieStar===null)h.isMovieStar=!!(h.serverURL||(h.type?h.type.match(Ab):
false)||h.url&&h.url.match(Ib));if(h.isMovieStar){b._wD("soundManager.createSound(): using MovieStar handling");h.loops>1&&u("noNSLoop")}}h=wa(h,"soundManager.createSound(): ");g=d();if(s===8)o._createSound(h.id,h.loops||1,h.usePolicyFile);else{o._createSound(h.id,h.url,h.usePeakData,h.useWaveformData,h.useEQData,h.isMovieStar,h.isMovieStar?h.bufferTime:false,h.loops||1,h.serverURL,h.duration||null,h.autoPlay,true,h.autoLoad,h.usePolicyFile);if(!h.serverURL){g.connected=true;h.onconnect&&h.onconnect.apply(g)}}if(!h.serverURL&&
(h.autoLoad||h.autoPlay))g.load(h)}!h.serverURL&&h.autoPlay&&g.play();return g};this.destroySound=function(c,a){if(!w(c))return false;var d=b.sounds[c],g;d._iO={};d.stop();d.unload();for(g=0;g<b.soundIDs.length;g++)if(b.soundIDs[g]===c){b.soundIDs.splice(g,1);break}a||d.destruct(true);delete b.sounds[c];return true};this.load=function(c,a){if(!w(c))return false;return b.sounds[c].load(a)};this.unload=function(c){if(!w(c))return false;return b.sounds[c].unload()};this.onposition=this.onPosition=function(c,
a,d,g){if(!w(c))return false;return b.sounds[c].onposition(a,d,g)};this.clearOnPosition=function(c,a,d){if(!w(c))return false;return b.sounds[c].clearOnPosition(a,d)};this.start=this.play=function(c,a){var d=null,g=a&&!(a instanceof Object);if(!x||!b.ok()){T("soundManager.play(): "+v(!x?"notReady":"notOK"));return false}if(w(c,g)){if(g)a={url:a}}else{if(!g)return false;if(g)a={url:a};if(a&&a.url){b._wD('soundManager.play(): Attempting to create "'+c+'"',1);a.id=c;d=b.createSound(a).play()}}if(d===
null)d=b.sounds[c].play(a);return d};this.setPosition=function(c,a){if(!w(c))return false;return b.sounds[c].setPosition(a)};this.stop=function(c){if(!w(c))return false;b._wD("soundManager.stop("+c+")",1);return b.sounds[c].stop()};this.stopAll=function(){var c;b._wD("soundManager.stopAll()",1);for(c in b.sounds)b.sounds.hasOwnProperty(c)&&b.sounds[c].stop()};this.pause=function(c){if(!w(c))return false;return b.sounds[c].pause()};this.pauseAll=function(){var c;for(c=b.soundIDs.length-1;c>=0;c--)b.sounds[b.soundIDs[c]].pause()};
this.resume=function(c){if(!w(c))return false;return b.sounds[c].resume()};this.resumeAll=function(){var c;for(c=b.soundIDs.length-1;c>=0;c--)b.sounds[b.soundIDs[c]].resume()};this.togglePause=function(c){if(!w(c))return false;return b.sounds[c].togglePause()};this.setPan=function(c,a){if(!w(c))return false;return b.sounds[c].setPan(a)};this.setVolume=function(c,a){if(!w(c))return false;return b.sounds[c].setVolume(a)};this.mute=function(c){var a=0;if(c instanceof String)c=null;if(c){if(!w(c))return false;
b._wD('soundManager.mute(): Muting "'+c+'"');return b.sounds[c].mute()}else{b._wD("soundManager.mute(): Muting all sounds");for(a=b.soundIDs.length-1;a>=0;a--)b.sounds[b.soundIDs[a]].mute();b.muted=true}return true};this.muteAll=function(){b.mute()};this.unmute=function(c){if(c instanceof String)c=null;if(c){if(!w(c))return false;b._wD('soundManager.unmute(): Unmuting "'+c+'"');return b.sounds[c].unmute()}else{b._wD("soundManager.unmute(): Unmuting all sounds");for(c=b.soundIDs.length-1;c>=0;c--)b.sounds[b.soundIDs[c]].unmute();
b.muted=false}return true};this.unmuteAll=function(){b.unmute()};this.toggleMute=function(c){if(!w(c))return false;return b.sounds[c].toggleMute()};this.getMemoryUse=function(){var c=0;if(o&&s!==8)c=parseInt(o._getMemoryUse(),10);return c};this.disable=function(c){var a;if(c===j)c=false;if(I)return false;I=true;u("shutdown",1);for(a=b.soundIDs.length-1;a>=0;a--)kb(b.sounds[b.soundIDs[a]]);ga(c);B.remove(q,"load",Z);return true};this.canPlayMIME=function(c){var a;if(b.hasHTML5)a=ma({type:c});if(!a&&
G)a=c&&b.ok()?!!((s>8?c.match(Ab):null)||c.match(b.mimePattern)):null;return a};this.canPlayURL=function(c){var a;if(b.hasHTML5)a=ma({url:c});if(!a&&G)a=c&&b.ok()?!!c.match(b.filePattern):null;return a};this.canPlayLink=function(c){if(c.type!==j&&c.type)if(b.canPlayMIME(c.type))return true;return b.canPlayURL(c.href)};this.getSoundById=function(c,a){if(!c)return null;var d=b.sounds[c];!d&&!a&&b._wD('soundManager.getSoundById(): Sound "'+c+'" not found.',2);return d};this.onready=function(c,a){var d=
false;if(typeof c==="function"){x&&b._wD(v("queue","onready"));a||(a=q);Ja("onready",c,a);W();d=true}else throw v("needFunction","onready");return d};this.ontimeout=function(c,a){var d=false;if(typeof c==="function"){x&&b._wD(v("queue","ontimeout"));a||(a=q);Ja("ontimeout",c,a);W({type:"ontimeout"});d=true}else throw v("needFunction","ontimeout");return d};this._writeDebug=function(c,a){var d,g;if(!b.debugMode)return false;if(na&&b.useConsole){if(a&&typeof a==="object")console.log(c,a);else jb[a]!==
j?console[jb[a]](c):console.log(c);if(b.consoleOnly)return true}d=L("soundmanager-debug");if(!d)return false;g=r.createElement("div");if(++Gb%2===0)g.className="sm2-alt";a=a===j?0:parseInt(a,10);g.appendChild(r.createTextNode(c));if(a){if(a>=2)g.style.fontWeight="bold";if(a===3)g.style.color="#ff3333"}d.insertBefore(g,d.firstChild);return true};if(da.indexOf("sm2-debug=alert")!==-1)this._writeDebug=function(c){q.alert(c)};this._wD=this._writeDebug;this._debug=function(){var c,a;u("currentObj",1);
c=0;for(a=b.soundIDs.length;c<a;c++)b.sounds[b.soundIDs[c]]._debug()};this.reboot=function(c,a){if(b.soundIDs.length)b._wD("Destroying "+b.soundIDs.length+" SMSound object"+(b.soundIDs.length!==1?"s":"")+"...");var d,g;for(d=b.soundIDs.length-1;d>=0;d--)b.sounds[b.soundIDs[d]].destruct();if(o)try{if(V)Ra=o.innerHTML;ia=o.parentNode.removeChild(o)}catch(h){u("badRemove",2)}Ra=ia=G=o=null;b.enabled=ha=x=ja=Ta=ea=fa=I=M=b.swfLoaded=false;b.soundIDs=[];b.sounds={};vb=0;if(c)P=[];else for(d in P)if(P.hasOwnProperty(d)){c=
0;for(g=P[d].length;c<g;c++)P[d][c].fired=false}a||b._wD("soundManager: Rebooting...");b.html5={usingFlash:null};b.flash={};b.html5Only=false;b.ignoreFlash=false;q.setTimeout(function(){Na();a||b.beginDelayedInit()},20);return b};this.reset=function(){u("reset");return b.reboot(true,true)};this.getMoviePercent=function(){return o&&"PercentLoaded"in o?o.PercentLoaded():null};this.beginDelayedInit=function(){ra=true;aa();setTimeout(function(){if(Ta)return false;ua();sa();return Ta=true},20);$()};this.destruct=
function(){b._wD("soundManager.destruct()");b.disable(true)};eb=function(c){var a=this,d,g,h,t,k,n,p=false,y=[],H=0,pa,D,J=null,N,bb;N={duration:null,time:null};this.sID=this.id=c.id;this.url=c.url;this._iO=this.instanceOptions=this.options=E(c);this.pan=this.options.pan;this.volume=this.options.volume;this.isHTML5=false;this._a=null;bb=this.url?false:true;this.id3={};this._debug=function(){b._wD(a.id+": Merged options:",a.options)};this.load=function(e){var f=null,i;if(e!==j)a._iO=E(e,a.options);
else{e=a.options;a._iO=e;if(J&&J!==a.url){u("manURL");a._iO.url=a.url;a.url=null}}if(!a._iO.url)a._iO.url=a.url;a._iO.url=ya(a._iO.url);i=a.instanceOptions=a._iO;b._wD(a.id+": load ("+i.url+")");if(!i.url&&!a.url){b._wD(a.id+": load(): url is unassigned. Exiting.",2);return a}!a.isHTML5&&s===8&&!a.url&&!i.autoPlay&&b._wD(a.id+": Flash 8 load() limitation: Wait for onload() before calling play().",1);if(i.url===a.url&&a.readyState!==0&&a.readyState!==2){u("onURL",1);a.readyState===3&&i.onload&&Ba(a,
function(){i.onload.apply(a,[!!a.duration])});return a}a.loaded=false;a.readyState=1;a.playState=0;a.id3={};if(za(i)){f=a._setup_html5(i);if(f._called_load)b._wD(a.id+": Ignoring request to load again");else{a._html5_canplay=false;if(a.url!==i.url){b._wD(u("manURL")+": "+i.url);a._a.src=i.url;a.setPosition(0)}a._a.autobuffer="auto";a._a.preload="auto";a._a._called_load=true}}else{if(b.html5Only){b._wD(a.id+": No flash support. Exiting.");return a}if(a._iO.url&&a._iO.url.match(/data\:/i)){b._wD(a.id+
": data: URIs not supported via Flash. Exiting.");return a}try{a.isHTML5=false;a._iO=wa(va(i));i=a._iO;s===8?o._load(a.id,i.url,i.stream,i.autoPlay,i.usePolicyFile):o._load(a.id,i.url,!!i.stream,!!i.autoPlay,i.loops||1,!!i.autoLoad,i.usePolicyFile)}catch(m){u("smError",2);K("onload",false);ba({type:"SMSOUND_LOAD_JS_EXCEPTION",fatal:true})}}a.url=i.url;return a};this.unload=function(){if(a.readyState!==0){b._wD(a.id+": unload()");if(a.isHTML5){t();if(a._a){a._a.pause();J=Aa(a._a)}}else s===8?o._unload(a.id,
"about:blank"):o._unload(a.id);d()}return a};this.destruct=function(e){b._wD(a.id+": Destruct");if(a.isHTML5){t();if(a._a){a._a.pause();Aa(a._a);M||h();a._a._s=null;a._a=null}}else{a._iO.onfailure=null;o._destroySound(a.id)}e||b.destroySound(a.id,true)};this.start=this.play=function(e,f){var i,m,l,R,cb,F=true;F=null;i=a.id+": play(): ";f=f===j?true:f;e||(e={});if(a.url)a._iO.url=a.url;a._iO=E(a._iO,a.options);a._iO=E(e,a._iO);a._iO.url=ya(a._iO.url);a.instanceOptions=a._iO;if(!a.isHTML5&&a._iO.serverURL&&
!a.connected){if(!a.getAutoPlay()){b._wD(i+" Netstream not connected yet - setting autoPlay");a.setAutoPlay(true)}return a}if(za(a._iO)){a._setup_html5(a._iO);k()}if(a.playState===1&&!a.paused)if(m=a._iO.multiShot)b._wD(i+"Already playing (multi-shot)",1);else{b._wD(i+"Already playing (one-shot)",1);a.isHTML5&&a.setPosition(a._iO.position);F=a}if(F!==null)return F;if(e.url&&e.url!==a.url)if(!a.readyState&&!a.isHTML5&&s===8&&bb)bb=false;else a.load(a._iO);if(a.loaded)b._wD(i.substr(0,i.lastIndexOf(":")));
else if(a.readyState===0){b._wD(i+"Attempting to load");if(!a.isHTML5&&!b.html5Only){a._iO.autoPlay=true;a.load(a._iO)}else if(a.isHTML5)a.load(a._iO);else{b._wD(i+"Unsupported type. Exiting.");F=a}a.instanceOptions=a._iO}else if(a.readyState===2){b._wD(i+"Could not load - exiting",2);F=a}else b._wD(i+"Loading - attempting to play...");if(F!==null)return F;if(!a.isHTML5&&s===9&&a.position>0&&a.position===a.duration){b._wD(i+"Sound at end, resetting to position:0");e.position=0}if(a.paused&&a.position>=
0&&(!a._iO.serverURL||a.position>0)){b._wD(i+"Resuming from paused state",1);a.resume()}else{a._iO=E(e,a._iO);if(a._iO.from!==null&&a._iO.to!==null&&a.instanceCount===0&&a.playState===0&&!a._iO.serverURL){m=function(){a._iO=E(e,a._iO);a.play(a._iO)};if(a.isHTML5&&!a._html5_canplay){b._wD(i+"Beginning load for from/to case");a.load({_oncanplay:m});F=false}else if(!a.isHTML5&&!a.loaded&&(!a.readyState||a.readyState!==2)){b._wD(i+"Preloading for from/to case");a.load({onload:m});F=false}if(F!==null)return F;
a._iO=D()}if(!a.instanceCount||a._iO.multiShotEvents||a.isHTML5&&a._iO.multiShot&&!M||!a.isHTML5&&s>8&&!a.getAutoPlay())a.instanceCount++;a._iO.onposition&&a.playState===0&&n(a);a.playState=1;a.paused=false;a.position=a._iO.position!==j&&!isNaN(a._iO.position)?a._iO.position:0;if(!a.isHTML5)a._iO=wa(va(a._iO));if(a._iO.onplay&&f){a._iO.onplay.apply(a);p=true}a.setVolume(a._iO.volume,true);a.setPan(a._iO.pan,true);if(a.isHTML5)if(a.instanceCount<2){k();f=a._setup_html5();a.setPosition(a._iO.position);
f.play()}else{b._wD(a.id+": Cloning Audio() for instance #"+a.instanceCount+"...");l=new Audio(a._iO.url);R=function(){B.remove(l,"ended",R);a._onfinish(a);Aa(l);l=null};cb=function(){B.remove(l,"canplay",cb);try{l.currentTime=a._iO.position/1E3}catch(Jb){T(a.id+": multiShot play() failed to apply position of "+a._iO.position/1E3)}l.play()};B.add(l,"ended",R);if(a._iO.volume!==undefined)l.volume=Math.max(0,Math.min(1,a._iO.volume/100));if(a.muted)l.muted=true;a._iO.position?B.add(l,"canplay",cb):
l.play()}else{F=o._start(a.id,a._iO.loops||1,s===9?a.position:a.position/1E3,a._iO.multiShot||false);if(s===9&&!F){b._wD(i+"No sound hardware, or 32-sound ceiling hit",2);a._iO.onplayerror&&a._iO.onplayerror.apply(a)}}}return a};this.stop=function(e){var f=a._iO;if(a.playState===1){b._wD(a.id+": stop()");a._onbufferchange(0);a._resetOnPosition(0);a.paused=false;if(!a.isHTML5)a.playState=0;pa();f.to&&a.clearOnPosition(f.to);if(a.isHTML5){if(a._a){e=a.position;a.setPosition(0);a.position=e;a._a.pause();
a.playState=0;a._onTimer();t()}}else{o._stop(a.id,e);f.serverURL&&a.unload()}a.instanceCount=0;a._iO={};f.onstop&&f.onstop.apply(a)}return a};this.setAutoPlay=function(e){b._wD(a.id+": Autoplay turned "+(e?"on":"off"));a._iO.autoPlay=e;if(!a.isHTML5){o._setAutoPlay(a.id,e);if(e)if(!a.instanceCount&&a.readyState===1){a.instanceCount++;b._wD(a.id+": Incremented instance count to "+a.instanceCount)}}};this.getAutoPlay=function(){return a._iO.autoPlay};this.setPosition=function(e){if(e===j)e=0;var f=
a.isHTML5?Math.max(e,0):Math.min(a.duration||a._iO.duration,Math.max(e,0));a.position=f;e=a.position/1E3;a._resetOnPosition(a.position);a._iO.position=f;if(a.isHTML5){if(a._a){if(a._html5_canplay){if(a._a.currentTime!==e){b._wD(a.id+": setPosition("+e+")");try{a._a.currentTime=e;if(a.playState===0||a.paused)a._a.pause()}catch(i){b._wD(a.id+": setPosition("+e+") failed: "+i.message,2)}}}else if(e){b._wD(a.id+": setPosition("+e+"): Cannot seek yet, sound not ready",2);return a}a.paused&&a._onTimer(true)}}else{e=
s===9?a.position:e;if(a.readyState&&a.readyState!==2)o._setPosition(a.id,e,a.paused||!a.playState,a._iO.multiShot)}return a};this.pause=function(e){if(a.paused||a.playState===0&&a.readyState!==1)return a;b._wD(a.id+": pause()");a.paused=true;if(a.isHTML5){a._setup_html5().pause();t()}else if(e||e===j)o._pause(a.id,a._iO.multiShot);a._iO.onpause&&a._iO.onpause.apply(a);return a};this.resume=function(){var e=a._iO;if(!a.paused)return a;b._wD(a.id+": resume()");a.paused=false;a.playState=1;if(a.isHTML5){a._setup_html5().play();
k()}else{e.isMovieStar&&!e.serverURL&&a.setPosition(a.position);o._pause(a.id,e.multiShot)}if(!p&&e.onplay){e.onplay.apply(a);p=true}else e.onresume&&e.onresume.apply(a);return a};this.togglePause=function(){b._wD(a.id+": togglePause()");if(a.playState===0){a.play({position:s===9&&!a.isHTML5?a.position:a.position/1E3});return a}a.paused?a.resume():a.pause();return a};this.setPan=function(e,f){if(e===j)e=0;if(f===j)f=false;a.isHTML5||o._setPan(a.id,e);a._iO.pan=e;if(!f){a.pan=e;a.options.pan=e}return a};
this.setVolume=function(e,f){if(e===j)e=100;if(f===j)f=false;if(a.isHTML5){if(a._a){if(b.muted&&!a.muted){a.muted=true;a._a.muted=true}a._a.volume=Math.max(0,Math.min(1,e/100))}}else o._setVolume(a.id,b.muted&&!a.muted||a.muted?0:e);a._iO.volume=e;if(!f){a.volume=e;a.options.volume=e}return a};this.mute=function(){a.muted=true;if(a.isHTML5){if(a._a)a._a.muted=true}else o._setVolume(a.id,0);return a};this.unmute=function(){a.muted=false;var e=a._iO.volume!==j;if(a.isHTML5){if(a._a)a._a.muted=false}else o._setVolume(a.id,
e?a._iO.volume:a.options.volume);return a};this.toggleMute=function(){return a.muted?a.unmute():a.mute()};this.onposition=this.onPosition=function(e,f,i){y.push({position:parseInt(e,10),method:f,scope:i!==j?i:a,fired:false});return a};this.clearOnPosition=function(e,f){var i;e=parseInt(e,10);if(isNaN(e))return false;for(i=0;i<y.length;i++)if(e===y[i].position)if(!f||f===y[i].method){y[i].fired&&H--;y.splice(i,1)}};this._processOnPosition=function(){var e,f;e=y.length;if(!e||!a.playState||H>=e)return false;
for(e=e-1;e>=0;e--){f=y[e];if(!f.fired&&a.position>=f.position){f.fired=true;H++;f.method.apply(f.scope,[f.position])}}return true};this._resetOnPosition=function(e){var f,i;f=y.length;if(!f)return false;for(f=f-1;f>=0;f--){i=y[f];if(i.fired&&e<=i.position){i.fired=false;H--}}return true};D=function(){var e=a._iO,f=e.from,i=e.to,m,l;l=function(){b._wD(a.id+': "To" time of '+i+" reached.");a.clearOnPosition(i,l);a.stop()};m=function(){b._wD(a.id+': Playing "from" '+f);i!==null&&!isNaN(i)&&a.onPosition(i,
l)};if(f!==null&&!isNaN(f)){e.position=f;e.multiShot=false;m()}return e};n=function(){var e,f=a._iO.onposition;if(f)for(e in f)f.hasOwnProperty(e)&&a.onPosition(parseInt(e,10),f[e])};pa=function(){var e,f=a._iO.onposition;if(f)for(e in f)f.hasOwnProperty(e)&&a.clearOnPosition(parseInt(e,10))};k=function(){a.isHTML5&&nb(a)};t=function(){a.isHTML5&&ob(a)};d=function(e){if(!e){y=[];H=0}p=false;a._hasTimer=null;a._a=null;a._html5_canplay=false;a.bytesLoaded=null;a.bytesTotal=null;a.duration=a._iO&&a._iO.duration?
a._iO.duration:null;a.durationEstimate=null;a.buffered=[];a.eqData=[];a.eqData.left=[];a.eqData.right=[];a.failures=0;a.isBuffering=false;a.instanceOptions={};a.instanceCount=0;a.loaded=false;a.metadata={};a.readyState=0;a.muted=false;a.paused=false;a.peakData={left:0,right:0};a.waveformData={left:[],right:[]};a.playState=0;a.position=null;a.id3={}};d();this._onTimer=function(e){var f,i=false,m={};if(a._hasTimer||e){if(a._a&&(e||(a.playState>0||a.readyState===1)&&!a.paused)){f=a._get_html5_duration();
if(f!==N.duration){N.duration=f;a.duration=f;i=true}a.durationEstimate=a.duration;f=a._a.currentTime*1E3||0;if(f!==N.time){N.time=f;i=true}if(i||e)a._whileplaying(f,m,m,m,m)}return i}};this._get_html5_duration=function(){var e=a._iO;return(e=a._a&&a._a.duration?a._a.duration*1E3:e&&e.duration?e.duration:null)&&!isNaN(e)&&e!==Infinity?e:null};this._apply_loop=function(e,f){!e.loop&&f>1&&b._wD("Note: Native HTML5 looping is infinite.",1);e.loop=f>1?"loop":""};this._setup_html5=function(e){e=E(a._iO,
e);var f=M?fb:a._a,i=decodeURI(e.url),m;if(M){if(i===decodeURI(Va))m=true}else if(i===decodeURI(J))m=true;if(f){if(f._s)if(M)f._s&&f._s.playState&&!m&&f._s.stop();else if(!M&&i===decodeURI(J)){a._apply_loop(f,e.loops);return f}if(!m){J&&d(false);f.src=e.url;Va=J=a.url=e.url;f._called_load=false}}else{if(e.autoLoad||e.autoPlay){a._a=new Audio(e.url);a._a.load()}else a._a=Ya&&opera.version()<10?new Audio(null):new Audio;f=a._a;f._called_load=false;if(M)fb=f}a.isHTML5=true;a._a=f;f._s=a;g();a._apply_loop(f,
e.loops);if(e.autoLoad||e.autoPlay)a.load();else{f.autobuffer=false;f.preload="auto"}return f};g=function(){function e(i,m,l){return a._a?a._a.addEventListener(i,m,l||false):null}if(a._a._added_events)return false;var f;a._a._added_events=true;for(f in Q)Q.hasOwnProperty(f)&&e(f,Q[f]);return true};h=function(){function e(i,m,l){return a._a?a._a.removeEventListener(i,m,l||false):null}var f;b._wD(a.id+": Removing event listeners");a._a._added_events=false;for(f in Q)Q.hasOwnProperty(f)&&e(f,Q[f])};
this._onload=function(e){var f=!!e||!a.isHTML5&&s===8&&a.duration;e=a.id+": ";b._wD(e+(f?"onload()":"Failed to load / invalid sound?"+(!a.duration?" Zero-length duration reported.":" -")+" ("+a.url+")"),f?1:2);if(!f&&!a.isHTML5){b.sandbox.noRemote===true&&b._wD(e+v("noNet"),1);b.sandbox.noLocal===true&&b._wD(e+v("noLocal"),1)}a.loaded=f;a.readyState=f?3:2;a._onbufferchange(0);a._iO.onload&&Ba(a,function(){a._iO.onload.apply(a,[f])});return true};this._onbufferchange=function(e){if(a.playState===0)return false;
if(e&&a.isBuffering||!e&&!a.isBuffering)return false;a.isBuffering=e===1;if(a._iO.onbufferchange){b._wD(a.id+": Buffer state change: "+e);a._iO.onbufferchange.apply(a)}return true};this._onsuspend=function(){if(a._iO.onsuspend){b._wD(a.id+": Playback suspended");a._iO.onsuspend.apply(a)}return true};this._onfailure=function(e,f,i){a.failures++;b._wD(a.id+": Failures = "+a.failures);a._iO.onfailure&&a.failures===1?a._iO.onfailure(a,e,f,i):b._wD(a.id+": Ignoring failure")};this._onfinish=function(){var e=
a._iO.onfinish;a._onbufferchange(0);a._resetOnPosition(0);if(a.instanceCount){a.instanceCount--;if(!a.instanceCount){pa();a.playState=0;a.paused=false;a.instanceCount=0;a.instanceOptions={};a._iO={};t();if(a.isHTML5)a.position=0}if(!a.instanceCount||a._iO.multiShotEvents)if(e){b._wD(a.id+": onfinish()");Ba(a,function(){e.apply(a)})}}};this._whileloading=function(e,f,i,m){var l=a._iO;a.bytesLoaded=e;a.bytesTotal=f;a.duration=Math.floor(i);a.bufferLength=m;a.durationEstimate=!a.isHTML5&&!l.isMovieStar?
l.duration?a.duration>l.duration?a.duration:l.duration:parseInt(a.bytesTotal/a.bytesLoaded*a.duration,10):a.duration;if(!a.isHTML5)a.buffered=[{start:0,end:a.duration}];if((a.readyState!==3||a.isHTML5)&&l.whileloading)l.whileloading.apply(a)};this._whileplaying=function(e,f,i,m,l){var R=a._iO;if(isNaN(e)||e===null)return false;a.position=Math.max(0,e);a._processOnPosition();if(!a.isHTML5&&s>8){if(R.usePeakData&&f!==j&&f)a.peakData={left:f.leftPeak,right:f.rightPeak};if(R.useWaveformData&&i!==j&&i)a.waveformData=
{left:i.split(","),right:m.split(",")};if(R.useEQData)if(l!==j&&l&&l.leftEQ){e=l.leftEQ.split(",");a.eqData=e;a.eqData.left=e;if(l.rightEQ!==j&&l.rightEQ)a.eqData.right=l.rightEQ.split(",")}}if(a.playState===1){!a.isHTML5&&s===8&&!a.position&&a.isBuffering&&a._onbufferchange(0);R.whileplaying&&R.whileplaying.apply(a)}return true};this._oncaptiondata=function(e){b._wD(a.id+": Caption data received.");a.captiondata=e;a._iO.oncaptiondata&&a._iO.oncaptiondata.apply(a,[e])};this._onmetadata=function(e,
f){b._wD(a.id+": Metadata received.");var i={},m,l;m=0;for(l=e.length;m<l;m++)i[e[m]]=f[m];a.metadata=i;a._iO.onmetadata&&a._iO.onmetadata.apply(a)};this._onid3=function(e,f){b._wD(a.id+": ID3 data received.");var i=[],m,l;m=0;for(l=e.length;m<l;m++)i[e[m]]=f[m];a.id3=E(a.id3,i);a._iO.onid3&&a._iO.onid3.apply(a)};this._onconnect=function(e){e=e===1;b._wD(a.id+": "+(e?"Connected.":"Failed to connect? - "+a.url),e?1:2);if(a.connected=e){a.failures=0;if(w(a.id))if(a.getAutoPlay())a.play(j,a.getAutoPlay());
else a._iO.autoLoad&&a.load();a._iO.onconnect&&a._iO.onconnect.apply(a,[e])}};this._ondataerror=function(e){if(a.playState>0){b._wD(a.id+": Data error: "+e);a._iO.ondataerror&&a._iO.ondataerror.apply(a)}};this._debug()};ta=function(){return r.body||r.getElementsByTagName("div")[0]};L=function(c){return r.getElementById(c)};E=function(c,a){c=c||{};var d;a=a===j?b.defaultOptions:a;for(d in a)if(a.hasOwnProperty(d)&&c[d]===j)c[d]=typeof a[d]!=="object"||a[d]===null?a[d]:E(c[d],a[d]);return c};Ba=function(c,
a){!c.isHTML5&&s===8?q.setTimeout(a,0):a()};Y={onready:1,ontimeout:1,defaultOptions:1,flash9Options:1,movieStarOptions:1};Ia=function(c,a){var d,g=true,h=a!==j,t=b.setupOptions;if(c===j){g=[];for(d in t)t.hasOwnProperty(d)&&g.push(d);for(d in Y)if(Y.hasOwnProperty(d))if(typeof b[d]==="object")g.push(d+": {...}");else b[d]instanceof Function?g.push(d+": function() {...}"):g.push(d);b._wD(v("setup",g.join(", ")));return false}for(d in c)if(c.hasOwnProperty(d))if(typeof c[d]!=="object"||c[d]===null||
c[d]instanceof Array||c[d]instanceof RegExp)if(h&&Y[a]!==j)b[a][d]=c[d];else if(t[d]!==j){b.setupOptions[d]=c[d];b[d]=c[d]}else if(Y[d]===j){T(v(b[d]===j?"setupUndef":"setupError",d),2);g=false}else if(b[d]instanceof Function)b[d].apply(b,c[d]instanceof Array?c[d]:[c[d]]);else b[d]=c[d];else if(Y[d]===j){T(v(b[d]===j?"setupUndef":"setupError",d),2);g=false}else return Ia(c[d],d);return g};B=function(){function c(k){k=sb.call(k);var n=k.length;if(h){k[1]="on"+k[1];n>3&&k.pop()}else n===3&&k.push(false);
return k}function a(k,n){var p=k.shift();n=[t[n]];h?p[n](k[0],k[1]):p[n].apply(p,k)}function d(){a(c(arguments),"add")}function g(){a(c(arguments),"remove")}var h=q.attachEvent,t={add:h?"attachEvent":"addEventListener",remove:h?"detachEvent":"removeEventListener"};return{add:d,remove:g}}();Q={abort:A(function(){b._wD(this._s.id+": abort")}),canplay:A(function(){var c=this._s,a;if(c._html5_canplay)return true;c._html5_canplay=true;b._wD(c.id+": canplay");c._onbufferchange(0);a=c._iO.position!==j&&
!isNaN(c._iO.position)?c._iO.position/1E3:null;if(c.position&&this.currentTime!==a){b._wD(c.id+": canplay: Setting position to "+a);try{this.currentTime=a}catch(d){b._wD(c.id+": canplay: Setting position of "+a+" failed: "+d.message,2)}}c._iO._oncanplay&&c._iO._oncanplay()}),canplaythrough:A(function(){var c=this._s;if(!c.loaded){c._onbufferchange(0);c._whileloading(c.bytesLoaded,c.bytesTotal,c._get_html5_duration());c._onload(true)}}),ended:A(function(){var c=this._s;b._wD(c.id+": ended");c._onfinish()}),
error:A(function(){b._wD(this._s.id+": HTML5 error, code "+this.error.code);this._s._onload(false)}),loadeddata:A(function(){var c=this._s;b._wD(c.id+": loadeddata");if(!c._loaded&&!Da)c.duration=c._get_html5_duration()}),loadedmetadata:A(function(){b._wD(this._s.id+": loadedmetadata")}),loadstart:A(function(){b._wD(this._s.id+": loadstart");this._s._onbufferchange(1)}),play:A(function(){this._s._onbufferchange(0)}),playing:A(function(){b._wD(this._s.id+": playing");this._s._onbufferchange(0)}),progress:A(function(c){var a=
this._s,d,g,h;d=0;var t=c.type==="progress",k=c.target.buffered,n=c.loaded||0,p=c.total||1;a.buffered=[];if(k&&k.length){d=0;for(g=k.length;d<g;d++)a.buffered.push({start:k.start(d)*1E3,end:k.end(d)*1E3});d=(k.end(0)-k.start(0))*1E3;n=Math.min(1,d/(c.target.duration*1E3));if(t&&k.length>1){h=[];g=k.length;for(d=0;d<g;d++)h.push(c.target.buffered.start(d)*1E3+"-"+c.target.buffered.end(d)*1E3);b._wD(this._s.id+": progress, timeRanges: "+h.join(", "))}t&&!isNaN(n)&&b._wD(this._s.id+": progress, "+Math.floor(n*
100)+"% loaded")}if(!isNaN(n)){a._onbufferchange(0);a._whileloading(n,p,a._get_html5_duration());n&&p&&n===p&&Q.canplaythrough.call(this,c)}}),ratechange:A(function(){b._wD(this._s.id+": ratechange")}),suspend:A(function(c){var a=this._s;b._wD(this._s.id+": suspend");Q.progress.call(this,c);a._onsuspend()}),stalled:A(function(){b._wD(this._s.id+": stalled")}),timeupdate:A(function(){this._s._onTimer()}),waiting:A(function(){var c=this._s;b._wD(this._s.id+": waiting");c._onbufferchange(1)})};za=function(c){return!c||
!c.type&&!c.url&&!c.serverURL?false:c.serverURL||c.type&&qa(c.type)?false:c.type?ma({type:c.type}):ma({url:c.url})||b.html5Only||c.url.match(/data\:/i)};Aa=function(c){var a;if(c){a=Da?"about:blank":b.html5.canPlayType("audio/wav")?"data:audio/wave;base64,/UklGRiYAAABXQVZFZm10IBAAAAABAAEARKwAAIhYAQACABAAZGF0YQIAAAD//w==":"about:blank";c.src=a;if(c._called_unload!==undefined)c._called_load=false}if(M)Va=null;return a};ma=function(c){if(!b.useHTML5Audio||!b.hasHTML5)return false;var a=c.url||null;c=
c.type||null;var d=b.audioFormats,g;if(c&&b.html5[c]!==j)return b.html5[c]&&!qa(c);if(!U){U=[];for(g in d)if(d.hasOwnProperty(g)){U.push(g);if(d[g].related)U=U.concat(d[g].related)}U=new RegExp("\\.("+U.join("|")+")(\\?.*)?$","i")}g=a?a.toLowerCase().match(U):null;if(!g||!g.length){if(c){a=c.indexOf(";");g=(a!==-1?c.substr(0,a):c).substr(6)}}else g=g[1];if(g&&b.html5[g]!==j)a=b.html5[g]&&!qa(g);else{c="audio/"+g;a=b.html5.canPlayType({type:c});a=(b.html5[g]=a)&&b.html5[c]&&!qa(c)}return a};rb=function(){function c(n){var p;
var y=p=false;if(!a||typeof a.canPlayType!=="function")return p;if(n instanceof Array){k=0;for(p=n.length;k<p;k++)if(b.html5[n[k]]||a.canPlayType(n[k]).match(b.html5Test)){y=true;b.html5[n[k]]=true;b.flash[n[k]]=!!n[k].match(yb)}p=y}else{n=a&&typeof a.canPlayType==="function"?a.canPlayType(n):false;p=!!(n&&n.match(b.html5Test))}return p}if(!b.useHTML5Audio||!b.hasHTML5){G=b.html5.usingFlash=true;return false}var a=Audio!==j?Ya&&opera.version()<10?new Audio(null):new Audio:null,d,g,h={},t,k;t=b.audioFormats;
for(d in t)if(t.hasOwnProperty(d)){g="audio/"+d;h[d]=c(t[d].type);h[g]=h[d];if(d.match(yb)){b.flash[d]=true;b.flash[g]=true}else{b.flash[d]=false;b.flash[g]=false}if(t[d]&&t[d].related)for(k=t[d].related.length-1;k>=0;k--){h["audio/"+t[d].related[k]]=h[d];b.html5[t[d].related[k]]=h[d];b.flash[t[d].related[k]]=h[d]}}h.canPlayType=a?c:null;b.html5=E(b.html5,h);b.html5.usingFlash=qb();G=b.html5.usingFlash;return true};S={notReady:"Unavailable - wait until onready() has fired.",notOK:"Audio support is not available.",
domError:"soundManagerexception caught while appending SWF to DOM.",spcWmode:"Removing wmode, preventing known SWF loading issue(s)",swf404:"soundManager: Verify that %s is a valid path.",tryDebug:"Try soundManager.debugFlash = true for more security details (output goes to SWF.)",checkSWF:"See SWF output for more debug info.",localFail:"soundManager: Non-HTTP page ("+r.location.protocol+" URL?) Review Flash player security settings for this special case:\nhttp://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager04.html\nMay need to add/allow path, eg. c:/sm2/ or /users/me/sm2/",
waitFocus:"soundManager: Special case: Waiting for SWF to load with window focus...",waitForever:"soundManager: Waiting indefinitely for Flash (will recover if unblocked)...",waitSWF:"soundManager: Waiting for 100% SWF load...",needFunction:"soundManager: Function object expected for %s",badID:'Sound ID "%s" should be a string, starting with a non-numeric character',currentObj:"soundManager: _debug(): Current sound objects",waitOnload:"soundManager: Waiting for window.onload()",docLoaded:"soundManager: Document already loaded",
onload:"soundManager: initComplete(): calling soundManager.onload()",onloadOK:"soundManager.onload() complete",didInit:"soundManager: init(): Already called?",secNote:"Flash security note: Network/internet URLs will not load due to security restrictions. Access can be configured via Flash Player Global Security Settings Page: http://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager04.html",badRemove:"soundManager: Failed to remove Flash node.",shutdown:"soundManager.disable(): Shutting down",
queue:"soundManager: Queueing %s handler",smError:"SMSound.load(): Exception: JS-Flash communication failed, or JS error.",fbTimeout:"No flash response, applying ."+z.swfTimedout+" CSS...",fbLoaded:"Flash loaded",fbHandler:"soundManager: flashBlockHandler()",manURL:"SMSound.load(): Using manually-assigned URL",onURL:"soundManager.load(): current URL already assigned.",badFV:'soundManager.flashVersion must be 8 or 9. "%s" is invalid. Reverting to %s.',as2loop:"Note: Setting stream:false so looping can work (flash 8 limitation)",
noNSLoop:"Note: Looping not implemented for MovieStar formats",needfl9:"Note: Switching to flash 9, required for MP4 formats.",mfTimeout:"Setting flashLoadTimeout = 0 (infinite) for off-screen, mobile flash case",needFlash:"soundManager: Fatal error: Flash is needed to play some required formats, but is not available.",gotFocus:"soundManager: Got window focus.",policy:"Enabling usePolicyFile for data access",setup:"soundManager.setup(): allowed parameters: %s",setupError:'soundManager.setup(): "%s" cannot be assigned with this method.',
setupUndef:'soundManager.setup(): Could not find option "%s"',setupLate:"soundManager.setup(): url, flashVersion and html5Test property changes will not take effect until reboot().",noURL:"soundManager: Flash URL required. Call soundManager.setup({url:...}) to get started.",sm2Loaded:"SoundManager 2: Ready.",reset:"soundManager.reset(): Removing event callbacks",mobileUA:"Mobile UA detected, preferring HTML5 by default.",globalHTML5:"Using singleton HTML5 Audio() pattern for this device."};v=function(){var c,
a,d,g;c=sb.call(arguments);a=c.shift();if((g=S&&S[a]?S[a]:"")&&c&&c.length){a=0;for(d=c.length;a<d;a++)g=g.replace("%s",c[a])}return g};va=function(c){if(s===8&&c.loops>1&&c.stream){u("as2loop");c.stream=false}return c};wa=function(c,a){if(c&&!c.usePolicyFile&&(c.onid3||c.usePeakData||c.useWaveformData||c.useEQData)){b._wD((a||"")+v("policy"));c.usePolicyFile=true}return c};T=function(c){na&&console.warn!==j?console.warn(c):b._wD(c)};Fa=function(){return false};kb=function(c){var a;for(a in c)if(c.hasOwnProperty(a)&&
typeof c[a]==="function")c[a]=Fa};Qa=function(c){if(c===j)c=false;if(I||c)b.disable(c)};lb=function(c){var a=null;if(c)if(c.match(/\.swf(\?.*)?$/i)){if(a=c.substr(c.toLowerCase().lastIndexOf(".swf?")+4))return c}else if(c.lastIndexOf("/")!==c.length-1)c+="/";c=(c&&c.lastIndexOf("/")!==-1?c.substr(0,c.lastIndexOf("/")+1):"./")+b.movieURL;if(b.noSWFCache)c+="?ts="+(new Date).getTime();return c};La=function(){s=parseInt(b.flashVersion,10);if(s!==8&&s!==9){b._wD(v("badFV",s,8));b.flashVersion=s=8}var c=
b.debugMode||b.debugFlash?"_debug.swf":".swf";if(b.useHTML5Audio&&!b.html5Only&&b.audioFormats.mp4.required&&s<9){b._wD(v("needfl9"));b.flashVersion=s=9}b.version=b.versionNumber+(b.html5Only?" (HTML5-only mode)":s===9?" (AS3/Flash 9)":" (AS2/Flash 8)");if(s>8){b.defaultOptions=E(b.defaultOptions,b.flash9Options);b.features.buffering=true;b.defaultOptions=E(b.defaultOptions,b.movieStarOptions);b.filePatterns.flash9=new RegExp("\\.(mp3|"+Bb.join("|")+")(\\?.*)?$","i");b.features.movieStar=true}else b.features.movieStar=
false;b.filePattern=b.filePatterns[s!==8?"flash9":"flash8"];b.movieURL=(s===8?"soundmanager2.swf":"soundmanager2_flash9.swf").replace(".swf",c);b.features.peakData=b.features.waveformData=b.features.eqData=s>8};ib=function(c,a){if(!o)return false;o._setPolling(c,a)};Pa=function(){if(b.debugURLParam.test(da))b.debugMode=true;if(L(b.debugID))return false;var c,a,d,g;if(b.debugMode&&!L(b.debugID)&&(!na||!b.useConsole||!b.consoleOnly)){c=r.createElement("div");c.id=b.debugID+"-toggle";a={position:"fixed",
bottom:"0px",right:"0px",width:"1.2em",height:"1.2em",lineHeight:"1.2em",margin:"2px",textAlign:"center",border:"1px solid #999",cursor:"pointer",background:"#fff",color:"#333",zIndex:10001};c.appendChild(r.createTextNode("-"));c.onclick=mb;c.title="Toggle SM2 debug console";if(C.match(/msie 6/i)){c.style.position="absolute";c.style.cursor="hand"}for(g in a)if(a.hasOwnProperty(g))c.style[g]=a[g];a=r.createElement("div");a.id=b.debugID;a.style.display=b.debugMode?"block":"none";if(b.debugMode&&!L(c.id)){try{d=
ta();d.appendChild(c)}catch(h){throw new Error(v("domError")+" \n"+h.toString());}d.appendChild(a)}}};w=this.getSoundById;u=function(c,a){return!c?"":b._wD(v(c),a)};mb=function(){var c=L(b.debugID),a=L(b.debugID+"-toggle");if(!c)return false;if(Ha){a.innerHTML="+";c.style.display="none"}else{a.innerHTML="-";c.style.display="block"}Ha=!Ha};K=function(c,a,d){if(q.sm2Debugger!==j)try{sm2Debugger.handleEvent(c,a,d)}catch(g){return false}return true};ca=function(){var c=[];b.debugMode&&c.push(z.sm2Debug);
b.debugFlash&&c.push(z.flashDebug);b.useHighPerformance&&c.push(z.highPerf);return c.join(" ")};Sa=function(){var c=v("fbHandler"),a=b.getMoviePercent(),d={type:"FLASHBLOCK"};if(b.html5Only)return false;if(b.ok()){b.didFlashBlock&&b._wD(c+": Unblocked");if(b.oMC)b.oMC.className=[ca(),z.swfDefault,z.swfLoaded+(b.didFlashBlock?" "+z.swfUnblocked:"")].join(" ")}else{if(G){b.oMC.className=ca()+" "+z.swfDefault+" "+(a===null?z.swfTimedout:z.swfError);b._wD(c+": "+v("fbTimeout")+(a?" ("+v("fbLoaded")+")":
""))}b.didFlashBlock=true;W({type:"ontimeout",ignoreInit:true,error:d});ba(d)}};Ja=function(c,a,d){if(P[c]===j)P[c]=[];P[c].push({method:a,scope:d||null,fired:false})};W=function(c){c||(c={type:b.ok()?"onready":"ontimeout"});if(!x&&c&&!c.ignoreInit)return false;if(c.type==="ontimeout"&&(b.ok()||I&&!c.ignoreInit))return false;var a={success:c&&c.ignoreInit?b.ok():!I},d=c&&c.type?P[c.type]||[]:[],g=[],h;a=[a];var t=G&&!b.ok();if(c.error)a[0].error=c.error;c=0;for(h=d.length;c<h;c++)d[c].fired!==true&&
g.push(d[c]);if(g.length){c=0;for(h=g.length;c<h;c++){g[c].scope?g[c].method.apply(g[c].scope,a):g[c].method.apply(this,a);if(!t)g[c].fired=true}}return true};Z=function(){q.setTimeout(function(){b.useFlashBlock&&Sa();W();if(typeof b.onload==="function"){u("onload",1);b.onload.apply(q);u("onloadOK",1)}b.waitForWindowLoad&&B.add(q,"load",Z)},1)};Wa=function(){if(O!==j)return O;var c=false,a=navigator,d=a.plugins,g,h=q.ActiveXObject;if(d&&d.length){if((a=a.mimeTypes)&&a["application/x-shockwave-flash"]&&
a["application/x-shockwave-flash"].enabledPlugin&&a["application/x-shockwave-flash"].enabledPlugin.description)c=true}else if(h!==j&&!C.match(/MSAppHost/i)){try{g=new h("ShockwaveFlash.ShockwaveFlash")}catch(t){g=null}c=!!g}return O=c};qb=function(){var c,a,d=b.audioFormats;if(Ca&&C.match(/os (1|2|3_0|3_1)/i)){b.hasHTML5=false;b.html5Only=true;if(b.oMC)b.oMC.style.display="none"}else if(b.useHTML5Audio){if(!b.html5||!b.html5.canPlayType){b._wD("SoundManager: No HTML5 Audio() support detected.");b.hasHTML5=
false}if($a)b._wD("soundManager: Note: Buggy HTML5 Audio in Safari on this OS X release, see https://bugs.webkit.org/show_bug.cgi?id=32159 - "+(!O?" would use flash fallback for MP3/MP4, but none detected.":"will use flash fallback for MP3/MP4, if available"),1)}if(b.useHTML5Audio&&b.hasHTML5){la=true;for(a in d)if(d.hasOwnProperty(a))if(d[a].required)if(b.html5.canPlayType(d[a].type)){if(b.preferFlash&&(b.flash[a]||b.flash[d[a].type]))c=true}else{la=false;c=true}}if(b.ignoreFlash){c=false;la=true}b.html5Only=
b.hasHTML5&&b.useHTML5Audio&&!c;return!b.html5Only};ya=function(c){var a,d,g=0;if(c instanceof Array){a=0;for(d=c.length;a<d;a++)if(c[a]instanceof Object){if(b.canPlayMIME(c[a].type)){g=a;break}}else if(b.canPlayURL(c[a])){g=a;break}if(c[g].url)c[g]=c[g].url;c=c[g]}else c=c;return c};nb=function(c){if(!c._hasTimer){c._hasTimer=true;if(!Za&&b.html5PollingInterval){if(ka===null&&xa===0)ka=setInterval(pb,b.html5PollingInterval);xa++}}};ob=function(c){if(c._hasTimer){c._hasTimer=false;!Za&&b.html5PollingInterval&&
xa--}};pb=function(){var c;if(ka!==null&&!xa){clearInterval(ka);ka=null;return false}for(c=b.soundIDs.length-1;c>=0;c--)b.sounds[b.soundIDs[c]].isHTML5&&b.sounds[b.soundIDs[c]]._hasTimer&&b.sounds[b.soundIDs[c]]._onTimer()};ba=function(c){c=c!==j?c:{};if(typeof b.onerror==="function")b.onerror.apply(q,[{type:c.type!==j?c.type:null}]);c.fatal!==j&&c.fatal&&b.disable()};tb=function(){if(!$a||!Wa())return false;var c=b.audioFormats,a,d;for(d in c)if(c.hasOwnProperty(d))if(d==="mp3"||d==="mp4"){b._wD("soundManager: Using flash fallback for "+
d+" format");b.html5[d]=false;if(c[d]&&c[d].related)for(a=c[d].related.length-1;a>=0;a--)b.html5[c[d].related[a]]=false}};this._setSandboxType=function(c){var a=b.sandbox;a.type=c;a.description=a.types[a.types[c]!==j?c:"unknown"];if(a.type==="localWithFile"){a.noRemote=true;a.noLocal=false;u("secNote",2)}else if(a.type==="localWithNetwork"){a.noRemote=false;a.noLocal=true}else if(a.type==="localTrusted"){a.noRemote=false;a.noLocal=false}};this._externalInterfaceOK=function(c){if(b.swfLoaded)return false;
var a;K("swf",true);K("flashtojs",true);b.swfLoaded=true;Ea=false;$a&&tb();if(!c||c.replace(/\+dev/i,"")!==b.versionNumber.replace(/\+dev/i,"")){a='soundManager: Fatal: JavaScript file build "'+b.versionNumber+'" does not match Flash SWF build "'+c+'" at '+b.url+". Ensure both are up-to-date.";setTimeout(function(){throw new Error(a);},0);return false}setTimeout(Ga,V?100:1)};ua=function(c,a){function d(){var D=[],J,N=[];J="SoundManager "+b.version+(!b.html5Only&&b.useHTML5Audio?b.hasHTML5?" + HTML5 audio":
", no HTML5 audio support":"");if(b.html5Only)b.html5PollingInterval&&D.push("html5PollingInterval ("+b.html5PollingInterval+"ms)");else{b.preferFlash&&D.push("preferFlash");b.useHighPerformance&&D.push("useHighPerformance");b.flashPollingInterval&&D.push("flashPollingInterval ("+b.flashPollingInterval+"ms)");b.html5PollingInterval&&D.push("html5PollingInterval ("+b.html5PollingInterval+"ms)");b.wmode&&D.push("wmode ("+b.wmode+")");b.debugFlash&&D.push("debugFlash");b.useFlashBlock&&D.push("flashBlock")}if(D.length)N=
N.concat([D.join(" + ")]);b._wD(J+(N.length?" + "+N.join(", "):""),1);ub()}function g(D,J){return'<param name="'+D+'" value="'+J+'" />'}if(ea&&fa)return false;if(b.html5Only){La();d();b.oMC=L(b.movieID);Ga();fa=ea=true;return false}var h=a||b.url,t=b.altURL||h;a=ta();var k=ca(),n=null;n=r.getElementsByTagName("html")[0];var p,y,H;n=n&&n.dir&&n.dir.match(/rtl/i);c=c===j?b.id:c;La();b.url=lb(oa?h:t);a=b.url+"?v=4904";b.wmode=!b.wmode&&b.useHighPerformance?"transparent":b.wmode;if(b.wmode!==null&&(C.match(/msie 8/i)||
!V&&!b.useHighPerformance)&&navigator.platform.match(/win32|win64/i)){X.push(S.spcWmode);b.wmode=null}k={name:c,id:c,src:a,quality:"high",allowScriptAccess:b.allowScriptAccess,bgcolor:b.bgColor,pluginspage:zb+"www.macromedia.com/go/getflashplayer",title:"JS/Flash audio component (SoundManager 2)",type:"application/x-shockwave-flash",wmode:b.wmode,hasPriority:"true"};if(b.debugFlash)k.FlashVars="debug=1";b.wmode||delete k.wmode;if(V){h=r.createElement("div");y=['<object id="'+c+'" data="'+a+'" type="'+
k.type+'" title="'+k.title+'" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="'+zb+'download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0">',g("movie",a),g("AllowScriptAccess",b.allowScriptAccess),g("quality",k.quality),b.wmode?g("wmode",b.wmode):"",g("bgcolor",b.bgColor),g("hasPriority","true"),b.debugFlash?g("FlashVars",k.FlashVars):"","</object>"].join("")}else{h=r.createElement("embed");for(p in k)k.hasOwnProperty(p)&&h.setAttribute(p,k[p])}Pa();k=ca();if(a=
ta()){b.oMC=L(b.movieID)||r.createElement("div");if(b.oMC.id){H=b.oMC.className;b.oMC.className=(H?H+" ":z.swfDefault)+(k?" "+k:"");b.oMC.appendChild(h);if(V){c=b.oMC.appendChild(r.createElement("div"));c.className=z.swfBox;c.innerHTML=y}fa=true}else{b.oMC.id=b.movieID;b.oMC.className=z.swfDefault+" "+k;c=p=null;if(!b.useFlashBlock)if(b.useHighPerformance)p={position:"fixed",width:"8px",height:"8px",bottom:"0px",left:"0px",overflow:"hidden"};else{p={position:"absolute",width:"6px",height:"6px",top:"-9999px",
left:"-9999px"};if(n)p.left=Math.abs(parseInt(p.left,10))+"px"}if(Hb)b.oMC.style.zIndex=1E4;if(!b.debugFlash)for(H in p)if(p.hasOwnProperty(H))b.oMC.style[H]=p[H];try{V||b.oMC.appendChild(h);a.appendChild(b.oMC);if(V){c=b.oMC.appendChild(r.createElement("div"));c.className=z.swfBox;c.innerHTML=y}fa=true}catch(pa){throw new Error(v("domError")+" \n"+pa.toString());}}}ea=true;d();return true};sa=function(){if(b.html5Only){ua();return false}if(o)return false;if(!b.url){u("noURL");return false}o=b.getMovie(b.id);
if(!o){if(ia){if(V)b.oMC.innerHTML=Ra;else b.oMC.appendChild(ia);ia=null;ea=true}else ua(b.id,b.url);o=b.getMovie(b.id)}typeof b.oninitmovie==="function"&&setTimeout(b.oninitmovie,1);Xa();return true};$=function(){setTimeout(hb,1E3)};Ka=function(){q.setTimeout(function(){T("soundManager: useFlashBlock is false, 100% HTML5 mode is possible. Rebooting with preferFlash: false...");b.setup({preferFlash:false}).reboot();b.didFlashBlock=true;b.beginDelayedInit()},1)};hb=function(){var c,a=false;if(!b.url)return false;
if(ja)return false;ja=true;B.remove(q,"load",$);if(O&&Ea&&!ab){u("waitFocus");return false}if(!x){c=b.getMoviePercent();if(c>0&&c<100)a=true}setTimeout(function(){c=b.getMoviePercent();if(a){ja=false;b._wD(v("waitSWF"));q.setTimeout($,1);return false}if(!x){b._wD("soundManager: No Flash response within expected time. Likely causes: "+(c===0?"SWF load failed, ":"")+"Flash blocked or JS-Flash security error."+(b.debugFlash?" "+v("checkSWF"):""),2);if(!oa&&c){u("localFail",2);b.debugFlash||u("tryDebug",
2)}c===0&&b._wD(v("swf404",b.url),1);K("flashtojs",false,": Timed out"+oa?" (Check flash security or flash blockers)":" (No plugin/missing SWF?)")}if(!x&&xb)if(c===null)if(b.useFlashBlock||b.flashLoadTimeout===0){b.useFlashBlock&&Sa();u("waitForever")}else if(!b.useFlashBlock&&la)Ka();else{u("waitForever");W({type:"ontimeout",ignoreInit:true,error:{type:"INIT_FLASHBLOCK"}})}else if(b.flashLoadTimeout===0)u("waitForever");else!b.useFlashBlock&&la?Ka():Qa(true)},b.flashLoadTimeout)};Ma=function(){function c(){B.remove(q,
"focus",Ma)}if(ab||!Ea){c();return true}ab=xb=true;u("gotFocus");ja=false;$();c();return true};Xa=function(){if(X.length){b._wD("SoundManager 2: "+X.join(" "),1);X=[]}};ub=function(){Xa();var c,a=[];if(b.useHTML5Audio&&b.hasHTML5){for(c in b.audioFormats)if(b.audioFormats.hasOwnProperty(c))a.push(c+" = "+b.html5[c]+(!b.html5[c]&&G&&b.flash[c]?" (using flash)":b.preferFlash&&b.flash[c]&&G?" (preferring flash)":!b.html5[c]?" ("+(b.audioFormats[c].required?"required, ":"")+"and no flash support)":""));
b._wD("SoundManager 2 HTML5 support: "+a.join(", "),1)}};ga=function(c){if(x)return false;if(b.html5Only){u("sm2Loaded");x=true;Z();K("onload",true);return true}var a=true,d;b.useFlashBlock&&b.flashLoadTimeout&&!b.getMoviePercent()||(x=true);d={type:!O&&G?"NO_FLASH":"INIT_TIMEOUT"};b._wD("SoundManager 2 "+(I?"failed to load":"loaded")+" ("+(I?"Flash security/load error":"OK")+")",I?2:1);if(I||c){if(b.useFlashBlock&&b.oMC)b.oMC.className=ca()+" "+(b.getMoviePercent()===null?z.swfTimedout:z.swfError);
W({type:"ontimeout",error:d,ignoreInit:true});K("onload",false);ba(d);a=false}else K("onload",true);if(!I)if(b.waitForWindowLoad&&!ra){u("waitOnload");B.add(q,"load",Z)}else{b.waitForWindowLoad&&ra&&u("docLoaded");Z()}return a};gb=function(){var c,a=b.setupOptions;for(c in a)if(a.hasOwnProperty(c))if(b[c]===j)b[c]=a[c];else if(b[c]!==a[c])b.setupOptions[c]=b[c]};Ga=function(){function c(){B.remove(q,"load",b.beginDelayedInit)}if(x){u("didInit");return false}if(b.html5Only){if(!x){c();b.enabled=true;
ga()}return true}sa();try{o._externalInterfaceTest(false);ib(true,b.flashPollingInterval||(b.useHighPerformance?10:50));b.debugMode||o._disableDebug();b.enabled=true;K("jstoflash",true);b.html5Only||B.add(q,"unload",Fa)}catch(a){b._wD("js/flash exception: "+a.toString());K("jstoflash",false);ba({type:"JS_TO_FLASH_EXCEPTION",fatal:true});Qa(true);ga();return false}ga();c();return true};aa=function(){if(ha)return false;ha=true;gb();Pa();(function(){var c=null;c=null;var a=da.toLowerCase();if(a.indexOf("sm2-usehtml5audio=")!==
-1){c=a.charAt(a.indexOf("sm2-usehtml5audio=")+18)==="1";if(na)console.log((c?"Enabling ":"Disabling ")+"useHTML5Audio via URL parameter");b.setup({useHTML5Audio:c})}if(a.indexOf("sm2-preferflash=")!==-1){c=a.charAt(a.indexOf("sm2-preferflash=")+16)==="1";if(na)console.log((c?"Enabling ":"Disabling ")+"preferFlash via URL parameter");b.setup({preferFlash:c})}})();if(!O&&b.hasHTML5){b._wD("SoundManager 2: No Flash detected"+(!b.useHTML5Audio?", enabling HTML5.":". Trying HTML5-only mode."),1);b.setup({useHTML5Audio:true,
preferFlash:false})}rb();if(!O&&G){X.push(S.needFlash);b.setup({flashLoadTimeout:1})}r.removeEventListener&&r.removeEventListener("DOMContentLoaded",aa,false);sa();return true};Ua=function(){if(r.readyState==="complete"){aa();r.detachEvent("onreadystatechange",Ua)}return true};Oa=function(){ra=true;B.remove(q,"load",Oa)};Na=function(){if(Za){if(!b.setupOptions.useHTML5Audio||b.setupOptions.preferFlash)X.push(S.mobileUA);b.setupOptions.useHTML5Audio=true;b.setupOptions.preferFlash=false;if(Ca||wb&&
!C.match(/android\s2\.3/i)){X.push(S.globalHTML5);if(Ca)b.ignoreFlash=true;M=true}}};Na();Wa();B.add(q,"focus",Ma);B.add(q,"load",$);B.add(q,"load",Oa);if(r.addEventListener)r.addEventListener("DOMContentLoaded",aa,false);else if(r.attachEvent)r.attachEvent("onreadystatechange",Ua);else{K("onload",false);ba({type:"NO_DOM2_EVENTS",fatal:true})}}var Cb=null;q.SM2_DEFER=true;if(q.SM2_DEFER===undefined||!SM2_DEFER)Cb=new db;q.SDSSoundManager=db;q.SDSsoundManager=Cb})(window);
