#!/bin/bash

SNAPTREE_TOOL="/usr/syno/sbin/synosharesnaptree"
EADIR="/@eaDir"
SNAPTREE_BIN_FILE=$EADIR"/snaptree.bin"
SYNOFSTOOL="/usr/syno/sbin/synofstool"
VOLUMETAB="/run/synostorage/volumetab"
BROKEN_SNAPTREE_SUFFIX=".broken"

_get_fs_type()
{
	$SYNOFSTOOL --get-fs-type "$1"
}

reconstruct_snaptree()
{
	[ -e $VOLUMETAB ] || exit 0
	awk '{print $2}' < $VOLUMETAB | while read volume
	do
		if [ "$(_get_fs_type "$volume")" == "btrfs" ]; then
			if [ -e "$volume$EADIR" ]; then
				if [ -e "$volume$SNAPTREE_BIN_FILE" ] && [ ! -f "$volume$SNAPTREE_BIN_FILE$BROKEN_SNAPTREE_SUFFIX" ]; then
					continue
				fi
				if $SNAPTREE_TOOL -x "$volume"; then
					rm -f $volume$SNAPTREE_BIN_FILE$BROKEN_SNAPTREE_SUFFIX
				fi
			fi
		fi
	done
}

reconstruct_snaptree
