#!/bin/sh

###############################################################
#   This script should be hooked when invoking share_transform hook.
#   Usable environment variable:
#       SHARE_NAME, SHARE_PATH, TRANS_DIRECT, RESULT
###############################################################

SNAPTREE_BINARY=/usr/syno/sbin/synosharesnaptree
SYNOFSTOOL_BINARY=/usr/syno/sbin/synofstool
TMP_DELETE_SHARE_ATTR_DIR="/tmp/deleteshareattr"

GetFsType() {
	$SYNOFSTOOL_BINARY --get-fs-type "$1"
}

GetShareAttr() {
	mkdir -p "$TMP_DELETE_SHARE_ATTR_DIR"
	VOLUME_NAME=$(dirname "$SHARE_PATH")
	if [ "btrfs" = "$(GetFsType "$VOLUME_NAME")" ]; then
		cp "$VOLUME_NAME/@eaDir/$SHARE_NAME/SYNO@.attr" "$TMP_DELETE_SHARE_ATTR_DIR/$SHARE_NAME.attr"
	fi
}

case $1 in
	--sdk-mod-ver)
		echo "2.0" ;;
	--name)
		echo "SnapTreeChangeShareTransform" ;;
	--pkg-ver)
		echo "1.0" ;;
	--vendor)
		echo "Synology Inc." ;;
	--pre)
		GetShareAttr
		;;
	--post)
		#Actions after share set

		if [ "0" != "${RESULT}" ]; then
			exit 0
		fi

		${SNAPTREE_BINARY} --move_share "$SHARE_PATH" -s "$SHARE_PATH"

		if [ -e "$TMP_DELETE_SHARE_ATTR_DIR/$SHARE_NAME.attr" ]; then
			rm -f "$TMP_DELETE_SHARE_ATTR_DIR/$SHARE_NAME.attr"
		fi
		;;
	*)
		echo "Usage: $0 --sdk_mod_ver|--name|--pkg_ver|--vendor|--pre|--post" ;;
esac
