#!/bin/sh

###############################################################
#   This script should be hooked when invoking share_delete hook.
###############################################################
SNAPTREE_BINARY=/usr/syno/sbin/synosharesnaptree
SYNOFSTOOL_BINARY=/usr/syno/sbin/synofstool
TMP_DELETE_SHARE_ATTR_DIR="/tmp/deleteshareattr"

GetFsType() {
	$SYNOFSTOOL_BINARY --get-fs-type "$1"
}

GetShareAttr() {
	INDEX=1
	mkdir -p "$TMP_DELETE_SHARE_ATTR_DIR"
	while [ "${INDEX}" -le "${NITEMS}" ]
	do
		eval "SHARE_NAME=\$SHARE_NAME_$INDEX"
		eval "SHARE_PATH=\$SHARE_PATH_$INDEX"
		VOLUME_NAME="$(dirname "$SHARE_PATH")"
		if [ "btrfs" = "$(GetFsType "$VOLUME_NAME")" ]; then
			cp "$VOLUME_NAME/@eaDir/$SHARE_NAME/SYNO@.attr" "$TMP_DELETE_SHARE_ATTR_DIR/$SHARE_NAME.attr"
		fi
		INDEX=$((INDEX + 1))
	done
}

CheckShareDeleted() {
	INDEX=1
	while [ "${INDEX}" -le "${NITEMS}" ]
	do
		eval "SHARE_OP_RESULT=\$SHARE_OP_RESULT_$INDEX"
		if [ "0x0000" = "${SHARE_OP_RESULT}" ]; then
			eval "SHARE_NAME=\$SHARE_NAME_$INDEX"
			eval "SHARE_PATH=\$SHARE_PATH_$INDEX"
			VOLUME_NAME="$(dirname "$SHARE_PATH")"
			if [ "btrfs" = "$(GetFsType "$VOLUME_NAME")" ]; then
				${SNAPTREE_BINARY} --delete_share "$SHARE_PATH"
			fi

			if [ -e "$TMP_DELETE_SHARE_ATTR_DIR/$SHARE_NAME.attr" ]; then
				rm -f "$TMP_DELETE_SHARE_ATTR_DIR/$SHARE_NAME.attr"
			fi
		fi

		INDEX=$((INDEX + 1))
	done
}

case $1 in
	--sdk-mod-ver)
		echo "2.0" ;;
	--name)
		echo "SnapTreeChangeShareDelete" ;;
	--pkg-ver)
		echo "1.0" ;;
	--vendor)
		echo "Synology Inc." ;;
	--pre)
		GetShareAttr;;
	--post)
		if [ "0" != "${RESULT}" ]; then
			exit 0
		fi
		CheckShareDeleted
		;;
	*)
		echo "Usage: $0 --sdk_mod_ver|--name|--pkg_ver|--vendor|--pre|--post" ;;
esac
