#!/bin/sh

skip_process="attrd Checkpoint_last cib Confsync corosync crmd drbd Dummy handle_ais.sh handler_sb.sh Infoset init IPaddr2 lrmd lsyncd ocf_wrapper_fs ocf_wrapper_serv pacemakerd pengine ping ntpd rc.ha rsync stonithd SxxPost.shSxxPre.sh synodrbd synoha_set_aff.sh synoha synohachkstateserverd synohamonmd0 synoharecordd synolsync UtilRec.sh"

f_old="/tmp/ha/proc_old"
f_new="/tmp/ha/proc_new"

set_aff()
{
ls /proc >$f_new
diff=$(comm -13 $f_old $f_new)
mv $f_new $f_old

for pid in $diff; do
	if [ ! -d /proc/$pid ] ; then
		continue
	fi
	if [ ! -f /proc/$pid/stat ] ; then
		continue
	fi
	if [ $pid = "self" ] ; then
		continue
	fi
	if [ "" = "$(cat /proc/$pid/cmdline)" ] ; then
		continue
	fi

	aff=$(/bin/taskset -p $pid | cut -d' ' -f6)
	case $aff in
		3) new_aff=2;;
		f) new_aff=e;;
		ff) new_aff=fe;;
		fff) new_aff=ffe;;
		ffff) new_aff=fffe;;
		fffff) new_aff=ffffe;;
		ffffff) new_aff=fffffe;;
		fffffff) new_aff=ffffffe;;
		ffffffff) new_aff=fffffffe;;
		*) continue;;
	esac

	process=$(cat /proc/$pid/cmdline | tr '\0' ' ' | cut -d ' ' -f1)
	if [ "$process" = "/bin/sh" ] || [ "$process" = "/bin/bash" ] || [ "$process" = "/bin/ash" ] || [ "$process" = "-ash" ] ; then
		process=$(cat /proc/$pid/cmdline | tr '\0' ' ' | cut -d ' ' -f2)
	fi
	process=$(/bin/basename $process)

	set_new=1
	for skip in $skip_process; do
		if [ "$process" = "$skip" ]; then
			set_new=0
			break
		fi
	done
	if [ "$set_new" = "1" ] ; then
		taskset -a -p $new_aff $pid
	fi

done
}

mkdir -p /tmp/ha &>/dev/null
rm -f $f_old $f_new
touch $f_old

while :; do
	set_aff &>/dev/null
	sleep 10
done

