#!/bin/sh

. /usr/syno/etc.defaults/synoha/rc.subr

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "1.0";
		;;
	--name)
		#Print package name
		echo "Synology High-Availability"
		;;
	--pkg-ver)
		#Print package version
		echo "1.0";
		;;
	--vendor)
		#Print package vendor
		echo "Synology";
		;;
	--post)
		if [ "yes" == "`get_key_value ${SYNOINFO} runha`" ] && [ "${IFNAME}" == "${DRBD_IF}" ]; then
			[ -z "${DRBD_IF}" -o -z "${DRBD_NETMASK}" -o -z "${DRBD_IP_LOCAL}" ] && exit 1
			mask=`/bin/ipcalc -p ${DRBD_IP_LOCAL} ${DRBD_NETMASK} | cut -f2 -d=`
			${SYNONET_BIN} --set_ip -4 ${DRBD_IF}:DRBD add ${DRBD_IP_LOCAL}/${mask}
		fi
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--post"
		;;
esac

