/* Copyright (c) 2017 Synology Inc. All rights reserved. */

Ext.ns("SYNO.SDS.LicenseManager.Utils");SYNO.SDS.LicenseManager.Utils.Helper={result_mapping:function(){return{unknown:{status:"error",headline:_T("license","license_result_fail_title"),description:_T("license","license_result_unknown_sub_title"),text:_T("license","license_result_unknown_desc")},add_success:{status:"success",headline:_T("license","license_result_success_title"),description:_T("license","license_result_success_sub_title"),text:SYNO.SDS.LicenseManager.Utils.Helper.T("license","license_result_success_desc")},add_failed:{status:"error",headline:_T("license","license_result_fail_title"),description:_T("license","license_result_fail_sub_title"),text:SYNO.SDS.LicenseManager.Utils.Helper.T("license","license_result_fail_desc")+"<br>{2}"},extend_success:{status:"success",headline:_T("license","license_result_success_title"),description:_T("license","result_extend_success_subtitle"),text:_T("license","result_extend_success_desc")},extend_failed:{status:"error",headline:_T("license","license_result_fail_title"),description:_T("license","result_extend_fail_subtitle"),text:SYNO.SDS.LicenseManager.Utils.Helper.T("license","license_result_fail_desc")+"<br>{2}"}}},T:function(b,a){return _TT(SYNO.SDS.LicenseManager.app,b,a)||_T(b,a)||String.format("{0}",a)},maskLoading:function(a){a.getEl().mask(_T("common","loading"),"x-mask-loading")},unmask:function(a){a.getEl().unmask()},renderDate:function(b){var a=new Date(parseInt(b,10)*1000);return a.format("Y/m/d")},renderSecToMonth:function(a){return Math.round(a/(60*60*24*30))},isValid:function(a){if("valid"===a){return true}return false},renderStatus:function(a){switch(a){case"invalid":return String.format('<span class="red-status">{0}</span>',_T("license","license_status_invalid_string"));case"expired":return String.format('<span class="red-status">{0}</span>',_T("license","license_status_expire_string"));case"prepared":return String.format('<span class="red-status">{0}</span>',_T("license","license_status_prepared_string"));case"reactivated":return String.format('<span class="red-status">{0}</span>',_T("license","license_status_reactivated_string"));case"valid":return String.format('<span class="green-status">{0}</span>',_T("license","license_status_validate_string"));default:return String.format('<span class="red-status">{0}</span>',_T("schedule","status_unknown"))}},renderLicenseCode:function(b){var a=5,c=b.replace(/-/g,"");while(a<c.length){c=c.substr(0,a)+"-"+c.substr(a);a=a+6}return c},renderLicenseCodeDisplay:function(a){var b=SYNO.SDS.LicenseManager.Utils.Helper.renderLicenseCode(b);return'<span class="license-key-text">'+b+"</span>"},maskLicenseCode:function(a){return SYNO.SDS.LicenseManager.Utils.Helper.renderLicenseCode(a)},parseLicenseCodes:function(a){var b="";a.each(function(d){var c="";c=SYNO.SDS.LicenseManager.Utils.Helper.renderLicenseCode(d);c=SYNO.SDS.LicenseManager.Utils.Helper.renderLicenseCodeDisplay(c);b+=+"<br>"});return b},renderResult:function(b,e,a){var f=this.result_mapping()[b],d=e?e.length:0,c="";switch(b){case"add_success":case"extend_success":f.text=String.format(f.text,d,a);break;case"add_failed":case"extend_failed":if(undefined!==e){c=e.code}f.text=String.format(f.text,d,a,SYNO.SDS.LicenseManager.Utils.Helper.getWebapiErrorMsg(c));break;default:f=this.result_mapping().unknown;f.text=String.format(f.text,d,a);break}return f},renderSummaryDisplay:function(c,e){var a={},b=0,d=[];c.each(function(g){var f={};f.name=SYNO.SDS.LicenseManager.Utils.Helper.renderLicenseCode(g.licenseCode);f.data=g.licenseData||0;if(0===f.data){f.status=_T("license","license_status_invalid_string")}else{f.status=_T("license","license_status_validate_string")}b+=f.data;d.push(f)});a.total=b;a.display=d;return a},isResultWithFailReason:function(a,c){switch(a){case"add_success":case"extend_success":var b=false;c.each(function(d){if(!d.success){b=true;return false}});return b;default:return false}},renderResultStatus:function(a){if(a.success){return SYNO.SDS.LicenseManager.ERR_SUCCESS}return a.error},renderResultStatusText:function(a){switch(a){case SYNO.SDS.LicenseManager.ERR_SUCCESS:return String.format('<span class="green-status">{0}</span>',_T("report","status_success"));case SYNO.SDS.LicenseManager.ERR_SERVER_EXCEED_ACT_LIMIT:case SYNO.SDS.LicenseManager.ERR_SERVER_DIFFERENT_DS:case SYNO.SDS.LicenseManager.ERR_SERVER_DIFFERENT_ACCOUNT:return String.format('<span class="red-status" style="float:left;">{0}</span><div class="license-note" ext:qtip="{1}"></div>',_T("report","status_fail"),_T("license","tip_error_reactivated"));case SYNO.SDS.LicenseManager.ERR_SERVER_ACTIVATED:return String.format('<span class="red-status" style="float:left;">{0}</span><div class="license-note" ext:qtip="{1}"></div>',_T("report","status_fail"),_T("license","tip_error_license_used"));case SYNO.SDS.LicenseManager.ERR_SERVER_DIFFERENT_CONTENT:return String.format('<span class="red-status" style="float:left;">{0}</span><div class="license-note" ext:qtip="{1}"></div>',_T("report","status_fail"),_T("license","tip_error_license_different_content"));default:return String.format('<span class="red-status">{0}</span>',_T("report","status_fail"))}},getLicenseFieldErrorMsg:function(a){switch(a){case SYNO.SDS.LicenseManager.ERR_LOCAL_DUPLICATED_KEY:return this.T("license","license_invalid_key_duplicate");case SYNO.SDS.LicenseManager.ERR_LOCAL_INSTALLED_KEY:return this.T("license","error_installed_key");case SYNO.SDS.LicenseManager.ERR_SERVER_INVALID_APPTYPE:case SYNO.SDS.LicenseManager.ERR_SERVER_DIFFERENT_CONTENT:return this.T("license","license_invalid_key_apptype");case SYNO.SDS.LicenseManager.ERR_SERVER_EXCEED_ACT_LIMIT:case SYNO.SDS.LicenseManager.ERR_SERVER_DIFFERENT_DS:return _T("license","tip_error_reactivated");case SYNO.SDS.LicenseManager.ERR_SERVER_LICENSE_USED:return _T("license","tip_error_license_used");case SYNO.SDS.LicenseManager.ERR_SERVER_DIFFERENT_ACCOUNT:return this.T("license","tip_error_license_registered");case SYNO.SDS.LicenseManager.ERR_LOCAL_NOT_EXIST_KEY:return _T("license","license_invalid_key_not_exist");case SYNO.SDS.LicenseManager.ERR_SERVER_CHECK_FREQUENCY:case SYNO.SDS.LicenseManager.ERR_SERVER_REQ_VALIDATE:case SYNO.SDS.LicenseManager.ERR_SERVER_RECORD_DB:case SYNO.SDS.LicenseManager.ERR_SERVER_READ_DB:case SYNO.SDS.LicenseManager.ERR_SERVER_DECODE_FILE:return this.T("license","error_server_system");default:case SYNO.SDS.LicenseManager.ERR_SERVER_INVALID_CODE:return this.T("license","license_invalid_key_id")}},getWebapiErrorMsg:function(a){switch(a){case SYNO.SDS.LicenseManager.ERR_WEBAPI_CONNECTION:case SYNO.SDS.LicenseManager.ERR_WEBAPI_SEND_REQUESET:return _T("license","error_connection");default:return _T("common","error_system")}},isImportEnable:function(a){if(a.importEnable){return true}return false}};Ext.define("SYNO.SDS.LicenseManager.License.Store",{extend:"Ext.data.JsonStore",constructor:function(a){var c=this;var b={autoDestroy:true,idProperty:"name",fields:["displayName","name","data","type","firstActTime","expireTime","displayStatus","status"],sortInfo:{field:"expireTime",direction:"ASC"}};c.callParent([Ext.apply(b,a)])}});Ext.define("SYNO.SDS.LicenseManager.License.ResultStore",{extend:"Ext.data.JsonStore",constructor:function(a){var c=this;var b={autoDestroy:true,idProperty:"displayName",fields:["displayName","displayStatus"]};c.callParent([Ext.apply(b,a)])}});Ext.define("SYNO.SDS.LicenseManager.License.SummaryStore",{extend:"Ext.data.JsonStore",constructor:function(a){var c=this;var b={autoDestroy:true,idProperty:"name",fields:["name","data"]};if(2<=a.version){b.fields.push("status")}c.callParent([Ext.apply(b,a)])}});SYNO.SDS.LicenseManager.LICENSE_API="SYNO.License";SYNO.SDS.LicenseManager.app=undefined;SYNO.SDS.LicenseManager.LICENSE_KEY_FIELD_LENGTH=5;SYNO.SDS.LicenseManager.LICENSE_KEY_LENGTH=30;SYNO.SDS.LicenseManager.APPLICATION_TYPE_ALL=-1;SYNO.SDS.LicenseManager.APPLICATION_TYPE_DOCKERDSM=1;SYNO.SDS.LicenseManager.APPLICATION_TYPE_VIRTUALDSM=2;SYNO.SDS.LicenseManager.APPLICATION_TYPE_MAILPLUS=3;SYNO.SDS.LicenseManager.ERR_SUCCESS=0;SYNO.SDS.LicenseManager.ERR_WEBAPI_CONNECTION=420;SYNO.SDS.LicenseManager.ERR_WEBAPI_SEND_REQUESET=421;SYNO.SDS.LicenseManager.ERR_LOCAL_DUPLICATED_KEY=150;SYNO.SDS.LicenseManager.ERR_LOCAL_NOT_EXIST_KEY=151;SYNO.SDS.LicenseManager.ERR_LOCAL_INSTALLED_KEY=152;SYNO.SDS.LicenseManager.ERR_SERVER_REQ_VALIDATE=3;SYNO.SDS.LicenseManager.ERR_SERVER_RECORD_DB=4;SYNO.SDS.LicenseManager.ERR_SERVER_READ_DB=5;SYNO.SDS.LicenseManager.ERR_SERVER_DECODE_FILE=6;SYNO.SDS.LicenseManager.ERR_SERVER_CHECK_FREQUENCY=13;SYNO.SDS.LicenseManager.ERR_SERVER_INVALID_CODE=50;SYNO.SDS.LicenseManager.ERR_SERVER_INVALID_APPTYPE=51;SYNO.SDS.LicenseManager.ERR_SERVER_EXCEED_ACT_LIMIT=52;SYNO.SDS.LicenseManager.ERR_SERVER_DIFFERENT_ACCOUNT=53;SYNO.SDS.LicenseManager.ERR_SERVER_NOT_ACTIVATED=54;SYNO.SDS.LicenseManager.ERR_SERVER_DIFFERENT_DS=55;SYNO.SDS.LicenseManager.ERR_SERVER_LICENSE_EXPIRED=56;SYNO.SDS.LicenseManager.ERR_SERVER_LICENSE_USED=57;SYNO.SDS.LicenseManager.ERR_SERVER_DIFFERENT_CONTENT=58;Ext.define("SYNO.SDS.LicenseManager.Wizard.LicenseAgreementStep",{extend:"SYNO.SDS.Wizard.Step",helper:SYNO.SDS.LicenseManager.Utils.Helper,LICENSE_AGREE:1,LICENSE_DISAGREE:2,constructor:function(a){var c=this;c.owner=a.owner;var b={headline:_T("license","license_agreement_title"),description:String.format(_T("license","license_agreement_sub_title"),c.owner.appName),layout:"fit",items:[{xtype:"syno_panel",cls:"license-agreement",autoFlexcroll:true,htmlEncode:false,html:String.format(_T("license","license_agreement_desc"),c.owner.appName)}]};c.callParent([Ext.apply(b,a)])},checkState:function(){var a=this;a.callParent(arguments);a.owner.getButton("next").setText(_T("common","agree"));a.owner.getButton("cancel").setText(_T("common","disagree"))},getNext:function(){var a=this;a.helper.maskLoading(a.owner);a.appWin.sendWebAPI({api:SYNO.SDS.LicenseManager.LICENSE_API,method:"check_connection",version:1,scope:a,callback:function(c,b){a.helper.unmask(a.owner);a.owner.getButton("cancel").setText(_T("common","cancel"));if(!c){a.owner.goNext(a.nextId.fail_connect)}else{a.owner.goNext(a.nextId.success)}}});return false}});Ext.define("SYNO.SDS.LicenseManager.Wizard.ConnectionFailStep",{extend:"SYNO.SDS.Wizard.Step",helper:SYNO.SDS.LicenseManager.Utils.Helper,constructor:function(a){var c=this;c.owner=a.owner;c.goImport=false;var b={headline:_T("license","license_no_connection_title"),items:[{xtype:"syno_panel",cls:"license-no-connection-overview",items:[{xtype:"syno_panel",cls:"license-result-icon-warning"},{xtype:"syno_panel",cls:c.helper.isImportEnable(c.owner)?"license-no-connection-desc":"license-no-connection-text",items:[{xtype:"syno_displayfield",value:c.helper.T("license","license_no_connection_desc")},{xtype:"syno_radio",name:"method",boxLabel:c.helper.T("license","connection_retry_desc"),checked:true,hidden:c.helper.isImportEnable(c.owner)?false:true},{xtype:"syno_radio",id:c.importRadioId=Ext.id(),name:"method",boxLabel:c.helper.T("license","license_no_connection_check"),checked:false,hidden:c.helper.isImportEnable(c.owner)?false:true}]}]}]};c.callParent([Ext.apply(b,a)])},checkState:function(){var a=this;a.callParent(arguments);if(!a.helper.isImportEnable(a.owner)){a.owner.getButton("next").setText(_T("common","retry"))}},getNext:function(){var a=this;if(Ext.getCmp(a.importRadioId).getValue()){return a.nextId.go_import}a.helper.maskLoading(a.owner);a.appWin.sendWebAPI({api:SYNO.SDS.LicenseManager.LICENSE_API,method:"check_connection",version:1,scope:a,callback:function(c,b){a.helper.unmask(a.owner);a.owner.getButton("cancel").setText(_T("common","cancel"));if(c){a.owner.goNext(a.nextId.success)}}});return false}});Ext.define("SYNO.SDS.LicenseManager.Wizard.ImportStep",{extend:"SYNO.SDS.Wizard.Step",helper:SYNO.SDS.LicenseManager.Utils.Helper,onCheckNextBtnStatus:function(){var a=this;if(!Ext.getCmp(a.filepath_id).isDirty()){a.owner.getButton("next").disable()}else{a.owner.getButton("next").enable()}},checkState:function(){var a=this;a.callParent(arguments);a.onCheckNextBtnStatus()},onExport:function(){var a=this,b={};b.appType=a.owner.appType;a.downloadWebAPI({webapi:{api:"SYNO.License",method:"export",version:1,params:b},scope:a,callback:function(){a.helper.unmask(a)}})},getNext:function(){var a=this;a.helper.maskLoading(a.owner);Ext.getCmp(a.upload_main).upload();return false},onUploadSuccess:function(d,c,b){var a=this;a.helper.unmask(a.owner);a.owner.result="add_success";a.owner.resp=c.licenses;a.owner.isDataChanged=true;a.owner.goNext(a.nextId)},onUploadFailed:function(d,c,b){var a=this;a.helper.unmask(a.owner);a.owner.result="add_failed";a.owner.resp=c;a.owner.goNext(a.nextId)},fixFileButton:function(){var a=this;if(a.filepath_id){Ext.getCmp(a.filepath_id).addClass("license-file-button")}},onActivate:function(){var a=this;if(!a.first){return}a.first=false;new SYNO.SDS.Utils.FormPanel({id:a.upload_main=Ext.id(),fileUpload:true,trackResetOnLoad:true,frame:false,border:false,layout:"fit",webapi:{api:a.licenseConfig?a.licenseConfig.defaultWebAPIName||SYNO.SDS.LicenseManager.LICENSE_API:SYNO.SDS.LicenseManager.LICENSE_API,method:"import",version:1},items:[{xtype:"textfield",name:"appLogName",value:a.owner.appLogName,hidden:true},{xtype:"textfield",name:"extendedTarget",value:a.owner.extendedTarget,hidden:true},{xtype:"syno_filebutton",name:"importFile",id:a.filepath_id=Ext.id(),listeners:{scope:a,change:a.onCheckNextBtnStatus,afterrender:a.fixFileButton}}],onApiSuccess:Ext.createDelegate(a.onUploadSuccess,a),onApiFailure:Ext.createDelegate(a.onUploadFailed,a),renderTo:a.importBtnId})},onBeforeDestroy:function(){var a=this;if(Ext.getCmp(a.upload_main)){Ext.getCmp(a.upload_main).destroy()}}});Ext.define("SYNO.SDS.LicenseManager.Wizard.LicenseImportStep",{extend:"SYNO.SDS.LicenseManager.Wizard.ImportStep",helper:SYNO.SDS.LicenseManager.Utils.Helper,constructor:function(a){var d=this;d.owner=a.owner;d.licenseConfig=a.appWin.licenseConfig;d.exportBtnId=Ext.id();d.importBtnId=Ext.id();d.display="line-height:20px;padding-top:3px;padding-bottom:4px;";d.first=true;d.first_export=true;var b=[{xtype:"syno_panel",html:'<div><div style="">'+_T("license","follow_step_desc")+'</div><ol style="padding-left:20px;list-style:decimal;"><li><div style="margin-top:4px;'+d.display+'">'+d.helper.T("license","license_indirect_desc_step_export")+'</div><div id="'+d.exportBtnId+'"></div></li><li><div style="margin-top:4px;'+d.display+'">'+String.format(_T("license","license_indirect_desc_step_web"),'<a href="https://account.synology.com" target="_blank" style="text-decoration:underline;">account.synology.com</a>')+'</div></li><li><div style="margin-top:4px;'+d.display+'">'+_T("license","license_indirect_desc_step_import")+'</div><div id="'+d.importBtnId+'"></div></li></ol></div>'}];var c={headline:_T("license","license_indirect_title"),items:b,listeners:{activate:d.onActivate,beforedestroy:d.onBeforeDestroy,scope:d}};d.callParent([Ext.apply(c,a)])},onActivate:function(){var a=this;a.callParent(arguments);if(!a.first_export){return}a.first_export=false;new SYNO.ux.Button({id:a.exportId=Ext.id(),text:_T("license","license_export_file"),style:"margin-top:3px;margin-bottom:4px;",scope:a,handler:a.onExport,renderTo:a.exportBtnId})},onBeforeDestroy:function(){var a=this;if(Ext.getCmp(a.exportId)){Ext.getCmp(a.exportId).destroy()}}});Ext.define("SYNO.SDS.LicenseManager.Wizard.ExtendImportStep",{extend:"SYNO.SDS.LicenseManager.Wizard.ImportStep",constructor:function(a){var d=this;d.owner=a.owner;d.licenseConfig=a.appWin.licenseConfig;d.exportBtnId=Ext.id();d.importBtnId=Ext.id();d.display="line-height:20px;padding-top:3px;padding-bottom:4px;";d.first=true;var b=[{xtype:"syno_panel",html:'<div><div style="">'+_T("license","follow_step_desc")+'</div><ol style="padding-left:20px;list-style:number;"><li><div style="margin-top:4px;'+d.display+'">'+String.format(_T("license","extend_indirect_desc_step_web"),'<a href="https://account.synology.com" target="_blank" style="text-decoration:underline;">account.synology.com</a>')+'</div></li><li><div style="margin-top:4px;'+d.display+'">'+_T("license","license_indirect_desc_step_import")+'</div><div id="'+d.importBtnId+'"></div></li></ol></div>'}];var c={headline:_T("license","license_indirect_title"),items:b,listeners:{activate:d.onActivate,beforedestroy:d.onBeforeDestroy,scope:d}};d.callParent([Ext.apply(c,a)])}});Ext.define("SYNO.SDS.LicenseManager.Wizard.SynologyAccountStep",{extend:"SYNO.SDS.Wizard.Step",helper:SYNO.SDS.LicenseManager.Utils.Helper,constructor:function(a){var c=this;c.appWin=a.appWin;c.owner=a.owner;c.account="";c.forceAccount=a.forceAccount;c.loaded=false;var b={headline:_T("license","license_account_title"),description:String.format(c.helper.T("license","license_account_sub_title"),c.owner.appName),items:[{xtype:"syno_displayfield",value:_T("license","license_account_desc")},{xtype:"syno_displayfield",id:c.field_account=Ext.id(),value:'<span class="link-font syno_license_cursor" tabindex="0" aria-level="2" aria-label="'+_T("cloudbkp","my_ds_account")+": "+_T("myds","login_or_register_myds_account")+'">'+_T("myds","login_or_register_myds_account")+"</span>",fieldLabel:_T("cloudbkp","my_ds_account"),htmlEncode:false,tabIndex:-1}],listeners:{scope:c,activate:c.onActivate}};c.callParent([Ext.apply(b,a)]);c.on("afterlayout",c.addAccountListener,c,{single:true})},onActivate:function(){var a=this;if(a.loaded){return}a.helper.maskLoading(a.owner);a.appWin.sendWebAPI({api:"SYNO.Core.MyDSCenter",method:"query",version:2,scope:a,callback:function(c,b){a.helper.unmask(a.owner);if(!c||!b.is_logged_in){return}a.setAccount(b.account)}})},addAccountListener:function(){var a=this;Ext.getCmp(a.field_account).getEl().addListener("click",a.onClickAccountField,a)},onClickAccountField:function(){var b=this;if(""===b.account){var a=new SYNO.SDS.MyDSCenter.LoginDialog({owner:b.owner,listeners:{scope:b,login_success:b.afterRegisterAccount}});a.open()}else{SYNO.SDS.AppLaunch("SYNO.SDS.AdminCenter.Application",{fn:"SYNO.SDS.AdminCenter.InfoCenter.Main",tab:"account"})}},afterRegisterAccount:function(c,a){var b=this;b.setAccount(c)},setAccount:function(b){var a=this;if(undefined!==b&&0<b.length){a.account=b;Ext.getCmp(a.field_account).setValue('<span class="link-font syno_license_cursor" tabindex="0" aria-level="2" aria-label="'+_T("cloudbkp","my_ds_account")+": "+b+'">'+b+"</a>")}else{a.account="";Ext.getCmp(a.field_account).setValue('<span class="link-font syno_license_cursor" tabindex="0" aria-level="2" aria-label="'+_T("cloudbkp","my_ds_account")+": "+_T("myds","login_or_register_myds_account")+'">'+_T("myds","login_or_register_myds_account")+"</span>")}a.checkState()},checkState:function(){var a=this;a.callParent(arguments);if(""===a.account){a.owner.getButton("next").disable()}else{a.owner.getButton("next").enable()}},getNext:function(){var a=this;return a.nextId},getAccount:function(){var a=this;return a.account},summary:function(b){var a=this;b.append(_T("license","license_account_title"),a.account)}});Ext.define("SYNO.SDS.LicenseManager.Wizard.LicenseInputStep",{extend:"SYNO.ux.Panel",helper:SYNO.SDS.LicenseManager.Utils.Helper,constructor:function(a){var c=this;c.appWin=a.appWin;c.owner=a.owner;c.version=a.version||1;c.extendedTarget=a.extendedTarget;c.first=true;c.init();var b={headline:_T("license","license_enter_key_title"),description:_T("license","license_enter_key_sub_title"),layout:"form",items:[{xtype:"syno_panel",layout:"column",style:"margin-top: 8px;",items:[{xtype:"label",width:170,style:"padding-top: 4px;",text:_T("license","license_key_string")},c.panelLicenseField]},{xtype:"syno_panel",items:[{xtype:"label",text:_T("license","license_enter_key_annotation")}]}],listeners:{scope:c,activate:c.onActivate}};c.callParent([Ext.apply(b,a)])},init:function(){var a=this;a.keyList=[];var b=new SYNO.SDS.LicenseManager.Wizard.LicenseKeyPanel({index:a.keyList.length,appWin:a.appWin,owner:a});a.keyList.push(b);a.panelLicenseField=new SYNO.ux.Panel({width:440,height:200,autoFlexcroll:true,updateFormForScrollbar:true,items:[b],listeners:{afterlayout:function(c){if(c.body.dom){c.updateScrollbar(c.body.dom);if(c.body.dom.fleXcroll){c.body.dom.fleXcroll.scrollContent(false,"10p")}}}}});a.updateRowButton()},onActivate:function(){var a=this;if(a.first){a.first=false;a.keyList[0].key1.focus(false,10)}if(a.extendedTarget){var b={appType:a.owner.appType,extendedTarget:a.extendedTarget,account:a.owner.getStep(a.owner.stepItemId.ACCOUNT).getAccount()};a.helper.maskLoading(a.owner);a.owner.sendWebAPI({api:a.owner.defaultWebAPIName?a.owner.defaultWebAPIName:SYNO.SDS.LicenseManager.LICENSE_API,method:"check_extend_target",version:a.version,params:b,scope:a,callback:function(d,c){a.helper.unmask(a.owner);if(!d){a.owner.getMsgBox().alert("",a.helper.getWebapiErrorMsg(c.code),function(){a.owner.goBack()});return}else{if(c&&!c[0].success){a.owner.getMsgBox().alert("",a.helper.getLicenseFieldErrorMsg(c[0].error),function(){a.owner.goBack()})}}}})}},removeOneRow:function(a){var c=this;var d=c.keyList.length;if(d<=a){return}c.keyList.splice(a,1);d=c.keyList.length;var b;for(b=a;b<d;b++){c.keyList[b].descreaseIndex()}c.updateRowButton();c.panelLicenseField.updateScrollbar(c.panelLicenseField.body.dom)},addOneRow:function(){var b=this;var a=b.keyList.length;var c=new SYNO.SDS.LicenseManager.Wizard.LicenseKeyPanel({index:a,appWin:b.appWin,owner:b});b.keyList.push(c);b.panelLicenseField.add(c);c.key1.focus(false,10)},getTotalRowCount:function(){var a=this;return a.keyList.length},updateRowButton:function(){var b=this,a,c=b.keyList.length-1;for(a=0;a<c;a++){b.keyList[a].showAddButton(false)}b.keyList[c].showAddButton(true)},parseInput:function(d,e,m){m=m.replace(/[^0-9A-Za-z]/g,"");var l=this;var f=m.length+(e-1)*SYNO.SDS.LicenseManager.LICENSE_KEY_FIELD_LENGTH;var k=Math.ceil(f/SYNO.SDS.LicenseManager.LICENSE_KEY_LENGTH);var a=d+k-1;var j=l.keyList.length-1;var g,b=0;var n=e;var c,h;for(g=d;g<=a;g++){if(g>j){l.addOneRow()}if(d===g){n=e;c=SYNO.SDS.LicenseManager.LICENSE_KEY_LENGTH;c=c-((n-1)*SYNO.SDS.LicenseManager.LICENSE_KEY_FIELD_LENGTH)}else{n=1;c=SYNO.SDS.LicenseManager.LICENSE_KEY_LENGTH}h=m.substr(b,c);l.keyList[g].setLicenseKey(h,n);b+=c}l.panelLicenseField.doLayout();l.panelLicenseField.updateFleXcrollForm();l.updateRowButton()},getLicenseCodes:function(){var a=this;return a.licenseList},getCheckResult:function(){var a=this;return a.checkResult},isValid:function(){var c=this,a,b=false;for(a=0;a<c.keyList.length;a++){b=c.keyList[a].isValid();if(false===b){break}}return b},markInvalidRow:function(b,e,a){var d=this,c=d.keyList[b].getLicenseKey();if(e===c){d.keyList[b].markInvalid(a)}else{d.keyList.each(function(f){if(e===f.getLicenseKey()){f.markInvalid(a)}})}},markValidRow:function(a,d){var c=this,b=c.keyList[a].getLicenseKey();if(d===b){c.keyList[a].markValid()}else{c.keyList.each(function(e){if(d===e.getLicenseKey()){e.markValid()}})}},getNext:function(){var d=this,e={};if(false===d.isValid()){return false}var b,c="",a=[];for(b=0;b<d.keyList.length;b++){c=d.keyList[b].getLicenseKey().replace(/-/g,"");a.push(c)}if(0>=a.length){return false}d.helper.maskLoading(d.owner);e.appType=d.owner.appType;e.licenseCode=a;e.account=d.owner.getStep("accountStep").getAccount();if(d.extendedTarget){e.extendedTarget=d.extendedTarget}d.appWin.sendWebAPI({api:SYNO.SDS.LicenseManager.LICENSE_API,method:d.extendedTarget?"check_extend_code":"check_code",version:d.version,params:e,scope:d,callback:function(g,f){d.helper.unmask(d.owner);if(!g){d.owner.getMsgBox().alert("",d.helper.getWebapiErrorMsg(f.code));return}d.checkResult=f;delete (d.licenseList);d.licenseList=a;d.owner.goNext(d.nextId)}});return false},summary:function(b){var a=this;a.licenseList.each(function(d,c){var e=a.helper.renderLicenseCode(d);if(0===c){b.append(_T("license","license_key_string"),e)}else{b.append("",e)}})}});Ext.define("SYNO.SDS.LicenseManager.Wizard.LicenseKeyField",{extend:"SYNO.ux.TextField",allowBlank:false,hideLabel:true,width:280,maskRe:/[a-zA-Z0-9]/,cls:"license-key-text",constructor:function(a){var b=this;b.owner=a.owner;b.index=a.index;b.callParent([a]);b.on("render",function(){b.getEl().on("input",function(g,d,c){var f=b.getValue();if(!f||(0===f.length)){return}this.onPasteInput()},b);b.getEl().on("paste",function(f,d,c){b.setValue("")},b)})},initEvents:function(){var a=this;a.callParent(arguments);a.mon(a,{scope:a,focus:function(b){a.owner.currentFieldIndex=b.index},keyup:function(){a.onKeyInput()}})},onKeyInput:function(){this.validate();this.owner.setLicenseKey(null,this.index);this.owner.owner.updateRowButton()},onPasteInput:function(a){var b=this,c=(!a)?b.getValue():a;b.owner.owner.parseInput(b.owner.index,b.index,c)},validator:function(a){a=a.replace(/-/g,"");if(a.length>=20&&0===a.length%5){return true}else{return _T("license","alert_invalid_license")}}});Ext.define("SYNO.SDS.LicenseManager.Wizard.LicenseKeyStatusPanel",{extend:"SYNO.ux.Panel",constructor:function(a){var c=this;var b={width:26,height:26,padding:"3px 3px",data:{iconCls:"",errmsg:""},tpl:new Ext.XTemplate('<tpl for=".">','<div class="license-key-status">','<div class="item-icon {iconCls}" ext:qtip="{errmsg}"></div>',"</div>","</tpl>")};c.callParent([Ext.apply(b,a)])},setValid:function(){var a=this;a.update({iconCls:"license-key-status-valid",errmsg:""})},setInvalid:function(b){var a=this;a.update({iconCls:"license-key-status-invalid",errmsg:b})},resetStatus:function(){var a=this;a.update({iconCls:"",errmsg:""})},update:function(b){var a=this;a.data=b;if(a.body){a.tpl.overwrite(a.body,a.data)}}});Ext.define("SYNO.SDS.LicenseManager.Wizard.LicenseKeyPanel",{extend:"SYNO.ux.Panel",helper:SYNO.SDS.LicenseManager.Utils.Helper,constructor:function(a){var c=this;c.appWin=a.appWin;c.owner=a.owner;c.index=a.index;c.init();var b={width:440,layout:"column",style:"margin-bottom: 7px;",items:[c.labelNumber,c.key1,c.btnDelete,c.btnAdd,c.iconStatus]};c.callParent([Ext.apply(b,a)])},init:function(){var a=this;a.labelNumber=new Ext.form.Label({width:30,style:"margin-right: 8px; padding-top: 4px;"});a.setLabelText();a.key1=new SYNO.SDS.LicenseManager.Wizard.LicenseKeyField({owner:a,index:1,style:"margin-right: 16px;"});a.btnAdd=new SYNO.ux.Button({cls:"license-key-add",tooltip:_T("common","add"),hidden:true,handler:function(){this.addOneRow();this.panelLicenseField.doLayout();this.updateRowButton()},scope:a.owner});a.btnDelete=new SYNO.ux.Button({cls:"license-key-delete",tooltip:_T("common","delete"),handler:a.onDelete,scope:a});a.iconStatus=new SYNO.SDS.LicenseManager.Wizard.LicenseKeyStatusPanel()},setLabelText:function(){var c=this,b,a=c.index+1;if(10>a){b="0"+a+"."}else{b=a+"."}c.labelNumber.setText(b)},onDelete:function(){var a=this;if((0<a.index)||(0===a.index)&&(1<a.owner.getTotalRowCount())){a.hide();a.owner.removeOneRow(a.index)}else{a.key1.setValue("");a.licenseKey="";a.resetValidFlag();a.owner.updateRowButton()}},resetValidFlag:function(){var a=this;a.blFormatValid=true;a.blDuplicated=false;a.iconStatus.resetStatus()},setLicenseKey:function(a,c){this.resetValidFlag();if(!a){this.licenseKey=this.key1.getValue();return}var b="";b=SYNO.SDS.LicenseManager.Utils.Helper.renderLicenseCode(a);this.key1.focus();this.key1.setValue(b);this.licenseKey=b},descreaseIndex:function(){var a=this;a.index--;a.setLabelText()},showAddButton:function(a){var b=this;if(false===a){b.btnAdd.setVisible(false);return}b.btnAdd.setVisible(true)},getLicenseKey:function(){var a=this;return a.licenseKey.toUpperCase()},markInvalid:function(a){var b=this,c=b.helper.getLicenseFieldErrorMsg(a);b.key1.markInvalid(c);b.iconStatus.setInvalid(c)},markValid:function(){var a=this;a.iconStatus.setValid()},isFormatValid:function(){return this.key1.isValid()},isValid:function(){return true===this.isFormatValid()&&false===this.blDuplicated}});Ext.define("SYNO.SDS.LicenseManager.Wizard.SummaryStep",{extend:"SYNO.SDS.Wizard.Step",helper:SYNO.SDS.LicenseManager.Utils.Helper,constructor:function(a){var c=this;c.owner=a.owner;c.version=a.version||1;c.extendedTarget=a.extendedTarget;var b={headline:c.helper.T("license","summary_title"),description:c.helper.T("license","summary_desc"),items:[{xtype:"syno_formpanel",height:234,labelWidth:192,items:[{xtype:"syno_displayfield",id:c.account_id=Ext.id(),fieldLabel:_T("myds","account"),labelStyle:"padding-left: 8px;",style:"padding-left: 7px;font-weight: bold;",value:c.account},{xtype:"syno_displayfield",id:c.total_id=Ext.id(),fieldLabel:c.helper.T("license","total_num"),labelStyle:"padding-left: 8px;",style:"padding-left: 7px;font-weight: bold;",value:0},c.gridPanel=new SYNO.SDS.LicenseManager.Wizard.SummaryGridPanel({version:c.version,extendedTarget:c.extendedTarget})]}],listeners:{scope:c,activate:c.onActivate}};c.callParent([Ext.apply(b,a)])},onActivate:function(){var a={},c="",b=0;a=this.owner.getStep(this.owner.stepItemId.LICENSE_ADD).getCheckResult();a=this.helper.renderSummaryDisplay(a,this.extendedTarget);c=this.owner.getStep(this.owner.stepItemId.ACCOUNT).getAccount();b=a.total||0;Ext.getCmp(this.account_id).setValue(c);Ext.getCmp(this.total_id).setValue(b);this.gridPanel.update(a.display)},checkState:function(){this.owner.getButton("back").hide()},getNext:function(){var a=this;a.owner.applySettings();return false},goNext:function(a,b){return this.callParent(a,false)}});Ext.define("SYNO.SDS.LicenseManager.Wizard.SummaryGridPanel",{extend:"SYNO.ux.GridPanel",helper:SYNO.SDS.LicenseManager.Utils.Helper,constructor:function(a){var d=this,b;d.version=a.version||1;d.extendedTarget=a.extendedTarget;d.summaryStore=new SYNO.SDS.LicenseManager.License.SummaryStore({version:d.version});var c=[{header:_T("license","license_key_string"),dataIndex:"name",width:320,renderer:function(f,e){e.attr='style="font-family:monospace;text-transform: uppercase;"';return f}},{header:_T("license","license_num_string"),useHtmlEncodeRender:false,width:300,dataIndex:"data"}];if(2<=d.version){c.push({header:_T("license","license_status_string"),useHtmlEncodeRender:false})}d.colModel=new Ext.grid.ColumnModel({columns:c});b={height:166,store:d.summaryStore,colModel:d.colModel,disableSelection:true,enableHdMenu:false,enableColumnMove:false,cls:"without-dirty-red-grid"};d.callParent([Ext.apply(b,a)])},update:function(b){var a=this;a.summaryStore.loadData(b,false)}});Ext.define("SYNO.SDS.LicenseManager.Wizard.ResultStep",{extend:"SYNO.SDS.Wizard.Step",helper:SYNO.SDS.LicenseManager.Utils.Helper,constructor:function(a){var c=this;c.owner=a.owner;var b={headline:c.headline,description:c.description,layout:"fit",items:[c.panel=new SYNO.SDS.LicenseManager.Wizard.ResultPanel(),c.gridPanel=new SYNO.SDS.LicenseManager.Wizard.ResultGridPanel()],listeners:{scope:c,activate:c.onActivate}};c.callParent([Ext.apply(b,a)])},onActivate:function(){var b=this,a;a=b.helper.renderResult(b.owner.result,b.owner.resp,b.owner.appName);if(b.helper.isResultWithFailReason(b.owner.result,b.owner.resp)){b.panel.setVisible(false);b.gridPanel.setVisible(true);b.gridPanel.update(b.owner.resp)}else{b.panel.setVisible(true);b.panel.update(a);b.gridPanel.setVisible(false)}b.headline=a.headline;b.description=a.description},checkState:function(){var a=this;a.callParent(arguments);a.owner.getButton("back").hide();a.owner.getButton("cancel").hide();a.owner.getButton("next").setText(_T("common","finish"))},getNext:function(){var a=this;a.owner.close();return false},summary:function(a){}});Ext.define("SYNO.SDS.LicenseManager.Wizard.ResultPanel",{extend:"SYNO.ux.Panel",constructor:function(a){var c=this,b;b={data:{status:"",text:""},tpl:new Ext.XTemplate('<div class="license-result-overview">','<div class="license-result-icon-{status}"></div>','<div class="license-result-text">{text}</div>',"</div>")};c.callParent([Ext.apply(b,a)])},update:function(b){var a=this;a.data=b;a.tpl.overwrite(a.body,a.data)}});Ext.define("SYNO.SDS.LicenseManager.Wizard.ResultGridPanel",{extend:"SYNO.ux.GridPanel",helper:SYNO.SDS.LicenseManager.Utils.Helper,constructor:function(a){var c=this,b;c.resultStore=new SYNO.SDS.LicenseManager.License.ResultStore();c.colModel=new Ext.grid.ColumnModel({columns:[{header:_T("license","license_key_string"),dataIndex:"displayName",width:320,renderer:function(e,d){d.attr='style="font-family:monospace;text-transform: uppercase;"';return e}},{header:_T("license","license_status_string"),width:400,useHtmlEncodeRender:false,dataIndex:"displayStatus",renderer:function(e,d){return c.helper.renderResultStatusText(e)}}]});b={layout:"fit",store:c.resultStore,colModel:c.colModel,cls:"without-dirty-red-grid"};c.callParent([Ext.apply(b,a)])},update:function(b){var a=this,c=[];b.each(function(e){var d={};d.displayName=a.helper.renderLicenseCode(e.licenseCode);d.displayStatus=a.helper.renderResultStatus(e);c.push(d)});a.resultStore.loadData(c,false)}});Ext.define("SYNO.SDS.LicenseManager.Wizard.Add",{extend:"SYNO.SDS.Wizard.ModalWindow",helper:SYNO.SDS.LicenseManager.Utils.Helper,defaultWinSize:{width:690,height:450},stepItemId:{AGREEMENT:"agreementStep",LICENSE_ADD:"licenseAddStep",ACCOUNT:"accountStep",SUMMARY:"summaryStep",RESULT:"resultStep",CONNECTION_FAIL:"connectionStep",IMPORT:"importStep"},constructor:function(a){var d=this,c;d.appWin=a.appWin;d.owner=a.owner;d.appType=a.appType;d.appName=a.appName;d.appLogName=a.appLogName;d.defaultWebAPIName=a.defaultWebAPIName;d.importEnable=a.importEnable;d.addPreHook=a.addPreHook;d.addPostHook=a.addPostHook;d.version=a.version||1;c=a.option;var b={title:_T("license","license_add_wizard_title"),cls:"syno-app-license-manager",width:d.defaultWinSize.width,height:d.defaultWinSize.height,minWidth:d.defaultWinSize.width,minHeight:d.defaultWinSize.height,resizable:false,activeStep:d.stepItemId.AGREEMENT,steps:[]};b.steps.push(new SYNO.SDS.LicenseManager.Wizard.LicenseAgreementStep({appWin:d.appWin,owner:d,option:c,itemId:d.stepItemId.AGREEMENT,nextId:{fail_connect:d.stepItemId.CONNECTION_FAIL,success:d.stepItemId.ACCOUNT}}));b.steps.push(new SYNO.SDS.LicenseManager.Wizard.ConnectionFailStep({appWin:d.appWin,owner:d,option:c,itemId:d.stepItemId.CONNECTION_FAIL,nextId:{success:d.stepItemId.ACCOUNT,go_import:d.stepItemId.IMPORT}}));b.steps.push(new SYNO.SDS.LicenseManager.Wizard.LicenseImportStep({appWin:d.appWin,owner:d,option:c,itemId:d.stepItemId.IMPORT,nextId:d.stepItemId.RESULT}));b.steps.push(new SYNO.SDS.LicenseManager.Wizard.SynologyAccountStep({appWin:d.appWin,owner:d,option:c,itemId:d.stepItemId.ACCOUNT,nextId:d.stepItemId.LICENSE_ADD}));b.steps.push(new SYNO.SDS.LicenseManager.Wizard.LicenseInputStep({appWin:d.appWin,owner:d,version:d.version,option:c,itemId:d.stepItemId.LICENSE_ADD,nextId:d.stepItemId.SUMMARY}));b.steps.push(new SYNO.SDS.LicenseManager.Wizard.SummaryStep({appWin:d.appWin,owner:d,option:c,version:d.version||1,itemId:d.stepItemId.SUMMARY,nextId:d.stepItemId.RESULT}));b.steps.push(new SYNO.SDS.LicenseManager.Wizard.ResultStep({appWin:d.appWin,owner:d,option:c,itemId:d.stepItemId.RESULT,nextId:null}));d.callParent([Ext.apply(b,a)])},applySettings:function(){var b=this;var c={appType:b.appType,appLogName:b.appLogName,licenseCode:b.getStep(b.stepItemId.LICENSE_ADD).getLicenseCodes(),account:b.getStep(b.stepItemId.ACCOUNT).getAccount()};var a=function(){b.helper.maskLoading(b);b.appWin.sendWebAPI({api:b.defaultWebAPIName,method:"activate",version:b.version,params:c,scope:b,callback:function(e,d){b.helper.unmask(b);b.resp=d;if(!e){SYNO.Debug.error("Failed to activate license",d);b.result="add_failed"}else{b.isDataChanged=true;b.result="add_success";if(b.addPostHook){b.addPostHook()}}b.goNext(b.stepItemId.RESULT)}})};if(b.addPreHook){b.addPreHook({addLicenseCode:b.getStep(b.stepItemId.LICENSE_ADD).getLicenseCodes(),addWin:b,callback:a})}else{a()}return false}});Ext.define("SYNO.SDS.LicenseManager.Wizard.Delete",{extend:"SYNO.SDS.ModalWindow",helper:SYNO.SDS.LicenseManager.Utils.Helper,defaultWinSize:{width:500,height:330},constructor:function(a){var f=this,d;f.appWin=a.appWin;f.owner=a.owner;f.appType=a.appType;f.appLogName=a.appLogName;f.unused=a.unused;f.defaultWebAPIName=a.defaultWebAPIName;f.deletePreHook=a.deletePreHook;f.deletePostHook=a.deletePostHook;f.version=a.version||1;d=a.option;f.licenseCode=[];f.licenseResult=[];f.deleteNum=0;Ext.each(a.records,function(h){var g={};g.licenseCode=h.get("name");g.licenseData=h.get("data");f.licenseResult.push(g);f.licenseCode.push(h.get("name"));if(f.helper.isValid(h.get("status"))){f.deleteNum+=h.get("data")}});var b=[{xtype:"syno_formpanel",labelWidth:192,items:[{xtype:"syno_displayfield",value:_T("license","license_delete_annotation")},{xtype:"syno_displayfield",id:f.total_id=Ext.id(),fieldLabel:f.helper.T("license","total_num"),labelStyle:"padding-left: 8px;",style:"padding-left: 7px;font-weight: bold;",value:"0"},f.gridPanel=new SYNO.SDS.LicenseManager.Wizard.SummaryGridPanel({dataColWidth:240})]}];var e=[{xtype:"syno_button",btnStyle:"red",text:_T("common","delete"),scope:f,handler:f.onApply},{xtype:"syno_button",text:_T("common","cancel"),scope:f,handler:f.close}];var c={title:_T("license","license_delete_wizard_title"),cls:"syno-app-license-manager",width:f.defaultWinSize.width,height:f.defaultWinSize.height,minWidth:f.defaultWinSize.width,minHeight:f.defaultWinSize.height,resizable:false,layout:"fit",items:b,buttons:e,listeners:{afterrender:f.onBeforeShow,scope:f,single:f,activate:f.onActivate}};f.callParent([Ext.apply(c,a)])},onActivate:function(){var b=this,a={};a=b.helper.renderSummaryDisplay(b.licenseResult);Ext.getCmp(b.total_id).setValue(a.total);b.gridPanel.update(a.display)},onBeforeShow:function(){var a=this;if(a.deleteNum>a.unused){a.getMsgBox().alert("",String.format('<span class="red-status">{0}</span>',String.format(_T("license","insufficient_license_notice"),a.deleteNum-a.unused)),a.close,a);return}a.helper.maskLoading(a);a.sendWebAPI({api:"SYNO.Core.MyDSCenter",method:"query",version:2,scope:a,callback:function(c,b){a.helper.unmask(a);if(!c||!b.is_logged_in){var d=_T("license","license_result_login_fail")+"<br>"+a.helper.T("license","local_delete_confirm");a.getMsgBox().confirm("",d,a.localDelete,a);return}a.account=b.account}})},onApply:function(){var b=this,c={appType:b.appType,appLogName:b.appLogName,licenseCode:b.licenseCode,account:b.account},a;a=function(){b.helper.maskLoading(b);b.sendWebAPI({api:b.defaultWebAPIName,method:"deactivate",version:b.version,params:c,callback:function(e,d){b.helper.unmask(b);if(!e){var f="";switch(d.code){case SYNO.SDS.LicenseManager.ERR_WEBAPI_CONNECTION:f=_T("license","error_connection");if(d.errors&&d.errors.licenses){b.licenseCode=d.errors.licenses}break;default:f=_T("license","license_result_delete_fail");break}f+="<br>"+b.helper.T("license","local_delete_confirm");b.getMsgBox().confirm("",f,b.localDelete,b)}else{b.isDataChanged=true;if(b.deletePostHook){b.deletePostHook()}b.close()}}})};if(b.deletePreHook){b.deletePreHook({delLicenseCode:b.licenseCode,delWin:b,callback:a})}else{a()}},localDelete:function(a){var b=this,c={appType:b.appType,appLogName:b.appLogName,licenseCode:b.licenseCode,account:b.account};if("yes"!==a){if(b.deletePostHook){b.deletePostHook()}b.close();return}b.helper.maskLoading(b);b.sendWebAPI({api:b.defaultWebAPIName,method:"delete",version:1,params:c,callback:function(e,d){b.helper.unmask(b);if(!e){b.appWin.getMsgBox().alert("",_T("license","error_local_delete"))}else{b.isDataChanged=true}if(b.deletePostHook){b.deletePostHook()}b.close()}})}});Ext.define("SYNO.SDS.LicenseManager.Wizard.WelcomeStep",{extend:"SYNO.SDS.Wizard.WelcomeStep",helper:SYNO.SDS.LicenseManager.Utils.Helper,constructor:function(a){var b=this;b.owner=a.owner;b.callParent([a])},getNext:function(){var a=this;a.helper.maskLoading(a.owner);a.appWin.sendWebAPI({api:SYNO.SDS.LicenseManager.LICENSE_API,method:"check_connection",version:1,scope:a,callback:function(c,b){a.helper.unmask(a.owner);a.owner.getButton("cancel").setText(_T("common","cancel"));if(!c){a.owner.goNext(a.nextId.fail_connect)}else{a.owner.goNext(a.nextId.success)}}});return false}});Ext.define("SYNO.SDS.LicenseManager.Wizard.Extend",{extend:"SYNO.SDS.Wizard.ModalWindow",helper:SYNO.SDS.LicenseManager.Utils.Helper,defaultWinSize:{width:650,height:450},stepItemId:{WELCOME:"welcomeStep",CONNECTION_FAIL:"connectionStep",IMPORT:"importStep",ACCOUNT:"accountStep",LICENSE_ADD:"licenseAddStep",SUMMARY:"summaryStep",RESULT:"resultStep"},constructor:function(a){var d=this,c;d.appWin=a.appWin;d.owner=a.owner;d.appType=a.appType;d.appName=a.appName;d.appLogName=a.appLogName;d.extendedTarget=a.code;d.defaultWebAPIName=a.defaultWebAPIName;d.importEnable=a.importEnable;d.extPreHook=a.extPreHook;d.extPostHook=a.extPostHook;c=a.option;var b={title:_T("license","extend_wizard_title"),cls:"syno-app-license-manager",width:d.defaultWinSize.width,height:d.defaultWinSize.height,minWidth:d.defaultWinSize.width,minHeight:d.defaultWinSize.height,resizable:false,activeStep:d.stepItemId.WELCOME,steps:[]};b.steps.push(new SYNO.SDS.LicenseManager.Wizard.WelcomeStep({appWin:d.appWin,owner:d,option:c,headline:_T("license","extend_welcome_headline"),description:_T("license","extend_welcome_desc"),itemId:d.stepItemId.WELCOME,nextId:{fail_connect:d.stepItemId.CONNECTION_FAIL,success:d.stepItemId.ACCOUNT}}));b.steps.push(new SYNO.SDS.LicenseManager.Wizard.ConnectionFailStep({appWin:d.appWin,owner:d,option:c,itemId:d.stepItemId.CONNECTION_FAIL,nextId:{success:d.stepItemId.ACCOUNT,go_import:d.stepItemId.IMPORT}}));b.steps.push(new SYNO.SDS.LicenseManager.Wizard.ExtendImportStep({appWin:d.appWin,owner:d,option:c,itemId:d.stepItemId.IMPORT,nextId:d.stepItemId.RESULT}));b.steps.push(new SYNO.SDS.LicenseManager.Wizard.SynologyAccountStep({appWin:d.appWin,owner:d,option:c,itemId:d.stepItemId.ACCOUNT,nextId:d.stepItemId.LICENSE_ADD}));b.steps.push(new SYNO.SDS.LicenseManager.Wizard.LicenseInputStep({appWin:d.appWin,owner:d,option:c,extendedTarget:d.extendedTarget,itemId:d.stepItemId.LICENSE_ADD,nextId:d.stepItemId.SUMMARY}));b.steps.push(new SYNO.SDS.LicenseManager.Wizard.SummaryStep({appWin:d.appWin,owner:d,option:c,extendedTarget:d.extendedTarget,itemId:d.stepItemId.SUMMARY,nextId:d.stepItemId.RESULT}));b.steps.push(new SYNO.SDS.LicenseManager.Wizard.ResultStep({appWin:d.appWin,owner:d,option:c,itemId:d.stepItemId.RESULT,nextId:null}));d.callParent([Ext.apply(b,a)])},applySettings:function(){var b=this;var c={appType:b.appType,appLogName:b.appLogName,licenseCode:b.getStep(b.stepItemId.LICENSE_ADD).getLicenseCodes(),extendedTarget:b.extendedTarget,account:b.getStep(b.stepItemId.ACCOUNT).getAccount()};var a=function(){b.helper.maskLoading(b);b.appWin.sendWebAPI({api:b.defaultWebAPIName,method:"extend",version:1,params:c,scope:b,callback:function(e,d){b.helper.unmask(b);b.resp=d;if(!e){SYNO.Debug.error("Failed to extend license",d);b.result="extend_failed"}else{b.isDataChanged=true;b.result="extend_success";if(b.extPostHook){b.extPostHook()}}b.goNext(b.stepItemId.RESULT)}})};if(b.extPreHook){b.extPreHook({extLicenseCode:b.getStep(b.stepItemId.LICENSE_ADD).getLicenseCodes(),extWin:b,callback:a})}else{a()}return false}});Ext.define("SYNO.SDS.LicenseManager.License.Main",{extend:"SYNO.ux.Panel",helper:SYNO.SDS.LicenseManager.Utils.Helper,defaultWebAPIName:"SYNO.License",constructor:function(a){var c=this;c.loaded=false;c.appWin=a.appWin;c.owner=a.owner;c.appType=c.appWin.licenseConfig?c.appWin.licenseConfig.appType:SYNO.SDS.LicenseManager.APPLICATION_TYPE_ALL;c.appName=c.appWin.licenseConfig?c.appWin.licenseConfig.appName:_T("license","default_app_name");c.defaultWebAPIName=c.appWin.licenseConfig?c.appWin.licenseConfig.defaultWebAPIName||c.defaultWebAPIName:c.defaultWebAPIName;c.appLogName=c.appWin.licenseConfig?c.appWin.licenseConfig.appLogName:"Synology Application";c.importEnable=c.appWin.licenseConfig?c.appWin.licenseConfig.importEnable||false:false;SYNO.SDS.LicenseManager.app=c.appWin.licenseConfig?c.appWin.licenseConfig.app:undefined;c.deletePreHook=a.deletePreHook;c.deletePostHook=a.deletePostHook;c.addPreHook=a.addPreHook;c.addPostHook=a.addPostHook;c.extPreHook=a.extPreHook;c.extPostHook=a.extPostHook;c.version=a.version||1;c.licenseStore=new SYNO.SDS.LicenseManager.License.Store();c.infoPanel=new SYNO.ux.Panel({layout:"hbox",items:[{xtype:"syno_formpanel",autoFlexcroll:false,items:[{xtype:"syno_displayfield",id:c.info_total_id=Ext.id(),fieldLabel:_T("license","license_total_string"),value:"0"}]},{xtype:"syno_formpanel",autoFlexcroll:false,items:[{xtype:"syno_displayfield",id:c.info_used_id=Ext.id(),indent:1,fieldLabel:_T("license","license_used_string"),value:"0"}]},{xtype:"syno_formpanel",autoFlexcroll:false,items:[{xtype:"syno_displayfield",id:c.info_unused_id=Ext.id(),indent:1,fieldLabel:_T("license","license_unused_string"),value:"0"}]}]});c.colModel=new Ext.grid.ColumnModel({defaults:{width:120,sortable:true},columns:[{header:_T("license","license_key_string"),dataIndex:"displayName",width:250,renderer:function(f,e){e.attr='style="font-family:monospace;text-transform: uppercase;"';return f}},{header:_T("license","license_num_string"),dataIndex:"data",width:150},{header:_T("license","first_activate_date_string"),dataIndex:"firstActTime",width:150},{header:_T("license","license_expire_date_string"),dataIndex:"expireTime",width:150},{header:_T("license","license_status_string"),useHtmlEncodeRender:false,dataIndex:"displayStatus",width:150}]});c.selModel=new Ext.grid.RowSelectionModel({singleSelect:false,listeners:{selectionchange:c.onSelectionChange,scope:c}});c.gridPanel=new SYNO.ux.GridPanel({layout:"fit",colModel:c.colModel,selModel:c.selModel,listeners:{rowdblclick:c.onDBClick,rowcontextmenu:c.onRowCtxMenu,containercontextmenu:c.showCtxMenu,scope:c},store:c.licenseStore,cls:"without-dirty-red-grid"});c.actionAdd=new Ext.Action({itemId:"add",text:_T("common","add"),disabled:false,scope:c,handler:c.onLicenseAdd});var d=[new SYNO.ux.Button(c.actionAdd)];if(1===c.version){c.actionDelete=new Ext.Action({itemId:"delete",text:_T("common","delete"),disabled:true,scope:c,handler:c.onLicenseDelete});c.actionExtend=new Ext.Action({itemId:"extend",text:_T("license","extend"),disabled:true,scope:c,handler:c.onLicenseExtend});d.push(new SYNO.ux.Button(c.actionDelete));d.push(new SYNO.ux.Button(c.actionExtend))}var b={layout:"fit",items:[c.gridPanel],tbar:{items:d},bbar:{height:40,items:c.infoPanel},listeners:{activate:c.onActivate,scope:c}};c.callParent([Ext.apply(b,a)])},onActivate:function(){var a=this;a.getLicenseList()},getLicenseList:function(){var a=this;a.used=a.appWin.licenseConfig?a.appWin.licenseConfig.used||0:0;a.free=a.appWin.licenseConfig?a.appWin.licenseConfig.free||0:0;if(!a.loaded){a.helper.maskLoading(a)}a.appWin.sendWebAPI({api:a.defaultWebAPIName,method:"list",version:a.version,scope:a,callback:function(c,b){if(!a.loaded){a.helper.unmask(a)}a.loaded=true;if(!c){SYNO.Debug.error("Failed to get license list",b)}else{a.processLicenseData(b.licenses);a.onSelectionChange()}}})},processLicenseData:function(c){var b=this;var a=b.free;delete b.licenses;b.licenses=[];b.processFreeLicense();Ext.each(c,function(d){var e={};if(!b.appType||SYNO.SDS.LicenseManager.APPLICATION_TYPE_ALL===b.appType){}else{if(b.appType!==d.appType){return true}}e.name=d.licenseCode;e.displayName=b.helper.maskLicenseCode(d.licenseCode);e.status=d.status;e.displayStatus=b.helper.renderStatus(d.status);e.data=d.licenseContent;e.firstActTime=b.helper.renderDate(d.firstActTime);e.expireTime=0!==d.expireTime?b.helper.renderDate(d.expireTime):"-";b.licenses.push(e);if(b.helper.isValid(d.status)){a+=e.data}});b.licenseStore.suspendEvents(true);b.licenseStore.loadData(b.licenses,false);b.licenseStore.resumeEvents();Ext.getCmp(b.info_total_id).setValue(a);Ext.getCmp(b.info_used_id).setValue(b.used);Ext.getCmp(b.info_unused_id).setValue((a-b.used)<0?0:a-b.used);b.total=a},processFreeLicense:function(){var a=this,b={};if(!a.appType||SYNO.SDS.LicenseManager.APPLICATION_TYPE_ALL===a.appType||0===a.free){return}b.displayName=_T("license","license_type_free");b.status="valid";b.displayStatus=a.helper.renderStatus(b.status);b.name=_T("license","license_type_free");b.data=a.free;b.firstActTime="-";b.expireTime="-";a.licenses.push(b)},onSelectionChange:function(){var e=this,d=e.selModel.getCount(),c=e.selModel.getSelections(),b=false,a=false;if(1===e.version){e.getButton("delete").hide();e.actionDelete.disable();e.getButton("extend").hide();e.actionExtend.disable()}e.getButton("add").show();e.actionAdd.enable();if(0===d){return}c.each(function(f){if(_T("license","license_type_free")===f.id){b=true;return false}if(!e.helper.isValid(f.get("status"))){a=true}});if(!b&&1===e.version){e.getButton("delete").show();e.actionDelete.enable();if(1===d&&!a){e.getButton("extend").show();e.actionExtend.enable()}}},onDBClick:function(b,e,d){var c=this;var a=c.licenseStore.getAt(e);if(a){}},onRowCtxMenu:function(a,e,c){var b=this,d=b.selModel;if(!d.isSelected(e)){d.selectRow(e)}b.showCtxMenu(a,c)},showCtxMenu:function(b,d){var c=this,a=[];a.push(c.actionAdd);if(1===c.version){a.push(c.actionDelete);a.push(c.actionExtend)}var e=new SYNO.ux.Menu({autoDestroy:true,items:a});c.onSelectionChange();e.showAt(d.getXY())},onLicenseAdd:function(){var a=this;a.openWizard("Add",{importEnable:a.importEnable,addPreHook:a.addPreHook,addPostHook:a.addPostHook,version:a.version})},onLicenseDelete:function(){var b=this,a=b.selModel.getSelections();if(0===a.length){return}b.openWizard("Delete",{records:a,unused:(b.total-b.used)>0?b.total-b.used:0,deletePreHook:b.deletePreHook,deletePostHook:b.deletePostHook,version:b.version})},onLicenseExtend:function(){var b=this,a=b.selModel.getSelections();if(1!==a.length){return}b.openWizard("Extend",{code:a[0].get("name"),extPreHook:b.extPreHook,extPostHook:b.extPostHook})},openWizard:function(b,a){var c=this;var d=new SYNO.SDS.LicenseManager.Wizard[b](Ext.apply({appWin:c.appWin,owner:c.owner,appType:c.appType,appName:c.appName,appLogName:c.appLogName,defaultWebAPIName:c.defaultWebAPIName},a));c.mon(d,"close",function(){if(Ext.isFunction(d.hideFromOwner)){d.hideFromOwner()}if(!d.isDataChanged){return}c.getLicenseList()},c,{single:true});d.open()},getButton:function(a){return this.getTopToolbar().getComponent(a)}});