#!/bin/sh

SUPPORT_DUAL_HEAD=`/bin/get_key_value /etc.defaults/synoinfo.conf support_dual_head`
if [ "yes" = "${SUPPORT_DUAL_HEAD}" ]; then
	. /etc.defaults/rc.network_dualhead
fi

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "1.0";
	;;
	--name)
	#Print package name
	echo "synoaha"
	;;
	--pkg-ver)
	#Print package version
	echo "1.0";
	;;
	--vendor)
	#Print package vendor
	echo "Synology";
	;;
	--pre)
	. /etc.defaults/rc.network dualhead-pre-check-interfaces $DUAL_HEAD_HA_NET_CHANG_NEED_LOCK &
	;;
	--post)
	. /etc.defaults/rc.network dualhead-check-interfaces $DUAL_HEAD_HA_NET_CHANG_NEED_LOCK &
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

