#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

SYSLOGNG_SERVER_PORT=514
SYSLOGNG_SERVER_TRANS_MODE=udp
SYSLOGNG_SERVER_SSL=0

SYSLOGNG_SERVER_IETF_PORT=514
SYSLOGNG_SERVER_IETF_TRANS_MODE=udp
SYSLOGNG_SERVER_IETF_SSL=0

SYSLOGNG_SERVER_LOG_ROTATE_TIME=0
SYSLOGNG_SERVER_DB_LOC=""
SYSLOGNG_SERVER_DB_PATH=""
SYSLOGNG_SERVER_CA_KEY_PATH="/usr/syno/etc/ssl/ssl.key/server.key"  #?
SYSLOGNG_SERVER_CA_FILE_PATH="/usr/syno/etc/ssl/ssl.crt/server.crt" #?
SYSLOGNG_SERVER_INTER_FILETER=""
SYSLOGNG_SERVER_TLS="tls(key_file(\"/usr/syno/etc/synosyslog/keys/ca.key\") cert_file(\"/usr/syno/etc/synosyslog/keys/ca.crt\") peer_verify(optional-untrusted))"

SyslogBsdConfigGen(){
    SyslogServerSettingGet "syslog-bsd"

    BsdConfDataClear
    touch ${SYSLOGNG_CONFIG_BSD}
    BsdSourceProcess
    BsdDestProcess
    BsdLogProcess
}
SyslogBsdConfigClr(){
    BsdConfDataClear
}

########################

SyslogServerSettingGet(){
    if [ ! -f "${SYSLOGNG_SERVER_SETTING}" ]; then
        echo "Syslog setting file does not exist!"
        exit 1
    fi

    SYSLOGNG_SERVER_PORT=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} server_port`
    SYSLOGNG_SERVER_TRANS_MODE=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} server_trans`
    SYSLOGNG_SERVER_SSL=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} server_ssl`

    SYSLOGNG_SERVER_IETF_PORT=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} server_ietf_port`
    SYSLOGNG_SERVER_IETF_TRANS_MODE=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} server_ietf_trans`
    SYSLOGNG_SERVER_IETF_SSL=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} server_ietf_ssl`

    SYSLOGNG_SERVER_LOG_ROTATE_TIME=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} server_log_rotate_time`
    SYSLOGNG_SERVER_DB_LOC=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} server_db_loc`
    SYSLOGNG_SERVER_DB_PATH=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} server_db_path`
    SYSLOGNG_SERVER_CA_KEY_PATH=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} server_ca_key`
    SYSLOGNG_SERVER_CA_FILE_PATH=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} server_ca_file`
    SYSLOGNG_SERVER_INTER_FILETER=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} server_internal_filter`

    SYSLOGNG_SERVER_ARCH_DEST=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} arch_dest`
    if [ ! -e "$SYSLOGNG_SERVER_ARCH_DEST" ]; then
        local RegisterShare=`synoservicecfg --get-field-info "${1}" share | sed 's/\[\(.*\)\]/\1/'`
        local SharePath=`synoshare --get $RegisterShare | grep 'Path .......' |sed 's/\s*Path \.\.\.\.\.\.\.\[\(.*\)\]/\1/'`
        local SlashNum=$((`echo "${SharePath}" | grep -o "/" |wc -l` + 2))
        local SubPath=`echo $SYSLOGNG_SERVER_ARCH_DEST | cut -d'/' -f${SlashNum}-`
        if [ -z $SubPath ] ; then
            SYSLOGNG_SERVER_ARCH_DEST=${SharePath}
        else
            SYSLOGNG_SERVER_ARCH_DEST=${SharePath}'/'${SubPath}
        fi
    fi
    SYSLOGNG_SERVER_ARCH_BYDEVICE=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} arch_by_device`
}

BsdConfDataClear(){
    rm -rf ${SYSLOGNG_CONFIG_BSD} > /dev/null 2>&1
}

BsdSourceProcess(){
    local TEMPLATE_FILE=${SYSLOGNG_SERVER_TEMPLATE_FOLDER}/src.template
    local SOCKET_BUFFER=`cat /proc/sys/net/ipv4/tcp_wmem | awk '{print $3}'`
    local TRANSPORT="udp"
    local TLS_RULE=""

    if [ "tcp" == "${SYSLOGNG_SERVER_TRANS_MODE}" ]; then
        TRANSPORT="tcp"
        if [ "1" == "${SYSLOGNG_SERVER_SSL}" ]; then
            TRANSPORT="tls"
            TLS_RULE=${SYSLOGNG_SERVER_TLS}
        fi
    fi

    # process v4 source
    cat ${TEMPLATE_FILE} |
    sed -e "s/__SYNO_SRCNAME__/bsd/" \
        -e "s/__SYNO_SRCTYPE__/network/" \
        -e "s/__SYNO_ANYADDR__/\"0.0.0.0\"/" \
        -e "s/__SYNO_TRANSPORT__/${TRANSPORT}/" \
        -e "s/__SYNO_PORT__/${SYSLOGNG_SERVER_PORT}/" \
        -e "s/__SYNO_IPV__/4/" \
        -e "s=__SYNO_CA_SETTING__=${TLS_RULE}=" \
        -e "s/__SYNO_SOCKBUF__/${SOCKET_BUFFER}/" \
        >> ${SYSLOGNG_CONFIG_BSD}

    # process v6 source
    cat ${TEMPLATE_FILE} |
    sed -e "s/__SYNO_SRCNAME__/bsd_6/" \
        -e "s/__SYNO_SRCTYPE__/network/" \
        -e "s/__SYNO_ANYADDR__/\"::\"/" \
        -e "s/__SYNO_TRANSPORT__/${TRANSPORT}/" \
        -e "s/__SYNO_PORT__/${SYSLOGNG_SERVER_PORT}/" \
        -e "s/__SYNO_IPV__/6/" \
        -e "s=__SYNO_CA_SETTING__=${TLS_RULE}=" \
        -e "s/__SYNO_SOCKBUF__/${SOCKET_BUFFER}/" \
        >> ${SYSLOGNG_CONFIG_BSD}
}

BsdDestProcess(){
    local DB_PATH=${SYSLOGNG_SERVER_ARCH_DEST}/SYNOSYSLOGDB__ARCH.DB

    if [ -z "$SYSLOGNG_SERVER_ARCH_DEST" ]; then
        exit 1
    fi

    if [ "1" == "${SYSLOGNG_SERVER_ARCH_BYDEVICE}" ]; then
        DB_PATH=${SYSLOGNG_SERVER_ARCH_DEST}/\$HOST/SYNOSYSLOGDB_\$HOST.DB
    fi

    cat ${SYSLOGNG_SERVER_TEMPLATE_FOLDER}/arch_dest_db.template |
    sed -e "s=__SYNO_DB_PATH__=${DB_PATH}=" \
    >> ${SYSLOGNG_CONFIG_BSD}
}

BsdLogProcess(){
    echo "log { source(s_syno_bsd); source(s_syno_bsd_6); destination(d_syno_db); flags(flow_control); };" \
    >> ${SYSLOGNG_CONFIG_BSD}

    echo "log { source(s_syno_bsd); source(s_syno_bsd_6); destination(d_syno_dest_recv); flags(flow_control); };" \
    >> ${SYSLOGNG_CONFIG_BSD}

    echo "log { source(s_syno_bsd); source(s_syno_bsd_6); destination(d_syno_arch_db); flags(flow_control); };" \
    >> ${SYSLOGNG_CONFIG_BSD}
}

####################################################
####################################################
####################################################

SyslogIetfConfigGen(){
    SyslogServerSettingGet "syslog-ietf"

    IetfConfDataClear
    touch ${SYSLOGNG_CONFIG_IETF}
    IetfSourceProcess
    IetfFilterProcess
    IetfDestProcess
    IetfLogProcess
}
SyslogIetfConfigClr(){
    IetfConfDataClear
}

########################
IetfConfDataClear(){
    rm -rf ${SYSLOGNG_CONFIG_IETF} > /dev/null 2>&1
}

IetfSourceProcess(){
    local TEMPLATE_FILE=${SYSLOGNG_SERVER_TEMPLATE_FOLDER}/src.template
    local SOCKET_BUFFER=`cat /proc/sys/net/ipv4/tcp_wmem | awk '{print $3}'`
    local TRANSPORT="udp"
    local TLS_RULE=""

    if [ "tcp" == "${SYSLOGNG_SERVER_IETF_TRANS_MODE}" ]; then
        TRANSPORT="tcp"
        if [ "1" == "${SYSLOGNG_SERVER_IETF_SSL}" ]; then
            TRANSPORT="tls"
            TLS_RULE=${SYSLOGNG_SERVER_TLS}
        fi
    fi

    # process v4 source
    cat ${TEMPLATE_FILE} |
    sed -e "s/__SYNO_SRCNAME__/ietf/" \
        -e "s/__SYNO_SRCTYPE__/syslog/" \
        -e "s/__SYNO_ANYADDR__/\"0.0.0.0\"/" \
        -e "s/__SYNO_TRANSPORT__/${TRANSPORT}/" \
        -e "s/__SYNO_PORT__/${SYSLOGNG_SERVER_IETF_PORT}/" \
        -e "s/__SYNO_IPV__/4/" \
        -e "s=__SYNO_CA_SETTING__=${TLS_RULE}=" \
        -e "s/__SYNO_SOCKBUF__/${SOCKET_BUFFER}/" \
        >> ${SYSLOGNG_CONFIG_IETF}

    # process v6 source
    cat ${TEMPLATE_FILE} |
    sed -e "s/__SYNO_SRCNAME__/ietf_6/" \
        -e "s/__SYNO_SRCTYPE__/syslog/" \
        -e "s/__SYNO_ANYADDR__/\"::\"/" \
        -e "s/__SYNO_TRANSPORT__/${TRANSPORT}/" \
        -e "s/__SYNO_PORT__/${SYSLOGNG_SERVER_IETF_PORT}/" \
        -e "s/__SYNO_IPV__/6/" \
        -e "s=__SYNO_CA_SETTING__=${TLS_RULE}=" \
        -e "s/__SYNO_SOCKBUF__/${SOCKET_BUFFER}/" \
        >> ${SYSLOGNG_CONFIG_IETF}
}

GeneralFilterProcess(){
    echo "filter f_syno_general { match('^System$' value('.SDATA.synolog@6574.synotype'));};" \
    >> ${SYSLOGNG_CONFIG_IETF}
}
ConnectionFilterProcess(){
    echo "filter f_syno_connection { match('^Connection$' value('.SDATA.synolog@6574.synotype'));};" \
    >> ${SYSLOGNG_CONFIG_IETF}
}
TransferFilterProcess(){
    echo "filter f_syno_ftpxfer { match('^FtpFileTransfer$' value('.SDATA.synolog@6574.synotype')); };" \
    >> ${SYSLOGNG_CONFIG_IETF}
    echo "filter f_syno_fsxfer { match('^FileStation$' value('.SDATA.synolog@6574.synotype')); };" \
    >> ${SYSLOGNG_CONFIG_IETF}
    echo "filter f_syno_fbxfer { match('^FileBrowser$' value('.SDATA.synolog@6574.synotype')); };" \
    >> ${SYSLOGNG_CONFIG_IETF}
    echo "filter f_syno_webdavxfer { match('^Webdav$' value('.SDATA.synolog@6574.synotype')); };" \
    >> ${SYSLOGNG_CONFIG_IETF}
    echo "filter f_syno_cifsxfer { match('^WinFileService$' value('.SDATA.synolog@6574.synotype')); };" \
    >> ${SYSLOGNG_CONFIG_IETF}

    echo "filter f_syno_transfer { filter(f_syno_ftpxfer) or filter(f_syno_fsxfer) or filter(f_syno_fbxfer) or filter(f_syno_webdavxfer) or filter(f_syno_cifsxfer) };" \
    >> ${SYSLOGNG_CONFIG_IETF}
}

IetfFilterProcess(){
    GeneralFilterProcess
    ConnectionFilterProcess
    TransferFilterProcess
}

IetfDestProcess(){
    local DB_PATH=${SYSLOGNG_SERVER_ARCH_DEST}/SYNOSYSLOGDB__ARCH.DB
    local DB_PATH_SYS=${SYSLOGNG_SERVER_ARCH_DEST}/SYNOSYSLOGDB__ARCH_SYS
    local DB_PATH_CON=${SYSLOGNG_SERVER_ARCH_DEST}/SYNOSYSLOGDB__ARCH_CON
    local DB_PATH_XFER=${SYSLOGNG_SERVER_ARCH_DEST}/SYNOSYSLOGDB__ARCH_XFER

    if [ "1" == "${SYSLOGNG_SERVER_ARCH_BYDEVICE}" ]; then
        DB_PATH=${SYSLOGNG_SERVER_ARCH_DEST}/\${HOST}/SYNOSYSLOGDB_\${HOST}.DB
        DB_PATH_SYS=${SYSLOGNG_SERVER_ARCH_DEST}/\${HOST}/SYNOSYSLOGDB_\${HOST}_SYS
        DB_PATH_CON=${SYSLOGNG_SERVER_ARCH_DEST}/\${HOST}/SYNOSYSLOGDB_\${HOST}_CON
        DB_PATH_XFER=${SYSLOGNG_SERVER_ARCH_DEST}/\${HOST}/SYNOSYSLOGDB_\${HOST}_XFER
    fi

    #main database
    cat ${SYSLOGNG_SERVER_TEMPLATE_FOLDER}/arch_dest_db.template |
    sed -e "s=__SYNO_DB_PATH__=${DB_PATH}=" \
    >> ${SYSLOGNG_CONFIG_IETF}

    #structure data
    cat ${SYSLOGNG_SERVER_TEMPLATE_FOLDER}/arch_dest_db_general.template |
    sed -e "s=__SYNO_DB_PATH__=${DB_PATH_SYS}=" \
    >> ${SYSLOGNG_CONFIG_IETF}

    cat ${SYSLOGNG_SERVER_TEMPLATE_FOLDER}/arch_dest_db_connection.template |
    sed -e "s=__SYNO_DB_PATH__=${DB_PATH_CON}=" \
    >> ${SYSLOGNG_CONFIG_IETF}

    cat ${SYSLOGNG_SERVER_TEMPLATE_FOLDER}/arch_dest_db_transfer.template |
    sed -e "s=__SYNO_DB_PATH__=${DB_PATH_XFER}=" \
    >> ${SYSLOGNG_CONFIG_IETF}
}

IetfDBLogProcess(){
    echo "log { source(s_syno_ietf); source(s_syno_ietf_6); destination(d_syno_db); flags(flow_control); };" \
    >> ${SYSLOGNG_CONFIG_IETF}
}
IetfPipeLogProcess(){
    echo "log { source(s_syno_ietf); source(s_syno_ietf_6); destination(d_syno_dest_recv); flags(flow_control); };" \
    >> ${SYSLOGNG_CONFIG_IETF}
}
IetfArchLogProcess(){
    #main database
    echo "log { source(s_syno_ietf); source(s_syno_ietf_6); destination(d_syno_arch_db); flags(flow_control); };" \
    >> ${SYSLOGNG_CONFIG_IETF}

    #structure data - general log
    echo "log { source(s_syno_ietf); source(s_syno_ietf_6); filter(f_syno_general); destination(d_syno_general_db); flags(flow_control); };" \
    >> ${SYSLOGNG_CONFIG_IETF}
    #structure data - connection log
    echo "log { source(s_syno_ietf); source(s_syno_ietf_6); filter(f_syno_connection); destination(d_syno_connection_db); flags(flow_control); };" \
    >> ${SYSLOGNG_CONFIG_IETF}
    #structure data - transfer log
    echo "log { source(s_syno_ietf); source(s_syno_ietf_6); filter(f_syno_transfer); destination(d_syno_transfer_db); flags(flow_control); };" \
    >> ${SYSLOGNG_CONFIG_IETF}
}
IetfLogProcess(){
    IetfDBLogProcess
    IetfPipeLogProcess
    IetfArchLogProcess
}
