#!/bin/sh
# Copyright (c) 2014 Synology Inc. All rights reserved.

BIN_GET_SKV=/usr/syno/bin/get_section_key_value

SYSLOGNG_TEMPLATE_SRC=${SYSLOGNG_CUSTRULE_TEMPLATE_FOLDER}/src.template
SYSLOGNG_TEMPLATE_PARSER=${SYSLOGNG_CUSTRULE_TEMPLATE_FOLDER}/parser.template
SYSLOGNG_TEMPLATE_PATTERN_DB=${SYSLOGNG_CUSTRULE_TEMPLATE_FOLDER}/pattern.template

SYSLOGNG_FOLDER_PATTERN_DB_XML=/usr/syno/etc/synosyslog/patterndb/

SyslogCustruleConfigGen(){
	CustruleConfDataClear
	touch ${SYSLOGNG_CONFIG_CUSTRULE}

	CustruleConfigGen
}

SyslogCustruleConfigClr(){
	CustruleConfDataClear
}

########################

CustruleConfDataClear(){
	rm -rf ${SYSLOGNG_CONFIG_CUSTRULE} > /dev/null 2>&1
	rm -rf ${SYSLOGNG_FOLDER_PATTERN_DB_XML}/*.xml > /dev/null 2>&1
}

CustRuleDestinationProcuss(){
	local SYSLOGNG_SERVER_ARCH_BYDEVICE=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} arch_by_device`
	local SYSLOGNG_SERVER_ARCH_DEST=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} arch_dest`
	local DB_PATH=${SYSLOGNG_SERVER_ARCH_DEST}/SYNOSYSLOGDB__ARCH.DB

	if [ -z "$SYSLOGNG_SERVER_ARCH_DEST" ]; then
		exit 1
	fi

    if [ "1" == "${SYSLOGNG_SERVER_ARCH_BYDEVICE}" ]; then
        DB_PATH=${SYSLOGNG_SERVER_ARCH_DEST}/\${HOST}/SYNOSYSLOGDB_\${HOST}.DB
    fi

    cat ${SYSLOGNG_SERVER_TEMPLATE_FOLDER}/arch_dest_db.template |
    sed -e "s=__SYNO_DB_PATH__=${DB_PATH}=" \
    >> ${SYSLOGNG_CONFIG_CUSTRULE}
}

CustruleConfigGen(){
	mkdir -p ${SYSLOGNG_FOLDER_PATTERN_DB_XML}

	CustRuleDestinationProcuss

	# for each section, read config and gen one rule
	local CUSTRULE_SEC_STRING=`grep '^\[.*\]$' ${SYSLOGNG_CUSTRULE_SETTING} | sed 's|^\[\(.*\)]$|\1|g'`
	local RULE=

	for RULE in ${CUSTRULE_SEC_STRING}
	do
		SingleRuleGen ${RULE}
	done
}

SingleRuleGen() {
	RULE_NAME=$1

	CUSTRULE_ENABLE=`${BIN_GET_SKV} ${SYSLOGNG_CUSTRULE_SETTING} ${RULE_NAME} enable`
	CUSTRULE_FORMAT=`${BIN_GET_SKV} ${SYSLOGNG_CUSTRULE_SETTING} ${RULE_NAME} format`
	CUSTRULE_PROTOCOL=`${BIN_GET_SKV} ${SYSLOGNG_CUSTRULE_SETTING} ${RULE_NAME} protocol`
	CUSTRULE_PORT=`${BIN_GET_SKV} ${SYSLOGNG_CUSTRULE_SETTING} ${RULE_NAME} port`
	CUSTRULE_SSL=`${BIN_GET_SKV} ${SYSLOGNG_CUSTRULE_SETTING} ${RULE_NAME} ssl`

	# escape if disable
	if [ "yes" != ${CUSTRULE_ENABLE} ]; then
		return
	fi

	CustRuleSourceProcess ${RULE_NAME}
	CustRuleParserProcess ${RULE_NAME}
	CustRuleLogProcess ${RULE_NAME}
}

CustRuleSourceProcess() {
	local RULE_NAME=$1
	local SOCKET_BUFFER=`awk '{print $3}' /proc/sys/net/ipv4/tcp_wmem`
	local PROTOCOL="udp"
	local TLS_RULE=""

	if [ "tcp" == "${CUSTRULE_PROTOCOL}" ]; then
		PROTOCOL="tcp"
		if [ "yes" == "${CUSTRULE_SSL}" ]; then
			PROTOCOL="tls"
			TLS_RULE="tls(key_file(\"/usr/syno/etc/synosyslog/keys/ca.key\") cert_file(\"/usr/syno/etc/synosyslog/keys/ca.crt\") peer_verify(optional-untrusted))"
		fi
	fi

	# process v4 source
	cat ${SYSLOGNG_TEMPLATE_SRC} |
    sed -e "s/__SYNO_SRCNAME__/${RULE_NAME}/" \
        -e "s/__SYNO_SRCTYPE__/network/" \
        -e "s/__SYNO_ANYADDR__/\"0.0.0.0\"/" \
        -e "s/__SYNO_TRANSPORT__/${PROTOCOL}/" \
        -e "s/__SYNO_PORT__/${CUSTRULE_PORT}/" \
        -e "s/__SYNO_IPV__/4/" \
        -e "s=__SYNO_CA_SETTING__=${TLS_RULE}=" \
        -e "s/__SYNO_SOCKBUF__/${SOCKET_BUFFER}/" \
        >> ${SYSLOGNG_CONFIG_CUSTRULE}

    # process v6 source
    cat ${SYSLOGNG_TEMPLATE_SRC} |
    sed -e "s/__SYNO_SRCNAME__/${RULE_NAME}_6/" \
        -e "s/__SYNO_SRCTYPE__/network/" \
        -e "s/__SYNO_ANYADDR__/\"::\"/" \
        -e "s/__SYNO_TRANSPORT__/${PROTOCOL}/" \
        -e "s/__SYNO_PORT__/${CUSTRULE_PORT}/" \
        -e "s/__SYNO_IPV__/6/" \
        -e "s=__SYNO_CA_SETTING__=${TLS_RULE}=" \
        -e "s/__SYNO_SOCKBUF__/${SOCKET_BUFFER}/" \
        >> ${SYSLOGNG_CONFIG_CUSTRULE}
}

CustRuleParserProcess() {
	local RULE_NAME=$1
	local PATTERN_DB_FILE=${RULE_NAME}".xml"
	local MD5=`date | openssl md5 | awk '{print $2}'`

	# 1. generate pattern db file, put it in "/usr/syno/etc/synosyslog/patterndb/<name>.xml"
	#    the pattern needs to overwrite following macro for Synology Log Center if necessary
	#
	#      $YEAR $MONTH $DAY $HOUR $MIN $SEC
	#      $HOSTNAME $PROGRAM $FACILITY $PRIORITY $MSGONLY
	#

	rm -rf ${SYSLOGNG_FOLDER_PATTERN_DB_XML}${PATTERN_DB_FILE} > /dev/null 2>&1
	touch ${SYSLOGNG_FOLDER_PATTERN_DB_XML}${PATTERN_DB_FILE}
	cat ${SYSLOGNG_TEMPLATE_PATTERN_DB} |
	sed -e "s/__SYNO_ID__/${RULE_NAME}/" \
		-e "s/__SYNO_PATTERNDB_RULE__/${CUSTRULE_FORMAT}/" \
		-e "s/__SYNO_MD5__/${MD5}/" \
		>> ${SYSLOGNG_FOLDER_PATTERN_DB_XML}${PATTERN_DB_FILE}

	# 2. create rule to use the pattern
	#
	#      parser p_parser_<name> {
	#          db_parser(
	#              file("/usr/syno/etc/synosyslog/patterndb/<name>.xml")
	#          );
	#      };
	#

	cat ${SYSLOGNG_TEMPLATE_PARSER} |
	sed -e "s/__SYNO_NAME__/${RULE_NAME}/" \
		-e "s/__SYNO_PATTERNDB_FILE__/${PATTERN_DB_FILE}/" \
		>> ${SYSLOGNG_CONFIG_CUSTRULE}
}

CustRuleLogProcess() {
	local RULE_NAME=$1

	echo "log { source(s_syno_net_${RULE_NAME}); source(s_syno_net_${RULE_NAME}_6); parser(p_parser_${RULE_NAME}); destination(d_syno_arch_db); flags(flow_control); };" \
	>> ${SYSLOGNG_CONFIG_CUSTRULE}
	echo "log { source(s_syno_net_${RULE_NAME}); source(s_syno_net_${RULE_NAME}_6); parser(p_parser_${RULE_NAME}); destination(d_syno_db); flags(flow_control); };" \
	>> ${SYSLOGNG_CONFIG_CUSTRULE}
	echo "log { source(s_syno_net_${RULE_NAME}); source(s_syno_net_${RULE_NAME}_6); parser(p_parser_${RULE_NAME}); destination(d_syno_dest_recv); flags(flow_control); };" \
	>> ${SYSLOGNG_CONFIG_CUSTRULE}
}

