/* Copyright (c) 2015 Synology Inc. All rights reserved. */

Ext.define("SYNO.SDS.AudioPlayer.Resizeable",{extend:"Ext.Resizable",snapHeight:function(){},onMouseMove:function(d){if(this.enabled&&this.activeHandle){try{if(this.resizeRegion&&!this.resizeRegion.contains(d.getPoint())){return}var a=this.curSize||this.startBox,l=this.startBox.x,j=this.startBox.y,m=a.width,c=a.height,n=this.minHeight,k=this.maxHeight,b=d.getXY(),i=-(this.startPoint[1]-Math.max(this.minY,b[1])),g=this.activeHandle.position;switch(g){case"south":c+=i;c=Math.min(Math.max(n,c),k);break;case"north":i=this.constrain(c,i,n,k);j+=i;c-=i;break}this.proxy.setBounds(l,j,m,c);if(this.dynamic){this.resizeElement()}}catch(f){SYNO.Debug("error: "+f)}}}});Ext.namespace("SYNO.SDS.AudioPlayer");SYNO.SDS.AudioPlayer.ErrorCode={401:_T("error","error_no_path"),402:_T("error","error_system"),403:_T("audio_player","err_exceed_maximum_file_num")};Ext.define("SYNO.SDS.AudioPlayer.UndoPanel",{extend:"Ext.Container",constructor:function(a){if(!a.owner){SYNO.Debug("owner required")}this.undoBox=new Ext.Component({cls:"undo-btn",html:_T("audio_player","add_undo")});this.closeBox=new Ext.Component({cls:"close-btn-wrap",html:'<div class="close-btn"></div>'});var b={cls:"sds-audioplayer-mini-player-undo-panel",items:[{cls:"undo-text",itemId:"contentText",xtype:"box",html:""},this.undoBox,this.closeBox],renderTo:a.owner.id,listeners:{afterlayout:{fn:this.bindEvents,scope:this,single:true},beforedestroy:{fn:this.unbindEvents,scope:this}}};Ext.apply(b,a);this.callParent([b])},updateText:function(b){var a=this.getComponent("contentText");a.el.update(b)},bindEvents:function(){this.closeBox.el.on("click",this.owner.hideUndoPanel,this.owner);this.undoBox.el.on("click",this.owner.removeAddedRecs,this.owner)},unbindEvents:function(){this.closeBox.el.un("click",this.owner.hideUndoPanel,this.owner);this.undoBox.el.un("click",this.owner.removeAddedRecs,this.owner)}});Ext.define("SYNO.SDS.AudioPlayer.PlaylistPanel",{extend:"SYNO.ux.GridPanel",constructor:function(a){this.player=a.player;var b=this.fillConfig(a);this.callParent([b]);this.mon(this.store,"add",this.onAddRecs,this);this.mon(this.store,"update",this.updatePlayingCls,this,{buffer:50});this.mon(this,"beforedestroy",this.clearTasks,this)},fillConfig:function(a){var b={cls:"sds-audioplayer-mini-player-playlist without-dirty-red-grid",colModel:this.initColModel(),loadMask:true,store:this.initStore(),enableHdMenu:false,hideHeaders:true,enableDragDrop:true,autoExpandColumn:"filename",ddGroup:"SDSAudioGroup",view:new SYNO.ux.FleXcroll.grid.BufferView({cacheSize:30,forceFit:true,trackResetOnLoad:false,onLayout:function(d,f){var c=this,e=c.scroller.dom;if(!c.autoFlexcroll){return}if(e.clientWidth===e.offsetWidth){c.scrollOffset=0}else{c.scrollOffset=undefined}this.fitColumns(false);c.updateScrollbar(e)}}),listeners:{rowdblclick:this.onFileDblClick,rowcontextmenu:this.onFileContextMenu,afterrender:this.onPlayListRendered,scope:this}};return Ext.apply(b,a)},updatePlayingCls:function(){var a=this.player,b=a.curIndex,c;if(!Ext.isEmpty(b)){c=Ext.fly(this.getView().getRow(b));if(c){c.addClass("playing")}}},durationRenderer:function(e,a,d,c,f,b){if(d.get("error")===true){return"--:--"}return SYNO.SDS.AudioPlayer.Utils.timeRenderer(e,a,d,c,f,b)},filenameRenderer:function(f,a,e,d,g,b){var c=Ext.util.Format.htmlEncode(f);a.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c},initColModel:function(){return new Ext.grid.ColumnModel({columns:[{id:"filename",header:false,width:300,renderer:this.filenameRenderer.createDelegate(this)},{id:"duration",width:60,header:false,renderer:this.durationRenderer.createDelegate(this),align:"right"}]})},updateRecDuration:function(a,b){this.store.getAt(a).set("duration",b)},initStore:function(){return new Ext.data.JsonStore({fields:["filename","duration","filepath","error"],data:[],idProperty:"filepath",muteOnInsert:true,insert:function(d,c){var e,a,b;c=[].concat(c);for(e=0,a=c.length;e<a;e++){b=c[e];this.data.insert(d+e,b);b.join(this);if(b.dirty||b.phantom){this.modified.push(b)}}if(this.snapshot){this.snapshot.addAll(c)}this.fireEvent("add",this,c,d,this.muteOnInsert)},listeners:{load:this.onStoreLoad,scope:this}})},scrollToIdx:function(c,b){var f=27,a,h,d,g=c.getVisibleRows().fisrt,e=Math.min(g+c.getVisibleRowCount(),this.getStore().getCount()-1);if(b>g&&b<e){return}a=this.getHeight()/2;h=parseInt(a/f,10);d=Math.max(0,b-h);c.fleXcrollTo(c.getRow(d))},onAddRecs:function(c,e,a,d){this.hideUndoPanel();var b=this.getView();if(c.getCount()===e.length||d){return}if(this.lastAddRecs){this.lastAddRecs=null}this.scrollToIdx.defer(10,this,[b,a]);this.lastAddRecs=e;this.changeClsForAddedRecs.defer(10,this,[true,a]);this.setUndoPanelVisible(true,String.format(_T("audio_player","number_files_added"),e.length));this.removeClsTaskID=this.changeClsForAddedRecs.defer(5000,this,[false,a]);this.hideUndoTaskID=this.setUndoPanelVisible.defer(5000,this,[false])},clearTasks:function(){if(this.removeClsTaskID){window.clearTimeout(this.removeClsTaskID);this.removeClsTaskID=null}if(this.hideUndoTaskID){window.clearTimeout(this.hideUndoTaskID);this.hideUndoTaskID=null}},hideUndoPanel:function(){this.clearTasks();if(!this.lastAddRecs){return}var a=this.store.indexOf(this.lastAddRecs[0]);this.changeClsForAddedRecs(false,a);this.setUndoPanelVisible(false);this.lastAddRecs=null},removeAddedRecs:function(){var a=this.store;this.clearTasks();this.setUndoPanelVisible(false);if(!this.lastAddRecs){return}Ext.each(this.lastAddRecs,function(c){var b=a.indexOf(c);Ext.fly(this.getView().getRow(b)).addClass("remove-files");a.remove.defer(600,a,[c])},this);this.lastAddRecs=null},onStoreLoad:function(a,c,b){this.player.errorFiles=[];Ext.each(c,function(f){if(f.get("error")===true){var d=a.indexOf(f),e=f.get("filepath");Ext.fly(this.getView().getRow(d)).addClass("playing-error");if(this.player.errorFiles.indexOf(e)===-1){this.player.errorFiles.push(e)}}},this);this.getSelectionModel().clearSelections(true)},changeClsForAddedRecs:function(e,a){var h=(e)?"addClass":"removeClass",c=this.store,b=this.getView(),f=c.getCount(),d,g;for(d=a;d<f;d++){g=b.getRow(d);if(g){Ext.fly(g)[h]("added-recs")}}},setUndoPanelVisible:function(a,b){var c=(a)?"addClass":"removeClass";if(!this.undoPanel){this.undoPanel=new SYNO.SDS.AudioPlayer.UndoPanel({owner:this})}if(b){this.undoPanel.updateText(b)}this.undoPanel[c]("cornerin")},loadFiles:function(e,c){var b,d=[],a=this.store;for(b=0;b<e.length;b++){var f=e[b];d.push({filename:f.filename,duration:(Ext.isNumber(f.duration))?f.duration:0,filepath:f.filepath,error:!!(f.error)})}a.loadData(d,c)},onFileDblClick:function(a,b,c){var d=a.getStore().getAt(b);if(d){this.player.jumpToIndex(b)}},onFileContextMenu:function(a,c,j){j.preventDefault();var f=a.getSelectionModel(),h;if(!f.isSelected(c)){f.selectRow(c)}h=f.getSelections();var d=this.getContextMenu(),g=h.length!==1,i=(c===0)||(h.length>1),b=(c===this.store.getCount()-1)||(h.length>1);d.getComponent("play").setDisabled(g);d.getComponent("moveup").setDisabled(i);d.getComponent("movedown").setDisabled(b);d.showAt(j.getXY())},onPlayListRendered:function(){var a=this.player,b=this;this.el.dropZone=new Ext.dd.DropZone(this.getView().el,{ddGroup:"SDSAudioGroup",getTargetFromEvent:function(d){var c=d.getTarget(b.getView().rowSelector),f=b.view.findRowIndex(c);return{target:d.getTarget(b.getView().rowSelector),rowIndex:f}},onNodeEnter:function(h,c,f,d){var g=Ext.fly(h.target);if(g){g.addClass("x-grid3-row-selected")}},onNodeOut:function(h,c,f,d){var g=Ext.fly(h.target);if(g){g.removeClass("x-grid3-row-selected")}},onNodeOver:function(g,c,f,d){if(!g.target||!g.rowIndex){return"x-dd-drop-nodrop"}return"x-dd-drop-ok-add"},onNodeDrop:function(h,c,g,f){if(!h.target||!h.rowIndex){return false}var d=h.rowIndex;a.moveFiles.apply(a,[f.selections,d])}});this.mon(this.player,"updateduration",this.updateRecDuration,this)},onPlayFile:function(){var b=this.getStore(),a=this.getSelectionModel().getSelections();if(a.length!==1){return}this.player.jumpToIndex(b.indexOf(a[0]))},getContextMenu:function(){if(!this.contextMenu){var b=this,a=b.player;this.contextMenu=new SYNO.ux.Menu({items:[{itemId:"play",text:_T("audio_player","menu_play"),handler:b.onPlayFile.createDelegate(b)},{itemId:"remove",text:_T("common","remove"),handler:a.removeFiles.createDelegate(a)},"-",{itemId:"moveup",text:_T("audio_player","menu_moveup"),handler:a.moveFileUp.createDelegate(a)},{itemId:"movedown",text:_T("audio_player","menu_movedown"),handler:a.moveFileDown.createDelegate(a)}]})}return this.contextMenu}});Ext.namespace("SYNO.SDS.AudioPlayer");Ext.define("SYNO.SDS.AudioPlayer.SoundPlayer",{extend:"Ext.util.Observable",moduleID:"sds_audio_player",_shiftedPosition:0,TRANSCODE_TYPE_LIST:["mp3","m4a","m4b","aac","ogg","wav","flac","ape","aiff","aif","wma"],constructor:function(a){Ext.apply(this,a);this.initSoundManager(a);SYNO.SDS.AudioPlayer.SoundPlayer.superclass.constructor.call(this,a)},initSoundManager:function(a){if(window.SDSsoundManager){this.soundManager=window.SDSsoundManager;this.isReady=true;return}this.soundManager=new SDSSoundManager();window.SDSsoundManager=this.soundManager;this.soundManager.setup({url:this.baseURL+"/flash/",debugMode:false,debugFlash:false,waitForWindowLoad:true,useHighPerformance:false,flashVersion:9,flashLoadTimeout:30000,preferFlash:true,useHTML5Audio:true,onready:function(b){this.SDSsoundManager.owner.isReady=true;this.SDSsoundManager.owner.fireEvent("onready")},ontimeout:function(b){this.SDSsoundManager.owner.fireEvent("ontimeout")}});this.soundManager.owner=this;this.soundManager.beginDelayedInit()},createSound:function(e,a,d){var c=SYNO.SDS.UserSettings.getProperty("AudioPlayer","volume");if(c===null){c=50}var b=this.soundManager.createSound({id:this.moduleID,url:e,volume:c,bufferTime:3,onfinish:function(){this.owner.fireEvent("onfinish")},onload:function(g){if(2===this.readyState){this.owner.fireEvent("onerror");return}if(this.owner.isURLinput||!this.owner.getDuration()){var f=Math.round(this.durationEstimate/1000);this.owner.setDuration(f)}},onpause:function(){},onplay:function(){},whileplaying:function(){var g=this.owner.getPosition();if(g===this.lastPos){return}var f=g/this.owner._soundLen;this.owner.fireEvent("whileplaying",f);this.lastPos=g}});b.owner=this;if(d){this.getMediaInfo(d)}this._isTranscoding=(-1!==e.indexOf("method=transcode"))?true:false;return b},getMediaInfo:function(a){if(this._shiftedPosition!==0||this.isURLinput){return}SYNO.API.currentManager.requestAPI("SYNO.AudioPlayer.Stream","get_media_info","1",{path:a},this.onGetMediaInfoDone,this)},onGetMediaInfoDone:function(d,b,c,a){if(d&&b){this.setDuration(b.duration)}else{if(!d){this.fireEvent("onerror")}}},play:function(d,c){var a=0;if(this.isPlaying){return this.togglePause()}var b=this.createSound(d,a,c);if(b){this.soundManager.play(this.moduleID);this.isPlaying=true;this.soundObj=b;return b.paused}else{this.fireEvent("onerror")}},stop:function(){this.soundManager.stop(this.moduleID);this.soundManager.setPosition(this.moduleID,0);this.isPlaying=false},seek:function(a,b){if(this._isTranscoding){this._shiftedPosition=a;this.destroy();this.play(b)}else{this.setPosition(a)}},destroy:function(){this.stop();this.soundManager.destroySound(this.moduleID)},reset:function(){this._shiftedPosition=0;this.destroy()},togglePause:function(){var a=this.soundManager.togglePause(this.moduleID);return a.paused},toggleMute:function(){var a=this.soundManager.toggleMute(this.moduleID);return a.muted},setVolume:function(a){this.soundManager.setVolume(this.moduleID,a)},setDuration:function(a){this._soundLen=a;this.fireEvent("updateDuration",this._soundLen)},getCurrentSount:function(){return this.soundObj},getVolume:function(){var a=SYNO.SDS.UserSettings.getProperty("AudioPlayer","volume")||50;return(this.soundObj)?this.soundObj.volume:a},getDuration:function(){return this._soundLen},getPosition:function(){var b=(this.soundObj)?this.soundObj.position:0,a=Math.floor(b/1000);if(this._isTranscoding){a+=this._shiftedPosition}return a},getProgress:function(){var a=this.getPosition()/this._soundLen;return a},setPosition:function(a){this.soundManager.setPosition(this.moduleID,Math.round(a*1000))},canPlay:function(a){var b,c;b=this.soundManager.canPlayURL(a);c=a.substring(a.lastIndexOf(".")+1);if(c.toLowerCase()==="m4a"){b=false}return b},canTranscode:function(a){var c,b;c=a.substring(a.lastIndexOf(".")+1);if(-1==this.TRANSCODE_TYPE_LIST.indexOf(c.toLowerCase())){b=false}else{if((Ext.isIE||Ext.isIE11)&&!this.canTranscodeMP3){b=false}else{b=true}}return b},getTranscodeFormat:function(a){var b="mp3";if(!this.canTranscodeMP3){b=(Ext.isIE||Ext.isIE11)?null:"wav"}return b},supported:function(){return this.soundManager.supported()},flashLoaded:function(){return this.soundManager.swfLoaded}});Ext.namespace("SYNO.SDS.AudioPlayer");SYNO.SDS.AudioPlayer.Slider=Ext.extend(Ext.slider.SingleSlider,{constructor:function(a){SYNO.SDS.AudioPlayer.Slider.superclass.constructor.apply(this,arguments)},isDragging:function(){if(!this.thumbs||this.thumbs.length<1){return false}return this.thumbs[0].dragging},promoteThumb:function(a){}});SYNO.SDS.AudioPlayer.PositionSlider=Ext.extend(SYNO.SDS.AudioPlayer.Slider,{positionMax:10000,constructor:function(a){var b;b={cls:"sds-audioplayer-slider sds-audioplayer-position-slider",width:360,minValue:0,maxValue:this.positionMax,scope:this,listeners:{change:this.onPositionChange,afterrender:this.onPositionSliderRender}};Ext.apply(b,a);SYNO.SDS.AudioPlayer.PositionSlider.superclass.constructor.call(this,b)},getProgress:function(){var a=this.getValue()/this.positionMax;return a},setProgress:function(a){if(this.isDragging()){return}this.setValue(a*this.positionMax)},onPositionChange:function(e,f,b){var c=e.getEl().child(".sds-audioplayer-slider-progress"),a=e.getEl().child(".x-slider-inner").getWidth(),d=0;if(0!==f){d=((f*a/this.positionMax)+3)}c.dom.style.width=d+"px"},onPositionSliderRender:function(c){var b=c.getEl().child(".x-slider-inner");var a=c.getEl().child(".x-slider-thumb");b.createChild({tag:"div",cls:"sds-audioplayer-slider-progress"},a);b.createChild({tag:"div",cls:"sds-audioplayer-slider-bg"},a);c.halfThumb=15;a.dom.style.left="-15px"},setPositionSlideThumbVisible:function(b){var a=this.getEl().child(".x-slider-thumb");if(!a){return}if(b){a.addClass("sds-audioplayer-slider-thumb-visible")}else{a.removeClass("sds-audioplayer-slider-thumb-visible")}}});SYNO.SDS.AudioPlayer.VolumeSlider=Ext.extend(SYNO.SDS.AudioPlayer.Slider,{constructor:function(a){var b;b={cls:"sds-audioplayer-slider sds-audioplayer-volume-slider",minValue:0,maxValue:100,scope:this,listeners:{change:this.onVolumeChange,afterrender:this.onVolumeSliderRender}};Ext.apply(b,a);SYNO.SDS.AudioPlayer.VolumeSlider.superclass.constructor.call(this,b)},onVolumeChange:function(e,f,b){var c=e.getEl().child(".sds-audioplayer-slider-progress"),a=e.getEl().child(".x-slider-inner").getWidth(),d=0;if(0!==f){d=((f*a/100)+1)}c.dom.style.width=d+"px"},onVolumeSliderRender:function(c){var b=c.getEl().child(".x-slider-inner");var a=c.getEl().child(".x-slider-thumb");b.createChild({tag:"div",cls:"sds-audioplayer-slider-progress"},a);b.createChild({tag:"div",cls:"sds-audioplayer-slider-bg"},a);c.halfThumb=6}});Ext.define("SYNO.SDS.AudioPlayer.MiniVolumeSlider",{extend:"SYNO.SDS.AudioPlayer.VolumeSlider",constructor:function(a){var b={cls:"sds-audioplayer-mini-volume-slider",vertical:true};Ext.apply(b,a);this.callParent([b])},onVolumeSliderRender:function(){this.volumeBg=Ext.DomHelper.insertBefore(this.thumbs[0].el,{tag:"div",cls:"sds-audioplayer-slider-bg"},true);this.volumeStrip=Ext.DomHelper.insertBefore(this.thumbs[0].el,{tag:"div",cls:"sds-audioplayer-slider-progress"},true);var a=this.valueToHeight(this.value);this.volumeStrip.setHeight(a);this.halfThumb=7},valueToHeight:function(b){var a=0;if(0!==b){a=((b*82/100)-2)}return a},onVolumeChange:function(c,d,b){var a=this.valueToHeight(d);this.volumeStrip.setHeight(a)}});Ext.namespace("SYNO.SDS.AudioPlayer");Ext.define("SYNO.SDS.AudioPlayer.MiniPlayer",{extend:"SYNO.SDS.AppWindow",miniPlayerPanel:undefined,btnPlay:undefined,volumeSlider:undefined,positionSlider:undefined,playerNormalHeight:117,RepeatMode:{REPEAT_NONE:0,REPEAT_ALL:1,REPEAT_ONE:2},currentRepeatMode:0,errorCount:0,defaultListHeight:300,maxFileNum:1024,maxListHeight:580,minListHeight:84,playerSliderPadding:5,initEvents:function(){var c=this,d=this.infoPanel.getHeight()+this.playListToggle.getHeight()+this.playerSliderPadding,b=d+this.minListHeight,a=d+this.maxListHeight;c.callParent(arguments);if(c.resizable){if(c.resizer){c.resizer.destroy()}c.resizer=new SYNO.SDS.AudioPlayer.Resizeable(c.el,{minWidth:c.width,maxWidth:c.width,minHeight:b,maxHeight:a,handles:c.resizeHandles||"all",resizeElement:c.resizerAction,handleCls:"x-window-handle"});c.resizer.window=c;c.resizer.minHeight=b;c.mon(c.resizer,"beforeresize",c.beforeResize,c)}},constructor:function(c){var a=360;this.player=new SYNO.SDS.AudioPlayer.SoundPlayer({baseURL:this.jsConfig.jsBaseURL});this.miniPlayerPanel=this.initMiniPlayerPanel();this.errorFiles=[];var b={cls:"sds-audioplayer-mini-player-window",maximizable:false,pinable:false,width:a,height:this.playerNormalHeight,layout:"fit",resizable:true,resizeHandles:"n s",fbar:[],items:[this.miniPlayerPanel],listeners:{afterrender:this.initDropZone,scope:this}};Ext.apply(this,c);SYNO.SDS.AudioPlayer.MiniPlayer.superclass.constructor.call(this,b);this.addEvents("updateduration");this.mon(this,"resize",this.onPlaylistResize,this)},overwriteAppWinConfig:function(a){if(_S("standalone")){a.modal=false;a.draggable=true}return a},isAlwaysOnTop:function(){return _S("standalone")},isSkipActive:function(){return _S("standalone")},getMsgBox:function(){if(!this.msgBox||this.msgBox.isDestroyed){this.msgBox=new SYNO.SDS.MessageBoxV5({owner:this,cls:_S("standalone")?"audio-standalone-msg":""})}return this.msgBox.getWrapper()},parseInputData:function(a){if(a&&a.fb_recs){if(a.fb_param==="add"){this.addFileToList(a.fb_recs)}else{this.listLoaded=false;this.parseFileStationRec(a.fb_recs)}}else{if(a&&a.url_recs){this.parseInputURL(a.url_recs)}else{this.getMsgBox().alert(_T("audio_player","title"),"No sound to play")}}},onOpen:function(a){this.parseInputData(a);this.resetPlayer();this.callParent()},beforeResize:function(){if(!this.resizable){return}var a=this.infoPanel.getHeight()+this.playListToggle.getHeight()+this.playerSliderPadding;if(this.playListPanel.isVisible()){this.resizer.minHeight=Math.max((a+this.minListHeight),this.getFrameHeight()+40)}this.resizer.minWidth=Math.max(this.minWidth,this.getFrameWidth()+40);this.resizeBox=this.el.getBox()},onPlaylistResize:function(d,b,a){if(!this.playListPanel.isVisible()){return}var c,e;c=Math.min(a,this.playerNormalHeight+this.maxListHeight);c=Math.max(a,this.playerNormalHeight+this.minListHeight);this.setHeight(c);e=c-(this.infoPanel.getHeight()+this.playListToggle.getHeight()+this.playerSliderPadding);this.playListPanel.setHeight(e);this.customPlayListHeight=e},updatePlayerHeight:function(){var a=this.infoPanel.getHeight()+this.playListToggle.getHeight()+this.playerSliderPadding+this.playListPanel.getHeight();this.setHeight(a)},isPanelMasked:function(){return this.infoPanel.el.isMasked()||this.playListPanel.el.isMasked()},maskPanels:function(){this.infoPanel.el.mask();this.playListPanel.el.mask(_T("common","loading"),"x-mask-loading")},unmaskPanels:function(){this.infoPanel.el.unmask();this.playListPanel.el.unmask()},parseFileStationRec:function(a){var b=[];this.mode="new";a.each(function(c){b.push({path:c.get("file_id"),type:(c.get("isdir")===true)?"dir":"file",name:c.get("filename")})});this.maskPanels();SYNO.API.currentManager.requestAPI("SYNO.AudioPlayer.Stream","list_media_info","1",{recs:Ext.util.JSON.encode({info:b})},this.onGetMediaInfoDone,this);this.player.isURLinput=false;this.setPlayListMode(true)},onGetMediaInfoDone:function(f,b,d,a){var e,c=!!this.btnPlay;if(f&&b&&b.recs){this.setPlayListMode(true);this.playListPanel.loadFiles(b.recs,this.mode==="add");if(c){this.btnPlay.removeClass("disable")}if(!this.listLoaded){this.listLoaded=true;this.onStart()}}if(f&&b&&b.error){e=SYNO.SDS.AudioPlayer.ErrorCode[b.error.code]||_T("error","error_error_system");this.getMsgBox().alert(_T("audio_player","title"),e)}if(!f){e=_T("error","error_error_system");this.getMsgBox().alert(_T("audio_player","title"),e)}this.unmaskPanels()},setPlayListMode:function(b){var c=(b)?"addClass":"removeClass",d=(b)?"show":"hide",a=(b)?this.infoPanel.getHeight()+this.playListPanel.getHeight()+this.playListToggle.getHeight()+this.playerSliderPadding:this.playerNormalHeight;this.playListPanel[d]();this.playListToggle[d]();this.setHeight(a);this.playListToggle[c]("expanded")},parseInputURL:function(a){var b=[];a.each(function(c){b.push({filename:c.title||"",filepath:c.url,duration:0,error:false})});this.playListPanel.loadFiles(b,false);this.setPlayListMode(false);this.player.isURLinput=true;this.onStart()},onRequest:function(a){if(this.isPanelMasked()){return}this.toFront();if(a.fb_param!=="add"){this.resetPlayer();this.player.reset()}this.parseInputData(a)},resetPlayer:function(){var a=this.playListPanel.getView().getRow(this.curIndex);if(a){Ext.fly(a).removeClass("playing")}this.curIndex=0;this.errorCount=0;this.resetPlayerUI();if(this.player){this.player.reset()}},resetPlayerUI:function(){var a=(this.btnPlay)?true:false;if(a){this.btnPlay.removeClass("disable");this.setBtnToPause(false);this.durationEl.update("--:--");this.currentPosEl.update("--:--");this.setPlayerTitle("");this.positionSlider.setProgress(0)}},setPlayerTitle:function(a){a=Ext.util.Format.htmlEncode(a);this.titleEl.update(a);this.titleEl.dom.setAttribute("ext:qtip",a);this.updateMarquee()},updateDuration:function(a){var b=SYNO.SDS.AudioPlayer.Utils.timeRenderer(a);this.durationEl.update(b);this.fireEvent("updateduration",this.curIndex,a)},updatePosition:function(){var a=this.player.getPosition();var b=this.player.getDuration();if(a===this.currentPos){return}var c=SYNO.SDS.AudioPlayer.Utils.timeRenderer(a,b);if(this.currentPosEl&&this.player.getCurrentSount()){this.currentPosEl.update(c)}this.currentPos=a},initDraggable:function(){this.dd=new SYNO.SDS.AudioPlayer.WindowDD(this,this.allowDragDivId)},initDropZone:function(){this.dropZone=new Ext.dd.DropZone(this.body,{ddGroup:"SDSShortCut",onContainerDrop:this.onContainerDrop.createDelegate(this,[],true),onContainerOver:this.onContainerOver.createDelegate(this)})},checkFiles:function(a){if(this.player.isURLinput===true){return false}if(a.length+this.playListPanel.store.getCount()>this.maxFileNum){return false}var c,b=this.appInstance.jsConfig.fb_extern[0].file;for(c=0;c<a.length;c++){var d=a[c].get("type").toLowerCase();if(b.indexOf(d)===-1&&a[c].get("isdir")!==true){return false}}return true},addFileToList:function(b){var a=this.getPlayListStore(),c=[];this.mode="add";a.each(function(d){c.push({path:d.get("filepath"),type:"file",name:d.get("filename"),duration:(d.get("error")!==true)?d.get("duration"):0})});Ext.each(b,function(e){var d=e.get("file_id");if(!a.getById(d)){c.push({path:e.get("file_id"),type:(e.get("isdir")===true)?"dir":"file",name:e.get("filename")})}},this);this.maskPanels();SYNO.API.currentManager.requestAPI("SYNO.AudioPlayer.Stream","list_media_info","1",{recs:Ext.util.JSON.encode({info:c})},this.onGetMediaInfoDone,this)},onContainerDrop:function(b,d,c){var a=c.selections;if(this.isPanelMasked()||!a||!Ext.isArray(a)||!this.checkFiles(a)){return}this.addFileToList(a)},onContainerOver:function(d,c,b){this.toFront();var a=b.selections;if(this.isPanelMasked()){d.getProxy().getGhost().update(_T("audio_player","err_no_add"));return"x-dd-drop-nodrop"}else{if(this.checkFiles(a)){d.getProxy().getGhost().update(_T("audio_player","add_file"));return"x-dd-drop-ok-add"}else{d.getProxy().getGhost().update(_T("audio_player","err_no_add"));return"x-dd-drop-nodrop"}}},onDestroy:function(){var a=this.dropZone,b=this.playListPanel.el.dropZone;a.removeFromGroup(a.ddGroup);b.removeFromGroup(b.ddGroup)},initPlayListPanel:function(){return new SYNO.SDS.AudioPlayer.PlaylistPanel({player:this,height:this.defaultListHeight})},initMiniPlayerPanel:function(){this.allowDragDivId=Ext.id();var b=['<div id="sds_audioplayer_mini_control_div" class="sds-audioplayer-mini-control-div">','<div id="{0}" class="mini-drag-area">','<div class="mini-thumb-div">','<img class="player-info-thumb" src="{1}" qtip="">',"</div>",'<div class="mini-info-div">','<div class="mini-title"></div>',"</div>",'<div class="mini-duration">','<span class="info-position">--:--</span>&nbsp;/&nbsp;','<span class="info-duration">--:--</span>',"</div>",'<div class="mini-control-btns">','<div class="mini-btn mini-volume"><span class="webfont-audio-volume"></span></div>','<div class="mini-btn mini-prev"><span class="webfont-audio-prev"></span></div>','<div class="mini-btn mini-play"><span class="webfont-audio-play"></span></div>','<div class="mini-btn mini-next"><span class="webfont-audio-next"></span></div>','<div class="mini-btn mini-stop"><span class="webfont-audio-stop"></span></div>',"</div>",'<div class="mini-btn mini-display-mode"></div>','<div class="mini-win-btn min" ><span class="webfont-icon-min-window"></span></div>','<div class="mini-win-btn close"><span class="webfont-icon-close-window"></span></div>','<div class="mini-win-btn repeat"><span class="webfont-audio-repeat-all"></span></div>',"</div>",'<div class="mini-position-wrapper">','<div class="mini-position-progress-padding"></div>','<div class="mini_position_div"></div>',"</div>","</div>"].join("");b=String.format(b,this.allowDragDivId,Ext.BLANK_IMAGE_URL);this.infoPanel=new SYNO.ux.Panel({html:b,cls:"sds-audioplayer-mini-info-panel",border:false,height:98,bodyCssClass:"sds-audioplayer-mini-panel-body"});this.playListToggle=new Ext.BoxComponent({height:16,width:360,cls:"mini-playlist-toggle expanded",html:'<div class="mini-playlist-toggle-btn"></div>'});this.playListPanel=this.initPlayListPanel();var a=new SYNO.ux.Panel({border:false,bodyCssClass:"sds-audioplayer-mini-panel-body",items:[this.infoPanel,this.playListPanel,this.playListToggle],listeners:{buffer:100,afterrender:this.onPanelAfterRender.createDelegate(this)}});this.positionSlider=new SYNO.SDS.AudioPlayer.PositionSlider({width:360,clickRange:[0,16]});return a},onPanelAfterRender:function(){if(Ext.isIE8){Ext.getBody().focus()}this.titleEl=this.getPlayerControlElement("mini-title");this.currentPosEl=this.getInfoElement("info-position");this.durationEl=this.getInfoElement("info-duration");this.mon(this.player,"updateDuration",this.updateDuration,this);this.mon(this.player,"onfinish",this.onNext,this);this.mon(this.player,"onerror",this.onError,this);this.positionSlider.render(this.getPlayerControlElement("mini_position_div"));this.positionSlider.mon(this.player,"whileplaying",this.onUpdateProgress,this);this.positionSlider.on("changecomplete",this.onSeek,this);this.btnPlay=this.bindControlBtnFn("webfont-audio-play",this.onPlay);this.btnStop=this.bindControlBtnFn("webfont-audio-stop",this.onStop);this.btnPrev=this.bindControlBtnFn("webfont-audio-prev",this.onPrev);this.btnNext=this.bindControlBtnFn("webfont-audio-next",this.onNext);this.volumeBtn=this.bindControlBtnFn("webfont-audio-volume",this.onMute);this.btnMinimize=this.bindControlBtnFn("webfont-icon-min-window",this.minimize);this.btnClose=this.bindControlBtnFn("webfont-icon-close-window",this.onCloseWindow);this.btnRepeat=this.bindControlBtnFn("webfont-audio-repeat-all",this.onRepeat);this.createVolumeSliderMenu(this.volumeBtn);if(_S("standalone")){this.btnMinimize.hide()}this.playListToggle.el.on("click",this.onTogglePlayList,this);this.mon(this.player,"onready",this.onStart,this);this.mon(this.player,"ontimeout",this.onLoadError,this);this.mon(this.playListPanel,"hide",this.setReizerDisabled.createDelegate(this,[true]),this);this.mon(this.playListPanel,"show",this.setReizerDisabled.createDelegate(this,[false]),this);SYNO.API.currentManager.requestAPI("SYNO.AudioPlayer.Stream","getinfo","1",{},this.onGetInfoDone,this)},setReizerDisabled:function(a){if(!this.resizable){return}this.resizer.enabled=!a;this[(a)?"addClass":"removeClass"]("window-unresizeable")},getMarqueeCSS:function(){if(!this.marqueeCSS){this.marqueeCSS=document.createElement("style");this.marqueeCSS.type="text/css";document.getElementsByTagName("head")[0].appendChild(this.marqueeCSS)}return this.marqueeCSS},updateMarquee:function(){var e=this.getMarqueeCSS();var c=this.titleEl.getWidth();var j=this.titleEl.parent().getWidth();var g=j-c;if(e.firstChild){e.removeChild(e.firstChild)}if(g>=0){this.titleEl.removeClass("marquee");return}this.titleEl.addClass("marquee");var d="";if(Ext.isWebKit){d="-webkit-"}else{if(Ext.isGecko){d="-moz-"}}var h=10;var b=Math.round(-1*g/h+2);var k=String.format(".sds-audioplayer-mini-control-div .mini-info-div .marquee {{0}animation: audio-player-marquee {1}s linear infinite !important}",d,b);var i=Math.round((2/b)*100);var a=String.format("@{0}keyframes audio-player-marquee {0%, {2}%, 100% { left:0px;}50%, {3}% { left:{1}px;}} {4}",d,g,i,50+i,k);var f=document.createTextNode(a);e.appendChild(f);this.titleEl.repaint()},bindControlBtnFn:function(a,c){var b=this.getPlayerControlElement(a);b.on("click",c,this);return b},onTogglePlayList:function(){if(!this.playListPanel){return}if(this.playListPanel.isVisible()){this.playListPanel.hide();this.playListToggle.removeClass("expanded");this.updatePlayerHeight()}else{this.playListPanel.show();this.playListToggle.addClass("expanded");this.updatePlayerHeight()}},onCloseWindow:function(){this.close()},close:function(){this.player.destroy();this.callParent()},setBtnToPause:function(a){if(a){this.btnPlay.replaceClass("webfont-audio-play","webfont-audio-pause")}else{this.btnPlay.replaceClass("webfont-audio-pause","webfont-audio-play")}},getPlayListStore:function(){return this.playListPanel.getStore()},onPlay:function(){var f,b,g,a,d,e=this.getPlayListStore(),i,h,c;f=this.curIndex;d=e.getAt(f);b=(d)?this.getSoundURL(d.get("filepath")):null;a=this.playListPanel.getView();if(!Ext.isEmpty(this.lastIdx)){i=Ext.fly(a.getRow(this.lastIdx));if(i){i.removeClass("playing")}}if(!b){if(e.getCount()<=0){c=_T("audio_player","err_no_available_file");this.getMsgBox().alert(_T("audio_player","title"),c);this.resetPlayer();this.btnPlay.addClass("disable");this.listLoaded=false}else{if(e.getCount()>1){if((Ext.isIE||Ext.isModernIE)&&!this.player.canTranscodeMP3){this.onError()}else{this.onNext()}}else{c=_T("audio_player","err_format_not_support");if((Ext.isIE||Ext.isModernIE)&&!this.player.canTranscodeMP3){c=_T("audio_player","ie_not_support_wav")}this.getMsgBox().alert(_T("audio_player","title"),c);this.btnPlay.addClass("disable")}}return}d.set("error",false);h=a.getRow(f);if(h){Ext.fly(h).removeClass("playing-error");Ext.fly(h).addClass("playing")}this.setPlayerTitle(d.get("filename"));this.lastIdx=f;g=this.player.play(b,d.get("filepath"));this.setBtnToPause(!g)},onStop:function(){this.player.reset();this.onUpdateProgress(0);this.setBtnToPause(false)},onMute:function(){if(this.isMute){this.isMute=false;this.volumeSlider.setValue(this.lastVol)}else{this.isMute=true;this.lastVol=this.player.getVolume();this.volumeSlider.setValue(0)}},setBtnMute:function(a){this.volumeBtn[a?"addClass":"removeClass"]("webfont-audio-mute");this.volumeBtn[!a?"addClass":"removeClass"]("webfont-audio-volume")},onSeek:function(g,a){var f,e,d,b,c=this.getPlayListStore().getAt(this.curIndex);if(!c){return}f=this.player.getDuration();e=g.getValue()/g.positionMax;d=e*f;b=this.getSoundURL(c.get("filepath"),d);this.player.seek(d,b)},onPrev:function(){var b=(this.curIndex===0),a=this.getPlayListStore();if(this.isRepeatOne()){this.jumpToIndex(this.curIndex)}else{if(this.isRepeatAll()&&b){this.jumpToIndex(a.getCount()-1)}else{if(this.curIndex===0){this.onStop()}else{this.jumpToIndex(this.curIndex-1)}}}},onNext:function(){var a=this.getPlayListStore(),b=(this.curIndex==a.getCount()-1);if(b){this.errorCount=0}if(this.isRepeatOne()){this.jumpToIndex(this.curIndex)}else{if(this.isRepeatAll()&&b){this.jumpToIndex(0)}else{if(b){this.onStop()}else{this.jumpToIndex(this.curIndex+1)}}}},setCurIndex:function(a){this.curIndex=a;this.lastIdx=a},moveFiles:function(d,g){var b=this.playListPanel,j=b.getStore(),c,h,f=0,k=j.getAt(this.curIndex),a=k.get("filepath"),e;this.playListPanel.hideUndoPanel();for(e=0;e<d.length;e++){d[e].index=j.indexOf(d[e])}d.sort(function(l,i){return l.index-i.index});c=(d[0].index>g)?g:d[0].index;h=(d[d.length-1].index<g)?g:d[d.length-1].index;for(e=0;e<d.length;e++){if(d[e].index<g){f++}}if(g!==c){if(g===h){g=g-d.length+1}else{g=g-f+1}}for(e=0;e<d.length;e++){j.remove(d[e])}j.insert(g,d);this.setCurIndex(j.indexOfId(a));Ext.fly(this.playListPanel.getView().getRow(this.curIndex)).addClass("playing")},moveFile:function(e,b){var a=this.getPlayListStore(),c=a.getAt(this.curIndex).get("filepath"),d=a.getAt(e).copy();a.removeAt(e);a.insert(b,d);this.setCurIndex(a.indexOfId(c));Ext.fly(this.playListPanel.getView().getRow(this.curIndex)).addClass("playing")},getSelectedIdx:function(){var c=this.playListPanel,b=c.getSelectionModel(),a=b.getSelections();if(a.length!==1){return -1}else{return c.getStore().indexOf(a[0])}},moveFileUp:function(){var a=this.getSelectedIdx(),b=this.getPlayListStore();if(a<1||a>=b.getCount()){return}this.playListPanel.hideUndoPanel();this.moveFile(a,a-1)},moveFileDown:function(){var a=this.getSelectedIdx(),b=this.getPlayListStore();if(a<0||a>=b.getCount()-1){return}this.playListPanel.hideUndoPanel();this.moveFile(a,a+1)},removeFiles:function(){var c=this.playListPanel.getSelectionModel().getSelections();if(c.length<=0){return}var d=this.getPlayListStore(),f=d.getAt(this.curIndex).get("filepath"),b,h,a,e,g=false;this.playListPanel.hideUndoPanel();for(e=c.length-1;e>=0;e--){a=d.indexOf(c[e]);b=c[e].get("filepath");d.remove(c[e]);h=this.errorFiles.indexOf(b);if(h>=0){this.errorFiles.splice(h,1)}if(this.curIndex===a){g=true;this.player.reset();this.resetPlayerUI();this.setCurIndex(a%d.getCount());this.onStop()}}if(d.getCount()===0){this.close();return}if(!g){this.setCurIndex(d.indexOfId(f))}},jumpToIndex:function(a){var b=this.getPlayListStore();if(a<0){a=0}else{if(a>b.getCount()-1){a=b.getCount()-1}}this.player.reset();this.resetPlayerUI();this.curIndex=a;this.onPlay()},onError:function(){this.player.reset();var d=this.playListPanel,b=d.getView(),c=d.getStore(),a=this.curIndex,f=c.getAt(a),e=f.get("filepath");f.set("error",true);Ext.fly(b.getRow(a)).addClass("playing-error");if(this.errorFiles.indexOf(e)===-1){this.errorFiles.push(e)}if(this.errorFiles.length===c.getCount()){this.showPlayError()}else{this.onNext()}},showPlayError:function(){var b=_T("audio_player","err_error_count_exceed"),a=this.getPlayListStore();if(a.getCount()===1){b=String.format(_T("audio_player","err_failed_to_play"),a.getAt(0).get("filename"))}this.getMsgBox().alert(_T("audio_player","title"),b);this.setBtnToPause(false)},onChangeVolume:function(a,b){if(b>0){this.isMute=false}this.setBtnMute(this.isMute);this.player.setVolume(b);SYNO.SDS.UserSettings.setProperty("AudioPlayer","volume",b)},onRepeat:function(){this.currentRepeatMode=(this.currentRepeatMode+1)%3;var a=(this.isRepeatOne()||this.isRepeatAll());this.btnRepeat[a?"addClass":"removeClass"]("toggle");if(this.isRepeatOne()){this.btnRepeat.replaceClass("webfont-audio-repeat-all","webfont-audio-repeat-one")}else{this.btnRepeat.replaceClass("webfont-audio-repeat-one","webfont-audio-repeat-all")}},onUpdateProgress:function(a){this.updatePosition();this.positionSlider.setProgress(a)},canPlayURL:function(a){return this.player.canPlay(a)},getSoundURL:function(c,e){var b,a,d;a=this.player.canPlay(c);if(this.player.isURLinput){return a?c:null}d=this.player.canTranscode(c);c=encodeURIComponent(c);if(a){b=this.getDirectURL(c)}else{if(d){b=this.getTranscodeURL(c,e)}else{b=null}}return b},getTranscodeURL:function(b,d){var c=this.player.getTranscodeFormat(b);var a=this.composeURL({method:"transcode",format:c,path:b,position:d||0});return a},getDirectURL:function(b){var a=this.composeURL({method:"stream",path:b});return a},composeURL:function(d){var b,a;b=this.getFileExt(d.path);if(b.toLowerCase()===".m4a"||d.method==="transcode"){b="."+this.player.getTranscodeFormat()}a=this.getOrigin()+String.format("/webapi/AudioPlayer/stream.cgi/{0}?",b);var e={api:"SYNO.AudioPlayer.Stream",version:1};Ext.apply(d,e);if(_S("SynoToken")){d.SynoToken=_S("SynoToken")}var c=Object.keys(d);c.each(function(f){a+=f+"="+d[f]+"&"});a=a.substr(0,a.length-1);return a},getOrigin:function(){var a=window.location.origin;if(!a){a=window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:"")}return a},getFileExt:function(b){var a=b.lastIndexOf(".");return b.substr(a)},onLoadError:function(){var a=_T("audio_player","error_load_player");if(!this.player.flashLoaded()){a=_T("audio_player","error_no_flash")}this.getMsgBox().alert(_T("audio_player","title"),a)},onStart:function(){var a=(this.player.isURLinput)?true:this.listLoaded;if(this.player.isReady&&this.getInfoDone&&a){if(this.player.supported()){this.onPlay()}else{this.onLoadError()}}},onGetInfoDone:function(d,b,c,a){if(d&&b){this.player.canTranscodeMP3=b.canTranscodeMP3}else{this.player.canTranscodeMP3=false}this.getInfoDone=true;this.onStart()},getPlayerControlElement:function(a){return Ext.get("sds_audioplayer_mini_control_div").child("."+a)},getInfoElement:function(a){return Ext.get("sds_audioplayer_mini_control_div").child("."+a)},ghost:function(a){var b=a?a+" sds-audioplayer-miniplayer-ghost":"sds-audioplayer-miniplayer-ghost";var d=this.createGhost(b);var c=this.getBox(true);d.setLeftTop(c.x,c.y);d.setWidth(c.width);this.el.hide();this.activeGhost=d;return d},createVolumeSliderMenu:function(){var a=SYNO.SDS.UserSettings.getProperty("AudioPlayer","volume");if(a===null){a=50}this.volumeSlider=new SYNO.SDS.AudioPlayer.MiniVolumeSlider({height:86,value:a});this.volumePanel=new SYNO.ux.Panel({cls:"sds-audioplayer-volume-panel",items:[this.volumeSlider]});this.volumeMenu=new SYNO.ux.Menu({cls:"sds-audioplayer-volume-menu",defaultOffsets:[0,-8],items:[this.volumePanel],listeners:{scope:this,beforeshow:function(){}}});this.volumeBtn.on("mouseover",function(){this.volumeMenu.show(this.volumeBtn.id,"b-t")},this);this.volumeSlider.on("change",this.onChangeVolume,this)},isRepeatOne:function(){return(this.currentRepeatMode===this.RepeatMode.REPEAT_ONE)},isRepeatAll:function(){return(this.currentRepeatMode===this.RepeatMode.REPEAT_ALL)}});Ext.define("SYNO.SDS.AudioPlayer.WindowDD",{extend:"Ext.Window.DD",constructor:function(b,a){this.win=b;Ext.Window.DD.superclass.constructor.call(this,b.el.id,"WindowDD-"+b.id);this.setHandleElId(a);this.scroll=false}});SYNO.SDS.AudioPlayer.Utils={timeRenderer:function(d,b){var c;if(isNaN(d)||""===d){return""}if(!b){b=d}var a={hour:Math.floor(d/3600),minute:Math.floor((d%3600)/60),second:Math.floor(d%60)};if(b>=3600){c=([a.hour,String.leftPad(a.minute,2,"0"),String.leftPad(a.second,2,"0")]).join(":")}else{if(b<60){c="0:"+String.leftPad(a.second,2,"0")}else{c=a.minute+":"+String.leftPad(a.second,2,"0")}}return c}};Ext.namespace("SYNO.SDS.AudioPlayer");Ext.define("SYNO.SDS.AudioPlayer.Application",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.AudioPlayer.MiniPlayer",constructor:function(a){Ext.apply(this,a);SYNO.SDS.AudioPlayer.Application.superclass.constructor.call(this,arguments)}});