#!/bin/sh

INETD=/usr/sbin/inetd
INETD_CONF="/etc/inetd.conf"
TEMP_CONF="/tmp/inetd.$$.conf.tmp"
CUPS_LPD="/usr/lib/cups/daemon/cups-lpd"
v4only=`/bin/get_key_value /etc.defaults/synoinfo.conf ipv4only`
SZF_INETD_LOCK="/tmp/syno_inetd.lock"

check_conf()
{
	if [ ! -f $INETD_CONF ]; then
		touch $INETD_CONF
	fi
}

prestart_telnetd()
{
	check_conf

	(
	if flock -x 8; then
		grep -v "^[ 	]*telnet\([ 	]\|$\)" $INETD_CONF > $TEMP_CONF
		if [ "yes" == "${v4only}" ]; then
			echo "telnet	stream	tcp	nowait	root	/usr/sbin/telnetd	telnetd" >> $TEMP_CONF
		else
			echo "telnet	stream	tcp6 nowait	root	/usr/sbin/telnetd	telnetd" >> $TEMP_CONF
		fi
		mv $TEMP_CONF $INETD_CONF

		reload inetd

		flock -u 8
		rm ${SZF_INETD_LOCK}
	fi
	)8> ${SZF_INETD_LOCK}
}

poststop_telnetd()
{
	check_conf

	(
	if flock -x 8; then
		grep -v "^[ 	]*telnet\([ 	]\|$\)" $INETD_CONF > $TEMP_CONF
		mv $TEMP_CONF $INETD_CONF

		killall telnetd
		reload inetd

		flock -u 8
		rm ${SZF_INETD_LOCK}
	fi
	)8> ${SZF_INETD_LOCK}
}

prestart_cups_lpd()
{
	if [ ! -x ${CUPS_LPD} ]; then
		echo "cups-lpd does not exist"
		return 0
	fi

	check_conf

	(
	if flock -x 8; then
		grep -v "^[ 	]*printer\([ 	]\|$\)" $INETD_CONF > $TEMP_CONF
		if [ "yes" == "${v4only}" ]; then
			echo "printer	stream  tcp	nowait	root	${CUPS_LPD} cups-lpd -T /var/services/printer/tmp" >> $TEMP_CONF
		else
			echo "printer	stream  tcp6 nowait	root	${CUPS_LPD} cups-lpd -T /var/services/printer/tmp" >> $TEMP_CONF
		fi
		mv $TEMP_CONF $INETD_CONF

		reload inetd

		flock -u 8
		rm ${SZF_INETD_LOCK}
	fi
	)8> ${SZF_INETD_LOCK}
}

poststop_cups_lpd()
{
	check_conf

	(
	if flock -x 8; then
		grep -v "^[ 	]*printer\([ 	]\|$\)" $INETD_CONF > $TEMP_CONF
		mv $TEMP_CONF $INETD_CONF

		reload inetd

		flock -u 8
		rm ${SZF_INETD_LOCK}
	fi
	)8> ${SZF_INETD_LOCK}
}

case "$1" in

prestart_telnetd)
	prestart_telnetd
	;;

poststop_telnetd)
	poststop_telnetd
	;;

prestart_cups_lpd)
	prestart_cups_lpd
	;;

poststop_cups_lpd)
	poststop_cups_lpd
	;;

*)
	echo "usage: $0 { prestart_telnetd | poststop_telnetd | prestart_cups_lpd | poststop_cups_lpd }" >&2
	exit 1
	;;

esac
