Httpd="/usr/bin/httpd"
HttpdConf="/etc/httpd/conf/httpd.conf"
HttpdSSLConf="/etc/httpd/conf/extra/httpd-ssl.conf"
HttpdSSLConfCipher="/etc/httpd/conf/extra/httpd-ssl.conf-cipher"
PHPINI="/etc/php/php.ini"
DEFAULT_PHPINI="/etc.defaults/php/php.ini"
SynoConf="/etc/synoinfo.conf"
SynoDefConf="/etc.defaults/synoinfo.conf"
PIDFILE="/run/httpd/httpd-user.pid"
SZD_MailStation="/var/packages/MailStation"
SZD_PhotoStation="/var/packages/PhotoStation"
SZF_PHPINI="/etc/php/php.ini"
SZF_USR_SETTING_INI="/etc/php/conf.d/user-settings.ini"
INTERCRT="/usr/syno/etc/ssl/ssl.intercrt/server-ca.crt"
SZD_USER_CONF="/etc/httpd/sites-enabled-user"
SZD_VHOST_CONF="/etc/httpd/sites-enabled-user/httpd-vhost.conf-user"
SZD_SSL_VHOST_CONF="/etc/httpd/sites-enabled-user/httpd-ssl-vhost.conf-user"

SupportWeb=$(/bin/get_key_value ${SynoDefConf} supportweb || true)
HttpPort=$(/bin/get_key_value ${SynoConf} httpport || true)
HttpsPort=$(/bin/get_key_value ${SynoConf} httpsport || true)
RunWebLocal=$(/bin/get_key_value ${SynoConf} supportweblocaluser || true)
SupportSPDY=$(/bin/get_key_value ${SynoDefConf} support_spdy || true)
RunSPDY=$(/bin/get_key_value ${SynoConf} runuserspdy || true)
RunHSTS=$(/bin/get_key_value ${SynoConf} runuserhsts || true)

. /etc.defaults/rc.subr || true

if [  -f "${SZD_MailStation}/enabled" ]; then
	WebmailEnabled="yes"
fi
if [  -f "${SZD_PhotoStation}/enabled" ]; then
	RunPhoto="yes"
fi

IsPortAlreadyListen()
{
	local Port="$1"
	grep -q "Listen $Port" $SZD_VHOST_CONF || grep -q "Listen $Port" $SZD_SSL_VHOST_CONF
	return $?
}

GenerateConf()
{
	cp ${HttpdConf}-user ${HttpdConf}
	cp ${HttpdSSLConf}-user ${HttpdSSLConf}
	if [ "$HttpPort" != "80" ]; then
		if ! IsPortAlreadyListen "$HttpPort" ; then
			echo "Listen $HttpPort" >> ${HttpdConf}
		fi
		echo "<VirtualHost *:$HttpPort>" >> ${HttpdConf}
		echo "Include $SZD_USER_CONF/*.conf" >> ${HttpdConf}
		echo "</VirtualHost>" >> ${HttpdConf}
	fi
	if [ "$HttpsPort" != "0" ]; then
		if ! IsPortAlreadyListen "$HttpsPort"; then
			echo "Listen $HttpsPort" >> ${HttpdSSLConf}
		fi
		echo "<VirtualHost *:$HttpsPort>" >> ${HttpdSSLConf}
		echo "Include $SZD_USER_CONF/*.conf" >> ${HttpdSSLConf}
		echo "SSLEngine on" >> ${HttpdSSLConf}
		echo "</VirtualHost>" >> ${HttpdSSLConf}
	fi
	if [ "$SupportWeb" = "yes" -a "$RunWebLocal" = "yes" ]; then
		echo "Include /etc/httpd/conf/extra/httpd-userdir.conf-user" >> ${HttpdConf}
	fi


	if [ -s ${HttpdSSLConfCipher} ]; then
		if [ -f "$INTERCRT" ]; then
			sed -e "/^#SSLCertificateChainFile/c\\SSLCertificateChainFile /usr/syno/etc/ssl/ssl.intercrt/server-ca.crt" \
			${HttpdSSLConfCipher} > ${HttpdSSLConfCipher}.$$
		else
			sed -e "/^SSLCertificateChainFile/c\\#SSLCertificateChainFile /usr/syno/etc/ssl/ssl.intercrt/server-ca.crt" \
			${HttpdSSLConfCipher} > ${HttpdSSLConfCipher}.$$
		fi

		if [ -s "${HttpdSSLConfCipher}.$$" ]; then
			mv ${HttpdSSLConfCipher}.$$ ${HttpdSSLConfCipher}
		fi

		rm -f ${HttpdSSLConfCipher}.$$ 2>/dev/null
	fi
}

PHP_date_timezone=$(synodate --getNameInTZDB || true)

PHPINI_DEFAULT=/etc.defaults/php/php.ini
# copy from default config if php.ini is empty or not exists.
if [ ! -s ${PHPINI} ]; then
	/bin/cp ${PHPINI_DEFAULT} ${PHPINI} || true
fi

/bin/sed -i "s:^.*date.timezone =.*$:date.timezone = ${PHP_date_timezone}:g" ${PHPINI} || true

if [ ! -s ${PHPINI} ]; then
	/bin/cp ${DEFAULT_PHPINI} ${PHPINI} || true
fi

if [ ! -x "$Httpd" ]; then
	echo "$Httpd is not executable."
	stop; exit 1;
fi


# Dir for Blog banner image file.
chown -R http /var/services/blog/ || true
chmod 755 /var/services/blog/ || true

#clean up Assistant Photo Uploader temp files
rm -rf "/var/services/photo/@eaDir/ASST_PHOTO_UPLOAD_TMP_DIR" || true

GenerateConf || true

mkdir -p /var/log/httpd /run/httpd || true
rm -f /run/httpd/user-cgisock.* || true

count=1
while [ ! -s "${HttpdConf}" -a $count -lt 3 ];
do
	GenerateConf
	count=$(($count + 1))
done
if [ ! -s ${HttpdConf} ]; then
	logger -p err -t $0 "${HttpdConf} is empty."
fi
