#!/bin/sh
CUPSD_LPADMIN=/usr/bin/lpadmin
CUPSD_DISABLE=/usr/bin/cupsdisable
GET_SECTION_KEY_VALUE=/usr/syno/bin/get_section_key_value
DRIVER_HOST="`/bin/get_key_value /etc.defaults/synoinfo.conf printer_driver_host`"
RSS_URL="`/bin/get_key_value /etc.defaults/synoinfo.conf rss_server`?dlSite=syno&tz="
DRIVER_LIST="_list_"
TMPFLD="/tmp/_airprint"
PRINTER_NAME=""
PPD_PATH="/etc/cups/ppd/"
LOGGER="/usr/bin/logger"
WGET="/usr/syno/bin/wget"
SERVICETOOL="/usr/syno/bin/servicetool"
SwapScript="/usr/syno/bin/swapaction"
USE_OTHER_WEB=0

MAXDISKS=`/bin/get_key_value /etc.defaults/synoinfo.conf maxdisks`
if [ ${MAXDISKS} -eq 0 ]; then
	DISKLESS="yes"
fi

log_msg()
{
	$LOGGER -sp $1 -t CUPS "$2"
}

update_service_link()
{
	VolumeSpool=$1
	log_msg err "Update service link to [${VolumeSpool}]"
	if [ ! -d /var/services ]; then
		rm -f /var/services
		mkdir /var/services
		chmod 755 /var/services
	fi
	if [ ! -d ${VolumeSpool} ]; then
		rm -f ${VolumeSpool}
		/bin/mkdir ${VolumeSpool}
	fi
	rm -rf /var/services/printer
	ln -sf ${VolumeSpool} /var/services/printer
}

make_spool_ready()
{
	Volume=`${SERVICETOOL} --get-service-path printer`
	ServiceOnVolume=$?
	if [ $ServiceOnVolume -eq 0 ] ; then
		Volume=`${SERVICETOOL} --get-alive-volume`
		FoundVolume=$?
		if [ $FoundVolume -eq 0 ] ; then
			log_msg err "Never start CUPS until volume exist..."
			exit 1
		fi
		update_service_link "${Volume}/@spool"
	fi

	SPOOL="/var/services/printer"
	/bin/rm -rf $SPOOL/cache
	/bin/mkdir $SPOOL/cache
	/bin/mkdir -p $SPOOL/tmp
	/bin/chmod -R 777 $SPOOL/
}

make_diskless_spool_ready()
{
	Volume=`${SERVICETOOL} --get-alive-sharebin`
	FoundVolume=$?
	if [ $FoundVolume -eq 0 ] ; then
		Volume="/volume1"
	fi

	ServicePath=`${SERVICETOOL} --get-service-path printer`
	ServiceOnVolume=$?
	if [ $ServiceOnVolume -eq 0 ] ; then
		update_service_link "${Volume}/@spool"
	elif [ $FoundVolume -ne 0 ] ; then
		CurrentService=`readlink /var/services/printer`
		FoundCurrent=$?
		if [ $FoundCurrent -ne 0 ] || [ "${CurrentService}" != "${Volume}/@spool" ] ; then
			update_service_link "${Volume}/@spool"
		fi
	fi

	SPOOL="/var/services/printer"
	/bin/rm -rf $SPOOL/cache
	/bin/mkdir $SPOOL/cache
	/bin/mkdir -p $SPOOL/tmp
	/bin/chmod 777 $SPOOL/
	/bin/chmod -R 777 $SPOOL/cache/
	/bin/chmod -R 777 $SPOOL/tmp/
}

link_airprint_filter()
{
	if [ -d /usr/local/cups/filter/ ]; then
		# backward compatible to DSM 5.0 AirPrint drivers
		ln -s /usr/local/cups/filter/* /usr/lib/cups/filter/ > /dev/null 2>&1
	fi
}

pre_start_cups()
{

	if [ "$DISKLESS" = "yes" ] ; then
		make_diskless_spool_ready
	else
		make_spool_ready
	fi

	link_airprint_filter
	exit 0
}

reload_cups()
{
	link_airprint_filter
	/sbin/reload cupsd
}

get_loadbalance_host()
{
	if [ -z "$DRIVER_HOST" ]; then
		log_msg err "Fail to get printer_driver_host from /etc.defaults/synoinfo.conf !"
		exit 1
	fi
	TZ="`/bin/get_key_value /etc/synoinfo.conf timezone`"
	LB_HOST="`/usr/syno/bin/curl ${RSS_URL}${TZ}`"

	if [ "$USE_OTHER_WEB" -eq 0 ] && [ "${LB_HOST:0:7}" == "http://" ]; then
		DRIVER_HOST="`/bin/echo $DRIVER_HOST| /bin/sed \"s;http://[^/]*;$LB_HOST;\"`"
	fi
	log_msg info "Using server: $DRIVER_HOST"
}


case $1 in
get_driver_list)
	TMPFILE="${TMPFLD}/${DRIVER_LIST}"
	/bin/mkdir -p ${TMPFLD}
	get_loadbalance_host
	if ! $WGET ${DRIVER_HOST}/${DRIVER_LIST} -O ${TMPFILE}; then
		exit 1
	fi
	;;
uninstall)
	ID=$2
	PRINTER_NAME=`$GET_SECTION_KEY_VALUE /usr/syno/etc/printer.conf $ID cups\ printer\ name`

	PPD=$PPD_PATH/$ID.ppd
	test -f $PPD && rm -f $PPD
	if ! synoservicecfg --status cupsd >/dev/null; then
		synoservicecfg --start cupsd
	fi
	$CUPSD_LPADMIN -x $PRINTER_NAME
	if [ "$DISKLESS" = "yes" ]; then
		$SwapScript off
	fi
	HOSTNAME=`hostname`
	$CUPSD_LPADMIN -p $PRINTER_NAME -E -L "$HOSTNAME" -v usb:/dev/usb/$2
	$CUPSD_DISABLE $PRINTER_NAME
	;;
uninstall_np)
	ID=$2
	PRINTER_NAME=`$GET_SECTION_KEY_VALUE /usr/syno/etc/printer.conf $ID cups\ printer\ name`
	IP=`$GET_SECTION_KEY_VALUE /usr/syno/etc/printer.conf $ID IP`
	Protocol=`$GET_SECTION_KEY_VALUE /usr/syno/etc/printer.conf $ID Backend`
	QName=`$GET_SECTION_KEY_VALUE /usr/syno/etc/printer.conf $ID QName`

	if [ "$Protocol" = "lpd" -o "$Protocol" = "ipp" ] && [ "$QName" != "" ]; then
		Device_URI="$Protocol://$IP/$QName"
	else
		Device_URI="$Protocol://$IP/"
	fi

	PPD=$PPD_PATH/$ID.ppd
	test -f $PPD && rm -f $PPD
	if ! synoservicecfg --status cupsd >/dev/null; then
		synoservicecfg --start cupsd
	fi
	$CUPSD_LPADMIN -x $PRINTER_NAME
	if [ "$DISKLESS" = "yes" ]; then
		$SwapScript off
	fi
	HOSTNAME=`hostname`
	$CUPSD_LPADMIN -p $PRINTER_NAME -E -L "$HOSTNAME" -v $Device_URI
	;;
install)
	# lp0 /ppd/xxxxxx.ppd.tgz
	TMPFILE="$TMPFLD/driver.tgz"
	get_loadbalance_host
	URL="${DRIVER_HOST}/$3"
	if [ ! -f /usr/syno/bin/lpadmin ]; then
		# backward compatible to DSM 5.0 AirPrint drivers
		ln -s /usr/bin/lpadmin /usr/syno/bin/lpadmin
	fi
	/bin/mkdir -p $TMPFLD
	if ! $WGET "$URL" -O ${TMPFILE}; then
		exit 1
	fi
	if ! /bin/tar zxvf $TMPFILE -C $TMPFLD/; then
		/bin/rm -f $TMPFILE
		exit 1
	fi
	/bin/rm -f $TMPFILE
	/bin/sh $TMPFLD/install.sh "$2" "$DRIVER_HOST" &
	;;
prestart)
	pre_start_cups
	;;
reload)
	reload_cups
	;;
*)
	exit 1
	;;
esac
# the return value should be 0 if operation success without a hitch
