#!/bin/sh

EXEFILE="/usr/syno/sbin/synodatacollectd"
PIDFILE="/var/run/synodatacollectd.pid"

# Get pid
is_daemon_alive() {
	if [ -f "$1" ]; then
		local pid=`cat "$1"`

		kill -0 $pid
		if [ "0" = "$?" ]; then
			echo "$pid";
			return 1;
		else
			echo "0";
			return 0;
		fi
	fi

	echo "0";
	return 0;
}

getpid() {
	pidnum=`is_daemon_alive $PIDFILE`
}

# Start syno cache client
synocacheclient_start() {
	Run=`/bin/get_key_value /etc/synoinfo.conf join_user_data_collect`
	retry=5
	if [ "yes" = "$Run" ]; then
		${EXEFILE}
		while [ $retry -gt 0 ] && [ "0" == `is_daemon_alive "$PIDFILE"` ];
		do
			sleep 1;
			retry=`expr $retry - 1`
		done

		if [ "0" == `is_daemon_alive "$PIDFILE"` ]; then
			echo "synodatacollectd start fail"
		else
			echo "synodatacollectd started"
		fi

	fi
}

# Stop syno cache client
synocacheclient_stop() {
	retry=30

	kill $pidnum

	while [ $retry -gt 0 ] && [ "0" != `is_daemon_alive "$PIDFILE"` ];
	do
		sleep 1;
		retry=`expr $retry - 1`
	done

	if [ "0" != `is_daemon_alive "$PIDFILE"` ] ; then
		kill -9 $pidnum
		echo "synodatacollectd still running, force kill"
	fi

	echo "synodatacollectd stopped"
	if [ -e "$PIDFILE" ] ; then
		rm "$PIDFILE"
	fi
}

case "$1" in
'start')
	getpid
	if [ "0" == "$pidnum" ] ; then
		synocacheclient_start
		RETVAL=0
	else
		echo "synodatacollectd is already running"
		RETVAL=1
	fi
	;;
'stop')
	getpid
	if [ "0" == "$pidnum" ] ; then
		echo "synodatacollectd is not running"
		RETVAL=1
	else
		synocacheclient_stop
		RETVAL=0
	fi
	;;
'restart')
	getpid
	if [ "0" == "$pidnum" ] ; then
		echo "synodatacollectd is not running"
		synocacheclient_start
	else
		synocacheclient_stop
		synocacheclient_start
	fi
	RETVAL=0
	;;
'status')
	getpid
	if [ "0" == "$pidnum" ] ; then
		echo "synodatacollectd is stopped"
		RETVAL=1
	else
		echo "synodatacollectd is running - Pid : $pidnum"
		RETVAL=0
	fi
	;;
*)
echo "Usage $0 { start | stop | restart | status }"
RETVAL=1
;;
esac
exit $RETVAL
