#!/bin/sh

IFCONFIG="/sbin/ifconfig"
UPNPD="/usr/syno/sbin/miniupnpd"
UPNP_TOOL="/usr/syno/bin/miniupnp-tool.sh"
CONFIG_DIR="/etc/sysconfig/miniupnpd"

usage() {
        cat <<EOF
Usage: $(basename $0) [start|stop|restart]
EOF
}

start_services() {
	if [ -d ${CONFIG_DIR} ]; then
		local files=`ls ${CONFIG_DIR}/*`
		
		for configs in ${files}; do
			# start upnpd
			`${UPNP_TOOL} start-config ${configs} > /dev/null 2>&1`
		done 
	fi
}

stop_services() {
	local files=`ps -w | grep -v grep | grep ${UPNPD} | sed -e "s/.*-f \(.*\) -P.*/\1/g"`
	
	for configs in ${files}; do
		# start upnpd
		`${UPNP_TOOL} stop-config ${configs} > /dev/null 2>&1 `
	done
}

action=$1
shift;

case $action in
	start)
		stop_services && start_services
		;;
	stop)
		stop_services
		;;
	restart)
		stop_services && start_services
		;;
	*)
		usage >&2;
		exit 1
		;;
esac
