#!/bin/sh
# Copyright (c) 2000-2015 Synology Inc. All rights reserved.

# This script starts isccore and iss daemon in order, and then monitor them
# indefinitely until at least one of them failed running.  If this happens, the
# two daemons are killed and the script ends.  Upstart service should handle
# this situation and respawn the script.

. /etc.defaults/rc.subr

ISS_PATH=/usr/syno/bin/iss
ISS_PID_FILE=/var/run/iss.pid
ISCCORE_PATH=/usr/syno/bin/isccore
ISCCORE_PID_FILE=/var/run/isccore.pid

# usage: wait_process name pid_file_path
# return: 0 for process exists, 1 for wait and find no such process
wait_process()
{
	[ $# -eq 0 ] && return 0
	local wait_time=10
	while [ $wait_time -gt 0 ]
	do
		if [ ! -f $2 ]; then
			sleep 1
			wait_time=`expr $wait_time - 1`
			continue
		fi
		pid=`cat $2`
		proc_exist=`ps | grep $pid | grep $1 | wc -l`
		if [ $proc_exist -eq 1 ]; then
			return 0
		else
			sleep 1
			wait_time=`expr $wait_time - 1`
		fi
	done
	echo "$1 does not exist ${proc_exist}, wait timeout"
	return 1
}

# usage: process_alive program_path pid_file_path
# return: 0 for process running, 1 otherwise.
process_alive()
{
	[ ! -f $2 ] && return 1
	local pid=`cat $2`
	if [ -d "/proc/${pid}" -a `cat /proc/${pid}/cmdline` = "$1" ]; then
		return 0
	fi
	return 1
}

trap 'killall iss; killall isccore; exit 0' INT TERM EXIT ABRT

RCMsg "Start iSCSI plugin daemon"
$ISCCORE_PATH &
wait_process $ISCCORE_PATH $ISCCORE_PID_FILE
$ISS_PATH &
wait_process $ISS_PATH $ISS_PID_FILE

trap - INT TERM EXIT ABRT

life_end=false
trap 'life_end=true' INT TERM ABRT

while ! $life_end
do
	process_alive $ISCCORE_PATH $ISCCORE_PID_FILE
	if [ $? -ne 0 ]; then
		RCMsg "$ISCCORE_PATH failed!"
		break
	fi
	process_alive $ISS_PATH $ISS_PID_FILE
	if [ $? -ne 0 ]; then
		RCMsg "$ISS_PATH failed!"
		break
	fi
	sleep 30
done

RCMsg "Stop iSCSI plugin daemon"
killall iss
killall isccore
return 0
