#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       NITEMS, SHARE_NAME_X, SHARE_OP_RESULT_X
###############################################################

#Include common scripts
FILE_SYNOINDEX_INC_SCRP=/usr/libexec/SynoindexShareCommon.sh
. ${FILE_SYNOINDEX_INC_SCRP}

BIN_SYNOSHARE=/usr/syno/sbin/synoshare
FILE_SHARE_PATH=/tmp/share_delete_path

SaveSharePath() {
    INDEX=1
    NITEMS=$((NITEMS + 1))
	while [ "${INDEX}" != "${NITEMS}" ]
	do
                eval "SHARE_NAME=\$SHARE_NAME_$INDEX"
		SHARE_PATH=`${BIN_SYNOSHARE} --get ${SHARE_NAME} | awk '$1 == "Path" {print $2}' | sed 's/^\.*\[//g' | sed 's/\]$//g'`
		echo "$SHARE_PATH" >> $FILE_SHARE_PATH;
		INDEX=$((INDEX + 1))
	done
}

RestoreSharePath() {
    INDEX=1
    while read line
    do
        eval "SHARE_PATH_$INDEX=\$line"
        INDEX=$((INDEX + 1))
    done < $FILE_SHARE_PATH
}

CheckShareDeleted() {
    # Only hooked when shares are deleted successfully
    INDEX=1;
    NITEMS=$((NITEMS + 1))
    while [ "${INDEX}" != "${NITEMS}" ]
    do
        eval "SHARE_OP_RESULT=\$SHARE_OP_RESULT_$INDEX"
        if [ "0x0000" = "${SHARE_OP_RESULT}" ]; then
            eval "SYNOINDEX_SHARE_NAME=\$SHARE_NAME_$INDEX"
            eval "SYNOINDEX_SHARE_PATH=\$SHARE_PATH_$INDEX"
            SynoindexShareRemove
        fi
        INDEX=$((INDEX + 1))
    done
}

case $1 in
    --sdk-mod-ver)
        #Print SDK support version
        echo ${SYNOINDEX_PKG_MODVER}
    ;;
    --name)
        #Print package name
        echo ${SYNOINDEX_PKG_NAME}
    ;;
    --pkg-ver)
        #Print package version
        echo ${SYNOINDEX_PKG_VERSION}
    ;;
    --vendor)
        #Print package vendor
        echo ${SYNOINDEX_PKG_VENDOR}
    ;;
    --pre)
        #Actions before share delete
        SaveSharePath
    ;;
    --post)
        #Actions after share delete
        RestoreSharePath
        CheckShareDeleted
        rm -f $FILE_SHARE_PATH
    ;;
    *)
        echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
    ;;
esac
