#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       NITEMS, SHARE_NAME_X, SHARE_PATH_X, SHARE_OP_RESULT_X
#
###############################################################

#At begining, acquire package settings
SYNOSHARE_BINARY=/usr/syno/sbin/synosharesnap
SYNOSCHEDTASK_BINARY=/usr/syno/bin/synoschedtask

SYNOSCHEDTASK_PKG_NAME="SynoSchedTask"
SYNOSCHEDTASK_PKG_VERSION="1.0"
SYNOSCHEDTASK_PKG_VENDOR="Synology Inc."
SYNOSCHEDTASK_PKG_MODVER="2.0"

case $1 in
	--sdk-mod-ver)
		echo ${SYNOSCHEDTASK_PKG_MODVER}
	;;
	--name)
		echo ${SYNOSCHEDTASK_PKG_NAME}
	;;
	--pkg-ver)
		echo ${SYNOSCHEDTASK_PKG_VERSION}
	;;
	--vendor)
		echo ${SYNOSCHEDTASK_PKG_VENDOR}
	;;
	--pre)
		if [ -f "${SYNOSCHEDTASK_BINARY}" ] && [ -f "${SYNOSHARE_BINARY}" ]; then
			INDEX=1
			NITEMS=$((NITEMS + 1))
			while [ ${INDEX} -lt ${NITEMS} ]
			do
				eval "SHARE_NAME=\$SHARE_NAME_$INDEX"
				SYNO_SHARE_SCHED_TASK_ID=`${SYNOSHARE_BINARY} sched get_task_id "${SHARE_NAME}"`
				RESULT_SCHEDTASKID=$?
				if [ 1 -eq ${RESULT_SCHEDTASKID} ]; then
					${SYNOSCHEDTASK_BINARY} --del id=${SYNO_SHARE_SCHED_TASK_ID}
				fi
				INDEX=$((INDEX + 1))
			done
		fi
	;;
	--post)
	;;
	*)
                echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
