#!/bin/sh

# check if local backup is running
if pidof synolocalbkp >/dev/null 2>&1; then
        exit 1
fi

# check if network backup is running
if pidof synonetbkp >/dev/null 2>&1; then
        exit 1
fi

# check if s3 backup is running
if pidof synonetbkps3 >/dev/null 2>&1; then
        exit 1
fi

# check if azure backup is running
if pidof synocloudbkp >/dev/null 2>&1; then
        exit 1
fi

# check if img backup client is running
if pidof img_backup >/dev/null 2>&1; then
        exit 1
fi

# check if hidrive backup is running
if pidof synohidrivebkp >/dev/null 2>&1; then
        exit 1
fi

# check if glacier backup is running
if pidof synoglacierbkp >/dev/null 2>&1; then
	exit 1
fi

# check if glacier backup is running
if pidof synoglaciertool >/dev/null 2>&1; then
	exit 1
fi

# check if dsm restoring or lun restoring
RESTORE_TEST=`/usr/syno/bin/synobackup --is-restoring`
if [ $? -eq 1 ]; then
	exit 1
fi

# check if local, network, s3, hidrive, glacier restore is running
if [ -f /tmp/DSMTaskMgr/@system/backup ]; then
	php -d open_basedir= <<'EOF'
<?php

$restore_task_info = file_get_contents('/tmp/DSMTaskMgr/@system/backup');
$obj = json_decode($restore_task_info);
$property = $obj->{'property'};
$restore_pid = $property->{'pid'};

$proc_path = "/proc/" . $restore_pid;
$proc_stat = stat($proc_path);

if (!$proc_stat) {
   $ret= 0;
} else {
   $ret = 1;
}

exit($ret);

?>
EOF
	isRestoring=$?
	if [ $isRestoring -ne 0 ]; then
		exit 1
	fi
fi

exit 0

