#!/bin/sh
. /etc/iproute2/script/gateway-mgt-function

SYNONETD_TOOL="/usr/syno/sbin/synonetdtool"

delete_wireless_interface()
{
	local topology=`/bin/get_key_value /etc/synoinfo.conf net_topology`
	if [ "client" != "${topology}" ]; then
		return
	fi

	# wpa connect and disconnect will pop alot of up-down event
	# make sure wpa is really disconnect
	local wpa_ps=`/bin/ps ww | /bin/grep wpa_supplicant | /bin/grep ${IFNAME}`
	if [ -n "$wpa_ps" ]; then
		return
	fi

	${SYNONETD_TOOL} --del-gateway-info -4 ${IFNAME}
	${SYNONETD_TOOL} --del-gateway-info -6 ${IFNAME}
	${SYNONETD_TOOL} --refresh-gateway -4
	${SYNONETD_TOOL} --refresh-gateway -6

	${SYNONETD_TOOL} --reset-ipv6-module ${IFNAME}

	local enable_multi_gateway=`/bin/get_key_value /etc/synoinfo.conf multi_gateway`
	if [ "xyes" = "x${enable_multi_gateway}" ]; then
		${SYNONETD_TOOL} --del-policy-route-rule -4 multi-gateway ${IFNAME}
		${SYNONETD_TOOL} --disable-route-table -4 ${IFNAME}
	fi
}

delete_6in4_tunnel_interface()
{
	if [ ! -e "/sys/class/net/6in4-${IFNAME}" ]; then
		return
	fi

	/sbin/ip tunnel del 6in4-${IFNAME}
	rm /etc/sysconfig/networking/ipv6-${IFNAME}

	${SYNONETD_TOOL} --del-gateway-info -6 6in4-${IFNAME}
	${SYNONETD_TOOL} --refresh-gateway -6
}

delete_wired_interface()
{
	local SPEED=`/usr/syno/bin/ethtool ${IFNAME} | grep Speed | cut -d ":" -f2 | cut -d " " -f2`
	if [$? -eq 0]; then
		if [ "Unknown!" != "${SPEED}" ]; then
			return
		fi

		local IFCFG_FILE="/etc/sysconfig/network-scripts/ifcfg-${IFNAME}"
		if [ ! -f ${IFCFG_FILE} ]; then
			return
		fi
	fi

	${SYNONETD_TOOL} --del-gateway-info -4 ${IFNAME}
	${SYNONETD_TOOL} --del-gateway-info -6 ${IFNAME}
	${SYNONETD_TOOL} --refresh-gateway -4
	${SYNONETD_TOOL} --refresh-gateway -6

	${SYNONETD_TOOL} --reset-ipv6-module ${IFNAME}

	local enable_multi_gateway=`/bin/get_key_value /etc/synoinfo.conf multi_gateway`
	if [ "xyes" = "x${enable_multi_gateway}" ]; then
		${SYNONETD_TOOL} --del-policy-route-rule -4 multi-gateway ${IFNAME}
		${SYNONETD_TOOL} --disable-route-table -4 ${IFNAME}
	fi
}

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "1.0";
	;;
	--name)
	#Print package name
	echo "SynorouterClient"
	;;
	--pkg-ver)
	#Print package version
	echo "1.0";
	;;
	--vendor)
	#Print package vendor
	echo "Synology";
	;;
	--post)
		local IFCFG_FILE="/etc/sysconfig/network-scripts/ifcfg-${IFNAME}"
		local BOOTPROTO=`get_key_value ${IFCFG_FILE} BOOTPROTO`

		if [ "${BOOTPROTO}" = "dhcp" ]; then
			restart dhcp-client IFACE=${IFNAME}
		fi

		if /usr/syno/bin/synobootseq --is-ready; then
			# Waiting for /usr/syno/bin/servicetool --restart link &
			restart smbd &
			restart nmbd &
			restart winbindd &
		fi

		echo ${IFNAME} | grep -q "^wlan"
		if [ $? -eq 0 ]; then
			delete_wireless_interface
			return
		fi
		is_wired_interface ${IFNAME}
		if [ $? -eq 0 ]; then
			delete_wired_interface
			return
		fi

		delete_6in4_tunnel_interface
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

