#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

USBMODEM_INFO="/tmp/usbmodem.info"
USBMODEM_HANDLER_LOCK="/tmp/lock/lock_usbmodem_plug"
COMMON_MODULE="slhc ppp_generic ppp_async"
OPTION_MODULE="usbserial usb_wwan usb_wwan_syno option"
CDC_ACM_MODULE="cdc-acm"
SIERRA_MODULE="usbserial sierra"
DAEMON_NAME="synousbmodemd"
USBMODEM_BACKUP_GW="/etc/ppp/usbmodem_backup_gw"
MODEM_DEBUG="/tmp/usbmodem.debug"

select_modules () {
	local module=$@
	local dev_modulefiles

	for mod in ${module}; do
		case "${mod}" in
			option)
				eval dev_modulefiles=\"\${dev_modulefiles} ${OPTION_MODULE}\"
				;;
			cdc-acm)
				eval dev_modulefiles=\"\${dev_modulefiles} ${CDC_ACM_MODULE}\"
				;;
			sierra)
				eval dev_modulefiles=\"\${dev_modulefiles} ${SIERRA_MODULE}\"
				;;
			*)
				echo "Failed to search the suitable modules with vendor[${usb_vendor}] and product[${usb_product}]" >> ${MODEM_DEBUG}
				;;
		esac
	done

	# some driver ko file might not exist in some platform
	# ex: usb_wwan_syno.ko only exist in linux 3.x platform, and no usb_wwan.ko
	MODULE_FILES=${COMMON_MODULE}
	for mod in ${dev_modulefiles}; do
		if [ -f /lib/modules/${mod}.ko ]; then
			MODULE_FILES="$MODULE_FILES $mod"
		fi
	done
}

list_using_modules() {
	local module_names=`grep -h MODULES ${USBMODEM_INFO}* | grep -v grep | cut -d'=' -f2 | sort -u`
	local ret=""
	USING_MODULES=""

	for module_name in ${module_names}; do
		if [ "x${module_name}" != "x" ]; then
			select_modules ${module_name}
			local filelist=${MODULE_FILES}

			for mod in ${filelist}; do
				if [ -z "$(echo ${ret} | grep ${mod})" ]; then
					ret="${mod} ${ret}"
				fi
			done
		fi
	done

	if [ -n "${ret}" -o "$(pidof pppd)" ]; then
		USING_MODULES="${ret} ${COMMON_MODULE}"
	else
		USING_MODULES=${ret}
	fi
}

check_device_to_skip ()
{
	# Vendor=04d8 ProdID=000a
	# this is LCD monitor used by bromolow, driver is cdc-acm, but it is not usbmodem
	local lcd_exist=`/bin/cat /proc/bus/usb/devices | /bin/grep "Vendor=04d8 ProdID=000a" | /usr/bin/wc -l`
	local driver_is_acm=`/bin/echo "$@" | /bin/grep ${CDC_ACM_MODULE} | /usr/bin/wc -l`

	if [ 0 -lt ${lcd_exist} -a 0 -lt ${driver_is_acm} ]; then
		return 1
	fi

	return 0
}

insert_modules() {
	select_modules $@
	local list=${MODULE_FILES}

	check_device_to_skip $list
	if [ 1 == $? ]; then
		return
	fi

	for mod in ${list}; do
		if [ -f /lib/modules/${mod}.ko ]; then
			/sbin/insmod /lib/modules/${mod}.ko >> ${MODEM_DEBUG}
		else
			echo "Modules ${mod} non-exists in /lib/modules/" >> ${MODEM_DEBUG}
		fi
	done
}

remove_modules() {
	select_modules $@
	local list=${MODULE_FILES}
	local filelist=""
	list_using_modules

	check_device_to_skip $list
	if [ 1 == $? ]; then
		return
	fi

	for mod in ${list}; do
		if [ -z "$(echo ${USING_MODULES} | grep ${mod})" ]; then
			filelist="${mod} ${filelist}"
		fi
	done

	for mod in ${filelist}; do
		/sbin/rmmod ${mod//-/_} >> ${MODEM_DEBUG}
	done
}

plug_in_usbmodem () {
	[ ! -d /tmp/lock ] && /bin/mkdir /tmp/lock
	(flock -x 666
		insert_modules $modules
	) 666>${USBMODEM_HANDLER_LOCK}
}

plug_out_usbmodem () {
	[ ! -d /tmp/lock ] && /bin/mkdir /tmp/lock
	(flock -x 666
		remove_modules $modules
	) 666>${USBMODEM_HANDLER_LOCK}
}

set_usbmodem_parameters () {
	usb_vendor=${SYNO_USB_VENDER}
	usb_product=${SYNO_USB_PRODUCT}
	product=${PRODUCT}
	modules=${SYNO_USB_DRIVER}
	device=${DEVICE}
}

start_usbmodem_daemon () {
	local hasdaemon=`ps | grep ${DAEMON_NAME} | grep -v grep`
	local hasdbus=`ps | grep dbus-daemon | grep system | grep -v grep`
	local waitCount=0;
	local maxWaitCount=60;

	if [ "x${hasdaemon}" = "x" ]; then

		while [ "x${hasdbus}" = "x" ] && [ $waitCount -lt $maxWaitCount ]; do
			echo "Wait for dbus-daemon starting..." >> ${MODEM_DEBUG}
			sleep 1
			waitCount=`expr $waitCount + 1`
			hasdbus=`ps | grep dbus-daemon | grep system | grep -v grep`
		done

		if [ "x${hasdbus}" = "x" ]; then
			echo "Timeout. Skip starting ${DAEMON_NAME}" >> ${MODEM_DEBUG}
		else
			echo "dbus-daemon is running. Try to start ${DAEMON_NAME}..." >> ${MODEM_DEBUG}
			`/usr/syno/sbin/${DAEMON_NAME}`
			hasdaemon=`ps | grep ${DAEMON_NAME} | grep -v grep`

			if [ "x${hasdaemon}" = "x" ]; then
				echo "Failed to start ${DAEMON_NAME}" >> ${MODEM_DEBUG}
			else
				echo "${DAEMON_NAME} is running" >> ${MODEM_DEBUG}
			fi
		fi
	elif [ "x${hasdaemon}" != "x" ]; then
		# signal it
		echo "----------> signal it " >> ${MODEM_DEBUG}
    fi
}

terminate_usbmodem_daemon () {
	local hasdaemon=`ps | grep ${DAEMON_NAME} | grep -v grep`

	if [ "x${hasdaemon}" != "x" ]; then
		local pid=`echo ${hasdaemon} | awk '{print $1}'`
		`/bin/kill -15 ${pid}`
		local ret=$?
		echo "Try to terminate ${DAEMON_NAME}..." >> ${MODEM_DEBUG}
		if [ ${ret} -ne 0 ]; then
			echo "Failed to terminate ${DAEMON_NAME}:[${pid}, ${ret}]" >> ${MODEM_DEBUG}
		fi
		sleep 1
	elif [ "x${hasdaemon}" != "x" ]; then
		# signal it
			echo "<---------- signal it " >> ${MODEM_DEBUG}
	fi
}

# input of this script: "plug-in/out" "${usb_idVendor}" "${usb_idProduct}" "${PRODUCT}" "${USBMODEM_DRIVER}" "${DEVICE}"
echo "-----------" >> ${MODEM_DEBUG}
echo "`date`" >> ${MODEM_DEBUG}
echo "action:[${ACTION}]" >> ${MODEM_DEBUG}

action=$1
shift;
case $action in
	[Pp][Ll][Uu][Gg]-[Ii][Nn])
		set_usbmodem_parameters "$@"
		plug_in_usbmodem
		start_usbmodem_daemon
		;;
	[Pp][Ll][Uu][Gg]-[Oo][Uu][Tt])
		set_usbmodem_parameters "$@"
		terminate_usbmodem_daemon
		plug_out_usbmodem
		;;
	*)
		echo "Usage: [plug-in|plug-out]"
		;;
esac

