#!/usr/bin/perl
use strict;

my $challenge = $ARGV[0];
my $pw = $ARGV[1];
my $hexcase = 0; # hex output format. 0 - lowercase; 1 - uppercase
my $chrsz = 16; # bits per input character. 8 - ASCII; 16 - Unicode

setResponse($pw);

sub setResponse
{
	my $str = $challenge . "-" . makeDots($_[0]);
	my $response = $challenge . "-" . hex_md5($str);
	print $response;
}

sub makeDots
{
	my $newStr = "";
	my $str = $_[0];
	my $len = length $str;

	for (my $i = 0; $i < $len; $i++) {
		if (ord(substr($str, $i, 1)) > 255) {
			$newStr .= '.';
		}
		else {
			$newStr .= substr($str, $i, 1);
		}
	}
	return $newStr;
}

# These are the functions you'll usually want to call
# They take string arguments and return either hex or base-64 encoded strings
sub hex_md5
{
	my $str = $_[0];
	my $len = length $str;
	return binl2hex(core_md5(str2binl($str), $len * $chrsz));
}

# Calculate the MD5 of an array of little-endian words, and a bit length
sub core_md5
{
	my @x = @_;
	# append padding
	my $last = scalar @x;
	my $len = int ($x[$last - 1]);
	$x[$last - 1] = "";

	$x[$len >> 5] |= 0x80 << (($len) % 32);
	$x[((($len + 64) >> 9) << 4) + 14] = $len;

	my $x_len = scalar @x;
	my $a = 1732584193;
	my $b = -271733879;
	my $c = -1732584194;
	my $d = 271733878;

	for(my $i = 0; $i < $x_len; $i += 16)
	{
		my $olda = $a;
		my $oldb = $b;
		my $oldc = $c;
		my $oldd = $d;

		$a = md5_ff($a, $b, $c, $d, $x[$i+ 0], 7 , -680876936);
		$d = md5_ff($d, $a, $b, $c, $x[$i+ 1], 12, -389564586);
		$c = md5_ff($c, $d, $a, $b, $x[$i+ 2], 17, 606105819);
		$b = md5_ff($b, $c, $d, $a, $x[$i+ 3], 22, -1044525330);
		$a = md5_ff($a, $b, $c, $d, $x[$i+ 4], 7 , -176418897);
		$d = md5_ff($d, $a, $b, $c, $x[$i+ 5], 12, 1200080426);
		$c = md5_ff($c, $d, $a, $b, $x[$i+ 6], 17, -1473231341);
		$b = md5_ff($b, $c, $d, $a, $x[$i+ 7], 22, -45705983);
		$a = md5_ff($a, $b, $c, $d, $x[$i+ 8], 7 , 1770035416);
		$d = md5_ff($d, $a, $b, $c, $x[$i+ 9], 12, -1958414417);
		$c = md5_ff($c, $d, $a, $b, $x[$i+10], 17, -42063);
		$b = md5_ff($b, $c, $d, $a, $x[$i+11], 22, -1990404162);
		$a = md5_ff($a, $b, $c, $d, $x[$i+12], 7 , 1804603682);
		$d = md5_ff($d, $a, $b, $c, $x[$i+13], 12, -40341101);
		$c = md5_ff($c, $d, $a, $b, $x[$i+14], 17, -1502002290);
		$b = md5_ff($b, $c, $d, $a, $x[$i+15], 22, 1236535329);
		$a = md5_gg($a, $b, $c, $d, $x[$i+ 1], 5 , -165796510);
		$d = md5_gg($d, $a, $b, $c, $x[$i+ 6], 9 , -1069501632);
		$c = md5_gg($c, $d, $a, $b, $x[$i+11], 14, 643717713);
		$b = md5_gg($b, $c, $d, $a, $x[$i+ 0], 20, -373897302);
		$a = md5_gg($a, $b, $c, $d, $x[$i+ 5], 5 , -701558691);
		$d = md5_gg($d, $a, $b, $c, $x[$i+10], 9 , 38016083);
		$c = md5_gg($c, $d, $a, $b, $x[$i+15], 14, -660478335);
		$b = md5_gg($b, $c, $d, $a, $x[$i+ 4], 20, -405537848);
		$a = md5_gg($a, $b, $c, $d, $x[$i+ 9], 5 , 568446438);
		$d = md5_gg($d, $a, $b, $c, $x[$i+14], 9 , -1019803690);
		$c = md5_gg($c, $d, $a, $b, $x[$i+ 3], 14, -187363961);
		$b = md5_gg($b, $c, $d, $a, $x[$i+ 8], 20, 1163531501);
		$a = md5_gg($a, $b, $c, $d, $x[$i+13], 5 , -1444681467);
		$d = md5_gg($d, $a, $b, $c, $x[$i+ 2], 9 , -51403784);
		$c = md5_gg($c, $d, $a, $b, $x[$i+ 7], 14, 1735328473);
		$b = md5_gg($b, $c, $d, $a, $x[$i+12], 20, -1926607734);
		$a = md5_hh($a, $b, $c, $d, $x[$i+ 5], 4 , -378558);
		$d = md5_hh($d, $a, $b, $c, $x[$i+ 8], 11, -2022574463);
		$c = md5_hh($c, $d, $a, $b, $x[$i+11], 16, 1839030562);
		$b = md5_hh($b, $c, $d, $a, $x[$i+14], 23, -35309556);
		$a = md5_hh($a, $b, $c, $d, $x[$i+ 1], 4 , -1530992060);
		$d = md5_hh($d, $a, $b, $c, $x[$i+ 4], 11, 1272893353);
		$c = md5_hh($c, $d, $a, $b, $x[$i+ 7], 16, -155497632);
		$b = md5_hh($b, $c, $d, $a, $x[$i+10], 23, -1094730640);
		$a = md5_hh($a, $b, $c, $d, $x[$i+13], 4 , 681279174);
		$d = md5_hh($d, $a, $b, $c, $x[$i+ 0], 11, -358537222);
		$c = md5_hh($c, $d, $a, $b, $x[$i+ 3], 16, -722521979);
		$b = md5_hh($b, $c, $d, $a, $x[$i+ 6], 23, 76029189);
		$a = md5_hh($a, $b, $c, $d, $x[$i+ 9], 4 , -640364487);
		$d = md5_hh($d, $a, $b, $c, $x[$i+12], 11, -421815835);
		$c = md5_hh($c, $d, $a, $b, $x[$i+15], 16, 530742520);
		$b = md5_hh($b, $c, $d, $a, $x[$i+ 2], 23, -995338651);
		$a = md5_ii($a, $b, $c, $d, $x[$i+ 0], 6 , -198630844);
		$d = md5_ii($d, $a, $b, $c, $x[$i+ 7], 10, 1126891415);
		$c = md5_ii($c, $d, $a, $b, $x[$i+14], 15, -1416354905);
		$b = md5_ii($b, $c, $d, $a, $x[$i+ 5], 21, -57434055);
		$a = md5_ii($a, $b, $c, $d, $x[$i+12], 6 , 1700485571);
		$d = md5_ii($d, $a, $b, $c, $x[$i+ 3], 10, -1894986606);
		$c = md5_ii($c, $d, $a, $b, $x[$i+10], 15, -1051523);
		$b = md5_ii($b, $c, $d, $a, $x[$i+ 1], 21, -2054922799);
		$a = md5_ii($a, $b, $c, $d, $x[$i+ 8], 6 , 1873313359);
		$d = md5_ii($d, $a, $b, $c, $x[$i+15], 10, -30611744);
		$c = md5_ii($c, $d, $a, $b, $x[$i+ 6], 15, -1560198380);
		$b = md5_ii($b, $c, $d, $a, $x[$i+13], 21, 1309151649);
		$a = md5_ii($a, $b, $c, $d, $x[$i+ 4], 6 , -145523070);
		$d = md5_ii($d, $a, $b, $c, $x[$i+11], 10, -1120210379);
		$c = md5_ii($c, $d, $a, $b, $x[$i+ 2], 15, 718787259);
		$b = md5_ii($b, $c, $d, $a, $x[$i+ 9], 21, -343485551);
		$a = safe_add($a, $olda);
		$b = safe_add($b, $oldb);
		$c = safe_add($c, $oldc);
		$d = safe_add($d, $oldd);
	}

	my @array = ($a, $b, $c, $d);
	return @array;
}

# These functions implement the four basic operations the algorithm uses.
sub md5_cmn
{
	return safe_add(bit_rol(safe_add(safe_add($_[1], $_[0]), safe_add($_[3], $_[5])), $_[4]),$_[2]);
}

sub md5_ff
{
	return md5_cmn(($_[1] & $_[2]) | ((~$_[1]) & $_[3]), $_[0], $_[1], $_[4], $_[5], $_[6]);
}

sub md5_gg
{
	return md5_cmn(($_[1] & $_[3]) | ($_[2] & (~$_[3])), $_[0], $_[1], $_[4], $_[5], $_[6]);
}

sub md5_hh
{
	return md5_cmn($_[1] ^ $_[2] ^ $_[3], $_[0], $_[1], $_[4], $_[5], $_[6]);
}

sub md5_ii
{
	return md5_cmn($_[2] ^ ($_[1] | (~$_[3])), $_[0], $_[1], $_[4], $_[5], $_[6]);
}

# Add integers, wrapping at 2^32. This uses 16-bit operations internally
# to work around bugs in some JS interpreters.
sub safe_add
{
	my $lsw = ($_[0] & 0xFFFF) + ($_[1] & 0xFFFF);
	my $msw = ($_[0] >> 16) + ($_[1] >> 16) + ($lsw >> 16);
	return (($msw << 16) | ($lsw & 0xFFFF));
}

# Bitwise rotate a 32-bit number to the left.
sub bit_rol
{
	my $num = $_[0];
	my $cnt = $_[1];
	return (($num << $cnt) | ($num >> (32 - $cnt)));
}


# Convert a string to an array of little-endian words
# If chrsz is ASCII, characters >255 have their hi-byte silently ignored.
# !!!! Chinese word is fail now !!!!
sub str2binl
{
	my @bin = ();
	my $strLength = length $_[0];
	my $mask = (1 << $chrsz) - 1;

	for (my $i = 0; $i < $strLength * $chrsz; $i += $chrsz) {
		my $tmpString = ord(substr($_[0], ($i / $chrsz), 1));
		$bin[$i>>5] |= ($tmpString & $mask) << ($i%32);
	}
	return @bin;
}

# Convert an array of little-endian words to a hex string.
sub binl2hex
{
	my $hex_tab = $hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
	my $str = "";
	my @arr = @_;
	my $arr_len = scalar @arr;
	for(my $i = 0; $i < $arr_len * 4; $i++)
	{
		$str .= substr($hex_tab, (($_[$i>>2] >> (($i%4)*8+4)) & 0xF), 1) .
		substr($hex_tab, (($_[$i>>2] >> (($i%4)*8 )) & 0xF), 1);
	}
	return $str;
}


