/* Copyright (c) 2018 Synology Inc. All rights reserved. */

Ext.namespace("SYNO.SDS.StorageManager");Ext.define("SYNO.SDS.StorageManager.DataView",{extend:"SYNO.ux.ExpandableListView",singleExpanded:true,constructor:function(a){var c=this,b;c.selectedItemId={};c.appWin=a.appWin;c.owner=a.owner;c.usageTpl=a.usageTpl;c.detailTpl=a.detailTpl;c.isCardLayout=a.isCardLayout;c.showButton=(c.usageTpl||c.detailTpl||c.isCardLayout)?true:false;b={tpl:this.createTpl(),trackResetOnLoad:false};c.callParent([Ext.apply(b,a)])},createTpl:function(){var c=this;var b='<div class="sm-list-next-btn"><div class="sm-list-next-img"></div></div>';var d='<div class="item-toggle"><div class="item-toggle-img"></div></div>';var a=new Ext.XTemplate('<tpl for=".">','<div class="item-wrap" itemId="{id}" id="{id}">','<div class="item-summary">','<div class="item-icon sm-list-icon {iconCls}"></div>','<div class="sm-list-status-icon {statusIconCls}"></div>',"<div>",'<span class="item-title">{displayName}</span>',"{summaryStatus}",'<div class="item-status">{desc}</div>',"</div>",c.usageTpl?c.usageTpl.html:"",!c.showButton?"":(c.isCardLayout?b:d),"</div>",c.detailTpl?('<div class="item-detail" style="display:none">'+c.detailTpl.html+"</div>"):"","</div>","</tpl>",'<div class="x-clear"></div>',{hasValues:function(e){if(!e){return false}return 0<e.length}});return a},getSelectedItemIds:function(){var a,b,c=[];a=this.getSelectedRecords();for(b=0;b<a.length;++b){if(!a[b]){continue}c.push(a[b].get("id"))}return c},getSelectedItems:function(){var c=this,a=c.getSelectedItemIds(),d=c.appWin[c.dataType].data,b=[];Ext.each(a,function(e){if(e in d){if(d[e]){b.push(d[e])}}});return b},getSelectedItem:function(){var b=this;var a=b.getSelectedItems();if(0===a.length){return}return a[0]},setFocus:function(a){if(!a){return}this.focusNode(a);this.select(a);this.setExpanded(a,true)},isExpanded:function(b){var a=Ext.get(b);return a&&(a.child(".item-toggle-expanded")!==null)},setExpanded:function(c,b){var a=Ext.get(c);if(a&&this.isExpanded(c)!==b){this.toggleDetail(a,true)}},onClick:function(d,c,b){this.callParent(arguments);if(!this.isCardLayout){return}var a=Ext.fly(c);if(a&&(a.hasClass("sm-list-next-btn")||a.hasClass("sm-list-next-img"))){this.owner.fireEvent("nextDetail")}},onDblClick:function(c,b,a){if(this.isCardLayout){this.owner.fireEvent("nextDetail");return}this.callParent(arguments)}});Ext.define("SYNO.SDS.StorageManager.FieldSet",{extend:"Ext.form.FieldSet",collapsible:true,animCollapse:true,constructor:function(){this.callParent(arguments);this.addListener("afterrender",this.doLayout.createDelegate(this,[false,true]),this)},onRender:function(b,a){this.callParent(arguments);var c=this.el.select("legend");if(c){c.addListener("mouseover",this.onMouseOverLegend,this);c.addListener("mouseout",this.onMouseOutLegend,this);c.addListener("mousedown",this.onMouseDownLegend,this);c.addListener("mouseup",this.onMouseUpLegend,this);c.addListener("click",this.onClickLegend,this);c.setStyle({display:"block",width:"100%"})}this.addClass("sm-detail-fieldset")},onMouseOverLegend:function(){this.el.select("legend").addClass("sm-fieldset-legend-hover")},onMouseOutLegend:function(){this.el.select("legend").removeClass("sm-fieldset-legend-hover")},onMouseDownLegend:function(){this.el.select("legend").addClass("sm-fieldset-legend-click")},onMouseUpLegend:function(){this.el.select("legend").removeClass("sm-fieldset-legend-click")},onClickLegend:function(){this.ownerCt.ownerCt.fireEvent("prevList")},toggleCollapse:function(a){this.ownerCt.ownerCt.fireEvent("prevList");return this}});SYNO.SDS.StorageManager.UsageTpl=function(){var a=new Ext.XTemplate('<div class="sm-usage">',"<div>{usage}</div>",'<div class="sm-usage-bg">','<div class="sm-usage-bar" style="width:{barWidth}px"></div>',"</div>","</div>");return a};SYNO.SDS.StorageManager.ScrubbingPropertyTpl=function(){var a=new Ext.XTemplate("<div>",'<tpl for="scrubbingProperty">',"<dl>",'<dt class="sm-grid-property-name">{name}</dt>','<dt class="sm-grid-property-value">{value}</dt>','<div style="clear:both"></div>',"</dl>","</tpl>",'<div class="x-clear"></div>',"</div>");return a};SYNO.SDS.StorageManager.PropertyTpl=function(){var a=new Ext.XTemplate("<div>",'<tpl for="property">',"<dl>",'<dt class="sm-grid-property-name">{name}</dt>','<dt class="sm-grid-property-value">{value}</dt>','<div style="clear:both"></div>',"</dl>","</tpl>",'<div class="x-clear"></div>',"</div>");return a};SYNO.SDS.StorageManager.PropertyWithTipTpl=function(){var a=new Ext.XTemplate("<div>",'<tpl for="property">',"<dl>",'<dt class="sm-grid-property-name">{name}</dt>','<dt class="sm-grid-property-value">{value}','<tpl if="Ext.isString(values.tip)">','<span class="sm-tip-placeholder" tip="{values.tip}"></span>',"</tpl>","</dt>",'<div style="clear:both"></div>',"</dl>","</tpl>",'<div class="x-clear"></div>',"</div>");return a};SYNO.SDS.StorageManager.AllocationListTpl=function(a){var d,b;var c=function(f,e,g,h){return String.format('<dt class="sm-grid-disk-list-column" style="width:55%">{0}</dt><dt class="sm-grid-disk-list-column" style="width:15%">{1}</dt><dt class="sm-grid-disk-list-column" style="width:15%">{2}</dt><dt class="sm-grid-disk-list-column" style="width:15%">{3}</dt>',f,e,g,h)};d=new Ext.XTemplate(String.format('<tpl if="this.hasValues(values.{0}) == false">',a.scope),String.format('<div class="sm-grid-disk-list-no-item">{0}</div>',_T("volume","volume_status_none")),"</tpl>",String.format('<tpl for="{0}">',a.scope),'<dl class="sm-grid-disk-list-row">',c("{name}","{fs}","{usedSize}","{totalSize}"),'<div class="x-clear"></div>',"</dl>","</tpl>");b=new Ext.XTemplate(String.format('<div class="sm-grid-section-header">{0}</div>',_T("volume","storage_allocation")),'<div class="sm-grid-disk-list">','<div class="sm-grid-disk-list-header">',"<dl>",c(_T("common","name"),_T("volume","volume_filesystem"),_T("volume","volume_usedsize"),_T("volume","volume_totalsize")),'<div class="x-clear"></div>',"</dl>","</div>",'<div class="sm-grid-disk-list-body">',d.html,"</div>","</div>",'<div class="x-clear"></div>');return b};SYNO.SDS.StorageManager.DiskListTpl=function(c){var b,g,f,e,a,h,d;g=c.title||_T("smart","smart_toolbar_disk_info");b=c.emptyText||_T("volume","volume_status_none");f=String.format('<div class="sm-grid-section-header">{0} {#} - {1} {status}</div>',_T("volume","volume_raid_subgroup"),g);e=String.format('<div class="sm-grid-section-header">{0}</div>',g);a=new Ext.XTemplate('<tpl if="xcount &gt; 1">',f,"</tpl>",'<tpl if="xcount <= 1">',e,"</tpl>");h=new Ext.XTemplate(String.format('<tpl if="this.hasValues(values.{0}) == false">',c.scope),String.format('<div class="sm-grid-disk-list-no-item">{0}</div>',b),"</tpl>",String.format('<tpl for="{0}">',c.scope),'<dl class="sm-grid-disk-list-row">','<dt class="sm-grid-disk-list-column" style="width:17%">{container}</dt>','<dt class="sm-grid-disk-list-column" style="width:22%">{name}</dt>','<dt class="sm-grid-disk-list-column" style="width:17%">{size}</dt>','<dt class="sm-grid-disk-list-column" style="width:10%">{driveType}</dt>','<dt class="sm-grid-disk-list-column" style="width:17%">{status}</dt>','<dt class="sm-grid-disk-list-column" style="width:17%">{overviewStatus}</dt>','<div class="x-clear"></div>',"</dl>","</tpl>");d=new Ext.XTemplate(a.html,'<div class="sm-grid-disk-list">','<div class="sm-grid-disk-list-header">',"<dl>",String.format('<dt class="sm-grid-disk-list-column" style="width:17%">{0}</dt>',_T("volume","volume_e_unit")),String.format('<dt class="sm-grid-disk-list-column" style="width:22%">{0}</dt>',_T("volume","volume_disknumber")),String.format('<dt class="sm-grid-disk-list-column" style="width:17%">{0}</dt>',_T("volume","volume_diskcapacity")),String.format('<dt class="sm-grid-disk-list-column" style="width:10%">{0}</dt>',_T("volume","volume_disk_type")),String.format('<dt class="sm-grid-disk-list-column" style="width:17%">{0}</dt>',_T("disk_info","disk_allocation_status")),String.format('<dt class="sm-grid-disk-list-column" style="width:17%">{0}</dt>',_T("disk_info","disk_health_status")),'<div class="x-clear"></div>',"</dl>","</div>",'<div class="sm-grid-disk-list-body">',h.html,"</div>","</div>",'<div class="x-clear"></div>');return d};SYNO.SDS.StorageManager.VolumeListTpl=function(c){var b,f,e,a,g,d;f=c.title||_T("volume","volume");b=c.emptyText||_T("volume","volume_status_none");e=String.format('<div class="sm-grid-section-header">{0}</div>',f);a=new Ext.XTemplate("<tpl>",e,"</tpl>");g=new Ext.XTemplate(String.format('<tpl if="this.hasValues(values.{0}) == false">',c.scope),String.format('<div class="sm-grid-disk-list-no-item">{0}</div>',b),"</tpl>",String.format('<tpl for="{0}">',c.scope),'<dl class="sm-grid-disk-list-row">','<dt class="sm-grid-disk-list-column" style="width:25%">{name}</dt>','<dt class="sm-grid-disk-list-column" style="width:25%">{fileSystem}</dt>','<dt class="sm-grid-disk-list-column" style="width:25%">{capacity}</dt>','<dt class="sm-grid-disk-list-column" style="width:25%">{supportScrubbing}</dt>','<div class="x-clear"></div>',"</dl>","</tpl>");d=new Ext.XTemplate(a.html,'<div class="sm-grid-disk-list">','<div class="sm-grid-disk-list-header">',"<dl>",String.format('<dt class="sm-grid-disk-list-column" style="width:25%">{0}</dt>',_T("volume","volume")),String.format('<dt class="sm-grid-disk-list-column" style="width:25%">{0}</dt>',_T("volume","volume_add_fs_type")),String.format('<dt class="sm-grid-disk-list-column" style="width:25%">{0}</dt>',_T("volume","volume_totalsize")),String.format('<dt class="sm-grid-disk-list-column" style="width:25%">{0}</dt>',_T("data_scrubbing","fs_scrubbing_support")),'<div class="x-clear"></div>',"</dl>","</div>",'<div class="sm-grid-disk-list-body">',g.html,"</div>","</div>",'<div class="x-clear"></div>');return d};SYNO.SDS.StorageManager.DetailUsageTpl=function(){var a=new Ext.XTemplate('<tpl for="detailUsage">','<div class="sm-detail-usage-bg">','<div class="sm-detail-usage-bar1" style="width:{bar1Width}%"></div>','<div class="sm-detail-usage-bar2" style="width:{bar2Width}%"></div>',"</div>","</tpl>","<table>","<tr>",'<tpl for="illustrate">','<tpl if="hide != 1">','<td style="vertical-align:bottom">','<div class="sm-illustrate">','<div class="sm-illustrate-text">{text}</div>',"</div>","</td>","</tpl>","</tpl>","</tr>","</table>","<table>","<tr>",'<tpl for="illustrate">','<tpl if="hide != 1">',"<td>",'<div class="sm-illustrate">','<div class="sm-illustrate-bar{#}"></div>',"</div>","</td>","</tpl>","</tpl>","</tr>","</table>","<table>","<tr>",'<tpl for="illustrate">','<tpl if="hide != 1">','<td style="vertical-align:top">',"<tpl if=\"'string' === typeof message && 0 < message.length\">",'<div class="sm-illustrate">','<div class="sm-illustrate-value{#}"><span style="font-size: 10px">{message}</span></div>',"</div>","</tpl>","<tpl if=\"'string' !== typeof message || 0 === message.length\">",'<div class="sm-illustrate">','<div class="sm-illustrate-value{#}">{value}<span style="font-size: 10px">&nbsp;{unit}</span></div>',"</div>","</tpl>","</td>","</tpl>","</tpl>","</tr>","</table>",'<div class="x-clear"></div>');return a};SYNO.SDS.StorageManager.ListTpl=function(b){var a,g,e,c=[],f=[],h,d;g=b.title||_T("smart","smart_toolbar_disk_info");a=b.emptyText||_T("volume","volume_status_none");e=100/b.columns.length;Ext.each(b.columns,function(i){c.push(String.format('<dt class="sm-grid-disk-list-column" style="width:{0}%">{1}</dt>',i.width?i.width:e,i.header));f.push(String.format('<dt class="sm-grid-disk-list-column" style="width:{0}%">{{1}}</dt>',i.width?i.width:e,i.dataIndex))});h=new Ext.XTemplate(String.format('<tpl if="this.hasValues(values.{0}) == false">',b.scope),String.format('<div class="sm-grid-disk-list-no-item">{0}</div>',a),"</tpl>",String.format('<tpl for="{0}">',b.scope),'<dl class="sm-grid-disk-list-row">',f.join(""),'<div class="x-clear"></div>',"</dl>","</tpl>");d=new Ext.XTemplate(String.format('<div class="sm-grid-section-header">{0}</div>',g),'<div class="sm-grid-disk-list">','<div class="sm-grid-disk-list-header">',"<dl>",c.join(""),'<div class="x-clear"></div>',"</dl>","</div>",'<div class="sm-grid-disk-list-body">',h.html,"</div>","</div>",'<div class="x-clear"></div>');return d};Ext.define("SYNO.SDS.StorageManager.Dialog.Confirm",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.owner=a.owner;this.callback=a.callback;var b={title:a.title||"",width:650,height:a.winHeight+220,layout:"fit",resizable:false,items:[{xtype:"syno_formpanel",items:[]}],buttons:[{xtype:"syno_button",btnStyle:a.confirmBtnStyle||"blue",itemId:"confirm",text:_T("common","apply"),handler:function(){if(this.callback){this.callback()}this.close()},scope:this},{itemId:"cancel",text:_T("common","cancel"),handler:function(){this.close()},scope:this}]};if(a.message){b.items[0].items.push({xtype:"syno_displayfield",html:a.message});b.items[0].items.push({xtype:"syno_displayfield",html:" "})}b.items[0].items.push({xtype:"syno_checkbox",htmlEncode:false,hideLabel:true,boxLabel:String.format('<font class="red-status">{0}</font>',a.confirmText),listeners:{check:function(c,d){if(d){this.getFooterToolbar().get("confirm").enable()}else{this.getFooterToolbar().get("confirm").disable()}},scope:this}});this.callParent([Ext.apply(b,a)])},onOpen:function(){this.callParent(arguments);this.getFooterToolbar().get("confirm").disable()}});Ext.define("SYNO.SDS.StorageManager.SortButton",{extend:"SYNO.ux.Button",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;b={itemId:"sort",tooltip:_T("pkgmgr","sort"),cls:"syno-sm-sort-btn",menu:{defaults:{checked:false},cls:"syno-pkg-menu syno-ux-searchfield-menu",items:a.menuItems,show:function(e,f,d){if(this.floating){this.parentMenu=d;if(!this.el){this.render();this.doLayout(false,true)}this.items.each(function(g){if(undefined!==c.owner.sortType&&g.itemId!==c.owner.sortType){g.setChecked(false)}else{g.setChecked(true)}},this);this.showAt(this.el.getAlignToXY(e,f||this.defaultAlign,this.defaultOffsets),d)}else{Ext.menu.Menu.superclass.show.call(this)}}}};c.callParent([b])},getMenuClass:function(){return""}});Ext.define("SYNO.SDS.StorageManager.Wizard.SummaryStore",{extend:"SYNO.SDS.Wizard.SummaryStore",constructor:function(){SYNO.SDS.Wizard.SummaryStore.superclass.constructor.call(this,{autoDestroy:true,root:"data",fields:["key","value","skipValueEncode"]})},append:function(a,c,d){var b={key:a,value:c,skipValueEncode:d?true:false};this.loadData({data:[b]},true)}});Ext.define("SYNO.SDS.StorageManager.Wizard.ModalWindow",{extend:"SYNO.SDS.Wizard.ModalWindow",constructor:function(a){this.callParent(arguments);this.dataStack=[{wizard_mode:a.mode||""}]},onOpen:function(){this.callParent(arguments);var a=this.getActiveStep();if(Ext.isFunction(a.isSkip)&&a.isSkip()){if(Ext.isFunction(a.getNext)){this.goNext(a.getNext())}else{this.goNext()}}},setData:function(a,b){this.dataStack.last()[a]=b},goNext:function(b){var c,a;c=this.getActiveStep();if(Ext.isFunction(c.beforeNext)&&false===c.beforeNext()){return}a=SYNO.SDS.Utils.clone(this.dataStack.slice(-1).pop())||{};if(Ext.isFunction(c.updateData)){c.updateData(a)}this.dataStack.push(a);this.callParent(arguments);c=this.getActiveStep();if(Ext.isFunction(c.isSkip)&&c.isSkip()){if(Ext.isFunction(c.getNext)){this.goNext(c.getNext())}else{this.goNext()}}},goBack:function(){var a;this.dataStack.pop();this.callParent(arguments);if(this.stepStack.length<1){return}a=this.getActiveStep();if(Ext.isFunction(a.isSkip)&&a.isSkip()){if(Ext.isFunction(a.getBack)){this.goBack(a.getBack())}else{this.goBack()}}},getData:function(c,a){var b=this.dataStack.slice(-1).pop()[c];return(typeof(b)!=="undefined"?b:a)}});Ext.define("SYNO.SDS.StorageManager.Wizard.Step",{extend:"SYNO.ux.FormPanel",activate:function(){},deactivate:function(){},isSkip:function(){return false},getNext:function(){return this.nextId||null},getBack:function(){},beforeNext:function(){return true},updateData:function(a){},summary:function(a){},getData:function(c,a){var b;if(this.owner&&this.owner.dataStack){b=this.owner.dataStack.slice(-1).pop()[c]}return(typeof(b)!=="undefined"?b:a)}});Ext.define("SYNO.SDS.StorageManager.Wizard.SummaryStep",{extend:"SYNO.SDS.Wizard.SummaryStep",constructor:function(){var a=arguments[0]||{};a.store=new SYNO.SDS.StorageManager.Wizard.SummaryStore();this.callParent([a])},activate:function(){var a=this.owner.stepStack;var c=null;this.callParent(arguments);this.getStore().removeAll(true);for(var b=0;b<a.length;b++){c=this.owner.getStep(a[b]);if(Ext.isFunction(c.isSkip)&&c.isSkip()){continue}if(Ext.isFunction(c.summary)){c.summary(this.getStore())}}this.getView().refresh()},descRenderer:function(f,a,b,e,h,g){var i,d,c;if(b.data.skipValueEncode){i=f.toString().replace(/<.*?>/g,"");c=Ext.util.Format.htmlEncode(i);d=f}else{c=Ext.util.Format.htmlEncode(f);c=Ext.util.Format.htmlEncode(c);d=Ext.util.Format.htmlEncode(f)}a.attr=String.format('ext:qtip="{0}"',c);return d},getData:function(c,a){var b;if(this.owner&&this.owner.dataStack){b=this.owner.dataStack.slice(-1).pop()[c]}return(typeof(b)!=="undefined"?b:a)}});Ext.define("SYNO.SDS.StorageManager.DisableableComboBox",{extend:"SYNO.ux.ComboBox",constructor:function(a){var d,c,b;this.disabledField=a.disabledField||"disabled";this.displayField=a.displayField||"text";b=String.format("sm-disableable-combo-disabled-{{0}}",this.disabledField);c=new Ext.XTemplate('<tpl for=".">','<div class="x-combo-list-item '+b+'">{'+this.displayField+"}</div>","</tpl>");d={tpl:c};this.callParent([Ext.apply(d,a)])},afterRender:function(){this.mon(this,"beforeselect",function(c,a,b){return !a.get(this.disabledField)},this);this.callParent(arguments)}});Ext.reg("syno_storage_disableable_combobox",SYNO.SDS.StorageManager.DisableableComboBox);Ext.define("SYNO.SDS.StorageManager.Overview.Main",{extend:"SYNO.ux.Panel",statusColors:{healthy:"#37a600",caution:"#ff7f00",danger:"#cc1414"},statusText:{healthy:_T("volume","volume_healthy"),caution:_T("volume","volume_caution"),attention:_T("volume","volume_danger")},DISPLAY_ALL_STORAGE_POOLS:"ALL",pieChartColor:{high:{startColor:"#FF737E",middleColor:"#F25056",stopColor:"#E52E2E",fontCls:"red-status"},mid:{startColor:"#FFAA00",middleColor:"#F99100",stopColor:"#F27900",fontCls:"orange-status"},low:{startColor:"#00AAFF",middleColor:"#1792F2",stopColor:"#2E7AE5",fontCls:"blue-status"}},constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.appWin;c.statusDesc={healthy:_T("volume","volume_healthy_desc"),caution:_T("volume","volume_caution_desc"),attention:_T("volume","volume_danger_desc")};c.initialized=false;c.pageIndex=1;c.totalPageCount=0;c.chart=[];c.templateHelperFunctions={hasFocusedSpaceID:function(){return c.focusedSpaceID!==c.DISPLAY_ALL_STORAGE_POOLS},isFocusedSpaceID:function(d){return c.focusedSpaceID===d},isLastElement:function(d,e){return d==e},mod:function(d,e){return d%e},notZero:function(d){return d!==0}};c.sysHealth=new Ext.DataView({cls:"sm-overview-health-container",tpl:new Ext.XTemplate('<tpl for=".">','<table class="sm-overview-health-table">','<td class="sm-overview-health-icon-container">','<div class="sm-overview-health-icon sm-overview-health-icon-{status}"></div>',"</td>",'<td class="sm-overview-health-text-desc-container">','<div class="sm-overview-health-text sm-overview-health-text-{status}">{text}</div>','<div class="sm-overview-health-desc">{desc}</div>',"</td>","</table>","</tpl>"),store:c.healthStore=new Ext.data.JsonStore({autoDestroy:true,fields:["status","text","desc"],listeners:{load:function(){if(c.repairSysLinkId){c.mon(Ext.get(c.repairSysLinkId),"click",c.repairSysConfirm,c,{single:true})}},scope:c}})});c.focusedSpaceID=c.DISPLAY_ALL_STORAGE_POOLS;c.storagePoolSelector=new SYNO.SDS.StorageManager.Overview.BorderlessComboBox({editable:false,hideLabel:true,forceSelection:true,displayField:"storagePool",valueField:"spaceID",boxClass:"sm-overview-poolSelector",store:c.storagePoolSelectorStore=new Ext.data.JsonStore({autoDestroy:true,fields:["spaceID","storagePool"],listeners:{load:{scope:c,fn:c.storagePoolSelectorStoreOnLoad}},prevSelectorData:"",loadDataOnlyIfChanged:function(f,d){var e=Ext.encode(this.prevSelectorData)!==Ext.encode(f);this.prevSelectorData=f;if(e){this.loadData(f,d)}return e}}),listeners:{select:{scope:c,fn:c.storagePoolSelected}}});c.storagePoolSelectorStore.on({load:function(e,d,f){if(!c.storagePoolSelector.isExpanded()){c.storagePoolSelector.triggerBlur()}}});c.volUsage=new SYNO.ux.FieldSet({title:_T("volume","volume_status"),collapsible:false,items:new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">','<div id="sm-overview-vol-usage">','<tpl if="Ext.isEmpty(values.volumes)">','<div class="sm-overview-no-item"><div>',_T("volume","volume_novolume"),"</div></div>","</tpl>",'<tpl if="!Ext.isEmpty(values.volumes)">','<div id="sm_overview_vol_prev" class="sm-overview-vol-prev sm-overview-vol-btn"></div>','<div id="sm_overview_vol_usage_canvas">','<tpl for="volumes">','<div id="sm_overview_vol_{idx}" class="sm-overview-vol">','<div id="sm_overview_vol_chart_{idx}" class="sm-overview-vol-chart"></div>','<div class="sm-overview-vol-details">','<div id="sm_overview_vol_name_{idx}" class="sm-overview-vol-details-text sm-overview-vol-name"></div>','<div id="sm_overview_vol_desc_{idx}" class="sm-overview-vol-details-text sm-overview-vol-desc"></div>','<div id="sm_overview_vol_hl_{idx}" class="sm-overview-vol-hl"></div>','<div id="sm_overview_vol_pool_{idx}" class="sm-overview-vol-details-text sm-overview-vol-pool"></div>','<div class="sm-overview-vol-details-text sm-overview-vol-size">','<span id="sm_overview_vol_usedSize_{idx}" class="sm-overview-vol-usedSize"></span>','<span id="sm_overview_vol_totalSize_{idx}" class="sm-overview-vol-totalSize"></span>',"</div>","</div>","</div>","</tpl>","</div>",'<div id="sm_overview_vol_next" class="sm-overview-vol-next sm-overview-vol-btn"></div>',"</tpl>","</div>","</tpl>",'<div class="x-clear"></div>',c.templateHelperFunctions),store:c.volStore=new Ext.data.JsonStore({autoDestroy:true,fields:["volCount","volumes"]})})});c.volUsage.addClass("sm-overview-fieldset");c.storagePoolSummaryGrid=new SYNO.ux.GridPanel({disableSelection:true,enableColumnHide:false,enableColumnMove:false,enableColumnResize:false,enableHdMenu:false,cls:"sm-overview-storagepoolgrid",store:c.storagePoolGridStore=new Ext.data.JsonStore({autoDestroy:true,fields:["name","status","raidType","raidSize"],listeners:{load:function(){var g=c.storagePoolSummaryGrid;var e=this;var h=34+1;var f=28+1;var d=h+f*e.getCount()+1;g.setHeight(d)}}}),colModel:new Ext.grid.ColumnModel({columns:[{dataIndex:"name",header:_T("volume","storage_pool_id"),width:2,renderer:function(h,g,d,j,f,e){var i=String.format("<b>{0} ({1})</b>",d.data.name,d.data.status);g.attr=String.format('ext:qtip="{0}"',c.prepareValueForToolTip(i));return i}},{dataIndex:"raidType",header:_T("volume","volume_raid_type"),width:2,renderer:function(h,g,d,j,f,e){var i=h.value;g.attr=String.format('ext:qtip="{0}"',c.prepareValueForToolTip(i));return i}},{dataIndex:"raidSize",header:_T("volume","volume_totalsize"),align:"right",width:1}]})});c.storagePoolDisplay=new SYNO.ux.FieldSet({title:_T("volume","volume_raid_group"),collapsible:false,items:[c.storagePoolSummaryGrid,new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">','<tpl if="Ext.isEmpty(values.storagePoolData)">','<div class="sm-overview-no-item"><div>',_T("volume","volume_nostoragepool"),"</div></div>","</tpl>",'<tpl if="this.hasFocusedSpaceID()">','<div class="sm-overview-storagepool-bounding-box">','<tpl for="storagePoolData">','<tpl if="this.isFocusedSpaceID(pool_id)">','<div class="sm-overview-storagepool-details">','<div class="sm-overview-storagepool-details-line sm-overview-storagepool-details-line-name">','<span class="sm-overview-storagepool-details-name">{name} ','(<span class=".sm-overview-storagepool-details-status">{status}</span>)</span>',"</div>",'<div class="sm-overview-storagepool-details-line sm-overview-storagepool-details-line-bar">','<div class="sm-overview-storagepool-bar">','<tpl for="childrenBar">','<div class="sm-overview-storagepool-bar-item sm-overview-storagepool-item-color{styleColor}" style="{style}" ext:qtip="{toolTip}"></div>',"</tpl>","</div>","</div>",'<div class="sm-overview-storagepool-details-line sm-overview-storagepool-details-line-type" ext:qtip="{[values.raidType.toolTip]}">',"{[values.raidType.description]}: ",'<span class="sm-overview-storagepool-details-highlight">{[values.raidType.value]}</span>',"</div>",'<div class="sm-overview-storagepool-details-line sm-overview-storagepool-details-line-size">',"{[values.raidSize.description]}: ",'<span class="sm-overview-storagepool-details-highlight">{[values.raidSize.value]}</span>',"</div>","</div>",'<div class="sm-overview-storagepool-legend">',"<div>",'<tpl for="childrenLegend">','<div class="sm-overview-storagepool-legend-line">','<div class="sm-overview-storagepool-legend-item-colorBox sm-overview-storagepool-item-color{styleColor}" ext:qtip="{toolTip}"></div>','<div class="sm-overview-storagepool-legend-item-name" ext:qtip="{toolTip}">{name}</div>','<div class="sm-overview-storagepool-legend-item-percent" ext:qtip="{toolTip}">{percent}%</div>',"</div>","</tpl>","</div>","</div>","</tpl>","</tpl>","</div>","</tpl>","</tpl>",c.templateHelperFunctions),store:c.selectedStoragePoolStore=new Ext.data.JsonStore({autoDestroy:true,fields:["storagePoolData"]})})]});c.storagePoolDisplay.addClass("sm-overview-fieldset");c.storagePoolDisplay.addClass("sm-overview-fieldset-storagepool");c.diskInfo=new SYNO.ux.FieldSet({title:_T("volume","volume_disk_information"),collapsible:false,items:new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">','<div style="clear:both;padding-left:4px;">','<tpl for="diskInfoStat">','<tpl if="this.notZero(values.count)">','<div class="sm-overview-stat sm-overview-disk-stat-bar-{type}">','<div class="sm-overview-stat-text">{text}</div>','<div class="sm-disk-stat-count sm-disk-stat-count-{type}">{count}</div>',"</div>","</tpl>","</tpl>","</div>",'<div class="x-clear"></div>','<div style="height:7px;"></div>','<tpl for="expansions">','<div class="normal-font" style="margin-left:8px;line-height:24px;">','<div style="width:229px;float:left;" ext:qtip="{snInfo}">{name}</div>',"<div>","<table>","<tr><td>",'<tpl for="disks">','<tpl if="values.hasToolTip()">','<div class="sm-overview-disk sm-overview-disk-{status} sm-overview-disk-{focusStatus}" ext:qtip="{[values.toolTip()]}"></div>',"</tpl>",'<tpl if="!values.hasToolTip()">','<div class="sm-overview-disk sm-overview-disk-{status} sm-overview-disk-{focusStatus}"></div>',"</tpl>",'<tpl if="xindex &gt; 0 && xindex %12 === 0">',"</td></tr><tr><td>","</tpl>","</tpl>","</td></tr>","</table>","</div>",'<div class="x-clear"></div>',"</div>","</tpl>",'<div class="x-clear"></div>',"</tpl>",c.templateHelperFunctions),store:c.diskStore=new Ext.data.JsonStore({autoDestroy:true,fields:["expansions","diskInfoStat"]})})});c.diskInfo.addClass("sm-overview-fieldset");b={itemId:"overview",border:false,autoFlexcroll:true,items:[c.sysHealth,c.storagePoolSelector,c.volUsage,c.storagePoolDisplay,c.diskInfo],listeners:{activate:c.onActivate,resize:{buffer:200,fn:function(){c.pageIndex=1;c.onActivate()}},scope:c}};c.callParent([Ext.apply(b,a)])},prepareValueForToolTip:function(b){if(!b){return""}var a=b.toString().replace(/<.*?>/g,"");return Ext.util.Format.htmlEncode(a)},getHelpParam:function(){return"StorageManager/overview.html"},spaceIDToString:function(c,a){a=a||"";var b=SYNO.SDS.StorageUtils.SpaceIDParser(c);return b!==""?b.str:a},sizeToString:function(a){var b=SYNO.SDS.StorageUtils.GetSizeUnit(a);return String.format("{0} {1}",b.size,b.unit)},onActivate:function(){if(!this.appWin.loaded){return}this.doLayout();this.oneBayModelComponentVisibility();this.refreshStoragePoolSelector()},refreshStoragePoolSelector:function(){var a=this.prepareStoragePoolsSelectorData();if(!this.storagePoolSelectorStore.loadDataOnlyIfChanged(a,false)){this.refreshPage()}},storagePoolSelectorStoreOnLoad:function(b,a,c){if(!a||a.length===0){return}this.refreshPage()},validateFocusedSpaceID:function(){var a=this.storagePoolSelector.findRecord(this.storagePoolSelector.valueField,this.focusedSpaceID);this.focusedSpaceID=a?this.focusedSpaceID:this.DISPLAY_ALL_STORAGE_POOLS;this.storagePoolSelector.setValue(this.focusedSpaceID)},refreshPage:function(){var b=this;this.validateFocusedSpaceID();b.prepareUiData();b.healthStore.loadData(b.uiData,false);b.diskStore.loadData(b.uiData,false);b.cleanVolUsage();b.volStore.loadData(b.uiData,false);b.selectedStoragePoolStore.loadData(b.uiData,false);b.storagePoolGridStore.loadData(b.uiData[0].storagePoolData,false);var a=b.focusedSpaceID===b.DISPLAY_ALL_STORAGE_POOLS?_T("volume","volume_raid_group"):_T("volume","storage_allocation");b.storagePoolDisplay.setTitle(a);if(b.focusedSpaceID===b.DISPLAY_ALL_STORAGE_POOLS&&!Ext.isEmpty(b.uiData[0].storagePoolData)){b.storagePoolSummaryGrid.el.enableDisplayMode().show();b.storagePoolSummaryGrid.el.setVisibilityMode(Ext.Element.VISIBILITY)}else{b.storagePoolSummaryGrid.el.enableDisplayMode().hide()}b.storagePoolSummaryGrid.setWidth(b.volUsage.getWidth()-16);if(1<b.pageCount){b.mun(Ext.get("sm_overview_vol_prev"),"click");b.mun(Ext.get("sm_overview_vol_next"),"click");b.mon(Ext.get("sm_overview_vol_prev"),"click",function(g,c,d){var f=new Ext.Element(c);if(!f.hasClass("sm-overview-vol-btn-enable")){return}--b.pageIndex;b.drawPieChart()},b);b.mon(Ext.get("sm_overview_vol_next"),"click",function(g,c,d){var f=new Ext.Element(c);if(!f.hasClass("sm-overview-vol-btn-enable")){return}++b.pageIndex;b.drawPieChart()},b)}b.drawPieChart();this.doLayout()},oneBayModelComponentVisibility:function(){var a=(this.appWin.isSingleBay()||this.appWin.isVDSM)&&!(this.appWin.isSupportEbox()&&this.appWin.isEboxPluged());this.storagePoolSelector.setVisible(!a);this.storagePoolDisplay.setVisible(!a);this.diskInfo.setVisible(!a)},storagePoolSelected:function(b,a,d,c){if(!a){return}this.focusedSpaceID=a.get("spaceID");this.refreshPage()},decidePieChartCount:function(){var b=this;b.VOL_CHART_WIDTH=100;b.VOL_DESC_WIDTH=20+185;b.VOL_TOTAL_WIDTH=b.VOL_CHART_WIDTH+b.VOL_DESC_WIDTH;b.VOL_SPACING=20;b.VOL_WIDTH_AND_SPACING=b.VOL_TOTAL_WIDTH+b.VOL_SPACING;b.VOL_LEFT_BUTTON_WIDTH=44;b.VOL_RIGHT_BUTTON_WIDTH=42;b.VOL_LEFT_NO_PAGING=b.VOL_LEFT_BUTTON_WIDTH;var a=Math.floor((b.volUsage.getWidth()-b.VOL_LEFT_NO_PAGING-b.VOL_TOTAL_WIDTH)/b.VOL_WIDTH_AND_SPACING)+1;var d=Math.floor((b.volUsage.getWidth()-b.VOL_LEFT_BUTTON_WIDTH-b.VOL_TOTAL_WIDTH-b.VOL_RIGHT_BUTTON_WIDTH)/b.VOL_WIDTH_AND_SPACING)+1;var c=b.volumesInFocusedPool;if(c.length>a){b.pieChartCount=d;b.pageCount=Math.ceil(c.length/d)}else{b.pieChartCount=c.length;b.pageCount=1}},prepareUiData:function(){var a=this,b={};delete a.uiData;delete a.volumes;a.uiData=[];a.volumes=a.appWin.volumes.getMatched("notUsedByGlusterFs");a.volumesInFocusedPool=a.appWin.volumes.getMatched(function(){return a.focusedSpaceID===a.DISPLAY_ALL_STORAGE_POOLS||this.get("pool_path")===a.focusedSpaceID});a.decidePieChartCount();a.prepareHealth(b);a.prepareSysRepair(b);a.prepareDisk(b);a.prepareVolume(b);a.prepareStoragePool(b);a.uiData.push(b)},prepareHealth:function(b){var a=this;a.systemNeedRepair=false;a.repairSysLinkId=undefined;if(a.appWin.supportRaid&&a.appWin.env.status.system_crashed){b.status="attention";b.text=a.statusText[b.status];b.desc=_T("error","error_system_abnormal_steps");if("healthy"!==b.status){return}}a.checkDataSpaceStatus(b);if("healthy"!==b.status){return}if(a.appWin.supportSas){if("yes"===_D("support_dual_head")){if(0===this.appWin.AHAInfo.link_status){b.status="caution";b.text=a.statusText[b.status];b.desc=_T("common","loading")}else{if(1!=this.appWin.AHAInfo.link_status){b.status="caution";b.text=a.statusText[b.status];b.desc=_T("volume","volume_cable_connection_abnormal")}}}else{if(!a.checkLinkValid()){b.status="caution";b.text=a.statusText[b.status];b.desc=_T("volume","volume_cable_connection_abnormal")}}if("healthy"!==b.status){return}}a.checkDiskHealth(b)},prepareSysRepair:function(b){var a=this;if(a.appWin.supportRaid){a.checkSysPartition();if(a.systemNeedRepair){a.repairSysLinkId=Ext.id();if("attention"!==b.status){b.status="caution"}b.text=a.statusText[b.status];b.desc+=String.format('{0}<a class="link-font" href="#" id="{1}">{2}</a>',_T("volume","volume_system_partition_fail_desc"),a.repairSysLinkId,_T("volume","volume_system_partition_fail_link"))}}},prepareStoragePoolsSelectorData:function(b){var a=this;var c=[{spaceID:a.DISPLAY_ALL_STORAGE_POOLS,storagePool:_T("volume","all_storage_pools")}];Ext.each(a.appWin.storagePools.getAll(),function(d){if(!d.id||d.isCreating()||d.isDeleting()){return true}c.push({spaceID:d.id,storagePool:a.spaceIDToString(d.id)})});return c},prepareDisk:function(D){var C=this,u={},B,s,n,h,r,E,x,k,e,v,z,y,w,g,b,a;var l=[{name:"attention",text:_T("volume","volume_caution")},{name:"used",text:_T("volume","volume_used_disk")},{name:"spare",text:_T("volume","volume_hot_spare_disk")},{name:"cache",text:_T("volume","volume_cache_disk")},{name:"unused",text:_T("volume","volume_unused_disk")},{name:"empty",text:_T("volume","volume_available_slot")}];var d={};var f={};Ext.each(l,function(i){d[i.name]=i.name;f[i.name]=0});var q=function(i,j){if(!j||!d.hasOwnProperty(i)){return}f[i]++};var t=C.appWin.AHAInfo;var A=function(j,i){return(j.order>i.order)?1:((j.order===i.order)?0:-1)};var c=function(j){var i=j.get("used_by");if(!C.appWin.ssdCaches.data.hasOwnProperty(i)){return null}return C.appWin.ssdCaches.data[i]};var m=function(F){var H=c(F);if(H===null){return false}var G=H.get("mountSpaceId");if(!G){return false}var j=C.appWin.volumes.getById(G);if(j===undefined){j=C.appWin.iscsiLuns.getById(G)}if(j===undefined){return false}var i=C.appWin.storagePools.getById(j.get("pool_path"));return C.focusedSpaceID===i.id};var o=function(F){var j=F.get("status");var i=F.get("overview_status");return"crashed"===j||"system_crashed"===j||"deactivated"===j||"normal"!==i};g={focusStatus:C.focusedSpaceID===C.DISPLAY_ALL_STORAGE_POOLS?"focused":"notFocused",status:"empty",displayName:"",usedBy:"",hasToolTip:function(){return this.status!=="empty"},toolTip:function(){if(!this.hasToolTip()){return""}var i=this.displayName;if(this.usedBy!==""){i+=String.format("<br />{0}",this.usedBy)}if(this.status==="attention"){i+=String.format("<br />{0}",_T("volume","volume_caution"))}return i}};D.expansions=[];D.diskInfoStat=[];Ext.each(C.appWin.disks.getAll(),function(j){if("disabled"===j.get("portType")){return true}n=j.get("container");if(j.isCacheTray()){return true}b="";if("ebox"===n.type){x=n.order;if(C.appWin.supportSas&&t){k=t.enclosures[x-1].max_disk;E=String.format("{0}-{1}",t.enclosures[x-1].model,x)}else{k=SYNO.SDS.StorageUtils.GetEboxBayNumber(n.str);if(0===k){return true}E=n.str}if(undefined!==n.chassis_sn&&""!==n.chassis_sn&&undefined!==n.module_sn&&""!==n.module_sn){b=String.format("Chassis SN: {0}</br>Module 1 SN: {1}",n.chassis_sn,n.module_sn)}}else{x=0;k=parseInt(_D("maxdisks","1"),10);E=_S("hostname")}if(!u[x]){s={bayNumber:k,name:E,disks:[],nonEmptySlot:{},snInfo:b};u[x]=s}else{s=u[x]}var i=C.focusedSpaceID===C.DISPLAY_ALL_STORAGE_POOLS||C.focusedSpaceID===j.get("used_by")||m(j);if(o(j)){v=d.attention}else{if(j.isFree()){v=d.unused}else{if("hotspare"===j.get("used_by")){v=d.spare}else{if(null!==c(j)){v=d.cache}else{v=d.used}}}}q(v,i);if(d.unused===v){r=_T("volume","unused_size")}else{if(this.appWin.isSingleBay()&&j.isInternal()){r=_T("volume","volume_disk_source_internal")}else{r=SYNO.SDS.StorageUtils.SpaceIDParser(j.get("used_by")).str}}if(i){z="focused"}else{z="notFocused"}h=SYNO.SDS.StorageUtils.DiskDisplayNameGet(j);a=j.get("pciSlot");if(0<=a){e=parseInt(j.get("order"),10)+(a*24)+k}else{e=parseInt(j.get("order"),10)}s.disks.push(Ext.applyIf({status:v,order:e,displayName:h,usedBy:r,focusStatus:z},g));s.nonEmptySlot[e]=true},C);var p=(C.focusedSpaceID===C.DISPLAY_ALL_STORAGE_POOLS);if(t){for(w=1;w<=t.enclosures.length;++w){if(!u[w]){k=t.enclosures[w-1].max_disk;E=String.format("{0} {1}",t.enclosures[w-1].model,w);s={bayNumber:k,name:E,disks:[],nonEmptySlot:{}};u[w]=s}else{s=u[w]}for(y=1;y<=s.bayNumber;++y){if(!s.nonEmptySlot[y]){q(d.empty,p);s.disks.push(Ext.applyIf({order:y},g))}}s.disks.sort(A);D.expansions.push(s)}}else{for(B in u){if(u.hasOwnProperty(B)){s=u[B];for(y=1;y<=s.bayNumber;++y){if(!s.nonEmptySlot[y]){q(d.empty,p);s.disks.push(Ext.applyIf({order:y},g))}}s.disks.sort(A);D.expansions.push(s)}}}Ext.each(l,function(i){D.diskInfoStat.push({type:i.name,text:i.text,count:f[i.name]})})},prepareVolume:function(f){var c=this,b,a;f.volCount=c.volumes.length;f.volumes=[];for(a=0;a<c.pieChartCount;++a){b={};b.style=(3>=f.volCount)?1:2;b.idx=a;f.volumes.push(b)}var h={crashed:3,degrade:2,warning:1};var e=function(j){var i=j?j.get("status"):"";return(i in h)?h[i]:0};var d=function(k){var i=k?k.get("size"):null;var j=i?parseInt(i.total,10):0;return(0===j)?0:parseInt(i.used,10)/j};var g=function(j,i){return e(i)-e(j)||d(i)-d(j)};c.volumes.sort(g);c.volumesInFocusedPool.sort(g)},prepareStoragePool:function(e){var d=this,c=d.appWin.storagePools.dataArray;var b=SYNO.SDS.StorageUtils;var a=[];Ext.each(c,function(i){var g=i.get("id");var l=i.get("size").total;var k=b.SpaceTypeRender(i.get("device_type"));var f=d.prepareValueForToolTip(k);var j={pool_id:g,name:d.spaceIDToString(g),status:b.StatusNameRender(i.get("status")),description:i.get("desc"),raidType:{description:_T("volume","volume_raid_type"),value:k,toolTip:f,toString:function(){return this.value}},raidSize:{description:_T("volume","volume_totalsize"),value:d.sizeToString(l),toString:function(){return this.value}}};if(g===d.focusedSpaceID){var h=d.getStoragePoolChildData(i);j.childrenBar=d.getStoragePoolChildBar(h);j.childrenLegend=d.getStoragePoolChildLegend(h)}a.push(j)});e.storagePoolData=a},deepCopy:function(a){return JSON.parse(JSON.stringify(a))},getStoragePoolChildBar:function(b){var d=this.deepCopy(b);for(var a=d.length-1;a>=0;a--){var c=d[a];if(c.percent<0.1){d.splice(a,1);continue}else{c.style=String.format("width: {0}%;",c.percent)}}d[d.length-1].style="";return d},getStoragePoolChildLegend:function(a){var d=this.deepCopy(a);if(d.length<=1){return d}d.pop();var b=0;Ext.each(d,function(e){b+=e.percent});if(b>100){var c=d[d.length-1];c.percent=Math.max(c.percent-(b-100),0)}Ext.each(d,function(e){e.percent=e.percent.toFixed(1)});return d},getStoragePoolChildData:function(e){var g=this,i=SYNO.SDS.StorageUtils;var j=5;var c=[];var a=e.get("size").total;var b={name:"",size:0,percent:function(){return Math.round(1000*this.size/a)/10},sizeToString:function(){return g.sizeToString(this.size)},toolTip:function(){return String.format("{0}<br>{1}",this.name,this.sizeToString())}};if(e.supportMultiple()){Ext.each(e.get("pool_child"),function(l){c.push(Ext.applyIf({name:l.hasOwnProperty("name")?l.name:i.getVolumeNames(l.id),size:parseInt(l.size.total,10)},b))})}else{if(e.isDeploy()){c.push(Ext.applyIf({name:i.getVolumeNames(e.get("deploy_path")),size:e.get("size").total},b))}}c.sort(function(m,l){var n=l.size-m.size;if(n!==0){return n}return m.name>l.name?1:-1});if(c.length>j){var d=Ext.applyIf({name:_T("volume","others")},b);while(c.length>=j){var f=c.pop(j-1);d.size+=f.size}c.push(d)}var k=Ext.applyIf({name:_T("volume","volume_freesize"),size:a,unusedPercent:100,percent:function(){return this.unusedPercent},removeChildSlice:function(l){this.size-=l.size;this.unusedPercent-=l.percent()}},b);Ext.each(c,function(l){k.removeChildSlice(l)});c.push(k);var h=[];Ext.each(c,function(m,l){h.push({name:m.name,percent:m.percent(),toolTip:m.toolTip(),styleColor:(l+1)%c.length})});return h},drawPieChart:function(){var z=this,e=0,c,a,v,o,g,p,x,d,A,n,y=SYNO.SDS.StorageUtils,h,s,t,j,m,w=z.volumesInFocusedPool,b=Ext.get("sm_overview_vol_usage_canvas"),f=Ext.get("sm_overview_vol_prev"),r=Ext.get("sm_overview_vol_next");if(!b){return}z.pageIndex=(z.pageIndex>z.pageCount)?z.pageCount:z.pageIndex;z.pageIndex=(1>z.pageIndex)?1:z.pageIndex;c=(z.pageIndex-1)*z.pieChartCount;a=(w.length<c+z.pieChartCount)?w.length:c+z.pieChartCount;x=a-c;if(1<z.pageCount){b.setStyle("margin-left",z.VOL_LEFT_BUTTON_WIDTH+"px");f.show();r.show();if(1===z.pageIndex){f.removeClass("sm-overview-vol-btn-enable");if(!r.hasClass("sm-overview-vol-btn-enable")){r.addClass("sm-overview-vol-btn-enable")}}else{if(z.pageIndex===z.pageCount){r.removeClass("sm-overview-vol-btn-enable");if(!f.hasClass("sm-overview-vol-btn-enable")){f.addClass("sm-overview-vol-btn-enable")}}else{if(!f.hasClass("sm-overview-vol-btn-enable")){f.addClass("sm-overview-vol-btn-enable")}if(!r.hasClass("sm-overview-vol-btn-enable")){r.addClass("sm-overview-vol-btn-enable")}}}}else{b.setStyle("margin-left",z.VOL_LEFT_NO_PAGING+"px");b.setStyle("left","");f.hide();r.hide()}z.cleanVolUsage();for(;c<a;++c){v=w[c];o=v.get("size");if(0===parseInt(o.total,10)){g=0}else{g=parseInt(o.used,10)/parseInt(o.total,10)}if(g>0.9){p="high"}else{if(g>0.8){p="mid"}else{p="low"}}d=z.pieChartColor[p];A=String.format("sm_overview_vol_chart_{0}",e);n=new SYNO.SDS.StorageManager.Overview.AdvancedCircleGradient({criticalPercent:1-z.appWin.env.volume_full_critical,warningPercent:1-z.appWin.env.volume_full_warning,renderTo:A});n.draw(Math.min(g,1));z.chart.push(n);h=String.format("{0} ({1})",y.SpaceIDParser(v.get("id")).str,y.StatusNameRender(v.getStatus()));s=v.get("desc");t=z.spaceIDToString(v.get("pool_path"),_T("volume","volume_disk_source_internal"));j=z.sizeToString(o.used);m=String.format(" / {0}",z.sizeToString(o.total));A=String.format("sm_overview_vol_name_{0}",e);Ext.get(A).update(h);Ext.get(A).set({"ext:qtip":h});A=String.format("sm_overview_vol_desc_{0}",e);if(!s){Ext.get(A).update("-")}else{Ext.get(A).update(s);Ext.get(A).set({"ext:qtip":s})}A=String.format("sm_overview_vol_hl_{0}",e);Ext.get(A).setStyle("opacity","1");A=String.format("sm_overview_vol_pool_{0}",e);Ext.get(A).update(t);A=String.format("sm_overview_vol_usedSize_{0}",e);Ext.get(A).update(j);var l=n.getColorByPercentUsed(Math.min(g,1));if(l&&l.fontColor){Ext.get(A).setStyle("color",l.fontColor)}A=String.format("sm_overview_vol_totalSize_{0}",e);Ext.get(A).update(m);e++}if(1===x){var k=this.volUsage.getWidth()-this.VOL_LEFT_BUTTON_WIDTH-this.VOL_RIGHT_BUTTON_WIDTH-this.VOL_CHART_WIDTH;Ext.get("sm_overview_vol_name_0").setWidth(k);Ext.get("sm_overview_vol_desc_0").setWidth(k);for(var u=1;u<this.pieChartCount;u++){var q=Ext.get(String.format("sm_overview_vol_{0}",u));if(q){q.setStyle("display","none")}}}},cleanVolUsage:function(){var b=this,a;for(a=0;a<this.pieChartCount;a++){if(b.chart[a]){b.chart[a].destroy();delete b.chart[a]}if(Ext.get(String.format("sm_overview_vol_{0}",a))){Ext.get(String.format("sm_overview_vol_{0}",a)).setStyle("display","")}if(Ext.get(String.format("sm_overview_vol_chart_{0}",a))){Ext.get(String.format("sm_overview_vol_chart_{0}",a)).update("")}if(Ext.get(String.format("sm_overview_vol_name_{0}",a))){Ext.get(String.format("sm_overview_vol_name_{0}",a)).update("");Ext.get(String.format("sm_overview_vol_name_{0}",a)).setWidth("");if(typeof Ext.get(String.format("sm_overview_vol_name_{0}",a)).dom!=="undefined"){Ext.get(String.format("sm_overview_vol_name_{0}",a)).dom.removeAttribute("ext:qtip")}}if(Ext.get(String.format("sm_overview_vol_desc_{0}",a))){Ext.get(String.format("sm_overview_vol_desc_{0}",a)).update("");Ext.get(String.format("sm_overview_vol_desc_{0}",a)).setWidth("");if(typeof Ext.get(String.format("sm_overview_vol_desc_{0}",a)).dom!=="undefined"){Ext.get(String.format("sm_overview_vol_desc_{0}",a)).dom.removeAttribute("ext:qtip")}}if(Ext.get(String.format("sm_overview_vol_hl_{0}",a))){Ext.get(String.format("sm_overview_vol_hl_{0}",a)).setStyle("opacity","0")}if(Ext.get(String.format("sm_overview_vol_pool_{0}",a))){Ext.get(String.format("sm_overview_vol_pool_{0}",a)).update("")}if(Ext.get(String.format("sm_overview_vol_usedSize_{0}",a))){Ext.get(String.format("sm_overview_vol_usedSize_{0}",a)).update("")}if(Ext.get(String.format("sm_overview_vol_totalSize_{0}",a))){Ext.get(String.format("sm_overview_vol_totalSize_{0}",a)).update("")}}b.chart=[]},checkSpaceStatus:function(b,e){var d=this,a="healthy",c;Ext.each(b,function(f){if(f.isLogicalVolume()){if(f.isVolume()){c=d.appWin.storagePools.data[f.get("pool_path")];if(c.isDegrade()||c.isCrashed()){return true}}else{return true}}if(f.isCrashed()){a="attention";return false}if(f.isDegrade()){a="caution"}},d);e.status=a;e.text=d.statusText[a];e.desc=d.statusDesc[a]},checkSsdCacheStatus:function(c,e){var d=this,a="healthy",b=true;Ext.each(c,function(f){if("write"===f.get("mode")&&f.isDegrade()){a="caution"}else{if(f.isCrashed()){switch(f.get("mode")){case"read":case"write_bypass":a="caution";b=false;break;case"write_crash":a="attention";return false;default:SYNO.Debug.error("no such cache mode: ",f.get("mode"))}}}},d);e.status=a;e.text=d.statusText[a];e.desc=("caution"===a&&!b)?_T("volume","ssd_cache_crash_no_need_backup_desc"):d.statusDesc[a]},checkDataSpaceStatus:function(f){var b={},d={},c={},a={},e=this;e.checkSpaceStatus(e.volumes,b);e.checkSpaceStatus(e.appWin.storagePools.getAll(),d);if(e.appWin.supportSsdCache){e.checkSsdCacheStatus(e.appWin.ssdCaches.getAll(),c)}if("attention"===b.status){a=b}else{if("attention"===d.status){a=d}else{if("attention"===c.status){a=c}else{if("caution"===b.status){a=b}else{if("caution"===d.status){a=d}else{if("caution"===c.status){a=c}else{a=b}}}}}}f.status=a.status;f.text=a.text;f.desc=a.desc},checkSysPartition:function(){var d=this,b=d.appWin.env.status;var c;var a=SYNO.SDS.StorageUtils;d.systemNeedRepair=b.system_need_repair;if(!d.systemNeedRepair){return}var e="";for(c=0;c<b.suggestions.length;c++){e+=String.format('<span class="red-status">{0}</span><br>',a.FormatSuggestion(b.suggestions[c]))}d.sysPartitionFailHtml=e},checkLinkValid:function(){var a=this,b=true;Ext.each(a.appWin.enclosures.getAll(),function(c){var d=c.get("ports");if(c.get("internal")){if(0===d.length||1===d.length){return true}if(d[0].linkId!==d[1].linkId||1!==d[0].portNum||2!==d[1].portNum){b=false}}else{if(2===d.length){return true}if(d[0].linkId!==d[1].linkId||d[2].linkId!==d[3].linkId||3!==d[2].portNum||4!==d[3].portNum){b=false}}return b},a);return b},checkDiskHealth:function(d){var c=this;var a=c.appWin.disks.getAll();var b="";Ext.each(a,function(e){if("failing"===e.get("overview_status")){b="failing";return false}else{if("critical"===e.get("overview_status")){if("failing"!==b){b="critical"}}else{if("normal"!==e.get("overview_status")){if("failing"!==b&&"critical"!==b){b="warning"}}}}},c);if(""!==b){switch(b){case"warning":d.desc=_T("disk_info","overview_status_disk_warning");break;case"critical":d.desc=_T("disk_info","overview_status_disk_critical");break;case"failing":d.desc=_T("disk_info","overview_status_disk_failing");break;default:SYNO.Debug.error("no such status",b);return}d.status="caution";d.text=c.statusText[d.status]}},repairSysConfirm:function(){var a=this.owner.getMsgBox();a.confirm(_T("volume","volume_adddisk2_type_repair"),this.sysPartitionFailHtml,this.repairSysPartition,this,{ok:_T("volume","volume_adddisk2_type_repair"),cancel:_T("common","cancel")})},repairSysPartition:function(a){var b=this;if("ok"!==a){return}b.owner.setStatusBusy();b.owner.cleanMask=true;b.appWin.stopPollTask();SYNO.API.Request({api:"SYNO.Storage.CGI.Storage",method:"repair_system_partition",version:1,callback:function(f,c,e,d){b.owner.clearStatusBusy();if(!f){b.owner.getMsgBox().alert(this.title,_T("common","commfail"))}b.appWin.startPollTask()},scope:b})}});Ext.define("SYNO.SDS.StorageManager.Overview.AdvancedCircleGradient",{extend:"SYNO.SDS.Utils.canvas.circlegradient",constructor:function(a){var c=this;var d=48;var b=d*2;a=a||{};Ext.applyIf(a,{radius:d,gradientWidth:11,innerCircleWidth:7,fillColor:"#DFE2E5",arcBorderColor:"#FFFFFF",criticalPercent:0.9,warningPercent:0.8,colors:{critical:{fallbackColor:"#E53232",stopColor:"#FF7272",middleColor:"#E53232",startColor:"#FF7272",fontColor:"#F03434"},warning:{fallbackColor:"#FF6833",stopColor:"#FFA733",middleColor:"#FF6833",startColor:"#FFA733",fontColor:"#F25B24"},normal:{fallbackColor:"#0086E5",stopColor:"#00BCD9",middleColor:"#0086E5",startColor:"#00BCD9",fontColor:"#0086E5"},zero:{fallbackColor:"#96A0AA",stopColor:"#96A0AA",middleColor:"#96A0AA",startColor:"#96A0AA",fontColor:"#96A0AA"}},height:b,width:b,canvasConfig:{height:b,width:b}});a.criticalPercent=this.sanitizePercentage(a.criticalPercent);a.warningPercent=this.sanitizePercentage(a.warningPercent);c.callParent(arguments)},getColorByPercentUsed:function(a){if(!this.colors){return{}}a=this.sanitizePercentage(a);if(a>=this.criticalPercent&&this.colors.critical){return this.colors.critical}else{if(a>=this.warningPercent&&this.colors.warning){return this.colors.warning}else{if(a<0.01&&this.colors.zero){return this.colors.zero}else{if(this.colors.normal){return this.colors.normal}}}}return{}},applyColorByPercent:function(a){Ext.apply(this,this.getColorByPercentUsed(a))},sanitizePercentage:function(b){var a=Ext.isNumber(b)?Math.max(Math.min(b,1),0):1;return Math.round(a*100)/100},getCtx:function(){var b=this;var a=b.callParent(arguments);if(typeof a!=="undefined"){return a}return b.getCanvas().getContext("2d")},getRadiusCenter:function(){return(this.radius-this.lineWidth/2)},setupCanvas:function(){var g=this,f=g.getCanvas(),c=f.getContext("2d"),e=g.getRatio(c),d=g.lineWidth*e,b=g.getRadiusCenter()*e,a=d%2;g.setCanvasSize(f,c,e);g.clearCanvas(c);c.translate(d/2,d/2);c.save();g.ctx=c;c.beginPath();c.rect(-d,-d,b*2+d*2+a,b*2+d*2+a);c.clip()},drawInnerCircle:function(){var f=this,c=f.getCtx(),e=f.getRatio(c),d=f.lineWidth*e,b=f.innerCircleWidth*e,a=f.getRadiusCenter()*e;c.lineWidth=b;if(Ext.isDefined(f.fillColor)){c.strokeStyle=f.fillColor;c.beginPath();c.arc(a*1,a*1,a*1,Math.PI*0,Math.PI*2,true);c.stroke();c.restore()}c.lineWidth=d},innerDraw:function(){var a=this;a.setupCanvas();a.drawInnerCircle()},drawArcBorder:function(f){var h=this,j=h.getCanvas(),i=j.getContext("2d"),g=h.getRatio(i),a=h.lineWidth*g,c=h.getRadiusCenter()*g,k=2*Math.PI/360,e=-90,d=(-1+e)*k,b=(360*f+1+e)*k;i.lineWidth=a;if(Ext.isDefined(h.arcBorderColor)){i.strokeStyle=h.arcBorderColor;i.beginPath();i.arc(c*1,c*1,c*1,d,b,false);i.stroke();i.restore()}},draw:function(c){var b=this,a;b.value=c;c=b.sanitizePercentage(c);b.applyColorByPercent(c);b.updateLabel(c);b.innerDraw();if(c>0){b.drawArcBorder(c)}a=b.getCtx();b.draw0To50Arc(a,c);if(c>0.5){b.draw50To100Arc(a,c)}}});Ext.define("SYNO.SDS.StorageManager.Overview.BorderlessComboBox",{extend:"SYNO.ux.ComboBox",constructor:function(b){var d=this;b=b||{};b=Ext.applyIf(b,{listWidth:30,width:150,arrowOffset:39,borderless:true,boxClass:"",cls:"",triggerClass:"",disabledClass:"",hoverClass:"",clickClass:""});var a={boxClass:"borderless-combobox",cls:"borderless-combobox-text",triggerClass:"borderless-combobox-arrow",disabledClass:"borderless-combobox-disabled",hoverClass:"borderless-combobox-hover",clickClass:"borderless-combobox-click"};for(var c in a){if(a.hasOwnProperty(c)){b[c]=String.format("{0} {1}",b[c]?b[c]:"",a[c]).trim()}}d.callParent(arguments);d.getStore().on({load:d.updateListWidth,scope:d});d.on({select:d.updateWidth,afterrender:d.addClasses,scope:d});if(this.borderless){d.on({afterrender:d.removeBorder,scope:d})}},getTextElement:function(){return this.getEl()},getTextDom:function(){var a=this.getTextElement();return a?Ext.getDom(a):null},getArrowElement:function(){var a=this.getTextDom();return a?Ext.get(a.nextSibling):null},getBoxElement:function(){var a=this.getTextDom();return a?Ext.get(a.parentNode):null},addClasses:function(){var b=this.getBoxElement();if(b){b.addClass(this.boxClass)}var c=this.getTextElement();var a=this.getArrowElement();if(!c||!a){return}b.addClassOnOver(this.hoverClass);b.addClassOnClick(this.clickClass);c.addClassOnOver(this.hoverClass);c.addClassOnClick(this.clickClass);a.addClassOnOver(this.hoverClass);a.addClassOnClick(this.clickClass)},removeBorder:function(){var b=this.getTextElement();var a=this.getArrowElement();if(!b||!a){return}b.setStyle("border-width","0px");b.setStyle("border-image-width","0px");b.setStyle("box-shadow","none");a.setStyle("border-width","0px");a.setStyle("border-image-width","0px");a.setStyle("box-shadow","none")},getTextWidth:function(c){var b=this.getTextElement();if(!c||!b){return 0}var a=new Ext.util.TextMetrics.createInstance(b);return a.getWidth(c)},updateWidth:function(){var a=this.findRecord(this.valueField,this.getValue());var c=a.get(this.displayField);var b=this.getTextWidth(c);this.setWidth(b+this.arrowOffset)},updateListWidth:function(){var b=this;var a=0;this.getStore().each(function(c){a=Math.max(a,b.getTextWidth(c.get(b.displayField)))});b.listWidth=a+this.arrowOffset;this.updateWidth()},setValue:function(a){this.callParent(arguments);this.updateWidth()}});SYNO.SDS.StorageManager.Wizard.DiskStep=function(a){if(!a.appWin.supportRaidGroup||a.isSHR){return new SYNO.SDS.StorageManager.Wizard.ClassicDiskStep(a)}else{return new SYNO.SDS.StorageManager.Wizard.AdvDiskStep(a)}};Ext.define("SYNO.SDS.StorageManager.Wizard.ClassicDiskStep",{extend:"SYNO.SDS.StorageManager.Wizard.Step",space:null,allowBlank:false,filter:undefined,free_disks:null,free_disks_for_expand:null,disks:null,defaultChecked:true,constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;c.space=a.space||null;c.validator=c.diskChooserValidater;c.skipCheck=false;b={headline:_T("volume","volume_add_diskselect"),labelWidth:200,items:[{xtype:"syno_displayfield",name:"hint",value:_T("volume","volume_need_no_disk_tip")},c.createGrid({itemId:"disks"})],listeners:{beforeshow:this.onBeforeshow,scope:this}};c.callParent([Ext.apply(b,a)])},createGrid:function(a){var c=new SYNO.ux.EnableColumn({dataIndex:"enabled",id:"enable",bindRowClick:true,sortable:true,align:"center"});var b=Ext.apply({enableHdMenu:false,layout:"fit",cls:"without-dirty-red-grid",plugins:c,columns:[c,{header:_T("volume","volume_disknumber"),dataIndex:"nameHashValue",sortable:true,width:200,renderer:function(h,e,d,j,g,f,i){return d.data.name}},{header:_T("volume","volume_diskmodel"),dataIndex:"model",sortable:true,width:200},{header:_T("volume","volume_disk_type"),dataIndex:"diskType",sortable:true,width:100},{header:_T("volume","4k_hdd"),dataIndex:"is4Kn",sortable:true,width:60,renderer:function(d){if(d){return _T("common","yes")}return _T("common","no")}},{header:_T("volume","volume_diskcapacity"),dataIndex:"size_total",width:140,sortable:true,renderer:function(h,e,d,j,g,f,i){return SYNO.SDS.StorageUtils.SizeRender(h)}}],store:this.disks=new Ext.data.JsonStore({autoDestroy:true,fields:["id","enabled","name","model","size_total","container","numId","diskType","is4Kn","nameHashValue"],listeners:{update:function(d,e,f){if(Ext.data.Record.EDIT!==f){return}if(!this.allowBlank){this.onRecordUpdate()}},scope:this}})},a);return new SYNO.ux.GridPanel(b)},loadDisks:function(){var d=this;var a=SYNO.SDS.StorageUtils;var c=d.defaultChecked;var b=this.getSource();var e=[];Ext.each(d.free_disks,function(f){if("internal"===b&&!f.isInternal()){return true}if("ebox"===b&&!f.isInEbox()){return true}e.push({enabled:c,id:f.get("id"),num_id:f.get("num_id"),name:f.get("name"),nameHashValue:a.DiskNameHashValueGet(f.get("container").order,f.get("num_id"),f.get("portType")),model:f.get("model"),size_total:parseInt(f.get("size_total"),10),container:f.get("container"),diskType:f.get("isSsd")?"SSD":"HDD",is4Kn:f.get("is4Kn")})});e.sort(function(g,f){if(g.container.order>f.container.order){return 1}if(g.container.order<f.container.order){return -1}if(g.num_id>f.num_id){return 1}if(g.num_id<f.num_id){return -1}return 0});d.disks.loadData(e,false);d.getComponent("disks").setHeight(45+e.length*28)},getAvailableDisksForAdd:function(b){var f=this;var e=this.owner.getPoolObject();var i=e.get("minimal_disk_size");var a=e.get("container");var g=[];var c=[];var h=false;var d=function(j){if(-1===e.get("device_type").indexOf("shr")||"expand_by_disk"!==b){return j.isBiggerThan(i)}return j.isBiggerThan(i)||j.isEqualToAny(c)};if(!a||!e.get("can_do")){return g}e.get("disks").each(function(j){var k=f.appWin.disks.data[j];if(!k){return true}if(k.is4Kn()){h=true}c.push(parseInt(k.get("size_total"),10))},this);if(e.get("can_do").raid_cross||e.isExpansion()){g=f.appWin.disks.getMatched(function(){return this.isNormalTray()&&this.isFree()&&d(this)&&((this.is4Kn()&&h)||(!this.is4Kn()&&!h))})}else{if("internal"===a){g=f.appWin.disks.getMatched(function(){return this.isNormalTray()&&this.isFree()&&this.isInternal()&&d(this)&&((this.is4Kn()&&h)||(!this.is4Kn()&&!h))})}else{if("ebox"===a){g=f.appWin.disks.getMatched(function(){return this.isFree()&&this.isInEbox()&&d(this)&&((this.is4Kn()&&h)||(!this.is4Kn()&&!h))})}}}return g},showAllowEmptyHint:function(a){SYNO.SDS.Utils.DisplayField(this.getForm(),"hint",a)},isInternal:function(a){return"internal"===a.get("container").type},isNeedCrossWarning:function(){var c=false;var d=false;var b,a;if(this.space){a=this.space.get("container");if("cross"===a){return false}if("internal"===a){c=true}else{d=true}}for(b=0;b<this.disks.getCount();b++){if(!this.disks.getAt(b).get("enabled")){continue}if(this.isInternal(this.disks.getAt(b))){c=true}else{d=true}if(c&&d){return true}}return false},isNeedPowerButtonDisableWarning:function(){for(var a=0;a<this.disks.getCount();a++){if(!this.disks.getAt(a).get("enabled")){continue}if(this.disks.getAt(a).get("container").supportPwrBtnDisable){return true}}return false},isSelectAny:function(){for(var a=0;a<this.disks.getCount();a++){if(this.disks.getAt(a).get("enabled")){return true}}return false},getIds:function(){var a=[];this.disks.each(function(b){if(b.get("enabled")){a.push(b.id)}});return a},getNames:function(){var a=[];this.disks.each(function(b){if(b.get("enabled")){a.push(b.get("name"))}});return a},getDisks:function(){var a=[];this.disks.each(function(b){if(b.get("enabled")){a.push(b)}});return a},getStore:function(){return this.disks},getSource:function(){if(this.space&&!this.appWin.isSupportRaidCross){return this.space.get("container")}return this.getData("disk_source","all")},diskChooserValidater:function(){var e=this;var j=this.getData("manage_action","create");var c=this.getData("raid_level");var f=this.getDisks();var d=f.length;var h=false,i=false,g=false;var a,b;if("create"!==j){a=this.owner.getPoolObject()}b=this.getDiskCountLimit(a,j);if(0<b.max&&d>b.max){this.owner.getMsgBox().alert(this.owner.title,String.format(_T("volume","volume_max_disks_count"),b.max));return false}if(d<b.min){this.owner.getMsgBox().alert(this.owner.title,String.format(_T("volume","volume_min_disk_count"),b.min));return false}if("create"===j&&"raid_10"===c&&0!==d%2){this.owner.getMsgBox().alert(this.owner.title,_T("volume","raid10_constrain"));return false}if(a){if(this.isDiskExceedMax(f,a)){this.owner.getMsgBox().alert(this.owner.title,_T("volume","volume_disk_3tb_limitation"));return false}Ext.each(a.get("disks"),function(k){h=e.appWin.disks.data[k].is4Kn();return false});Ext.each(f,function(k){if(k.get("is4Kn")){i=true}else{g=true}});if((h&&g)||(!h&&i)){this.owner.getMsgBox().alert(this.owner.title,_T("volume","not_allow_hybrid_hdd"));return false}}return true},getDiskCountLimit:function(f,g){var e=f?f.get("can_do"):{};var h=this.getData("migrate_type");var c=this.getData("raid_level");var d=0;var a=0;switch(g){case"create":a=SYNO.SDS.StorageUtils.RAIDDiskMinMaxCountGet(c).min;d=SYNO.SDS.StorageUtils.RAIDDiskMinMaxCountGet(c).max;break;case"repair":d=e.repair;break;case"expand":a=e.expand;break;case"convert_shr_to_pool":a=e.convert_shr_to_pool;break;case"expand_unfinished_shr":switch(this.getData("shr_operation")){case"add_disk":case"hotspare_repair":a=0;break;case"migrate_to_shr2":a=e.expand_unfinished_shr.migrate_to_shr2;break}break}if(Ext.isDefined(h)){switch(h){case"add_mirror":d=e.migrate.add_mirror;break;case"to_raid1":d=e.migrate.to_raid1;break;case"to_raid5+spare":var b=e.migrate["to_raid5+spare"].split("-");a=parseInt(b[0],10);d=parseInt(b[1],10);break;case"to_raid5":a=e.migrate.to_raid5;break;case"to_raid6":a=e.migrate.to_raid6;break;case"to_shr2":a=e.migrate.to_shr2;break}}return{max:d,min:a}},isDiskExceedMax:function(a,d){var c=parseInt(d.get("maximal_disk_size"),10);var e=0;if(undefined===c||0===c){return false}for(var b=0;b<a.length;b++){e=parseInt(a[b].get("size_total"),10);if(c<e){return true}}return false},onBeforeshow:function(){this.showAllowEmptyHint(this.allowBlank)},activate:function(){var a=this;var d=this.getData("wizard_mode");var b=this.getData("manage_action");var c;this.skipCheck=false;if(d==="pool_manage"){a.addType=b}c=this.getSource();if(a.diskSource==c){return}a.diskSource=c;a.allowBlank=this.getData("allow_disk_blank",false);a.defaultChecked=this.getData("disk_default_checked",true);if(d==="pool_manage"){a.free_disks=this.getAvailableDisksForAdd(b)}else{a.free_disks=a.appWin.disks.getMatched("isNormalTray","isFree")}a.showAllowEmptyHint(a.allowBlank);a.loadDisks();if("pool_manage"===d&&this.defaultChecked){this.defaultChecked=false}a.owner.doLayout()},onRecordUpdate:function(){if(this.allowBlank||this.isSelectAny()){this.owner.getButton("next").enable()}else{this.owner.getButton("next").disable()}},updateData:function(a){a.disk_ids=this.getIds();a.disk_groups=[]},beforeNext:function(){var f=this,c="",e;var a=false;var d=false;var g=this.getDisks(),h=false,i=false;if(this.skipCheck){return true}e=this.getIds().length;if(Ext.isFunction(this.validator)){if(!this.validator()){return false}}Ext.each(g,function(j){if(!j.get("is4Kn")){h=true}else{i=true}});if(h&&i){this.owner.getMsgBox().alert(this.owner.title,_T("volume","not_allow_hybrid_hdd"));return false}if(e===0&&this.allowBlank){return true}if(!this.raidGroup&&this.isNeedCrossWarning()){c+=String.format("1. {0}<p>2. {1}",_T("volume","volume_mix_disks_warning"),_T("volume","volume_adddisk_type_two_warning"));d=true}else{c+=_T("volume","volume_adddisk_type_two_warning");d=false}if(!this.raidGroup&&this.isNeedPowerButtonDisableWarning()){a=true}else{a=false}var b=new SYNO.SDS.StorageManager.Volume.Dialog.SpaceCreationWarningWindow({owner:this.owner,warningMsg:c,showPwrChk:a,next_id:this.getNext(),isCrossRAID:d,callBack:function(j){if(j){f.skipCheck=true}}});b.open();return false},deactivate:function(){this.owner.getButton("next").enable()},summary:function(a){if(this.getNames().length>0){a.append(_T("volume","volume_apply_disk"),this.getNames().join(", "))}}});Ext.define("SYNO.SDS.StorageManager.Wizard.PoolFromStep",{extend:"SYNO.SDS.StorageManager.Wizard.Step",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.loaded=false;b={headline:_T("volume","volume_choose_raid_title"),items:[{xtype:"syno_displayfield",htmlEncode:false,value:_T("volume","choose_pool_from_step_description")},{xtype:"syno_displayfield",cls:"sm-empty-line"},{xtype:"syno_radio",boxLabel:_T("volume","volume_choose_existing_raid"),name:"poolstep",itemId:"existing",inputValue:"existing",checked:true},{xtype:"syno_radio",boxLabel:_T("volume","volume_create_raid"),name:"poolstep",itemId:"create",inputValue:"create"}]};c.callParent([Ext.apply(b,a)])},activate:function(){var c=this;var b,a;if(c.loaded){return}b=c.appWin.storagePools.getMatched("isFreeSizeBiggerThan1GB","isWritable","notUsedByGlusterFs");a=c.appWin.disks.getMatched("isNormalTray","isFree");if(0===a.length){c.getComponent("create").disable()}else{c.getComponent("create").enable();c.getComponent("create").setValue(true)}if(0===b.length){c.getComponent("existing").disable()}else{c.getComponent("existing").enable();c.getComponent("existing").setValue(true)}c.loaded=true},updateData:function(a){a.pool_from=this.getValues()},getNext:function(){return this.nextId[this.getForm().getValues().poolstep]},getValues:function(){return this.getForm().getValues().poolstep},summary:function(a){}});Ext.define("SYNO.SDS.StorageManager.Wizard.VolumePropertyStep",{extend:"SYNO.SDS.StorageManager.Wizard.Step",constructor:function(b){var e=this,d;e.appWin=b.appWin;e.deviceType=undefined;e.maxFreeSizeGB=undefined;e.minSizeGB=10;e.maxVolumeByte=parseInt(e.appWin.getMaxVolumeSize(),10);e.maxFreeSizeByte=undefined;e.maxFreeSizeGB=undefined;e.sizeValueInput=undefined;e.deviceType=b.deviceType;e.setDefaultDesc=true;var a=_T("volume","volume_allocate_size_field_name");var c=_T("volume","volume_totalsize");if(e.deviceType=="lun"){a=_T("iscsilun","iscsilun_allocate_size_field_name");c=_T("iscsilun","iscsilun_totalsize")}d={headline:_T("volume","volume_allocate_size_title"),items:[{xtype:"syno_displayfield",fieldLabel:_T("common","name"),itemId:"pool_name"},{xtype:"syno_textfield",itemId:"desc",name:"desc",fieldLabel:_T("share","share_comment"),width:300,maxLength:64,enableKeyEvents:true,value:"",listeners:{keypress:function(){this.setDefaultDesc=false},scope:this}},{xtype:"syno_displayfield",fieldLabel:_T("volume","volume_totalsize"),itemId:"pool_total"},{xtype:"syno_displayfield",fieldLabel:_T("volume","volume_freesize"),itemId:"pool_free"},{indent:0,xtype:"panel",layout:"hbox",itemId:"size",border:false,fieldLabel:String.format("{0} ({1})",a,_T("common","size_gb")),labelStyle:"line-height: 28px;padding:0px;",bodyStyle:{padding:"0px 0px 0px 0px"},items:[{xtype:"syno_numberfield",allowDecimals:false,width:100,value:"10",itemId:"size_value"},{xtype:"syno_displayfield",width:10,value:" "},{xtype:"syno_button",itemId:"size_max",text:_T("common","max"),handler:function(g,f){this.SizeValueInput.setValue(this.maxFreeSizeGB)},scope:this}]}]};this.callParent([Ext.apply(d,b)])},getEstimatedSize:function(){var a=this;var b=this.getData("raid_type")==="multiple";a.owner.setStatusBusy();a.owner.getButton("next").disable();SYNO.API.Request({api:"SYNO.Storage.CGI.Pool",method:"estimate_size",version:1,params:{estimate_for:"create",disk_id:a.owner.getDiskIds(),device_type:a.owner.getRaidLevel()},callback:function(h,g,f,c){var d,e;a.owner.clearStatusBusy();if(!h){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,g);a.owner.getButton("next").disable();return}d=e=g.size;if(b){d=Math.min(a.maxVolumeByte,d)}a.updatePoolInfo({freeByte:d,totalByte:e,poolId:g.new_pool_path})},scope:a})},getPoolSize:function(a){var c=this.appWin.storagePools.data[a];var b=c.get("size");var f=parseInt(b.used,10);var e=parseInt(b.total,10);var d=e-f;if(c.supportMultiple()){d=Math.min(this.maxVolumeByte,d)}this.updatePoolInfo({freeByte:d,totalByte:e,poolId:a})},updatePoolInfo:function(b){var a=SYNO.SDS.StorageUtils;this.maxFreeSizeGB=a.GetSizeGB(b.freeByte,0);this.maxFreeSizeByte=b.freeByte;this.getComponent("pool_name").setValue(a.SpaceIDParser(b.poolId).str);this.getComponent("pool_total").setValue(a.SizeRender(b.totalByte,2));this.getComponent("pool_free").setValue(String.format("{0} {1}",this.maxFreeSizeGB,_T("common","size_gb")));this.SizeValueInput.setValue(this.maxFreeSizeGB);if("single"===this.getData("raid_type")){this.SizeValueInput.disable()}else{this.SizeValueInput.enable()}this.updateDesc()},updateDesc:function(){var a;var b="";if(!this.setDefaultDesc){return}b+=String.format(_T("volume","volume_default_desc"),this.getComponent("pool_name").getValue());b+=", ";a=this.getData("raid_level");b+=SYNO.SDS.StorageUtils.RaidLevelRender(a);this.getComponent("desc").setValue(b)},getAllocateByte:function(){var b=this.SizeValueInput.getValue();var a;if(b===this.maxFreeSizeGB){a=this.maxFreeSizeByte}else{a=b*1024*1024*1024}return a},getDescription:function(){return this.getComponent("desc").getValue()},activate:function(){var a=this.getData("quick_mode");var c=this.getData("pool_from");var b=this.getData("selected_pool_id");this.SizeValueInput=this.getComponent("size").getComponent("size_value");this.getComponent("size").doLayout();if(a||c==="create"){this.getEstimatedSize()}else{if(b){this.getPoolSize(b)}}},updateData:function(a){a.volume_description=this.getDescription();a.allocate_byte=this.getAllocateByte()},getNext:function(){var e=this;var g=false;var d=this.getData("raid_type");var a=e.SizeValueInput.getValue();var b,c,f;if(!this.getForm().isValid()){return false}if(e.maxFreeSizeGB<a){b=String.format("{0}",e.minSizeGB);c=String.format("{0}",e.maxFreeSizeGB);f=String.format(_T("volume","volume_valid_range_warning"),b,c);g=true}else{if(e.minSizeGB>a&&d!=="single"){b=String.format("{0}",e.minSizeGB);f=String.format(_JSLIBSTR("extlang","minnumber"),b);g=true}}if(g){e.SizeValueInput.markInvalid(f);return false}return e.nextId},summary:function(a){var b=String.format("{0} {1}",this.SizeValueInput.getValue(),_T("common","size_gb"));a.append(_T("volume","volume_pool"),this.getComponent("pool_name").getValue());a.append(_T("volume","volume_size_allocated"),b);a.append(_T("volume","volume_desc"),this.getDescription())}});Ext.define("SYNO.SDS.StorageManager.Wizard.DiskCheckStep",{extend:"SYNO.SDS.StorageManager.Wizard.Step",constructor:function(a){var b={headline:_T("volume","volume_diskcheck"),items:[{xtype:"syno_radio",boxLabel:String.format("{0} ({1})",_T("common","yes"),_T("volume","volume_recommand")),name:"check",inputValue:"yes",itemId:"check"},{xtype:"syno_displayfield",indent:1,value:_T("volume","volume_diskcheck_enable_help")},{xtype:"syno_displayfield",cls:"sm-empty-line"},{xtype:"syno_radio",boxLabel:String.format("{0}",_T("common","no")),name:"check",inputValue:"no",itemId:"nocheck"},{xtype:"syno_displayfield",indent:1,value:_T("volume","volume_diskcheck_disable_help")}]};b=Ext.apply(b,a);this.callParent([b])},isChecked:function(){return this.getForm().getValues().check==="yes"},getNext:function(){return this.nextId},isSkip:function(){if(this.getData("quick_mode")){return true}switch(this.getData("raid_level")){case"raid_5":case"raid_6":case"raid_f1":case"shr_2":return true;case"shr":if(this.getData("disk_ids",[]).length>2){return true}break;default:break}return false},updateData:function(a){a.disk_check=this.isChecked()},summary:function(a){if(this.isSkip()){return}a.append(_T("volume","volume_diskcheck_title"),this.isChecked()?_T("common","yes"):_T("common","no"))},activate:function(){var b=false;var c=this.owner.getRaidLevel();var a=this.getData("disk_ids",[]);switch(c){case"shr_with_1_disk_protect":b=(a.length<3);break;case"shr_without_disk_protect":case"basic":case"raid_0":case"raid_linear":b=true;break;default:break}this.getComponent(b?"check":"nocheck").setValue(true)}});Ext.define("SYNO.SDS.StorageManager.Wizard.SHROperationStep",{extend:"SYNO.ux.FormPanel",constructor:function(a){this.appWin=a.appWin;this.spaceType=a.spaceType||"volume";var b={headline:_T("volume","choose_unfinished_shr_operation_title"),items:[{xtype:"syno_radio",boxLabel:_T("volume","volume_expand_raidgroup_by_add_disk"),name:"shr_operation",itemId:"add_disk",inputValue:"add_disk"},{xtype:"syno_displayfield",indent:1,itemId:"add_disk_desc",value:_T("volume","volume_expand_unfinished_shr_add_disk_desc")},{xtype:"syno_radio",boxLabel:_T("volume","volume_expand_unfinished_shr_to_shr2"),name:"shr_operation",itemId:"migrate_to_shr2",inputValue:"migrate_to_shr2"},{xtype:"syno_radio",boxLabel:_T("volume","spare_repair"),name:"shr_operation",itemId:"hotspare_repair",inputValue:"hotspare_repair"},{xtype:"syno_displayfield",indent:1,itemId:"hotspare_repair_desc",value:_T("volume","spare_expand_unalloc_desc")},{xtype:"syno_displayfield",htmlEncode:false,value:"</br>"},{xtype:"syno_displayfield",itemId:"note",htmlEncode:false,value:_T("volume","volume_expand_unfinished_shr_note")}]};this.callParent([Ext.apply(b,a)])},activate:function(){var d=this.getComponent("add_disk");var a=this.getComponent("add_disk_desc");var c=this.getComponent("migrate_to_shr2");var b=this.getComponent("hotspare_repair");var e=this.getComponent("hotspare_repair_desc");this.pool=this.owner.pool;this.SHROperation=this.pool.get("can_do").expand_unfinished_shr||{};if(this.SHROperation.add_disk){d.setValue(true)}else{d.disable();a.disable();b.disable();e.disable();c.setValue(true)}},getOperation:function(){return this.getForm().getValues().shr_operation},updateData:function(b){var a=this.getOperation();b.shr_operation=a;b.disk_default_checked=false;if("migrate_to_shr2"===a&&0!==this.SHROperation.migrate_to_shr2){b.allow_disk_blank=false}else{b.allow_disk_blank=true}},getNext:function(){var b=this.getOperation();var a="";if("hotspare_repair"===b){a=this.nextId.summary}else{a=this.nextId.disk}return a}});Ext.define("SYNO.SDS.StorageManager.Wizard.ManageSummaryStep",{extend:"SYNO.SDS.StorageManager.Wizard.SummaryStep",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.pool=undefined;c.stopServicesType=undefined;c.convertSHRToPool=false;b={headline:_T("volume","volume_wizard_summary_title")};c.callParent([Ext.apply(b,a)])},activate:function(){var h=this;var k=SYNO.SDS.StorageUtils;var j=h.getStore();var e=h.getData("manage_action");var a=h.getData("migrate_type");var b=h.getData("disk_groups",[]);var d=h.getData("disk_ids",[]);var f,l,c,g,i;h.callParent(arguments);h.pool=h.owner.getPoolObject();f=h.pool;j.append(_T("common","name"),f.getName());j.append(_T("volume","volume_add_purpose"),k.AddDiskTypeRender(e));switch(e){case"migrate":j.append(_T("volume","volume_migrate_type"),k.MigrateTypeRender(a));break;case"data_scrubbing":j.append(_T("volume","notice"),_T("volume","data_scrubbing_notice"));break;case"expand_by_disk":if("shr_without_disk_protect"===f.getDeviceType()&&1===d.length){j.append(_T("common","note"),_T("volume","volume_add_disk_into_shr_raidgroup_help"))}break}if(f.isSingleLun()){c="SYNO.Core.Storage.iSCSILUN";l=h.lunEstimateCallBack;g="lun";i=f.get("deploy_path")}else{if(f.isSingleVolume()){c="SYNO.Storage.CGI.Volume";l=h.volumeEstimateCallBack;g="volume";i=f.get("deploy_path")}else{c="SYNO.Storage.CGI.Pool";l=h.poolEstimateCallBack;g="pool";i=f.id}}this.type=g;h.owner.setStatusBusy();h.owner.getButton("next").disable();SYNO.API.Request({api:c,method:"estimate_size",version:1,params:{estimate_for:h.owner.getActionType(),disk_id:d,space_id:i,diskGroups:b},callback:l,scope:h})},checkRunningvDSM:function(c,f){var d=this,e=d.appWin.volumes.getAll(),b=SYNO.SDS.StorageUtils,a=[];if(!(c==="pool"||c==="volume")){return false}Ext.each(e,function(g){if(f.get("id")===g.get("pool_path")){a.push(g.get("id"))}});if(b.isExistRunningvDSM(e,a)){return true}return false},getNext:function(){if("stop_in_minutes"===this.stopServicesType&&this.checkRunningvDSM(this.type,this.pool)){this.owner.getMsgBox().alert(this.owner.title,_TT("SYNO.SDS.Virtualization.Application","vm","exist_alive_vm_err"),function(a){this.owner.close()},this);return false}this.owner.applySettings(this.stopServicesType);return false},isSupportFitFsLimit:function(){var a=this.owner.getActionType();if(!this.pool.isSHR()&&!this.appWin.env.support_fit_fs_limit){switch(a){case"repair":case"expand_with_unalloc_size":case"expand_unfinished_shr":break;default:return false}}return true},checkAutoSHRConvert:function(a,c){var b=this.getData("manage_action");if(!this.pool.isSHR()){return}switch(b){case"repair":case"expand_with_unalloc_size":case"expand_unfinished_shr":case"expand_by_disk":break;default:return}this.owner.getMsgBox().confirm(this.owner.title,_T("volume","volume_auto_convert_shr_to_pool_tip"),function(e){if("yes"==e){var d=this.getStore();var f=(b==="repair")?_T("volume","volume_shr_repair_and_convert"):_T("volume","volume_shr_expand_and_convert");this.convertSHRToPool=true;d.append(_T("volume","volume_pool_freesize"),String.format("{0} {1}",_T("volume","volume_add_warningabout"),SYNO.SDS.StorageUtils.SizeRender(a-c)));d.each(function(g){if(g.json.key===_T("volume","volume_add_purpose")){g.set("value",f);g.commit();return false}})}},this)},getVolumeMaxFsSize:function(){var a=0;var b;b=this.appWin.volumes.data[this.pool.get("deploy_path")];if(b){a=parseInt(b.get("max_fs_size"),10)}return a},volumeEstimateCallBack:function(m,e,f,b){var j=this;var g=SYNO.SDS.StorageUtils;var i={};var n=parseInt(j.appWin.getMaxVolumeSize(),10);var h=parseInt(j.pool.get("size").total,10);var l=parseInt(e.size,10);var c=j.getData("manage_action");var a=l;var k,d;j.owner.clearStatusBusy();if(!m){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,e);j.owner.getButton("next").disable();return}if("convert_shr_to_pool"!==c){d=this.getVolumeMaxFsSize();k=Math.min(d,n);k=Math.max(k,h);if(l>k){if(this.isSupportFitFsLimit()){a=k;i.text=_T("volume","volume_size_limitation_warning");i.text=String.format(i.text,g.SizeRender(k));SYNO.SDS.StorageUtils.ReportWebapiFailure(this,i,this.checkAutoSHRConvert,l,a)}else{i.text=_T("error","error_volume_oversize");i.text=String.format(i.text,g.SizeRender(k));SYNO.SDS.StorageUtils.ReportWebapiFailure(this,i);j.owner.getButton("next").disable()}}}j.getStore().append(_T("volume","volume_totalsize"),String.format("{0} {1}",_T("volume","volume_add_warningabout"),SYNO.SDS.StorageUtils.SizeRender(a)));if("data_scrubbing"===c){return}if(e.stop_service_type){j.stopServicesType=e.stop_service_type}},poolEstimateCallBack:function(d,c,b,a){this.owner.clearStatusBusy();if(!d){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,c);this.owner.getButton("next").disable();return}this.getStore().append(_T("volume","volume_totalsize"),String.format("{0} {1}",_T("volume","volume_add_warningabout"),SYNO.SDS.StorageUtils.SizeRender(c.size)));if(c.stop_service_type){this.stopServicesType=c.stop_service_type}},lunEstimateCallBack:function(d,c,b,a){this.owner.clearStatusBusy();if(!d){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,c);this.owner.getButton("next").disable();return}this.getStore().append(_T("volume","volume_totalsize"),String.format("{0} {1}",_T("volume","volume_add_warningabout"),SYNO.SDS.StorageUtils.SizeRender(c.size)));if(c.stop_service_type){this.stopServicesType=c.stop_service_type}},disableNextInDemoMode:true});Ext.define("SYNO.SDS.StorageManager.Wizard.AdvDiskStep",{extend:"SYNO.SDS.StorageManager.Wizard.Step",constructor:function(a){this.subgroupName=undefined;this.freeDisksPanel=undefined;this.raidDisksPanel=undefined;this.ctrlHold=false;this.shiftHold=false;this.proxy=undefined;this.moving=false;this.lastClickedA=undefined;this.lastClickedS=undefined;this.minSize=0;this.minSizeRequiredDisks=0;this.mode=a.mode||"create";this.disks=a.advDisks;this.raidType=null;this.raidLevel=null;this.raidLimitNum=null;this.requiredDiskForSHR=a.repair||0;this.initFreeDiskPanel();this.initRaidDiskPanel();var b={headline:_T("volume","volume_add_diskselect"),description:_T("volume","volume_select_disk_desc"),layout:{type:"hbox",align:"stretch"},bwrapCfg:{cls:"x-panel-bwrap",style:{padding:"8px 20px 4px 20px"}},items:[this.freeDisksPanel,this.raidDisksPanel]};Ext.apply(b,a);this.callParent([b])},initEvents:function(){this.callParent(arguments);this.bindKeyboardEvents();this.mon(this.freeDisksPanel.view.getStore(),"load",this.setMask,this)},setMask:function(){if(0===this.freeDisksPanel.view.getStore().getCount()){this.freeDisksPanel.body.mask(_T("volume","volume_no_available_disks"),"syno-ux-mask-info")}else{this.freeDisksPanel.body.unmask()}},bindKeyboardEvents:function(){var a=this;var b=Ext.getDoc();a.mon(b,"keydown",function(d,c){switch(d.getKey()){case d.CONTROL:this.ctrlHold=true;break;case d.SHIFT:this.shiftHold=true;break;default:return}},a);a.mon(b,"keyup",function(d,c){switch(d.getKey()){case d.CONTROL:this.ctrlHold=false;break;case d.SHIFT:this.shiftHold=false;break;default:return}},a)},initFreeDiskPanel:function(){var b={tpl:this.getFreeDiskTpl(),layout:"fit",store:new Ext.data.JsonStore({autoDestroy:true,root:"containers",fields:["id","name","disks"],listeners:{load:function(){if(Ext.get("freeDisksPanel")){var c=Ext.get("freeDisksPanel").query(".selectable");Ext.each(c,function(h,e,g){var f=new Ext.Element(h);if(f.hasClass("toggle")||f.hasClass("hostname")){return true}this.mon(f,"mousedown",this.onMouseDown,this)},this);var d=Ext.get("freeDisksPanel").query(".toggle");Ext.each(d,function(h,e,g){var f=new Ext.Element(h);this.mon(f,"mousedown",function(k,j){k.stopEvent();var i=new Ext.Element(j);i.parent("div",false).next("ul",false).setVisibilityMode(Ext.Element.DISPLAY);i.parent("div",false).next("ul",false).toggle();i.toggleClass("sds-space-toggle-collapse")},this)},this)}this.doLayout()},scope:this}})};var a=new Ext.DataView(b);this.freeDisksPanel=new Ext.Panel({id:"freeDisksPanel",bodyStyle:{"border-top":"0","border-left":"0","border-bottom":"0","border-right":"1px solid #C8D2Dc"},view:a,flex:48,autoFlexcroll:true,items:a})},getFreeDiskTpl:function(){var a=new Ext.XTemplate("<ul>",'<tpl for=".">','<li class="enclosure sds-space-disk-li">','<div class="sds-space-disk-container owner selectable" side="available" type="enclosure" devId="{id}">','<div class="toggle sds-space-toggle nonselectable"></div>','<span class="hostname">{name}</span>',"</div>","<ul>",'<tpl for="disks">','<li class="sds-space-disk-li">','<div class="sds-space-disk disk selectable" side="available" diskType="{diskType}" owner="{owner}" container="{owner}" size_total="{size_total}" devId="{id}">{shortName} - {diskType} / {driveType} {size} {display4Kn}</div>',"</li>","</tpl>","</ul>","</li>","</tpl>","</ul>");a.compile();return a},initRaidDiskPanel:function(){var b={tpl:this.getRaidDiskTpl(),layout:"fit",store:new Ext.data.JsonStore({autoDestroy:true,root:"raids",fields:["id","disks"],listeners:{load:function(){if(Ext.get("raidDisksPanel")){var c=Ext.get("raidDisksPanel").query(".selectable");Ext.each(c,function(h,e,g){var f=new Ext.Element(h);if(!h.getAttribute("used_by")){this.mon(f,"mousedown",this.onMouseDown,this)}},this);var d=Ext.get("raidDisksPanel").query(".sds-space-disk-remove-icon");Ext.each(d,function(h,e,g){var f=new Ext.Element(h);if(!h.getAttribute("used_by")){this.mon(f,"click",function(j,l,k){var i=[];i.push({dom:l.parentNode});this.dropToAvailable(i)},this)}},this)}this.doLayout()},scope:this}})};var a=new Ext.DataView(b);this.raidDisksPanel=new Ext.Panel({id:"raidDisksPanel",border:false,bodyStyle:{"padding-left":"10px"},view:a,flex:52,autoFlexcroll:true,items:a})},getRaidDiskTpl:function(){var a=new Ext.XTemplate("<ul>",'<tpl for=".">','<li class="sds-space-disk-li">','<div devId="id" class="sds-space-raid owner nonselectable" used_by="{id}">{id}</div>',"<ul>",'<tpl for="disks">','<tpl if="dummy == true">','<li><div class="sds-space-dummy dummy {cls}" used_by="dummy" minSize="{minSize}" raidNum="{raidNum}">','<tpl if="required == true">',_T("volume","volume_required_disk"),"</tpl>",'<tpl if="required == false">',_T("volume","volume_additional_disk"),"</tpl>","</div></li>","</tpl>",'<tpl if="dummy == false">','<li class="sds-space-disk-li">','<div class="sds-space-disk-choosed disk {cls}" diskType="{diskType}" side="pool" owner="{parent.id}" container="{owner}" devId="{id}" size_total="{size_total}" used_by="{used_by}" raidNum="{raidNum}">{shortName} - {diskType} / {driveType} {size} {display4Kn}',"<tpl if=\"cls == 'selectable'\">",'<div class="sds-space-disk-remove-icon"></div>',"</tpl>","</div>","</li>","</tpl>","</tpl>","</ul>","</li>","</tpl>","</ul>");a.compile();return a},onMouseDown:function(d,c){var a=new Ext.Element(c);if(a.hasClass("hostname")){a=a.parent();c=a.dom}if("available"===c.getAttribute("side")){this.lastClickA=a}else{this.lastClickS=a}this.lastClick=a;d.stopEvent();this.checkSelection(c);var b=this;b.lastPos=d.getXY();var f=setTimeout(function(){var e=Ext.getDoc();b.mon(e,"mousemove",b.onMouseMove,b);b.mon(e,"mouseup",b.onMouseUp,b)},50);this.mon(a,"mouseup",function(){clearTimeout(f)},this,{single:true})},checkSelection:function(e){var c=new Ext.Element(e);var a,b;if("available"===e.getAttribute("side")){a=Ext.get("freeDisksPanel");b="lastClickedA"}else{a=Ext.get("raidDisksPanel");b="lastClickedS"}if(!this.ctrlHold&&!this.shiftHold&&!c.hasClass("sds-pool-create-device-selected")){Ext.each(a.query(".sds-pool-create-device-selected"),function(){var g=new Ext.Element(this);g.removeClass("sds-pool-create-device-selected")});c.addClass("sds-pool-create-device-selected")}if(this.shiftHold){if(null===this[b]){c.addClass("sds-pool-create-device-selected")}else{Ext.each(a.query(".sds-pool-create-device-selected"),function(){var g=new Ext.Element(this);g.removeClass("sds-pool-create-device-selected")});var d=this[b].getXY()[1]<c.getXY()[1]?this[b].getXY()[1]:c.getXY()[1];var f=this[b].getXY()[1]>c.getXY()[1]?this[b].getXY()[1]:c.getXY()[1];Ext.each(a.query(".selectable"),function(){var g=new Ext.Element(this);if(g.getXY()[1]>=d&&g.getXY()[1]<=f&&!g.hasClass("nonselectable")){g.addClass("sds-pool-create-device-selected")}})}}else{if(this.ctrlHold){c.toggleClass("sds-pool-create-device-selected")}}this[b]=c},onMouseMove:function(f,d){var b=new Ext.Element(d);var c=f.getXY(),a,h,g;if(b.hasClass("hostname")){b=b.parent();d=b.dom}if(this.lastPos){a=Math.pow(this.lastPos[0]-c[0],2);h=Math.pow(this.lastPos[1]-c[1],2);g=Math.sqrt(a+h)}if(g>15&&!this.proxy){this.moved=true;this.createDragProxy(d)}if(this.proxy){c[0]+=5;c[1]+=5;this.proxy.setXY(c);this.proxy.setStyle({position:"absolute","z-index":"100000",width:"200px"})}if(this.dropHint&&this.dropHint.hasClass("sds-space-dummy-disk-hover")){this.dropHint.removeClass("sds-space-dummy-disk-hover")}if(this.isInDropZone(f,"raidDisks")){Ext.each(Ext.get("raidDisksPanel").query("div"),function(i){var e=new Ext.Element(i);if(e.hasClass("dummy")&&f.getXY()[1]>=e.getXY()[1]&&f.getXY()[1]<=e.getXY()[1]+e.getHeight()){this.dropHint=e;if(!e.hasClass("sds-space-dummy-disk-hover")){e.addClass("sds-space-dummy-disk-hover")}this.dropPos="";return false}if((f.getXY()[1]>=e.getXY()[1])&&(f.getXY()[1]<e.getXY()[1]+e.getHeight()/2)&&!e.hasClass("dummy")&&e.hasClass("selectable")){this.dropHint=e;if(!e.hasClass("sds-space-dummy-disk-hover")){e.addClass("sds-space-dummy-disk-hover")}this.dropPos="top";return false}if((f.getXY()[1]>=e.getXY()[1]+e.getHeight()/2)&&(f.getXY()[1]<e.getXY()[1]+e.getHeight())&&!e.hasClass("dummy")&&e.hasClass("selectable")){this.dropHint=e;if(!e.hasClass("sds-space-dummy-disk-hover")){e.addClass("sds-space-dummy-disk-hover")}this.dropPos="bottom";return false}delete this.dropHint;delete this.dropPos;e.removeClass("sds-space-dummy-disk-hover")},this)}else{delete this.dropHint;delete this.dropPos}},createDropHint:function(a){if(!this.dropHintProxy){this.dropHintProxy=new Ext.Element(Ext.DomHelper.createDom({tag:"div",html:">"}));Ext.getBody().appendChild(this.dropHintProxy)}this.dropHintProxy.setStyle({position:"absolute","z-index":"100000",width:"20px",height:"20px"});this.dropHintProxy.setXY(a)},createDragProxy:function(f){var e;var b;e=new Ext.Element(f);if("available"===f.getAttribute("side")){b=Ext.get("freeDisksPanel")}else{b=Ext.get("raidDisksPanel")}var d=[],a=[],c={};Ext.each(b.query(".sds-pool-create-device-selected"),function(){var g=new Ext.Element(this);if(g.hasClass("owner")){c[this.getAttribute("devId")]=true;d.push(g)}else{if(!c[this.getAttribute("owner")]){a.push(g)}}});d=d.concat(a);d.sort(function(h,g){if(h.getXY()[1]>g.getXY()[1]){return 1}if(h.getXY()[1]<g.getXY()[1]){return -1}return 0});this.proxy=new Ext.Element(Ext.DomHelper.createDom({tag:"div"}));Ext.each(d,function(h){var g=h.parent().dom.cloneNode(true);g.removeAttribute("id");this.proxy.appendChild(g)},this);this.proxy.setStyle({position:"absolute","z-index":"100000",width:"200px"});Ext.getBody().appendChild(this.proxy)},onMouseUp:function(f,d){var a,b=new Ext.Element(d);if(b.hasClass("hostname")){b=b.parent();d=b.dom}if("available"===d.getAttribute("side")){a=Ext.get("freeDisksPanel")}else{a=Ext.get("raidDisksPanel")}if(!this.ctrlHold&&!this.shiftHold&&!this.moved){Ext.each(a.query(".sds-pool-create-device-selected"),function(){var e=new Ext.Element(this);e.removeClass("sds-pool-create-device-selected")});b.addClass("sds-pool-create-device-selected")}if(this.proxy){this.proxy.remove();this.proxy=null}if(this.dropHintProxy){this.dropHintProxy.remove();delete this.dropHintProxy}var c=Ext.getDoc();this.mun(c,"mousemove",this.onMouseMove,this);this.mun(c,"mouseup",this.onMouseUp,this);this.dropSelections(f,d);delete this.lastPos},dropSelections:function(f,d){var c=this.lastClick;var b,a;if("available"===c.dom.getAttribute("side")){b=Ext.get("freeDisksPanel");if(this.isInDropZone(f,"raidDisks")){a=this.getSelectedDisks(b);if(this.dropHint){switch(this.dropPos){case"":this.dropOnDummyAToS(a);break;case"top":this.dropOnTopAToS(a);break;case"bottom":this.dropOnBottomAToS(a);break}}else{if(this.isMultiRAIDMode()){this.dropToTheEndAToSMulti(a)}else{this.dropToTheEndAToS(a)}}}}else{b=Ext.get("raidDisksPanel");a=this.getSelectedDisks(b);if(this.isInDropZone(f,"freeDisks")){this.dropToAvailable(a)}else{if(this.moved){switch(this.dropPos){case"":this.dropOnDummySToS(a);break;case"top":this.dropOnTopSToS(a);break;case"bottom":this.dropOnBottomSToS(a);break}}}}this.moved=false},dropToTheEndAToSMulti:function(g){if("repair"===this.owner.add_type){return}var b,a,d,e=false,f=0,c;Ext.each(this.RaidDisksData.raids,function(j){var h,k;var l=0,i;if(this.pool&&f<=this.pool.json.raids.length-1){i=this.pool.json.raids[f];l=parseInt(this.pool.json.raids[f].minDevSize,10)}b=this.maxDisks;a=[];Ext.each(j.disks,function(m){if(!m.dummy){a.push(m);--b}},this);c=[];for(d=0;d<g.length;++d){h=g[d].dom.getAttribute("devId");k=this.appWin.disks.data[h];if(k.get("size_total")>=l&&0<b){g[d]=null;this.freeDisks[h].available=false;a.push(this.createDisk(k,f,false,false,true));--b}else{c.push(g[d])}}g=c;e=this.fillDummyDisks(a,f,i);delete j.disks;j.disks=a;++f},this);if(!e&&0<g.length){this.fillOthers(g)}this.checkLastRAID();this.prepareFreeDisksData();this.freeDisksPanel.view.store.loadData(this.FreeDisksData,false);this.raidDisksPanel.view.store.loadData(this.RaidDisksData,false)},getRepairRequiredCount:function(a,b,c){if(a&&b&&b.devices){if(0<(a.length-b.normalDevCount)){return 0}else{return 1}}return c},fillDummyDisks:function(a,e,d){var c=false;var b,f=this.maxDisks-a.length;if(d&&"repair"===this.owner.add_type){b=parseInt(d.designedDiskCount,10)-a.length;f=b;if("raid_6"===this.raidLevel){b=this.getRepairRequiredCount(a,d,b)}}else{if(d&&"expand_by_disk"===this.owner.add_type){b=parseInt(d.designedDiskCount,10)-a.length+1}else{if(d&&"migrate"===this.owner.add_type){if("raid_1"===this.raidLevel&&1===parseInt(d.designedDiskCount,10)){b=parseInt(d.designedDiskCount,10)-a.length+1}else{if(this.minDisks>parseInt(d.designedDiskCount,10)){b=this.minDisks-a.length}else{if("raid_1"===this.pool.json.device_type&&"raid_1"!==this.raidLevel){b=this.minDisks-a.length}else{b=parseInt(d.designedDiskCount,10)+1-a.length}}}}else{b=this.minDisks-a.length;if("raid_10"===this.raidLevel&&a.length>this.minDisks&&1===a.length%2){b=1}}}}c=0<f;while(0<f){a.push({raidNum:e,dummy:true,required:0<b,cls:0<b?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--f;--b}return c},fillOthers:function(d){if("migrate"===this.owner.add_type){return}var a;var c=0;var b=0;Ext.each(this.RaidDisksData.raids,function(i){var e=[];var g=false;Ext.each(i.disks,function(j){if(!j.dummy){e.push(j)}else{g=true;return false}},this);if(!g){++b;return true}a=this.maxDisks-e.length;if(this.pool){if(this.pool.json.raids&&this.pool.json.raids[b]){c=parseInt(this.pool.json.raids[b].minDevSize,10)}else{c=parseInt(this.pool.get("minimal_disk_size"),10)}}if("repair"===this.owner.add_type){var h=this.pool.json.raids[b];a=parseInt(h.designedDiskCount,10)-e.length}var f=[];Ext.each(d,function(l){var j=l.dom.getAttribute("devId");var k=this.appWin.disks.data[j];if(k.get("size_total")>=c&&0<a){this.freeDisks[j].available=false;e.push(this.createDisk(k,b,false,false,true));--a}else{f.push(l)}},this);d=f;if("repair"!==this.owner.add_type){this.fillDummyDisks(e,b,null)}delete i.disks;i.disks=e;if(0===d.length){return false}++b},this);if(0<d.length&&"repair"!==this.owner.add_type){this.fillNewRaid(d)}},fillNewRaid:function(g){var c=0,d,e,b,a,f;for(d=0;d<g.length;++d){if(0===c){e=this.RaidDisksData.raids.length;a=[];this.RaidDisksData.raids.push({disks:a,id:String.format(this.subgroupName,(e+1)),raidNum:e});c=this.maxDisks}b=g[d].dom.getAttribute("devId");f=this.appWin.disks.data[b];if(0<c){this.freeDisks[b].available=false;a.push(this.createDisk(f,e,false,false,true));--c}}a=this.RaidDisksData.raids[this.RaidDisksData.raids.length-1].disks;e=this.RaidDisksData.raids.length-1;this.fillDummyDisks(a,e,null)},dropToTheEndAToS:function(d){if("repair"===this.owner.add_type){return}var f=0===this.RaidDisksData.raids.length?0:this.RaidDisksData.raids.length-1;if(!this.RaidDisksData.raids[f]){return}var e=0;var i=f;if(this.pool){if(this.pool.json.raids&&this.pool.json.raids[i]){e=parseInt(this.pool.json.raids[i].minDevSize,10)}else{e=parseInt(this.pool.get("minimal_disk_size"),10)}}var g=[];Ext.each(this.RaidDisksData.raids[f].disks,function(j){if(!j.dummy){g.push(j)}},this);var b;var a;if(this.pool){a=this.pool.json.raids[i]}if(-1<this.raidLevel.indexOf("shr")){b=this.requiredDiskForSHR}else{if(a&&"repair"===this.owner.add_type){b=parseInt(a.designedDiskCount,10)-g.length}else{b=this.maxDisks-g.length}}Ext.each(d,function(l){var j=l.dom.getAttribute("devId");var k=this.appWin.disks.data[j];if(k.get("size_total")>=e&&0<b){this.freeDisks[j].available=false;g.push(this.createDisk(k,i,false,false,true));--b;--this.requiredDiskForSHR}},this);var c,h=this.maxDisks-g.length;if(-1<this.raidLevel.indexOf("shr")){c=this.requiredDiskForSHR;h=c}else{if(a&&"repair"===this.owner.add_type){c=parseInt(a.designedDiskCount,10)-g.length;h=c}else{if(a&&"expand_by_disk"===this.owner.add_type){c=parseInt(a.designedDiskCount,10)-g.length+1}else{if(a&&"migrate"===this.owner.add_type){if("raid_1"===this.raidLevel&&2===parseInt(a.designedDiskCount,10)){c=parseInt(a.designedDiskCount,10)-g.length+1}else{if(this.minDisks>parseInt(a.designedDiskCount,10)){c=this.minDisks-g.length}else{if("raid_1"===this.pool.json.device_type&&"raid_1"!==this.raidLevel){c=this.minDisks-g.length}else{c=parseInt(a.designedDiskCount,10)+1-g.length}}}}else{c=this.minDisks-g.length;if("raid_10"===this.raidLevel&&g.length>this.minDisks&&1===g.length%2){c=1}}}}}while(0<h){g.push({raidNum:i,dummy:true,required:0<c,cls:0<c?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--h;--c}delete this.RaidDisksData.raids[f].disks;this.RaidDisksData.raids[f].disks=g;this.checkLastRAID();this.prepareFreeDisksData();this.freeDisksPanel.view.store.loadData(this.FreeDisksData,false);this.raidDisksPanel.view.store.loadData(this.RaidDisksData,false)},dropOnDummyAToS:function(g){var l=parseInt(this.dropHint.dom.getAttribute("raidNum"),10);var i=this.RaidDisksData.raids[l];var h=0;var c,d,k;if(this.pool){if(this.pool.json.raids&&this.pool.json.raids[l]){h=parseInt(this.pool.json.raids[l].minDevSize,10)}else{h=parseInt(this.pool.get("minimal_disk_size"),10)}}var j=[];Ext.each(i.disks,function(m){if(!m.dummy){j.push(m)}},this);var b;var a;if(this.pool&&this.pool.json.raids){a=this.pool.json.raids[l]}if(-1<this.raidLevel.indexOf("shr")){b=this.requiredDiskForSHR}else{if(a&&"repair"===this.owner.add_type){b=parseInt(a.designedDiskCount,10)-j.length}else{b=this.maxDisks-j.length}}var f=[];Ext.each(g,function(n){var m=n.dom.getAttribute("devId");c=this.appWin.disks.data[m];if(c.get("size_total")>=h&&0<b){this.freeDisks[m].available=false;j.push(this.createDisk(c,l,false,false,true));--b;--this.requiredDiskForSHR}else{f.push(n)}},this);g=f;k=this.maxDisks-j.length;if(-1<this.raidLevel.indexOf("shr")){d=this.requiredDiskForSHR;k=d}else{if(a&&"repair"===this.owner.add_type){d=parseInt(a.designedDiskCount,10)-j.length;k=d;if("raid_6"===this.raidLevel){d=this.getRepairRequiredCount(j,a,d)}}else{if(a&&"expand_by_disk"===this.owner.add_type){d=parseInt(a.designedDiskCount,10)-j.length+1}else{if(a&&"migrate"===this.owner.add_type){if("raid_1"===this.raidLevel&&2===parseInt(a.designedDiskCount,10)){d=parseInt(a.designedDiskCount,10)-j.length+1}else{if(this.minDisks>parseInt(a.designedDiskCount,10)){d=this.minDisks-j.length}else{if("raid_1"===this.pool.json.device_type&&"raid_1"!==this.raidLevel){d=this.minDisks-j.length}else{d=parseInt(a.designedDiskCount,10)+1-j.length}}}}else{d=this.minDisks-j.length;if("raid_10"===this.raidLevel&&j.length>this.minDisks&&1===j.length%2){d=1}}}}}var e=0<k;while(0<k){j.push({raidNum:l,dummy:true,required:0<d,cls:0<d?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--k;--d}delete i.disks;i.disks=j;if(this.isMultiRAIDMode()){if(!e&&0<g.length){this.fillOthers(g)}}this.checkLastRAID();this.prepareFreeDisksData();this.freeDisksPanel.view.store.loadData(this.FreeDisksData,false);this.raidDisksPanel.view.store.loadData(this.RaidDisksData,false)},dropOnTopAToS:function(j){var p=parseInt(this.dropHint.dom.getAttribute("raidNum"),10);var l=this.RaidDisksData.raids[p];var k=0;var d,e,o;if(this.pool){if(this.pool.json.raids&&this.pool.json.raids[p]){k=parseInt(this.pool.json.raids[p].minDevSize,10)}else{k=parseInt(this.pool.get("minimal_disk_size"),10)}}var n=[];Ext.each(l.disks,function(i){if(i&&!i.dummy){n.push(i)}},this);var b;var a;if(this.pool&&this.pool.json.raids){a=this.pool.json.raids[p]}if(-1<this.raidLevel.indexOf("shr")){b=this.requiredDiskForSHR}else{if(a&&"repair"===this.owner.add_type){b=parseInt(a.designedDiskCount,10)-n.length}else{b=this.maxDisks-n.length}}var m=[];var h=[];Ext.each(j,function(q){var i=q.dom.getAttribute("devId");d=this.appWin.disks.data[i];if(d.get("size_total")>=k&&0<b){this.freeDisks[i].available=false;m.push(this.createDisk(d,p,false,false,true));--b;--this.requiredDiskForSHR}else{h.push(q)}},this);j=h;var c=n;n=[];for(var g=0;g<c.length;++g){if(c[g].id===this.dropHint.dom.getAttribute("devId")){n=n.concat(m)}n.push(c[g])}o=this.maxDisks-n.length;if(-1<this.raidLevel.indexOf("shr")){e=this.requiredDiskForSHR;o=e}else{if(a&&"repair"===this.owner.add_type){e=parseInt(a.designedDiskCount,10)-n.length;o=e;if("raid_6"===this.raidLevel){e=this.getRepairRequiredCount(n,a,e)}}else{if(a&&"expand_by_disk"===this.owner.add_type){e=parseInt(a.designedDiskCount,10)-n.length+1}else{if(a&&"migrate"===this.owner.add_type){if("raid_1"===this.raidLevel&&2===parseInt(a.designedDiskCount,10)){e=parseInt(a.designedDiskCount,10)-n.length+1}else{if(this.minDisks>parseInt(a.designedDiskCount,10)){e=this.minDisks-n.length}else{if("raid_1"===this.pool.json.device_type&&"raid_1"!==this.raidLevel){e=this.minDisks-n.length}else{e=parseInt(a.designedDiskCount,10)+1-n.length}}}}else{e=this.minDisks-n.length;if("raid_10"===this.raidLevel&&n.length>this.minDisks&&1===n.length%2){e=1}}}}}var f=0<o;while(0<o){n.push({raidNum:p,dummy:true,required:0<e,cls:0<e?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--o;--e}delete l.disks;l.disks=n;if(this.isMultiRAIDMode()){if(!f&&0<j.length){this.fillOthers(j)}}this.checkLastRAID();this.prepareFreeDisksData();this.freeDisksPanel.view.store.loadData(this.FreeDisksData,false);this.raidDisksPanel.view.store.loadData(this.RaidDisksData,false)},dropOnBottomAToS:function(j){var p=parseInt(this.dropHint.dom.getAttribute("raidNum"),10);var l=this.RaidDisksData.raids[p];var k=0;var d,e,o;if(this.pool){if(this.pool.json.raids&&this.pool.json.raids[p]){k=parseInt(this.pool.json.raids[p].minDevSize,10)}else{k=parseInt(this.pool.get("minimal_disk_size"),10)}}var n=[];Ext.each(l.disks,function(i){if(i&&!i.dummy){n.push(i)}},this);var b;var a;if(this.pool&&this.pool.json.raids){a=this.pool.json.raids[p]}if(-1<this.raidLevel.indexOf("shr")){b=this.requiredDiskForSHR}else{if(a&&"repair"===this.owner.add_type){b=parseInt(a.designedDiskCount,10)-n.length}else{b=this.maxDisks-n.length}}var m=[],h=[];Ext.each(j,function(q){var i=q.dom.getAttribute("devId");d=this.appWin.disks.data[i];if(d.get("size_total")>=k&&0<b){this.freeDisks[i].available=false;m.push(this.createDisk(d,p,false,false,true));--b;--this.requiredDiskForSHR}else{h.push(q)}},this);j=h;var c=n;n=[];for(var g=0;g<c.length;++g){n.push(c[g]);if(c[g].id===this.dropHint.dom.getAttribute("devId")){n=n.concat(m)}}o=this.maxDisks-n.length;if(-1<this.raidLevel.indexOf("shr")){e=this.requiredDiskForSHR;o=e}else{if(a&&"repair"===this.owner.add_type){e=parseInt(a.designedDiskCount,10)-n.length;o=e;if("raid_6"===this.raidLevel){e=this.getRepairRequiredCount(n,a,e)}}else{if(a&&"expand_by_disk"===this.owner.add_type){e=parseInt(a.designedDiskCount,10)-n.length+1}else{if(a&&"migrate"===this.owner.add_type){if("raid_1"===this.raidLevel&&2===parseInt(a.designedDiskCount,10)){e=parseInt(a.designedDiskCount,10)-n.length+1}else{if(this.minDisks>parseInt(a.designedDiskCount,10)){e=this.minDisks-n.length}else{if("raid_1"===this.pool.json.device_type&&"raid_1"!==this.raidLevel){e=this.minDisks-n.length}else{e=parseInt(a.designedDiskCount,10)+1-n.length}}}}else{e=this.minDisks-n.length;if("raid_10"===this.raidLevel&&n.length>this.minDisks&&1===n.length%2){e=1}}}}}var f=0<o;while(0<o){n.push({raidNum:p,dummy:true,required:0<e,cls:0<e?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--o;--e}delete l.disks;l.disks=n;if(this.isMultiRAIDMode()){if(!f&&0<j.length){this.fillOthers(j)}}this.checkLastRAID();this.prepareFreeDisksData();this.freeDisksPanel.view.store.loadData(this.FreeDisksData,false);this.raidDisksPanel.view.store.loadData(this.RaidDisksData,false)},dropToAvailable:function(b){var a;Ext.each(b,function(f){var c=f.dom.getAttribute("devId");a=parseInt(f.dom.getAttribute("raidNum"),10);for(var e=0;e<this.RaidDisksData.raids[a].disks.length;++e){if(this.RaidDisksData.raids[a].disks[e]&&this.RaidDisksData.raids[a].disks[e].id===c){this.RaidDisksData.raids[a].disks[e]=null;break}}this.freeDisks[c].available=true},this);this.requiredDiskForSHR+=b.length;a=0;Ext.each(this.RaidDisksData.raids,function(f){var c=[];Ext.each(f.disks,function(h){if(h&&!h.dummy){c.push(h)}},this);var d,g;var e;if(this.pool&&this.pool.json.raids){e=this.pool.json.raids[a]}g=this.maxDisks-c.length;if(-1<this.raidLevel.indexOf("shr")){d=this.requiredDiskForSHR;g=d}else{if(e&&"repair"===this.owner.add_type){d=parseInt(e.designedDiskCount,10)-c.length;g=d;if("raid_6"===this.raidLevel){d=this.getRepairRequiredCount(c,e,d)}}else{if(e&&"expand_by_disk"===this.owner.add_type){d=parseInt(e.designedDiskCount,10)-c.length+1}else{if(e&&"migrate"===this.owner.add_type){if("raid_1"===this.raidLevel&&2===parseInt(e.designedDiskCount,10)){d=parseInt(e.designedDiskCount,10)-c.length+1}else{if(this.minDisks>parseInt(e.designedDiskCount,10)){d=this.minDisks-c.length}else{if("raid_1"===this.pool.json.device_type&&"raid_1"!==this.raidLevel){d=this.minDisks-c.length}else{d=parseInt(e.designedDiskCount,10)+1-c.length}}}}else{d=this.minDisks-c.length;if("raid_10"===this.raidLevel&&c.length>this.minDisks&&1===c.length%2){d=1}}}}}while(0<g){c.push({raidNum:a,dummy:true,required:0<d,cls:0<d?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--g;--d}delete f.disks;f.disks=c;++a},this);this.checkLastRAID();this.prepareFreeDisksData();this.freeDisksPanel.view.store.loadData(this.FreeDisksData,false);this.raidDisksPanel.view.store.loadData(this.RaidDisksData,false)},dropOnDummySToS:function(f){var l=parseInt(this.dropHint.dom.getAttribute("raidNum"),10);var h=this.RaidDisksData.raids[l];var g=0;var c,d,k;if(this.pool){if(this.pool.json.raids&&this.pool.json.raids[l]){g=parseInt(this.pool.json.raids[l].minDevSize,10)}else{g=parseInt(this.pool.get("minimal_disk_size"),10)}}var b;var a;if(this.pool&&this.pool.json.raids){a=this.pool.json.raids[l]}if(-1<this.raidLevel.indexOf("shr")){b=this.SHRDiskNum}else{if(a&&"repair"===this.owner.add_type){b=parseInt(a.designedDiskCount,10)}else{b=this.maxDisks;Ext.each(h.disks,function(m){if(!m.dummy){--b}},this)}}var e=[];var j=[];Ext.each(f,function(o){var m=o.dom.getAttribute("devId");c=this.appWin.disks.data[m];if(c.get("size_total")>=g&&0<b){var n=parseInt(o.dom.getAttribute("raidNum"),10);e.push({id:c.id,raidNum:n});j.push(this.createDisk(c,l,false,false,true));--b}},this);Ext.each(e,function(n){for(var m=0;m<this.RaidDisksData.raids[n.raidNum].disks.length;++m){if(this.RaidDisksData.raids[n.raidNum].disks[m]&&n.id===this.RaidDisksData.raids[n.raidNum].disks[m].id){this.RaidDisksData.raids[n.raidNum].disks[m]=null}}},this);var i;Ext.each(this.RaidDisksData.raids,function(m){i=[];Ext.each(m.disks,function(n){if(n&&!n.dummy){i.push(n)}},this);delete m.disks;m.disks=i},this);h.disks=h.disks.concat(j);l=0;Ext.each(this.RaidDisksData.raids,function(m){if(this.pool&&this.pool.json.raids){a=this.pool.json.raids[l]}k=this.maxDisks-m.disks.length;if(-1<this.raidLevel.indexOf("shr")){d=this.requiredDiskForSHR;k=d}else{if(a&&"repair"===this.owner.add_type){d=parseInt(a.designedDiskCount,10)-m.disks.length;k=d;if("raid_6"===this.raidLevel){d=this.getRepairRequiredCount(i,a,d)}}else{if(a&&"expand_by_disk"===this.owner.add_type){d=parseInt(a.designedDiskCount,10)-m.disks.length+1}else{if(a&&"migrate"===this.owner.add_type){if("raid_1"===this.raidLevel&&2===parseInt(a.designedDiskCount,10)){d=parseInt(a.designedDiskCount,10)-m.disks.length+1}else{if(this.minDisks>parseInt(a.designedDiskCount,10)){d=this.minDisks-m.disks.length}else{if("raid_1"===this.pool.json.device_type&&"raid_1"!==this.raidLevel){d=this.minDisks-m.disks.length}else{d=parseInt(a.designedDiskCount,10)+1-m.disks.length}}}}else{d=this.minDisks-m.disks.length;if("raid_10"===this.raidLevel&&m.disks.length>this.minDisks&&1===m.disks.length%2){d=1}}}}}while(0<k){m.disks.push({raidNum:l,dummy:true,required:0<d,cls:0<d?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--k;--d}++l},this);this.checkLastRAID();this.prepareFreeDisksData();this.freeDisksPanel.view.store.loadData(this.FreeDisksData,false);this.raidDisksPanel.view.store.loadData(this.RaidDisksData,false)},dropOnTopSToS:function(e){var k=parseInt(this.dropHint.dom.getAttribute("raidNum"),10);var f=0;var d,g,j;if(this.pool){if(this.pool.json.raids&&this.pool.json.raids[k]){f=parseInt(this.pool.json.raids[k].minDevSize,10)}else{f=parseInt(this.pool.get("minimal_disk_size"),10)}}var c=[];Ext.each(e,function(i){c.push(i.dom.getAttribute("devId"))},this);var h=[];var b=this.maxDisks;var a;if(this.pool&&this.pool.json.raids){a=this.pool.json.raids[k]}if(-1<this.raidLevel.indexOf("shr")){b=this.SHRDiskNum}else{if(a&&"repair"===this.owner.add_type){b=parseInt(a.designedDiskCount,10)}else{b=this.maxDisks}}for(g=0;g<this.RaidDisksData.raids[k].disks.length;++g){if(!this.RaidDisksData.raids[k].disks[g]){continue}if(this.RaidDisksData.raids[k].disks[g].dummy){break}if(this.RaidDisksData.raids[k].disks[g].id===this.dropHint.dom.getAttribute("devId")){Ext.each(e,function(o){var i=o.dom.getAttribute("devId");var n=this.appWin.disks.data[i];if(n.get("size_total")>=f&&0<b){var m=parseInt(o.dom.getAttribute("raidNum"),10);for(var l=0;l<this.RaidDisksData.raids[m].disks.length;++l){if(this.RaidDisksData.raids[m].disks[l]&&this.RaidDisksData.raids[m].disks[l].id===n.id){this.RaidDisksData.raids[m].disks[l]=null;break}}h.push(this.createDisk(n,k,false,false,true));--b}},this)}if(0<b&&this.RaidDisksData.raids[k].disks[g]&&-1===c.indexOf(this.RaidDisksData.raids[k].disks[g].id)){h.push(this.RaidDisksData.raids[k].disks[g]);--b}else{if(0>=b&&this.RaidDisksData.raids[k].disks[g]&&this.freeDisks[this.RaidDisksData.raids[k].disks[g].id]){this.freeDisks[this.RaidDisksData.raids[k].disks[g].id].available=true}}}delete this.RaidDisksData.raids[k].disks;this.RaidDisksData.raids[k].disks=h;Ext.each(this.RaidDisksData.raids,function(i){h=[];Ext.each(i.disks,function(l){if(l&&!l.dummy){h.push(l)}},this);delete i.disks;i.disks=h},this);k=0;Ext.each(this.RaidDisksData.raids,function(i){if(this.pool&&this.pool.json.raids){a=this.pool.json.raids[k]}j=this.maxDisks-i.disks.length;if(-1<this.raidLevel.indexOf("shr")){d=this.requiredDiskForSHR;j=d}else{if(a&&"repair"===this.owner.add_type){d=parseInt(a.designedDiskCount,10)-i.disks.length;j=d;if("raid_6"===this.raidLevel){d=this.getRepairRequiredCount(h,a,d)}}else{if(a&&"expand_by_disk"===this.owner.add_type){d=parseInt(a.designedDiskCount,10)-i.disks.length+1}else{if(a&&"migrate"===this.owner.add_type){if("raid_1"===this.raidLevel&&2===parseInt(a.designedDiskCount,10)){d=parseInt(a.designedDiskCount,10)-i.disks.length+1}else{if(this.minDisks>parseInt(a.designedDiskCount,10)){d=this.minDisks-i.disks.length}else{if("raid_1"===this.pool.json.device_type&&"raid_1"!==this.raidLevel){d=this.minDisks-i.disks.length}else{d=parseInt(a.designedDiskCount,10)+1-i.disks.length}}}}else{d=this.minDisks-i.disks.length;if("raid_10"===this.raidLevel&&i.disks.length>this.minDisks&&1===i.disks.length%2){d=1}}}}}while(0<j){i.disks.push({raidNum:k,dummy:true,required:0<d,cls:0<d?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--j;--d}++k},this);this.checkLastRAID();this.prepareFreeDisksData();this.freeDisksPanel.view.store.loadData(this.FreeDisksData,false);this.raidDisksPanel.view.store.loadData(this.RaidDisksData,false)},dropOnBottomSToS:function(f){var l=parseInt(this.dropHint.dom.getAttribute("raidNum"),10);var g=0;var d,e,h,k;if(this.pool){if(this.pool.json.raids&&this.pool.json.raids[l]){g=parseInt(this.pool.json.raids[l].minDevSize,10)}else{g=parseInt(this.pool.get("minimal_disk_size"),10)}}var c=[];Ext.each(f,function(i){c.push(i.dom.getAttribute("devId"))},this);var j=[];var b=this.maxDisks;var a;if(this.pool&&this.pool.json.raids){a=this.pool.json.raids[l]}if(-1<this.raidLevel.indexOf("shr")){b=this.SHRDiskNum}else{if(a&&"repair"===this.owner.add_type){b=parseInt(a.designedDiskCount,10)}else{b=this.maxDisks}}for(h=0;h<this.RaidDisksData.raids[l].disks.length;++h){if(!this.RaidDisksData.raids[l].disks[h]){continue}if(this.RaidDisksData.raids[l].disks[h].dummy){break}if(0<b&&this.RaidDisksData.raids[l].disks[h]&&-1===c.indexOf(this.RaidDisksData.raids[l].disks[h].id)){j.push(this.RaidDisksData.raids[l].disks[h]);--b}else{if(0>=b&&this.RaidDisksData.raids[l].disks[h]){this.freeDisks[this.RaidDisksData.raids[l].disks[h].id].available=true}}if(this.RaidDisksData.raids[l].disks[h]&&this.RaidDisksData.raids[l].disks[h].id===this.dropHint.dom.getAttribute("devId")){Ext.each(f,function(o){var i=o.dom.getAttribute("devId");d=this.appWin.disks.data[i];if(d.get("size_total")>=g&&0<b){var n=parseInt(o.dom.getAttribute("raidNum"),10);for(var m=0;m<this.RaidDisksData.raids[n].disks.length;++m){if(this.RaidDisksData.raids[n].disks[m]&&this.RaidDisksData.raids[n].disks[m].id===d.id){this.RaidDisksData.raids[n].disks[m]=null;break}}j.push(this.createDisk(d,l,false,false,true));--b}},this)}}delete this.RaidDisksData.raids[l].disks;this.RaidDisksData.raids[l].disks=j;Ext.each(this.RaidDisksData.raids,function(i){j=[];Ext.each(i.disks,function(m){if(m&&!m.dummy){j.push(m)}},this);delete i.disks;i.disks=j},this);l=0;Ext.each(this.RaidDisksData.raids,function(i){if(this.pool&&this.pool.json.raids){a=this.pool.json.raids[l]}k=this.maxDisks-i.disks.length;if(-1<this.raidLevel.indexOf("shr")){e=this.requiredDiskForSHR;k=e}else{if(a&&"repair"===this.owner.add_type){e=parseInt(a.designedDiskCount,10)-i.disks.length;k=e;if("raid_6"===this.raidLevel){e=this.getRepairRequiredCount(j,a,e)}}else{if(a&&"expand_by_disk"===this.owner.add_type){e=parseInt(a.designedDiskCount,10)-i.disks.length+1}else{if(a&&"migrate"===this.owner.add_type){if("raid_1"===this.raidLevel&&2===parseInt(a.designedDiskCount,10)){e=parseInt(a.designedDiskCount,10)-i.disks.length+1}else{if(this.minDisks>parseInt(a.designedDiskCount,10)){e=this.minDisks-i.disks.length}else{if("raid_1"===this.pool.json.device_type&&"raid_1"!==this.raidLevel){e=this.minDisks-i.disks.length}else{e=parseInt(a.designedDiskCount,10)+1-i.disks.length}}}}else{e=this.minDisks-i.disks.length;if("raid_10"===this.raidLevel&&i.disks.length>this.minDisks&&1===i.disks.length%2){e=1}}}}}while(0<k){i.disks.push({raidNum:l,dummy:true,required:0<e,cls:0<e?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--k;--e}++l},this);this.checkLastRAID();this.prepareFreeDisksData();this.freeDisksPanel.view.store.loadData(this.FreeDisksData,false);this.raidDisksPanel.view.store.loadData(this.RaidDisksData,false)},checkAddNewRAID:function(h){if("repair"===this.owner.add_type){return}var b=this.RaidDisksData.raids[this.RaidDisksData.raids.length-1].disks;var d=false;var f={};Ext.each(b,function(i){if(i.dummy){d=true;return false}},this);if(d){return}var e=this.RaidDisksData.raids.length;f.id=String.format(this.subgroupName,(e+1));f.raidNum=e;f.disks=[];this.RaidDisksData.raids.push(f);var a=this.maxDisks;Ext.each(h,function(k){if(0===a){return false}var i=k.dom.getAttribute("devId");var j=this.appWin.disks.data[i];this.freeDisks[i].available=false;f.disks.push(this.createDisk(j,e,false,false,true));--a},this);var c=this.minDisks-f.disks.length;if("raid_10"===this.raidLevel&&f.disks.length>this.minDisks&&1===f.disks.length%2){c=1}var g=this.maxDisks-f.disks.length;while(0<g){f.disks.push({raidNum:e,dummy:true,required:0<c,cls:0<c?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--g;--c}this.prepareFreeDisksData();this.freeDisksPanel.view.store.loadData(this.FreeDisksData,false);this.raidDisksPanel.view.store.loadData(this.RaidDisksData,false)},checkAddNewDummyRaid:function(){if("repair"===this.owner.add_type){return}var b=true;Ext.each(this.RaidDisksData.raids,function(g){Ext.each(g.disks,function(h){if(h.dummy){b=false;return b}},this);return b},this);if(!b){return}var c=this.minDisks;var f=this.maxDisks;var a=[];var e=this.RaidDisksData.raids.length;var d={};if(e!==this.firstEditableRaid){c=0}while(0<f){a.push({raidNum:e,dummy:true,required:0<c,cls:0<c?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--f;--c}d.disks=a;d.id=String.format(this.subgroupName,(e+1));d.raidNum=e;this.RaidDisksData.raids.push(d);this.raidDisksPanel.view.store.loadData(this.RaidDisksData,false)},checkLastRAID:function(){var a=true,b,c;while(a){if(1>=this.RaidDisksData.raids.length){break}c=this.RaidDisksData.raids[this.RaidDisksData.raids.length-1];for(b=0;b<c.disks.length;b++){if(!c.disks[b].dummy){a=false;break}}if(a){this.RaidDisksData.raids.pop()}}if(this.isMultiRAIDMode()&&"migrate"!==this.owner.add_type){this.checkAddNewDummyRaid()}},isInDropZone:function(f,a){var g={begin:[0,0],end:[0,0]},d;if("freeDisks"===a){var b=Ext.get("freeDisksPanel");d=b.getXY();g.begin[0]=d[0];g.begin[1]=d[1];g.end[0]=d[0]+b.getWidth();g.end[1]=d[1]+b.getHeight()}else{var c=Ext.get("raidDisksPanel");d=c.getXY();g.begin[0]=d[0];g.begin[1]=d[1];g.end[0]=d[0]+c.getWidth();g.end[1]=d[1]+c.getHeight()}d=f.getXY();return((d[0]>=g.begin[0]&&d[1]>=g.begin[1])&&(d[0]<=g.end[0]&&d[1]<=g.end[1]))},getSelectedDisks:function(b){var a=[],c={};Ext.each(b.query(".sds-pool-create-device-selected"),function(){var d=new Ext.Element(this);if(d.hasClass("owner")){c[this.getAttribute("devId")]=true;Ext.each(d.next().query("div"),function(){var e=new Ext.Element(this);a.push(e)})}else{if(!c[this.getAttribute("owner")]){a.push(d)}}});return a},activate:function(){var c=this.getData("raid_type","");var a=this.getData("raid_level","");var d=this.getData("hdd_type","");var f=this.getData("raid_limit_number",6);var e=this.getData("manage_action","create");var b={};this.skipCheck=false;this.pool=this.getData("pool");if("migrate"===e){a=this.owner.getRaidLevel()}if(this.raidType!==c||this.raidLevel!==a||this.hddType!==d||this.raidLimitNum!==f){this.raidType=c;this.raidLevel=a;this.raidLimitNum=f;b.diskType=d;this.getFreeDisks(b);this.initialized=false}if(this.isMultiRAIDMode()){this.subgroupName=String.format("{0} ({1} {2})",_T("volume","volume_storage_pool"),_T("volume","volume_raid_subgroup"),"{0}")}else{this.subgroupName=_T("volume","volume_storage_pool")}this.decideMinMaxDiskNumber();if(!this.initialized){this.initialized=true;this.initializeRAIDData()}this.prepareFreeDisksData();this.freeDisksPanel.view.store.loadData(this.FreeDisksData,false);this.raidDisksPanel.view.store.loadData(this.RaidDisksData,false)},decideMinMaxDiskNumber:function(){var a=SYNO.SDS.StorageUtils.RAIDDiskMinMaxCountGet(this.raidLevel,this.raidLimitNum);this.minDisks=a.min;this.maxDisks=a.max},initializeRAIDData:function(){var c,b,d,a,e;this.RaidDisksData={};this.RaidDisksData.raids=[];if(this.pool&&this.pool.json.raids){this.pool.json.raids.sort(this.sortRaid);b=0;Ext.each(this.pool.json.raids,function(f){c={};c.id=String.format(this.subgroupName,(b+1));c.raidNum=b;c.disks=[];this.RaidDisksData.raids.push(c);Ext.each(f.devices,function(g){d=this.appWin.disks.data[g.id];if("crashed"===d.get("status")){return true}c.disks.push(this.createDisk(d,b,false,false,false))},this);c.disks.sort(SYNO.SDS.StorageUtils.DiskSort);if("repair"===this.owner.add_type){a=f.designedDiskCount-f.normalDevCount;e=a;if("raid_6"===this.raidLevel){a=1}}else{if("expand_by_disk"===this.owner.add_type){a=1;e=this.maxDisks-c.disks.length}else{if("migrate"===this.owner.add_type){if("raid_1"===this.raidLevel){a=1}else{if(this.minDisks>parseInt(f.designedDiskCount,10)){a=this.minDisks-c.disks.length}else{if("raid_1"===this.pool.json.device_type&&"raid_1"!==this.raidLevel){a=this.minDisks-c.disks.length}else{a=parseInt(f.designedDiskCount,10)+1-c.disks.length}}}e=this.maxDisks-c.disks.length}else{if("raid_10"===this.raidLevel&&c.disks.length>this.minDisks&&1===c.disks.length%2){a=1}e=a;if(this.isMultiRAIDMode()){e=this.maxDisks-c.disks.length}}}}if(0<e){this.firstEditableRaid=b}else{this.firstEditableRaid=b+1}while(0<e){c.disks.push({raidNum:b,dummy:true,required:0<a,cls:0<a?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--e;--a}++b},this);if(this.isMultiRAIDMode()){this.checkAddNewDummyRaid()}return}else{if("repair"===this.owner.add_type&&-1<this.raidLevel.indexOf("shr")){this.initSHRRAID();return}}this.firstEditableRaid=0;this.initialFirstRAID()},initSHRRAID:function(){var b=0,c=this.requiredDiskForSHR;var a={};a.id=String.format(this.subgroupName,(b+1));a.raidNum=b;a.disks=[];this.RaidDisksData.raids.push(a);Ext.each(this.pool.get("disks"),function(d){var e=this.appWin.disks.data[d];if("crashed"===e.get("status")){return true}a.disks.push(this.createDisk(e,b,false,false,false))},this);while(0<c){a.disks.push({raidNum:b,dummy:true,required:true,cls:"sds-space-required-disk nonselectable"});--c}this.SHRDiskNum=a.disks.length},initialFirstRAID:function(){var c={};var b=0;var e="";if(this.isMultiRAIDMode()){e=String.format(this.subgroupName,1)}else{e=this.subgroupName}c.id=e;c.raidNum=b;c.disks=[];this.RaidDisksData.raids.push(c);var a=this.minDisks-c.disks.length;if("raid_10"===this.raidLevel&&c.disks.length>this.minDisks&&1===c.disks.length%2){a=1}var d=this.maxDisks;while(0<d){c.disks.push({raidNum:0,dummy:true,required:0<a,cls:0<a?"sds-space-required-disk nonselectable":"sds-space-dummy nonselectable"});--d;--a}},prepareFreeDisksData:function(){var c={},g=false;if(0<this.minSizeRequiredDisks&&0<this.minSize){var f=0;Ext.each(this.selectedDisk,function(j){if(j.size_total>=this.minSize){++f}},this);var h=[];if(f<this.minSizeRequiredDisks){Ext.each(this.selectedDisk,function(j){if(j.size_total>=this.minSize){h.push(j)}else{j.available=true}},this);g=true}}for(var i in this.freeDisks){if(this.freeDisks.hasOwnProperty(i)){var a=this.freeDisks[i];if(!a.available){continue}var e=a.owner;if(!c[e]){c[e]={};c[e].id=e;c[e].name=0===a.container.order?_S("hostname"):a.container.str;c[e].order=a.container.order;c[e].disks=[]}var b=c[e];b.disks.push(a);b.disks.sort(SYNO.SDS.StorageUtils.DiskSort)}}delete this.FreeDisksData;this.FreeDisksData={};this.FreeDisksData.containers=[];for(i in c){if(c.hasOwnProperty(i)){this.FreeDisksData.containers.push(c[i])}}var d=function(k,j){if(k.order>j.order){return 1}if(k.order<j.order){return -1}return 0};this.FreeDisksData.containers.sort(d);Ext.each(this.FreeDisksData.containers,function(j){j.disks.sort(d)},this)},isValid:function(){if(this.isMultiRAIDMode()){return this.isValidMutiRaid()}else{return this.isValidSingleRaid()}},isValidMutiRaid:function(){var f=this,a=true,d,e,c=false,j=false,h=false;var g=function(i){if(!i.dummy&&i.is4Kn){j=true}else{if(!i.dummy){h=true}}if(!c&&i.dummy){c=true}a=!i.required;return a};for(d=0;d<this.RaidDisksData.raids.length;++d){if(0!==d&&d===this.RaidDisksData.raids.length-1){break}e=this.RaidDisksData.raids[d];Ext.each(e.disks,g,this)}if(j&&h){f.owner.getMsgBox().alert(f.owner.title,_T("volume","not_allow_hybrid_hdd"));return false}if(1===this.RaidDisksData.raids.length){if(!a){this.markupRequiredDisks()}else{this.owner.clearStatus()}return a}var b=true;if(a&&1<this.RaidDisksData.raids.length){e=this.RaidDisksData.raids[this.RaidDisksData.raids.length-1];b=e.disks[0].dummy;if(!b){Ext.each(e.disks,function(i){a=!i.required;return a},this)}}if(a&&c){this.markupAdditionalDisks();return false}else{this.owner.clearStatus()}if(!a){this.markupRequiredDisks()}else{this.owner.clearStatus()}return a},markupRequiredDisks:function(){this.owner.setStatusError({text:_T("volume","volume_fill_all_required_disks"),clear:3000});var a=Ext.get("raidDisksPanel").query(".sds-space-required-disk");Ext.each(a,function(e,b,d){var c=new Ext.Element(e);c.addClass("red-status")})},markupAdditionalDisks:function(){this.owner.setStatusError({text:_T("volume","volume_fill_all_additional_disks"),clear:3000});var a=Ext.get("raidDisksPanel").query(".sds-space-dummy");var b=this.RaidDisksData.raids.length-1;Ext.each(a,function(f,c,e){if(b===parseInt(f.getAttribute("raidNum"),10)){return true}var d=new Ext.Element(f);d.addClass("red-status")})},isValidSingleRaid:function(){var c=this,b=true,e=false,d=false;if(!this.RaidDisksData.raids[0]){return false}Ext.each(this.RaidDisksData.raids[0].disks,function(f){if(!f.dummy&&f.is4Kn){e=true}else{if(!f.dummy){d=true}}b=!f.required;return b},this);if(e&&d){c.owner.getMsgBox().alert(c.owner.title,_T("volume","not_allow_hybrid_hdd"));return false}if(!b){this.owner.setStatusError({text:_T("volume","volume_fill_all_required_disks"),clear:3000});var a=Ext.get("raidDisksPanel").query(".sds-space-required-disk");Ext.each(a,function(i,f,h){var g=new Ext.Element(i);g.addClass("red-status")})}else{this.owner.clearStatus()}return b},beforeNext:function(){var b=this;if(!this.isValid()){return false}if(this.skipCheck){return true}var a=new SYNO.SDS.StorageManager.Volume.Dialog.SpaceCreationWarningWindow({owner:this.owner,warningMsg:_T("volume","volume_adddisk_type_two_warning"),showPwrChk:false,next_id:this.nextId,callBack:function(c){if(c){b.skipCheck=true}}});a.open();return false},getDiskIds:function(){var a=[];if(!this.RaidDisksData){return a}Ext.each(this.RaidDisksData.raids,function(b){Ext.each(b.disks,function(c){if(""===c.used_by&&!c.dummy){a.push(c.id)}})});return a},getDiskShortName:function(c,b,a){if(0<c){return String.format("{0}-{1}",c,b)}else{return String.format("{0} {1}",a,b)}},getDiskGroups:function(){var a=[],b;if(!this.isMultiRAIDMode()){return a}if("migrate"===this.owner.add_type){return a}if(!this.RaidDisksData){return a}Ext.each(this.RaidDisksData.raids,function(e){var d=[];var f="new_raid",c=true;if(this.pool&&this.pool.json.raids&&this.pool.json.raids[e.raidNum]){f=this.pool.json.raids[e.raidNum].raidPath;c=false}Ext.each(e.disks,function(g){if(""===g.used_by&&!g.dummy){d.push(g.id)}},this);b={isNew:c,disks:d,raidPath:f};if(0<d.length){a.push(b)}},this);return a},getFreeDisks:function(a){var b=this;delete this.freeDisks;b.freeDisks={};if(!b.disks){b.disks=b.appWin.disks.getAll()}Ext.each(b.disks,function(f){var e,h,d,g;if(!f.isFree()){return true}if(!f.isNormalTray()){return true}if(b.appWin.hotSpares.data[f.id]){return}if(a.diskType&&a.diskType!==f.get("diskType")){return true}if("cache"===f.get("portType")){return}if("raid_f1"===this.raidLevel&&!f.get("isSsd")&&"no"===_D("sata_as_cache","no")){return}var c;if("internal"===f.get("container").type){c="host"}else{c="expander_"+f.get("container").order}e=f.get("container").order?f.get("container").order+" -":"";h=f.get("order");g=f.get("pciSlot");d=this.getDiskShortName(g,h,e);this.freeDisks[f.id]={container:{str:f.get("container").str,type:f.get("container").type,order:f.get("container").order||0},owner:c,device:f.get("device"),diskType:f.get("diskType"),driveType:f.isSSD()?"SSD":"HDD",id:f.id,order:f.get("order"),model:f.get("model"),name:SYNO.SDS.StorageUtils.DiskDisplayNameGet(f),longName:f.get("longName"),shortName:d,rpm:f.get("rpm"),serial:f.get("serial"),size_total:f.get("size_total"),size:SYNO.SDS.StorageUtils.SizeRender(f.get("size_total")),status:f.get("status"),temp:f.get("temp"),used_by:f.get("used_by"),available:true,dummy:false,is4Kn:f.get("is4Kn"),display4Kn:f.get("is4Kn")?String.format("({0})",_T("volume","4kn")):"",pciSlot:g,portType:f.get("portType"),ctnOrder:parseInt(f.get("container").order,10)}},this)},getNames:function(){var a=[];Ext.each(this.RaidDisksData.raids,function(b){Ext.each(b.disks,function(c){if(!c.dummy&&c.used_by.empty()){a.push(c.longName)}},this)},this);return a},isMultiRAIDMode:function(){if("multiple"!==this.raidType){return false}switch(this.raidLevel){case"raid_5":case"raid_6":case"raid_f1":break;default:return false}return true},updateData:function(a){a.disk_ids=this.getDiskIds();a.disk_groups=this.getDiskGroups()},summary:function(b){var a=this.getNames();if(a.length>0){b.append(_T("volume","volume_apply_disk"),a.join(", "))}},createDisk:function(a,h,c,d,f){var i=a.get("container").order?a.get("container").order+" -":"";var g=a.get("order");var b=a.get("pciSlot");var e=this.getDiskShortName(b,g,i);return{container:{str:a.get("container").str,type:a.get("container").type,order:a.get("container").order||0},device:a.get("device"),diskType:a.get("diskType"),driveType:a.isSSD()?"SSD":"HDD",id:a.id,numId:a.get("num_id"),ctnOrder:a.get("container").order,order:a.get("order"),model:a.get("model"),name:SYNO.SDS.StorageUtils.DiskDisplayNameGet(a),longName:SYNO.SDS.StorageUtils.DiskDisplayNameGet(a),shortName:e,rpm:a.get("rpm"),serial:a.get("serial"),size_total:a.get("size_total"),size:SYNO.SDS.StorageUtils.SizeRender(a.get("size_total")),status:a.get("status"),temp:a.get("temp"),used_by:a.get("used_by"),raidNum:h,available:c,dummy:d,cls:f?"selectable":"nonselectable",is4Kn:a.get("is4Kn"),display4Kn:a.get("is4Kn")?String.format("({0})",_T("volume","4kn")):"",portType:a.get("portType"),pciSlot:b}},sortRaid:function(h,e){var g=h.raidPath.split("/")[2].split("d")[1];var d=e.raidPath.split("/")[2].split("d")[1];var f=h.designedDiskCount;var c=e.designedDiskCount;if(f>c){return -1}else{if(f<c){return 1}}g=parseInt(g,10);d=parseInt(d,10);if(g>d){return 1}if(g<d){return -1}return 0}});Ext.define("SYNO.SDS.StorageManager.Wizard.DeletePool",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this,b;c.isDataChanged=false;c.appWin=a.appWin;c.owner=a.owner;c.pool=a.poll;c.services=undefined;b={title:_T("volume","volume_remove_raid_group"),width:640,height:350,resizable:false,layout:"fit",items:[{xtype:"syno_formpanel",itemId:"main",border:false,items:[{xtype:"syno_displayfield",value:"",id:c.descID=Ext.id(),itemId:"desc"},c.grid=new SYNO.SDS.Wizard.SummaryStep({layout:"fit",height:200})]}],buttons:[{xtype:"syno_button",btnStyle:"red",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","remove"),id:c.applyButtonID=Ext.id(),scope:c,handler:c.onSave},{xtype:"syno_button",text:_T("common","alt_cancel"),scope:c,handler:c.onCancel}]};c.callParent([Ext.apply(b,a)])},onOpen:function(){var c=this,a=c.grid.getStore(),e,d,b;c.callParent(arguments);if(c.pool.isSingleLun()){e=c.appWin.iscsiLuns.data[c.pool.get("deploy_path")];if(!e){return}a.append(_T("tree","leaf_raid"),c.pool.getName());a.append(_T("volume","volume_iscsitrg_lun"),e.get("iscsi_lun").name);if(c.appWin.supportSsdCache&&0<c.appWin.ssdCaches.count){Ext.each(c.appWin.ssdCaches.getAll(),function(f){if(-1<f.get("path").indexOf(e.get("iscsi_lun").name)){a.append(_T("volume","ssd_cache"),String.format("{0}({1})",_T("volume","ssd_cache"),e.get("iscsi_lun").name));return false}},c)}return}if(c.pool.isSingleVolume()){b="SYNO.Storage.CGI.Volume";d={space_id:[c.pool.get("deploy_path")]}}else{b="SYNO.Storage.CGI.Pool";d={space_id:c.pool.get("id")}}c.setStatusBusy();SYNO.API.Request({api:b,method:"enum_resource",version:1,params:d,callback:function(i,h,g,f){c.clearStatusBusy();if(!i){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,h);return}c.loadData(h,g)},scope:c})},loadData:function(f,e){var j=this;var l=SYNO.SDS.StorageUtils;var m={},d={},g=[];var a=l.CheckFailedMsg(f.check);var c=false;var i,h,k;var b=function(o){var n=true;if("single"===j.pool.get("raidType")&&j.pool.get("deploy_path")){o.space_id.each(function(p){if("crashed"!==j.owner.volumes.data[p].get("status")){n=false;return false}});if(n){Ext.getCmp(j.applyButtonID).enable();Ext.getCmp(j.descID).setValue(_T("volume","del_soft_check_fail"))}}else{if("crashed"===j.owner.storagePools.data[o.space_id].get("status")){Ext.getCmp(j.applyButtonID).enable();Ext.getCmp(j.descID).setValue(_T("volume","del_soft_check_fail"))}}};if("hard_failed"===a){c=true;Ext.getCmp(j.applyButtonID).disable();Ext.getCmp(j.descID).setValue(_T("volume","del_hard_check_fail"));b(e)}else{if("soft_failed"===a){Ext.getCmp(j.descID).setValue(_T("volume","del_soft_check_fail"))}else{Ext.getCmp(j.descID).setValue(_T("volume","volume_delete_summary_desc"))}}h=j.grid.getStore();h.append(_T("volume","volume_storage_pool"),j.pool.getName());if(f.check&&f.check.pools){l.CheckMsg(f.check,c,"pools",h)}if("single"===j.pool.get("raidType")&&j.pool.get("deploy_path")){k=l.SpaceIDParser(j.pool.get("deploy_path")).str;h.append(_T("volume","volume"),k);l.CheckMsg(f.check,c,"volumes",h);if(j.appWin.supportSsdCache&&0<j.appWin.ssdCaches.count){Ext.each(j.appWin.ssdCaches.getAll(),function(n){var o=j.pool.get("deploy_path").replace("_","");if(-1<n.get("path").indexOf(o)){h.append(_T("volume","ssd_cache"),_T("volume","ssd_cache")+"("+k+")");return false}},j)}}if(f.services&&f.services.length>0){h.append(_T("volume","volume_warninglistservice"),l.getServiceNames(f.services))}if(f.shares&&f.shares.length>0){h.append(_T("volume","volume_status_warningdelinfo"),l.getNamesString(f.shares));l.CheckMsg(f.check,c,"shares",h)}if(f.iscsiluns&&f.iscsiluns.length>0){h.append(_T("volume","volume_iscsitrg_lun"),l.getNamesString(f.iscsiluns));l.CheckMsg(f.check,c,"iscsiluns",h)}if(f.volumes&&f.volumes.length>0){h.append(_T("volume","volume"),l.getVolumeNames(f.volumes));l.CheckMsg(f.check,c,"volumes",h)}if(f.pkgs&&f.pkgs.length>0){h.append(_T("pkgmgr","title_packages"),l.getNamesString(f.pkgs))}j.services=f.services;if(!j.appWin.supportSsdCache){return}Ext.each(f.volumes,function(n){m[n.name]=true});Ext.each(f.iscsiluns,function(n){d[n.name]=true});Ext.each(j.appWin.ssdCaches.getAll(),function(n){i=n.get("mountSpaceId");if(m[i]){g.push(String.format("{0}({1})",l.SpaceIDParser(n.get("id")).str,l.SpaceIDParser(i).str))}if(d[l.SpaceIDParser(i).num]){g.push(String.format("{0}({1})",l.SpaceIDParser(n.get("id")).str,l.SpaceIDParser(i).num))}},j);if(0<g.length){h.append(_T("volume","ssd_cache"),g.join(", "))}},onSave:function(){var b=this,c,a,f,e;if(b.pool.isSingleLun()){var d=b.appWin.iscsiLuns.getById(b.pool.get("deploy_path"));a="SYNO.Storage.CGI.Pool";f="remove_lun";c={lid:[d.get("iscsi_lun").lid]}}else{if(b.pool.isSingleVolume()){a="SYNO.Storage.CGI.Volume";f="delete";c={delete_space:true,space_id:[b.pool.get("deploy_path")]}}else{a="SYNO.Storage.CGI.Pool";f="delete";c={space_id:b.pool.get("id")}}}c.force=true;e=String.format('1. <font class="red-status">{0}</font><br/>',_T("volume","volume_delete_warning"));e+=String.format("2. {0}",_T("volume","volume_all_service_stop"));b.getMsgBox().confirm(_T("tree","leaf_volume"),e,function(g){if("yes"===g){SYNO.SDS.Utils.PasswordConfirmDialog.openDialog(b,b.applySettings,[a,f,c])}},b)},onCancel:function(){this.close()},applySettings:function(a,d,b){var c={};this.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:a,method:d,version:1,params:b,callback:function(h,g,f,e){this.clearStatusBusy();if(!h){if(SYNO.SDS.StorageUtils.IsFeasibilityFail(g,c)){SYNO.SDS.StorageUtils.ConfirmFeasibilityFail(this,c,this.applySettings,a,d,f)}else{SYNO.SDS.StorageUtils.HARemoteCheckErrParsing(g);SYNO.SDS.StorageUtils.ReportWebapiFailure(this,g)}return}this.disableServices(this.services);this.isDataChanged=true;this.close()},scope:this})},disableServices:function(a){var b={media:undefined,audio:"SYNO.SDS.AudioStation.Application",itunes:undefined,photo:"SYNO.SDS.PhotoStation",web:"SYNO.SDS.WebStation",netbkp:undefined,download:"SYNO.SDS.DownloadStation",mysql:undefined,surveillance:"SYNO.SDS.SurveillanceStation",userhome:undefined,weblocal:undefined};Ext.each(a,function(c){if(Ext.isString(b[c])){SYNO.SDS.StatusNotifier.setServiceDisabled(b[c],true)}})}});Ext.define("SYNO.SDS.StorageManager.Wizard.CreatePoolMain",{extend:"SYNO.SDS.StorageManager.Wizard.ModalWindow",constructor:function(a){var c=this,b;c.isDataChanged=false;c.appWin=a.appWin;c.owner=a.owner;b={title:_T("volume","volume_raid_creation_title"),mode:"pool_create",width:700,height:520,minHeight:475,minWidth:700,resizable:true,border:false,steps:[]};if(!this.appWin.isSingleBay()){b.steps.push(new SYNO.SDS.StorageManager.Wizard.PoolTypeStep({appWin:c.appWin,itemId:"raid_type",nextId:"property"}))}b.steps.push(new SYNO.SDS.StorageManager.Wizard.PoolPropertyStep({appWin:c.appWin,itemId:"property",nextId:"disk"}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.DiskStep({appWin:c.appWin,itemId:"disk",nextId:"disk_check"}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.DiskCheckStep({appWin:c.appWin,itemId:"disk_check",nextId:"summary"}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.CreatePoolSummaryStep({appWin:c.appWin,itemId:"summary",nextId:null}));c.callParent([Ext.apply(b,a)])},onOpen:function(){if(this.appWin.isSingleBay()){this.setData("raid_type","single")}this.setData("create_for","storage_pool");this.callParent(arguments)},getRaidType:function(){return this.getData("raid_type","")},getDesc:function(){return this.getData("pool_description","")},getRaidLevel:function(){var a=this.getData("raid_level","");var b=this.getData("disk_ids",[]);if("shr_2"===a){a="shr_with_2_disk_protect"}else{if("shr"===a){if(b.length===1){a="shr_without_disk_protect"}else{a="shr_with_1_disk_protect"}}}return a},getRaidLimitNum:function(){return this.getData("raid_limit_number")},getHddType:function(){return this.getData("hdd_type")},getDiskIds:function(){return this.getData("disk_ids")},getDiskGroups:function(){return this.getData("disk_groups")},getDiskCheck:function(){return this.getData("disk_check")},applySettings:function(a){var b={};var c={};b.disk_id=this.getDiskIds();b.device_type=this.getRaidLevel();b.is_disk_check=this.getDiskCheck();b.is_pool_child=false;b.allocate_size="0";b.spare_disk_count="0";b.desc=this.getDesc();b.is_unused="single"===this.getRaidType();b.diskGroups=this.getDiskGroups();b.limitNum=this.getRaidLimitNum().toString();b.force=a||false;if(1>=b.diskGroups.length){delete b.diskGroups}this.getButton("next").disable();this.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:"SYNO.Storage.CGI.Pool",method:"create",version:1,params:b,callback:function(h,g,f,d){var e="";this.clearStatusBusy();if(!h){if(SYNO.SDS.StorageUtils.IsFeasibilityFail(g,c)){SYNO.SDS.StorageUtils.ConfirmFeasibilityFail(this,c,this.applySettings,true)}else{SYNO.SDS.StorageUtils.HARemoteCheckErrParsing(g);SYNO.SDS.StorageUtils.ReportWebapiFailure(this,g)}return}this.getButton("next").enable();this.getButton("next").setText(_T("common","alt_finish"));this.isDataChanged=true;e=String.format(_T("volume","volume_create_vol_lun_hint"),_T("volume","volume_storage_pool"));this.owner.getMsgBox().alert(this.owner.title,e);this.close()},scope:this})}});Ext.define("SYNO.SDS.StorageManager.Wizard.PoolTypeStep",{extend:"SYNO.SDS.StorageManager.Wizard.Step",constructor:function(a){var c=this,b;var d=a.appWin.getMaxVolumeSize()<=16*Math.pow(1024,4);var e=String.format('<span class="syno-ux-note">{0}{1} </span>{2}',_T("common","note"),_T("common","colon"),"{0}");c.setDefault=true;c.appWin=a.appWin;b={headline:_T("volume","volume_raid_purpose_title"),listeners:{afterlayout:this.addTip,scope:this,single:true},items:[{xtype:"syno_displayfield",value:_T("volume","pool_type_step_description")},{xtype:"syno_displayfield",cls:"sm-empty-line"},{xtype:"syno_radio",boxLabel:_T("volume","pool_type_for_performance"),name:"RaidType",itemId:"singleVolume",inputValue:"single"},{xtype:"syno_displayfield",indent:1,value:_T("volume","pool_support_single_volume")},{xtype:"syno_displayfield",indent:1,htmlEncode:false,value:String.format(e,_T("volume","pool_single_volume_disk_number_limit_note")),hidden:!this.appWin.supportRaidGroup},{xtype:"syno_displayfield",indent:1,htmlEncode:false,value:String.format(e,_T("volume","pool_single_volume_size_limit_note")),hidden:!d},{xtype:"syno_displayfield",cls:"sm-empty-line"},{xtype:"syno_radio",boxLabel:_T("volume","pool_type_for_flexibility"),name:"RaidType",itemId:"multiple",inputValue:"multiple"},{xtype:"syno_displayfield",indent:1,value:_T("volume","pool_support_multiple_volume")},{xtype:"syno_displayfield",htmlEncode:false,indent:1,value:String.format(e,_T("volume","pool_support_shr")),hidden:!this.appWin.isSupportSHR||this.appWin.supportRaidGroup||_S("ha_running")},{xtype:"syno_displayfield",itemId:"supportRaidGroupField",htmlEncode:false,indent:1,value:String.format(e,_T("volume","pool_support_raid_group")),hidden:!this.appWin.supportRaidGroup}]};c.callParent([Ext.apply(b,a)])},getRaidType:function(){return this.getForm().getValues().RaidType},getNext:function(){return this.nextId},isSkip:function(){return this.appWin.isSingleBay()},updateData:function(a){a.raid_type=this.getRaidType()},addTip:function(){var a=this.getComponent("supportRaidGroupField");var b=_T("volume","raid_group_feature_info");if(!a||typeof a.getEl()==="undefined"){return}SYNO.SDS.Utils.AddTip(a.getEl(),Ext.util.Format.htmlEncode(b))},activate:function(){if(!this.setDefault){return}this.getComponent("singleVolume").setValue(true);this.setDefault=false},summary:function(a){var b="single"===this.getRaidType()?_T("common","no"):_T("common","yes");a.append(_T("volume","volume_multiple_vol_lun_support"),b)}});Ext.define("SYNO.SDS.StorageManager.Wizard.PoolPropertyStep",{extend:"SYNO.SDS.StorageManager.Wizard.Step",constructor:function(a){var d=this;var b=[];var c;d.setDefault=true;d.setDefaultDesc=true;d.appWin=a.appWin;d.currentRaidType=null;d.currentRaidLimit=12;d.isNeedSelectSource=!d.appWin.isSupportRaidCross()&&d.appWin.isSupportEbox()&&d.appWin.isEboxPluged();d.isOneBayBasicVolume=this.appWin.isSingleBay();d.tabList=[];d.tabList.push(["SAS","SAS"]);if("no"===_D("support_dual_head","no")){d.tabList.push(["SATA","SATA"])}if("yes"===_D("supportnvme")){d.tabList.push(["NVMe","NVMe"])}if(d.isNeedSelectSource){b.push({xtype:"syno_storage_disableable_combobox",name:"hddSource",itemId:"hddSource",lazyRender:true,store:new Ext.data.ArrayStore({id:"value",fields:["text","value","disabled"]}),fieldLabel:_T("volume","pool_disk_source"),displayField:"text",valueField:"value",forceSelection:true,mode:"local",allowBlank:false,listeners:{select:this.onDiskSourceSelect,scope:this}})}b=b.concat([{xtype:"syno_textfield",itemId:"desc",name:"desc",fieldLabel:_T("volume","pool_desc"),maxLength:64,enableKeyEvents:true,listeners:{keypress:function(){this.setDefaultDesc=false},scope:this}},{xtype:"syno_combobox",name:"level",itemId:"level",hiddenName:"level",store:this.levelStore=new Ext.data.ArrayStore({id:"value",fields:["text","value"]}),fieldLabel:_T("volume","volume_raid_title"),displayField:"text",valueField:"value",forceSelection:true,mode:"local",allowBlank:false,validator:function(){var e=d.getForm().getValues().level||"basic";var h=SYNO.SDS.StorageUtils.RAIDDiskMinMaxCountGet(e);var f=d.getFreeDisksBySettings();var g=f.length;var i=d.filterDisksBySSD(f).length;if(("raid_f1"===e&&h.min>i)||(h.min>g)){d.owner.getButton("next").disable();return _T("volume","volume_create_pool_without_enough_disk_warning")}else{d.owner.getButton("next").enable();return true}},listeners:{select:this.onRaidLevelChanged,scope:this}},{xtype:"syno_displayfield",itemId:"minDiskNum",anchor:"95%",fieldLabel:_T("volume","min_raid_disk_number"),value:"0"},{xtype:"syno_combobox",name:"limitNum",itemId:"limitNum",hiddenName:"limitNum",hiddenValue:0,hidden:!this.appWin.supportRaidGroup,store:new Ext.data.ArrayStore({data:[["6",6],["12",12],["24",24]],id:"value",fields:["text","value"]}),fieldLabel:_T("volume","limit_raid_disk_number"),displayField:"text",valueField:"value",mode:"local",allowBlank:false,listeners:{select:this.onLimitedChanged,scope:this}},{xtype:"syno_combobox",name:"hddType",itemId:"hddType",hiddenName:"hddType",store:new Ext.data.ArrayStore({data:d.tabList,id:"value",fields:["text","value"]}),fieldLabel:_T("volume","volume_hdd_type"),displayField:"text",valueField:"value",forceSelection:true,mode:"local",allowBlank:false,listeners:{select:this.onHddTypeSelect,scope:this},hidden:!d.appWin.supportSas||("yes"===_D("support_dual_head","no"))},{xtype:"syno_displayfield",itemId:"raidGroupFeature",fieldLabel:_T("volume","raid_group_feature"),value:_T("common","not_support"),hidden:!d.appWin.supportRaidGroup},{xtype:"syno_displayfield",itemId:"raidDescription",hidden:true,hideLabel:true,htmlEncode:false,anchor:"95%"}]);c={headline:_T("volume","volume_raid_property"),labelWidth:300,listeners:{afterlayout:function(){this.addTip("limitNum",_T("volume","limit_raid_disk_number_info"))},scope:this,single:true},items:b};d.callParent([Ext.apply(c,a)])},addTip:function(c,b){var a=this.getComponent(c);if(!a||typeof a.getEl()==="undefined"){return}SYNO.SDS.Utils.AddTip(a.getEl(),Ext.util.Format.htmlEncode(b))},onRaidLevelChanged:function(b,c,a){this.updateForm()},onLimitedChanged:function(b,c,a){this.currentRaidLimit=this.getRaidLimit()},onHddTypeSelect:function(){this.setDefaultLevel();this.updateForm()},onDiskSourceSelect:function(d,a,b,c){if(!a){return}if(this.appWin.isSingleBayWithEbox()){this.isOneBayBasicVolume=a.data.value==="internal";this.levelStore.loadData(this.generateLevelStore(),false)}this.setDefaultLevel();this.updateForm()},matchFirstRule:function(b,c,a){if(""!==a){return a}return b?c:a},setDefaultLevel:function(){var d=this.getComponent("level");var e=d.getStore();var f=this.getData("quick_mode",false);var h=this.getData("raid_type","single");var a="";var c;var i=this.getFreeDisksBySettings();var b=i.length;var g=this.filterDisksBySSD(i).length;if(this.appWin.supportDiffRaid&&this.isAllFlashModel()){c="FS_model"}else{if(this.appWin.supportRaidGroup){c="raidgroup_model"}else{if(this.isOneBayBasicVolume){c="basic"}else{if(f){c="quick_mode"}else{if("multiple"===h){c="multiple_mode"}else{c="single_volume"}}}}}switch(c){case"FS_model":a=this.matchFirstRule(3<=g,"raid_f1",a);a=this.matchFirstRule(3<=b,"raid_5",a);a=this.matchFirstRule(2===b,"raid_1",a);a=this.matchFirstRule(1===b,"basic",a);break;case"raidgroup_model":case"single_volume":a=this.matchFirstRule(3<=b,"raid_5",a);a=this.matchFirstRule(2===b,"raid_1",a);a=this.matchFirstRule(1===b,"basic",a);break;case"basic":a="basic";break;case"quick_mode":a=this.matchFirstRule(true,"shr",a);break;case"multiple_mode":if(!_S("ha_running")){a=this.matchFirstRule(true,"shr",a)}a=this.matchFirstRule(3<=b,"raid_5",a);a=this.matchFirstRule(2===b,"raid_1",a);a=this.matchFirstRule(1===b,"basic",a);break;default:break}if(""===a){a=e.getAt(0).data.value}d.setValue(a);d.setDisabled(this.levelStore.data.items.length<2)},updateRAID:function(){var c=this;var b=c.getData("raid_type","single");var a=c.getComponent("level").getValue()||"basic";var d=SYNO.SDS.StorageUtils.RAIDDiskMinMaxCountGet(a);var e=d.min;if(c.appWin.supportRaidGroup&&"multiple"===b&&d.raidGroup){c.getComponent("limitNum").setValue(c.currentRaidLimit);c.getComponent("limitNum").enable();c.getComponent("raidGroupFeature").setValue(_T("pkgmgr","support"))}else{c.getComponent("limitNum").setValue(24);c.getComponent("limitNum").disable();c.getComponent("raidGroupFeature").setValue(_T("common","not_support"))}c.addTip("raidGroupFeature",_T("volume","raid_group_feature_info"));if(a==="shr"){e+=String.format(" ({0})",_T("volume","shr_one_drive_no_data_protection_info"))}this.getComponent("minDiskNum").setValue(e)},updateDesc:function(){var a=this.getRaidLevel();if(this.setDefaultDesc){this.getComponent("desc").setValue(SYNO.SDS.StorageUtils.RaidLevelRender(a))}},updateRaidDesc:function(){var a=this.getRaidLevel();var d=this.getComponent("raidDescription");var b=String.format(_T("volume","pool_raid_desc"),SYNO.SDS.StorageUtils.RaidLevelRender(a));var c;switch(a){case"shr":case"shr_2":c=_T("volume","volume_type_description_shr");break;case"basic":c=_T("volume","volume_type_description_basic");break;case"raid_linear":c=_T("volume","volume_type_description_linear");break;case"raid_0":c=_T("volume","volume_type_description_raid_0");break;case"raid_1":c=_T("volume","volume_type_description_raid_1");break;case"raid_10":c=_T("volume","volume_type_description_raid_10");break;case"raid_5":c=_T("volume","volume_type_description_raid_5");break;case"raid_6":c=_T("volume","volume_type_description_raid_6");break;case"raid_f1":c=_T("volume","volume_type_description_raid_f1");break;default:d.hide();return}d.setValue('<div class="sds-pool-raid-desc"><div><a>'+b+"</a></div><div>"+c+"</div></div>");d.show();this.doLayout()},updateForm:function(){this.updateRAID();this.updateDesc();this.updateRaidDesc()},pushWhenMatch:function(a,b,c){if(a){b.push(c)}},generateLevelStore:function(){var c=this.getData("raid_type","single");var a=this.getData("quick_mode",false);var e=String.format("{0}+Spare",_T("volume","volume_type_raid_5"));var d=[];var b=0;var f={};Ext.each(this.appWin.disks.getAll(),function(i){if("disabled"===i.get("portType")||i.isCacheTray()){return true}var h=i.get("container");if(Ext.isNumber(f[h.order])){return true}var g;if("ebox"===h.type){if(this.appWin.supportSas&&this.appWin.AHAInfo){g=this.appWin.AHAInfo.enclosures[h.order-1].max_disk}else{g=SYNO.SDS.StorageUtils.GetEboxBayNumber(h.str);if(0===g){return true}}}else{g=parseInt(_D("maxdisks","1"),10)}f[h.order]=g},this);Ext.iterate(f,function(g,h){if(this.appWin.isSupportRaidCross()){b+=h}else{b=Math.max(b,h)}},this);if(a){this.pushWhenMatch(1<=b,d,["SHR","shr"]);this.pushWhenMatch(4<=b,d,["SHR-2","shr_2"]);return d}if(!this.appWin.supportRaidGroup&&this.appWin.isSupportSHR()&&"multiple"===c&&!_S("ha_running")){this.pushWhenMatch(1<=b,d,["SHR","shr"]);this.pushWhenMatch(4<=b,d,["SHR-2","shr_2"])}this.pushWhenMatch(2<=b,d,[_T("volume","volume_type_raid_1"),"raid_1"]);this.pushWhenMatch(3<=b,d,[_T("volume","volume_type_raid_5"),"raid_5"]);if(!this.appWin.supportHotSpare){this.pushWhenMatch(4<=b,d,[e,"raid_5+spare"])}this.pushWhenMatch(4<=b,d,[_T("volume","volume_type_raid_6"),"raid_6"]);this.pushWhenMatch(4<=b,d,[_T("volume","volume_type_raid_10"),"raid_10"]);this.pushWhenMatch(1<=b,d,[_T("volume","volume_type_basic"),"basic"]);this.pushWhenMatch(1<=b,d,[_T("volume","volume_type_linear"),"raid_linear"]);this.pushWhenMatch(2<=b,d,[_T("volume","volume_type_raid_0"),"raid_0"]);if(this.appWin.supportDiffRaid){this.pushWhenMatch(3<=b,d,[_T("volume","volume_type_raid_f1"),"raid_f1"])}if(this.appWin.isSingleBay()){if(!this.isNeedSelectSource||(this.isNeedSelectSource&&"internal"===this.getDiskSource())){d=[[_T("volume","volume_type_basic"),"basic"]]}}return d},filterDisksBySource:function(b,a){if(!b||!Ext.isArray(b)){return[]}a=a||this.getDiskSource();if(a==="internal"){return b.filter(function(c){return c.isInternal()})}else{if(a==="ebox"){return b.filter(function(c){return c.isInEbox()})}else{return b.filter(function(){return true})}}},filterDisksByHddType:function(a){if(!a||!Ext.isArray(a)){return[]}var b=this.getHddType();return a.filter(function(c){return c.get("diskType")===b})},filterDisksBySSD:function(a){if(!a||!Ext.isArray(a)){return[]}return a.filter(function(b){return b.isSSD()})},getAllFreeDisks:function(){if(!this.allFreeDisks){this.allFreeDisks=this.appWin.disks.getMatched("isNormalTray","isFree")}return this.allFreeDisks},getFreeDisksBySettings:function(){var a=this.getAllFreeDisks();a=this.filterDisksBySource(a);a=this.filterDisksByHddType(a);return a},getNext:function(){if(!this.getForm().isValid()){return false}return this.nextId},getDiskSource:function(){var a=this.getComponent("hddSource");return a?a.getValue():false},getRaidLevel:function(){return this.getComponent("level").getValue()},getRaidLimit:function(){return this.getComponent("limitNum").getValue()},getDescription:function(){return this.getComponent("desc").getValue()},getHddType:function(){return this.getComponent("hddType").getValue()},getDefaultHddType:function(){var c=false;var b=false;var a=this.getAllFreeDisks();Ext.each(a,function(e){var d=e.get("diskType");if("SATA"===d){c=true}else{if("SAS"===d){b=true}}});if(b){return"SAS"}else{if(c){return"SATA"}else{return this.appWin.supportSas?"SAS":"SATA"}}},isAllFlashModel:function(){return/^fs[0-9]*/i.test(_D("upnpmodelname"))},activate:function(){var d=this;var j=d.getData("create_for")==="storage_pool";var g=d.getData("raid_type","");var f=d.currentRaidType!==g;var h=this.getAllFreeDisks();var c=this.filterDisksBySource(h,"internal");var e=this.filterDisksBySource(h,"ebox");d.currentRaidType=g;if(d.isNeedSelectSource){var b=d.getComponent("hddSource");var i=c.length<=0||(this.appWin.isSingleBay()&&j);var a=e.length<=0;b.getStore().loadData([[_T("volume","volume_disk_source_internal"),"internal",i],[_T("volume","volume_disk_source_ebox"),"ebox",a]],false);if(!i){b.setValue("internal");this.isOneBayBasicVolume=this.appWin.isSingleBay()}else{if(!a){b.setValue("ebox");this.isOneBayBasicVolume=false}}f=true}d.levelStore.loadData(this.generateLevelStore(),false);if(f){d.getComponent("hddType").setValue(this.getDefaultHddType());d.setDefaultLevel()}d.updateForm()},updateData:function(a){a.raid_level=this.getRaidLevel();a.raid_limit_number=this.getRaidLimit();a.hdd_type=this.getHddType();a.pool_description=this.getDescription();if(this.isNeedSelectSource){a.disk_source=this.getDiskSource()}},summary:function(d){var c=this;var b=c.owner.getRaidLevel();var a=c.getRaidLimit();d.append(_T("volume","pool_desc"),c.getDescription());if(b.substr(0,3)!=="shr"){d.append(_T("volume","volume_raid_title"),SYNO.SDS.StorageUtils.DeviceTypeRender(b),true)}else{d.append(_T("volume","volume_raid_title"),SYNO.SDS.StorageUtils.SpaceTypeRender(b),true)}if(c.appWin.supportSas){d.append(_T("volume","volume_hdd_type"),c.getHddType())}if(c.appWin.supportRaidGroup&&"basic"!==b&&"raid_1"!==b){d.append(_T("volume","limit_raid_disk_number"),a)}}});Ext.define("SYNO.SDS.StorageManager.Wizard.CreatePoolSummaryStep",{extend:"SYNO.SDS.StorageManager.Wizard.SummaryStep",constructor:function(a){var b={headline:_T("volume","volume_wizard_summary_title")};this.callParent([Ext.apply(b,a)])},activate:function(){this.callParent(arguments);this.owner.setStatusBusy();this.owner.getButton("next").disable();var a={};a.estimate_for="create";a.disk_id=this.owner.getDiskIds();a.device_type=this.owner.getRaidLevel();a.diskGroups=this.owner.getDiskGroups();if(1>=a.diskGroups.length){delete a.diskGroups}SYNO.API.Request({api:"SYNO.Storage.CGI.Pool",method:"estimate_size",version:1,params:a,callback:function(e,d,c,b){this.owner.clearStatusBusy();if(!e){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,d);this.owner.getButton("next").disable();return}if(!_S("demo_mode")){this.owner.getButton("next").enable()}this.getStore().append(_T("volume","volume_totalsize"),_T("volume","volume_add_warningabout")+" "+SYNO.SDS.StorageUtils.SizeRender(d.size))},scope:this})},getNext:function(){this.owner.applySettings();return false}});Ext.define("SYNO.SDS.StorageManager.Wizard.EditPool",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){var d=this,c;d.isDataChanged=false;d.appWin=b.appWin;d.owner=b.owner;var e={xtype:"syno_fieldset",collapsible:false,title:_T("common","general"),itemId:"general",name:"general",items:[{xtype:"syno_textfield",validateOnBlur:true,validationEvent:"blur",name:"desc",itemId:"desc",fieldLabel:_T("share","share_comment"),disabled:true,width:250,maxLength:64}]};var a={xtype:"syno_fieldset",collapsible:false,title:_T("volume","stripe_cache_size"),itemId:"fieldset_stripe_cache_size",name:"fieldset_stripe_cache_size",items:[{xtype:"syno_displayfield",value:_T("volume","stripe_cache_size_explain")},{xtype:"syno_displayfield",itemId:"not_support_displayfield",value:_T("volume","stripe_cache_size_not_support"),hidden:true},{xtype:"syno_radio",itemId:"default_radio",name:"stripe_cache_size",boxLabel:_T("volume","stripe_cache_size_default"),inputValue:"default",disabled:true,indent:1},{xtype:"syno_radio",itemId:"small_radio",name:"stripe_cache_size",boxLabel:_T("volume","stripe_cache_size_small"),inputValue:"small",disabled:true,indent:1},{xtype:"syno_displayfield",htmlEncode:false,value:String.format('<span class="syno-ux-note">{0}{1} </span>{2}',_T("common","note"),_T("common","colon"),_T("volume","stripe_cache_size_notice"))}]};c={title:_T("common","common_settings"),items:[new SYNO.ux.FormPanel({itemId:"settingPanel",border:false,trackResetOnLoad:true,labelWidth:130,items:[e,a]})],width:480,height:440,resizable:false,layout:"fit",buttons:[{xtype:"syno_button",btnStyle:"blue",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","alt_apply"),scope:d,handler:d.onSave},{xtype:"syno_button",text:_T("common","alt_cancel"),scope:d,handler:d.onCancel}]};d.callParent([Ext.apply(c,b)]);d.fieldDesc=d.getComponent("settingPanel").getComponent("general").getComponent("desc");d.radio_default=d.getComponent("settingPanel").getComponent("fieldset_stripe_cache_size").getComponent("default_radio");d.radio_small=d.getComponent("settingPanel").getComponent("fieldset_stripe_cache_size").getComponent("small_radio");if(!d.isSupportStripeCacheSize()){d.getComponent("settingPanel").getComponent("fieldset_stripe_cache_size").getComponent("not_support_displayfield").show()}},updateValues:function(b){var a={desc:Ext.util.Format.htmlDecode(this.pool.get("desc")),stripe_cache_size:b.stripe_cache_size};this.getComponent("settingPanel").getForm().setValues(a);this.fieldDesc.setDisabled(false);if(this.isSupportStripeCacheSize()){this.radio_default.setDisabled(false);this.radio_small.setDisabled(false)}},isSupportStripeCacheSize:function(){switch(this.pool.get("device_type")){case"raid_5":case"raid_6":case"raid_f1":case"shr_with_2_disk_protect":return true;case"shr_with_1_disk_protect":var a=this.pool.get("raids");for(var b=0;b<a.length;b++){if(a[b].designedDiskCount>=3){return true}}return false;default:return false}return false},onOpen:function(){var a=this;var b={pool_path:this.pool.get("space_path")};a.setStatusBusy({text:_T("common","loading")});a.callParent(arguments);SYNO.API.Request({api:"SYNO.Storage.CGI.Pool",method:"get_setting",version:1,params:b,callback:function(f,e,d,c){a.clearStatusBusy();if(!f){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,e);return}a.updateValues(e)},scope:a})},onSave:function(){if(!this.getComponent("settingPanel").getForm().isValid()){return}if(!this.getComponent("settingPanel").getForm().isDirty()){this.setStatusError({text:_T("error","nochange_subject"),clear:true});return}var b={pool_path:this.pool.get("space_path")};var a=this.getComponent("settingPanel").getForm().getValues();if(this.fieldDesc.isValid()&&this.fieldDesc.isDirty()){b.desc=a.desc}if(this.isSupportStripeCacheSize()&&(this.radio_default.isDirty()||this.radio_small.isDirty())){b.stripe_cache_size=a.stripe_cache_size}this.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:"SYNO.Storage.CGI.Pool",method:"set_setting",version:1,params:b,callback:function(f,e,d,c){this.clearStatusBusy();if(!f){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,e);return}this.isDataChanged=true;this.close()},scope:this})},onCancel:function(){if("create"===this.mode){this.close();return}if(this.getComponent("settingPanel").getForm().isDirty()){this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(a){if("yes"===a){this.close()}},this);return}this.close()}});Ext.define("SYNO.SDS.StorageManager.Wizard.ManagePool",{extend:"SYNO.SDS.StorageManager.Wizard.ModalWindow",constructor:function(a){var c=this,b,d=0;c.appWin=a.appWin;c.owner=a.owner;c.pool=a.pool||null;c.disks=a.disks||[];c.manageType=a.manageType||{};c.migrateType=a.migrateType||{};c.add_type=a.add_type;c.raidLimitNum=c.pool.get("limited_disk_number");c.isDataChanged=false;if(a.repair){d=a.repair}b=Ext.apply({title:_T("volume","volume_raid_management_title"),mode:"pool_manage",width:700,height:520,minHeight:475,minWidth:700,resizable:true,border:false,steps:[]},a);if("migrate"===c.add_type){c.activeStep="migrate"}else{if("expand_unfinished_shr"===c.add_type){c.activeStep="shr_operation"}else{if("expand_with_unalloc_size"===c.add_type){c.activeStep="summary"}else{if("data_scrubbing"===c.add_type){c.activeStep="summary"}else{c.activeStep="advDisk"}}}}if("migrate"===c.add_type){b.steps.push(new SYNO.SDS.StorageManager.Wizard.MigrateTypeStep({appWin:c.appWin,migrateType:c.migrateType,migrateConstrain:c.pool.get("can_do").migrate,itemId:"migrate",nextId:"advDisk"}))}if("expand_unfinished_shr"===c.add_type){b.steps.push(new SYNO.SDS.StorageManager.Wizard.SHROperationStep({appWin:c.appWin,spaceType:c.spaceType,itemId:"shr_operation",nextId:{disk:"advDisk",summary:"summary"}}))}b.steps.push(new SYNO.SDS.StorageManager.Wizard.DiskStep({appWin:c.appWin,isSHR:c.getPoolObject().isSHR(),advDisks:c.disks,raidLimitNum:c.raidLimitNum,repair:d,itemId:"advDisk",nextId:"summary"}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.ManageSummaryStep({appWin:c.appWin,itemId:"summary",nextId:null}));c.callParent([b])},activate:function(){this.callParent(arguments)},onOpen:function(){var a=this;this.setData("pool",a.pool);this.setData("space",a.pool);this.setData("manage_action",a.add_type);this.setData("raid_type",a.pool.get("raidType"));this.setData("raid_level",a.pool.get("device_type"));this.setData("raid_limit_number",a.pool.get("limited_disk_number"));a.setActiveStep(a.activeStep);a.callParent(arguments)},getPoolObject:function(){return this.appWin.storagePools.data[this.pool.id]},getManageType:function(){return this.add_type},getMigrateType:function(){return this.getData("migrate_type")},getHddType:function(){return this.appWin.disks.data[this.pool.get("disks")[0]].get("diskType")},getRaidType:function(){return this.pool.get("raidType")},getRaidLevel:function(){var a=this.getData("migrate_type");if(a){switch(a){case"add_mirror":return"raid_1";case"to_raid1":return"raid_1";case"to_raid5":return"raid_5";case"to_raid6":return"raid_6";default:return""}}else{return this.pool.getDeviceType()}},getRaidLimitNum:function(){return this.getData("raid_limit_number")||this.pool.get("limited_disk_number")},getDiskIds:function(){return this.getData("disk_ids",[])},getDiskGroups:function(){return this.getData("disk_groups",[])},getActionType:function(){var a=this.getManageType();if("migrate"===a){return"migrate_"+this.getMigrateType()}else{return a}},getSHROperation:function(){return this.getData("shr_operation")},applySettings:function(a){if(this.pool.isSingleLun()){this.applySettingsLun(a)}else{if(this.pool.isSingleVolume()){this.applySettingsVolume(a)}else{this.applySettingsPool(a)}}},applySettingsPool:function(b){var a="";switch(b){case"stop_in_minutes":a=String.format(_T("volume","volume_change_service_stop_in_minutes"),_T("common","ask_cont"));break;default:}if(a!==""){if("yes"===_D("support_share_encryption","no")){a=String.format("1. {0}<p>2. {1}",_T("volume","volume_share_encryption_unmount_warning"),a)}this.getMsgBox().confirm(this.title,a,function(c){if("yes"===c){this.sendRequestPool()}},this);return}this.sendRequestPool()},sendRequestPool:function(b){var d={},a;var f=this.getDiskIds();var e=this.getDiskGroups();var g=this.getManageType();var c=this.getActionType();var i=this.getSHROperation();var h={};d.space_id=this.pool.id;d.force=b||false;switch(g){case"repair":a="repair";d.disk_id=f;d.diskGroups=e;break;case"data_scrubbing":a="data_scrubbing";d.diskGroups=e;break;case"expand_by_disk":a="expand_by_add_disk";d.disk_id=f;d.diskGroups=e;break;case"expand_with_unalloc_size":a="expand_unallocated";break;case"migrate":a="migrate";d.migrate_type=c;d.disk_id=f;if("raid_5"===this.getRaidLevel()){d.limit_num=this.getRaidLimitNum()}break;case"expand_unfinished_shr":a="expand_unfinished_shr";d.shr_action=i;d.disk_id=f;break;case"convert_shr_to_pool":a="convert_shr_to_pool";d.disk_id=f;break;default:SYNO.Debug("unknown add type");return}this.getButton("next").disable();this.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:"SYNO.Storage.CGI.Pool",method:a,version:1,params:d,callback:function(m,l,k,j){this.clearStatusBusy();if(!m){if(SYNO.SDS.StorageUtils.IsFeasibilityFail(l,h)){SYNO.SDS.StorageUtils.ConfirmFeasibilityFail(this,h,this.sendRequestPool,true)}else{SYNO.SDS.StorageUtils.HARemoteCheckErrParsing(l);SYNO.SDS.StorageUtils.ReportWebapiFailure(this,l)}return}this.getButton("next").enable();this.getButton("next").setText(_T("common","alt_finish"));this.isDataChanged=true;this.close()},scope:this})},applySettingsVolume:function(b){var a="";switch(b){case"stop_in_minutes":a=String.format(_T("volume","volume_change_service_stop_in_minutes"),_T("common","ask_cont"));break;default:}if(a!==""){if("yes"===_D("support_share_encryption","no")){a=String.format("1. {0}<p>2. {1}",_T("volume","volume_share_encryption_unmount_warning"),a)}this.getMsgBox().confirm(this.title,a,function(c){if("yes"===c){this.sendRequestVolume()}},this);return}this.sendRequestVolume()},sendRequestVolume:function(b){var d={};var a;var f=this.getDiskIds();var e=this.getDiskGroups();var g=this.getManageType();var c=this.getActionType();var i=this.getSHROperation();var h={};d.pool_path=this.pool.id;d.space_id=this.pool.get("deploy_path");d.force=b||false;switch(g){case"repair":a="repair";d.disk_id=f;d.diskGroups=e;break;case"data_scrubbing":a="data_scrubbing";d.diskGroups=e;break;case"expand_by_disk":a="expand_by_add_disk";d.disk_id=f;d.diskGroups=e;break;case"expand_with_unalloc_size":a="expand_unallocated";break;case"migrate":a="migrate";d.migrate_type=c;d.disk_id=f;d.diskGroups=e;if("raid_5"===this.getRaidLevel()){d.limit_num=this.getRaidLimitNum()}break;case"expand_unfinished_shr":a="expand_unfinished_shr";d.shr_action=i;d.disk_id=f;break;case"convert_shr_to_pool":a="convert_shr_to_pool";d.disk_id=f;break;default:SYNO.Debug("unknown add type");return}if(this.getStep("summary")&&this.getStep("summary").convertSHRToPool){d.convert_shr_to_pool=true}this.getButton("next").disable();this.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:"SYNO.Storage.CGI.Volume",method:a,version:1,params:d,callback:function(m,l,k,j){this.clearStatusBusy();if(!m){if(SYNO.SDS.StorageUtils.IsFeasibilityFail(l,h)){SYNO.SDS.StorageUtils.ConfirmFeasibilityFail(this,h,this.sendRequestVolume,true)}else{SYNO.SDS.StorageUtils.HARemoteCheckErrParsing(l);SYNO.SDS.StorageUtils.ReportWebapiFailure(this,l)}return}this.getButton("next").enable();this.getButton("next").setText(_T("common","alt_finish"));this.isDataChanged=true;this.close()},scope:this})},applySettingsLun:function(b){var a="";switch(b){case"stop_in_minutes":a=String.format(_T("volume","volume_change_service_stop_in_minutes"),_T("common","ask_cont"));break;default:}if(a!==""){this.getMsgBox().confirm(this.title,a,function(c){if("yes"===c){this.sendRequestLun()}},this);return}this.sendRequestLun()},sendRequestLun:function(f){var g={};var b=this.getDiskIds();var e=this.getDiskGroups();var d=this.getManageType();var c=this.getActionType();var a=this.getSHROperation();g.pool_path=this.pool.id;g.space_id=this.pool.get("deploy_path");g.force=f||false;switch(d){case"repair":g.method="repair";g.disk_id=b;g.diskGroups=e;break;case"data_scrubbing":g.method="data_scrubbing";g.diskGroups=e;break;case"expand_by_disk":g.method="expand_by_add_disk";g.disk_id=b;g.diskGroups=e;break;case"expand_with_unalloc_size":g.method="expand_unallocated";break;case"migrate":g.method="migrate";g.migrate_type=c;g.disk_id=b;g.diskGroups=e;if("raid_5"===this.getRaidLevel()){g.limit_num=this.getRaidLimitNum()}break;case"expand_unfinished_shr":g.method="expand_unfinished_shr";g.shr_action=a;g.disk_id=b;break;case"convert_shr_to_pool":g.method="convert_shr_to_pool";g.disk_id=b;break;default:SYNO.Debug("unknown add type");return}this.getButton("next").disable();this.setStatusBusy({text:_T("common","saving")});this.sendWebAPI({api:"SYNO.Core.Storage.iSCSILUN",method:g.method,version:1,params:g,callback:function(i,h){var j={};this.clearStatusBusy();if(!i){if(SYNO.SDS.StorageUtils.IsFeasibilityFail(h,j)){SYNO.SDS.StorageUtils.ConfirmFeasibilityFail(this,j,this.sendRequestLun,true)}else{SYNO.SDS.StorageUtils.HARemoteCheckErrParsing(h);SYNO.SDS.StorageUtils.ReportWebapiFailure(this,h)}return}this.getButton("next").enable();this.getButton("next").setText(_T("common","alt_finish"));if(h.str){this.getMsgBox().alert(this.title,h.str,this.close,this)}else{this.isDataChanged=true;this.close()}},scope:this})}});Ext.define("SYNO.SDS.StorageManager.Wizard.MigrateTypeStep",{extend:"SYNO.SDS.StorageManager.Wizard.Step",constructor:function(a){var c=this,b;c.migrateType=undefined;c.migrateConstrain=undefined;c.loaded=false;c.appWin=a.appWin;b={headline:_T("volume","volume_migrate_type_title"),items:[{xtype:"syno_radio",boxLabel:_T("volume","volume_migrate_add_mirror"),name:"migrateType",itemId:"add_mirror",inputValue:"add_mirror",listeners:{check:this.onMigrateTypeChanged,scope:this}},{xtype:"syno_radio",boxLabel:_T("volume","volume_migrate_to_raid1"),name:"migrateType",itemId:"to_raid1",inputValue:"to_raid1",listeners:{check:this.onMigrateTypeChanged,scope:this}},{xtype:"syno_radio",boxLabel:_T("volume","volume_migrate_to_raid5"),name:"migrateType",itemId:"to_raid5",inputValue:"to_raid5",listeners:{check:this.onMigrateTypeChanged,scope:this}},{xtype:"syno_radio",boxLabel:_T("volume","volume_migrate_to_raid5_spare"),name:"migrateType",itemId:"to_raid5+spare",inputValue:"to_raid5+spare",listeners:{check:this.onMigrateTypeChanged,scope:this}},{xtype:"syno_radio",boxLabel:_T("volume","volume_migrate_to_raid6"),name:"migrateType",itemId:"to_raid6",inputValue:"to_raid6",listeners:{check:this.onMigrateTypeChanged,scope:this}},{xtype:"syno_radio",boxLabel:_T("volume","volume_migrate_to_shr2"),name:"migrateType",itemId:"to_shr2",inputValue:"to_shr2",listeners:{check:this.onMigrateTypeChanged,scope:this}},{xtype:"syno_combobox",fieldLabel:_T("volume","limit_raid_disk_number"),name:"limitNum",itemId:"limitNum",hidden:true,hiddenName:"limitNum",hiddenValue:0,store:new Ext.data.ArrayStore({data:[["6",6],["12",12],["24",24]],id:"value",fields:["text","value"]}),displayField:"text",valueField:"value",mode:"local",allowBlank:false}]};c.callParent([Ext.apply(b,a)])},onMigrateTypeChanged:function(c,d){var b=this.owner.getPoolObject();var a=this.getComponent("limitNum");if("to_raid5"===c.itemId){if(true===d&&this.appWin.supportRaidGroup){a.show()}else{a.hide()}if(b.supportMultiple()){a.enable()}else{a.disable();a.setValue(24)}}},getType:function(){return this.getForm().getValues().migrateType},activate:function(){var b=this.owner.getPoolObject();var c="";var a;if(this.loaded){return}Ext.each(this.find("name","migrateType"),function(d){d.hide()});if(b.isSHR()){a=["to_shr2"]}else{a=["to_raid5","to_raid6"];if(!this.appWin.supportHotSpare){a.splice(1,0,"to_raid5+spare")}if("add_mirror" in this.migrateType&&this.migrateType.add_mirror){a.unshift("add_mirror")}else{a.unshift("to_raid1")}}Ext.each(a,function(e){var d=this.getComponent(e);if(e in this.migrateType&&this.migrateType[e]){d.enable();c=e}else{d.disable()}d.show()},this);this.getComponent("limitNum").setValue(24);this.getComponent(c).setValue(true);this.loaded=true},updateData:function(b){var c=this.getType();var a=false;if(("to_raid5"===c&&0===this.migrateConstrain.to_raid5)||("to_raid6"===c&&0===this.migrateConstrain.to_raid6)){a=true}b.allow_disk_blank=a;if("to_raid5"===c){b.raid_limit_number=this.getComponent("limitNum").getValue()}b.migrate_type=this.getType()},summary:function(a){if("to_raid5"===this.getType()&&this.appWin.supportRaidGroup){a.append(_T("volume","limit_raid_disk_number"),this.getComponent("limitNum").getValue())}}});Ext.define("SYNO.SDS.StorageManager.Wizard.CreateVolumeMain",{extend:"SYNO.SDS.StorageManager.Wizard.ModalWindow",constructor:function(a){var d=this,c,b;d.appWin=a.appWin;d.owner=a.owner;d.supportBtrfs=("yes"===_D("support_btrfs","no"));d.isDataChanged=false;c=a.option;b={title:_T("volume","volume_add_volmgr_title"),cls:"sm-wizard-main",mode:"volume_create",width:640,height:560,minHeight:560,minWidth:640,resizable:true,border:false,steps:[]};if(!d.appWin.supportRaidGroup){if(!d.appWin.isSingleBay()){b.steps.push(new SYNO.SDS.StorageManager.Wizard.CreateVolumeModeStep({appWin:d.appWin,option:c,itemId:"create_mode",nextId:{quick:"property",custom:"pool_from"}}))}if(!d.appWin.isSingleBay()||d.appWin.isSingleBayWithEbox()){b.steps.push(new SYNO.SDS.StorageManager.Wizard.PoolFromStep({appWin:d.appWin,itemId:"pool_from",nextId:{create:"raid_type",existing:"pool_choosing"}}))}}if(!d.appWin.isSingleBay()||d.appWin.isSingleBayWithEbox()){b.steps.push(new SYNO.SDS.StorageManager.Wizard.PoolChoosingStep({appWin:d.appWin,itemId:"pool_choosing",nextId:"allocate_size_step"}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.PoolTypeStep({appWin:d.appWin,itemId:"raid_type",nextId:"property"}))}b.steps.push(new SYNO.SDS.StorageManager.Wizard.PoolPropertyStep({appWin:d.appWin,itemId:"property",nextId:"disk"}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.DiskStep({appWin:d.appWin,itemId:"disk",nextId:"check"}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.DiskCheckStep({appWin:d.appWin,itemId:"check",getNext:function(){return this.getData("quick_mode",false)||this.appWin.isSingleBay()?"fsstep":"allocate_size_step"}}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.VolumePropertyStep({appWin:d.appWin,itemId:"allocate_size_step",deviceType:"volume",nextId:"fsstep"}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.VolumeFsTypeStep({appWin:d.appWin,itemId:"fsstep",nextId:"summary"}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.CreateVolumeSummaryStep({appWin:d.appWin,isOneBay:d.appWin.isSingleBay(),headline:_T("volume","volume_wizard_summary_title"),itemId:"summary",nextId:null}));d.callParent([Ext.apply(b,a)])},onOpen:function(){this.callParent(arguments);if(this.appWin.supportRaidGroup){this.setData("quick_mode",false);this.setData("pool_from","existing")}if(this.appWin.isSingleBay()){this.setData("quick_mode",false);this.setData("pool_from","create");this.setData("raid_type","single")}this.setData("create_for","volume")},isQuickMode:function(){return this.getData("quick_mode",false)},getSpaceType:function(){return"volume"},getDiskIds:function(){return this.getData("disk_ids",[])},getRaidLevel:function(){var a=this.getData("raid_level","");var b=this.getData("disk_ids",[]);if("shr_2"===a){a="shr_with_2_disk_protect"}else{if("shr"===a){if(b.length===1){a="shr_without_disk_protect"}else{a="shr_with_1_disk_protect"}}}return a},getPoolPath:function(){return this.getData("selected_pool_id","")},getDescription:function(){return this.getData("volume_description")||this.getData("pool_description")||""},isChooseExistingPool:function(){if(this.getData("pool_from")==="existing"){return true}return false},getFsType:function(){return this.getData("fs_type",_D("defaultfs","ext4"))},getAllocateSizeMB:function(){var a=this.getData("allocate_byte",0);return Math.floor(a/1024/1024).toString()},getDiskCheck:function(){return this.getData("disk_check",false)},isPoolChild:function(){return this.getData("raid_type")==="multiple"},applySettings:function(d){var b=this.getData("raid_type");var c=this.getData("deploy_space_path");var e={};var g={};var a,f;e.force=d||false;if(this.isChooseExistingPool()){if("single"===b){f="deploy_unused";e.space_path=c}else{f="create_on_existing_pool";e.pool_path=this.getPoolPath();e.allocate_size=this.getAllocateSizeMB()}e.fs_type=this.getFsType();e.vol_desc=this.getDescription();e.atime_opt="relatime"}else{a=this.getRaidLevel();f="create";e.pool_path=this.getPoolPath();e.fs_type=this.getFsType();e.allocate_size=this.getAllocateSizeMB();e.disk_id=this.getDiskIds();e.is_disk_check=this.getDiskCheck();e.device_type=a;e.is_pool_child=this.isPoolChild();e.spare_disk_count="0";e.vol_desc=this.getDescription();e.desc=SYNO.SDS.StorageUtils.RaidLevelRender(a);e.atime_opt="relatime"}this.getButton("next").disable();this.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:"SYNO.Storage.CGI.Volume",method:f,version:1,params:e,callback:function(k,j,i,h){this.clearStatusBusy();if(!k){if(SYNO.SDS.StorageUtils.IsFeasibilityFail(j,g)){SYNO.SDS.StorageUtils.ConfirmFeasibilityFail(this,g,this.applySettings,true)}else{SYNO.SDS.StorageUtils.HARemoteCheckErrParsing(j);SYNO.SDS.StorageUtils.ReportWebapiFailure(this,j)}return}this.getButton("next").enable();this.getButton("next").setText(_T("common","alt_finish"));this.isDataChanged=true;this.close()},scope:this})}});Ext.define("SYNO.SDS.StorageManager.Wizard.ManageVolume",{extend:"SYNO.SDS.StorageManager.Wizard.ModalWindow",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;c.volume=a.volume||null;c.manageAction=a.manageAction;b=Ext.apply({title:_T("volume","volume_raid_management_title"),mode:"pool_manage",width:700,height:520,minHeight:475,minWidth:700,resizable:true,border:false,steps:[]},a);b.steps.push(new SYNO.SDS.StorageManager.Wizard.ManageSummaryStep({appWin:c.appWin,itemId:"summary",nextId:null}));c.callParent([b])},activate:function(){this.callParent(arguments)},onOpen:function(){var a=this;this.setData("manage_action",a.manageAction);a.callParent(arguments)},getPoolObject:function(){return this.appWin.volumes.data[this.volume.id]},getActionType:function(){return this.manageAction},applySettings:function(b){var a="";switch(b){case"stop_in_minutes":a=String.format(_T("volume","volume_change_service_stop_in_minutes"),_T("common","ask_cont"));break;default:}if(a!==""){if("yes"===_D("support_share_encryption","no")){a=String.format("1. {0}<p>2. {1}",_T("volume","volume_share_encryption_unmount_warning"),a)}this.getMsgBox().confirm(this.title,a,function(c){if("yes"===c){this.sendRequestVolume()}},this);return}this.sendRequestVolume()},sendRequestVolume:function(a){var b={};var d;var c={};b.force=a||false;b.pool_path=this.volume.get("pool_path");b.space_id=this.volume.id;switch(this.manageAction){case"expand_with_unalloc_size":d="expand_unallocated";break;default:SYNO.Debug("unknown add type");return}this.getButton("next").disable();this.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:"SYNO.Storage.CGI.Volume",method:d,version:1,params:b,callback:function(h,g,f,e){this.clearStatusBusy();if(!h){if(SYNO.SDS.StorageUtils.IsFeasibilityFail(g,c)){SYNO.SDS.StorageUtils.ConfirmFeasibilityFail(this,c,this.sendRequestVolume,true)}else{SYNO.SDS.StorageUtils.HARemoteCheckErrParsing(g);SYNO.SDS.StorageUtils.ReportWebapiFailure(this,g)}return}this.getButton("next").enable();this.getButton("next").setText(_T("common","alt_finish"));this.close()},scope:this})}});Ext.define("SYNO.SDS.StorageManager.Wizard.CreateVolumeModeStep",{extend:"SYNO.SDS.StorageManager.Wizard.Step",constructor:function(a){var c=this,b;var d=String.format('<span class="syno-ux-note">{0}{1} </span>{2}',_T("common","note"),_T("common","colon"),"{0}");c.loaded=false;c.option=a.option||{};c.appWin=a.appWin;c.owner=a.owner;b={headline:_T("volume","volume_add_mode_title"),items:[{xtype:"syno_radio",boxLabel:_T("volume","volume_add_mode_systemdefault"),name:"choose_mode",itemId:"quick",inputValue:"quick",disabled:true},{xtype:"syno_displayfield",htmlEncode:false,indent:1,value:_T("volume","volume_add_mode_systemdefault_help")},{xtype:"syno_displayfield",htmlEncode:false,indent:1,value:String.format(d,_T("volume","volume_type_shr_support_note")),hidden:!this.appWin.supportHA},{xtype:"syno_displayfield",cls:"sm-empty-line"},{xtype:"syno_radio",boxLabel:_T("volume","volume_add_mode_customized"),name:"choose_mode",itemId:"custom",inputValue:"custom",disabled:true},{xtype:"syno_displayfield",indent:1,value:_T("volume","volume_add_mode_customized_help")},{xtype:"syno_displayfield",htmlEncode:false,indent:1,value:String.format(d,_T("volume","volume_add_mode_customized_note"))}]};this.callParent([Ext.apply(b,a)])},isQuickMode:function(){return this.getForm().getValues().choose_mode==="quick"},activate:function(){if(this.loaded){return}if(this.option.can_create_volume){if(!_S("ha_running")){this.getComponent("quick").enable();this.getComponent("quick").setValue(true)}else{this.getComponent("quick").disable();this.getComponent("custom").setValue(true)}this.getComponent("custom").enable()}else{if(this.option.can_create_volume_on_existing_pool){this.getComponent("quick").disable();this.getComponent("custom").enable();this.getComponent("custom").setValue(true)}else{this.getComponent("quick").disable();this.getComponent("custom").disable()}}this.loaded=true},getNext:function(){return this.nextId[this.getForm().getValues().choose_mode]},updateData:function(a){a.quick_mode=this.isQuickMode()},summary:function(a){a.append(_T("volume","volume_space"),_T("volume","volume"))}});Ext.define("SYNO.SDS.StorageManager.Wizard.VolumeFsTypeStep",{extend:"SYNO.SDS.StorageManager.Wizard.Step",constructor:function(a){var c=this,b;c.loaded=false;c.option=a.option||{};c.appWin=a.appWin;c.owner=a.owner;b={headline:_T("volume","volume_add_fs_title"),items:[{xtype:"syno_radio",boxLabel:_T("volume","volume_add_fs_btrfs"),name:"choose_fs",itemId:"btrfs",inputValue:"btrfs"},{xtype:"syno_displayfield",indent:1,value:_T("volume","volume_add_fs_btrfs_help")},{xtype:"syno_displayfield",cls:"sm-empty-line"},{xtype:"syno_radio",boxLabel:_T("volume","volume_add_fs_ext4"),name:"choose_fs",itemId:"ext4",inputValue:"ext4"},{xtype:"syno_displayfield",style:"margin-bottom:20px",indent:1,value:_T("volume","volume_add_fs_ext4_help")},{xtype:"syno_displayfield",htmlEncode:false,value:_T("volume","volume_choose_fs_info")}]};this.callParent([Ext.apply(b,a)])},isSkip:function(){return !this.appWin.supportBtrfs},getFsType:function(){return this.getForm().getValues().choose_fs},activate:function(){if(this.loaded){return}if(this.appWin.supportBtrfs&&"btrfs"===_D("defaultfs")){this.getComponent("btrfs").setValue(true)}else{this.getComponent("ext4").setValue(true)}this.loaded=true},updateData:function(a){a.fs_type=this.getFsType()},getNext:function(){return this.nextId},summary:function(b){var a;if(!this.isSkip()){a=("btrfs"===this.getFsType())?_T("volume","volume_add_fs_btrfs_type"):_T("volume","volume_add_fs_ext4_type");b.append(_T("volume","volume_add_fs_type"),a)}}});Ext.define("SYNO.SDS.StorageManager.Wizard.CreateVolumeSummaryStep",{extend:"SYNO.SDS.StorageManager.Wizard.SummaryStep",constructor:function(a){this.isOneBay=false;var b={headline:_T("volume","volume_wizard_summary_title")};b=Ext.apply(b,a);this.callParent([b])},estimateSize:function(){var a=this.getData("raid_type","single")==="multiple";this.owner.setStatusBusy();this.owner.getButton("next").disable();SYNO.API.Request({api:"SYNO.Storage.CGI.Volume",method:"estimate_size",version:1,params:{estimate_for:"create",disk_id:this.owner.getDiskIds(),device_type:this.owner.getRaidLevel()},callback:function(e,d,c,b){this.owner.clearStatusBusy();if(!e){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,d);this.owner.getButton("next").disable();return}this.getStore().append(_T("volume","volume_totalsize"),_T("volume","volume_add_warningabout")+" "+SYNO.SDS.StorageUtils.SizeRender(d.size));this.checkSize(a?this.getData("allocate_byte",0):parseInt(d.size,10))},scope:this})},checkSize:function(b){var c=this;var a=parseInt(this.appWin.getMaxVolumeSize(),10);var d={};if(b>a){d.text=_T("error","error_volume_oversize");d.text=String.format(d.text,SYNO.SDS.StorageUtils.SizeRender(a));SYNO.SDS.StorageUtils.ReportWebapiFailure(this,d,function(){c.owner.getButton("next").disable()})}},activate:function(){var d=this;var c=this.getData("pool_from","create");var a=this.getData("quick_mode",false);var b=this.getData("allocate_byte",0);d.callParent(arguments);if("create"===c||a){this.estimateSize()}else{this.checkSize(b)}},getNext:function(){this.owner.applySettings();return false}});Ext.define("SYNO.SDS.StorageManager.Volume.Dialog.SpaceCreationWarningWindow",{extend:"SYNO.SDS.ModalWindow",title:_T("download","download_warning"),owner:null,powerButtonCheckboxID:null,okButtonID:null,next_id:null,constructor:function(b){var c=this;c.appWin=b.appWin;c.owner=b.owner;c.next_id=b.next_id;c.callBack=b.callBack;c.callParent([c.getConfig(b)]);if(!b.showPwrChk){Ext.getCmp(this.okButtonID).setDisabled(false)}else{Ext.getCmp(this.okButtonID).setDisabled(true)}var a=200;if(b.showPwrChk){a=a+70}this.setHeight(a)},getConfig:function(a){var b=Ext.apply({width:600,layout:"fit",items:[{xtype:"syno_formpanel",items:[{xtype:"syno_displayfield",htmlEncode:false,hideLabel:true,value:a.warningMsg},{xtype:"syno_checkbox",id:this.powerButtonCheckboxID=Ext.id(),boxLabel:_T("volume","eunit_power_button_disabled"),hideLabel:true,handler:this.onClickConfirmReadingCheckbox,hidden:!a.showPwrChk,scope:this}]}],buttons:[{xtype:"syno_button",btnStyle:"red",text:_T("common","ok"),id:this.okButtonID=Ext.id(),scope:this,handler:this.onClickOKButton},{text:_T("common","close"),xtype:"syno_button",scope:this,handler:function(){if(Ext.isFunction(this.callBack)){this.callBack(false)}this.close()}}]},a);return b},onClickConfirmReadingCheckbox:function(){if(true===Ext.getCmp(this.powerButtonCheckboxID).getValue()){Ext.getCmp(this.okButtonID).setDisabled(false)}else{Ext.getCmp(this.okButtonID).setDisabled(true)}return},onClickOKButton:function(){if(Ext.isFunction(this.callBack)){this.callBack(true)}this.owner.goNext(this.next_id);this.close();return}});Ext.define("SYNO.SDS.StorageManager.Wizard.VolumeGeneralProperty",{extend:"SYNO.ux.FormPanel",constructor:function(a){var c=this,b;c.maxFreeSizeGB=0;c.maxFreeSizeByte=0;c.maxExpandSizeGB=0;c.maxExpandSizeByte=0;c.minExpandSizeGB=0;c.supportBtrfs=("yes"===_D("support_btrfs","no"));c.appWin=a.appWin;c.owner=a.owner;c.mode=a.mode;c.volume=a.volume;b={title:_T("common","general"),itemId:"volume_property",trackResetOnLoad:true,layoutConfig:{trackLabels:true},labelWidth:250,listeners:{activate:{fn:this.onActivate,single:true,scope:this},afterlayout:{fn:this.addAtimeOptTip,single:true,scope:this}},items:[{xtype:"syno_displayfield",itemId:"pool",name:"pool",fieldLabel:_T("volume","volume_raid_group"),hidden:this.appWin.isVDSM,width:250},{xtype:"syno_textfield",validateOnBlur:true,validationEvent:"blur",name:"desc",itemId:"desc",enableKeyEvents:true,fieldLabel:_T("share","share_comment"),width:250,maxLength:64},{xtype:"syno_combobox",itemId:"atime_opt",name:"atime_opt",fieldLabel:_T("volume","volume_atime_option"),lazyRender:true,width:250,editable:false,mode:"local",forceSelection:true,allowBlank:false,disabled:(_S("systemdr_running")?true:false),value:(_S("systemdr_running")?"noatime":"relatime"),store:(_S("systemdr_running")?[["noatime",_T("volume","never")]]:[["relatime",_T("volume","daily")],["monthly",_T("volume","monthly")],["noatime",_T("volume","never")]])},{xtype:"syno_displayfield",itemId:"allocated_size_desc",hideLabel:false,disabled:true,disabledClass:"",fieldLabel:String.format("{0} ({1})",_T("volume","volume_pool_usedsize"),_T("common","size_gb")),width:250,value:"100000"},{xtype:"syno_displayfield",itemId:"size_max_desc",hideLabel:false,disabled:true,disabledClass:"",fieldLabel:String.format("{0} ({1})",_T("volume","volume_max_allocatable_size"),_T("common","size_gb")),width:250,value:"200000"},{layout:"hbox",itemId:"size_panel",border:false,fieldLabel:String.format("{0} ({1})",_T("volume","volume_allocate_size_field_name"),_T("common","size_gb")),labelStyle:"line-height: 28px;padding:0px;",bodyStyle:{padding:"0px 0px 0px 0px"},items:[{xtype:"syno_numberfield",allowDecimals:false,validateOnBlur:true,width:250,value:"1",itemId:"size_value",validator:function(e){var d=String.format(_T("volume","volume_valid_range_warning"),c.minValue,c.maxValue);if(c.maxValue<e||c.minValue>e){return d}return true}},{xtype:"syno_displayfield",width:10,value:" "},{xtype:"syno_button",itemId:"size_max",text:_T("common","max"),handler:function(e,d){c.sizeCmp.setValue(c.sizeCmp.maxValue)},scope:c}]}]};c.callParent([Ext.apply(b,a)]);c.descCmp=c.getComponent("desc");c.atimeOptCmp=c.getComponent("atime_opt");c.sizeCmp=c.getComponent("size_panel").getComponent("size_value");c.maxSizeBtn=c.getComponent("size_panel").getComponent("size_max");c.maxSizeDesc=c.getComponent("size_max_desc");c.alloSizeDesc=c.getComponent("allocated_size_desc");c.poolCmp=c.getComponent("pool")},onActivate:function(){var h=this;var k=SYNO.SDS.StorageUtils;var g,d,f,i,b;var c,j,a,e;if(!h.volume){return}g=h.appWin.storagePools.data[h.volume.get("pool_path")];if(!g||h.volume.isSingleBayBasicVolume()){c=h.appWin.getMaxVolumeSize();f=parseInt(h.volume.get("size").used,10);i=parseInt(h.volume.get("size").used,10);b=""}else{c=h.appWin.getMaxVolumeSize();f=parseInt(g.get("size").total,10);i=parseInt(g.get("size").used,10);b=k.SpaceIDParser(g.get("id")).str}d=parseInt(h.volume.get("size").total_device,10);j=parseInt(((f-i)+d),10);a=parseInt(h.volume.get("max_fs_size"),10);if(a<j){h.maxExpandSizeGB=k.GetSizeGB(a,0);h.maxExpandSizeByte=a}else{h.maxExpandSizeGB=k.GetSizeGB(j,0);h.maxExpandSizeByte=j}h.minExpandSizeGB=k.GetSizeGB(d,0);if(h.minExpandSizeGB>h.maxExpandSizeGB){h.maxExpandSizeGB=h.minExpandSizeGB;h.maxExpandSizeByte=d}if(h.maxExpandSizeByte>c){h.maxExpandSizeByte=c;h.maxExpandSizeGB=c/1024/1024/1024}e=Ext.util.Format.htmlDecode(h.volume.get("desc"));h.getForm().setValues({pool:b,desc:e,atime_opt:h.volume.get("atime_opt"),size_value:h.minExpandSizeGB});h.sizeCmp.maxValue=h.maxExpandSizeGB;h.sizeCmp.minValue=h.minExpandSizeGB;h.maxSizeDesc.setValue(h.maxExpandSizeGB);h.alloSizeDesc.setValue(h.minExpandSizeGB);if(!g){h.poolCmp.hide()}if(!g||!g.isFreeSizeBiggerThan1GB()||!g.isWritable){h.sizeCmp.disable();h.maxSizeBtn.disable();return}if(!g||"single"===g.get("raidType")){h.sizeCmp.disable();h.maxSizeBtn.disable()}else{h.sizeCmp.enable();h.maxSizeBtn.enable()}},addAtimeOptTip:function(){SYNO.SDS.Utils.AddTip(this.atimeOptCmp.getEl(),_T("volume","volume_atime_option_hint"))},getAllocateSizeMB:function(){var c=this,b=0,a=this.sizeCmp;if(a.getValue()===a.maxValue){b=Math.floor(parseInt(c.maxFreeSizeByte,10)/1024/1024)}else{b=parseInt(a.getValue(),10)*1024}return b.toString()},isValid:function(){return this.getForm().isValid()},isDirty:function(){return this.getForm().isDirty()},getSettingAPI:function(){var a=this;var e,b,d,c;if(!a.isValid()||!a.isDirty()){return}if(a.sizeCmp.isDirty()){b=parseInt(a.sizeCmp.getValue(),10)*1024*1024*1024}else{b=0}d=a.descCmp.getValue();c=a.atimeOptCmp.getValue();e={space_id:a.volume.get("id"),desc:d,atime_opt:c,new_size:b.toString()};return{api:"SYNO.Storage.CGI.Volume",method:"expand_pool_child",version:1,params:e}}});Ext.define("SYNO.SDS.StorageManager.Wizard.DeleteVolume",{extend:"SYNO.SDS.ModalWindow",serviceNameMap:{media:_T("tree","leaf_mediaservice"),itunes:_T("tree","leaf_itunes"),audio:_T("tree","leaf_audio"),photo:_T("tree","leaf_photo"),netbkp:_T("tree","leaf_netbkp"),web:_T("tree","leaf_web"),download:_T("tree","node_download"),mysql:_T("tree","leaf_mysql"),surveillance:_T("tree","leaf_surveillance"),userhome:_T("user","user_home")},constructor:function(a){var c=this,b;c.isDataChanged=false;c.appWin=a.appWin;c.owner=a.owner;c.volumeIds=a.volumeIds||[];c.services=undefined;b={title:_T("volume","volume_delete_volmgr_title"),width:640,height:350,resizable:false,layout:"fit",items:[{xtype:"syno_formpanel",itemId:"main",border:false,items:[{xtype:"syno_displayfield",value:"",id:c.descID=Ext.id(),itemId:"desc"},c.grid=new SYNO.SDS.Wizard.SummaryStep({layout:"fit",height:200})]}],buttons:[{xtype:"syno_button",btnStyle:"red",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","remove"),id:c.applyButtonID=Ext.id(),scope:c,handler:c.onSave},{xtype:"syno_button",text:_T("common","alt_cancel"),scope:c,handler:c.onCancel}]};c.callParent([Ext.apply(b,a)])},onOpen:function(){var c=this,a=SYNO.SDS.StorageUtils,b;c.callParent(arguments);if(0===c.volumeIds.length){return}b=c.grid.getStore();b.append(_T("volume","volume"),a.getVolumeNames(c.volumeIds));c.setStatusBusy();SYNO.API.Request({api:"SYNO.Storage.CGI.Volume",method:"enum_resource",version:1,params:{space_id:c.volumeIds},callback:function(g,f,e,d){c.clearStatusBusy();if(!g){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,f);return}c.loadData(f,e)},scope:c})},onSave:function(){var a=this,b,c;b={space_id:a.volumeIds,force:true};c='1. <font class="red-status">'+_T("volume","volume_delete_warning")+"</font><br/>2. ";c+=_T("volume","volume_all_service_stop");a.getMsgBox().confirm(_T("tree","leaf_volume"),c,function(d){if("yes"===d){SYNO.SDS.Utils.PasswordConfirmDialog.openDialog(a,a.apply,["delete",b])}},a)},onCancel:function(){this.close()},loadData:function(f,e){var h=this,g=h.grid.getStore(),i=SYNO.SDS.StorageUtils,d={},j=[],a=i.CheckFailedMsg(f.check),c=false,b=function(l){var k=true;l.space_id.each(function(m){if("crashed"!==h.owner.volumes.data[m].get("status")){k=false;return false}});if(k){Ext.getCmp(h.applyButtonID).enable();Ext.getCmp(h.descID).setValue(_T("volume","del_soft_check_fail"))}};if("hard_failed"===a){c=true;Ext.getCmp(h.applyButtonID).disable();Ext.getCmp(h.descID).setValue(_T("volume","del_hard_check_fail"));b(e)}else{if("soft_failed"===a){Ext.getCmp(h.descID).setValue(_T("volume","del_soft_check_fail"))}else{Ext.getCmp(h.descID).setValue(_T("volume","volume_delete_summary_desc"))}}i.CheckMsg(f.check,c,"volumes",g);if(f.services&&f.services.length>0){g.append(_T("volume","volume_warninglistservice"),i.getServiceNames(f.services))}if(f.shares&&f.shares.length>0){g.append(_T("volume","volume_status_warningdelinfo"),i.getNamesString(f.shares));i.CheckMsg(f.check,c,"shares",g)}if(f.iscsiluns&&f.iscsiluns.length>0){g.append(_T("volume","volume_iscsitrg_lun"),i.getNamesString(f.iscsiluns));i.CheckMsg(f.check,c,"iscsiluns",g)}if(f.pkgs&&f.pkgs.length>0){g.append(_T("pkgmgr","title_packages"),i.getNamesString(f.pkgs))}h.services=f.services;if("yes"!==_D("support_ssd_cache","no")){return}Ext.each(h.volumeIds,function(k){d[k]=true});Ext.each(h.appWin.ssdCaches.getAll(),function(k){if(d[k.get("mountSpaceId")]){j.push(SYNO.SDS.Utils.StorageUtils.SpaceIDParser(k.get("id")).str)}},h);if(0<j.length){g.append(_T("volume","ssd_cache"),j.join(", "))}},apply:function(d,b){var a=this;var c={};a.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:"SYNO.Storage.CGI.Volume",method:d,version:1,params:b,callback:function(h,g,f,e){a.clearStatusBusy();if(!h){if(SYNO.SDS.StorageUtils.IsFeasibilityFail(g,c)){SYNO.SDS.StorageUtils.ConfirmFeasibilityFail(this,c,this.apply,d,f)}else{SYNO.SDS.StorageUtils.HARemoteCheckErrParsing(g);SYNO.SDS.StorageUtils.ReportWebapiFailure(this,g)}return}SYNO.SDS.StorageUtils.disableServices(a.services);a.isDataChanged=true;a.close()},scope:a})}});Ext.define("SYNO.SDS.StorageManager.Wizard.TrimVolumeProperty",{extend:"SYNO.ux.Panel",constructor:function(a){var c=this,b;c.isScheduleEdited=false;c.isDataChanged=false;c.nextTriggerTime="-";c.origEnableStatus=false;c.appWin=a.appWin;c.owner=a.owner;c.volume=a.volume;c.pool=a.pool;c.busyee=a.busyee;c.isLoaded=false;c.supportSSDTrim=false;b={title:_T("volume","ssd_trim_title"),layout:"fit",border:false,items:[{xtype:"syno_formpanel",border:false,items:[{xtype:"syno_displayfield",value:_T("volume","ssd_trim_desc")},{xtype:"syno_checkbox",boxLabel:_T("volume","ssd_trim_en"),id:c.enabledId=Ext.id(),handler:c.onClickEnable,hideLabel:true,scope:c},c.grid=new SYNO.SDS.Wizard.SummaryStep({height:130}),{xtype:"syno_displayfield",fieldLabel:_T("schedule","next_trigger_time"),value:c.nextTriggerTime,id:c.nextTriggerTimeId=Ext.id()},{xtype:"syno_button",id:c.editButtonId=Ext.id(),text:_T("wireless_ap","ap_set_schedule"),handler:c.onEdit,disabled:true,scope:c}]}],listeners:{activate:{fn:this.onActivate,single:true,scope:this}}};c.callParent([Ext.apply(b,a)])},onActivate:function(){var d=this,a=SYNO.SDS.StorageUtils,e=[],f,c;var b;this.isLoaded=true;b=this.checkSupport();d.supportSSDTrim=b.supported;if(!d.supportSSDTrim){Ext.getCmp(d.enabledId).disable();Ext.getCmp(d.nextTriggerTimeId).disable();Ext.getCmp(d.editButtonId).disable();this.body.mask(b.msg,"syno-ux-mask-info");return}if(d.pool&&"single"!==d.pool.get("raidType")){f={space_id:d.pool.id};c="SYNO.Storage.CGI.Pool"}else{e.push(d.volume.id);f={space_id:e};c="SYNO.Storage.CGI.Volume";d.grid.getStore().append(_T("volume","volume"),a.getVolumeNames([d.volume]))}d.busyee.setStatusBusy();d.appWin.sendWebAPI({scope:d,compound:{stopwhenerror:true,mode:"parallel",params:[{api:c,method:"enum_resource",version:1,params:f},{api:"SYNO.Storage.CGI.Volume",method:"ssd_trim_get",version:1,params:{space_path:d.volume.json.vol_path}}]},callback:function(g,j,i,h){d.busyee.clearStatusBusy();if(g&&!j.has_fail){d.loadDataVolumes(j.result[0].data);d.loadDataSsdTrim(j.result[1].data);return}else{SYNO.SDS.StorageUtils.ReportWebapiFailure(d.appWin,j)}}})},onEdit:function(){var d=this;if(!this.supportSSDTrim){return}var b=new SYNO.SDS.TaskScheduler2.ScheduleDialog({title:_T("schedule","schedule_advance"),listeners:{close:{scope:d,fn:function(){d.schedule=d.owner.schedule;d.isScheduleEdited=d.schedule?true:false;d.updateNextTriggerTime(true)}}},owner:d.owner});d.schedule=d.owner.schedule;var c=this.volume.get("ssd_trim").schedule;var a=this.schedule;var e=this.isScheduleEdited?a:c;b.open(this.scheduleToNew(e))},onClickEnable:function(){var a=Ext.getCmp(this.enabledId).getValue();if(a){Ext.getCmp(this.editButtonId).enable();Ext.getCmp(this.nextTriggerTimeId).setValue(this.nextTriggerTime)}else{Ext.getCmp(this.editButtonId).disable();Ext.getCmp(this.nextTriggerTimeId).setValue("-");this.volume.get("ssd_trim").schedule.next_trigger_time=null}},checkSupport:function(){var f=true;var h=this.volume;var c=h.get("ssd_trim").support;var g,b,e;var a;var d;if("not support"===c){f=false;a=_T("common","not_support")}if(f){if(this.appWin.supportSsdCache){g=this.appWin.ssdCaches.getAll();for(e=0;e<g.length;++e){b=g[e];if(h.get("vol_path")===b.get("path")){d="cache"}}}if("disabled by time backup"===c){d="backup"}if(d){if("cache"===d){a=_T("volume","ssd_trim_disabled_by_cache")}else{if("backup"===d){a=_T("volume","ssd_trim_disabled_by_backup")}}f=false}if("partial support"===c){f=false;a=_T("volume","ssd_trim_not_support_desc")}}return{supported:f,msg:a}},isDirty:function(){var a=Ext.getCmp(this.enabledId).getValue();if(!this.supportSSDTrim||!this.isLoaded){return false}if(a!==this.origEnableStatus||this.isScheduleEdited){return true}return false},getSettingAPI:function(){var d={};var b=Ext.getCmp(this.enabledId).getValue();var c=this.volume.get("ssd_trim").schedule;var a=this.schedule;if(!this.supportSSDTrim){return}if(!this.isDirty()){return}d.enable=b;d.space_path=this.pool?this.pool.get("space_path"):this.volume.get("space_path");d.num_id=this.pool?this.pool.get("num_id"):this.volume.get("num_id");d.is_pool_child=this.pool?true:false;if(b){d.schedule=this.isScheduleEdited?this.scheduleToOld(a):c}return{api:"SYNO.Storage.CGI.Volume",method:"ssd_trim_save",version:1,params:d}},loadDataVolumes:function(c){var b=this.grid.getStore(),a=SYNO.SDS.StorageUtils;if(c.volumes&&c.volumes.length>0){b.append(_T("volume","volume"),a.getVolumeNames(c.volumes))}},loadDataSsdTrim:function(b){var a=this;if(b.ssd_trim){a.volume.json.ssd_trim=b.ssd_trim;if(b.ssd_trim.schedule.next_trigger_time){a.nextTriggerTime=b.ssd_trim.schedule.next_trigger_time;Ext.getCmp(this.nextTriggerTimeId).setValue(a.nextTriggerTime)}else{a.updateNextTriggerTime(false)}a.origEnableStatus=b.ssd_trim.enable===1;Ext.getCmp(a.enabledId).setValue(a.origEnableStatus);Ext.getCmp(a.editButtonId).setDisabled(!a.origEnableStatus)}},updateNextTriggerTime:function(d){var c=this;var e={};var b=this.volume.get("ssd_trim").schedule;var a=this.schedule;if("-"!==this.nextTriggerTime&&!this.isScheduleEdited){if(d){Ext.getCmp(this.nextTriggerTimeId).setValue(this.nextTriggerTime)}return}e.schedule=this.isScheduleEdited?this.scheduleToOld(a):b;c.busyee.setStatusBusy();SYNO.API.Request({api:"SYNO.Storage.CGI.Volume",method:"next_trim_time_get",version:1,params:e,callback:function(i,h,g,f){c.busyee.clearStatusBusy();if(!i){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,h);return}this.nextTriggerTime=h.next_trigger_time;if(d){Ext.getCmp(this.nextTriggerTimeId).setValue(this.nextTriggerTime)}},scope:this})},scheduleToNew:function(b){if(b.hasOwnProperty("week_name")){b.week_day=b.week_name;delete b.week_name}if(b.hasOwnProperty("repeat")){b.repeat_data=b.repeat;b.repeat_date=b.repeat;delete b.repeat}if(b.hasOwnProperty("min")){b.minute=b.min;delete b.min}if(!b.hasOwnProperty("date")){var a=new Date();b.date=(a.getYear()+1900)+"/"+(a.getMonth()+1)+"/"+a.getDate();b.repeat_date=0}return b},scheduleToOld:function(a){if(a.hasOwnProperty("week_day")){a.week_name=a.week_day;delete a.week_day}if(a.hasOwnProperty("repeat_data")){a.repeat=a.repeat_data;delete a.repeat_data}if(a.hasOwnProperty("minute")){a.min=a.minute;delete a.minute}if(a.hasOwnProperty("repeat_date")){a.repeat=a.repeat_date;delete a.repeat_date}return a}});Ext.define("SYNO.SDS.StorageManager.Wizard.ConfigureVolume",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;c.volume=a.volume;c.pool=a.pool;c.volume_support_ssd_trim=("yes"===_D("support_trim","no"))&&("not support"!==c.volume.get("ssd_trim").support);c.gernalTab=new SYNO.SDS.StorageManager.Wizard.VolumeGeneralProperty({appWin:c.appWin,owner:c,itemId:"gernal_tab",volume:c.volume});c.trimTab=new SYNO.SDS.StorageManager.Wizard.TrimVolumeProperty({appWin:c.appWin,owner:c,itemId:"trim_tab",volume:c.volume,pool:c.pool,border:false,frame:false,busyee:c});b={title:_T("volume","adv_prop_title"),width:660,height:450,resizable:false,layout:"fit",plain:true,border:false,items:[{itemId:"main",xtype:"syno_tabpanel",hideMode:"offsets",deferredRender:false,activeTab:0,plain:true,items:[c.gernalTab,c.trimTab]}],buttons:[{xtype:"syno_button",btnStyle:"blue",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","alt_apply"),scope:this,handler:this.onSave},{xtype:"syno_button",text:_T("common","alt_cancel"),scope:this,handler:this.onCancel}]};c.callParent([Ext.apply(b,a)])},onSave:function(){var b=this;var c=[];var a=this.getAllTabs();if(!this.isValid()){return}Ext.each(a,function(e){if(!e.getSettingAPI){return true}var d=e.getSettingAPI();if(Ext.isObject(d)){c.push(d)}});if(c.length===0){this.close()}this.setStatusBusy();this.sendWebAPI({scope:this,compound:{stopwhenerror:false,mode:"parallel",params:c},callback:function(g,f,e,d){this.clearStatusBusy();if(!g){this.getMsgBox().alert(this.title,_T("error","error_subject"));return}else{if(f.has_fail){Ext.each(f.result,function(h){var i={};if(!h.success){if(SYNO.SDS.StorageUtils.IsFeasibilityFail(h.error,i)){SYNO.SDS.StorageUtils.ConfirmFeasibilityFail(b,i,b.sendWebapiSkipFeasibilityCheck,SYNO.API.Util.GetReqByAPI(d,h.api,h.method))}else{SYNO.SDS.StorageUtils.HARemoteCheckErrParsing(h);SYNO.SDS.StorageUtils.ReportWebapiFailure(b,h.error)}}});return}}this.close()}})},onCancel:function(){if(this.isDirty()){this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(a){if("yes"===a){this.close()}},this);return}this.close()},isDirty:function(){var b=false;var a=this.getAllTabs();Ext.each(a,function(c){if(Ext.isFunction(c.isDirty)&&c.isDirty()){b=true;return false}});return b},isValid:function(){var c=this.getComponent("main");var b=true;var a=this.getAllTabs();Ext.each(a,function(d){if(Ext.isFunction(d.isValid)&&!d.isValid()){c.setActiveTab(d.itemId);b=false;return false}});return b},getAllTabs:function(){var a=this.getComponent("main").items;return a?a.items:[]},getActiveTab:function(){var a=this.getComponent("main");return(a&&Ext.isFunction(a.getActiveTab))?a.getActiveTab():null},sendWebapiSkipFeasibilityCheck:function(a){a.params.force=true;this.setStatusBusy({text:_T("common","saving")});this.sendWebAPI({api:a.api,method:a.method,version:a.version,params:a.params,callback:function(c,b){this.clearStatusBusy();if(!c){SYNO.SDS.StorageUtils.HARemoteCheckErrParsing(b);SYNO.SDS.StorageUtils.ReportWebapiFailure(this,b)}this.close()},scope:this})}});Ext.define("SYNO.SDS.StorageManager.Wizard.PoolChoosingStep",{extend:"SYNO.SDS.StorageManager.Wizard.Step",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.loaded=false;b={headline:_T("volume","volume_choose_raid_title"),items:[{xtype:"syno_storage_combobox",fieldLabel:_T("volume","volume_pool"),width:250,name:"pools",itemId:"pools",valueField:"id",displayField:"display",descriptionField:"desc",store:c.poolStore=new Ext.data.JsonStore({autoDestroy:true,idProperty:"id",fields:["id","display","avail","total","desc","raidLevel","multipleSupport","spacePath"]}),listeners:{select:this.onSelect,scope:this}},{xtype:"syno_displayfield",itemId:"raid_level",fieldLabel:_T("volume","volume_raid_type"),htmlEncode:false},{xtype:"syno_displayfield",itemId:"multiple_volume_support",fieldLabel:_T("volume","volume_multiple_vol_lun_support")},{xtype:"syno_displayfield",itemId:"total_size",fieldLabel:_T("volume","volume_totalsize")},{xtype:"syno_displayfield",itemId:"free_size",fieldLabel:_T("volume","volume_freesize")}]};c.callParent([Ext.apply(b,a)])},activate:function(){var c=this;var a=SYNO.SDS.StorageUtils;var d=[];var b,e;if(c.loaded){return}b=c.appWin.storagePools.getMatched("isFreeSizeBiggerThan1GB","isWritable","notUsedByGlusterFs");Ext.each(b,function(g){var f,i,h,j,k;k=g.get("id");f=g.get("size");h=parseInt(f.used,10);i=parseInt(f.total,10);j=i-h;d.push({id:k,display:String.format("{0} ({1}: {2})",a.SpaceIDParser(k).str,_T("volume","volume_freesize"),a.SizeRenderWithFloor(j)),desc:g.get("desc"),avail:j,total:i,numId:g.get("num_id"),raidLevel:g.get("device_type"),multipleSupport:g.supportMultiple(),spacePath:g.get("space_path")})});d.sort(function(g,f){return(g.numId>f.numId)?1:((g.numId===f.numId)?0:-1)});c.poolStore.loadData(d);e=c.poolStore.getAt(0);if(e){c.getComponent("pools").setValue(e.get("id"));c.onSelect(c,e,0)}c.loaded=true},onSelect:function(g,h,f){var e=SYNO.SDS.StorageUtils;var d=this.getComponent("raid_level");var b=this.getComponent("multiple_volume_support");var c=this.getComponent("total_size");var a=this.getComponent("free_size");d.setValue(e.SpaceTypeRender(h.data.raidLevel));b.setValue(h.data.multipleSupport?_T("common","yes"):_T("common","no"));c.setValue(e.SizeRender(h.data.total));a.setValue(e.SizeRender(h.data.avail))},updateData:function(d){var c=this.getComponent("pools");var b=c.getValue();var a=c.getStore().getById(b);d.selected_pool_id=b;d.raid_level=a.data.raidLevel;d.raid_type=a.data.multipleSupport?"multiple":"single";d.deploy_space_path=a.data.spacePath},getNext:function(){return this.nextId},summary:function(a){}});Ext.define("SYNO.SDS.StorageManager.Space",{check:SYNO.SDS.StorageUtils.check,get:function(a){if(this.json){return this.json[a]}return undefined},getIdProp:function(){return SYNO.SDS.StorageUtils.SpaceIDParser(this.get("id"))},getISCSIProp:function(){return this.isISCSI()?this.get("iscsi_lun"):{}},getStatusStr:function(){return SYNO.SDS.StorageUtils.StatusNameRender(this.getStatus())},getStatus:function(){if(this.isVolume()&&this.get("cache")){var a=this.get("cacheStatus");if("cache_degrade"===a||"cache_unsafe_crashed"===a||"cache_repairing"===a||"cache_deleting"===a){return a}}return this.get("status")},getName:function(){if(this.isISCSI()){return this.get("iscsi_lun").name}else{return SYNO.SDS.StorageUtils.SpaceIDParser(this.get("id")).str}},getLunId:function(){if(this.isISCSI()){return this.get("iscsi_lun").lid}else{return undefined}},getLunOwner:function(){var a=this.getISCSIProp();return a.hasOwnProperty("used_by")?a.used_by:""},getVolumeId:function(){if(this.isVolume()){return this.get("id")}else{return undefined}},isVolume:function(){return"volume"===this.getIdProp().type},isISCSI:function(){return"iscsi"===this.getIdProp().type},isActioning:function(){return !!(this.get("is_actioning"))},isDeleting:function(){return"deleting"===this.get("status")},isCreating:function(){return"creating"===this.get("status")},isScheduled:function(){return !!(this.get("is_scheduled"))},isCrashed:function(){var a=this.get("status");if("background"===a){a=this.checkRaidStatus()}return"crashed"===a},isDegrade:function(){var a=this.get("status");if("background"===a){a=this.checkRaidStatus()}return"degrade"===a},isNotCrashed:function(){return"crashed"!==this.get("status")},isBgProgressing:function(){return"background"===this.get("status")},isWritable:function(){return !!(this.get("is_writable"))},isExpansion:function(){return 0===this.get("device_type").indexOf("expansion")},isBlockSpace:function(){return this.isVolume()||"block"===this.getISCSIProp().device_type},isBlockLun:function(){return("block"===this.getISCSIProp().device_type)},isFileLun:function(){return("file"===this.getISCSIProp().device_type||"sink"===this.getISCSIProp().device_type)},isSinkLun:function(){return("sink"===this.getISCSIProp().device_type)},isBLun:function(){return this.getISCSIProp().is_blun},isLunOwnedByCinder:function(){return("cinder"===this.getLunOwner())},isLunOwnedByDsm:function(){return("dsm"===this.getLunOwner())},isPool:function(){return(this.get("pool_path")===this.id||(""===this.get("pool_path")&&!this.get("vol_path")))},isPoolChild:function(){if(this.isPool()){return false}return this.get("pool_path")&&this.get("pool_path").length>0},isUnhealthy:function(){return"Unhealthy"===this.get("status")},isExt4Volume:function(){return"ext4"===this.get("fs_type")},isBtrfsVolume:function(){return"btrfs"===this.get("fs_type")},isSingleVolume:function(){if("single"===this.get("raidType")&&this.isDeploy()&&-1<this.get("deploy_path").indexOf("volume")){return true}return false},isSingleLun:function(){if("single"===this.get("raidType")&&this.isDeploy()&&-1<this.get("deploy_path").indexOf("iscsilun")){return true}return false},isSingleBayBasicVolume:function(){return this.isVolume()&&""===this.get("pool_path")},isSHR:function(){return -1<this.getDeviceType().indexOf("shr")},supportMultiple:function(){if(this.isPool()&&"multiple"===this.get("raidType")){return true}return false},notUsedByGlusterFs:function(){return !this.get("used_by_gluster")},usedByGlusterFs:function(){return this.get("used_by_gluster")||false},cacheMissing:function(){return("cache_missing"===this.get("cacheStatus"))},cacheCrashed:function(){return("cache_crashed"===this.get("cacheStatus"))},getPoolChild:function(){if(this.isPool()){return this.get("pool_child")}return undefined},getPoolID:function(){if(this.isPool()){return this.get("id")}return this.get("pool_path")},isLogicalVolume:function(){if(this.isPool()||!this.get("raidType")){return false}return"multiple"===this.get("raidType")},canRepair:function(a){if(0===a.length||-1===a.indexOf(this.get("space_path"))){return true}return false},getDriveType:function(){var a=this.get("drive_type");if(-1===a){return"Unknown"}else{if(0===a){return"HDD"}else{if(1===a){return"SSD"}else{if(2===a){return"Hybrid"}}}}},getDriveTypeStr:function(){var a=this.get("drive_type");if(-1===a){return _T("common","status_unknown")}else{if(0===a){return"HDD"}else{if(1===a){return"SSD"}else{if(2===a){return _T("volume","drv_hybrid")}}}}},canExpandUnalloc:function(){var a=this.get("can_do");if(Ext.isDefined(a.expand_with_unalloc_size)){return true}return false},getDeviceType:function(){return this.get("device_type")},getProgressStep:function(){return this.get("progress").step},isFreeSizeBiggerThan1GB:function(){var b=parseInt(this.get("size").total,10);var a=parseInt(this.get("size").used,10);var c=(b-a)/(1024*1024*1024);return c>=1},isDeploy:function(){var a=this.get("deploy_path");if(a&&a.length>0){return true}return false},notDeployed:function(){return !this.isDeploy()},checkRaidStatus:function(){var a="normal";Ext.each(this.get("raids"),function(b){switch(b.raidStatus){case 2:a="degrade";return true;case 4:a="crashed";return false;default:return true}});return a},supportRaidScrubbing:function(){var b=this.get("device_type");var a,c=false;switch(b){case"raid_5":case"raid_6":case"raid_f1":case"raid_5+spare":case"shr_with_2_disk_protect":c=true;break;case"shr_with_1_disk_protect":a=this.get("disks");if(2<a.length){c=true}else{c=false}break;default:c=false}return c},supportFSScrubbing:function(a){var b=false;Ext.each(a.appWin.volumes.getAll(),function(c){if(this.get("id")===c.get("pool_path")){if("btrfs"===c.get("fs_type")){b=true}}},this);return b},supportDataScrubbing:function(a){return(this.supportFSScrubbing(a)||this.supportRaidScrubbing())}});Ext.define("SYNO.SDS.StorageManager.Volume.Store",{extend:"Ext.ux.data.PagingJsonStore",constructor:function(a){var c=this,b;c.sortField="numId";c.sortDir="ASC";b={autoDestroy:true,idProperty:"id",fields:["numId","id","iconCls","statusIconCls","displayName","desc","usage","barWidth","summaryStatus","property","raidInfo","status","totalSize","freeSize","tip"],listeners:{load:function(){c.sort(c.sortField,c.sortDir)},scope:c}};c.callParent([Ext.apply(b,a)])}});Ext.define("SYNO.SDS.StorageManager.Volume.Main",{extend:"SYNO.ux.Panel",pageSize:25,constructor:function(a){var d=this,b,c;d.appWin=a.appWin;d.owner=a.appWin;d.sortType="sort_numId";d.createView();c=d.view.getSelectedItem();b={border:false,layout:"fit",itemId:"volume",tbar:{defaultType:"syno_button",items:[{itemId:"create",text:_T("common","create"),handler:d.onCreate,hidden:d.appWin.isVDSM,scope:d},{itemId:"remove",text:_T("common","remove"),handler:d.onDelete,hidden:d.appWin.isVDSM,scope:d},{itemId:"manage",text:_T("common","action"),menu:[{itemId:"defrag",text:_T("volume","fs_defrag"),handler:function(){d.onAdvManage("defrag")},scope:d},{itemId:"expand",text:_T("volume","volume_adddisk2_type_expand"),handler:d.onExpand,scope:d},{itemId:"configure",text:_T("volume","adv_prop_title"),handler:d.onConfigure,scope:d}]},{itemId:"cancel",text:_T("common","alt_cancel"),handler:d.onCancel,scope:d},"->",new SYNO.SDS.StorageManager.SortButton({appWin:d.appWin,owner:d,menuItems:[{text:_T("volume","volume_sort_by_id"),itemId:"sort_numId",handler:d.onSort,scope:d},{text:_T("volume","volume_sort_by_status"),itemId:"sort_status",handler:d.onSort,scope:d},{text:_T("volume","volume_sort_by_available"),itemId:"sort_freeSize",handler:d.onSort,scope:d},{text:_T("volume","volume_sort_by_capacity"),itemId:"sort_totalSize",handler:d.onSort,scope:d}]})]},bbar:new SYNO.ux.PagingToolbar({store:d.view.store,pageSize:d.pageSize}),items:d.view,listeners:{activate:d.onActivate,scope:d}};d.callParent([Ext.apply(b,a)])},getHelpParam:function(){return"StorageManager/volume.html"},createView:function(){var e=this,c=SYNO.SDS.StorageManager.UsageTpl(),d=SYNO.SDS.StorageManager.PropertyWithTipTpl(),g=SYNO.SDS.StorageManager.DiskListTpl({scope:"disks",emptyText:_T("volume","volume_status_none")}),f=SYNO.SDS.StorageManager.DiskListTpl({scope:"spares",title:_T("volume","volume_suitable_spare_disks"),emptyText:_T("volume","volume_no_suitable_spare_disks")}),b,a;b=new Ext.XTemplate('<div class="item-detail-inner">',d.html,'<tpl if="this.hasValues(raidInfo) == true">','<tpl for="raidInfo">',(e.appWin.isVDSM)?"":g.html,(e.appWin.supportHotSpare)?f.html:"","</tpl>","</tpl>","</div>");a={appWin:e.appWin,owner:e,dataType:"volumes",itemId:"volumeView",multiSelect:true,usageTpl:c,detailTpl:b,store:new SYNO.SDS.StorageManager.Volume.Store(),listeners:{selectionchange:e.onSelectChange,scope:e}};e.view=new SYNO.SDS.StorageManager.DataView(a)},prepareUiData:function(){var a=this,b=a.appWin.volumes.getMatched("notUsedByGlusterFs");delete a.uiData;delete a.ssdLinkIdList;a.uiData=[];a.ssdLinkIdList=[];Ext.each(b,function(c){var d={};a.prepareSummary(c,d);a.prepareProperty(c,d);a.uiData.push(d)},a)},prepareSummary:function(d,e){var c=SYNO.SDS.StorageUtils;var b=parseInt(d.get("size").used,10);var a=parseInt(d.get("size").total,10);var f;e.numId=d.get("num_id");e.status=d.getStatus();e.totalSize=a;e.freeSize=a-b;e.id=d.get("id");e.displayName=c.SpaceIDParser(d.get("id")).str;e.desc=d.get("desc");e.usage=String.format('<span style="color:#0086E5">{0}</span>&nbsp;/&nbsp;{1}',c.SizeRender(b),c.SizeRender(a));e.barWidth=(0===a)?0:200*b/a;e.summaryStatus=String.format("&nbsp;-&nbsp;{0}",c.StatusNameRender(d.getStatus()));if("btrfs"===d.get("fs_type")){f="btrfs"}else{f="ext4"}if(d.isLogicalVolume()){e.iconCls="sm-list-icon-"+f+"-multi-volume"}else{e.iconCls="sm-list-icon-"+f+"-single-volume"}if(d.get("is_actioning")){e.statusIconCls="sm-list-status-icon-acting"}else{if("cache_unsafe_crashed"===e.status||"cache_safe_crashed"===e.status||"cache_degrade"===e.status||"crashed"===e.status||"degrade"===e.status){e.statusIconCls="sm-list-status-icon-crashed"}}},prepareProperty:function(i,q){var p=this,k=SYNO.SDS.StorageUtils,d=parseInt(i.get("size").used,10),e=parseInt(i.get("size").total,10),l,m,h;if("cache_missing"===i.get("cacheStatus")){l=k.StatusNameRender(i.get("cacheStatus"))}else{l=k.StatusRender(i.getStatus(),i.get("progress"))}h=k.WarningTextRender(i.getStatus(),k.SpaceIDParser(i.get("pool_path")).str);q.property=[];if(!p.appWin.isVDSM){q.property.push({name:_T("volume","volume_raid_title"),value:k.SpaceTypeRender(i.get("device_type"))})}p.renderSuggestions(i,q);if(i.get("pool_path")){q.property.push({name:_T("volume","volume_storage_pool"),value:k.SpaceIDParser(i.get("pool_path")).str})}if(i.get("fs_type")){m="volume_add_fs_"+i.get("fs_type")+"_type";q.property.push({name:_T("volume","volume_add_fs_type"),value:_T("volume",m)})}q.property.push({name:_T("volume","volume_volumestatus"),value:l+h});if(i.get("cache")){var b=Ext.id();var j=i.get("cache").id;var o=String.format('<a class="link-font" href="#" id={0} cache_id={1}>{2}</a>',b,i.get("cache").id,SYNO.SDS.StorageUtils.SpaceIDParser(j).str);var f=this.appWin.ssdCaches.data[j];var n=f?f.getStatusStr():"-";var a=String.format("{0} ({1})",o,n);p.ssdLinkIdList.push(b);q.property.push({name:_T("volume","ssd_cache"),value:a})}q.property.push({name:_T("volume","volume_totalsize"),value:k.SizeRender(e)});var c={name:_T("volume","volume_usedsize"),value:k.SizeRender(d)};var r=i.get("vol_path");var g=this.volumeReclaim.hasOwnProperty(r)?this.volumeReclaim[r]:0;if(g>0){c.value=String.format("{0} ({1} {2})",c.value,k.SizeRender(g),_T("volume","lun_space_reclaim_progress"));c.tip=_T("volume","lun_space_reclaim_info_desc")}q.property.push(c);q.property.push({name:_T("volume","volume_freesize"),value:k.SizeRender(e-d)});if(i.get("is_inode_full")){q.property.push({name:_T("volume","volume_available_filenumber"),value:'<span class="red-status">'+i.get("size").free_inode+"</span>"})}},linkTargetElement:function(g,f){var c=this,b=new Ext.Element(f),a=b.getAttribute("cache_id"),d;if(""===a){return}c.appWin.selectPage("SYNO.SDS.StorageManager.SsdCache.Main");d=c.appWin.getActivePage();d.listView.select(a);d.fireEvent("nextDetail")},renderSuggestions:function(p,y){var q,o="",h="",f={};var a=false;var g=false;var j=false;var x=false;var e=false;var d=false;var n=false;var c="";var v="";var s="";var t="";var l=p.get("suggestions");var w=SYNO.SDS.StorageUtils;if(!l||l.length<=0){return}for(q=0;q<l.length;q++){h=w.FormatSuggestion(l[q]);if(undefined!==l[q].note){switch(l[q].note){case"system partition failed":f=SYNO.SDS.Utils.clone(l[q]);f.str=h;a=true;break;case"remove crashed pool child":f=SYNO.SDS.Utils.clone(l[q]);f.str=h;g=true;break;case"repair degraded pool child":f=SYNO.SDS.Utils.clone(l[q]);f.str=h;j=true;break;case"fs error need fsck":f=SYNO.SDS.Utils.clone(l[q]);f.str=h;d=true;break;case"repair warning pool child":f=SYNO.SDS.Utils.clone(l[q]);f.str=h;x=true;break;case"repair warning disk child":f=SYNO.SDS.Utils.clone(l[q]);f.str=h;e=true;break;case"some disks are failing":f=SYNO.SDS.Utils.clone(l[q]);f.str=h;n=true;break;case"cache unsafe crashed":console.log("cache unsafe crashed");o+=String.format('<span class="{0}">{1}{2}</span><br>',l[q].type==="warning"?"red-status":"green-status",String.format(h,SYNO.SDS.StorageUtils.SpaceIDParser(p.get("cache").id).str),"");break;case"cache degrade":case"cache safe crashed":case"cache ro crashed":if("crashed"!==p.get("status")){o+=String.format('<span class="{0}">{1}{2}</span><br>',l[q].type==="warning"?"red-status":"green-status",String.format(h,SYNO.SDS.StorageUtils.SpaceIDParser(p.get("cache").id).str),"")}break;default:continue}}else{o+=String.format('<span class="{0}">{1}{2}</span><br>',l[q].type==="warning"?"red-status":"green-status",h,"")}}if(a){var m=Ext.id();c=String.format('&nbsp<a class="link-font" id="{0}" href="#" space_id={1}>{2}</a>',m,p.get("id"),_T("volume","volume_repair_syspart"));o+=String.format('<span class="{0}">{1}{2}</span><br>',f.type==="warning"?"red-status":"green-status",f.str,c);if(c){this.mon(this.view.getStore(),"load",function(){var i=Ext.fly(m);this.mon(i,"click",this.repairSysPartition,this)},this,{single:true})}}else{if(g){var r=Ext.id();v=String.format('&nbsp<a class="link-font" id="{0}" href="#" space_id={1}>{2}</a>',r,p.get("pool_path"),_T("volume","volume_storage_pool_link"));o+=String.format('<span class="{0}">{1}{2}</span><br>',f.type==="warning"?"red-status":"green-status",f.str,v);if(v){this.mon(this.view.getStore(),"load",function(){var i=Ext.fly(r);this.mon(i,"click",this.linkPoolElement,this)},this,{single:true})}}else{if(j||x){var b=Ext.id();s=String.format('&nbsp<a class="link-font" id="{0}" href="#" space_id={1}>{2}</a>',b,p.get("pool_path"),_T("volume","volume_storage_pool_link"));o+=String.format('<span class="{0}">{1}{2}</span><br>',true===j?(f.type==="warning"?"red-status":"green-status"):"orange-status",f.str,s);if(s){this.mon(this.view.getStore(),"load",function(){var i=Ext.fly(b);this.mon(i,"click",this.linkPoolElement,this)},this,{single:true})}}else{if(e){var k=Ext.id();s=String.format('&nbsp<a class="link-font" id="{0}" href="#">{1}</a>',k,_T("volume","volume_disk_link"));o+=String.format('<span class="{0}">{1}{2}</span><br>',"orange-status",f.str,s);if(s){this.mon(this.view.getStore(),"load",function(){var i=Ext.fly(k);this.mon(i,"click",this.linkDiskElement,this)},this,{single:true})}}else{if(d){var u=Ext.id();t=String.format('&nbsp<a class="link-font" id="{0}" href="#" space_id={1}>{2}</a>',u,p.get("id"),_T("volume","volume_do_fsck"));o+=String.format('<span class="{0}">{1}{2}</span><br>',f.type==="warning"?"red-status":"green-status",f.str,t);if(t){this.mon(this.view.getStore(),"load",function(){var i=Ext.fly(u);this.mon(i,"click",this.showFsckDialog,this)},this,{single:true})}}else{if(n){o+=String.format('<span class="orange-status">{0}</span><br>',f.str)}else{SYNO.Debug("other suggestion")}}}}}}y.property.push({name:_T("volume","volume_status_suggest"),value:o})},onDeactivate:function(){if(this.volumeUsageReclaimPoll){this.volumeUsageReclaimPoll.stop();delete this.volumeUsageReclaimPoll}},onActivate:function(){this.startVolumeUsageReclaimPoll();this.refreshData()},refreshData:function(){var b=this,c,a=b.view.store;b.prepareUiData();if(a.start>=b.uiData.length){c=(b.uiData.length<=b.pageSize)?0:Math.floor(b.uiData.length/b.pageSize)*b.pageSize}else{c=a.start||0}a.lastOptions={params:{limit:b.pageSize,start:c}};a.loadData(b.uiData,false);b.resetBtnStatus();if(0<b.view.store.getCount()&&0===b.view.getSelectedItemIds().length){b.view.select(0,true,true)}if(b.pageSize>=b.uiData.length){b.getBottomToolbar().hide()}else{b.getBottomToolbar().show()}b.doLayout();b.onSelectChange();b.setMask();b.monSsdLink();b.addToolTips()},addToolTips:function(){var c=this.getComponent("volumeView");var a=c?c.getEl():null;var b=a?a.query(".sm-tip-placeholder"):[];Ext.each(b,function(d){SYNO.SDS.Utils.AddTip(d,d.getAttribute("tip"))});return},startVolumeUsageReclaimPoll:function(){if(this.volumeUsageReclaimPoll){return}this.volumeUsageReclaimPoll=this.addWebAPITask({api:"SYNO.Core.ISCSI.Node",method:"get",version:1,params:{additional:["no_rod_key","ep_buf_mapped_size"]},interval:6000,callback:function(d,c,b,a){if(this.volumeUsageReclaimPollFirstTime){this.volumeUsageReclaimPollFirstTime=false;this.owner.clearStatusBusy()}if(!d||!c||!Ext.isArray(c.ep_buf_mapped_size)){this.volumeReclaim={};return}this.volumeReclaim=c.ep_buf_mapped_size.reduce(function(e,f){if(f.root_path&&Ext.isNumber(f.mapped_size)&&f.mapped_size>0){e[f.root_path]=f.mapped_size}return e},{});this.refreshData()},scope:this});this.volumeReclaim={};this.owner.setStatusBusy();this.volumeUsageReclaimPollFirstTime=true;this.volumeUsageReclaimPoll.start()},monSsdLink:function(){var a=this;a.ssdLinkIdList.forEach(function(b){a.mon(Ext.fly(b),"click",a.linkTargetElement,a,{single:true})})},onSelectChange:function(){var b=this,a,c=b.view.getSelectedItems();b.getButton("remove").hide();b.getButton("manage").hide();b.getButton("cancel").hide();if(0===c.length){this.disablePanelFunctionBySystemDR();return}if(!b.appWin.isVDSM){b.getButton("remove").show();b.enableButton("remove",b.canDelete(c))}if(1===c.length){a=c[0];if(a.isCreating()||("defrag"===a.getProgressStep())){b.getButton("cancel").show();b.enableButton("cancel",b.canCancel(a))}if(!b.appWin.isVDSM){b.getButton("manage").show();b.enableButton("manage",this.canManage(a))}}this.disablePanelFunctionBySystemDR()},onCreate:function(){var b=this,a;a=b.canCreate();if(!a){return}b.openWizard("CreateVolumeMain",{mode:"create",option:a})},onDelete:function(){var c=this,d,a,b;d=c.view.getSelectedItems();if(0===d.length){return}for(b=0;b<d.length;++b){if(d[b].get("used_by_gluster")){c.owner.getMsgBox().alert(c.title,_T("volume","goto_cms_manage_volume"));return}}a=c.view.getSelectedItemIds();c.openWizard("DeleteVolume",{volumeIds:a})},onAdvManage:function(h){var b=this;var g,f,e;var a=b.view.getSelectedItem();var d={defrag:_T("volume","fs_do_defrag")};var c={defrag:_T("volume","fs_defrag_notice")};e={vol_path:a.get("vol_path")};f=d[h];g=c[h];if(SYNO.SDS.StorageUtils.IsBlockedInSDR(b.appWin)){return}b.owner.getMsgBox().confirm(f,g,function(i){if("yes"===i){this.owner.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:"SYNO.Storage.CGI.Volume",method:h,version:1,params:e,callback:function(m,l,k,j){this.owner.clearStatusBusy();if(!m){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,l)}},scope:this})}},this)},onExpand:function(){var b=this;var a=b.view.getSelectedItem();if(SYNO.SDS.StorageUtils.IsBlockedInSDR(b.owner)){return}if(!a){return}b.openWizard("ManageVolume",{volume:a,manageAction:"expand_with_unalloc_size"})},onConfigure:function(){var c=this;var b,a;b=c.view.getSelectedItem();if(SYNO.SDS.StorageUtils.IsBlockedInSDR(c.appWin)){return}if(!b){return}a=c.appWin.storagePools.data[b.get("pool_path")];c.openWizard("ConfigureVolume",{volume:b,volpath:b.get("vol_path"),pool:a})},onCancel:function(){var c=this,b=c.view.getSelectedItem(),e,a,d;if(SYNO.SDS.StorageUtils.IsBlockedInSDR(c.appWin)){return}if(!b){return}e=b.get("id");a="";d="cancel_create";c.appWin.stopPollTask();c.owner.setStatusBusy({text:_T("common","saving")});if("defrag"===b.getProgressStep()){d="cancel_defrag";a=b.get("vol_path")}SYNO.API.Request({api:"SYNO.Storage.CGI.Volume",method:d,version:1,params:{space_id:e,vol_path:a},callback:function(i,h,g,f){this.clearStatusBusy();if(!i){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,h)}this.setStatusBusy();this.cleanMask=true;this.startPollTask()},scope:c.owner})},onSort:function(f,d){var c=this,b,a=c.view.store;if(0>f.itemId.indexOf("_")){return}c.sortType=f.itemId;b=f.itemId.split("_")[1];if(a.sortField!==b){a.sortField=b;a.sortDir="ASC"}else{a.sortDir="ASC"===a.sortDir?"DESC":"ASC"}a.sort(a.sortField,a.sortDir);c.onSelectChange()},resetBtnStatus:function(){var a=this;a.getButton("remove").hide();a.getButton("cancel").hide();a.enableButton("create",a.canCreate());this.disablePanelFunctionBySystemDR()},setMask:function(){var b=this;if(b.isVisible()&&0===b.view.getStore().getCount()){if(0===b.appWin.storagePools.count&&b.appWin.supportRaidGroup){var d=Ext.id();var a=String.format('<a id="{0}" class="link-font" style="cursor:pointer;">{1}</a>',d,_T("volume","volume_storage_pool_tab"));var c=String.format(_T("volume","volume_no_raid_in_system"),_T("volume","volume_storage_pool"),a);this.body.mask(c,"syno-ux-mask-info");b.mon(Ext.fly(d),"click",function(){b.appWin.selectPage("SYNO.SDS.StorageManager.Pool.Main")},b)}else{this.body.mask(_T("volume","volume_no_volumes"),"syno-ux-mask-info")}this.getButton("sort").disable()}if(0<this.view.getStore().getCount()){this.body.unmask();this.getButton("sort").enable()}this.disablePanelFunctionBySystemDR()},setFocus:function(a){if(!a||!this.view){return}this.view.setFocus(a)},syncHeight:function(){var b=this.toolbarHeight,c=this.body,a=this.lastSize.height,d;if(this.autoHeight||!Ext.isDefined(a)||a=="auto"){return}if(b!=this.getToolbarHeight()){b=Math.max(0,a-this.getFrameHeight());if(this.getBottomToolbar().isVisible()){b-=12}c.setHeight(b);d=c.getSize();this.toolbarHeight=this.getToolbarHeight();this.onBodyResize(d.width,d.height)}},canCreate:function(){var c=this,a=c.appWin.disks.getMatched("isNormalTray","isFree"),d=c.appWin.storagePools.getMatched("isFreeSizeBiggerThan1GB","isWritable","notDeployed","notUsedByGlusterFs"),b={},e;if(c.appWin.isVDSM){return false}if((_S("ha_running")&&c.appWin.isUpToHASpaceMaxCount())||c.appWin.isUpToVolumeMaxCount()){return false}if(0<a.length&&!this.appWin.supportRaidGroup){b.can_create_volume=true}if(0<d.length){b.can_create_volume_on_existing_pool=true}for(e in b){if(b.hasOwnProperty(e)){return b}}return false},canDelete:function(g){var f=this;var e=f.appWin.storagePools.data;var b,a,d,c;if(f.appWin.isVDSM){return false}if(0===g.length){return false}for(a=0;a<g.length;++a){d=g[a];if(d.isActioning()){return false}b=e[d.get("pool_path")];if(b&&b.isCrashed()){return false}c=d.get("can_do");if(!c["delete"]){return false}}if(f.appWin.isAnyStorageActioning(g)){return false}return true},canManage:function(c){var b=this;var d=this.getButton("manage").menu;var a=false;if(b.appWin.isVDSM){return false}if(!c){return false}if(c.isActioning()){return false}if(c.isCrashed()){return false}d.getComponent("defrag").disable();d.getComponent("configure").disable();d.getComponent("expand").disable().hide();if("yes"===_D("support_btrfs","no")&&"btrfs"===c.get("fs_type")&&"normal"===c.get("status")){d.getComponent("defrag").enable();a=true}if(b.canConfigure(c)){d.getComponent("configure").enable();a=true}if(b.canExpand(c)){d.getComponent("expand").enable().show();a=true}return a},canExpand:function(f){var e=this,d=f.get("can_do"),a=f.get("size"),c,b;if(e.appWin.isVDSM){return false}if(!f||!d||!d.expand_with_unalloc_size){return false}c=parseInt(d.expand_with_unalloc_size,10);b=parseInt(a.total_device,10);return(0<c&&c===b)},canCancel:function(c){var b=this,a;if(b.appWin.isVDSM){return false}if(!c){return false}if(c.isCreating()){a=c.getProgressStep();if(a==="mk_filesystem"||a==="disk_check"||a==="raid_syncing"||a==="raid_parity_checking"||(a==="waiting"&&!_S("ha_running"))){return true}}else{if("defrag"===c.getProgressStep()){return true}}return false},canEdit:function(a){if(!a){return false}if(a.isActioning()){return false}if(a.isCrashed()){return false}return true},canTrim:function(a){if(!a){return false}if(a.isDeleting()||a.isCreating()){return false}if(a.isCrashed()){return false}if("yes"!==_D("support_trim","no")||"not support"===a.get("ssd_trim").support){return false}return true},canConfigure:function(a){return this.canEdit(a)||this.canTrim(a)},openWizard:function(b,a){var c=this,e;if(c.appWin.isUpToBatchTaskCount()){e=_T("volume","volume_max_batch_task_count").replace("_MAX_TASK_",c.appWin.getMaxBatchTaskCount());c.appWin.getMsgBox().alert(c.title,e,function(){},c);return}var d=new SYNO.SDS.StorageManager.Wizard[b](Ext.apply({appWin:c.appWin,owner:c.owner},a));c.appWin.stopPollTask();c.mon(d,"close",function(){if(Ext.isFunction(d.hideFromOwner)){d.hideFromOwner()}if(d.isDataChanged){c.owner.setStatusBusy();c.body.unmask();c.owner.cleanMask=true}c.appWin.startPollTask()},c,{single:true});d.open()},repairSysPartition:function(c,b){var a=new Ext.Element(b);var d=a.getAttribute("space_id");this.owner.setStatusBusy({text:_T("common","saving")});this.owner.updater.stop();SYNO.API.Request({webapi:{api:"SYNO.Storage.CGI.Storage",method:"repair_sys_partition",version:"1",params:{space_id:d}},callback:function(h,e,g,f){this.owner.clearStatusBusy();if(!h){this.owner.getMsgBox().alert(this.title,_T("common","commfail"));this.owner.updater.start();return}if(e.str){this.owner.getMsgBox().alert(this.title,e.str,function(){this.owner.setStatusBusy();this.owner.cleanMask=true;this.owner.updater.start()},this)}else{this.owner.updater.start()}},scope:this})},showFsckDialog:function(){if(!this.win){this.win=new SYNO.SDS.App.Ext4FsGoWrongApp.DiskScan({appInstance:{getUserSettings:function(){},setUserSettings:function(){}}});this.win.setTitle(_T("volume","volume_fsck_notification"))}this.win.show()},linkPoolElement:function(d,c){var b=this,a=new Ext.Element(c),f=a.getAttribute("space_id");b.appWin.selectPage("SYNO.SDS.StorageManager.Pool.Main");b.appWin.getActivePage().setFocus(f)},linkDiskElement:function(c,b){var a=this;a.appWin.selectPage("SYNO.SDS.StorageManager.Disk.Main");a.appWin.getActivePage().setFocus("sda")},getButton:function(a){return this.getTopToolbar().getComponent(a)},getButtons:function(a){return a.map(this.getButton,this)},enableButton:function(c,a){var b=this.getButton(c);return a?b.enable():b.disable()},disablePanelFunctionBySystemDR:function(){var a=this;var b=a.getButtons(["create","remove","manage","cancel"]);if(!_S("systemdr_running")){return}if(!_S("systemdr_is_cdsm_single_volume")){SYNO.SDS.StorageUtils.DisableButtonsBySDR(b,_TT("SYNO.SDS.SystemDR.Instance","feasibility","not_support_in_beta"))}else{if(SYNO.SDS.Utils.isInC2DSM()){SYNO.SDS.StorageUtils.DisableButtonsBySDR(b,_TT("SYNO.SDS.SystemDR.Instance","feasibility","sdr_in_vdsm"))}}}});Ext.namespace("SYNO.SDS.StorageManager.Pool");SYNO.SDS.StorageManager.renderCheckBox=function(c,e,d,a){var g=(a)?a.id+"_"+this.dataIndex:Ext.id();var f=(c==="disabled")?_T("common","disabled"):_JSLIBSTR("uicommon","enable_column_"+e);var b;if("disabled"===c){b=String.format('<div class="syno-ux-grid-enable-column-{0}-{1}" id="{2}"></div>',c,e,g)}else{b=String.format('<div class="syno-ux-grid-enable-column-{0}" id="{1}"></div>',e,g)}d=d||{};d.cellAttr=String.format('aria-label="{0} {1}" aria-checked="{2}" aria-disabled="{3}" role="checkbox"',Ext.util.Format.stripTags(this.orgHeader),f,e,c);return b};SYNO.SDS.StorageManager.ScheduleSelector=function(f){f=f||{};var i,h,k;var d,j,l=new Ext.lib.Region(0,0,0,0);var b=f.dragSafe===true;this.init=function(p){i=p;i.on("render",o)};function m(){d=[];i.all.each(function(p){d[d.length]=p.getRegion()});j=i.el.getRegion()}function e(){return false}function g(p){return !b||p.target==i.el.dom}function n(p){i.on("containerclick",e,i,{single:true});if(!h){h=i.el.createChild({cls:"x-view-selector"});h.setDisplayed(false)}else{if(h.dom.parentNode!==i.el.dom){i.el.dom.appendChild(h.dom)}}m();i.clearSelections()}function c(v){var z=k.startXY;var D=k.getXY();var B=Math.min(z[0],D[0]);var A=Math.min(z[1],D[1]);var C=Math.abs(z[0]-D[0]);var t=Math.abs(z[1]-D[1]);if(i.owner&&i.owner.disableDataView){return}l.left=B;l.top=A;l.right=B+C;l.bottom=A+t;l.constrainTo(j);h.setRegion(l);for(var s=0,u=d.length;s<u;s++){var p=d[s],q=l.intersect(p);if(q&&!p.selected){p.selected=true;i.select(s,true)}else{if(!q&&p.selected){p.selected=false;i.deselect(s)}}}}function a(p){if(!Ext.isIE){i.un("containerclick",e,i)}if(h){h.setDisplayed(false)}if(i.owner&&i.owner.selectRecords){i.owner.selectRecords(i,d)}}function o(p){k=new Ext.dd.DragTracker({onBeforeStart:g,onStart:n,onDrag:c,onEnd:a});k.initEl(p.el)}};SYNO.SDS.StorageManager.SchePlanPanel=Ext.extend(Ext.Panel,{CLASS_LIST:["syno-sds-bw2-schedule-td-no-download","syno-sds-bw2-schedule-td-full-speed","syno-sds-bw2-schedule-td-alt-speed"],DAY_STRING_SHORT:[_T("schedule","dayabbre_sun"),_T("schedule","dayabbre_mon"),_T("schedule","dayabbre_tue"),_T("schedule","dayabbre_wed"),_T("schedule","dayabbre_thu"),_T("schedule","dayabbre_fri"),_T("schedule","dayabbre_sat")],constructor:function(a){this.currentSpeed="0";this.currentSchedule=[];this.defaultSchedule=[];this.rate=[];for(var c=0;c<24;c++){this.currentSchedule[c]="0"}for(c=0;c<24*7;c++){this.defaultSchedule[c]="1"}var b={cls:"syno-dl-schedule-panel",border:false,width:"100%",layout:"anchor",autoFlexcroll:true,title:_T("data_scrubbing","time_session"),items:[this.getPanelConfig(a)],listeners:a.listeners};Ext.apply(b,a);SYNO.SDS.StorageManager.SchePlanPanel.superclass.constructor.call(this,b)},initComponent:function(){SYNO.SDS.StorageManager.SchePlanPanel.superclass.initComponent.call(this);this.addEvents("beforecellchange")},getPanelConfig:function(a){var d=a.buttons||[];this.dataView=this.createDataView();this.disableDataView=false;d.push({label:_T("data_scrubbing","suspend_data_scrubbing")});d.push({label:_T("data_scrubbing","run_data_scrubbing")});var e=[];for(var c=0;c<2;c++){e=e.concat(this.getSingleBtnConfig(d[c]||{},c))}var f=_T("data_scrubbing","wait_for_setting");var g=new Ext.data.ArrayStore({fields:["display","value"],data:[[_T("schedule","repeat_monthly"),1],[_T("schedule","repeat_tri_monthly"),2],[_T("schedule","repeat_half_year"),3],[_T("schedule","repeat_yearly"),4]]});var b={id:this.fieldset_id=Ext.id(),border:false,layout:"form",items:[{xtype:"syno_checkbox",id:this.enable_check_id=Ext.id(),scope:this,boxLabel:_T("data_scrubbing","enable_schedule"),name:"enableCheckBox",listeners:{scope:this,check:function(h,i){Ext.getCmp(this.date_comp_id).setDisabled(!i);Ext.getCmp(this.repeat_comp_id).setDisabled(!i);Ext.getCmp(this.time_session_id).setDisabled(!i);Ext.getCmp(this.sche_plan_status_id).setDisabled(!i)}}},{xtype:"syno_compositefield",hideLabel:true,name:"interval",indent:1,id:this.repeat_comp_id=Ext.id(),disabled:true,items:[{xtype:"syno_displayfield",value:_T("data_scrubbing","interval")+_T("common","colon"),width:234},{xtype:"syno_combobox",store:g,hideLabel:true,value:3,indent:0,id:this.repeat_id=Ext.id(),displayField:"display",valueField:"value",triggerAction:"all",width:200,mode:"local",editable:false,tpl:new Ext.XTemplate('<tpl for=".">','<div ext:qtip="{display:htmlEncode}" class="x-combo-list-item" role="option" aria-label="{display}" id="{[Ext.id()]}">',"{display}","</div>","</tpl>")}]},{xtype:"syno_compositefield",hideLabel:true,name:"start_date",indent:1,id:this.date_comp_id=Ext.id(),disabled:true,items:[{xtype:"syno_displayfield",value:_T("data_scrubbing","start_date")+_T("common","colon"),width:234},{xtype:"syno_datefield",width:200,indent:0,id:this.date_id=Ext.id(),format:"Y/n/j",hideLabel:true,allowBlank:false,editable:false,maxValue:"2037/12/31",minValue:"2017/1/1"}]},{xtype:"syno_compositefield",hideLabel:true,name:"sche_plan_status",id:this.sche_plan_status_id=Ext.id(),indent:1,disabled:true,items:[{xtype:"syno_displayfield",value:_T("common","status")+_T("common","colon"),width:234},{xtype:"syno_displayfield",value:f,id:this.schedule_plan_status_id=Ext.id()}]},{xtype:"syno_fieldset",title:_T("data_scrubbing","time_session"),name:"sche_table",id:this.time_session_id=Ext.id(),disabled:true,items:[{xtype:"syno_radio",name:"schedule_plan_option",id:this.schedule_plan_default_id=Ext.id(),boxLabel:_T("data_scrubbing","run_all_time"),value:false,inputValue:"run_all_time"},{xtype:"syno_radio",name:"schedule_plan_option",id:this.schedule_plan_manual_id=Ext.id(),boxLabel:_T("data_scrubbing","manual_config_time"),value:false,inputValue:"run_setting_time",listeners:{scope:this,check:function(i,h){if(h){Ext.getCmp(this.schedule_plan_id).setDisabled(false)}else{Ext.getCmp(this.schedule_plan_id).setDisabled(true)}}}},{xtype:"syno_fieldset",id:this.schedule_plan_id=Ext.id(),style:"padding-left: 22px;",disabled:true,items:[{xtype:"syno_compositefield",cls:"syno-sds-bw2-schedule-btn-compositefield",style:"padding-bottom: 5px;",hideLabel:true,items:[e]},this.dataView]}]}]};return b},getSingleBtnConfig:function(b,a){return[{xtype:"button",itemId:a.toString(),pressed:0===a,cls:"syno-sds-bw2-schedule-btn",iconCls:this.getBtnIconCls(a),scope:b.scope||this,handler:b.handler||this.onSpeedButtonClick,hidden:b.hidden||Ext.isEmpty(b.label),disabled:b.disabled||false,text:" "},{xtype:"syno_displayfield",hidden:b.hidden||Ext.isEmpty(b.label),value:b.label,width:192}]},getBtnIconCls:function(a){var b="syno-sds-bw2-schedule-btn-";if(0===a){b+="no-download"}else{if(1===a){b+="full-speed"}else{if(2===a){b+="alt-speed"}}}return b},createDataView:function(){var a=new Ext.DataView({id:this.grid_id=Ext.id(),store:this.DAY_STRING_SHORT,multiSelect:true,itemSelector:"td.syno-sds-bw2-schedule-td",tpl:this.createTemplate(),owner:this,plugins:[new SYNO.SDS.StorageManager.ScheduleSelector()],listeners:{scope:this,click:function(f,c,d,b){var e=this.getSpeed();this.setClassToNodeByIndex(c,e);f.deselect(d)},afterrender:function(b){b.days=new Ext.CompositeElementLite();b.hours=new Ext.CompositeElementLite();b.selectAll=new Ext.CompositeElementLite();b.days.fill(Ext.query("td.syno-sds-bw2-schedule-day-td",b.el.dom));b.hours.fill(Ext.query("td.syno-sds-bw2-schedule-hour-td",b.el.dom));b.selectAll.fill(Ext.query("td.syno-sds-bw2-schedule-select-all-td",b.el.dom));Ext.each(b.days.elements,function(f,c,d){var e=Ext.fly(f);this.mon(e,"click",this.onDayClick,this,{index:c});this.mon(e,"mouseenter",this.onDayMouseEnter,this,{index:c});this.mon(e,"mouseleave",this.onDayMouseLeave,this,{index:c})},this);Ext.each(b.hours.elements,function(f,c,d){var e=Ext.fly(f);this.mon(e,"click",this.onHourClick,this,{index:c});this.mon(e,"mouseenter",this.onHourMouseEnter,this,{index:c});this.mon(e,"mouseleave",this.onHourMouseLeave,this,{index:c})},this);Ext.each(b.selectAll.elements,function(f,c,d){var e=Ext.fly(f);this.mon(e,"click",this.onSelectAllClick,this);this.mon(e,"mouseenter",this.onSelectAllMouseEnter,this);this.mon(e,"mouseleave",this.onSelectAllMouseLeave,this)},this)},beforedestroy:function(b){b.days.clear();b.hours.clear();b.selectAll.clear()}}});return a},createTemplate:function(){var c;var f=[];var e='<td class="syno-sds-bw2-schedule-hour-td">{0}</td>';f.push("<tr>");f.push('<td class="syno-sds-bw2-schedule-select-all-td"></td>');for(c=0;c<24;c++){f.push(String.format(e,c))}f.push("</tr>");var a=f.join("\n");f=[];var b='<td class="syno-sds-bw2-schedule-td"></td>';f.push('<tr class="syno-sds-bw2-schedule-tr">');f.push('<td class="syno-sds-bw2-schedule-day-td">{field1}</td>');for(c=0;c<24;c++){f.push(b)}f.push("</tr>");var g=f.join("\n");var d=new Ext.XTemplate('<table class="syno-sds-bw2-schedule-table">',a,'<tpl for=".">',g,"</tpl>","<table>");return d},onSpeedButtonClick:function(b,a){if(b.pressed||this.disableDataView){return}var c=b.ownerCt.get(this.getSpeed());c.toggle(false);b.toggle(true);this.currentSpeed=b.itemId},getIndexesByDay:function(a){var c=[],b,e=a*24;for(var d=0;d<24;d++){b=e+d;c.push(b)}return c},onDayClick:function(a,c,d){var b=this.getSpeed();if(!d||!Ext.isNumber(d.index)){return}Ext.each(this.getIndexesByDay(d.index),function(g,e,f){this.setClassToNodeByIndex(g,b)},this)},onDayMouseEnter:function(a,b,c){if(!c||!Ext.isNumber(c.index)){return}Ext.fly(b).addClass("syno-sds-bw2-schedule-day-td-over");this.dataView.select(this.getIndexesByDay(c.index))},onDayMouseLeave:function(a,b,c){Ext.fly(b).removeClass("syno-sds-bw2-schedule-day-td-over");this.dataView.clearSelections()},getIndexesByHour:function(a){var c=[],b;for(var d=0;d<7;d++){b=a+(d*24);c.push(b)}return c},onHourClick:function(a,c,d){var b=this.getSpeed();if(!d||!Ext.isNumber(d.index)){return}Ext.each(this.getIndexesByHour(d.index),function(g,e,f){this.setClassToNodeByIndex(g,b)},this)},onHourMouseEnter:function(a,b,c){if(!c||!Ext.isNumber(c.index)){return}Ext.fly(b).addClass("syno-sds-bw2-schedule-hour-td-over");this.dataView.select(this.getIndexesByHour(c.index))},onHourMouseLeave:function(a,b,c){Ext.fly(b).removeClass("syno-sds-bw2-schedule-hour-td-over");this.dataView.clearSelections()},onSelectAllClick:function(b,f,g){var c=[],e=this.getSpeed(),d,a;for(d=0,a=7*24;d<a;d++){c.push(d)}Ext.each(c,function(j,h,i){this.setClassToNodeByIndex(j,e)},this)},onSelectAllMouseEnter:function(a,b,c){Ext.fly(b).addClass("syno-sds-bw2-schedule-select-all-td-over")},onSelectAllMouseLeave:function(a,b,c){Ext.fly(b).removeClass("syno-sds-bw2-schedule-select-all-td-over")},getSpeed:function(){return this.currentSpeed},selectRecords:function(b,c){var f;var e=this.getSpeed();for(var d=0,a=c.length;d<a;d++){f=c[d];if(f.selected){this.setClassToNodeByIndex(d,e)}}b.clearSelections()},setSchedule:function(b){var a=b.split("");if(a.length!==this.dataView.getNodes().length){SYNO.Debug("error! schedule is not the same to element. array length:",a.length,", view size:",this.dataView.getNodes().length);return}Ext.each(a,function(e,c,d){this.setClassToNodeByIndex(c,e)},this)},getSchedule:function(){return this.currentSchedule.join("")},isScheEnabled:function(){return(Ext.getCmp(this.enable_check_id).getValue())},isValid:function(){var a=true;var b=this;if(!Ext.getCmp(b.date_id).validate()){a=false}return a},isDirty:function(){var a=true;return a},setClassToNodeByIndex:function(a,b){var c=Ext.fly(this.dataView.getNode(a));if(false===this.fireEvent("beforecellchange",this,a,b,this.currentSchedule[a])){return}c.removeClass(this.CLASS_LIST);c.addClass(this.CLASS_LIST[b]);this.currentSchedule[a]=b}});Ext.define("SYNO.SDS.StorageManager.ScheTargetPanel",{extend:"SYNO.ux.Panel",constructor:function(a){var c=this,b;b={title:_T("data_scrubbing","choose_target"),border:false,layout:"fit",items:[c.grid=c.createSpaceGrid()],listeners:{scope:this,activate:this.onActivate}};c.callParent([Ext.apply(b,a)])},createSpaceGrid:function(){var b=function(f,e){if(false===e.get("enabled")){return true}else{return false}};var c=function(i,h,e){var f=(true===e.get("enabled"))?"enabled":"disabled";var g=(true===i)?"checked":"unchecked";return SYNO.SDS.StorageManager.renderCheckBox.call(this,f,g,h,e)};var d=new SYNO.ux.EnableColumn({dataIndex:"isScheduled",id:"isScheduled",disableSelectAll:false,align:"center",isIgnore:b,renderer:c});var a=Ext.apply({enableHdMenu:false,enableColumnMove:false,cls:"without-dirty-red-grid",plugins:d,columns:[d,{header:_T("common","name"),dataIndex:"name",width:150},{header:_T("data_scrubbing","data_scrubbing_support"),dataIndex:"supportScrubbing",width:200},{header:_T("volume","volume_volumestatus"),dataIndex:"status",width:250}],store:new Ext.data.JsonStore({autoDestroy:true,fields:["id","enabled","name","supportScrubbing","space_path","status","isScheduled","scrubbingStatus"],idProperty:"id",root:"pools"})});return new SYNO.ux.GridPanel(a)},renderStatus:function(a,c,b){var d,f=a.get("scrubbingStatus"),e="";if(!a.supportDataScrubbing(c)){e="-"}else{if("abnormal"===f){e=_T("data_scrubbing","target_abnormal")}else{if("manual_paused"===f){e=_T("data_scrubbing","paused")}else{if(a.isScheduled()){if("done"===b.sche_status){d=(new Date(a.get("next_schedule_time")*1000)).format("Y-m-d");e=String.format(_T("data_scrubbing","schedule_on"),d)}else{if("wait_for_another_task"===f){e=_T("data_scrubbing","not_yet_processed")}else{if("paused"===f){e=_T("data_scrubbing","schedule_paused")}else{e=_T("data_scrubbing",f)}}}}else{e=_T("data_scrubbing",f)}}}}return e},getSpaces:function(){var f=this;var a=SYNO.SDS.StorageUtils;var e=f.appWin.storagePools.getAll();var d=f.appWin.env.data_scrubbing;f.spaceData={pools:[]};for(var c=0;c<e.length;++c){var g={},b=e[c];g.id=b.id;g.enabled=this.isEnabled(b);g.name=a.SpaceIDParser(b.id).str;g.isScheduled=b.isScheduled();g.supportScrubbing=b.supportDataScrubbing(f)?_T("common","yes"):_T("common","no");g.space_path=b.get("space_path");g.status=this.renderStatus(b,f,d);g.scrubbingStatus=b.get("scrubbingStatus");f.spaceData.pools.push(g)}f.spaceData.pools.sort(function(i,h){if(i.id>h.id){return 1}if(i.id<h.id){return -1}return 0})},isEnabled:function(b){var a=this;if(false===b.supportDataScrubbing(a)||"abnormal"===b.get("scrubbingStatus")||"manual_running"===b.get("scrubbingStatus")){return false}return true},hasSchePool:function(){var c=this,a=c.grid.getStore();for(var b=0;b<a.getCount();b++){if(true===a.getAt(b).get("isScheduled")){return true}}return false},showConfirm:function(){var d=this,a=d.grid.getStore();for(var c=0;c<a.getCount();c++){var b=d.spaceData.pools[c];var e=a.getAt(c);if(e.get("isScheduled")!==b.isScheduled){if(b.isScheduled&&("done"===b.scrubbingStatus||"paused"===b.scrubbingStatus||"pending"===b.scrubbingStatus||"schedule_running"===b.scrubbingStatus)){return true}}}return false},setMask:function(){var b=this;var a;var d;if(!b.body){return}if(!this.mask_text_id){this.mask_text_id=Ext.id()}a='<span class="link-font" id="'+this.mask_text_id+'">'+_T("data_scrubbing","time_session")+"</span>";d=String.format(_T("data_scrubbing","target_notification_when_disable_schedule"),a);if(!this.owner.isScheEnabled()){b.body.mask(d,"syno-ux-mask-info");b.grid.hide()}else{b.body.unmask();b.grid.show()}var c=Ext.get(this.mask_text_id);if(Ext.isObject(c)){c.on("click",this.onClickMask,this)}},onBeforeDestroy:function(a){var b=Ext.get(this.mask_text_id);if(Ext.isObject(b)){b.un("click",this.onClickMask,this)}},onClickMask:function(){var b=this.owner.tabPanel;var a=this.owner.schePlanPanel;b.setActiveTab(a)},onActivate:function(){var a=this;a.getSpaces();a.grid.getStore().loadData(a.spaceData,false);a.setMask()}});Ext.define("SYNO.SDS.StorageManager.SchedulePlanTab",{extend:"SYNO.SDS.Utils.TabPanel",constructor:function(a){var b;this.appWin=a.appWin;this.owner=a.owner;this.schePlanPanel=a.schePlanPanel;this.scheTargetPanel=a.scheTargetPanel;b={useDefaultBtn:false,appWin:this.appWin,owner:this.owner,itemId:"tabpanel",activeTab:0,items:[this.schePlanPanel,this.scheTargetPanel]};this.callParent([b]);this.scheTargetPanel.onActivate()}});Ext.define("SYNO.SDS.StorageManager.SchedulePlanWin",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){Ext.apply(this,a||{});this.scheduleConfig=a.scheduleConfig;this.schePlanPanel=new SYNO.SDS.StorageManager.SchePlanPanel(Ext.applyIf({owner:this},a));this.scheTargetPanel=new SYNO.SDS.StorageManager.ScheTargetPanel(Ext.applyIf({owner:this},a));this.tabPanel=new SYNO.SDS.StorageManager.SchedulePlanTab(Ext.applyIf({schePlanPanel:this.schePlanPanel,scheTargetPanel:this.scheTargetPanel,owner:this},a));var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var b={owner:a.owner,height:630,width:740,padding:"0 20px 0 20px",title:_T("schedule","schedule_title"),layout:"fit",resizable:false,buttonAlign:"left",items:this.tabPanel,buttons:[{xtype:"syno_button",btnStyle:"blue",id:this.confirm_id=Ext.id(),text:_T("common","apply"),scope:this,handler:this.okHandler},{xtype:"syno_button",text:_T("common","cancel"),scope:this,handler:function(){this.close()}}]};Ext.apply(b,a);return b},onOpen:function(){this.callParent(arguments);var a=this;a.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:"SYNO.Storage.CGI.Storage",method:"get_schedule_plan",version:1,params:{},callback:function(j,d,e,b){var i=a.appWin.storagePools.getAll();var h=a.appWin.env.data_scrubbing;var f=0;var c="";var k;var g;if(!j){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,d)}Ext.each(i,function(l){if(l.isScheduled()){f=1}if(l.isScheduled()&&"done"===h.sche_status){k=(new Date(l.get("next_schedule_time")*1000)).format("Y-m-d");c=String.format(_T("data_scrubbing","schedule_on"),k)}else{g=(new Date(l.get("next_schedule_time")*1000)).format("Y-m-d")}},a);a.schePlanPanel.setSchedule(d.schedule.schedule_plan);if(0!==d.schedule.start_time&&""!==d.schedule.interval){Ext.getCmp(a.schePlanPanel.date_id).setValue(new Date(d.schedule.start_time*1000));Ext.getCmp(a.schePlanPanel.date_id).originalValue=(new Date(d.schedule.start_time*1000));Ext.getCmp(a.schePlanPanel.repeat_id).setValue(d.schedule.interval);if(1===f){if(""===c){c=String.format(_T("data_scrubbing","running"),g)}Ext.getCmp(a.schePlanPanel.schedule_plan_status_id).setValue(c)}}if(1===d.schedule.schedule_enabled){Ext.getCmp(a.schePlanPanel.enable_check_id).setValue(true)}else{Ext.getCmp(a.schePlanPanel.enable_check_id).setValue(false);c=_T("data_scrubbing","schedule_disabled");Ext.getCmp(a.schePlanPanel.schedule_plan_status_id).setValue(c)}if("run_all_time"===d.schedule.run_time_option){Ext.getCmp(a.schePlanPanel.schedule_plan_default_id).setValue(true)}else{Ext.getCmp(a.schePlanPanel.schedule_plan_manual_id).setValue(true)}a.clearStatusBusy()},scope:a})},isScheEnabled:function(){return this.schePlanPanel.isScheEnabled()},getApiParams:function(){var g=this.schePlanPanel;var h=Ext.getCmp(g.date_id).getValue();var a=Ext.getCmp(g.repeat_id).getValue();var l=(true===Ext.getCmp(g.enable_check_id).getValue())?1:0;var n=(true===Ext.getCmp(g.schedule_plan_default_id).getValue())?"run_all_time":"run_setting_time";var k=this;var b=[];var d=[];var m=k.scheTargetPanel.grid.getStore();if(h){h=h.getTime()/1000}for(var f=0;f<m.getCount();f++){var e={},j=k.scheTargetPanel.spaceData.pools[f];var c=m.getAt(f);if(c.get("isScheduled")!==j.isScheduled){e.space_path=c.get("space_path");e.scheduled=(true===c.get("isScheduled"))?"1":"0";d.push(e)}}if(0!==d.length&&l){b=b.concat([{api:"SYNO.Storage.CGI.Storage",method:"set_data_scrubbing_schedule",version:1,params:{schedule_spaces:d}}])}b=b.concat([{api:"SYNO.Storage.CGI.Storage",method:"set_schedule_plan",version:1,params:{start_time:h,schedule_plan:g.getSchedule(),interval:a,scheEnabled:l,runTimeOption:n}}]);return b},okHandler:function(){var c=this.schePlanPanel;var i=this.scheTargetPanel;var g=this.isScheEnabled()?1:0;var f=this,e;var h=Ext.getCmp(c.date_id).isDirty()&&(""!==Ext.getCmp(f.schePlanPanel.date_id).originalValue);var d=i.showConfirm();if(h||0===g){e=_T("data_scrubbing","modify_schedule_start_time_confirm")}else{if(d){e=_T("data_scrubbing","set_schedule_confirm")}}var b=this.getApiParams();if(!c.isValid()){this.tabPanel.setActiveTab(c);this.setStatusError({text:_T("common","forminvalid"),clear:true})}else{if(1===g&&!i.hasSchePool()){this.tabPanel.setActiveTab(i);this.setStatusError({text:_T("data_scrubbing","no_target_confirm"),clear:true})}else{var a=function(){f.owner.stopPollTask();f.owner.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:"SYNO.Entry.Request",version:1,method:"request",compound:{stopwhenerror:true,mode:"sequential",params:b},callback:function(m,l,k,j){this.clearStatusBusy();if(!m){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,l)}this.setStatusBusy();this.cleanMask=true;this.startPollTask()},scope:f.owner})};if(h||0===g||d){f.appWin.getMsgBox().confirm(_T("tree","leaf_volume"),e,function(j){if("yes"===j){a();this.close()}},f)}else{a();this.close()}}}},onShow:function(){if(this.scheduleConfig.scheduleField!==""){this.schePlanPanel.setSchedule(this.scheduleConfig.scheduleField)}}});Ext.define("SYNO.SDS.StorageManager.Pool.Store",{extend:"Ext.data.JsonStore",constructor:function(a){var c=this,b;c.sortField="numId";c.sortDir="ASC";c.sortType="sort_numId";b={autoDestroy:true,idProperty:"id",fields:["numId","id","iconCls","statusIconCls","displayName","desc","usage","barWidth","summaryStatus","property","raidInfo","detailUsage","allocation","volumeInfo","illustrate","status","totalSize","freeSize","scrubbingProperty"],listeners:{load:function(){c.sort(c.sortField,c.sortDir)},scope:c}};c.callParent([Ext.apply(b,a)])}});Ext.define("SYNO.SDS.StorageManager.Pool.Main",{extend:"SYNO.SDS.Utils.TabPanel",constructor:function(a){var c,b,d;this.appWin=a.appWin;this.owner=a.appWin;this.poolPanel=new SYNO.SDS.StorageManager.Pool.PoolPanel({appWin:this.appWin,owner:this.owner});this.configPanel=new SYNO.SDS.StorageManager.Pool.ConfigPanel({appWin:this.appWin,owner:this.owner});d=("yes"===_D("support_btrfs","no"));if(2<this.appWin.getBayNumber()||(this.appWin.isSupportEbox()&&this.appWin.isEboxPluged())||d){this.scrubbingPanel=new SYNO.SDS.StorageManager.Pool.ScrubbingPanel({appWin:this.appWin,owner:this.owner});b=[this.poolPanel,this.scrubbingPanel,this.configPanel]}else{b=[this.poolPanel,this.configPanel]}c={useDefaultBtn:false,appWin:this.appWin,owner:this.owner,itemId:"storage_pool",activeTab:0,items:b,listeners:{activate:this.onActivate,scope:this}};this.callParent([c])},getHelpParam:function(){switch(this.getActiveTab().itemId){case"pool_panel":return"StorageManager/storage_pool.html";case"scrubbing_panel":return"StorageManager/storage_pool_data_scrubbing.html";case"config_panel":return"StorageManager/storage_pool_adjust_resync_speed.html";default:return"StorageManager/storage_pool.html"}},onActivate:function(){this.getComponent("pool_panel").onActivate();var a=this.getComponent("scrubbing_panel");if(a){this.getComponent("scrubbing_panel").onActivate()}},onPageActivate:function(){this.getComponent("config_panel").onActivate()},setFocus:function(b){var a=this.poolPanel;if(!b||!a||!a.view||!Ext.isFunction(a.view.setFocus)){return}this.setActiveTab(a);a.view.setFocus(b)}});Ext.define("SYNO.SDS.StorageManager.Pool.ConfigPanel",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(b){var c;var d=this;this.appWin=b.appWin;this.owner=b.owner;var a=[{xtype:"syno_fieldset",itemId:"speed_limit",title:_T("data_scrubbing","speed_limit"),items:[{xtype:"syno_radio",name:"speed_option",itemId:"speed_limit_slow",boxLabel:_T("data_scrubbing","speed_limit_slow"),value:false,inputValue:"resync_slower"},{xtype:"syno_radio",name:"speed_option",itemId:"speed_limit_fast",boxLabel:_T("data_scrubbing","speed_limit_fast"),value:false,inputValue:"resync_faster"},{xtype:"syno_radio",name:"speed_option",itemId:"speed_limit_manual",boxLabel:_T("data_scrubbing","manual"),value:false,inputValue:"resync_manual",listeners:{scope:this,check:function(f,e){if(e){this.getField("speed_max_comp").setDisabled(false);this.getField("speed_min_comp").setDisabled(false);this.getField("speed_max_comp").show();this.getField("speed_min_comp").show()}else{this.getField("speed_max_comp").hide();this.getField("speed_min_comp").hide();this.getField("speed_max_comp").setDisabled(true);this.getField("speed_min_comp").setDisabled(true)}}}},{xtype:"syno_compositefield",itemId:"speed_max_comp",hidden:true,hideLabel:true,items:[{xtype:"syno_displayfield",width:70,indent:1,value:_T("data_scrubbing","speed_limit_max")},{xtype:"syno_numberfield",name:"speed_max",itemId:"speed_max",indent:1,validator:function(){return d.speedChecker()},minValue:0},{xtype:"syno_displayfield",width:10,indent:1,value:""},{xtype:"syno_displayfield",indent:1,value:"MB/s"}]},{xtype:"syno_compositefield",itemId:"speed_min_comp",hidden:true,hideLabel:true,items:[{xtype:"syno_displayfield",width:70,indent:1,value:_T("data_scrubbing","speed_limit_min")},{xtype:"syno_numberfield",name:"speed_min",itemId:"speed_min",indent:1,validator:function(){return d.speedChecker()},minValue:0},{xtype:"syno_displayfield",width:10,indent:1,value:""},{xtype:"syno_displayfield",indent:1,value:"MB/s"}]},{xtype:"syno_displayfield",htmlEncode:false,value:'<span class="syno-ux-note">'+_T("common","note")+_T("common","colon")+" </span>"+_T("data_scrubbing","resync_speed_note")}]}];c={title:_T("volume","configuration"),items:a,useDefaultBtn:true,itemId:"config_panel"};this.callParent([Ext.apply(c,b)])},getField:function(a){return this.getForm().findField(a)},speedChecker:function(){if(this.getField("speed_min").getValue()>=this.getField("speed_max").getValue()){return _T("data_scrubbing","resync_speed_setting_warning")}else{if(10000<this.getField("speed_min").getValue()||10000<this.getField("speed_max").getValue()){return _T("data_scrubbing","resync_speed_range_warning")}}return true},onActivate:function(){this.owner.setStatusBusy();SYNO.API.Request({webapi:{api:"SYNO.Storage.CGI.Storage",method:"get_resync_speed",version:"1",params:{}},callback:function(d,b,c,a){this.owner.clearStatusBusy();if(!d){this.owner.getMsgBox().alert(this.title,_T("common","commfail"));return}this.getForm().setValues({speed_option:b.speed_option,speed_max:b.speed_max,speed_min:b.speed_min})},scope:this})},getParams:function(){var a=this.getForm().getValues().speed_option;var b={speed_option:a};if(a==="resync_manual"){b.speed_max=this.getField("speed_max").getValue();b.speed_min=this.getField("speed_min").getValue()}return b},applyForm:function(){if(!this.getForm().isValid()){this.setStatusError({text:_T("common","forminvalid"),clear:true})}else{if(!this.getForm().isDirty()){this.setStatusError({text:_T("error","nochange_subject"),clear:true})}else{this.owner.setStatusBusy();SYNO.API.Request({webapi:{api:"SYNO.Storage.CGI.Storage",method:"set_resync_speed",version:"1",params:this.getParams()},callback:function(d,a,c,b){this.owner.clearStatusBusy();if(!d){this.owner.getMsgBox().alert(this.title,_T("common","commfail"));return}this.onActivate()},scope:this})}}}});Ext.define("SYNO.SDS.StorageManager.Pool.ScrubbingPanel",{extend:"SYNO.ux.Panel",constructor:function(a){var d=this,c,b,e;d.view=undefined;d.appWin=a.appWin;d.owner=a.owner;d.sortType="sort_numId";d.createView();b={xtype:"syno_button",itemId:"manual",text:_T("common","action"),menu:[{itemId:"start",text:_T("data_scrubbing","manual_start"),handler:d.onStart,scope:d},{itemId:"pause",text:_T("common","pause"),handler:d.onPause,scope:d},{itemId:"cancel",text:_T("common","cancel"),handler:d.onCancel,scope:d}]};e={xtype:"syno_button",itemId:"schedule",btnStyle:"blue",text:_T("data_scrubbing","schedule"),menu:[{itemId:"set",text:_T("data_scrubbing","set_up_schedule"),handler:d.onSetSchedule,scope:d},{itemId:"setScheduleStatus",text:_T("data_scrubbing","pause_schedule"),handler:d.onSetScheduleStatus,scope:d}]};c={title:_T("volume","data_scrubbing_page_title"),border:false,layout:"fit",itemId:"scrubbing_panel",tbar:{defaultType:"syno_button",items:[{itemId:"set",text:_T("data_scrubbing","set_schedule"),btnStyle:"blue",handler:d.onSetSchedule,scope:d},{xtype:"panel",hideBorders:true,border:false,html:'<div class="separator-wrapper"><div class="separator"></div></div>'},b]},items:d.view,listeners:{activate:d.onActivate,scope:d}};d.callParent([Ext.apply(c,a)])},createView:function(){var e=this,d=SYNO.SDS.StorageManager.ScrubbingPropertyTpl(),a=SYNO.SDS.StorageManager.VolumeListTpl({scope:"volumes",emptyText:_T("volume","volume_status_none")}),c,b;c=new Ext.XTemplate('<div class="item-detail-inner">',d.html,'<tpl if="this.hasValues(volumeInfo) == true">','<tpl for="volumeInfo">',a.html,"</tpl>","</tpl>","</div>");b={appWin:e.appWin,owner:e,dataType:"storagePools",itemId:"scrbbingpoolView",multiSelect:false,singleSelect:true,detailTpl:c,store:new SYNO.SDS.StorageManager.Pool.Store(),listeners:{selectionchange:e.onSelectChange,scope:e}};e.view=new SYNO.SDS.StorageManager.DataView(b)},getAPI:function(b){var d=b.get("deploy_path");var e="single"===b.get("raidType");var a,f;var c="";a=d?(-1<d.indexOf("volume")):false;f=d?(-1<d.indexOf("iscsilun")):false;if(e&&a){c="SYNO.Storage.CGI.Volume"}else{if(e&&f){c="SYNO.Core.Storage.iSCSILUN"}else{c="SYNO.Storage.CGI.Pool"}}return c},resetBtnStatus:function(){var a=this;var c=this.getButton("manual").menu;var b=this.getButton("schedule");a.enableButton(c.getComponent("start"),false);a.enableButton(c.getComponent("pause"),false);a.enableButton(c.getComponent("cancel"),false);a.enableButton(b,false)},setMask:function(){var a=this,b=_T("volume","volume_raid_group"),c=String.format(_T("volume","volume_no_storage_pool"),b);if(a.isVisible()&&0===a.view.getStore().getCount()){a.body.mask(c,"syno-ux-mask-info")}if(0<a.view.getStore().getCount()){a.body.unmask()}},canDoScrubbing:function(a){var b=this,c=false;if(!a){return false}if(a.get("can_do")&&"data_scrubbing" in a.get("can_do")){return true}Ext.each(b.appWin.volumes.getAll(),function(d){if(a.get("id")===d.get("pool_path")){if("btrfs"===d.get("fs_type")){c=true;return false}}},b);return c},canStart:function(a){var c=this,d=a.get("scrubbingStatus"),b=a.getProgressStep();if(!a||a.isCrashed()||a.isDegrade()||"none"!==b||"manual_paused"===d){return false}if(c.canDoScrubbing(a)&&"processing"!==d){return true}return false},canResume:function(a){var c=this,d=a.get("scrubbingStatus"),b=a.getProgressStep();if(!a||a.isCrashed()||a.isDegrade()||"none"!==b){return false}if(c.canDoScrubbing(a)&&"manual_paused"===d){return true}return false},canPause:function(a){var b,c=a.get("scrubbingStatus");if(!a){return false}b=a.getProgressStep();if("data_scrubbing"===b&&"manual_running"===c){return true}return false},canCancel:function(a){var b;if(!a){return false}b=a.getProgressStep();if("data_scrubbing"===b&&"manual_running"===a.get("scrubbingStatus")){return true}return false},canSet:function(a){var c=this,b;if(!a){return false}b=a.getProgressStep();if("data_scrubbing"===b||"paused"===a.get("scrubbingStatus")){return false}if(a.isScheduled()){return true}if(!a.isCrashed()&&!a.isDegrade()&&c.canDoScrubbing(a)){return true}return false},canSetScheduleStatus:function(){var d=this,f,e,a=false;var c=d.appWin.storagePools.getAll();var b=d.appWin.env.data_scrubbing;Ext.each(c,function(g){if(g.isScheduled()){a=true}},d);f=("done"===b.sche_status)?true:false;e=("1"===b.sche_enabled)?true:false;return(a&&!f&&e)},prepareUiData:function(){var b=this,a=b.appWin.storagePools.getAll(),c;delete b.uiData;b.uiData=[];Ext.each(a,function(d){c={};b.prepareSummary(d,c);b.prepareProperty(d,c);b.prepareVolumeInfo(d,c);b.uiData.push(c)},b)},prepareSummary:function(e,c){var g=this.appWin.env.data_scrubbing;var j,h,f=this,k=SYNO.SDS.StorageUtils,l,i,b,m,a,d;b=e.get("scrubbingStatus");a=new Date(e.get("last_done_time")*1000);j=k.SpaceIDParser(e.get("id"));d=e.supportDataScrubbing(f);if(e.usedByGlusterFs()){l=parseInt(e.get("glusterUsedSize"),10);i=parseInt(e.get("glusterTotalSize"),10);h=String.format("{0} ({1})",j.str,_T("volume","cluster_storage_unit"));c.iconCls="sm-list-icon-cluster-storage-unit"}else{l=parseInt(e.get("size").used,10);i=parseInt(e.get("size").total,10);h=j.str;c.iconCls="sm-list-icon-storage-pool"}c.numId=e.get("num_id");c.status=e.get("status");c.totalSize=i;c.freeSize=i-l;c.id=e.get("id");c.displayName=h;c.desc=e.get("desc");c.usage=String.format('<span style="color:#0086E5">{0}</span>&nbsp;/&nbsp;{1}',k.SizeRender(l),k.SizeRender(i));c.barWidth=(0===i)?0:200*l/i;if(e.isScheduled()&&"1"===g.sche_enabled){if("manual_running"===b){c.summaryStatus=String.format("&nbsp;-&nbsp;{0}",k.StatusNameRender(b))}else{if("manual_paused"===b){c.summaryStatus=String.format("&nbsp;-&nbsp;{0}",k.StatusNameRender("paused"))}else{if("paused"===g.sche_status){c.summaryStatus=String.format("&nbsp;-&nbsp;{0}",k.StatusNameRender("schedule_paused"))}else{if("done"===g.sche_status){m=new Date(e.get("next_schedule_time")*1000);c.summaryStatus=String.format("&nbsp;-&nbsp;{0}",String.format(k.StatusNameRender("schedule_on"),m.format("Y-m-d")))}else{c.summaryStatus=String.format("&nbsp;-&nbsp;{0}",k.StatusNameRender(b))}}}}}else{if("abnormal"===b){c.summaryStatus=String.format("&nbsp;-&nbsp;{0}",k.StatusNameRender(b))}else{if(false===d){c.summaryStatus=String.format("&nbsp;-&nbsp;{0}",k.StatusNameRender("not_support_scrubbing"))}else{if("no_action"===b&&0!==e.get("last_done_time")){c.summaryStatus=String.format("&nbsp;-&nbsp;{0}",String.format(k.StatusNameRender("last_run_on"),a.format("Y-m-d")))}else{if("manual_paused"===b){c.summaryStatus=String.format("&nbsp;-&nbsp;{0}",k.StatusNameRender("paused"))}else{c.summaryStatus=String.format("&nbsp;-&nbsp;{0}",k.StatusNameRender(b))}}}}}if("crashed"===e.get("status")||"degrade"===e.get("status")){c.statusIconCls="sm-list-status-icon-crashed"}else{if(e.isScheduled()&&"1"===g.sche_enabled){c.statusIconCls="sm-list-status-icon-scheduled"}}},prepareProperty:function(f,d){var g=this;var h,e;var k=SYNO.SDS.StorageUtils;var i=this.appWin.env.data_scrubbing;var c;var l;var a=new Date(f.get("last_done_time")*1000);var j;var b=f.get("scrubbingStatus");h=f.supportRaidScrubbing();e=f.supportDataScrubbing(g);if(f.isScheduled()&&"1"===i.sche_enabled){if("manual_running"===b){c=k.StatusRender("manual_running",f.get("progress"))}else{if("manual_paused"===b){c=k.StatusRender("paused",f.get("progress"))}else{if("paused"===i.sche_status){c=k.StatusRender("schedule_paused",f.get("progress"))}else{if("done"===i.sche_status){l=new Date(f.get("next_schedule_time")*1000);c=String.format(k.StatusRender("schedule_on",f.get("progress")),l.format("Y-m-d"))}else{c=k.StatusRender(b,f.get("progress"))}}}}}else{if("abnormal"===b){c=k.StatusRender(b,f.get("progress"))}else{if(false===e){c="-"}else{if("manual_paused"===b){c=k.StatusRender("paused",f.get("progress"))}else{c=k.StatusRender(b,f.get("progress"))}}}}d.scrubbingProperty=[{name:_T("volume","volume_raid_title"),value:k.SpaceTypeRender(f.get("device_type"))}];d.scrubbingProperty.push({name:_T("data_scrubbing","data_scrubbing_support"),value:e?_T("common","yes"):_T("common","no")});d.scrubbingProperty.push({name:_T("data_scrubbing","raid_scrubbing_support"),value:h?_T("common","yes"):_T("common","no")});d.scrubbingProperty.push({name:_T("volume","volume_volumestatus"),value:c});if(!e||0===f.get("last_done_time")){j=_T("data_scrubbing","never")}else{j=a.format("Y-m-d")}d.scrubbingProperty.push({name:_T("data_scrubbing","last_run"),value:j})},prepareVolumeInfo:function(d,g){var e=this,a,f,c,b=SYNO.SDS.StorageUtils;g.volumeInfo=[];f=[];Ext.each(e.appWin.volumes.getAll(),function(h){if(d.get("id")===h.get("pool_path")){if(h.get("fs_type")){a="volume_add_fs_"+h.get("fs_type")+"_type"}c=parseInt(h.get("size").total,10);f.push({name:b.SpaceIDParser(h.get("id")).str,fileSystem:_T("volume",a),capacity:b.SizeRender(c),supportScrubbing:("btrfs"===h.get("fs_type"))?_T("common","yes"):_T("common","no")})}},e);g.volumeInfo.push({volumes:f})},onActivate:function(){var c=this,a=c.view.store;var b=this.getButton("schedule");c.prepareUiData();a.suspendEvents(true);a.loadData(c.uiData,false);a.resumeEvents();c.resetBtnStatus();if(0<c.view.store.getCount()&&0===c.view.getSelectedItemIds().length){c.view.select(0,true,true)}c.onSelectChange();c.enableButton(b,c.canSetScheduleStatus());c.setMask()},onSelectChange:function(){var b=this,a=b.view.getSelectedItem();if(!a){return}var c=this.getButton("manual").menu;b.enableButton(c.getComponent("start"),b.canStart(a));b.enableButton(c.getComponent("cancel"),b.canCancel(a));if(!b.canCancel(a)&&a.isScheduled()){c.getComponent("cancel").hide()}else{c.getComponent("cancel").show()}if(this.isSchedulePaused()){c.getComponent("pause").setText(_T("data_scrubbing","resume_schedule"));c.getComponent("pause").setHandler(b.onSetScheduleStatus,b);b.enableButton(c.getComponent("pause"),b.canSetScheduleStatus())}else{c.getComponent("pause").setText(_T("data_scrubbing","pause_schedule"));c.getComponent("pause").setHandler(b.onSetScheduleStatus,b);b.enableButton(c.getComponent("pause"),b.canSetScheduleStatus())}if("manual_paused"===a.get("scrubbingStatus")){c.getComponent("pause").setText(_T("common","resume"));c.getComponent("pause").setHandler(b.onStart,b);b.enableButton(c.getComponent("pause"),b.canResume(a))}else{if(!a.isScheduled()||"manual_running"===a.get("scrubbingStatus")){c.getComponent("pause").setText(_T("common","pause"));c.getComponent("pause").setHandler(b.onPause,b);b.enableButton(c.getComponent("pause"),b.canPause(a))}}},onStart:function(){var b=this,a=b.view.getSelectedItem();if(SYNO.SDS.StorageUtils.IsBlockedInSDR(b.owner)){return}if(!a){return}b.openWizard("ManagePool",{add_type:"data_scrubbing",pool:a})},onPause:function(){var b=this,a=b.view.getSelectedItem(),c;if(SYNO.SDS.StorageUtils.IsBlockedInSDR(b.owner)){return}if(!a){return}c=a.get("id");b.appWin.stopPollTask();b.owner.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:this.getAPI(a),method:"pause_data_scrubbing",version:1,params:{space_id:c},callback:function(g,f,e,d){this.clearStatusBusy();if(!g){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,f)}this.setStatusBusy();this.cleanMask=true;this.startPollTask()},scope:this.owner})},onCancel:function(){var c=this,a=c.view.getSelectedItem(),e,d;if(SYNO.SDS.StorageUtils.IsBlockedInSDR(c.owner)){return}if(!a){return}e=a.get("id");d=String.format('<font class="red-status">{0}</font><br/>',_T("data_scrubbing","skip_space_confirm"));var b=function(){c.owner.stopPollTask();c.owner.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:c.getAPI(a),method:"cancel_data_scrubbing",version:1,params:{space_id:e},callback:function(i,h,g,f){this.clearStatusBusy();if(!i){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,h)}this.setStatusBusy();this.cleanMask=true;this.startPollTask()},scope:c.owner})};if(a.isScheduled()){c.appWin.getMsgBox().confirm(_T("tree","leaf_volume"),d,function(f){if("yes"===f){b()}},c)}else{b()}},isSchedulePaused:function(){var b=this,a=b.appWin.env.data_scrubbing,c;c=("paused"===a.sche_status)?true:false;return c},onSetScheduleStatus:function(){var a=this,b;if(this.isSchedulePaused()){b="0"}else{b="1"}a.appWin.stopPollTask();a.owner.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({webapi:{api:"SYNO.Storage.CGI.Storage",method:"set_data_scrubbing_schedule_status",version:"1",params:{schedule_status:b}},callback:function(f,e,d,c){this.clearStatusBusy();if(!f){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,e)}this.setStatusBusy();this.cleanMask=true;this.startPollTask()},scope:this.owner})},onSetSchedule:function(){var c=this;var b={scheduleField:"111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111"};var a=new SYNO.SDS.StorageManager.SchedulePlanWin({appWin:c.appWin,owner:c.findWindow(),scheduleConfig:b});a.open()},openDialog:function(d,b,a){var e;if(this.owner.isUpToBatchTaskCount()){e=_T("volume","volume_max_batch_task_count").replace("_MAX_TASK_",this.owner.getMaxBatchTaskCount());this.owner.getMsgBox().alert(this.title,e,function(){},this);return}var c=new SYNO.SDS.StorageManager.Pool.Dialog[d](Ext.apply({owner:this.owner},b));this.owner.updater.stop();c.mon(c,"close",function(){if(Ext.isFunction(c.hideFromOwner)){c.hideFromOwner()}if(c.isDataChanged){this.owner.setStatusBusy();this.owner.cleanMask=true}this.owner.updater.start()},this,{single:true});c.open(a)},openWizard:function(b,a){var c=this,e;if(c.appWin.isUpToBatchTaskCount()){e=_T("volume","volume_max_batch_task_count").replace("_MAX_TASK_",c.appWin.getMaxBatchTaskCount());c.appWin.getMsgBox().alert(c.title,e,function(){},c);return}var d=new SYNO.SDS.StorageManager.Wizard[b](Ext.apply({appWin:c.appWin,owner:c.owner},a));c.appWin.stopPollTask();c.mon(d,"close",function(){if(Ext.isFunction(d.hideFromOwner)){d.hideFromOwner()}if(d.isDataChanged){c.owner.setStatusBusy();c.body.unmask();c.owner.cleanMask=true}c.appWin.startPollTask()},c,{single:true});d.open()},getButton:function(a){return this.getTopToolbar().getComponent(a)},enableButton:function(b,a){if(!b){return false}return a?b.enable():b.disable()}});Ext.define("SYNO.SDS.StorageManager.Pool.PoolPanel",{extend:"SYNO.ux.Panel",constructor:function(b){var d=this,a,c;d.view=undefined;d.appWin=b.appWin;d.owner=b.owner;d.sortType="sort_numId";d.createView();a={xtype:"syno_button",itemId:"manage",text:_T("common","action"),menu:[{itemId:"repair",text:_T("volume","volume_adddisk2_type_repair"),handler:d.onRepair,scope:d},{itemId:"addDisks",text:_T("volume","volume_adddisk"),handler:d.onAddDisks,scope:d},{itemId:"expand",text:_T("volume","volume_adddisk2_type_expand"),handler:d.onExpand,scope:d},{itemId:"migrate",text:_T("volume","volume_adddisk2_type_migrate"),handler:d.onMigrate,scope:d},{itemId:"convert_shr",text:_T("volume","volume_convert_shr_raidgroup_to_pool"),handler:d.onConvertSHR,scope:d},{itemId:"complete_shr",text:_T("volume","continue_unfinished_shr"),handler:d.onCompleteSHR,scope:d},{itemId:"edit",text:_T("volume","change_settings"),handler:d.onEdit,scope:d}]};c={title:_T("volume","volume_raid_group"),border:false,layout:"fit",itemId:"pool_panel",tbar:{defaultType:"syno_button",items:[{itemId:"create",text:_T("common","create"),handler:d.onCreate,scope:d},{itemId:"remove",text:_T("common","remove"),handler:d.onDelete,scope:d},a,{itemId:"cancel",text:_T("common","cancel"),handler:d.onCancel,scope:d},"->",new SYNO.SDS.StorageManager.SortButton({appWin:d.appWin,owner:d,menuItems:[{text:_T("volume","volume_sort_by_id"),itemId:"sort_numId",handler:d.onSort,scope:d},{text:_T("volume","volume_sort_by_status"),itemId:"sort_status",handler:d.onSort,scope:d},{text:_T("volume","volume_sort_by_available"),itemId:"sort_freeSize",handler:d.onSort,scope:d},{text:_T("volume","volume_sort_by_capacity"),itemId:"sort_totalSize",handler:d.onSort,scope:d}]})]},items:d.view,listeners:{activate:d.onActivate,afterlayout:function(){d.setMask()},scope:d}};d.callParent([Ext.apply(c,b)])},createView:function(){var h=this,g=SYNO.SDS.StorageManager.UsageTpl(),d=SYNO.SDS.StorageManager.PropertyTpl(),b=SYNO.SDS.StorageManager.DiskListTpl({scope:"disks",emptyText:_T("volume","volume_status_none")}),c=SYNO.SDS.StorageManager.DiskListTpl({scope:"spares",title:_T("volume","volume_suitable_spare_disks"),emptyText:_T("volume","volume_no_suitable_spare_disks")}),i=SYNO.SDS.StorageManager.AllocationListTpl({scope:"allocation"}),a=SYNO.SDS.StorageManager.DetailUsageTpl(),f,e;f=new Ext.XTemplate('<div class="item-detail-inner">',d.html,'<tpl if="this.hasValues(raidInfo) == true">','<tpl for="raidInfo">',b.html,(h.appWin.supportHotSpare)?c.html:"","</tpl>","</tpl>",i.html,'<tpl if="detailUsage">',a.html,"</tpl>","</div>");e={appWin:h.appWin,owner:h,dataType:"storagePools",itemId:"poolView",multiSelect:false,singleSelect:true,usageTpl:g,detailTpl:f,store:new SYNO.SDS.StorageManager.Pool.Store(),listeners:{selectionchange:h.onSelectChange,scope:h}};h.view=new SYNO.SDS.StorageManager.DataView(e)},getAPI:function(b){var d=b.get("deploy_path");var e="single"===b.get("raidType");var a,f;var c="";a=d?(-1<d.indexOf("volume")):false;f=d?(-1<d.indexOf("iscsilun")):false;if(e&&a){c="SYNO.Storage.CGI.Volume"}else{if(e&&f){c="SYNO.Core.Storage.iSCSILUN"}else{c="SYNO.Storage.CGI.Pool"}}return c},resetBtnStatus:function(){var a=this;a.getButton("remove").hide();a.getButton("manage").hide();a.getButton("cancel").hide();a.enableButton("create",a.canCreate());this.disablePanelFunctionBySystemDR()},setMask:function(){var a=this,b=_T("volume","volume_raid_group"),c=String.format(_T("volume","volume_no_storage_pool"),b);if(a.isVisible()&&0===a.view.getStore().getCount()){a.body.mask(c,"syno-ux-mask-info");a.getButton("sort").disable()}if(0<a.view.getStore().getCount()){a.body.unmask();a.getButton("sort").enable()}this.disablePanelFunctionBySystemDR()},canCreate:function(){var b=this;var a;if(this.appWin.isSingleBay()){a=b.appWin.disks.getMatched("isNormalTray","isFree","isInEbox")}else{a=b.appWin.disks.getMatched("isNormalTray","isFree")}if(0<a.length){return true}return false},canDelete:function(a){if(!a){return false}if(a.isActioning()){return false}if(!a.get("can_do")["delete"]){return false}return true},canManage:function(c){var d=this;var a,b;var e=this.getButton("manage").menu;if(!c){return false}if(c.isActioning()){return false}if(c.isCrashed()){return false}a=d.getAvailableDisksForAdd(c);if(!c.isSHR()){b=d.getValidAddTypeRaidGroup(c,a)}else{b=d.getValidAddType(c,a)}e.getComponent("repair").disable();e.getComponent("expand").disable();e.getComponent("addDisks").disable();e.getComponent("migrate").disable();e.getComponent("convert_shr").disable();e.getComponent("complete_shr").disable();e.getComponent("expand").hide();e.getComponent("convert_shr").hide();e.getComponent("complete_shr").hide();if(b.repair){e.getComponent("repair").enable();return true}if(b.expand_unfinished_shr&&d.canCompleteSHR(c)){e.getComponent("complete_shr").show();e.getComponent("complete_shr").enable();return true}if(b.expand_with_unalloc_size){e.getComponent("expand").show();e.getComponent("expand").enable();return true}if(b.expand_by_disk&&d.canExpand(c)){e.getComponent("addDisks").enable()}if(b.migrate&&d.canMigrate(c)){e.getComponent("migrate").enable()}if(c.isSHR()&&!c.supportMultiple()){e.getComponent("convert_shr").show()}if(b.convert_shr_to_pool&&d.canConvertSHR(c)){e.getComponent("convert_shr").enable()}return true},canMigrate:function(a){if(a.isActioning()){return false}return this.checkDiskCountLimit(a)},canExpand:function(b){var a=b.get("device_type");if(b.isActioning()){return false}if(b.supportMultiple()){switch(a){case"raid_5":case"raid_6":case"raid_f1":return true;default:break}}return this.checkDiskCountLimit(b)},canConvertSHR:function(a){if(a.isActioning()){return false}if(!a.isSHR()){return false}return this.checkDiskCountLimit(a)},canCompleteSHR:function(a){if(a.isActioning()){return false}if(!a.isSHR()){return false}return this.checkDiskCountLimit(a)},canCancel:function(a){var b;b=a.getProgressStep();if(a.isCreating()){if(b==="mk_filesystem"||b==="raid_syncing"||b==="raid_parity_checking"||b==="disk_check"||b==="waiting"){return true}}return false},checkDiskCountLimit:function(a){if(this.appWin.supportRaidGroup&&a.get("limited_disk_number")<=a.get("disks").length){return false}return true},prepareUiData:function(){var b=this,a=b.appWin.storagePools.getAll(),c;delete b.uiData;b.uiData=[];Ext.each(a,function(f){var e=0,d=0;c={};if(f.usedByGlusterFs()){Ext.each(b.appWin.volumes.getAll(),function(g){if(f.get("id")===g.get("pool_path")){e+=parseInt(g.get("size").total,10);d+=parseInt(g.get("size").used,10)}},b);f.json.glusterTotalSize=e;f.json.glusterUsedSize=d}b.prepareSummary(f,c);b.prepareProperty(f,c);if(f.isSHR()){this.prepareRaidInfo(f,c)}else{this.prepareRaidGroupInfo(f,c)}b.prepareAllocation(f,c);if(f.notUsedByGlusterFs()){b.prepareDetail(f,c)}b.uiData.push(c)},b)},prepareSummary:function(e,f){var g,d,c=SYNO.SDS.StorageUtils,b,a;g=c.SpaceIDParser(e.get("id"));if(e.usedByGlusterFs()){b=parseInt(e.get("glusterUsedSize"),10);a=parseInt(e.get("glusterTotalSize"),10);d=String.format("{0} ({1})",g.str,_T("volume","cluster_storage_unit"));f.iconCls="sm-list-icon-cluster-storage-unit"}else{b=parseInt(e.get("size").used,10);a=parseInt(e.get("size").total,10);d=g.str;f.iconCls="sm-list-icon-storage-pool"}f.numId=e.get("num_id");f.status=e.get("status");f.totalSize=a;f.freeSize=a-b;f.id=e.get("id");f.displayName=d;f.desc=e.get("desc");f.usage=String.format('<span style="color:#0086E5">{0}</span>&nbsp;/&nbsp;{1}',c.SizeRender(b),c.SizeRender(a));f.barWidth=(0===a)?0:200*b/a;f.summaryStatus=String.format("&nbsp;-&nbsp;{0}",c.StatusNameRender(e.get("status")));if(e.get("is_actioning")){f.statusIconCls="sm-list-status-icon-acting"}else{if("crashed"===e.get("status")||"degrade"===e.get("status")){f.statusIconCls="sm-list-status-icon-crashed"}}},prepareProperty:function(e,d){var f=this;var i,g,c;var h=SYNO.SDS.StorageUtils;var b=h.StatusRender(e.get("status"),e.get("progress"));var a=h.WarningTextRender(e.get("status"),h.SpaceIDParser(e.get("id")).str);d.property=[{name:_T("volume","volume_raid_title"),value:h.SpaceTypeRender(e.get("device_type"))}];f.renderSuggestions(e,d);d.property.push({name:_T("volume","volume_multiple_vol_lun_support"),value:e.supportMultiple()?_T("common","yes"):_T("common","no")});if(f.appWin.supportRaidGroup){c=e.get("device_type");switch(c){case"basic":case"raid_1":case"shr_without_disk_protect":case"shr_with_1_disk_protect":case"shr_with_2_disk_protect":break;default:d.property.push({name:_T("volume","limit_raid_disk_number"),value:e.get("limited_disk_number")});break}}d.property.push({name:_T("volume","volume_volumestatus"),value:b+a});if(e.usedByGlusterFs()){i=parseInt(e.get("glusterUsedSize"),10);g=parseInt(e.get("glusterTotalSize"),10);d.property.push({name:_T("volume","volume_totalsize"),value:h.SizeRender(parseInt(e.get("size").total,10))});d.property.push({name:_T("volume","volume_usablesize"),value:h.SizeRender(g)});d.property.push({name:_T("volume","volume_usedsize"),value:h.SizeRender(i)});d.property.push({name:_T("volume","volume_freesize"),value:h.SizeRender(g-i)})}else{i=parseInt(e.get("size").used,10);g=parseInt(e.get("size").total,10);d.property.push({name:_T("volume","volume_totalsize"),value:h.SizeRender(g)});d.property.push({name:_T("volume","volume_usedsize"),value:h.SizeRender(i)});d.property.push({name:_T("volume","volume_freesize"),value:h.SizeRender(g-i)})}if(e.get("disk_failure_number")>0&&e.get("status")==="degrade"){d.property.push({name:_T("volume","volume_disk_number_to_be_repaired"),value:'<span class="red-status">'+e.get("disk_failure_number")+"</span>"})}},prepareRaidGroupInfo:function(k,f){var l=this,m=l.appWin.disks.data,a=l.appWin.hotSpares.data,o=SYNO.SDS.StorageUtils,n=k.get("raids"),b={1:"normal",2:"degrade",4:"crashed"},h,d,r,j,e,q=false;var p=SYNO.SDS.StorageUtils.DiskSort;f.raidInfo=[];n.sort(function(v,t){var x=v.raidPath;var w=t.raidPath;var s=x.substr(7,x.length-7);var y=w.substr(7,w.length-7);var u=v.designedDiskCount;var i=t.designedDiskCount;if(u>i){return -1}else{if(u<i){return 1}}s=parseInt(s,10);y=parseInt(y,10);if(s>y){return 1}if(s<y){return -1}return 0});var g=function(i){var s=m[i.id];if(!s){return true}if(s.is4Kn()){q=true}r.push({container:("internal"===s.get("container").type)?_S("hostname"):s.get("container").str,name:SYNO.SDS.StorageUtils.DiskDisplayNameGet(s),ctnOrder:s.get("container").order,numId:s.get("num_id"),size:o.SizeRender(s.get("size_total")),driveType:s.get("isSsd")?"SSD":"HDD",status:o.DiskStatusRender(s.get("status")),portType:s.get("portType"),overviewStatus:o.DiskOverviewStatusRender(s.get("overview_status"))})};var c=function(s){var t=m[s.id];var i=a[s.id];if(!t||!i){return true}if(t.is4Kn()!==q){return true}j.push({container:"internal"===t.get("container").type?_S("hostname"):t.get("container").str,name:SYNO.SDS.StorageUtils.DiskDisplayNameGet(t),ctnOrder:t.get("container").order,numId:t.get("num_id"),size:o.SizeRender(t.get("size_total")),driveType:t.get("isSsd")?"SSD":"HDD",status:o.SpareStatusRender(i.get("status").type),portType:t.get("portType")})};for(e=0;e<n.length;++e){h=n[e];if(1===n.length){d=""}else{d=b[h.raidStatus]||"";d=String.format("({0})",o.StatusNameRender(d))}r=[];Ext.each(h.devices,g,l);r.sort(p);j=[];Ext.each(h.spares,c,l);j.sort(p);f.raidInfo.push({disks:r,spares:j,status:d})}},prepareRaidInfo:function(c,b){var d=this,e=d.appWin.disks.data,j=d.appWin.hotSpares.data,i,a,f=SYNO.SDS.StorageUtils,h=[],g=false;b.raidInfo=[];i=[];Ext.each(c.get("disks"),function(k){a=e[k];if(!a){return true}if(a.is4Kn()){g=true}i.push({container:"internal"===a.get("container").type?_S("hostname"):a.get("container").str,name:SYNO.SDS.StorageUtils.DiskDisplayNameGet(a),size:f.SizeRender(a.get("size_total")),driveType:a.get("isSsd")?"SSD":"HDD",status:f.DiskStatusRender(a.get("status")),ctnOrder:a.get("container").order,numId:a.get("num_id"),portType:a.get("portType"),overviewStatus:f.DiskOverviewStatusRender(a.get("overview_status"))})});i.sort(SYNO.SDS.StorageUtils.DiskSort);Ext.each(c.get("spares"),function(k){a=e[k.id];k=j[k.id];if(!a||!k){return true}if(a.is4Kn()!==g){return true}h.push({container:"internal"===a.get("container").type?_S("hostname"):a.get("container").str,name:SYNO.SDS.StorageUtils.DiskDisplayNameGet(a),size:f.SizeRender(a.get("size_total")),driveType:a.get("isSsd")?"SSD":"HDD",status:f.SpareStatusRender(k.get("status").type)})});b.raidInfo.push({disks:i,spares:h})},prepareAllocation:function(b,e){var c=this;var g=[];var a=[];var d=function(i){var k=c.appWin.volumes.data[i];var j,h,l;if(!k){return}j=k.get("size");h=SYNO.SDS.StorageUtils.SpaceIDParser(k.get("id")).str;l=k.get("desc");if(l){h=String.format("{0} ({1})",h,l)}return{name:h,fs:_T("volume",String.format("volume_add_fs_{0}_type",k.get("fs_type"))),usedSize:SYNO.SDS.StorageUtils.SizeRender(j.used),totalSize:SYNO.SDS.StorageUtils.SizeRender(j.total)}};var f=function(h){var j=c.appWin.iscsiLuns.data[h];var i;if(!j){return}i=SYNO.SDS.StorageUtils.SizeRender(j.get("iscsi_lun").size);return{name:SYNO.SDS.StorageUtils.SpaceIDParser(j.get("id")).str,fs:"-",usedSize:i,totalSize:i}};if(b.supportMultiple()){Ext.each(b.get("pool_child"),function(h){g.push(h.id)})}else{if(b.isDeploy()){g.push(b.get("deploy_path"))}}Ext.each(g,function(i){var h=(0===i.indexOf("volume"))?d(i):f(i);if(!Ext.isObject(h)){return true}a.push(h)});e.allocation=a},prepareDetail:function(f,c){var h=this,i=SYNO.SDS.StorageUtils,g=h.appWin.detailUsage[f.get("id")]||{lun:0,volume:0},k=parseInt(f.get("size").used,10),j=parseInt(f.get("size").total,10),d=i.GetSizeUnit(g.volume),e=i.GetSizeUnit(g.lun),a=i.GetSizeUnit(j-k);var b=function(l){if(0>l.size){l.message=_T("volume","volume_size_calculating")}};b(d);b(e);b(a);c.detailUsage={};j=(0===j)?1:j;c.detailUsage.bar1Width=g.volume/j*100;c.detailUsage.bar2Width=g.lun/j*100;c.illustrate=[{text:_T("volume","volume"),value:d.size,unit:d.unit,message:d.message,hide:0},{text:_T("volume","volume_lun_block_level"),value:e.size,unit:e.unit,message:e.message,hide:("yes"===_D("support_iscsi_target","no"))?0:1},{text:_T("volume","volume_freesize"),value:a.size,unit:a.unit,message:a.message,hide:0}]},repair_system_partition_link_id:undefined,data_scrubbing_link_id:undefined,renderSuggestions:function(g,d){var e,h="",c="",l={};var a=false;var b=false;var m="";var j="";var f=g.get("suggestions");var k=SYNO.SDS.StorageUtils;if(!f||f.length<=0){return}if("system partition failed"===f[0].note){a=true;if(Ext.isDefined(this.repair_system_partition_link_id)){}else{this.repair_system_partition_link_id=Ext.id()}m=String.format('&nbsp<a class="link-font" id="{0}" href="#" space_id={2}>{1}</a>',this.repair_system_partition_link_id,_T("volume","volume_repair_syspart"),g.id)}for(e=0;e<f.length;e++){c=k.FormatSuggestion(f[e]);if(undefined!==f[e].note&&!a){if("need data scrubbing"===f[e].note){l=SYNO.SDS.Utils.clone(f[e]);l.str=c;b=true}else{if("some disks are failing"===f[e].note){h+=String.format('<span class="orange-status">{0}</span>',c)}else{continue}}}else{h+=String.format('<span class="{0}">{1}{2}</span><br>',f[e].type==="warning"?"red-status":"green-status",c,e===0?m:"")}}if(a){if(m){this.mon(this.view.getStore(),"load",function(){var i=Ext.fly(this.repair_system_partition_link_id);this.mon(i,"click",this.repairSysPartition,this)},this,{single:true})}}else{if(b){if(Ext.isDefined(this.data_scrubbing_link_id)){}else{this.data_scrubbing_link_id=Ext.id()}j=String.format('&nbsp<a class="link-font" id="{0}" href="#" space_id={2}>{1}</a>',this.data_scrubbing_link_id,_T("volume","start_raid_scrubbing"),g.id);h+=String.format('<span class="{0}">{1}{2}</span><br>',l.type==="warning"?"red-status":"green-status",l.str,j);if(j){this.mon(this.view.getStore(),"load",function(){var i=Ext.fly(this.data_scrubbing_link_id);this.mon(i,"click",this.onDataScrubbing,this)},this,{single:true})}}}if(""===h){return}d.property.push({name:_T("volume","volume_status_suggest"),value:h})},onActivate:function(){var b=this,a=b.view.store;b.prepareUiData();a.suspendEvents(true);a.loadData(b.uiData,false);a.resumeEvents();b.resetBtnStatus();if(0<b.view.store.getCount()&&0===b.view.getSelectedItemIds().length){b.view.select(0,true,true)}b.onSelectChange();b.setMask()},onSelectChange:function(){var b=this,a=b.view.getSelectedItem();b.getButton("remove").hide();b.getButton("manage").hide();b.getButton("cancel").hide();if(!a){this.disablePanelFunctionBySystemDR();return}b.getButton("remove").show();b.enableButton("remove",b.canDelete(a));b.getButton("manage").show();b.enableButton("manage",b.canManage(a));if(a.isCreating()){b.getButton("cancel").show();b.enableButton("cancel",b.canCancel(a))}this.disablePanelFunctionBySystemDR()},onCreate:function(){var b=this,a;a=b.canCreate();if(!a){return}b.openWizard("CreatePoolMain",{option:a})},onDelete:function(){var c=this,a,b,d;a=c.view.getSelectedItemIds();if(0===a.length){return}b=c.appWin.storagePools.data[a[0]];if(!b){return}if(b.usedByGlusterFs()){d=String.format(_T("volume","goto_cms_manage_pool"),_T("volume","volume_storage_pool"));c.owner.getMsgBox().alert(c.title,d);return}c.openWizard("DeletePool",{pool:b})},onRepair:function(){var f=this,d=f.view.getSelectedItem(),b,e,a,c,g;if(SYNO.SDS.StorageUtils.IsBlockedInSDR(f.owner)){return}if(!d){return}b=(d.get("raids"))?d.get("raids")[0].devices[0].id:d.get("disks")[0];e=f.appWin.disks.data[b].get("diskType");a=f.getAvailableDisksForAdd(d);if(!d.isSHR()){c=f.getValidAddTypeRaidGroup(d,a)}else{c=f.getValidAddType(d,a)}if(d.get("can_do")&&d.get("can_do").repair&&!isNaN(d.get("can_do").repair)){g=parseInt(d.get("can_do").repair,10)}else{g=0}f.openWizard("ManagePool",{add_type:"repair",pool:d,disks:a,hddType:e,repair:g,manageType:c,migrateType:f.getValidMigrateType(d,a)})},onAddDisks:function(){var f=this,c=f.view.getSelectedItem(),a,b,g,e=c.get("raids")[0],d=f.appWin.disks.data[e.devices[0].id].get("diskType");if(SYNO.SDS.StorageUtils.IsBlockedInSDR(f.owner)){return}if(!c){return}if(c.usedByGlusterFs()){g=String.format(_T("volume","goto_cms_manage_pool"),_T("volume","volume_storage_pool"));f.owner.getMsgBox().alert(f.title,g);return}a=f.getAvailableDisksForAdd(c);if(!c.isSHR()){b=f.getValidAddTypeRaidGroup(c,a)}else{b=f.getValidAddType(c,a)}f.openWizard("ManagePool",{add_type:"expand_by_disk",pool:c,disks:a,hddType:d,manageType:b,migrateType:f.getValidMigrateType(c,a)})},onExpand:function(){var b=this,a=b.view.getSelectedItem();if(SYNO.SDS.StorageUtils.IsBlockedInSDR(b.owner)){return}if(!a){return}b.openWizard("ManagePool",{pool:a,add_type:"expand_with_unalloc_size"})},onMigrate:function(){var f=this,g,c=f.view.getSelectedItem(),a,b,e=c.get("raids")[0],d=f.appWin.disks.data[e.devices[0].id].get("diskType");if(SYNO.SDS.StorageUtils.IsBlockedInSDR(f.owner)){return}if(!c){return}if(0<c.get("disk_failure_number")){this.owner.getMsgBox().alert(this.title,_T("volume","volume_migrate_with_failed_disk_alert"));return}if(c.usedByGlusterFs()){g=String.format(_T("volume","goto_cms_manage_pool"),_T("volume","volume_storage_pool"));f.owner.getMsgBox().alert(f.title,g);return}a=f.getAvailableDisksForAdd(c);if(!c.isSHR()){b=f.getValidAddTypeRaidGroup(c,a)}else{b=f.getValidAddType(c,a)}f.openWizard("ManagePool",{add_type:"migrate",pool:c,disks:a,hddType:d,manageType:b,migrateType:f.getValidMigrateType(c,a)})},onConvertSHR:function(){var c=this.view.getSelectedItem();var a,b;var d=this.appWin.disks.data[c.get("disks")[0]].get("diskType");if(SYNO.SDS.StorageUtils.IsBlockedInSDR(this.owner)){return}if(!c||!c.isSHR()){return}a=this.getAvailableDisksForAdd(c);b=this.getValidAddType(c,a);this.openWizard("ManagePool",{add_type:"convert_shr_to_pool",pool:c,disks:a,hddType:d,manageType:b,migrateType:this.getValidMigrateType(c,a)})},onCompleteSHR:function(){var c=this.view.getSelectedItem();var a,b;var d=this.appWin.disks.data[c.get("disks")[0]].get("diskType");if(SYNO.SDS.StorageUtils.IsBlockedInSDR(this.owner)){return}if(!c||!c.isSHR()){return}a=this.getAvailableDisksForAdd(c);b=this.getValidAddType(c,a);this.openWizard("ManagePool",{add_type:"expand_unfinished_shr",pool:c,disks:a,hddType:d,manageType:b,migrateType:this.getValidMigrateType(c,a)})},onEdit:function(){var b=this,a=b.view.getSelectedItem();if(SYNO.SDS.StorageUtils.IsBlockedInSDR(b.owner)){return}if(!a){return}b.openWizard("EditPool",{pool:a})},onCancel:function(){var d=this,b=d.view.getSelectedItem(),g,f;if(SYNO.SDS.StorageUtils.IsBlockedInSDR(d.owner)){return}if(!b){return}var c=b.get("deploy_path");var a=c?(-1<c.indexOf("volume")):false;var e="single"===b.get("raidType");g=(e&&a)?c:b.get("id");f="cancel_create";d.appWin.stopPollTask();d.owner.setStatusBusy({text:_T("common","saving")});SYNO.API.Request({api:this.getAPI(b),method:f,version:1,params:{space_id:g},callback:function(k,j,i,h){this.clearStatusBusy();if(!k){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,j)}this.setStatusBusy();this.cleanMask=true;this.startPollTask()},scope:this.owner})},onSort:function(f,d){var c=this,b,a=c.view.store;if(0>f.itemId.indexOf("_")){return}c.sortType=f.itemId;b=f.itemId.split("_")[1];if(a.sortField!==b){a.sortField=b;a.sortDir="ASC"}else{a.sortDir="ASC"===a.sortDir?"DESC":"ASC"}a.sort(a.sortField,a.sortDir);c.onSelectChange()},openDialog:function(d,b,a){var e;if(this.owner.isUpToBatchTaskCount()){e=_T("volume","volume_max_batch_task_count").replace("_MAX_TASK_",this.owner.getMaxBatchTaskCount());this.owner.getMsgBox().alert(this.title,e,function(){},this);return}var c=new SYNO.SDS.StorageManager.Pool.Dialog[d](Ext.apply({owner:this.owner},b));this.owner.updater.stop();c.mon(c,"close",function(){if(Ext.isFunction(c.hideFromOwner)){c.hideFromOwner()}if(c.isDataChanged){this.owner.setStatusBusy();this.owner.cleanMask=true}this.owner.updater.start()},this,{single:true});c.open(a)},openWizard:function(b,a){var c=this,e;if(c.appWin.isUpToBatchTaskCount()){e=_T("volume","volume_max_batch_task_count").replace("_MAX_TASK_",c.appWin.getMaxBatchTaskCount());c.appWin.getMsgBox().alert(c.title,e,function(){},c);return}var d=new SYNO.SDS.StorageManager.Wizard[b](Ext.apply({appWin:c.appWin,owner:c.owner},a));c.appWin.stopPollTask();c.mon(d,"close",function(){if(Ext.isFunction(d.hideFromOwner)){d.hideFromOwner()}if(d.isDataChanged){c.owner.setStatusBusy();c.body.unmask();c.owner.cleanMask=true}c.appWin.startPollTask()},c,{single:true});d.open()},getButton:function(a){return this.getTopToolbar().getComponent(a)},enableButton:function(c,a){var b=this.getButton(c);if(!b){throw Error("could not get button of id: "+c)}return a?b.enable():b.disable()},getAvailableDisksForAdd:function(h,d){var i=this;var l=i.appWin.hotSpares.data;var m=h.get("minimal_disk_size");var a=h.get("container");var c=h.isSHR();var j=[],e=[];var n=false;var b,k;var g=function(o){if(c&&"expand_by_disk"===d){return o.isBiggerThan(m)||o.isEqualToAny(e)}return o.isBiggerThan(m)};var f=function(o){return(o.is4Kn()&&k)||(!o.is4Kn()&&!k)};Ext.each(h.get("disks"),function(o){var p=i.appWin.disks.data[o];if(p){n=true;b=p.get("diskType");k=p.is4Kn()}if(n&&!c){return false}e.push(parseInt(p.get("size_total"),10))});if(!a||!h.get("can_do")||!n){return j}if(h.get("can_do").raid_cross||h.isExpansion()){j=i.appWin.disks.getMatched(function(){var o=this;return o.isNormalTray()&&o.isFree()&&g(o)&&o.isSameInterface(b)&&!o.inSpare(l)&&f(o)})}else{if("internal"===a){j=i.appWin.disks.getMatched(function(){var o=this;return o.isNormalTray()&&o.isFree()&&o.isInternal()&&g(o)&&f(o)})}else{if("ebox"===a){j=i.appWin.disks.getMatched(function(){var o=this;return o.isFree()&&o.isInEbox()&&g(o)&&f(o)})}}}return j},getValidAddType:function(f,a){var h=this,g=f.get("can_do"),e,b,d=false,c;if(!g){return{}}b=h.getValidMigrateType(f,a);for(e in b){if(b[e]){d=true;break}}c=h.getAvailableDisksForAdd(f,"expand_by_disk");return{repair:(("replace_failed_disk" in g)||("repair" in g))&&0<a.length,expand_by_disk:("expand_by_disk" in g)&&g.expand_by_disk<=c.length,expand_with_unalloc_size:("expand_with_unalloc_size" in g)&&(parseInt(g.expand_with_unalloc_size,10)>0),migrate:d,expand_unfinished_shr:("expand_unfinished_shr" in g),convert_shr_to_pool:("convert_shr_to_pool" in g)&&g.convert_shr_to_pool<=a.length}},getValidAddTypeRaidGroup:function(f,a){var e=f.get("can_do"),d,b,c=false;if(!e){return{}}b=this.getValidMigrateType(f,a);for(d in b){if(b[d]){c=true;break}}return{repair:("repair" in e)&&0<a.length,expand_by_disk:("expand_by_disk" in e)&&e.expand_by_disk<=a.length,expand_with_unalloc_size:("expand_with_unalloc_size" in e)&&parseInt(e.expand_with_unalloc_size,10)>0,migrate:c}},getValidMigrateType:function(f,a){var b,g,d,e=f.get("can_do"),c={};if(!e||!e.migrate){return{}}e=e.migrate;if("to_raid5+spare" in e){b=e["to_raid5+spare"].split("-");g=parseInt(b[0],10);d=parseInt(b[1],10);c["to_raid5+spare"]=(g<=a.length)&&!_S("ha_running")}return Ext.applyIf(c,{add_mirror:("add_mirror" in e)&&0<a.length,to_raid1:("to_raid1" in e)&&0<a.length&&!_S("ha_running"),to_raid5:("to_raid5" in e)&&e.to_raid5<=a.length&&!_S("ha_running"),to_raid6:("to_raid6" in e)&&e.to_raid6<=a.length&&!_S("ha_running"),to_shr2:("to_shr2" in e)&&e.to_shr2<=a.length&&!_S("ha_running")})},repairSysPartition:function(c,b){var a=new Ext.Element(b);var d=a.getAttribute("space_id");this.owner.setStatusBusy();this.owner.updater.stop();SYNO.API.Request({webapi:{api:"SYNO.Storage.CGI.Storage",method:"repair_sys_partition",version:"1",params:{space_id:d}},callback:function(h,e,g,f){this.owner.clearStatusBusy();if(!h){this.owner.getMsgBox().alert(this.title,_T("common","commfail"));this.owner.updater.start();return}if(e.str){this.owner.getMsgBox().alert(this.title,e.str,function(){this.owner.setStatusBusy();this.owner.cleanMask=true;this.owner.updater.start()},this)}else{this.owner.updater.start()}},scope:this})},disablePanelFunctionBySystemDR:function(){var b=this;if(!_S("systemdr_running")||_S("systemdr_is_cdsm_single_volume")||!SYNO.SDS.Utils.isInC2DSM()){return}var a=["create","remove","manage","cancel"].map(function(d){return b.getButton(d)});var c;if(_S("systemdr_is_cdsm_single_volume")){c=_TT("SYNO.SDS.SystemDR.Instance","feasibility","sdr_in_vdsm")}else{c=_TT("SYNO.SDS.SystemDR.Instance","feasibility","not_support_in_beta")}SYNO.SDS.StorageUtils.DisableButtonsBySDR(a,c)}});Ext.namespace("SYNO.SDS.TaskScheduler.SMART");Ext.namespace("SYNO.SDS.StorageManager.Disk");SYNO.SDS.StorageManager.Disk.UTILIZATION_THRESHOLD=5;SYNO.SDS.StorageManager.Disk.COMPARE_WARN_THRESHOLD=5;SYNO.SDS.StorageManager.Disk.DISK_PERF_NUM_THRESHOLD=3;SYNO.SDS.StorageManager.Disk.ERR_DISK_IN_USE=403;Ext.define("SYNO.SDS.StorageManager.Wizard.SmartTest",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){var a=new SYNO.SDS.StorageManager.SmartTestView(Ext.apply({style:"padding: 0px 20px;",appWin:this},b));var c=Ext.apply({title:_T("smart","smart_toolbar_smart_test"),width:650,height:450,minHeight:380,minWidth:560,layout:"fit",dsmStyle:"v5",items:[a],buttons:[{text:_T("common","alt_close"),handler:this.close,scope:this}]},b);this.callParent([c])}});Ext.define("SYNO.SDS.StorageManager.SmartTestView",{extend:"SYNO.ux.Panel",constructor:function(a){var c=this,b;this.is_target_ha_passive=a.is_target_ha_passive;c.needRefresh=false;b=Ext.apply({title:_T("smart","smart_toolbar_smart_test"),layout:"fit",items:[c.configForm({itemId:"form"})],listeners:{scope:c,beforedestroy:c.pollingTaskStop}},a);c.callParent([b]);c.mon(c,"afterlayout",c.onAfterlayout,c,{single:true})},configForm:function(a){var b;b=Ext.apply({xtype:"syno_formpanel",trackResetOnLoad:true,border:false,items:[{xtype:"syno_fieldset",collapsible:false,title:_T("disk_info","disk_smart_test_perform"),itemId:"testing",synodefaults:{width:200},items:[{xtype:"syno_displayfield",value:_T("disk_info","disk_smart_test_desc")},{xtype:"syno_displayfield",cls:"sm-empty-line"},{itemId:"quick_radio",xtype:"syno_radio",boxLabel:_T("smart","smart_quick_test"),name:"testStyle",inputValue:"quick",checked:true},{xtype:"syno_displayfield",value:_T("disk_info","disk_smart_quick_desc"),itemId:"quick_desc",indent:1},{itemId:"extend_radio",xtype:"syno_radio",boxLabel:_T("smart","smart_extend_test"),name:"testStyle",inputValue:"extend"},{xtype:"syno_displayfield",value:_T("disk_info","disk_smart_extend_desc"),itemId:"extend_desc",indent:1},{xtype:"syno_displayfield",name:"testingStatus",htmlEncode:false},{xtype:"syno_button",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",itemId:"apply",id:this.testBtnId=Ext.id(),text:_T("smart","smart_test_button_start"),handler:this.onApply,scope:this}]},{xtype:"syno_fieldset",collapsible:false,itemId:"status",title:_T("smart","smart_test_result"),labelWidth:300,items:[{xtype:"syno_displayfield",name:"quickTestLog",htmlEncode:false,fieldLabel:_T("smart","smart_quick_test_log")},{xtype:"syno_displayfield",name:"extendTestLog",htmlEncode:false,fieldLabel:_T("smart","smart_extend_test_log")}]}]},a);return b},onAfterlayout:function(a){if(!(this.device=a.device)){throw Error("param error: device is not set")}this.TestLogPollingConf={interval:5,immediate:true,webapi:SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",version:1,method:"get_smart_test_log",params:{device:this.device}}),status_callback:function(e,c,d,b){if(this.cleanMask){this.appWin.clearStatusBusy();this.cleanMask=false}if(!e){this.appWin.getMsgBox().alert(_T("tree","node_device"),_T("smart","smart_status_unknow"));this.pollingTaskStop();return}this.fillData(c)},scope:this};this.form=this.getComponent("form").getForm();this.btn=this.getComponent("form").getComponent("testing").getComponent("apply");this.radio_quick=this.getComponent("form").getComponent("testing").getComponent("quick_radio");this.desc_quick=this.getComponent("form").getComponent("testing").getComponent("quick_desc");this.radio_extend=this.getComponent("form").getComponent("testing").getComponent("extend_radio");this.desc_extend=this.getComponent("form").getComponent("testing").getComponent("extend_desc");this.appWin.setStatusBusy();this.cleanMask=true;this.pollingTaskStart()},pollingTaskStart:function(){if(this.TestLogPollingID===undefined){this.TestLogPollingID=this.pollReg(this.TestLogPollingConf)}},pollingTaskStop:function(){if(this.TestLogPollingID!==undefined){this.pollUnreg(this.TestLogPollingID);this.TestLogPollingID=undefined}},testing:undefined,quickTime:undefined,extendTime:undefined,cleanMask:false,fillData:function(e){var b=null;var d,f;var c=this;var a=SYNO.SDS.StorageUtils;b=e.testInfo[0];d=a.smartTestStatusRender(b.quick);f=a.smartTestStatusRender(b.extend);if(b.quick==="completed"||b.quick==="damage"||b.quick==="aborted"||b.quick==="interrupted"){if(0<e.quick_last.length){d=d+" ("+e.quick_last+")"}}if(b.extend==="completed"||b.extend==="damage"||b.extend==="aborted"||b.extend==="interrupted"){if(0<e.extend_last.length){f=f+" ("+e.extend_last+")"}}this.form.findField("quickTestLog").setRawValue(d);this.form.findField("extendTestLog").setRawValue(f);this.quickTime=b.quickTime;this.extendTime=b.extendTime;this.testing=b.testing;if(this.testing){this.form.findField("testingStatus").setVisible(true);if(b.remain!=="-1"){this.form.findField("testingStatus").setRawValue(SYNO.SDS.StorageUtils.smartStatusRender("",b.remain))}else{SYNO.SDS.StorageUtils.setUpdateTimeAnimate(true,this.form.findField("testingStatus"),_T("background_task","task_processing"))}this.radio_quick.getEl().findParentNode("").parentNode.style.display="none";this.desc_quick.getEl().findParentNode("").parentNode.style.display="none";this.radio_extend.getEl().findParentNode("").parentNode.style.display="none";this.desc_extend.getEl().findParentNode("").parentNode.style.display="none";this.btn.setText(_T("smart","smart_test_button_stop"));c.needRefresh=true}else{this.form.findField("testingStatus").setVisible(false);this.form.findField("testingStatus").setRawValue("");this.radio_quick.getEl().findParentNode("").parentNode.style.display="";this.desc_quick.getEl().findParentNode("").parentNode.style.display="";this.radio_extend.getEl().findParentNode("").parentNode.style.display="";this.desc_extend.getEl().findParentNode("").parentNode.style.display="";this.btn.setText(_T("smart","smart_test_button_start"));if(c.needRefresh){if(c.appWin.healthOverviewPanel){c.appWin.healthOverviewPanel.onHealthInfoRefresh({device:c.device})}c.needRefresh=false}}if(_S("demo_mode")){Ext.getCmp(this.testBtnId).setDisabled(true);Ext.getCmp(this.testBtnId).setTooltip(_JSLIBSTR("uicommon","error_demo"))}else{if(b.perf_testing||b.ihm_testing){Ext.getCmp(this.testBtnId).setDisabled(true);Ext.getCmp(this.testBtnId).setTooltip(_T("disk_info","other_is_testing"))}else{Ext.getCmp(this.testBtnId).setDisabled(false);Ext.getCmp(this.testBtnId).setTooltip("")}}c.doLayout()},onApply:function(){var d="";var c,b;var a=this;if(this.testing){this.sendStopRequest();return}d=this.form.findField("testStyle").getGroupValue();if(d==="quick"){c=_T("smart","smart_quick_test");b=String.format(_T("smart","smart_test_time"),_T("smart","smart_quick_test"),this.quickTime)}else{if(d==="extend"){c=_T("smart","smart_extend_test");b=String.format(_T("smart","smart_test_time"),_T("smart","smart_extend_test"),this.extendTime)}}if(a.appWin.healthInfo&&a.appWin.healthInfo.overview&&a.appWin.healthInfo.overview.smart_test_limit){a.appWin.getMsgBox().confirm("",_T("disk_info","disk_smart_test_warn"),function(e){if(e!=="yes"){return}a.sendTestRequest(c,b,d)},a)}else{a.sendTestRequest(c,b,d)}},sendStopRequest:function(){this.appWin.setStatusBusy({text:_T("common","saving")});this.appWin.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",version:1,method:"do_smart_test",params:{device:this.device,type:"stop"},callback:function(d,b,c,a){this.appWin.clearStatusBusy();if(!d){this.appWin.getMsgBox().alert(_T("tree","node_device"),_T("common","error_system"));this.pollingTaskStop();return}this.appWin.setStatusBusy();this.cleanMask=true;this.appWin.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",version:1,method:"get_smart_test_log",params:{device:this.device},callback:function(h,f,g,e){if(this.cleanMask){this.appWin.clearStatusBusy();this.cleanMask=false}if(!h){this.appWin.getMsgBox().alert(_T("tree","node_device"),_T("common","error_system"));this.pollingTaskStop();return}this.fillData(f)},scope:this}))},scope:this}))},sendTestRequest:function(b,a,c){this.appWin.getMsgBox().confirm(b,a,function(d){if(d!=="yes"){return}this.appWin.setStatusBusy({text:_T("common","saving")});this.appWin.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",version:1,method:"do_smart_test",params:{device:this.device,type:c},callback:function(h,f,g,e){this.appWin.clearStatusBusy();if(!h){this.appWin.getMsgBox().alert(_T("tree","node_device"),_T("smart","smart_selftest_cmd_exec_failed"));this.pollingTaskStop();return}this.appWin.setStatusBusy();this.cleanMask=true;this.appWin.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",version:1,method:"get_smart_test_log",params:{device:this.device},callback:function(l,j,k,i){if(this.cleanMask){this.appWin.clearStatusBusy();this.cleanMask=false}if(!l){this.appWin.getMsgBox().alert(_T("tree","node_device"),_T("common","error_system"));this.pollingTaskStop();return}this.fillData(j)},scope:this}))},scope:this}))},this)}});Ext.define("SYNO.SDS.StorageManager.Wizard.AdvTest",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){var a=new SYNO.SDS.StorageManager.AdvTestView(Ext.apply({style:"padding: 0px 20px;",appWin:this},b));var c=Ext.apply({title:_T("disk_info","disk_ironwolf_health"),width:650,height:450,minHeight:380,minWidth:560,layout:"fit",dsmStyle:"v5",items:[a],buttons:[{text:_T("common","alt_close"),handler:this.close,scope:this}]},b);this.callParent([c])}});Ext.define("SYNO.SDS.StorageManager.AdvTestView",{extend:"SYNO.ux.Panel",constructor:function(a){var c=this,b;c.cleanMask=false;c.needRefresh=false;b=Ext.apply({title:_T("disk_info","disk_ironwolf_health"),layout:"fit",items:[c.configForm({itemId:"form"})],listeners:{scope:c,beforedestroy:c.pollingTaskStop}},a);c.callParent([b]);c.mon(c,"afterlayout",c.onAfterlayout,c,{single:true})},configForm:function(a){var c=this,b;b=Ext.apply({xtype:"syno_formpanel",trackResetOnLoad:true,border:false,items:[{xtype:"syno_fieldset",collapsible:false,title:_T("disk_info","disk_ironwolf_health_manage"),htmlEncode:false,synodefaults:{width:200},items:[{xtype:"syno_displayfield",value:_T("disk_info","disk_adv_test_desc")},{xtype:"syno_displayfield",id:c.testingStatusId=Ext.id()},{xtype:"syno_button",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",id:c.testBtnId=Ext.id(),text:_T("smart","smart_test_button_start"),style:{marginBottom:"8px"},handler:c.onApply,scope:c},{xtype:"syno_displayfield",id:c.noteId=Ext.id(),htmlEncode:false,value:_T("disk_info","disk_ironwolf_link_note")}]},{xtype:"syno_fieldset",collapsible:false,title:_T("smart","smart_test_result"),labelWidth:300,items:[{xtype:"syno_displayfield",id:c.testResultId=Ext.id(),htmlEncode:false,fieldLabel:_T("disk_info","disk_ironwolf_test_pre_result")},{xtype:"syno_displayfield",id:c.testOutputId=Ext.id(),htmlEncode:false,fieldLabel:_T("disk_info","disk_adv_test_code")}]}]},a);return b},onAfterlayout:function(b){var a=this;if(!(a.device=b.device)){throw Error("param error: device is not set")}a.TestLogPollingConf={interval:5,immediate:true,webapi:SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",version:1,method:"get_adv_test_log",params:{device:a.device}}),status_callback:function(f,d,e,c){if(a.cleanMask){a.appWin.clearStatusBusy();a.cleanMask=false}if(!f){a.appWin.getMsgBox().alert(_T("tree","node_device"),_T("status","status_not_available"));a.pollingTaskStop();return}a.fillData(d)},scope:a};a.appWin.setStatusBusy();a.cleanMask=true;a.pollingTaskStart()},pollingTaskStart:function(){var a=this;if(undefined===a.TestLogPollingID){a.TestLogPollingID=a.pollReg(a.TestLogPollingConf)}},pollingTaskStop:function(){var a=this;if(undefined!==a.TestLogPollingID){a.pollUnreg(a.TestLogPollingID);a.TestLogPollingID=undefined}},fillData:function(e){var d=this;var b="";var a="";var c=SYNO.SDS.StorageUtils.DiskTestLogRender(e.test_result);a=String.format('<span class="{0}">{1}</span>',c.color,c.text);if(""!==e.test_time){a+=" ("+e.test_time+")"}Ext.getCmp(d.testResultId).setRawValue(a);if(""===c.code){b=c.tooltip}else{if("unknown"===c.code){b=e.test_code+". "+c.tooltip}else{b=c.code+". "+c.tooltip}}Ext.getCmp(d.testOutputId).setRawValue(b);switch(e.disk_code){case"ironwolf":Ext.getCmp(d.noteId).setValue(_T("disk_info","disk_ironwolf_link_note"));break;case"ironwolf_pro":Ext.getCmp(d.noteId).setValue(_T("disk_info","disk_ironwolf_pro_link_note"));break;default:Ext.getCmp(d.noteId).setValue("");Ext.getCmp(d.noteId).setVisible(false)}d.testing=e.testing;if(d.testing){SYNO.SDS.StorageUtils.setUpdateTimeAnimate(true,Ext.getCmp(d.testingStatusId),_T("background_task","task_processing"));Ext.getCmp(d.testingStatusId).setVisible(true);Ext.getCmp(d.testBtnId).setText(_T("smart","smart_test_button_stop"));d.needRefresh=true}else{Ext.getCmp(d.testingStatusId).setRawValue("");Ext.getCmp(d.testingStatusId).setVisible(false);Ext.getCmp(d.testBtnId).setText(_T("smart","smart_test_button_start"));if(d.needRefresh){if(d.appWin.healthOverviewPanel){d.appWin.healthOverviewPanel.onHealthInfoRefresh({device:d.device})}d.needRefresh=false}}if(_S("demo_mode")){Ext.getCmp(this.testBtnId).setDisabled(true);Ext.getCmp(this.testBtnId).setTooltip(_JSLIBSTR("uicommon","error_demo"))}else{if(e.perf_testing||e.smart_testing){Ext.getCmp(this.testBtnId).setDisabled(true);Ext.getCmp(this.testBtnId).setTooltip(_T("disk_info","other_is_testing"))}else{Ext.getCmp(this.testBtnId).setDisabled(false);Ext.getCmp(this.testBtnId).setTooltip("")}}d.doLayout()},onApply:function(){var b=this,a="";if(b.testing){a="stop";b.sendTestRequest(a)}else{a="start";b.confirmTestRequest(a)}},confirmTestRequest:function(a){var b=this;b.appWin.getMsgBox().confirm("",_T("disk_info","disk_ironwolf_test_processing"),function(c){if(c!=="yes"){return}b.sendTestRequest(a)},b)},sendTestRequest:function(a){var b=this;b.appWin.setStatusBusy({text:_T("common","saving")});b.appWin.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",version:1,method:"do_adv_test",params:{device:b.device,type:a},callback:function(f,d,e,c){b.appWin.clearStatusBusy();if(!f){b.appWin.getMsgBox().alert(_T("tree","node_device"),_T("error","error_error_system"));b.pollingTaskStop();return}b.appWin.setStatusBusy();b.cleanMask=true;b.appWin.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",version:1,method:"get_adv_test_log",params:{device:b.device},callback:function(j,h,i,g){if(b.cleanMask){b.appWin.clearStatusBusy();b.cleanMask=false}if(!j){b.appWin.getMsgBox().alert(_T("tree","node_device"),_T("common","error_system"));b.pollingTaskStop();return}b.needRefresh=true;b.fillData(h)},scope:b}))},scope:b}))}});Ext.define("SYNO.SDS.StorageManager.Wizard.HealthInfo",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var b=[];this.cfg=a;this.cfg.appWin=this;this.healthOverviewPanel=new SYNO.SDS.StorageManager.HealthOverview(Ext.apply({id:this.healthOverviewId=Ext.id()},this.cfg));this.smartInfoPanel=new SYNO.SDS.StorageManager.SmartInfo(Ext.apply({id:this.smartInfoId=Ext.id(),isNvme:false},this.cfg));this.smartInfoNVMePanel=new SYNO.SDS.StorageManager.SmartInfo(Ext.apply({id:this.smartInfoNVMeId=Ext.id(),isNvme:true},this.cfg));b.push(this.healthOverviewPanel);b.push(new SYNO.SDS.StorageManager.AdvTestView(Ext.apply({id:this.advTestViewId=Ext.id()},this.cfg)));b.push(new SYNO.SDS.StorageManager.SmartTestView(Ext.apply({id:this.smartTestViewId=Ext.id()},this.cfg)));b.push(this.smartInfoPanel);b.push(this.smartInfoNVMePanel);b.push(new SYNO.SDS.StorageManager.HealthHistory(Ext.apply({id:this.healthHistoryId=Ext.id()},this.cfg)));var d=new SYNO.SDS.Utils.TabPanel({id:this.tabPanelId=Ext.id(),activeTab:0,items:b});var c=Ext.apply({title:_T("disk_info","disk_health_info")+" - "+a.name,modal:false,width:700,height:620,minWidth:700,minHeight:580,layout:"fit",items:d,buttons:[{text:_T("common","alt_close"),handler:this.close,scope:this}]},a);this.callParent([c]);Ext.getCmp(this.tabPanelId).hideTabStripItem(this.advTestViewId);Ext.getCmp(this.tabPanelId).hideTabStripItem(this.smartInfoId);Ext.getCmp(this.tabPanelId).hideTabStripItem(this.smartInfoNVMeId);Ext.getCmp(this.tabPanelId).hideTabStripItem(this.smartTestViewId);Ext.getCmp(this.tabPanelId).hideTabStripItem(this.healthHistoryId)},removeTab:function(e){var b=0;var c=7;var d=20*2;var a=20*2;if("undefined"===typeof(e)){return}b+=a;b+=(Ext.getCmp(this.healthOverviewId).title.length)*c+d;if("not_support"!==e.adv_status){Ext.getCmp(this.tabPanelId).unhideTabStripItem(this.advTestViewId);b+=(Ext.getCmp(this.advTestViewId).title.length)*c+d}if(e.smartInfo_support){if(e.isNVMeDisk){Ext.getCmp(this.tabPanelId).unhideTabStripItem(this.smartInfoNVMeId);b+=(Ext.getCmp(this.smartInfoNVMeId).title.length)*c+d}else{Ext.getCmp(this.tabPanelId).unhideTabStripItem(this.smartInfoId);b+=(Ext.getCmp(this.smartInfoId).title.length)*c+d}}if(e.smartTest_support){Ext.getCmp(this.tabPanelId).unhideTabStripItem(this.smartTestViewId);b+=(Ext.getCmp(this.smartTestViewId).title.length)*c+d}if(e.healthHistory_support){Ext.getCmp(this.tabPanelId).unhideTabStripItem(this.healthHistoryId);b+=(Ext.getCmp(this.healthHistoryId).title.length)*c+d}if(this.getWidth()<b){this.setWidth(b)}}});Ext.define("SYNO.SDS.StorageManager.HealthOverview",{extend:"SYNO.ux.Panel",loaded:false,constructor:function(a){this.owner=a.owner;this.appWin=a.appWin;this.device=a.device;this.temp=a.temp;this.parent=a.parent;this.is_target_ha_passive=a.is_target_ha_passive;this.isHaPanel=a.isHaPanel;this.warningBtnRenderId=Ext.id();this.scheduleBtnRenderId=Ext.id();this.diskHealth=new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">','<div class="sm-overview-health-mini-status">','<div class="sm-overview-health-mini-icon-align ">','<div class="{iconCls} {iconCls}-{status}"></div>','<div class="{statusIconCls} {statusIconCls}-{status}"></div>',"</div>",'<div class="sm-overview-health-mini-textarea">','<div class="sm-overview-health-mini-text sm-overview-health-text-{status}">{text}</div>','<div class="sm-overview-health-mini-desc">{desc}</div>',"<div id="+this.warningBtnRenderId+' class="sm-overview-health-button"></div>',"<div id="+this.scheduleBtnRenderId+' class="sm-overview-health-button"></div>',"</div>","</div>","</tpl>"),store:this.healthStore=new Ext.data.JsonStore({autoDestroy:true,fields:["status","text","desc","iconCls","statusIconCls"]})});this.adv_support=false;if(false===this.isHaPanel){for(var d=0;d<this.owner.disks.count;d++){if("not_support"!==this.owner.disks.dataArray[d].json.adv_status){this.adv_support=true;break}}}var b=[];b.push({xtype:"syno_displayfield",htmlEncode:false,id:this.remain_life_id=Ext.id(),fieldLabel:_T("disk_info","disk_remain_life")},{xtype:"syno_displayfield",id:this.temp_id=Ext.id(),fieldLabel:_T("status","temperature")});b.push({xtype:"syno_displayfield",id:this.poweron_id=Ext.id(),fieldLabel:_T("disk_info","disk_poweron_hours")},{xtype:"syno_displayfield",id:this.retry_id=Ext.id(),fieldLabel:_T("disk_info","disk_retry_ct")},{xtype:"syno_displayfield",htmlEncode:false,id:this.unc_id=Ext.id(),fieldLabel:_T("disk_info","disk_bad_sector_ct")},{xtype:"syno_displayfield",id:this.idnf_id=Ext.id(),fieldLabel:_T("disk_info","disk_identify_failed_ct")});b.push({xtype:"syno_displayfield",htmlEncode:false,id:this.smart_id=Ext.id(),fieldLabel:_T("smart","smart_status")},{xtype:"syno_displayfield",htmlEncode:false,id:this.adv_id=Ext.id(),fieldLabel:_T("disk_info","disk_ironwolf_health_status")});var c=Ext.apply({title:_T("helptoc","logcenter_overview"),border:false,autoFlexcroll:true,items:[this.diskHealth,{xtype:"syno_fieldset",hidden:true,id:this.statistics_field_id=Ext.id(),title:_T("disk_info","disk_health_statistics"),border:false,labelWidth:300,items:b},{border:false,xtype:"syno_fieldset",hidden:true,id:this.description_field_id=Ext.id(),title:_T("pkgmgr","pkgmgr_pkg_description"),items:[{xtype:"syno_displayfield",htmlEncode:false,fieldLabel:"",id:this.system_long_desc_id=Ext.id(),hideLabel:true},{xtype:"syno_displayfield",htmlEncode:false,fieldLabel:"",id:this.system_status_desc_id=Ext.id(),hideLabel:true},{xtype:"syno_displayfield",htmlEncode:false,fieldLabel:"",id:this.system_status_id=Ext.id(),hideLabel:true}]}],listeners:{activate:this.onActivate,scope:this}},a);this.callParent([c])},onActivate:function(a){if(this.loaded){return}this.onHealthInfoRefresh(a)},onHealthInfoRefresh:function(a){this.appWin.setStatusBusy();this.appWin.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Storage.CGI.Smart",method:"get_health_info",version:1,params:{device:a.device},scope:this,callback:function(d,c){this.appWin.clearStatusBusy();var b=null;if(!d){this.onLoadFail();return}this.loaded=true;this.appWin.healthInfo=c.healthInfo;b=this.appWin.healthInfo.overview;if(!b){this.onLoadFail();return}this.onLoadSuccess(b);this.appWin.smartInfoPanel.onActivate()}}))},onRenderButton:function(j){var h=this,b=false,g=0,c="",f="",e=false,a=false,d=[];a=(0<j.smart_suppress||0<j.smart_disable||((0<j.unc_suppress||0<j.unc_disable)&&false===j.exceed_bad_sector_thr)||((0<j.remain_life_suppress||0<j.remain_life_disable)&&false===j.below_remain_life_thr)||true===j.adv_modified||((0<j.smart_test_suppress||0<j.smart_test_disable)&&"normal"===j.smart_test))?true:false;for(g=0;g<j.smart_fail.size();g++){if("critical"!==j.smart_fail[g].type){b=true;break}}if(true===j.exceed_bad_sector_thr||(true===j.below_remain_life_thr&&1<j.remain_life)||true===j.adv_modifiable||"normal_past"===j.smart_test){b=true}if(b||a){h.modifyWarningBtn=new Ext.menu.Item({text:_T("disk_info","disk_remove_warning_title"),id:h.modifyWarningId=Ext.id(),handler:h.onHandleWarning,disabled:!b,scope:h});d.push(h.modifyWarningBtn);h.recoverWarningBtn=new Ext.menu.Item({text:_T("disk_info","disk_recover_warning_title"),id:h.recoverWarningId=Ext.id(),handler:h.onEnableWarning,disabled:!a,scope:h});d.push(h.recoverWarningBtn);h.warningMenu=new SYNO.ux.Menu({items:d});h.warningBtn=new SYNO.ux.Button({id:h.warningBtnId=Ext.id(),text:_T("disk_info","disk_modify_warning_title"),menu:h.warningMenu,renderTo:h.warningBtnRenderId,scope:h})}if(true===h.isHaPanel||false===j.smartTest_support){e=false}else{if((!j.scheduled&&!j.smart_test_limit)&&(!j.adv_scheduled&&"not_support"!==j.adv_status)){c="all";f=_T("disk_info","disk_schedule_drive_test_btn");e=true}else{if(!j.scheduled&&!j.smart_test_limit){c="smart";f=_T("disk_info","disk_schedule_smart_test_btn");e=true}else{if(!j.adv_scheduled&&"not_support"!==j.adv_status){c="adv";f=_T("disk_info","disk_schedule_ironwolf_test_btn");e=true}}}}if(e){h.scheduleBtn=new SYNO.ux.Button({id:h.scheduleBtnId=Ext.id(),text:f,handler:function(){h.onHandleSchedule(c)},renderTo:h.scheduleBtnRenderId,tooltip:_T("disk_info","disk_no_sched_smart_test_desc"),scope:h})}},onHandleWarning:function(){var b=this,a={owner:b.appWin,appWin:b.appWin,device:b.device,is_target_ha_passive:b.is_target_ha_passive},c=new SYNO.SDS.StorageManager.Wizard.SmartWarning(a);c.open(a)},onEnableWarning:function(){var b=this,a={owner:b.appWin,appWin:b.appWin,device:b.device,is_target_ha_passive:b.is_target_ha_passive},c=new SYNO.SDS.StorageManager.Wizard.EnableWarning(a);c.open(a)},onHandleSchedule:function(d){var c=this,a={owner:c.appWin,owner_grid:c.parent.SmartScheduler.panel,disks:c.owner.disks,schedule_id:-1,basic_limitation:false,caller:c,adv_support:c.adv_support,test_type:d},b=new SYNO.SDS.StorageManager.Wizard.EditDialog(a);b.open(a)},smartOtherNormalJudge:function(a){if("fail"!==a.smart_test&&"warning"!==a.adv_status&&"critical"!==a.adv_status&&"failing"!==a.adv_status){return true}else{return false}},onLoadSuccess:function(f){var c={},b=[],d="",g="",a=SYNO.SDS.StorageUtils,e="";g=this.device.substring(5,this.device.length);Ext.getCmp(this.temp_id).setValue(a.DiskTemperatureRender(this.temp));if(f.isSataDisk||f.isNVMeDisk){Ext.getCmp(this.poweron_id).setValue(f.poweron+" "+_T("usbbackup","usbbkp_hour"))}if(f.isSataDisk){Ext.getCmp(this.retry_id).setValue(f.retry);Ext.getCmp(this.unc_id).setValue(a.BadSecCtRender(f.unc,f.exceed_bad_sector_thr));Ext.getCmp(this.idnf_id).setValue(f.idnf)}Ext.getCmp(this.poweron_id).setVisible((f.isSataDisk||f.isNVMeDisk));Ext.getCmp(this.retry_id).setVisible(f.isSataDisk);Ext.getCmp(this.unc_id).setVisible(f.isSataDisk);Ext.getCmp(this.idnf_id).setVisible(f.isSataDisk);this.appWin.removeTab(f);if("-1"===f.smart_progress){SYNO.SDS.StorageUtils.setUpdateTimeAnimate(true,Ext.getCmp(this.smart_id),_T("background_task","task_processing"))}else{Ext.getCmp(this.smart_id).setValue(a.smartStatusRender(f.smart,f.smart_progress))}if(-1===f.remain_life){Ext.getCmp(this.remain_life_id).setVisible(false)}else{Ext.getCmp(this.remain_life_id).setVisible(true);Ext.getCmp(this.remain_life_id).setValue(a.RemainLifeRender(f.remain_life,f.below_remain_life_thr))}if("not_support"===f.adv_status){Ext.getCmp(this.adv_id).setVisible(false)}else{Ext.getCmp(this.adv_id).setVisible(true);if("-1"===f.adv_progress){SYNO.SDS.StorageUtils.setUpdateTimeAnimate(true,Ext.getCmp(this.adv_id),_T("background_task","task_processing"))}else{Ext.getCmp(this.adv_id).setValue(a.advStatusRender(f.adv_status,f.adv_progress))}}Ext.getCmp(this.statistics_field_id).show();switch(f.overview_status){case"normal":c.status="normal";c.text=_T("disk_info","disk_status_normal");c.desc=_T("disk_info","disk_smart_ok_desc");break;case"warning":c.status="warning";c.text=_T("disk_info","disk_status_warning");c.desc=_T("disk_info","disk_status_warning_desc");break;case"unc":c.status="warning";c.text=_T("disk_info","disk_status_warning");c.desc=_T("disk_info","disk_status_warning_desc");break;case"critical":c.status="critical";c.text=_T("disk_info","disk_status_critical");c.desc=_T("disk_info","disk_status_critical_replace_desc");break;case"failing":c.status="failing";c.text=_T("disk_info","disk_status_failing");c.desc=_T("disk_info","disk_status_failing_replace_desc");break;default:SYNO.Debug.error("no such status",c.status);return}c.iconCls=("ironwolf"===f.disk_code)?"sm-overview-ironwolf-health-icon":"sm-overview-health-mini-icon";c.statusIconCls=("ironwolf"===f.disk_code)?"sm-overview-ironwolf-health-status-icon":"sm-overview-health-mini-status-icon";if(true===f.isNVMeDisk){if((true===f.critial_warning.temp_over_thr)&&("warning"===f.overview_status)){c.desc=_T("notification_event","DiskTemperatureAbnormal")}}if("unc"===f.overview_status){c.desc=(f.isSsd)?_T("disk_info","disk_status_warning_ssd_unc_desc"):_T("disk_info","disk_status_warning_unc_desc")}if("failing"!==f.overview_status){if("life_danger"===f.smart_info){c.desc=_T("disk_info","disk_status_remain_life_severe_desc")}}if(true===f.below_remain_life_thr){if("life_below_thr"===f.smart_info&&this.smartOtherNormalJudge(f)){c.desc=_T("disk_info","disk_status_remain_life_desc")}}b.push(c);this.healthStore.loadData(b);this.onRenderButton(f);if(-1!==f.remain_life){SYNO.SDS.Utils.AddTip(Ext.getCmp(this.remain_life_id).getEl(),String.format(_T("disk_info","disk_remain_life_info"),f.remain_life_attr))}e+=this.addBottomDescFailing(f);e+=this.addBottomDescCritical(f);e+=this.addBottomDescWarning(f);e+=this.addBottomDescInfo(f);if(""===e){Ext.getCmp(this.system_long_desc_id).hide();Ext.getCmp(this.description_field_id).hide()}else{Ext.getCmp(this.system_long_desc_id).setValue(e);Ext.getCmp(this.system_long_desc_id).show();Ext.getCmp(this.description_field_id).show()}if(("0"==f.retry&&"0"==f.unc&&"0"==f.idnf&&false===f.below_remain_life_thr)||(true===f.isNVMeDisk)){Ext.getCmp(this.system_status_desc_id).hide();Ext.getCmp(this.system_status_id).hide();this.doLayout();return}Ext.getCmp(this.system_status_desc_id).setValue(String.format(_T("disk_info","disk_err_desc"),_T("disk_info","disk_remain_life"),_T("disk_info","disk_retry_ct"),_T("disk_info","disk_bad_sector_ct"),_T("disk_info","disk_identify_failed_ct"))+"<br>");d+=(!f.below_remain_life_thr)?"":String.format(_T("disk_info","disk_remain_life_desc"),f.remain_life,_T("disk_info","disk_remain_life"),f.remain_life_attr)+"<br><br>";d+=("0"==f.retry)?"":String.format(_T("disk_info","disk_retry_desc"),f.retry,_T("disk_info","disk_retry_ct"))+"<br><br>";d+=("0"==f.unc)?"":String.format(_T("disk_info","disk_bad_sector_desc"),f.unc,_T("disk_info","disk_bad_sector_ct"))+"<br><br>";d+=("0"==f.idnf)?"":String.format(_T("disk_info","disk_identify_failed_desc"),f.idnf,_T("disk_info","disk_identify_failed_ct"))+"<br><br>";Ext.getCmp(this.system_status_id).setValue(d);Ext.getCmp(this.description_field_id).show();this.doLayout()},onLoadFail:function(){var b={},a=[];this.appWin.removeTab();b.status="access_error";b.text=_T("disk_info","disk_status_access_err");b.desc=_T("disk_info","disk_status_access_err_desc");b.iconCls="sm-overview-health-mini-icon";b.statusIconCls="sm-overview-health-mini-status-icon";a.push(b);this.healthStore.loadData(a);Ext.getCmp(this.system_long_desc_id).hide();Ext.getCmp(this.description_field_id).hide();this.doLayout()},addBottomDescFailing:function(b){var a="";a+=("fail"===b.smart_test)?_T("disk_info","disk_status_critical_smart_fail_desc")+"<br><br>":"";a+=("failing"===b.adv_status)?_T(b.adv_section,b.adv_key)+"<br><br>":"";a+=(b.isNVMeDisk&&b.critial_warning.read_only)?_T("disk_info","nvme_critical_warning_read_only_mode")+"<br><br>":"";return a},addBottomDescCritical:function(c){var b="";var a=0;for(a=0;a<c.smart_fail.size();a++){if("repeat"==c.smart_fail[a].type){b+=String.format(_T("disk_info","disk_status_smart_repeat_fail"),c.smart_fail[a].id,c.smart_fail[a].name)+"<br><br>"}else{if("critical"==c.smart_fail[a].type){b+=String.format(_T("disk_info","disk_status_smart_critical_fail"),c.smart_fail[a].id,c.smart_fail[a].name)+"<br><br>"}}}b+=("critical"===c.adv_status)?_T(c.adv_section,c.adv_key)+"<br>":"";if(true===c.isNVMeDisk){b+=(c.critial_warning.spare_below_thr)?String.format(_T("disk_info","nvme_critical_warning_reach_vendor_threshold"),c.remain_life,c.remain_life_thr)+"<br><br>":"";b+=(c.critial_warning.degraded)?_T("disk_info","nvme_critical_warning_media_error")+"<br><br>":"";b+=(c.critial_warning.vm_backup_fail)?_T("disk_info","nvme_critical_warning_volatile_memory_backup_device_fail")+"<br><br>":""}return b},addBottomDescWarning:function(d){var c="";var b=false;var a=0;for(a=0;a<d.smart_fail.size();a++){if("past"===d.smart_fail[a].type){b=true;break}}if("normal_past"===d.smart_info||b){c+=_T("disk_info","disk_status_normal_past_detail")+"<br><br>"}if("normal_past"===d.smart_test){c+=_T("disk_info","disk_status_normal_past_desc")+"<br><br>"}if(true===d.exceed_bad_sector_thr){if(d.isSsd){c+=_T("disk_info","disk_ssd_unc_note")+"<br><br>"}else{c+=_T("disk_info","disk_status_warning_unc_desc")+"<br><br>"}}c+=("warning"===d.adv_status)?_T(d.adv_section,d.adv_key)+"<br><br>":"";c+=(d.isNVMeDisk&&d.below_remain_life_thr)?String.format(_T("disk_info","nvme_remaining_life_reach_user_predefined_level"),d.remain_life)+"<br><br>":"";return c},addBottomDescInfo:function(b){var a="";if("normal_suppress"===b.smart_info||(false===b.exceed_bad_sector_thr&&1===b.unc_suppress&&0===b.unc_disable)||(false===b.below_remain_life_thr&&1===b.remain_life_suppress&&0===b.remain_life_disable)||true===b.adv_modified||("normal"===b.smart_test&&1===b.smart_test_suppress&&0===b.smart_test_disable)){a+=_T("disk_info","disk_status_suppress_detail")+"<br><br>"}if("normal_repeat_suppress"===b.smart_info||(false===b.exceed_bad_sector_thr&&1<b.unc_suppress&&0===b.unc_disable)||(false===b.below_remain_life_thr&&1<b.remain_life_suppress&&0===b.remain_life_disable)||("normal"===b.smart_test&&1<b.smart_test_suppress&&0===b.smart_test_disable)){a+=_T("disk_info","disk_status_suppress_repeat_detail")+"<br><br>"}if("normal_disable"===b.smart_info||(false===b.exceed_bad_sector_thr&&0<b.unc_disable)||(false===b.below_remain_life_thr&&0<b.remain_life_disable)||("normal"===b.smart_test&&0<b.smart_test_disable)){a+=_T("disk_info","disk_status_disable_detail")+"<br><br>"}if(b.smartTest_support&&!b.scheduled){a+=_T("disk_info","disk_no_sched_smart_test_desc")+"<br><br>"}return a}});SYNO.SDS.StorageManager.monthOffset=0;SYNO.SDS.StorageManager.convertToMonth=function(a){var b=[_JSLIBSTR("extlang","jan").substr(0,3),_JSLIBSTR("extlang","feb").substr(0,3),_JSLIBSTR("extlang","mar").substr(0,3),_JSLIBSTR("extlang","apr").substr(0,3),_JSLIBSTR("extlang","may").substr(0,3),_JSLIBSTR("extlang","jun").substr(0,3),_JSLIBSTR("extlang","jul").substr(0,3),_JSLIBSTR("extlang","aug").substr(0,3),_JSLIBSTR("extlang","sep").substr(0,3),_JSLIBSTR("extlang","oct").substr(0,3),_JSLIBSTR("extlang","nov").substr(0,3),_JSLIBSTR("extlang","dec").substr(0,3)];return b[(a+SYNO.SDS.StorageManager.monthOffset)%12]};Ext.define("SYNO.SDS.StorageManager.HealthHistory",{extend:"SYNO.ux.Panel",constructor:function(a){var d=this;var c;var b=[];d.owner=a.owner;d.appWin=a.appWin;d.device=a.device;d.isHaPanel=a.isHaPanel;d.is_target_ha_passive=a.is_target_ha_passive;d.healthTestHistoryPanel=new SYNO.SDS.StorageManager.HealthTestHistory({appWin:d.appWin,device:d.device,isHaPanel:d.isHaPanel,is_target_ha_passive:d.is_target_ha_passive});b.push({xtype:"syno_fieldset",title:_T("disk_info","disk_health_test_history_title"),collapsible:true,collapsed:false,id:d.healthTestHistoryId=Ext.id(),items:d.healthTestHistoryPanel});d.smartInfoHistoryPanel=new SYNO.SDS.StorageManager.SmartInfoHistory({appWin:d.appWin});b.push({xtype:"syno_fieldset",title:_T("disk_info","disk_smart_info_history_title"),collapsible:true,collapsed:true,id:d.smartInfoHistoryId=Ext.id(),items:d.smartInfoHistoryPanel});c=Ext.apply({title:_T("disk_info","disk_history_title"),dsmStyle:"v5",autoFlexcroll:true,items:b,listeners:{activate:d.onActivate,scope:d}},a);d.callParent([c]);d.mon(d,"resize",function(f,e){var g=e-20;f.healthTestHistoryPanel.setWidth(g);f.smartInfoHistoryPanel.setWidth(g);f.smartInfoHistoryPanel.RemainLifePanel.setWidth(g);f.smartInfoHistoryPanel.UncPanel.setWidth(g);f.smartInfoHistoryPanel.RetryPanel.setWidth(g);f.smartInfoHistoryPanel.IdnfPanel.setWidth(g);f.smartInfoHistoryPanel.drawChart()},d);d.mon(Ext.getCmp(d.healthTestHistoryId),"expand",function(){d.smartInfoHistoryPanel.setVisible(false);Ext.getCmp(d.smartInfoHistoryId).collapse()});d.mon(Ext.getCmp(d.smartInfoHistoryId),"expand",function(){d.smartInfoHistoryPanel.setVisible(true);d.smartInfoHistoryPanel.drawChart();Ext.getCmp(d.healthTestHistoryId).collapse()},d);d.mon(Ext.getCmp(d.smartInfoHistoryId),"collapse",function(){d.smartInfoHistoryPanel.setVisible(false)},d)},onActivate:function(){var a=this;a.healthTestHistoryPanel.onActivate();a.smartInfoSupport=("no"===_D("support_dual_head","no")&&a.appWin.healthInfo.overview.isSataDisk);if(a.smartInfoSupport){Ext.getCmp(a.smartInfoHistoryId).setVisible(true);a.smartInfoHistoryPanel.onActivate()}else{Ext.getCmp(a.smartInfoHistoryId).setVisible(false)}}});Ext.define("SYNO.SDS.StorageManager.SmartInfoHistory",{extend:"SYNO.ux.Panel",constructor:function(a){this.chartData=null;this.appWin=a.appWin;var c={width:640,height:117,border:false,resizable:true};this.RemainLifePanel=new Ext.Panel(Ext.apply({id:this.remain_life_panel_id=Ext.id(),hidden:true},c));this.UncPanel=new Ext.Panel(c);this.RetryPanel=new Ext.Panel(c);this.IdnfPanel=new Ext.Panel(c);this.ModeCombo=new SYNO.ux.ComboBox({displayField:"display",valueField:"value",value:"single",width:150,listWidth:150,store:new Ext.data.ArrayStore({fields:["value","display"],data:[["single",_T("disk_info","disk_history_mode_sigle")],["incremental",_T("disk_info","disk_history_mode_incremental")]]}),listeners:{select:{scope:this,fn:this.modeChange}}});var b=Ext.apply({tbar:{cls:"sm-storage-overview-tbar",items:["->",this.ModeCombo]},items:[this.RemainLifePanel,{xtype:"syno_displayfield",id:this.remain_life_panel_typesetting_id=Ext.id(),hidden:true},this.UncPanel,{xtype:"syno_displayfield"},this.RetryPanel,{xtype:"syno_displayfield"},this.IdnfPanel]},a);this.callParent([b])},onActivate:function(a){if(!this.appWin.healthInfo||!this.appWin.healthInfo.history){this.appWin.getMsgBox().alert(_T("disk_info","disk_history_title"),_T("status","status_not_available"));return}this.chartData=this.appWin.healthInfo.history;this.displayData=this.chartData.single;SYNO.SDS.StorageManager.monthOffset=this.displayData.offset;this.drawChart()},modeChange:function(){var a=this.ModeCombo.value;this.displayData="incremental"==a?this.chartData.incremental:this.chartData.single;this.drawChart()},showRemainLifePanel:function(){if(-1!==this.appWin.healthInfo.overview.remain_life&&"incremental"==this.ModeCombo.value){Ext.getCmp(this.remain_life_panel_id).show();Ext.getCmp(this.remain_life_panel_typesetting_id).show()}else{Ext.getCmp(this.remain_life_panel_id).hide();Ext.getCmp(this.remain_life_panel_typesetting_id).hide()}},genTicks:function(){var a=[],b=0;for(b=0;b<12;b++){a.push([b+1,SYNO.SDS.StorageManager.convertToMonth(b)])}return a},genMouseTrack:function(b){var a=SYNO.SDS.StorageManager.convertToMonth(b.x-1)+": "+b.y;if(b.y<0){a+="<br>"+_T("disk_info","disk_history_unc_tooltip")}return a},getChartOpt:function(a){var b={};var c=a.type;b={lines:{show:("series"===c)?true:false},points:{show:("series"===c)?true:false},bars:{show:("bar"===c)?true:false,lineWidth:0,fillColor:"#0086e5",fillOpacity:1,barWidth:0.5},xaxis:{color:"#505a64",ticks:this.genTicks()},yaxis:{max:("series"===c)?100:undefined,min:("series"===c)?0:undefined,tickDecimals:0,color:"#505a64",autoscaleMargin:1},shadowSize:0,grid:{verticalLines:false,horizontalLines:true,color:"#b4bec8",tickColor:"#d7e1eb",outlineWidth:1,backgroundColor:"#f5faff"},mouse:{track:true,relative:true,trackDecimals:0,lineColor:null,trackFormatter:this.genMouseTrack},title:a.title,titleCls:"health-history-chart-title"};return b},getChartData:function(c,a){var d;function b(e){if("inc"==a){return"0"==e.y?"":e.y}else{return null===e.y?"":e.y}}d={data:c,markers:{show:true,position:"ct",labelFormatter:b}};return[d]},drawChart:function(){this.showRemainLifePanel();if(null===this.chartData||false===this.isVisible()){return}for(var a=0;a<this.displayData.remainLife.length;a++){if(-1==this.displayData.remainLife[a][1]){this.displayData.remainLife[a][1]=null}}if(Ext.getCmp(this.remain_life_panel_id).isVisible()){Flotr.draw(this.RemainLifePanel.body.dom,this.getChartData(this.displayData.remainLife,"desc"),this.getChartOpt({title:_T("disk_info","disk_remain_life"),type:"series"}))}Flotr.draw(this.UncPanel.body.dom,this.getChartData(this.displayData.retry,"inc"),this.getChartOpt({title:_T("disk_info","disk_retry_ct"),type:"bar"}));Flotr.draw(this.RetryPanel.body.dom,this.getChartData(this.displayData.unc,"inc"),this.getChartOpt({title:_T("disk_info","disk_bad_sector_ct"),type:"bar"}));Flotr.draw(this.IdnfPanel.body.dom,this.getChartData(this.displayData.idnf,"inc"),this.getChartOpt({title:_T("disk_info","disk_identify_failed_ct"),type:"bar"}));this.doLayout();this.appWin.doLayout()}});Ext.define("SYNO.SDS.StorageManager.HealthTestHistory",{extend:"SYNO.ux.Panel",constructor:function(a){var c=this;var d=[];c.appWin=a.appWin;c.device=a.device;c.isHaPanel=a.isHaPanel;c.is_target_ha_passive=a.is_target_ha_passive;c.pageSize=10;c.exportBtn=new SYNO.ux.SplitButton({text:_T("autoblock","autoblock_export_ip_list"),handler:c.onExportHtml,scope:c,menu:{items:[{text:_T("log","html_type"),handler:c.onExportHtml,scope:c},{text:_T("log","csv_type"),handler:c.onExportCSV,scope:c}]}});c.importBtn=new SYNO.ux.Button({text:_T("disk_info","import_previous_data"),handler:c.onImportLog,scope:c,hidden:true});c.ModeCombo=new SYNO.ux.ComboBox({displayField:"display",valueField:"value",value:"all",width:150,listWidth:150,store:new Ext.data.ArrayStore({fields:["value","display"],data:d}),listeners:{select:{scope:c,fn:c.modeChange}}});c.colModel=new Ext.grid.ColumnModel({defaults:{sortable:false},columns:[{header:_T("time","time_time"),dataIndex:"time"},{header:_T("report","report_type"),dataIndex:"displayType"},{header:_T("smart","smart_test_result"),dataIndex:"displayResult",renderer:function(e,g,f){if("ihm"===f.data.type&&"ihm_000"!==f.data.result){g.attr='ext:qtip="'+Ext.util.Format.htmlEncode(f.data.tooltip)+'"'}return e}}]});c.healthTestHistoryStore=c.createStore(a);c.gridPanel=new SYNO.ux.GridPanel({layout:"fit",colModel:c.colModel,store:c.healthTestHistoryStore,enableHdMenu:false,disableSelection:true,height:324});c.paging=new SYNO.ux.PagingToolbar({store:c.healthTestHistoryStore,pageSize:c.pageSize,displayInfo:true,showRefreshBtn:true});var b=Ext.apply({layout:"fit",tbar:{cls:"sm-storage-overview-tbar",items:[c.exportBtn,c.importBtn,"->",c.ModeCombo]},items:[c.gridPanel],bbar:c.paging},a);c.callParent([b])},onRefreshConfig:function(){var a=this;a.appWin.setStatusBusy();a.appWin.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",method:"get_disk_log",version:1,params:{type:"test"},scope:a,callback:function(e,c,d,b){a.appWin.clearStatusBusy();if(!e){a.appWin.getMsgBox().alert(_T("tree","node_device"),_T("common","error_system"));return}a.importBtn.setVisible(c.exist_previous_log)}}))},createStore:function(a){var b=this;var c=new SYNO.API.JsonStore({api:"SYNO.Core.Storage.Disk",version:"1",method:"disk_test_log_get",autoDestroy:true,remoteSort:true,appWindow:a.appWin,baseParams:{device:b.device,offset:0,limit:b.pageSize},sortInfo:{field:"time",direction:"DESC"},totalProperty:"total",root:"testLog",fields:["id","time","type","test_type","result",{name:"displayType",convert:function(e,d){return b.onRenderTestType(d.type,d.test_type)}},{name:"displayResult",convert:function(e,d){var f=SYNO.SDS.StorageUtils.DiskTestLogRender(d.result);if(!f){return""}if(""===f.code){return String.format('<span class="{0}">{1}</span>',f.color,f.text)}else{if("unknown"===f.code){return String.format('<span class="{0}">{1}. {2}</span>',f.color,d.test_code,f.text)}else{return String.format('<span class="{0}">{1}. {2}</span>',f.color,f.code,f.text)}}}},{name:"tooltip",convert:function(e,d){var f=SYNO.SDS.StorageUtils.DiskTestLogRender(d.result);if(!f){return""}return f.tooltip}}]});return c},onActivate:function(){var a=this;var b=[];b.push(["all",_T("common","show_all")],["smart",_T("smart","smart_toolbar_smart_test")]);if("not_support"!==a.appWin.healthInfo.overview.adv_status){b.push(["ihm",_T("disk_info","disk_ironwolf_test")])}a.ModeCombo.store.loadData(b);a.ModeCombo.setValue(a.ModeCombo.getStore().getAt(0).get("value"));a.mon(a.healthTestHistoryStore,"load",a.onAfterStoreLoad,a);a.mon(a.healthTestHistoryStore,"beforeload",a.onBeforeStoreLoad,a);Ext.apply(a.healthTestHistoryStore.baseParams,{type:a.ModeCombo.value});a.healthTestHistoryStore.load();a.onRefreshConfig()},modeChange:function(){var a=this;Ext.apply(a.healthTestHistoryStore.baseParams,{type:a.ModeCombo.value});a.healthTestHistoryStore.load()},onAfterStoreLoad:function(a,d,b){var c=this;c.appWin.clearStatusBusy()},onBeforeStoreLoad:function(a,b){var c=this;c.appWin.setStatusBusy()},onRenderTestType:function(b,c){var a="";if("smart"===b){if("quick"===c){a=_T("smart","smart_smart_quick_test")}else{if("extend"===c){a=_T("smart","smart_smart_extend_test")}else{a=_T("disk_info","disk_status_unknown")}}}else{if("ihm"===b){a=_T("disk_info","disk_ironwolf_test")}else{a=_T("disk_info","disk_status_unknown")}}return a},onExportHtml:function(){var a=this;a.onExport("html")},onExportCSV:function(){var a=this;a.onExport("csv")},onExport:function(a){var b=this;b.downloadWebAPI({webapi:SYNO.SDS.StorageUtils.ReplaceWebapiSHADownload(this.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",method:"export_test_log",version:1,params:{device:b.device,type:a,testType:b.ModeCombo.value}}),scope:b})},onImportLog:function(){var a=this;var b=new SYNO.SDS.StorageManager.Wizard.ImportLog(Ext.apply({appWin:a.appWin,owner:a.owner,parentNode:a,type:"test"}));a.mon(b,"close",function(){if(Ext.isFunction(b.hideFromOwner)){b.hideFromOwner()}if(b.isDataChanged){a.appWin.stopPollTask();a.appWin.setStatusBusy();a.appWin.cleanMask=true;a.appWin.startPollTask()}},a,{single:true});b.open()}});Ext.define("SYNO.SDS.StorageManager.SmartInfo",{extend:"SYNO.ux.Panel",constructor:function(a){this.owner=a.owner;this.appWin=a.appWin;var c;if(a.isNvme){c=this.configGridNvme({itemId:"grid"})}else{c=this.configGrid({itemId:"grid"})}var b=Ext.apply({title:_T("smart","smart_toolbar_smart_info"),autoFlexcroll:true,items:[{xtype:"syno_displayfield",value:_T("disk_info","disk_smart_info_desc")},c],listeners:{activate:this.onActivate,scope:this}},a);this.callParent([b]);this.mon(this,"resize",function(f,d,e){Ext.getCmp(f.smartInfoGridId).setWidth(d);f.onAdjustGridHeight()},this)},configGrid:function(a){var b=Ext.apply({layout:"fit",border:false,xtype:"syno_gridpanel",style:{marginTop:"8px"},columns:[{header:_T("smart","smart_id"),dataIndex:"id",width:50,sortable:false},{id:"name",header:_T("smart","smart_attribute"),dataIndex:"name",width:150,sortable:false},{header:_T("smart","smart_current"),dataIndex:"current",width:75,sortable:false},{header:_T("smart","smart_worst"),dataIndex:"worst",width:75,sortable:false},{header:_T("smart","smart_threshold"),dataIndex:"threshold",width:75,sortable:false},{header:_T("volume","volume_diskstatus"),dataIndex:"status",width:75,sortable:false,renderer:function(c,e,d){if(d.get("name")==="Airflow_Temperature_Cel"){if(d.get("status")==="In_the_past"){return c}}return"OK"===d.get("status")?c:'<font class="red-status"> '+c+" </font>"}},{header:_T("smart","smart_raw"),dataIndex:"raw",width:150,sortable:false}],viewConfig:{forceFit:true},enableHdMenu:false,autoExpandColumn:"name",sm:new Ext.grid.RowSelectionModel(),store:new Ext.data.JsonStore({root:"smartInfo",fields:["id","name","current","worst","threshold","status","raw"]}),id:this.smartInfoGridId=Ext.id()},a);return b},configGridNvme:function(a){var b=Ext.apply({layout:"fit",border:false,xtype:"syno_gridpanel",style:{marginTop:"8px"},columns:[{id:"name",header:_T("smart","smart_attribute"),dataIndex:"name",width:150,sortable:false},{header:_T("smart","smart_current"),dataIndex:"current",width:75,sortable:false},{header:_T("volume","volume_diskstatus"),dataIndex:"status",width:75,sortable:false,renderer:function(c,e,d){if(d.get("name")==="Airflow_Temperature_Cel"){if(d.get("status")==="In_the_past"){return c}}return"OK"===d.get("status")?c:'<font class="red-status"> '+c+" </font>"}}],viewConfig:{forceFit:true},enableHdMenu:false,autoExpandColumn:"name",sm:new Ext.grid.RowSelectionModel(),store:new Ext.data.JsonStore({root:"smartInfo",fields:["name","current","status"]}),id:this.smartInfoGridId=Ext.id()},a);return b},onActivate:function(){var a=this.getComponent("grid");var b;if(!this.appWin.healthInfo||!this.appWin.healthInfo.smartInfo||!this.appWin.healthInfo.overview){this.appWin.getMsgBox().alert(_T("smart","smart_toolbar_smart_info"),_T("status","status_not_available"));return}a.getStore().loadData(this.appWin.healthInfo);b=this.appWin.healthInfo.overview;this.onAdjustGridHeight()},onAdjustGridHeight:function(){var a=0;a=this.getHeight()-60;Ext.getCmp(this.smartInfoGridId).setHeight(a)}});Ext.define("SYNO.SDS.StorageManager.Wizard.TaskPanel",{extend:"SYNO.ux.EditorGridPanel",btnEdit:null,btnDel:null,btnRun:null,constructor:function(a){var b=this.fillConfig(a);this.callParent([Ext.apply(b,a)]);this.mon(this.getSelectionModel(),"selectionchange",this.onSelectionChange,this);this.btnEdit=this.getTopToolbar().getComponent("edit");this.btnDel=this.getTopToolbar().getComponent("delete");this.btnRun=this.getTopToolbar().getComponent("run");this.btnSave=this.getTopToolbar().getComponent("save");this.mon(this.enableColumn,"click",this.onChgSaveBtnStat,this);this.mon(this,"headerclick",this.onChgSaveBtnStat,this);this.loadData()},fillConfig:function(a){this.appWin=a.appWin;this.adv_support=false;for(var c=0;c<this.appWin.disks.count;c++){if("not_support"!==this.appWin.disks.dataArray[c].json.adv_status){this.adv_support=true;break}}this.enableColumn=new SYNO.ux.EnableColumn({header:_T("common","enabled"),dataIndex:"enabled",width:50,align:"center",enableFastSelectAll:true});this.columnModel=new Ext.grid.ColumnModel([this.enableColumn,{header:_T("localbkp","localbkp_bkpset_name"),dataIndex:"task_name",renderer:function(e){var d=Ext.util.Format.htmlEncode(e);return'<div ext:qtip="'+Ext.util.Format.htmlEncode(d)+'">'+d+"</div>"},sortable:true},{header:_T("common","action"),dataIndex:"action",renderer:function(d){return d.replace(/#(.*?):(.*?)#/g,function(e,g,f){return _T(g,f)})}},{header:_T("schedule","next_trigger_time"),dataIndex:"next_trigger_time",align:"center",sortable:true}]);this.taskStore=new SYNO.API.Store({api:"SYNO.Storage.CGI.Smart.Scheduler",method:"list",version:1,appWindow:this.appWin,reader:new Ext.data.JsonReader({root:"items",totalProperty:"total"},["enabled","id","can_run","task_name","app_name","simple_edit_form","edit_form","edit_app","action","next_trigger_time"]),sortInfo:{field:"id",direction:"ASC"},remoteSort:false,pruneModifiedRecords:true});this.toolbar=new Ext.Toolbar({defaultType:"syno_button"});this.toolbar.add({text:_T("common","create"),itemId:"create",handler:this.onCreate,scope:this},{text:_T("common","alt_edit"),itemId:"edit",disabled:true,handler:this.onEdit,scope:this},{text:_T("common","delete"),itemId:"delete",disabled:true,handler:this.onDelete,scope:this},{text:_T("common","save"),itemId:"save",disabled:true,handler:this.onSave,scope:this},{text:_T("common","run"),itemId:"run",disabled:true,handler:this.onRun,scope:this});var b={title:_T("schedule","task_scheduler"),header:false,cm:this.columnModel,ds:this.taskStore,height:225,tbar:this.toolbar,autoScroll:true,selModel:new Ext.grid.RowSelectionModel(),plugins:[this.enableColumn]};Ext.apply(b,a);return b},onChgSaveBtnStat:function(){this.setSaveButton(!_S("demo_mode")&&this.isDirty())},isDirty:function(){return this.getStore().getModifiedRecords().length>0},setSaveButton:function(a){this.btnSave[a?"enable":"disable"]()},onSelectionChange:function(){var b=this.getSelectionModel();var a=b.getCount();if(0<a){this.btnDel.enable();this.btnRun.enable()}else{this.btnDel.disable();this.btnRun.disable()}if(1==a){this.btnEdit.enable()}else{this.btnEdit.disable()}},loadData:function(){this.taskStore.removeAll();this.taskStore.load();this.onChgSaveBtnStat()},onOpenEditDialog:function(b){var a=new SYNO.SDS.StorageManager.Wizard.EditDialog({owner:this.owner,owner_grid:this,disks:this.owner.disks,schedule_id:b,basic_limitation:false,adv_support:this.adv_support,test_type:"all"});a.open()},onCreate:function(){this.onOpenEditDialog(-1)},onEdit:function(){var b=this.getSelectionModel();var a=b.getSelections();this.onOpenEditDialog(a[0].id)},onSave:function(){if(0===this.getStore().getModifiedRecords().length){return}this.btnSave.disable();var c=[];for(var a=0;a<this.getStore().getModifiedRecords().length;++a){c.push({id:this.getStore().getModifiedRecords()[a].data.id,enabled:this.getStore().getModifiedRecords()[a].data.enabled})}var b={tasks:c};this.getStore().commitChanges();this.owner.setStatusBusy();this.appWin.sendWebAPI({api:"SYNO.Storage.CGI.Smart.Scheduler",method:"change_state",version:1,params:b,scope:this,callback:function(e,d){this.loadData();this.owner.clearStatusBusy()}})},onDelete:function(){var c=this.getSelectionModel().getSelections();var a=[];var f=[];for(var e=0;e<c.length;e++){var b=c[e].data;a.push(b.task_name);f.push(b.id)}var d=new SYNO.SDS.StorageManager.Wizard.TaskPanel.DeleteTaskDialog({owner:this.owner,grid:this,tasks:a.join(", "),taskids:f});d.open()},onRun:function(){var c=this.getSelectionModel();var a=c.getSelections();var d=":";for(var b=0;b<a.length;++b){if(0!==b){d+=","}d+=" "+a[b].data.task_name}this.owner.getMsgBox().confirm(_T("schedule","run_task"),_T("schedule","confirm_run_task")+d,this.runTasks,this)},runTasks:function(c){if("no"===c){return}var d=this.getSelectionModel();var a=d.getSelections();var f=[];var b=0;for(b=0;b<a.length;++b){f.push(a[b].id)}var e={tasks:f};this.owner.setStatusBusy();this.appWin.sendWebAPI({api:"SYNO.Storage.CGI.Smart.Scheduler",method:"run",version:1,params:e,scope:this,callback:function(){this.loadData();this.owner.clearStatusBusy()}})}});Ext.define("SYNO.SDS.StorageManager.Wizard.TaskPanel.DeleteTaskDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){var a=this.fillConfig(b);this.deletetaskids=b.taskids;this.callParent([a])},fillConfig:function(b){var a={title:_T("schedule","title_dialog_delete"),closable:false,width:420,height:150,layout:"fit",items:[{xtype:"syno_formpanel",border:false,items:[{xtype:"syno_displayfield",htmlEncode:false,value:_T("schedule","confirm_delete_task")+"<br>"+b.tasks}]}],buttons:[{xtype:"syno_button",btnStyle:"red",text:_T("common","delete"),scope:this,handler:this.onOK},{xtype:"syno_button",btnStyle:"gray",text:_T("common","cancel"),scope:this,handler:this.close}]};return Ext.apply(a,b)},onOK:function(){var a={tasks:this.deletetaskids};this.setStatusBusy();this.sendWebAPI({api:"SYNO.Storage.CGI.Smart.Scheduler",method:"delete",version:1,params:a,scope:this,callback:function(){this.grid.loadData();this.clearStatusBusy()}});this.close()}});Ext.define("SYNO.SDS.StorageManager.Wizard.EditDialog",{extend:"SYNO.SDS.ModalWindow",EditPanelBasic:null,EditPanelSchedule:null,constructor:function(b){var a=this.fillConfig(b);this.callParent([a])},fillConfig:function(c){this.EditPanelBasic=new SYNO.SDS.StorageManager.Disk.Dialog.EditBasicPanel({owner:this,disks:c.disks,adv_support:c.adv_support,test_type:c.test_type});this.EditPanelSchedule=new SYNO.SDS.TaskScheduler2.EditSchedulePanel({needTitle:true});var b=new SYNO.ux.TabPanel({activeTab:0,height:420,items:[this.EditPanelBasic,this.EditPanelSchedule]});var a={title:(-1==c.schedule_id)?_T("schedule","create_task"):_T("schedule","edit_task"),width:550,minWidth:550,autoHeight:true,items:b,dsmStyle:"v5",buttons:[{text:_T("common","apply"),scope:this,btnStyle:"blue",handler:this.onClickOK},{text:_T("common","cancel"),scope:this,btnStyle:"gray",handler:this.onClickCancel}]};Ext.apply(a,c);return a},onClickOK:function(){if(!this.EditPanelBasic.isValid()||!this.EditPanelSchedule.isValid()){return}var a={basic:this.EditPanelBasic.getData(),schedule:this.EditPanelSchedule.getData(),app:this.EditPanelBasic.getData()};a.schedule=this.scheduleToOld(a.schedule);this.setStatusBusy();this.sendWebAPI({api:"SYNO.Storage.CGI.Smart.Scheduler",method:"set",version:1,params:a,scope:this,callback:this.applyDone})},applyDone:function(b,a){this.clearStatusBusy();this.owner_grid.loadData();if(null!==this.caller&&undefined!==this.caller){this.caller.onHealthInfoRefresh({device:this.caller.device})}this.close()},onClickCancel:function(){this.close()},onOpen:function(){this.loadTask(this.schedule_id);this.callParent(arguments)},loadTask:function(a){this.setStatusBusy();this.sendWebAPI({api:"SYNO.Storage.CGI.Smart.Scheduler",method:"get",version:1,params:{id:a},scope:this,callback:function(c,b){this.clearStatusBusy();if(!c){this.getMsgBox().alert(_T("schedule","load_task"),_T("schedule","load_task_error"),function(){this.close()},this);return}this.respTask=b.task[0];this.EditPanelBasic.setDataBasic(this.respTask.basic);this.EditPanelBasic.setDataApp(this.respTask.app);this.EditPanelSchedule.setData(this.scheduleToNew(this.respTask.schedule))}})},scheduleToNew:function(a){if(a.hasOwnProperty("week_name")){a.week_day=a.week_name;delete a.week_name}if(a.hasOwnProperty("repeat")){a.repeat_data=a.repeat;a.repeat_date=a.repeat;delete a.repeat}if(a.hasOwnProperty("min")){a.minute=a.min;delete a.min}return a},scheduleToOld:function(a){if(a.hasOwnProperty("week_day")){a.week_name=a.week_day;delete a.week_day}if(a.hasOwnProperty("repeat_data")){a.repeat=a.repeat_data;delete a.repeat_data}if(a.hasOwnProperty("minute")){a.min=a.minute;delete a.minute}if(a.hasOwnProperty("repeat_date")){a.repeat=a.repeat_date;delete a.repeat_date}return a}});Ext.define("SYNO.SDS.StorageManager.Disk.Dialog.EditBasicPanel",{extend:"SYNO.ux.FormPanel",constructor:function(b){this.owner=b.owner;this.disks=b.disks;this.adv_support=b.adv_support;this.test_type=b.test_type;var a=this.fillConfig(b);this.callParent([a]);this.mon(Ext.getCmp(this.selected_disks_id),"additem",this.diskStoreSort,this);this.mon(Ext.getCmp(this.selected_disks_id),"removeitem",this.diskStoreSort,this);this.mon(Ext.getCmp(this.selected_adv_disks_id),"additem",this.advDiskStoreSort,this);this.mon(Ext.getCmp(this.selected_adv_disks_id),"removeitem",this.advDiskStoreSort,this)},fillConfig:function(b){var c=this.displayNameGet.createDelegate(this);this.owner_store=new Ext.data.Store({reader:new Ext.data.JsonReader({root:"owner_store"},["display"])});this.disk_store=new Ext.data.Store({reader:new Ext.data.JsonReader({root:"disk_store"},[{name:"device",mapping:"device"},{name:"id",mapping:"id"},{name:"longName",convert:c},{name:"ctnOrder",mapping:"container.order"},{name:"numId",mapping:"num_id"},{name:"portType",mapping:"portType"},{name:"smart_test_limit",mapping:"smart_test_limit"}]),listeners:{load:this.onStoreLoad,scope:this}});this.adv_disk_store=new Ext.data.Store({reader:new Ext.data.JsonReader({root:"disk_store"},[{name:"device",mapping:"device"},{name:"id",mapping:"id"},{name:"longName",convert:c},{name:"ctnOrder",mapping:"container.order"},{name:"numId",mapping:"num_id"},{name:"portType",mapping:"portType"}])});var a={title:_T("schedule","basic_info"),items:[{xtype:"syno_fieldset",title:_T("vpnc","basic_setting"),items:[{xtype:"syno_radio",boxLabel:_T("smart","smart_name"),name:"test_type",id:this.test_type_smart_id=Ext.id(),inputValue:"smart",fieldLabel:_T("disk_info","disk_test_task_type"),hideLabel:false,listeners:{check:function(e,d){if(d){this.refreshPage("smart")}},scope:this}},{xtype:"syno_radio",boxLabel:_T("disk_info","disk_ironwolf_health"),name:"test_type",id:this.test_type_adv_id=Ext.id(),inputValue:"adv",hidden:true,fieldLabel:("adv"===this.test_type)?_T("disk_info","disk_test_task_type"):"",hideLabel:false,listeners:{check:function(e,d){if(d){this.refreshPage("adv")}},scope:this}},{xtype:"syno_radio",boxLabel:_T("schedule","event_all"),name:"test_type",id:this.test_type_all_id=Ext.id(),inputValue:"all",checked:true,hidden:true,hideLabel:false,listeners:{check:function(e,d){if(d){this.refreshPage("all")}},scope:this}},{xtype:"syno_textfield",allowBlank:false,emptyText:"Task name",id:this.task_name_id=Ext.id(),fieldLabel:_T("s2s","s2s_lbl_task_name"),name:"task_name",width:200,itemId:"task_name",validator:function(d){return d==Ext.util.Format.stripTags(d)}},{xtype:"hidden",name:"id"},{xtype:"syno_combobox",hidden:true,triggerAction:"all",width:200,id:this.task_owner_id=Ext.id(),listWidth:200,fieldLabel:_T("common","owner"),name:"owner",hiddenName:"owner",itemId:"owner",editable:false,valueField:"display",displayField:"display",disabled:true,mode:"local",store:this.owner_store},{xtype:"syno_checkbox",hidden:true,boxLabel:_T("common","enabled"),name:"enabled",itemId:"enabled"}]},{xtype:"syno_fieldset",title:_T("schedule","smart_schedule_type"),id:this.smart_test_type_id=Ext.id(),items:[{xtype:"syno_radio",boxLabel:_T("smart","smart_quick_test"),id:this.test_style_quick=Ext.id(),checked:true,name:"test_style",inputValue:"quick"},{xtype:"syno_radio",boxLabel:_T("smart","smart_extend_test"),id:this.test_style_extend=Ext.id(),name:"test_style",inputValue:"extend"}]},{xtype:"syno_fieldset",title:_T("schedule","smart_schedule_range"),id:this.test_range_id=Ext.id(),items:[{xtype:"syno_radio",boxLabel:_T("disk_info","disk_test_all_support_disk"),id:this.test_range_all=Ext.id(),name:"test_range",inputValue:"all",listeners:{check:function(e,d){if(d){Ext.getCmp(this.selected_disks_id).setDisabled(true)}else{Ext.getCmp(this.selected_disks_id).setDisabled(false)}},scope:this}},{xtype:"syno_radio",boxLabel:_T("schedule","smart_schedule_apply_sel"),id:this.test_range_sel=Ext.id(),name:"test_range",inputValue:"sel",scope:this},{xtype:"syno_superboxselect",hideLabel:true,fieldLabel:"",displayField:"longName",id:this.selected_disks_id=Ext.id(),resizable:true,valueField:"device",name:"selected_disks",triggerAction:"all",mode:"local",store:this.disk_store}]},{xtype:"syno_fieldset",title:_T("disk_info","disk_ironwolf_test"),id:this.test_adv_range_id=Ext.id(),items:[{xtype:"syno_radio",boxLabel:_T("disk_info","disk_adv_test_all_support_disk"),id:this.adv_test_range_all=Ext.id(),name:"adv_test_range",inputValue:"all",listeners:{check:function(e,d){if(d){Ext.getCmp(this.selected_adv_disks_id).setDisabled(true)}else{Ext.getCmp(this.selected_adv_disks_id).setDisabled(false)}},scope:this}},{xtype:"syno_radio",boxLabel:_T("schedule","smart_schedule_apply_sel"),id:this.adv_test_range_sel=Ext.id(),name:"adv_test_range",inputValue:"sel",scope:this},{xtype:"syno_superboxselect",hideLabel:true,fieldLabel:"",displayField:"longName",id:this.selected_adv_disks_id=Ext.id(),resizable:true,valueField:"device",name:"selected_adv_disks",triggerAction:"all",mode:"local",store:this.adv_disk_store}]}]};Ext.apply(a,b);return a},displayNameGet:function(c,a){var b=this.disks.getById(a.id);return SYNO.SDS.StorageUtils.DiskDisplayNameGet(b)},getData:function(){return this.getForm().getValues()},setDataBasic:function(a){this.owner_store.loadData(a);this.getForm().setValues(a)},setDataApp:function(c){var a=[];var b=c;if("smart"===this.test_type||!this.adv_support){Ext.getCmp(this.test_type_smart_id).setVisible(true);Ext.getCmp(this.test_type_adv_id).setVisible(false);Ext.getCmp(this.test_type_all_id).setVisible(false)}else{if("adv"===this.test_type){Ext.getCmp(this.test_type_smart_id).setVisible(false);Ext.getCmp(this.test_type_adv_id).setVisible(true);Ext.getCmp(this.test_type_all_id).setVisible(false)}else{Ext.getCmp(this.test_type_smart_id).setVisible(true);Ext.getCmp(this.test_type_adv_id).setVisible(true);Ext.getCmp(this.test_type_all_id).setVisible(true)}}if("extend"===c.test_style){Ext.getCmp(this.test_style_extend).setValue(true)}else{Ext.getCmp(this.test_style_quick).setValue(true)}if(Ext.getCmp(this.test_type_smart_id).isVisible()){this.disk_store.loadData(c);this.diskStoreSort()}if(Ext.getCmp(this.test_type_adv_id).isVisible()){Ext.each(c.disk_store,function(d){if("not_support"!==d.adv_status){a.push(d)}});b.disk_store=a;this.adv_disk_store.loadData(b);this.advDiskStoreSort()}this.refreshPage(c.test_type);if(c.selected_disks){Ext.getCmp(this.selected_disks_id).setValue(c.selected_disks)}if("all"===c.test_range){Ext.getCmp(this.test_range_all).setValue(true);Ext.getCmp(this.selected_disks_id).setDisabled(true)}else{Ext.getCmp(this.test_range_sel).setValue(true);Ext.getCmp(this.selected_disks_id).setDisabled(false)}if(c.selected_adv_disks){Ext.getCmp(this.selected_adv_disks_id).setValue(c.selected_adv_disks)}if("all"===c.adv_test_range){Ext.getCmp(this.adv_test_range_all).setValue(true);Ext.getCmp(this.selected_adv_disks_id).setDisabled(true)}else{Ext.getCmp(this.adv_test_range_sel).setValue(true);Ext.getCmp(this.selected_adv_disks_id).setDisabled(false)}},refreshPage:function(a){if(undefined===a){if("smart"===this.test_type||!this.adv_support){a="smart"}else{if("adv"===this.test_type){a="adv"}else{a="all"}}}if("smart"===a){Ext.getCmp(this.test_type_smart_id).setValue(true);Ext.getCmp(this.smart_test_type_id).setVisible(true);Ext.getCmp(this.test_range_id).setVisible(true);Ext.getCmp(this.test_range_all).setVisible(true);Ext.getCmp(this.test_range_sel).setVisible(true);Ext.getCmp(this.selected_disks_id).setVisible(true);Ext.getCmp(this.test_adv_range_id).setVisible(false);Ext.getCmp(this.adv_test_range_all).setVisible(false);Ext.getCmp(this.adv_test_range_sel).setVisible(false);Ext.getCmp(this.selected_adv_disks_id).setVisible(false)}else{if("adv"===a){Ext.getCmp(this.test_type_adv_id).setValue(true);Ext.getCmp(this.smart_test_type_id).setVisible(false);Ext.getCmp(this.test_range_id).setVisible(false);Ext.getCmp(this.test_range_all).setVisible(false);Ext.getCmp(this.test_range_sel).setVisible(false);Ext.getCmp(this.selected_disks_id).setVisible(false);Ext.getCmp(this.test_adv_range_id).setVisible(true);Ext.getCmp(this.adv_test_range_all).setVisible(true);Ext.getCmp(this.adv_test_range_sel).setVisible(true);Ext.getCmp(this.selected_adv_disks_id).setVisible(true)}else{if("all"===a){Ext.getCmp(this.test_type_all_id).setValue(true);Ext.getCmp(this.smart_test_type_id).setVisible(true);Ext.getCmp(this.test_range_id).setVisible(true);Ext.getCmp(this.test_range_all).setVisible(true);Ext.getCmp(this.test_range_sel).setVisible(true);Ext.getCmp(this.selected_disks_id).setVisible(true);Ext.getCmp(this.test_adv_range_id).setVisible(true);Ext.getCmp(this.adv_test_range_all).setVisible(true);Ext.getCmp(this.adv_test_range_sel).setVisible(true);Ext.getCmp(this.selected_adv_disks_id).setVisible(true)}}}this.doLayout()},isValid:function(){var b=this;var a=false;if(!Ext.getCmp(b.task_name_id).isValid()){a=true}if(Ext.getCmp(b.test_range_sel).getValue()&&Ext.getCmp(b.selected_disks_id).isVisible()&&""===Ext.getCmp(b.selected_disks_id).getValue()){Ext.getCmp(b.selected_disks_id).markInvalid(_T("volume","volume_add_warningnodisk"));a=true}if(Ext.getCmp(b.adv_test_range_sel).getValue()&&Ext.getCmp(b.selected_adv_disks_id).isVisible()&&""===Ext.getCmp(b.selected_adv_disks_id).getValue()){Ext.getCmp(b.selected_adv_disks_id).markInvalid(_T("volume","volume_add_warningnodisk"));a=true}if(a){b.owner.setStatusError({text:_T("error","error_bad_field"),clear:true});return false}else{return true}},diskStoreSort:function(){this.disk_store.sort([{field:"ctnOrder",direction:"ASC"},{field:"portType",direction:"DESC"},{field:"numId",direction:"ASC"}],"ASC")},advDiskStoreSort:function(){this.adv_disk_store.sort([{field:"ctnOrder",direction:"ASC"},{field:"portType",direction:"DESC"},{field:"numId",direction:"ASC"}],"ASC")},onStoreLoad:function(b,a){b.filterBy(function(c){if(!c.get("smart_test_limit")){return true}else{return false}});delete b.snapshot}});Ext.define("SYNO.SDS.StorageManager.Wizard.SecureErase",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this,b;c.device=a.device;c.owner=a.owner;c.appWin=a.appWin;c.is_target_ha_passive=a.is_target_ha_passive;b=Ext.apply({title:_T("disk_info","disk_secure_erase"),width:550,height:350,minWidth:550,minHeight:350,dsmStyle:"v5",layout:"fit",items:[{xtype:"syno_formpanel",border:false,items:[{xtype:"syno_displayfield",htmlEncode:false,value:String.format(_T("disk_info","disk_secure_erase_desc"),a.erase_time)},{xtype:"syno_checkbox",htmlEncode:false,boxLabel:String.format('<span class="red-status">{0}</span>',_T("disk_info","disk_secure_erase_confirm")),listeners:{check:{scope:this,fn:this.onCheckboxCheck}}}]}],buttons:[{text:_T("common","delete"),itemId:"delete",scope:this,disabled:true,btnStyle:"red",handler:this.onClickDel},{text:_T("common","cancel"),scope:this,btnStyle:"gray",handler:this.onClickCancel}]},a);c.callParent([b])},onClickDel:function(){var a=this;SYNO.SDS.Utils.PasswordConfirmDialog.openDialog(a,a.onSecureEraseCheck)},onClickCancel:function(){this.close()},onCheckboxCheck:function(c,b){var a=this.getFooterToolbar().getComponent("delete");a.setDisabled(!b)},onSecureEraseCheck:function(){var a={device:this.device};this.setStatusBusy();this.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Storage.CGI.Smart",method:"secure_erase",version:1,params:a,scope:this,callback:function(d,c){var b=function(){this.clearStatusBusy();this.close()}.createDelegate(this);this.isDataChanged=true;setTimeout(b,1000)}}))}});Ext.define("SYNO.SDS.StorageManager.Wizard.DiskDeactivate",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this,b;c.device_name=a.device_name;c.device=a.device;c.owner=a.owner;c.appWin=a.appWin;b=Ext.apply({title:_T("disk_info","deactivate_disk_title"),width:550,height:257,minWidth:550,minHeight:257,dsmStyle:"v5",layout:"fit",items:[{xtype:"syno_formpanel",border:false,items:[{xtype:"syno_displayfield",htmlEncode:false,value:String.format(_T("disk_info","deactivate_disk_note"),a.device_name)},{xtype:"syno_checkbox",htmlEncode:false,boxLabel:String.format('<span class="red-status">{0}</span>',_T("disk_info","deactivate_disk_checkbox_confirm")),listeners:{check:{scope:this,fn:this.onCheckboxCheck}}}]}],buttons:[{text:_T("common","apply"),itemId:"apply",scope:this,disabled:true,btnStyle:"red",handler:this.onClickApply},{text:_T("common","cancel"),scope:this,btnStyle:"gray",handler:this.onClickCancel}]},a);c.callParent([b])},onClickApply:function(){var a=this;SYNO.SDS.Utils.PasswordConfirmDialog.openDialog(a,a.onActionConfirmed)},onClickCancel:function(){this.close()},onCheckboxCheck:function(c,b){var a=this.getFooterToolbar().getComponent("apply");a.setDisabled(!b)},onActionConfirmed:function(){this.setStatusBusy();this.sendWebAPI({api:"SYNO.Core.Storage.Disk",method:"deactivate_disk",version:1,params:{device:this.device},scope:this,callback:function(c,b){var a=function(){this.clearStatusBusy();this.close();if(c){this.appWin.getMsgBox().alert("",_T("disk_info","deactivate_disk_notice_complete"))}}.createDelegate(this);this.isDataChanged=true;setTimeout(a,1000)}})}});Ext.define("SYNO.SDS.StorageManager.Wizard.Benchmark",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this,b;c.owner=a.owner;c.appWin=a.appWin;c.disks=a.disks;c.selectIdx=a.selectIdx;c.pollingId=undefined;c.processing=false;c.otherTesting=false;c.diskPerf=new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">','<div class="sm-disk-perf-status">','<div id="prev-btn-id"></div>','<div class="sm-disk-perf-disk-icon"></div>','<div class="sm-disk-perf-textarea">','<div class="sm-disk-perf-title">{text}</div>','<div class="sm-disk-perf-desc">',"{diskVendor} {diskModel}</br>",'<div class="sm-disk-perf-desc-label">{latestLabel}:</div>{latestValue}</br>','<div class="sm-disk-perf-desc-label">{compareLabel}:</div>{compareValue}</br>','<div class="sm-disk-perf-desc-label">{typeLabel}:</div>{typeValue}</br>',"</div>",'<div id="run-test-btn-id"></div>',"</div>",'<div id="next-btn-id"></div>',"</div>","</tpl>"),store:c.perfStore=new Ext.data.JsonStore({autoDestroy:true,fields:["text","latestLabel","latestValue","compareLabel","compareValue","typeLabel","typeValue","diskVendor","diskModel"]})});var d='<div class="sm-disk-perf-result-box-{position}"><div class="sm-disk-perf-result-box-title">{title}</div><div class="sm-disk-perf-result-box-content"><div class="sm-disk-perf-result-box-content-value sm-disk-perf-result-box-content-value-{contentStatus}" data-unit="{unit}">{value}</div></div><div class="sm-disk-perf-result-box-status"><div class="sm-disk-perf-result-box-status-icon sm-disk-perf-result-box-status-icon-{direction}-{status}"></div><div class="sm-disk-perf-result-box-status-value sm-disk-perf-result-box-status-value-{status}">{comparison}</div></div></div>';c.diskPerfResult=new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">','<div class="sm-disk-perf-fieldset">{readTitle}</div>','<div class="sm-disk-perf-result-box" style="margin-bottom: 16px;">','<tpl for="diskReadPerf">',d,"</tpl>","</div>",'<div class="sm-disk-perf-fieldset">{writeTitle}</div>','<div class="sm-disk-perf-tip" ext:qtip="{writeInfo}"></div>','<div class="sm-disk-perf-result-box" style="margin-bottom: 20px;">','<tpl for="diskWritePerf">',d,"</tpl>","</div>","</tpl>"),store:c.perfResultStore=new Ext.data.JsonStore({autoDestroy:true,fields:["readTitle","writeTitle","writeInfo","diskReadPerf","diskWritePerf"]})});b=Ext.apply({title:_T("disk_info","disk_perf_benchmark"),width:644,height:576,minWidth:644,minHeight:576,dsmStyle:"v5",layout:"fit",resizable:false,items:[{xtype:"syno_formpanel",trackResetOnLoad:true,border:false,items:[c.diskPerf,c.diskPerfResult]}],buttons:[{text:_T("common","alt_close"),handler:c.close,scope:c}],listeners:{beforedestroy:c.pollingTaskStop,scope:c}},a);c.callParent([b])},onOpen:function(){var b=this;for(var a=0;a<b.disks.length;a++){b.disks[a].selectCompareLog=false;b.disks[a].selectIdx=-1;b.disks[a].compareLog={time:"-",testType:"-",readIopsValue:0,readBwValue:0,readBwUnit:"",readLatencyValue:0,readLatencyUnit:"",writeIopsValue:0,writeBwValue:0,writeBwUnit:"",writeLatencyValue:0,writeLatencyUnit:""}}b.pollingTaskStart();b.onUpdateStore();b.callParent(arguments)},onUpdatePerfStore:function(){var d=this,f={},a=[],e={},c=d.perfHistoryStore.getCount(),b=0;d.latestLog={time:"-",testType:"-",readIopsValue:0,readBwValue:0,readBwUnit:"",readLatencyValue:0,readLatencyUnit:"",writeIopsValue:0,writeBwValue:0,writeBwUnit:"",writeLatencyValue:0,writeLatencyUnit:""};if(0<c){e=d.perfHistoryStore.getAt(c-1);d.latestLog=e.data}if(d.disks[d.selectIdx].selectCompareLog&&d.disks[d.selectIdx].compareLog.testType!=d.latestLog.testType){d.disks[d.selectIdx].selectCompareLog=false;d.disks[d.selectIdx].selectIdx=-1;d.disks[d.selectIdx].compareLog={time:"-",testType:"-",readIopsValue:0,readBwValue:0,readBwUnit:"",readLatencyValue:0,readLatencyUnit:"",writeIopsValue:0,writeBwValue:0,writeBwUnit:"",writeLatencyValue:0,writeLatencyUnit:""}}if(!d.disks[d.selectIdx].selectCompareLog){for(b=c-2;b>=0;b--){e=d.perfHistoryStore.getAt(b);if(e.data.testType===d.latestLog.testType){d.disks[d.selectIdx].compareLog=e.data;d.disks[d.selectIdx].selectCompareLog=true;d.disks[d.selectIdx].selectIdx=b;break}}}d.testType=(c)?d.latestLog.testType:"-";if("internal"===d.disks[d.selectIdx].diskContainer.type){f.text=d.disks[d.selectIdx].diskName+" ("+d.disks[d.selectIdx].diskContainer.str+")"}else{f.text=d.disks[d.selectIdx].diskName}f.latestLabel=_T("disk_info","disk_perf_latest_test");f.latestValue=(c)?d.latestLog.time:"-";f.compareLabel=_T("disk_info","disk_perf_compare_with");d.compareValueId=Ext.id();f.compareValue=(!d.disks[d.selectIdx].selectCompareLog)?"-":(d.disks[d.selectIdx].compareLog.time+' (<a id="'+d.compareValueId+'" class="link-font" href="#" style="font-weight: normal;">'+_T("common","choose")+"</a>)");f.typeLabel=_T("disk_info","disk_perf_test_type");f.typeValue=d.testType;f.diskVendor=d.disks[d.selectIdx].vendor;f.diskModel=d.disks[d.selectIdx].model;a.push(f);d.perfStore.loadData(a)},onUpdatePerfResultStore:function(){var b=this,c={},a=[];c.readTitle=_T("disk_info","disk_perf_read_performance");c.writeTitle=_T("disk_info","disk_perf_write_performance");c.writeInfo=_T("disk_info","disk_perf_write_performance_info");c.diskReadPerf=[];if(b.processing){c.diskReadPerf.push(b.onRenderResultBoxWithoutValue("left",_T("rsrcmonitor","iops"),"processing"));c.diskReadPerf.push(b.onRenderResultBoxWithoutValue("center",_T("rsrcmonitor","throughput"),"processing"));c.diskReadPerf.push(b.onRenderResultBoxWithoutValue("right",_T("rsrcmonitor","latency"),"processing"))}else{c.diskReadPerf.push(b.onRenderResultBox("left",_T("rsrcmonitor","iops"),b.latestLog.readIopsValue,"",b.disks[b.selectIdx].compareLog.readIopsValue,""));c.diskReadPerf.push(b.onRenderResultBox("center",_T("rsrcmonitor","throughput"),b.latestLog.readBwValue,b.latestLog.readBwUnit,b.disks[b.selectIdx].compareLog.readBwValue,b.disks[b.selectIdx].compareLog.readBwUnit));c.diskReadPerf.push(b.onRenderResultBox("right",_T("rsrcmonitor","latency"),b.latestLog.readLatencyValue,b.latestLog.readLatencyUnit,b.disks[b.selectIdx].compareLog.readLatencyValue,b.disks[b.selectIdx].compareLog.readLatencyUnit))}c.diskWritePerf=[];if(b.processing){c.diskWritePerf.push(b.onRenderResultBoxWithoutValue("left",_T("rsrcmonitor","iops"),"processing"));c.diskWritePerf.push(b.onRenderResultBoxWithoutValue("center",_T("rsrcmonitor","throughput"),"processing"));c.diskWritePerf.push(b.onRenderResultBoxWithoutValue("right",_T("rsrcmonitor","latency"),"processing"))}else{c.diskWritePerf.push(b.onRenderResultBox("left",_T("rsrcmonitor","iops"),b.latestLog.writeIopsValue,"",b.disks[b.selectIdx].compareLog.writeIopsValue,""));c.diskWritePerf.push(b.onRenderResultBox("center",_T("rsrcmonitor","throughput"),b.latestLog.writeBwValue,b.latestLog.writeBwUnit,b.disks[b.selectIdx].compareLog.writeBwValue,b.disks[b.selectIdx].compareLog.writeBwUnit));c.diskWritePerf.push(b.onRenderResultBox("right",_T("rsrcmonitor","latency"),b.latestLog.writeLatencyValue,b.latestLog.writeLatencyUnit,b.disks[b.selectIdx].compareLog.writeLatencyValue,b.disks[b.selectIdx].compareLog.writeLatencyUnit))}a.push(c);b.perfResultStore.loadData(a)},onRenderResultBoxWithoutValue:function(a,d,b){var c={};switch(b){case"processing":c={position:a,title:d,contentStatus:b,unit:"",value:"",status:"",direction:"",comparison:""};break;case"na":c={position:a,title:d,contentStatus:b,unit:"",value:"N/A",status:"",direction:"",comparison:""};break;case"no":c={position:a,title:d,contentStatus:b,unit:"",value:"--",status:"",direction:"",comparison:""};break;default:break}return c},onRenderResultBox:function(d,h,i,k,a,j){var f=this,l="",g="",c="",b="",e={};if(!Number(i)){return f.onRenderResultBoxWithoutValue(d,h,"na")}if(k!=j){if("MB/s"===k){i*=1024;k="KB/s"}else{if("MB/s"===j){a*=1024;j="KB/s"}else{if("ms"===k){i*=1000;k="us"}else{if("ms"===j){a*=1000;j="us"}}}}}b="normal";if(Number(a)){l=f.onRenderValueToOneDecimal((i-a)/a*100);if(0>l){g="down";c=(_T("rsrcmonitor","latency")==h)?"good":"bad"}else{if(0<l){g="up";c=(_T("rsrcmonitor","latency")==h)?"bad":"good"}else{g="normal";c="normal"}}l=Math.abs(l);if(SYNO.SDS.StorageManager.Disk.COMPARE_WARN_THRESHOLD<=l){b=c}l+="%"}else{c="normal"}e=f.onRenderValueAndUnit(i,k);return{position:d,title:h,contentStatus:b,unit:e.unit,value:e.value,status:c,direction:g,comparison:l}},onRenderValueAndUnit:function(c,b){var a=this;if(1024<c&&"KB/s"===b){c/=1024;b="MB/s"}else{if(1000<c&&"us"===b){c/=1000;b="ms"}}switch(b){case"MB/s":case"KB/s":c=a.onRenderValueToInt(c);break;case"ms":case"us":c=a.onRenderValueToOneDecimal(c);break;default:break}c=a.onRenderMilliFormat(c);return{value:c,unit:b}},onRenderValueToOneDecimal:function(a){return(Math.round(a*Math.pow(10,1))/Math.pow(10,1)).toFixed(1)},onRenderValueToInt:function(a){return Math.round(a)},onRenderMilliFormat:function(a){return a&&a.toString().replace(/^\d+/g,function(b){return b.replace(/(?=(?!^)(\d{3})+$)/g,",")})},onRenderButton:function(){var a=this;if(0<a.selectIdx){a.prevBtn=new Ext.Container({cls:"sm-disk-perf-prev-btn",id:a.prevBtnId=Ext.id(),renderTo:"prev-btn-id"});Ext.get(a.prevBtnId).addListener("click",function(b,c){a.onChangeDisk(false)},a)}if(a.disks.length-1>a.selectIdx){a.nextBtn=new Ext.Container({cls:"sm-disk-perf-next-btn",id:a.nextBtnId=Ext.id(),renderTo:"next-btn-id"});Ext.get(a.nextBtnId).addListener("click",function(b,c){a.onChangeDisk(true)},a)}if(a.disks[a.selectIdx].selectCompareLog){Ext.get(a.compareValueId).addListener("click",function(b,c){a.onOpenHistoryWizard()},a)}a.runTestBtn=new SYNO.ux.Button({id:a.runTestBtnId=Ext.id(),text:_T("disk_info","disk_perf_run_test_now"),handler:function(){a.onHandleTest()},renderTo:"run-test-btn-id",scope:a});if(a.processing){Ext.getCmp(a.runTestBtnId).setText(_T("disk_info","disk_perf_stop_test"))}else{Ext.getCmp(a.runTestBtnId).setText(_T("disk_info","disk_perf_run_test_now"))}if(a.otherTesting){Ext.getCmp(a.runTestBtnId).setDisabled(true);Ext.getCmp(a.runTestBtnId).setTooltip(_T("disk_info","other_is_testing"))}else{Ext.getCmp(a.runTestBtnId).setDisabled(false);Ext.getCmp(a.runTestBtnId).setTooltip("")}},onChangeDisk:function(a){var b=this;if((a&&b.disks.length-1<=b.selectIdx)||(!a&&0>=b.selectIdx)){return}if(a){b.selectIdx++}else{b.selectIdx--}b.pollingTaskStop();b.onUpdateStore();b.pollingTaskStart()},onHandleTest:function(){var a=this;if(_T("disk_info","disk_perf_run_test_now")===Ext.getCmp(a.runTestBtnId).getText()){a.setStatusBusy();a.sendWebAPI({api:"SYNO.Core.Storage.Disk",method:"get_performance_test_info",version:1,params:{device:a.disks[a.selectIdx].device,spare:a.disks[a.selectIdx].spare},scope:a,callback:function(c,b){a.clearStatusBusy();if(!c){SYNO.Debug.error("Failed to get performance num",b);return}if(SYNO.SDS.StorageManager.Disk.DISK_PERF_NUM_THRESHOLD<=b.num){a.getMsgBox().alert("",String.format(_T("disk_info","disk_perf_system_busy_warn"),SYNO.SDS.StorageManager.Disk.DISK_PERF_NUM_THRESHOLD));return}else{a.startPerfTest(b.type)}}})}else{a.stopPerfTest()}},pollingTaskStart:function(){var a=this;if(a.pollingId){return}a.pollingId=a.pollReg({webapi:{api:"SYNO.Core.Storage.Disk",method:"get_performance_test_status",version:1,params:{device:a.disks[a.selectIdx].device}},interval:60,immediate:true,scope:a,status_callback:function(e,d,c,b){if(!e){SYNO.Debug.error("Get performance status error",d);return}if("processing"!==d.status){a.processing=false;a.pollingTaskStop()}else{a.processing=true}if(d.smart_testing||d.ihm_testing||d.is_erasing){a.otherTesting=true}else{a.otherTesting=false}a.onUpdateStore()}})},pollingTaskStop:function(){var a=this;if(a.pollingId){a.pollUnreg(a.pollingId);a.pollingId=undefined;a.processing=false}},startPerfTest:function(a){var b=this;b.setStatusBusy();b.sendWebAPI({api:"SYNO.Core.System.Utilization",method:"get",version:1,params:{type:"current",resource:["disk"]},scope:b,callback:function(h,g){b.clearStatusBusy();if(!h){SYNO.Debug.error("Failed to get utilization",g);return}var c=b.disks[b.selectIdx].device.replace("/dev/","");var f={yes:{text:_T("disk_info","disk_perf_do_test_continue"),btnStyle:"grey"},no:{text:Ext.MessageBox.buttonText.no,btnStyle:"blue"}};var d=0,e=-1;for(d=0;d<g.disk.disk.length;d++){if(c==g.disk.disk[d].device){e=g.disk.disk[d].utilization;break}}if(0>e){SYNO.Debug.error("Failed to get utilization of "+b.disks[b.selectIdx].device);return}if(SYNO.SDS.StorageManager.Disk.UTILIZATION_THRESHOLD<e){b.getMsgBox({btnStyle:"grey"}).confirm(_T("disk_info","disk_perf_do_test_warn_title"),String.format(_T("disk_info","disk_perf_do_test_warn_info"),e,SYNO.SDS.StorageManager.Disk.UTILIZATION_THRESHOLD),function(i){if("yes"===i){b.confirmPerfTest(e,a)}},b,f)}else{b.confirmPerfTest(e,a)}}})},confirmPerfTest:function(d,a){var c=this;if("quick"===a){c.doPerfTest(d,a)}else{var b={yes:{text:_T("disk_info","disk_perf_do_test_continue"),btnStyle:"red"},no:{text:Ext.MessageBox.buttonText.no}};c.getMsgBox().confirm("",_T("disk_info","disk_perf_confirm_full_test_text"),function(e){var f=this;if("yes"===e){SYNO.SDS.Utils.PasswordConfirmDialog.openDialog(f,f.doPerfTest,[d,a])}},c,b)}},doPerfTest:function(c,a){var b=this;b.setStatusBusy();b.sendWebAPI({api:"SYNO.Core.Storage.Disk",method:"do_performance_test",version:1,params:{device:b.disks[b.selectIdx].device,type:a,isSsdAlone:b.disks[b.selectIdx].isSsdAlone,utilization:c},scope:b,callback:function(e,d){b.clearStatusBusy();if(!e){if(SYNO.SDS.StorageManager.Disk.ERR_DISK_IN_USE===d.code){b.getMsgBox().alert("",_T("disk_info","disk_perf_do_test_warn_title"));return}SYNO.Debug.error("Failed to do performance test",d);return}Ext.getCmp(b.runTestBtnId).setText(_T("disk_info","disk_perf_stop_test"));b.pollingTaskStart();b.onUpdateStore()}})},stopPerfTest:function(){var a=this;a.setStatusBusy();a.sendWebAPI({api:"SYNO.Core.Storage.Disk",method:"stop_performance_test",version:1,params:{device:a.disks[a.selectIdx].device},scope:a,callback:function(c,b){a.clearStatusBusy();if(!c){SYNO.Debug.error("Failed to stop performance test",b);return}Ext.getCmp(a.runTestBtnId).setText(_T("disk_info","disk_perf_run_test_now"));a.pollingTaskStop();a.onUpdateStore()}})},onOpenHistoryWizard:function(){var a=this,b=new SYNO.SDS.StorageManager.Wizard.PerfHistory({owner:a,appWin:a,testType:a.testType,perfHistoryStore:a.perfHistoryStore,latestLog:a.latestLog,selectIdx:a.disks[a.selectIdx].selectIdx});a.mon(b,"close",function(){if(!b.isSelected){return}a.disks[a.selectIdx].compareLog=b.compareLog;a.disks[a.selectIdx].selectCompareLog=true;a.disks[a.selectIdx].selectIdx=b.selectIdx;a.onUpdateStore()},a,{single:true});b.open()},onUpdateStore:function(){var a=this,b={model:a.disks[a.selectIdx].model,serial:a.disks[a.selectIdx].serial};a.setStatusBusy();a.sendWebAPI({api:"SYNO.Core.Storage.Disk",method:"get_performance_test_log",version:1,params:b,scope:a,callback:function(d,c){a.clearStatusBusy();if(!d){SYNO.Debug.error("Failed to get performance test log",c);return}a.onUpdatePerfHistoryStore(c.diskPerfLog);a.onUpdatePerfStore();a.onUpdatePerfResultStore();a.onRenderButton()}})},onUpdatePerfHistoryStore:function(b){var a=this;if(a.perfHistoryStore){a.perfHistoryStore.destroy()}a.perfHistoryStore=new SYNO.SDS.StorageManager.Disk.PerfHistoryStore();delete a.perfLogs;a.perfLogs=[];Ext.each(b,function(c){var d={};d.time=c.time;d.testType="quick"===c.type?_T("disk_info","disk_perf_test_type_basic"):_T("disk_info","disk_perf_test_type_full");d.readIopsValue=c.read.iops;d.readIops=a.onRenderMilliFormat(c.read.iops);d.readBwValue=a.onRenderValueToInt(c.read.bw);d.readBwUnit=c.read.bw_unit;d.readBw=a.onRenderMilliFormat(d.readBwValue)+d.readBwUnit;d.readLatencyValue=a.onRenderValueToOneDecimal(c.read.latency);d.readLatencyUnit=c.read.latency_unit;d.readLatency=a.onRenderMilliFormat(d.readLatencyValue)+d.readLatencyUnit;d.writeIopsValue=c.write.iops;d.writeIops=(d.writeIopsValue)?a.onRenderMilliFormat(d.writeIopsValue):"-";d.writeBwValue=a.onRenderValueToInt(c.write.bw);d.writeBwUnit=c.write.bw_unit;d.writeBw=(d.writeBwUnit)?a.onRenderMilliFormat(d.writeBwValue)+d.writeBwUnit:"-";d.writeLatencyValue=a.onRenderValueToOneDecimal(c.write.latency);d.writeLatencyUnit=c.write.latency_unit;d.writeLatency=(d.writeLatencyUnit)?a.onRenderMilliFormat(d.writeLatencyValue)+d.writeLatencyUnit:"-";a.perfLogs.push(d)});a.perfHistoryStore.loadData(a.perfLogs)}});Ext.define("SYNO.SDS.StorageManager.Wizard.PerfHistory",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this,b;c.owner=a.owner;c.appWin=a.appWin;c.testType=a.testType;c.perfHistoryStore=a.perfHistoryStore;c.latestLog=a.latestLog;c.selectIdx=a.selectIdx;c.isSelected=false;c.colModel=new Ext.grid.ColumnModel({defaults:{sortable:true},columns:[{header:_T("time","time_time"),dataIndex:"time",width:140},{header:_T("rsrcmonitor","read"),dataIndex:"readIops",width:70},{header:_T("rsrcmonitor","write"),dataIndex:"writeIops",width:70},{header:_T("rsrcmonitor","read"),dataIndex:"readBw",width:70},{header:_T("rsrcmonitor","write"),dataIndex:"writeBw",width:70},{header:_T("rsrcmonitor","read"),dataIndex:"readLatency",width:70},{header:_T("rsrcmonitor","write"),dataIndex:"writeLatency",width:70},{header:_T("disk_info","disk_perf_test_type"),dataIndex:"testType",width:70}]});c.selModel=new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{selectionchange:c.onSelectionChange,scope:c}});c.gridPanel=new SYNO.ux.GridPanel({layout:"fit",colModel:c.colModel,selModel:c.selModel,store:c.perfHistoryStore,plugins:[new SYNO.ux.plugin.GroupHeaderGrid({groups:[{header:_T("rsrcmonitor","iops"),dataIndex:["readIops","writeIops"]},{header:_T("rsrcmonitor","throughput"),dataIndex:["readBw","writeBw"]},{header:_T("rsrcmonitor","latency"),dataIndex:["readLatency","writeLatency"]}]})]});b=Ext.apply({title:_T("disk_info","disk_perf_choose_title"),width:800,height:400,minWidth:800,minHeight:400,dsmStyle:"v5",layout:"fit",items:[c.gridPanel],buttons:[{text:_T("common","apply"),scope:c,disabled:true,id:c.applySelectId=Ext.id(),handler:c.onApply,btnStyle:"blue"},{text:_T("common","close"),scope:c,handler:c.close}],listeners:{scope:c,afterlayout:c.onAfterlayout}},a);c.callParent([b])},onAfterlayout:function(){var a=this;a.gridPanel.view.updateScroller();a.gridPanel.getSelectionModel().selectRow(a.selectIdx)},onApply:function(){var a=this;if(a.compareLog.testType!=a.testType){a.getMsgBox().alert("",_T("disk_info","disk_perf_diff_type_warn"));return}if(a.latestLog.time==a.compareLog.time){a.getMsgBox().alert("",_T("disk_info","disk_perf_same_log_warn"));return}a.isSelected=true;a.close()},onSelectionChange:function(){var b=this,a=b.selModel.getSelected();if(undefined===a){Ext.getCmp(b.applySelectId).setDisabled(true);return}b.selectIdx=b.gridPanel.store.indexOf(a);b.compareLog=a.data;Ext.getCmp(b.applySelectId).setDisabled(false)}});Ext.define("SYNO.SDS.StorageManager.Disk.PerfHistoryStore",{extend:"Ext.data.JsonStore",constructor:function(a){var c=this;var b={idProperty:"time",fields:["time","testType","readIops","readIopsValue","writeIops","writeIopsValue","readBw","readBwValue","readBwUnit","writeBw","writeBwValue","writeBwUnit","readLatency","readLatencyValue","readLatencyUnit","writeLatency","writeLatencyValue","writeLatencyUnit"]};c.callParent([Ext.apply(b,a)])}});Ext.define("SYNO.SDS.StorageManager.Disk.AdvHistoryStore",{extend:"Ext.data.JsonStore",constructor:function(a){var c=this;var b={autoDestroy:true,idProperty:"id",fields:["id","time","result"]};c.callParent([Ext.apply(b,a)])}});Ext.define("SYNO.SDS.StorageManager.Wizard.SmartWarning",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){var d=this;var c;var a=[];d.device=b.device;d.owner=b.owner;d.appWin=b.appWin;a.push({xtype:"syno_combobox",id:d.typeId=Ext.id(),displayField:"display",valueField:"warning",fieldLabel:"",hideLabel:true,width:500,listWidth:500,store:new Ext.data.ArrayStore({autoDestroy:true,fields:["warning","display","smartId"],data:[]}),listeners:{select:{scope:d,fn:d.onTypeChange}}},{xtype:"syno_radio",boxLabel:_T("disk_info","disk_suppress_warning_btn"),name:"warning_action",inputValue:"suppress",checked:true},{xtype:"syno_displayfield",indent:1,tabIndex:-1,value:_T("disk_info","disk_suppress_warning_short_desc")},{xtype:"syno_radio",boxLabel:_T("disk_info","disk_disable_warning_btn"),name:"warning_action",inputValue:"disable"},{xtype:"syno_displayfield",value:""},{xtype:"syno_displayfield",htmlEncode:false,value:String.format('<span class="red-status">{0}</span>',_T("disk_info","disk_suppress_disable_warning_desc"))},{xtype:"syno_checkbox",boxLabel:_T("disk_info","disk_suppress_warning_confirm"),listeners:{check:{scope:d,fn:d.onCheckboxCheck}}});c=Ext.apply({title:_T("disk_info","disk_remove_warning_title"),width:550,height:350,dsmStyle:"v5",layout:"fit",items:[{xtype:"syno_formpanel",id:d.formId=Ext.id(),border:false,items:a}],buttons:[{text:_T("common","cancel"),scope:d,btnStyle:"gray",handler:d.onClickCancel},{text:_T("common","apply"),id:d.confirmId=Ext.id(),scope:d,disabled:true,btnStyle:"red",handler:d.onClickConfirm}],listeners:{activate:d.onActivate,scope:d}},b);d.callParent([c])},onActivate:function(){var b=this,d={},c=[],a=0;if(!b.appWin.healthInfo||!b.appWin.healthInfo.overview){b.appWin.getMsgBox().alert("",_T("status","status_not_available"));return}d=b.appWin.healthInfo.overview;for(a=0;a<d.smart_fail.size();a++){if("critical"===d.smart_fail[a].type){continue}c.push(["smart",SYNO.SDS.StorageUtils.WarningTitleStringGet("smart",d.smart_fail[a].id),d.smart_fail[a].id])}if("normal_past"===d.smart_test){c.push(["smart_test",SYNO.SDS.StorageUtils.WarningTitleStringGet("smart_test",-1),-1])}if(true===d.exceed_bad_sector_thr){c.push(["unc",SYNO.SDS.StorageUtils.WarningTitleStringGet("unc",-1),-1])}if(true===d.below_remain_life_thr&&1<d.remain_life){c.push(["life",SYNO.SDS.StorageUtils.WarningTitleStringGet("life",-1),-1])}if(true===d.adv_modifiable){c.push(["adv",SYNO.SDS.StorageUtils.WarningTitleStringGet("adv",-1),-1])}Ext.getCmp(b.typeId).store.loadData(c);Ext.getCmp(b.typeId).setValue(Ext.getCmp(b.typeId).getStore().getAt(0).get("warning"));b.onTypeChange(Ext.getCmp(b.typeId),Ext.getCmp(b.typeId).getStore().getAt(0))},onClickConfirm:function(){var a=this;var c={};var b="";b=Ext.getCmp(a.formId).getForm().findField("warning_action").getGroupValue();c={device:a.device,action:b,type:a.type,smartId:(-1===a.smartId)?"":a.smartId.toString()};a.appWin.setStatusBusy();a.appWin.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Storage.CGI.Smart",method:"smart_warning_set",version:1,params:c,scope:a,callback:function(e,d){a.appWin.clearStatusBusy();if(!e){SYNO.Debug.error("send webapi smart_warning_set error");return}a.appWin.healthOverviewPanel.onHealthInfoRefresh({device:a.device});a.close()}}))},onClickCancel:function(){var a=this;a.close()},onCheckboxCheck:function(c,b){var a=this;Ext.getCmp(a.confirmId).setDisabled(!b)},onTypeChange:function(c,a){var b=this;Ext.getCmp(b.typeId).setValue(a.get("display"));b.type=a.get("warning");b.smartId=a.get("smartId")}});Ext.define("SYNO.SDS.StorageManager.Wizard.EnableWarning",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this;var b;c.device=a.device;c.owner=a.owner;c.appWin=a.appWin;c.is_target_ha_passive=a.is_target_ha_passive;b=Ext.apply({title:_T("disk_info","disk_recover_warning_title"),width:500,height:180,dsmStyle:"v5",layout:"fit",items:[{xtype:"syno_formpanel",border:false,id:c.formId=Ext.id(),items:[{xtype:"syno_combobox",id:c.typeId=Ext.id(),displayField:"display",valueField:"warning",fieldLabel:"",hideLabel:true,width:450,listWidth:450,store:new Ext.data.ArrayStore({autoDestroy:true,fields:["warning","display","action","smartId","descDisplay"],data:[],listeners:{load:c.onStoreLoad,scope:c}}),listeners:{select:{scope:c,fn:c.onTypeChange}}},{xtype:"syno_displayfield",id:c.descId=Ext.id()}]}],buttons:[{text:_T("disk_info","disk_enable_warning_title"),scope:c,handler:c.onClickConfirm},{text:_T("common","cancel"),id:c.confirmId=Ext.id(),scope:c,handler:c.onClickCancel}],listeners:{activate:c.onActivate,scope:c}},a);c.callParent([b])},onActivate:function(){var b=this;var c=[];var d={};var a=0;d={device:b.device};b.setStatusBusy();b.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(b.is_target_ha_passive,{api:"SYNO.Storage.CGI.Smart",method:"smart_warning_get",version:1,params:d,scope:b,callback:function(f,e){b.clearStatusBusy();if(!f){SYNO.Debug.error("send webapi smart_warning_get error");return}b.actionInfo=e;for(a=0;a<b.actionInfo.length;a++){c.push([b.actionInfo[a].warning,SYNO.SDS.StorageUtils.WarningTitleStringGet(b.actionInfo[a].warning,b.actionInfo[a].id),b.actionInfo[a].action,b.actionInfo[a].id,b.descStringGet(b.actionInfo[a].warning,b.actionInfo[a].action,b.actionInfo[a].id)])}Ext.getCmp(b.typeId).store.loadData(c);Ext.getCmp(b.typeId).setValue(Ext.getCmp(b.typeId).getStore().getAt(0).get("warning"));b.onTypeChange(Ext.getCmp(b.typeId),Ext.getCmp(b.typeId).getStore().getAt(0))}}))},descStringGet:function(a,b,d){var c="";switch(a){case"smart":c=("suppress"===b)?String.format(_T("disk_info","disk_warning_smart_info_past_suppress"),d):String.format(_T("disk_info","disk_warning_smart_info_past_disable"),d);break;case"unc":c=("suppress"===b)?_T("disk_info","disk_warning_unc_suppress"):_T("disk_info","disk_warning_unc_disable");break;case"life":c=("suppress"===b)?_T("disk_info","disk_warning_life_suppress"):_T("disk_info","disk_warning_life_disable");break;case"adv":c=("suppress"===b)?_T("disk_info","disk_warning_ironwolf_suppress"):_T("disk_info","disk_warning_ironwolf_disable");break;case"smart_test":c=("suppress"===b)?_T("disk_info","disk_warning_smart_test_past_suppress"):_T("disk_info","disk_warning_smart_test_past_disable");break;default:SYNO.Debug.error("no such value",a);return}return c},onClickConfirm:function(){var a=this;var b={};b={device:a.device,action:a.action,type:a.type,smartId:a.smartId};a.appWin.setStatusBusy();a.appWin.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(a.is_target_ha_passive,{api:"SYNO.Storage.CGI.Smart",method:"smart_warning_set",version:1,params:b,scope:a,callback:function(d,c){a.appWin.clearStatusBusy();if(!d){SYNO.Debug.error("send webapi smart_warning_set error");return}a.appWin.healthOverviewPanel.onHealthInfoRefresh({device:a.device});a.close()}}))},onClickCancel:function(){var a=this;a.close()},onTypeChange:function(c,a){var b=this;Ext.getCmp(b.typeId).setValue(a.get("display"));Ext.getCmp(b.descId).setValue(a.get("descDisplay"));b.type=a.get("warning");b.action=("suppress"===a.get("action"))?"remove":"enable";b.smartId=a.get("smartId")},onStoreLoad:function(c,b){var a={};var d="";c.filterBy(function(e){d=e.get("warning")+e.get("smartId");if(a[d]){return false}else{a[d]=true;return true}});delete c.snapshot}});Ext.define("SYNO.SDS.StorageManager.Wizard.SwitchDiskLed",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this,b;c.device=a.device;c.owner=a.owner;c.appWin=a.appWin;c.is_target_ha_passive=a.is_target_ha_passive;b=Ext.apply({title:_T("disk_info","switch_led_light_title"),width:550,height:250,minWidth:550,minHeight:250,dsmStyle:"v5",layout:"fit",items:[{xtype:"syno_formpanel",border:false,items:[{xtype:"syno_displayfield",value:_T("disk_info","switch_led_light_desc")},{xtype:"syno_displayfield",value:_T("disk_info","switch_led_light_time")},{xtype:"syno_combobox",id:c.ledRemainTime=Ext.id(),fieldLabel:_T("time","time_time"),store:c.getRemainTimeStore(),displayField:"display",valueField:"value",labelWidth:50,width:200},{xtype:"syno_displayfield",id:c.remainText=Ext.id(),hidden:true}]}],buttons:[{text:_T("disk_info","switch_led_light_btn"),id:c.confirmId=Ext.id(),handler:c.onClickConfirm,scope:c},{text:_T("common","alt_close"),handler:c.onClickClose,scope:c}],listeners:{scope:c,beforedestroy:c.pollingTaskStop}},a);c.callParent([b]);c.mon(c,"afterlayout",c.onAfterlayout,c,{single:true})},onAfterlayout:function(b){var a=this;if(!(a.device=b.device)){throw Error("param error: device is not set")}a.GetStatusPollingConf={interval:5,immediate:true,webapi:SYNO.SDS.StorageUtils.ReplaceWebapiSHA(a.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",version:1,method:"get_disk_led_status",params:{device:a.device}}),status_callback:function(f,d,e,c){if(a.cleanMask){a.appWin.clearStatusBusy();a.cleanMask=false}if(!f){a.appWin.getMsgBox().alert(_T("tree","node_device"),_T("status","status_not_available"));a.pollingTaskStop();return}a.fillData(d)},scope:a};a.appWin.setStatusBusy();a.cleanMask=true;a.pollingTaskStart()},getRemainTimeStore:function(){var a=new Ext.data.SimpleStore({fields:["value","display"],data:[[60,"1 "+_T("common","time_minute")],[300,"5 "+_T("hddsleep","hddsleep_min")],[900,"15 "+_T("hddsleep","hddsleep_min")],[1800,"30 "+_T("hddsleep","hddsleep_min")],[3600,"60 "+_T("hddsleep","hddsleep_min")]]});return a},pollingTaskStart:function(){var a=this;if(undefined===a.GetStatusPollingId){a.GetStatusPollingId=a.pollReg(a.GetStatusPollingConf)}},pollingTaskStop:function(){var a=this;if(undefined!==a.GetStatusPollingId){a.pollUnreg(a.GetStatusPollingId);a.GetStatusPollingId=undefined}},fillData:function(c){var b=this,a="";if(0<c.time){a=(1<c.time)?String.format(_T("disk_info","switch_led_light_remain"),c.time):String.format(_T("disk_info","switch_led_light_remain_singular"),c.time);Ext.getCmp(b.remainText).setValue(a);Ext.getCmp(b.remainText).setVisible(true);Ext.getCmp(b.ledRemainTime).setValue(c.duration);Ext.getCmp(b.ledRemainTime).disable();b.action="restore";Ext.getCmp(b.confirmId).setText(_T("disk_info","restore_led_light_btn"))}else{Ext.getCmp(b.remainText).setVisible(false);b.action="switch";Ext.getCmp(b.ledRemainTime).setValue(60);Ext.getCmp(b.ledRemainTime).enable();Ext.getCmp(b.confirmId).setText(_T("disk_info","switch_led_light_btn"))}},onClickConfirm:function(){var a=this;var b=Ext.getCmp(a.ledRemainTime).getValue();a.onSwitchDiskLed(b)},onClickClose:function(){var a=this;a.close()},onSwitchDiskLed:function(b){var a=this;var c={device:a.device,action:a.action,time:b};a.setStatusBusy();a.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(a.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",method:"set_disk_led_status",version:1,params:c,scope:a,callback:function(f,e){var d=function(){a.clearStatusBusy();a.pollingTaskStop();a.pollingTaskStart()}.createDelegate(a);a.isDataChanged=true;setTimeout(d,1000);if(!f){a.appWin.getMsgBox().alert(_T("helptoc","logcenter_overview"),_T("status","status_not_available"));return}}}))}});Ext.define("SYNO.SDS.StorageManager.Wizard.DiskConfig",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){var d=this,c,a=[];d.device=b.device;d.owner=b.owner;d.appWin=b.appWin;d.is_target_ha_passive=b.is_target_ha_passive;a.push({xtype:"syno_fieldset",itemId:"cache",title:_T("smart","cache_management"),items:[{xtype:"syno_checkbox",scope:d,id:d.CacheCheckboxId=Ext.id(),boxLabel:_T("hddsleep","dcache_config"),name:"wcache_en",value:true},{xtype:"syno_displayfield",scope:d,id:d.CacheDescdiskId=Ext.id(),value:_T("hddsleep","dcache_desc"),hidden:true},{xtype:"syno_displayfield",scope:d,id:d.CacheDescnoteId=Ext.id(),value:_T("hddsleep","dwcache_suggest"),htmlEncode:false,hidden:true}]});c=Ext.apply({title:_T("volume","configuration"),width:600,height:280,minWidth:600,minHeight:280,dsmStyle:"v5",layout:"fit",items:[{xtype:"syno_formpanel",border:false,id:d.formpanelId=Ext.id(),items:a}],buttons:[{text:_T("common","commit"),id:d.confirmId=Ext.id(),handler:d.onClickConfirm,scope:d},{text:_T("common","alt_close"),handler:d.onClickClose,scope:d}]},b);d.callParent([c])},fillData:function(b){var a=this;Ext.getCmp(a.CacheCheckboxId).setValue(b.wcache_en);Ext.getCmp(a.CacheDescdiskId).setVisible(!(b.blacklist||b.disable_wcache_off_list));Ext.getCmp(a.CacheDescnoteId).setVisible(b.blacklist||b.disable_wcache_off_list);Ext.getCmp(a.CacheCheckboxId).setDisabled(b.blacklist||b.disable_wcache_off_list)},onClickConfirm:function(){var a=this;var b={device:a.device,wcache_en:Ext.getCmp(a.CacheCheckboxId).getValue()};a.setStatusBusy();a.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(a.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",method:"disk_config_set",version:1,params:b,scope:a,callback:function(d,c){a.clearStatusBusy();if(!d){if(c.errors&&c.errors.errinfo.sec&&c.errors.errinfo.key){a.setStatusError({text:_T(c.errors.errinfo.sec,c.errors.errinfo.key)})}else{a.setStatusError({text:_T("error","error_error_system")})}return}a.close()}}))},onClickClose:function(){var a=this;a.close()},onActivate:function(){var a=this;var b={device:a.device};a.setStatusBusy();a.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(a.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",method:"disk_config_get",version:1,params:b,scope:a,callback:function(d,c){a.clearStatusBusy();if(!d){a.appWin.getMsgBox().alert(_T("helptoc","logcenter_overview"),_T("status","status_not_available"));return}a.fillData(c)}}))}});Ext.define("SYNO.SDS.StorageManager.Wizard.ImportLog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this,b;c.parentNode=a.parentNode;c.owner=a.owner;c.appWin=a.appWin;c.is_target_ha_passive=a.is_target_ha_passive;c.type=a.type;b=Ext.apply({title:_T("disk_info","import_previous_data"),width:550,height:200,minWidth:550,minHeight:200,dsmStyle:"v5",layout:"fit",items:[{xtype:"syno_formpanel",border:false,items:[{xtype:"syno_displayfield",value:_T("disk_info","log_update_desc")},{xtype:"syno_displayfield",htmlEncode:false,value:'<span class="syno-ux-note">'+_T("common","note")+_T("common","colon")+" </span>"+_T("disk_info","log_update_note")}]}],buttons:[{text:_T("nfs","nfs_kerberos_import_keys"),scope:this,handler:this.onClickImport},{text:_T("common","cancel"),scope:this,handler:this.onClickCancel}]},a);c.callParent([b])},onClickImport:function(){var a=this;a.setStatusBusy();a.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",method:"import_previous_log",version:1,params:{type:a.type},scope:a,callback:function(e,c,d,b){a.clearStatusBusy();if(!e){a.appWin.getMsgBox().alert(_T("tree","node_device"),_T("common","error_system"));return}a.parentNode.onRefreshConfig();a.close()}}))},onClickCancel:function(){this.close()}});Ext.define("SYNO.SDS.StorageManager.Disk.Object",{check:SYNO.SDS.StorageUtils.check,get:function(a){if(this.json){return this.json[a]}return undefined},isFree:function(d){var c=this.get("status");var b=this.get("container");var a=this.get("overview_status");var e=false;e=("normal"==a);if("undefined"===typeof(d)){d=true}if("ebox"===b.type&&0===b.order){return false}if(true===this.get("is_erasing")){return false}if(d&&!e){return false}if(0===c.indexOf("system_crashed")&&""===this.get("used_by")){return true}if(""!==this.get("used_by")){return false}if("not_use"===c||"sys_partition_normal"===c||"deactivated"===c){return true}return false},isBiggerThan:function(a){return a<=parseInt(this.get("size_total"),10)},isInternal:function(){return"internal"===this.get("container").type},isInEbox:function(){return"ebox"===this.get("container").type},isSameInterface:function(a){return a===this.get("diskType")},inSpare:function(b){var a=false;if(b.length){Ext.each(b,function(c){if(c.id===this.id){a=true;return false}},this);return a}return(this.id in b)},notUsedBySpace:function(){var a=this.get("status");if(0===a.indexOf("system_crashed")&&""===this.get("used_by")){return true}if(""!==this.get("used_by")&&"hotspare"!==this.get("used_by")){return false}return"not_use"===a||"sys_partition_normal"===a||"deactivated"===a},isSSD:function(){if("yes"===_D("sata_as_cache","no")){return true}return this.get("isSsd")},isSupported:function(){if("no"===_D("strict_ssd_policy","no")){return true}return this.get("support")},isNormalTray:function(){return("normal"===this.get("portType"))},isCacheTray:function(){return("cache"===this.get("portType"))},canBeSpare:function(){if(true===this.get("is_erasing")){return false}return("esata"!==this.get("portType"))},isEqualToAny:function(a){var c,b;c=parseInt(this.get("size_total"),10);for(b=0;b<a.length;++b){if(a[b]===c){return true}}return false},is4Kn:function(){return this.get("is4Kn")}});Ext.define("SYNO.SDS.StorageManager.Disk.Store",{extend:"Ext.data.JsonStore",constructor:function(a){var c=this,b;b={autoDestroy:true,idProperty:"id",fields:["numId","id","iconCls","statusIconCls","displayName","displayNameHashValue","desc","usage","barWidth","summaryStatus","property","raidInfo","detailUsage","illustrate","status","sizeTotal","sizeFree","firmware","model","totalSize","displayTotalSize","temp","diskType","smartStatus","diskStatus","usedBy","is4Kn","serial","trayStatus","allowJoin","ctnOrder","remainLife","vendor","expansion","badSecCt","advStatus","overviewStatus","portType","displayStatus","pciSlot"]};c.callParent([Ext.apply(b,a)])}});Ext.define("SYNO.SDS.StorageManager.Disk.Main",{extend:"SYNO.SDS.Utils.TabPanel",constructor:function(a){var d=this,c,b;d.appWin=a.appWin;d.owner=a.appWin;d.diskPanel=new SYNO.SDS.StorageManager.Disk.DiskPanel({appWin:d.appWin,owner:d.owner,parent:d});d.SmartScheduler=new SYNO.SDS.StorageManager.Disk.SmartScheduler({appWin:d.appWin,owner:d.owner});d.HddMgr=new SYNO.SDS.StorageManager.Disk.HddMgr({appWin:d.appWin,owner:d.owner});b=[d.diskPanel,new SYNO.SDS.StorageManager.Disk.LogPanel({appWin:d.appWin,owner:d.owner}),d.SmartScheduler,d.HddMgr];c={useDefaultBtn:false,appWin:d.appWin,owner:d.owner,itemId:"disk",activeTab:0,items:b,listeners:{activate:d.onActivate,scope:d}};this.callParent([c])},getHelpParam:function(){return"StorageManager/disk.html"},onActivate:function(){this.getComponent("diskPanel").onActivate()},onPageDeactivate:function(){var a=this;if(!a.checkFormDirty){return true}else{if(a.SmartScheduler.panel.isDirty()){return false}if(a.isAnyFormDirty()){return false}}},onPageActivate:function(b){var a=this;a.SmartScheduler.onActivate();a.HddMgr.onActivate();if(b&&b.tab){a.setActiveTab(b.tab)}},setFocus:function(b){var c=this;var a=c.diskPanel;this.setActiveTab(a);a.listView.view.setFocus(b)}});Ext.define("SYNO.SDS.StorageManager.Disk.DiskPanel",{extend:"SYNO.ux.Panel",filter:"all",constructor:function(a){var d=this,b,e=[],c=[];d.appWin=a.appWin;d.owner=a.owner;d.parent=a.parent;if("yes"===_D("supportsmart","no")){e.push({itemId:"health_info",text:_T("disk_info","disk_health_info"),handler:this.onHealthInfo,disabled:true,scope:this})}if("yes"===_D("support_disk_performance_test","no")){e.push({itemId:"benchmark",text:_T("disk_info","disk_perf_benchmark"),handler:d.onBenchmark,disable:false,scope:d})}e.push({itemId:"port_enable",text:_T("disk_info","disk_en"),handler:d.onPortEnable,disabled:false,hidden:true,scope:d});if("no"===_D("support_dual_head","no")){d.secureEraseBtn=new Ext.menu.Item({text:_T("disk_info","disk_secure_erase"),id:d.secureEraseId=Ext.id(),disabled:true,handler:d.onSecureErase,listeners:{afterrender:d.secureEraseStatusChange,scope:d},scope:d});c.push(d.secureEraseBtn)}d.deactivateDiskBtn=new Ext.menu.Item({text:_T("disk_info","deactivate"),id:d.deactivateDiskId=Ext.id(),disabled:true,handler:d.onDiskDeactivate,listeners:{afterrender:d.deactivateStatusChange,scope:d},scope:d});c.push(d.deactivateDiskBtn);if(1<parseInt(_D("maxdisks","1"),10)){d.switchDiskLedBtn=new Ext.menu.Item({text:_T("disk_info","switch_led_light_title"),id:d.switchDiskLedId=Ext.id(),handler:d.onSwitchDiskLed,listeners:{afterrender:d.switchDiskLedStatusChange,scope:d},scope:d});c.push(d.switchDiskLedBtn)}c.push(new Ext.menu.Item({text:_T("volume","adv_prop_title"),id:d.configId=Ext.id(),disable:false,handler:d.onConfiguration,scope:d}));if(0<c.length){d.actionMenu=new SYNO.ux.Menu({items:c});d.actionBtn=new SYNO.ux.Button({text:_T("common","action"),menu:d.actionMenu,scope:d});e.push(d.actionBtn)}e.push("->",{itemId:"filterBtn",cls:"syno-share-filter-btn",tooltip:_T("common","filter_label_text"),menu:{cls:"syno-ux-searchfield-menu",defaults:{checked:false},items:[],listeners:{itemclick:d.onFilter,scope:d}},getMenuClass:function(){return""}},{cls:"sm-viewmode-btn",xtype:"syno_statebuttongroup",itemId:"display_button_group",activeBtn:0,buttons:[{itemId:"listViewBtn"},{itemId:"gridViewBtn"}],listeners:{scope:d,activebuttonchange:function(f,h){var g=h.itemId;if("listViewBtn"===g){d.layout.setActiveItem(0)}else{d.layout.setActiveItem(1)}d.onActivate()}}});d.listView=new SYNO.SDS.StorageManager.Disk.DiskListViewPanel({appWin:d.appWin,owner:d});d.gridView=new SYNO.SDS.StorageManager.Disk.DiskGridViewPanel({appWin:d.appWin,owner:d});b={title:_T("disk_info","disk_disks"),border:false,layout:"card",frame:false,hideMode:"offsets",region:"center",itemId:"diskPanel",tbar:{defaultType:"syno_button",items:e},activeItem:0,items:[d.listView,d.gridView],listeners:{activate:d.onActivate,scope:d}};d.callParent([Ext.apply(b,a)])},onFilter:function(c,b){var a=this;a.filter=c.itemId;a.loadUiData()},onActivate:function(){this.prepareUiData();this.loadUiData()},secureEraseStatusChange:function(){var a=this;var b=a.layout.activeItem.getSelectedItem();var c="";if(undefined===b){return}if(true===b.get("is_erasing")){Ext.getCmp(a.secureEraseId).disable();c=_T("disk_info","disk_secure_erasing")}else{if(true===b.get("disable_secera")){Ext.getCmp(a.secureEraseId).disable();c=_T("disk_info","disk_cant_erase_not_support")}else{if(0>=b.get("erase_time")){Ext.getCmp(a.secureEraseId).disable();c=_T("disk_info","disk_cant_erase_not_support")}else{if(!a.appWin.supportSas&&("ebox"===b.get("container").type)){Ext.getCmp(a.secureEraseId).disable();c=_T("disk_info","disk_cant_erase_eunit")}else{if(this.isLastSystemDisk(b)){Ext.getCmp(a.secureEraseId).disable();c=_T("disk_info","disk_cant_erase_last_system")}else{if(!b.isFree(false)){Ext.getCmp(a.secureEraseId).disable();c=_T("disk_info","disk_cant_erase_on_volume")}else{if(b.get("smart_testing")||b.get("ihm_testing")||b.get("perf_testing")){Ext.getCmp(a.secureEraseId).disable();c=_T("disk_info","other_is_testing")}else{Ext.getCmp(a.secureEraseId).enable();c=""}}}}}}}c=Ext.util.Format.htmlEncode(c);Ext.getCmp(a.secureEraseId).textEl.update('<span style="margin-left: -3px;" ext:qtip="'+c+'">'+_T("disk_info","disk_secure_erase")+"</span>")},deactivateStatusChange:function(){var a=this;var b=a.layout.activeItem.getSelectedItem();if(undefined===b){return}if(b.isFree(false)){var c=Ext.util.Format.htmlEncode(_T("disk_info","deactivate_disk_tip_no_need"));if("deactivated"===b.get("status")){c=Ext.util.Format.htmlEncode(_T("disk_info","deactivate_disk_tip_deactivated"))}Ext.getCmp(a.deactivateDiskId).disable();Ext.getCmp(a.deactivateDiskId).textEl.update('<span style="margin-left: -3px;" ext:qtip="'+c+'">'+_T("disk_info","deactivate")+"</span>");return}a.sendWebAPI({api:"SYNO.Core.Storage.Disk",method:"test_deactivate_disk",version:1,params:{device:b.get("device")},scope:a,callback:function(f,e){if(f&&e.is_safe){Ext.getCmp(a.deactivateDiskId).enable();Ext.getCmp(a.deactivateDiskId).textEl.update('<span style="margin-left: -3px;" ext:qtip="">'+_T("disk_info","deactivate")+"</span>")}else{var d=Ext.util.Format.htmlEncode(_T("disk_info","deactivate_disk_tip_unsafety"));Ext.getCmp(a.deactivateDiskId).disable();Ext.getCmp(a.deactivateDiskId).textEl.update('<span style="margin-left: -3px;" ext:qtip="'+d+'">'+_T("disk_info","deactivate")+"</span>")}}})},switchDiskLedStatusChange:function(){var a=this;var b=a.layout.activeItem.getSelectedItem();if(b.isCacheTray()){Ext.getCmp(a.switchDiskLedId).disable()}else{Ext.getCmp(a.switchDiskLedId).enable()}},loadUiData:function(){var c=this,b,d,e=c.layout.activeItem,a=e.store;delete c.uiData;if("all"===c.filter){delete c.uiData;c.uiData=c.allData}else{c.uiData=[];for(b=0;b<c.allData.length;b++){d=c.allData[b];if(c.filter===d.ctnOrder.toString()){c.uiData.push(d)}}}c.uiData.sort(SYNO.SDS.StorageUtils.DiskSort);a.suspendEvents(true);a.loadData(c.uiData,false);a.resumeEvents();if(0<a.getCount()&&0===e.getSelectedItemIds().length){e.select(0,true,true)}c.onSelectChange()},prepareUiData:function(){var c=this,d,b,g=false,e={},f=[],a=(0===c.appWin.disks.count)?[]:c.appWin.disks.getAll();delete c.allData;c.allData=[];c.adv_support=false;Ext.each(a,function(h){if("not_support"!==h.get("adv_status")){c.adv_support=true;return false}},c);Ext.each(a,function(h){d={};if("disabled"===h.get("portType")){c.preparePort(h,d)}else{c.prepareSummary(h,d);c.prepareProperty(h,d)}c.allData.push(d)},c);for(b=0;b<c.allData.length;b++){d=c.allData[b];if(undefined!==e[d.ctnOrder]){continue}if(!g&&c.filter===d.ctnOrder.toString()){g=true}f.push({itemId:d.ctnOrder.toString(),checked:(c.filter===d.ctnOrder.toString()),text:d.ctnName,group:"container"});e[d.ctnOrder]=true}if(!g){c.filter="all"}f.sort(function(i,h){return parseInt(i.itemId,10)-parseInt(h.itemId,10)});f.unshift({itemId:"all",checked:!g,text:_T("common","show_all"),group:"container"});c.getTopToolbar().getComponent("filterBtn").menu.removeAll(true);c.getTopToolbar().getComponent("filterBtn").menu.add(f)},prepareSummary:function(g,f){var e=this,c=SYNO.SDS.StorageUtils,b=g.get("container"),a=c.GetSizeUnit(parseInt(g.get("size_total"),10)),d,h;f.id=g.get("id");f.numId=parseInt(g.get("num_id"),10);f.ctnOrder=parseInt(b.order,10);f.ctnName=(0===f.ctnOrder)?_S("hostname"):b.str;f.displayNameHashValue=c.DiskNameHashValueGet(f.ctnOrder,f.numId,g.get("portType"));f.totalSize=a.size;f.displayName=SYNO.SDS.StorageUtils.DiskDisplayNameGet(g);f.pciSlot=g.get("pciSlot");h=String.format("{0} {1}",f.totalSize,a.unit);d=("hotspare"===g.get("used_by"))?"hotspare":g.get("status");f.overviewStatus=c.DiskOverviewStatusRender(g.get("overview_status"));f.displayStatus=c.DiskSummaryStatusRender(d,g.get("overview_status"),g.get("testing_type"),g.get("testing_progress"));f.summaryStatus=String.format("&nbsp;-&nbsp;{0}",f.displayStatus);f.displayTotalSize=h;f.diskType=c.DiskTypeRender(g,e.appWin.supportSas);f.vendor=g.get("vendor");f.model='<span class="allowDefCtxMenu selectabletext">'+g.get("model")+"</span>";f.desc=String.format("{0} {1}, {2} {3}",f.vendor,f.model,h,f.diskType);f.iconCls=("ironwolf"===g.get("disk_code"))?"sm-list-icon-ironwolf":"sm-list-icon-disk";if(f.summaryStatus.match("blue-status")){f.statusIconCls="sm-list-status-icon-acting"}else{if(f.summaryStatus.match("red-status")||f.summaryStatus.match("orange-status")){f.statusIconCls="sm-list-status-icon-crashed"}}},prepareProperty:function(e,d){var a=SYNO.SDS.StorageUtils,c=("hotspare"===e.get("used_by"))?"hotspare":e.get("status"),b,f;d.property=[];d.expansion=("internal"===e.get("type"))?_S("hostname"):e.get("container").str;d.property.push({name:_T("volume","volume_raid_location"),value:d.expansion});d.usedBy=a.SpaceIDParser(e.get("used_by")).str||"-";d.property.push({name:_T("volume","volume_storage_pool"),value:d.usedBy});d.diskStatus=a.DiskStatusRender(c);d.property.push({name:_T("disk_info","disk_allocation_status"),value:d.diskStatus});d.overviewStatus=a.DiskOverviewStatusRender(e.get("overview_status"));d.property.push({name:_T("disk_info","disk_health_status"),value:d.overviewStatus});d.remainLife=a.RemainLifeRender(e.get("remain_life"),e.get("below_remain_life_thr"));d.property.push({name:_T("disk_info","disk_remain_life"),value:d.remainLife});d.badSecCt=a.BadSecCtRender(e.get("unc"),e.get("exceed_bad_sector_thr"));d.property.push({name:_T("disk_info","disk_bad_sector_ct"),value:d.badSecCt});if(0===e.get("temp")){d.temp=_T("common","loading")}else{d.temp=a.DiskTemperatureRender(e.get("temp"))}d.property.push({name:_T("status","temperature"),value:d.temp});b=(!e.get("serial"))?_T("common","loading"):e.get("serial");d.serial=b;d.property.push({name:_T("smart","smart_disk_serial"),value:'<span class="allowDefCtxMenu selectabletext">'+b+"</span>"});f=(!e.get("firm"))?_T("common","loading"):e.get("firm");d.firmware=f;d.property.push({name:_T("smart","smart_disk_firmware"),value:f});d.is4Kn=e.get("is4Kn")?_T("common","yes"):_T("common","no");d.property.push({name:_T("volume","4k_hdd"),value:d.is4Kn});d.portType=e.get("portType")},preparePort:function(a,b){b.id=a.get("id");b.numId=parseInt(a.get("num_id"),10);b.ctnOrder=0;b.ctnName=_S("hostname");b.displayName=SYNO.SDS.StorageUtils.DiskDisplayNameGet(a);b.displayStatus=String.format('<span class="red-status">{0}</span>',_T("disk_info","disk_disable_title"));b.summaryStatus=String.format("&nbsp;-&nbsp;{0}",b.displayStatus);b.iconCls="sm-list-icon-disk";b.pciSlot=a.get("pciSlot");b.model="-";b.displayTotalSize="-";b.temp="-";b.diskType="-";b.smartStatus="-";b.diskStatus=String.format('<span class="red-status">{0}</span>',_T("disk_info","disk_disable_title"));b.usedBy="-";b.is4Kn="-"},getButton:function(a){return this.getTopToolbar().getComponent(a)},isLastSystemDisk:function(d){var c=0,a=this.layout.activeItem.store,b=0;for(b=0;b<a.getCount();b++){var e=a.data.items[b].id;if(true===this.appWin.disks.data[e].get("has_system")){c=c+1}}if(1==c&&true===d.get("has_system")){return true}return false},onSelectChange:function(){var a=this,b=a.layout.activeItem.getSelectedItem();if(!b){return}if("disabled"===b.get("portType")){a.getButton("port_enable").show();if("yes"===_D("supportsmart","no")){Ext.each(["health_info"],function(c){a.getButton(c).hide()},a)}if("no"===_D("support_dual_head","no")){Ext.getCmp(a.secureEraseId).hide()}return}a.getButton("port_enable").hide();if("no"===_D("support_dual_head","no")){Ext.getCmp(a.secureEraseId).show();if(Ext.get(a.secureEraseId)){a.secureEraseStatusChange()}}Ext.getCmp(a.deactivateDiskId).show();if(Ext.get(a.deactivateDiskId)){a.deactivateStatusChange()}if(Ext.get(a.switchDiskLedId)){a.switchDiskLedStatusChange()}if("yes"===_D("supportsmart","no")){Ext.each(["health_info"],function(c){a.getButton(c).show();a.getButton(c).enable()},a);a.getButton("health_info").show();if("unknown"===b.get("smart_status")||true===b.get("is_erasing")){a.getButton("health_info").disable()}}},onHealthInfo:function(){var a=this,b=a.layout.activeItem.getSelectedItem();if(!b||"yes"!==_D("supportsmart","no")){return}this.openWizard("HealthInfo",{device:b.get("device"),name:SYNO.SDS.StorageUtils.DiskDisplayNameGet(b),temp:b.get("temp"),parent:a.parent,isHaPanel:false})},onSecureErase:function(){var a=this,b=a.layout.activeItem.getSelectedItem();if(!b){return}this.openWizard("SecureErase",{device:b.get("device"),erase_time:b.get("erase_time")})},onDiskDeactivate:function(){var a=this,b=a.layout.activeItem.getSelectedItem();if(!b){return}this.openWizard("DiskDeactivate",{device:b.get("device"),device_name:b.get("name")})},onBenchmark:function(){var e=this,g=e.layout.activeItem.getSelectedItem(),a=e.appWin.disks.getAll(),d=[],b=-1,c=0;if(!g||!a||"yes"!==_D("support_disk_performance_test","no")){return}for(c=0;c<a.length;c++){var f={};f.device=a[c].get("device");f.diskName=SYNO.SDS.StorageUtils.DiskDisplayNameGet(a[c]);f.diskId=a[c].get("num_id");f.diskContainer=a[c].get("container");f.spare=a[c].isFree(false);if(true===a[c].get("isSsd")&&"ssd cache"!==a[c].get("tray_status")){f.isSsdAlone=true}else{f.isSsdAlone=false}f.model=a[c].get("model").trim();f.serial=a[c].get("serial").trim();f.vendor=a[c].get("vendor").trim();f.numId=a[c].get("num_id");f.ctnOrder=a[c].get("container").order;f.portType=a[c].get("portType");d.push(f)}d.sort(SYNO.SDS.StorageUtils.DiskSort);for(c=0;c<d.length;c++){if(d[c].device===g.get("device")){b=c;break}}e.openWizard("Benchmark",{disks:d,selectIdx:b})},openWizard:function(b,a){var c=this,e;if(c.appWin.isUpToBatchTaskCount()){e=_T("volume","volume_max_batch_task_count").replace("_MAX_TASK_",c.appWin.getMaxBatchTaskCount());c.appWin.getMsgBox().alert(c.title,e,function(){},c);return}var d=new SYNO.SDS.StorageManager.Wizard[b](Ext.apply({appWin:c.appWin,owner:c.owner},a));c.mon(d,"close",function(){if(Ext.isFunction(d.hideFromOwner)){d.hideFromOwner()}if(d.isDataChanged){c.appWin.stopPollTask();c.appWin.setStatusBusy();c.appWin.cleanMask=true;c.appWin.startPollTask()}},c,{single:true});d.open(a)},onPortEnable:function(){var a=this,b=a.layout.activeItem.getSelectedItem();if(!b||"disabled"!==b.get("portType")){return}a.appWin.stopPollTask();a.appWin.setStatusBusy();a.appWin.cleanMask=true;this.sendWebAPI({api:"SYNO.Core.Polling.Data",version:1,method:"set",params:{disk_name:b.get("id")},callback:function(){a.appWin.cleanMask=true},scope:a});setTimeout(function(){a.appWin.startPollTask()},5000)},onSwitchDiskLed:function(){var a=this,b=a.layout.activeItem.getSelectedItem();if(!b){return}this.openWizard("SwitchDiskLed",{device:b.get("device")})},onConfiguration:function(){var a=this,b=a.layout.activeItem.getSelectedItem();if(!b){return}a.openWizard("DiskConfig",{device:b.get("device")})}});Ext.define("SYNO.SDS.StorageManager.Disk.DiskListViewPanel",{extend:"SYNO.ux.Panel",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;c.store=new SYNO.SDS.StorageManager.Disk.Store();c.createView();b={border:false,layout:"fit",itemId:"diskListViewPanel",items:c.view};c.callParent([Ext.apply(b,a)])},createView:function(){var d=this,c=SYNO.SDS.StorageManager.PropertyTpl(),b,a;b=new Ext.XTemplate('<div class="item-detail-inner">',c.html,"</div>");a={appWin:d.appWin,owner:d,dataType:"disks",itemId:"diskListView",multiSelect:false,singleSelect:true,detailTpl:b,store:d.store,listeners:{selectionchange:d.owner.onSelectChange,scope:d.owner}};d.view=new SYNO.SDS.StorageManager.DataView(a)},getSelectedItem:function(){return this.view.getSelectedItem()},getSelectedItemIds:function(){return this.view.getSelectedItemIds()},select:function(){this.view.select.apply(this.view,arguments)}});Ext.define("SYNO.SDS.StorageManager.Disk.DiskGridViewPanel",{extend:"SYNO.ux.GridPanel",constructor:function(a){var d=this,c,b;d.appWin=a.appWin;d.owner=a.owner;c=[{header:_T("volume","volume_disknumber"),dataIndex:"displayNameHashValue",width:150,sortable:true,hideable:false,renderer:this.renderDisplayName},{header:_T("volume","volume_diskvendor"),dataIndex:"vendor",width:100,sortable:true},{header:_T("volume","volume_diskmodel"),dataIndex:"model",useHtmlEncodeRender:false,width:140,sortable:true},{header:_T("volume","volume_diskcapacity"),width:100,sortable:true,dataIndex:"totalSize",renderer:this.renderTotalSize},{header:_T("volume","volume_disk_type"),dataIndex:"diskType",width:100,sortable:true},{header:_T("volume","volume_raid_location"),dataIndex:"expansion",width:100,sortable:true,hidden:true},{header:_T("volume","volume_storage_pool"),width:120,sortable:true,dataIndex:"usedBy"},{header:_T("volume","volume_diskstatus"),width:125,sortable:true,dataIndex:"displayStatus",useHtmlEncodeRender:false},{header:_T("disk_info","disk_allocation_status"),useHtmlEncodeRender:false,width:125,sortable:true,dataIndex:"diskStatus",hidden:true},{header:_T("disk_info","disk_health_status"),useHtmlEncodeRender:false,width:125,sortable:true,dataIndex:"overviewStatus",hidden:true},{header:_T("disk_info","disk_remain_life"),useHtmlEncodeRender:false,width:125,sortable:true,dataIndex:"remainLife"},{header:_T("disk_info","disk_bad_sector_ct"),useHtmlEncodeRender:false,width:125,sortable:true,dataIndex:"badSecCt"}];if("yes"===_D("showdisktemperature")){c.push({header:_T("status","temperature"),dataIndex:"temp",width:100})}c.push({header:_T("smart","smart_disk_serial"),dataIndex:"serial",width:140,sortable:true,hidden:true},{header:_T("smart","smart_disk_firmware"),dataIndex:"firmware",width:100,sortable:true,hidden:true},{header:_T("volume","4k_hdd"),dataIndex:"is4Kn",width:60,sortable:true,hidden:true});d.colModel=new Ext.grid.ColumnModel({defaults:{sortable:true},columns:c});b={border:false,itemId:"diskGridViewPanel",layout:"fit",store:new SYNO.SDS.StorageManager.Disk.Store(),colModel:d.colModel,sm:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{selectionchange:d.owner.onSelectChange,scope:d.owner}}),viewConfig:{trackResetOnLoad:false}};d.callParent([Ext.apply(b,a)])},getSelectedItem:function(){var a=this,b=a.getSelectionModel().getSelected();if(!b){return}return a.appWin.disks.data[b.get("id")]},getSelectedItemIds:function(){var a=this,b=a.getSelectionModel().getSelected();if(b){return[b.get("id")]}return[]},select:function(){this.getSelectionModel().selectFirstRow()},renderTotalSize:function(e,b,a,g,d,c,f){return a.data.displayTotalSize},renderDisplayName:function(e,b,a,g,d,c,f){return a.data.displayName}});Ext.define("SYNO.SDS.StorageManager.Disk.SystemRaidDiskGridViewPanel",{extend:"SYNO.ux.GridPanel",constructor:function(a){var d=this,c,b;d.appWin=a.appWin;d.owner=a.owner;d.enableColumn=new SYNO.ux.EnableColumn({header:_T("volume","system_raid_allow_join"),dataIndex:"allowJoin",width:150,align:"center"});c=new Ext.grid.ColumnModel([{header:_T("volume","volume_disknumber"),dataIndex:"displayNameHashValue",width:150,sortable:true,renderer:this.renderDisplayName},{header:_T("volume","volume_diskmodel"),dataIndex:"model",width:140,sortable:true},{header:_T("volume","volume_diskcapacity"),dataIndex:"totalSize",width:100,sortable:true,renderer:this.renderTotalSize},{header:_T("volume","volume_disk_type"),dataIndex:"diskType",width:100,sortable:true},{header:_T("volume","volume_diskstatus"),dataIndex:"diskStatus",width:100,sortable:true,useHtmlEncodeRender:false},{header:_T("volume","system_raid_status"),dataIndex:"trayStatus",width:100,sortable:true,renderer:this.renderTrayStatus},d.enableColumn]);b={border:false,itemId:"systemRaidDiskGridViewPanel",layout:"fit",store:new SYNO.SDS.StorageManager.Disk.Store(),colModel:c,disableSelection:true,enableHdMenu:false,viewConfig:{trackResetOnLoad:false},plugins:[d.enableColumn]};d.callParent([Ext.apply(b,a)])},renderDisplayName:function(e,b,a,g,d,c,f){return a.data.displayName},renderTotalSize:function(e,b,a,g,d,c,f){return a.data.displayTotalSize},renderTrayStatus:function(e,b,a,g,d,c,f){if("join"===e){return _T("volume","system_raid_join")}else{if("not join"===e){return _T("volume","system_raid_not_join")}else{if("ssd cache"===e){return _T("volume","ssd_cache")}else{return e}}}}});Ext.define("SYNO.SDS.StorageManager.Disk.LogPanel",{extend:"SYNO.ux.GridPanel",sm:new Ext.grid.RowSelectionModel(),title:_T("disk_info","disk_logs"),iconCls:"icon-grid",constructor:function(a){this.itemsPerPage=100;var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var e=[];this.store=this.createStore(a);this.paging=this.initPagingToolbar();var d=new SYNO.ux.TextFilter({iconStyle:"filter",itemId:"search",id:this.findFieldId=Ext.id(),store:this.store,queryParam:"keyword"});this.exportBtn=new SYNO.ux.SplitButton({text:_T("autoblock","autoblock_export_ip_list"),handler:this.onExportHtml,scope:this,menu:{items:[{text:_T("log","html_type"),handler:this.onExportHtml,scope:this},{text:_T("log","csv_type"),handler:this.onExportCSV,scope:this}]}});e.push(this.exportBtn);this.importBtn=new SYNO.ux.Button({text:_T("disk_info","import_previous_data"),handler:this.onImportLog,scope:this,hidden:true});e.push(this.importBtn);e.push("->",d);var c=new Ext.grid.ColumnModel({defaults:{sortable:false},columns:[{header:_T("log","logattr"),width:60,dataIndex:"level",renderer:this.onRenderLevel},{header:_T("log","log_time"),width:80,dataIndex:"time",renderer:this.onRenderText},{header:_T("status","status_disk_model"),width:80,dataIndex:"model",renderer:this.onRenderText},{header:_T("smart","smart_disk_serial"),width:80,dataIndex:"serial",renderer:this.onRenderText},{header:_T("volume","volume_e_unit"),width:60,dataIndex:"container",renderer:this.onRenderText},{header:_T("dsmoption","login_logo_position"),width:40,dataIndex:"slot",renderer:this.onRenderText},{header:_T("notification","notification_title"),width:120,dataIndex:"msg",renderer:this.onRenderText}]});var b={colModel:c,store:this.store,viewConfig:{forceFit:true},tbar:{items:e},bbar:this.paging,listeners:{scope:this,activate:this.onActivate}};Ext.apply(b,a);return b},getPageRecordStore:function(){var a=new Ext.data.SimpleStore({fields:["value","display"],data:[[100,100],[500,500],[1000,1000],[3000,3000]]});return a},onChangeDisplayRecord:function(c,d,b){var a=this.getStore();if(this.itemsPerPage!==c.getValue()){this.itemsPerPage=c.getValue();this.paging.pageSize=this.itemsPerPage;a.load({params:{start:0,limit:this.itemsPerPage}})}},initPageComboBox:function(a){var b=new SYNO.ux.ComboBox({name:"page_rec",hiddenName:"page_rec",hiddenId:Ext.id(),store:a,displayField:"display",valueField:"value",triggerAction:"all",value:this.itemsPerPage,editable:false,width:70,mode:"local",listeners:{select:{fn:this.onChangeDisplayRecord,scope:this}}});return b},initPagingToolbar:function(){var a=new SYNO.ux.PagingToolbar({store:this.store,displayInfo:true,pageSize:this.itemsPerPage,showRefreshBtn:true,items:["-",_T("common","items_perpage"),this.initPageComboBox(this.getPageRecordStore()),"-",{xtype:"tbtext",text:"",itemId:"infoLevel"},"-",{xtype:"tbtext",text:"",itemId:"warnLevel"},"-",{xtype:"tbtext",text:"",itemId:"errorLevel"},"-"]});return a},onActivate:function(){var a=this;var b={start:0,limit:a.itemsPerPage};a.onRefreshConfig();a.getStore().load({params:b})},onRefreshConfig:function(){var a=this;a.appWin.setStatusBusy();a.appWin.sendWebAPI(SYNO.SDS.StorageUtils.ReplaceWebapiSHA(this.is_target_ha_passive,{api:"SYNO.Core.Storage.Disk",method:"get_disk_log",version:1,params:{type:"log"},scope:a,callback:function(e,c,d,b){a.appWin.clearStatusBusy();if(!e){a.appWin.getMsgBox().alert(_T("tree","node_device"),_T("common","error_system"));return}a.importBtn.setVisible(c.exist_previous_log)}}))},createStore:function(a){return new SYNO.API.JsonStore({api:"SYNO.Core.SyslogClient.Log",method:"list",version:1,baseParams:{target:"LOCAL",logtype:"disk",date_from:0,date_to:0,keyword:"",level:""},appWindow:a.appWin,listeners:{exception:{scope:this,fn:this.onStoreException},beforeload:{scope:this,fn:this.onBeforeLoad},load:{scope:this,fn:this.onLoad}},root:"items",fields:["level","time","model","serial","container","slot","msg"],autoDestroy:true,removeSort:false,sortInfo:{field:"time",direction:"DESC"},scope:this})},onStoreException:function(){this.owner.clearStatusBusy();this.appWin.setStatusError({text:_T("common","commfail")});this.getGridEl().mask({text:_T("common","commfail")})},onBeforeLoad:function(){this.owner.setStatusBusy();this.getGridEl().unmask()},onLoad:function(a,e,c){this.owner.clearStatusBusy();var d,b;if(e.length<1){if(c.params.target=="LOCAL"){this.getGridEl().mask(_T("log","no_log_available"))}else{this.getGridEl().mask(_T("log","no_ietf_log_available"))}}else{this.getGridEl().unmask()}d=a.reader.jsonData;b='<div class="{0}" ext:qtip="{1}">{2}</div>';this.setLogLevelText(this.paging.getComponent("infoLevel"),b,"sm-disk-log-info",_T("log","info_level"),d.infoCount);this.setLogLevelText(this.paging.getComponent("warnLevel"),b,"sm-disk-log-warn",_T("log","warn_level"),d.warnCount);this.setLogLevelText(this.paging.getComponent("errorLevel"),b,"sm-disk-log-err",_T("log","error_level"),d.errorCount);this.setPagingToolbar(a,this,this.paging)},setPagingToolbar:function(a,b,c){this.setPagingToolbarVisible(c,a.getTotalCount()>this.itemsPerPage)},setPagingToolbarVisible:function(b,c){var a=0;for(a=0;a<13;a++){if(a===9||a===10||a===11){continue}b.items.items[a].setVisible(c)}b.setButtonsVisible(true)},setLogLevelText:function(b,a,c,e,d){if(b){d=d||"0";b.setText(String.format(a,c,e,d))}},onExportHtml:function(){var a=this;a.onExport("html")},onExportCSV:function(){var a=this;a.onExport("csv")},onExport:function(b){var c=this;var a=c.getStore();c.downloadWebAPI({webapi:{api:"SYNO.Core.SyslogClient.Log",version:1,method:"export",params:{target:a.baseParams.target,logtype:a.baseParams.logtype,level:a.baseParams.level,sort:a.sortInfo.field,dir:a.sortInfo.direction,date_from:a.baseParams.date_from,date_to:a.baseParams.date_to,keyword:Ext.getCmp(c.findFieldId).getValue(),format:b}}})},onImportLog:function(){var a=this;var b=new SYNO.SDS.StorageManager.Wizard.ImportLog(Ext.apply({appWin:a.appWin,owner:a.owner,parentNode:a,type:"log"}));a.mon(b,"close",function(){if(Ext.isFunction(b.hideFromOwner)){b.hideFromOwner()}if(b.isDataChanged){a.appWin.stopPollTask();a.appWin.setStatusBusy();a.appWin.cleanMask=true;a.appWin.startPollTask()}},a,{single:true});b.open()},onRenderText:function(b,c){var a=Ext.util.Format.htmlEncode(b);c.attr='ext:qtip="'+a+'"';return a},onRenderLevel:function(a,c){var b={emerg:"Emergency",alert:"Alert",crit:"Critical",err:"Error",warn:"Warning",warning:"Warning",notice:"Notice",info:"Information",debug:"Debug",any:"Any"};var d=b[a];c.attr='ext:qtip="'+d+'"';switch(a){case"emerg":case"alert":case"crit":case"err":return"<span style='color:red;'>"+d+"</span>";case"warn":case"warning":case"notice":return"<span style='color:#FFA500;'>"+d+"</span>";case"info":case"debug":return"<span style='color:green;'>"+d+"</span>";default:return"Undefined"}}});Ext.define("SYNO.SDS.StorageManager.Disk.SmartScheduler",{extend:"SYNO.ux.Panel",panel:null,constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;b=c.fillConfig(a);c.callParent([b])},fillConfig:function(a){this.panel=new SYNO.SDS.StorageManager.Wizard.TaskPanel({appWin:this.appWin,owner:this.owner});var b={title:_T("smart","smart_test_scheduler"),itemId:"scheduler",width:800,minWidth:800,minHeight:155,layout:"fit",items:this.panel};Ext.apply(b,a);return b},onActivate:function(){this.panel.loadData()}});Ext.define("SYNO.SDS.StorageManager.Disk.HddMgr",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(b){var a=[];this.appWin=b.appWin;this.owner=b.owner;a.push({xtype:"syno_fieldset",title:_T("disk_info","disk_health_report_title"),items:[{xtype:"syno_checkbox",scope:this,id:this.HealthCheckboxId=Ext.id(),boxLabel:_T("disk_info","disk_health_report_enable"),name:"healthReportEn"},{xtype:"syno_displayfield",scope:this,htmlEncode:false,id:this.HealthNoteId=Ext.id(),value:'<span class="syno-ux-note">'+_T("common","note")+_T("common","colon")+" </span>"+String.format(_T("disk_info","disk_health_report_note"),'<a id="'+Ext.id()+'" class="link-font" href="#">'+_T("controlpanel","leaf_notification")+"</a>"),listeners:{afterrender:this.openNotificationWizard,scope:this},hidden:true},{xtype:"syno_displayfield",scope:this,htmlEncode:false,id:this.HealthNoteWithSupportId=Ext.id(),value:'<table><tr><td><span class="syno-ux-note">'+_T("common","note")+_T("common","colon")+" </span></td><td>"+String.format(_T("disk_info","disk_health_report_note"),'<a id="'+Ext.id()+'" class="link-font" href="#">'+_T("controlpanel","leaf_notification")+"</a>")+"</td></tr><tr><td></td><td>"+_T("disk_info","disk_health_report_support")+"</td></tr></table>",listeners:{afterrender:this.openNotificationWizard,scope:this},hidden:true},{xtype:"syno_displayfield",fieldLabel:_T("disk_info","disk_health_report_next_time"),id:this.lblNextDateId=Ext.id(),value:"--"},{xtype:"syno_button",scope:this,text:_T("disk_info","disk_health_report_send_now"),id:this.SendReportNowId=Ext.id(),handler:this.onSendReportNow},{xtype:"syno_displayfield",scope:this,htmlEncode:false,id:this.healthSupportNoteId=Ext.id(),value:'<span class="syno-ux-note">'+_T("common","note")+_T("common","colon")+" </span>"+_T("disk_info","disk_health_report_support"),hidden:true}]});if("no"===_D("support_dual_head","no")){a.push({xtype:"syno_fieldset",title:_T("disk_info","disk_bad_sector_thr_title"),items:[{xtype:"syno_checkbox",id:this.BSThrChkBxId=Ext.id(),scope:this,boxLabel:_T("disk_info","disk_bad_sector_thr_enable"),name:"BadSctrThrEn"},{xtype:"syno_displayfield",scope:this,value:_T("disk_info","disk_bad_sector_thr_desc")},{xtype:"syno_numberfield",id:this.BSThrNumId=Ext.id(),name:"BadSctrThrVal",fieldLabel:_T("disk_info","disk_bad_sector_thr_value"),validator:function(d){if(0>=d){return"Threshold can't be equal or less than 0"}return true}}]});a.push({xtype:"syno_fieldset",title:_T("disk_info","disk_remain_life_thr_title"),items:[{xtype:"syno_checkbox",id:this.RemainLifeThrChkBxId=Ext.id(),scope:this,boxLabel:_T("disk_info","disk_remain_life_thr_enable"),name:"RemainLifeThrEn"},{xtype:"syno_displayfield",scope:this,value:_T("disk_info","disk_remain_life_thr_desc")},{xtype:"syno_numberfield",id:this.RemainLifeThrNumId=Ext.id(),name:"RemainLifeThrVal",fieldLabel:_T("disk_info","disk_remain_life_thr_value")+" (%)",validator:function(d){if(0>=d||100<=d){return _T("disk_info","disk_remain_life_thr_value_err")}return true}},{xtype:"syno_displayfield",scope:this,htmlEncode:false,value:'<span class="syno-ux-note">'+_T("common","note")+_T("common","colon")+" </span>"+_T("disk_info","disk_remain_life_thr_info")}]})}a.push({xtype:"syno_fieldset",title:_T("disk_info","disk_update_db_title"),items:[{xtype:"syno_displayfield",fieldLabel:_T("service","service_ddns_last_updated"),id:this.dbLastUpdateTimeId=Ext.id(),value:"--"},{xtype:"syno_button",text:_T("disk_info","disk_update_db_btn"),id:this.updateDbBtnId=Ext.id(),handler:this.onUpdateDb,scope:this},{xtype:"syno_displayfield",scope:this,htmlEncode:false,value:'<span class="red-status">'+_T("disk_info","disk_update_db_desc")+"</span>"}]});var c=Ext.apply({title:_T("disk_info","disk_info_general"),itemId:"general",useDefaultBtn:true,border:false,items:a,labelWidth:250},b);this.callParent([c]);if("no"===_D("support_dual_head","no")){this.mon(Ext.getCmp(this.BSThrChkBxId),"check",function(d,e){Ext.getCmp(this.BSThrNumId).setDisabled(!e)},this);this.mon(Ext.getCmp(this.RemainLifeThrChkBxId),"check",function(d,e){Ext.getCmp(this.RemainLifeThrNumId).setDisabled(!e)},this)}},getNextReportDate:function(d){if(!d){return"--"}var a=new Date();var c=a.getFullYear();var b=a.getMonth();if(11===b){c=c+1}b=(b+1)%12;return String.format(_T("login","date_format"),_T("login","mon_"+(b+1)),1,c)+" 00:00:00"},getFormatTime:function(h){if(!h){return"--"}var b=new Date(h*1000);var g=b.getFullYear();var f=b.getMonth();var d=b.getDate();var a=("0"+b.getHours()).slice(-2);var e=("0"+b.getMinutes()).slice(-2);var c=("0"+b.getSeconds()).slice(-2);return String.format("{0} {1}:{2}:{3}",String.format(_T("login","date_format"),_T("login","mon_"+(f+1)),d,g),a,e,c)},onSendReportNow:function(){var a;this.appWin.setStatusBusy();this.appWin.sendWebAPI({api:"SYNO.Storage.CGI.HddMan",method:"send_health_report",version:1,scope:this,callback:function(c,b){this.appWin.clearStatusBusy();if(c){a=_T("vpnc","sent")}else{a=_T("error","error_error_system")}this.appWin.getMsgBox().alert(_T("notification","notification_email"),a)}})},onActivate:function(){this.appWin.sendWebAPI({api:"SYNO.Storage.CGI.HddMan",method:"get",version:1,scope:this,callback:function(b,a){if(!b){return}this.getForm().setValues(a);Ext.getCmp(this.updateDbBtnId).setDisabled(!a.db_update_need);Ext.getCmp(this.dbLastUpdateTimeId).setValue(this.getFormatTime(a.db_last_update_time));Ext.getCmp(this.dbLastUpdateTimeId).originalValue=Ext.getCmp(this.dbLastUpdateTimeId).getValue();if("no"===_D("support_dual_head","no")){Ext.getCmp(this.BSThrNumId).setDisabled(!a.BadSctrThrEn);Ext.getCmp(this.RemainLifeThrNumId).setDisabled(!a.RemainLifeThrEn)}Ext.getCmp(this.lblNextDateId).setValue(this.getNextReportDate(a.healthReportEn));Ext.getCmp(this.lblNextDateId).originalValue=Ext.getCmp(this.lblNextDateId).getValue();Ext.getCmp(this.SendReportNowId).setDisabled(!a.healthReportEn);Ext.getCmp(this.HealthCheckboxId).setDisabled(!a.chkMailSetting);Ext.getCmp(this.lblNextDateId).setVisible(a.chkMailSetting);Ext.getCmp(this.SendReportNowId).setVisible(a.chkMailSetting);if(this.appWin.supportSas){Ext.getCmp(this.HealthNoteId).setVisible(false);Ext.getCmp(this.HealthNoteWithSupportId).setVisible(!a.chkMailSetting);Ext.getCmp(this.healthSupportNoteId).setVisible(a.chkMailSetting)}else{Ext.getCmp(this.HealthNoteId).setVisible(!a.chkMailSetting);Ext.getCmp(this.HealthNoteWithSupportId).setVisible(false);Ext.getCmp(this.healthSupportNoteId).setVisible(false)}}});this.doLayout()},applyForm:function(){var b=this,a=b.getForm(),c;if(false===b.onBeforeAction(a,"set")){return}c={action:"apply"};c.healthReportEn=a.getValues().healthReportEn;if("no"===_D("support_dual_head","no")){c.BadSctrThrEn=a.getValues().BadSctrThrEn;c.BadSctrThrVal=a.getValues().BadSctrThrVal;c.RemainLifeThrEn=a.getValues().RemainLifeThrEn;c.RemainLifeThrVal=a.getValues().RemainLifeThrVal}b.setStatusBusy();b.appWin.sendWebAPI({api:"SYNO.Storage.CGI.HddMan",method:"set",version:1,params:c,scope:this,callback:function(e,d){b.clearStatusBusy();if(e){this.getForm().setValues(d);Ext.getCmp(this.SendReportNowId).setDisabled(!d.healthReportEn);Ext.getCmp(this.lblNextDateId).setValue(this.getNextReportDate(d.healthReportEn));Ext.getCmp(this.lblNextDateId).originalValue=Ext.getCmp(this.lblNextDateId).getValue();b.setStatusOK();b.appWin.stopPollTask();b.appWin.startPollTask()}else{this.getForm().reset();if(d.errors){b.setStatusError({text:_T(d.errors.errinfo.sec,d.errors.errinfo.key)})}else{b.setStatusError()}}}})},openNotificationWizard:function(b){var a=b.el.child(".link-font");if(a){this.mon(a,"click",function(){SYNO.SDS.AppLaunch("SYNO.SDS.AdminCenter.Application",{fn:"SYNO.SDS.AdminCenter.Notification.Main",tab:"mailSettingTab"})},this)}},onUpdateDb:function(){var a=this;a.appWin.setStatusBusy();a.appWin.sendWebAPI({api:"SYNO.Storage.CGI.Smart",method:"update_smartctl_db",version:1,scope:a,callback:function(c,b){a.appWin.clearStatusBusy();if(!c){a.appWin.getMsgBox().alert("",_T("error","error_error_system"));return}Ext.getCmp(a.updateDbBtnId).setDisabled(true);Ext.getCmp(a.dbLastUpdateTimeId).setValue(a.getFormatTime(b.db_last_update_time));Ext.getCmp(a.dbLastUpdateTimeId).originalValue=Ext.getCmp(a.dbLastUpdateTimeId).getValue()}})}});Ext.define("SYNO.SDS.StorageManager.Disk.SystemRaidPanel",{extend:"SYNO.ux.Panel",constructor:function(a){var c=this,b,d=[];c.trayData={};c.minDisksCount=999;c.bUpdateSetting=true;c.appWin=a.appWin;c.owner=a.owner;c.gridView=new SYNO.SDS.StorageManager.Disk.SystemRaidDiskGridViewPanel({appWin:c.appWin,owner:c});d.push({xtype:"syno_button",itemId:"syncButton",text:_T("volume","system_raid_sync_conf"),handler:c.onSyncSetting,scope:c});b={title:_T("volume","system_title"),layout:"card",region:"center",itemId:"systemRaidPanel",tbar:{items:d},activeItem:0,items:c.gridView,listeners:{activate:c.onActivate,scope:c}};c.callParent([Ext.apply(b,a)])},onActivate:function(){this.updateButton();if(!this.bUpdateSetting){this.loadUiData(this.trayData.trays)}else{this.owner.setStatusBusy();SYNO.API.Request({api:"SYNO.Storage.CGI.Storage",version:1,method:"load_system_raid",callback:function(d,b,c,a){this.trayData=b;this.minDisksCount=this.trayData.min_disks_count;this.bUpdateSetting=true;this.loadUiData(this.trayData.trays);this.owner.clearStatusBusy()},scope:this});this.bUpdateSetting=false}},updateButton:function(){var a=this.getTopToolbar().getComponent("syncButton");if(this.appWin.env.isSyncSysPartition){a.disable();a.setText(_T("volume","system_raid_in_syncing"))}else{a.enable();a.setText(_T("volume","system_raid_sync_conf"))}},updateStore:function(){var e=this.layout.activeItem.store;var f,d,c,b;var a={};for(f=0;f<e.getCount();f++){d=e.getAt(f);a[d.id]=d}for(f=0;f<this.uiData.length;f++){c=this.uiData[f];d=a[c.id];if(!d){b=new e.recordType(c,c.id);e.insert(f,b);continue}else{d.set("model",c.model);d.set("totalSize",c.totalSize);d.set("displayTotalSize",c.displayTotalSize);d.set("diskType",c.diskType);d.set("diskStatus",c.diskStatus);d.set("trayStatus",c.trayStatus);d.set("isNormal",c.isNormal);d.set("isSynoPartition",c.isSynoPartition);if(d.modified){delete d.modified.model;delete d.modified.totalSize;delete d.modified.displayTotalSize;delete d.modified.diskType;delete d.modified.diskStatus;delete d.modified.trayStatus;delete d.modified.isNormal;delete d.modified.isSynoPartition}}a[c.id]=undefined}for(f=0;f<e.getCount();f++){d=e.getAt(f);if(a[d.id]){e.remove(d)}}},loadUiData:function(b){var c=this;var a=c.layout.activeItem.store;c.prepareUiData(b);a.suspendEvents(true);if(this.bUpdateSetting){a.loadData(c.uiData,false);c.bUpdateSetting=false}else{c.updateStore()}a.resumeEvents()},prepareUiData:function(b){var c=this,d;var a=c.appWin.disks;var e=("yes"===_D("support_dual_head","no"))?true:false;a=(0===a.count)?[]:(e?a.getMatched("isInEbox"):a.getMatched("isInternal","isNormalTray"));delete c.uiData;c.uiData=[];Ext.each(a,function(f){d={};if("disabled"===f.get("portType")){c.preparePort(f,d)}else{c.prepareSummary(f,d,b)}c.uiData.push(d)},c);c.uiData.sort(SYNO.SDS.StorageUtils.DiskSort)},preparePort:function(a,b){b.id=a.get("id");b.numId=parseInt(a.get("num_id"),10);b.ctnOrder=0;b.displayName=SYNO.SDS.StorageUtils.DiskDisplayNameGet(a);b.model="-";b.displayTotalSize="-";b.diskType="-";b.diskStatus=String.format('<span class="red-status">{0}</span>',_T("disk_info","disk_disable_title"));b.trayStatus="-";b.allowJoin=true;b.isNormal=false;b.isSynoPartition=false;b.pciSlot=a.get("pciSlot")},prepareSummary:function(a,d,c){var f=this,e,h;var i=SYNO.SDS.StorageUtils;var b=a.get("container");var g=parseInt(a.get("size_total"),10);d.id=a.get("id");d.numId=parseInt(a.get("num_id"),10);d.ctnOrder=parseInt(b.order,10);d.displayNameHashValue=i.DiskNameHashValueGet(d.ctnOrder,d.numId,a.get("portType"));d.totalSize=g/1024/1024/1024;d.model=a.get("model");d.displayName=SYNO.SDS.StorageUtils.DiskDisplayNameGet(a);d.pciSlot=a.get("pciSlot");h=String.format("{0} {1}",d.totalSize.toFixed(2),_T("status","status_disk_size_unit"));e=("hotspare"===a.get("used_by"))?"hotspare":a.get("status");d.diskStatus=i.DiskStatusRender(e);d.displayTotalSize=h;d.diskType=i.DiskTypeRender(a,f.appWin.supportSas);d.trayStatus=a.get("tray_status");d.allowJoin=f.searchTrayConf(c,d.numId,d.ctnOrder);d.isNormal="normal"===e;d.isSynoPartition=a.get("isSynoPartition");d.portType=a.get("portType")},searchTrayConf:function(d,b,a){var c;for(c=0;c<d.length;c++){if(b===d[c].num&&a===d[c].cnrIdx){return d[c].join}}return true},onSyncSetting:function(){var j=this.layout.activeItem.store;var e,h,d,c,m,l;var f=("yes"===_D("support_dual_head","no"))?true:false;var g=this;var k=0;var b=true;var a=[];for(e=0;e<j.getCount();e++){h=j.getAt(e).data;if("ssd cache"===h.trayStatus){continue}if(false===h.allowJoin){b=false;continue}if(false===h.isSynoPartition){a.push(h.displayName)}k++}if(this.minDisksCount>k&&!b){d=String.format(_T("volume","system_raid_min_disk_limit_alert"),this.minDisksCount);this.appWin.getMsgBox().alert("",d);return}if(0<a.length){c=_T("volume","system_raid_create_sys_partition_alert");c+="</br></br>";c+=a.join(", ");l=a.length*20/(f?2.5:6);l=(300<l)?300:l;m=new SYNO.SDS.StorageManager.Dialog.Confirm({owner:this.owner,title:this.owner.title,winHeight:l,confirmBtnStyle:"red",message:c,confirmText:_T("volume","system_raid_create_sys_partition_confirm"),callback:function(){g.sendRequest(j)}});m.open();return}this.sendRequest(j)},sendRequest:function(b){var d,a,c=[];this.appWin.setStatusBusy();for(d=0;d<b.getCount();d++){a=b.getAt(d);c.push({num:a.data.numId,cnrIdx:a.data.ctnOrder,allow_join:a.data.allowJoin})}SYNO.API.Request({api:"SYNO.Storage.CGI.Storage",method:"set_system_raid",version:1,params:{trays:c},callback:function(h,e,g,f){if(h){this.appWin.getMsgBox().alert("",_T("tree","okpage"));this.clearDirty();this.appWin.env.isSyncSysPartition=true;this.updateButton()}else{this.appWin.getMsgBox().alert("",_T("router_tc","op_msg_failed_apply"))}this.appWin.clearStatusBusy()},scope:this})},clearDirty:function(){var b=this.layout.activeItem.store;var c,a;for(c=0;c<b.getCount();c++){a=b.getAt(c);a.commit()}}});Ext.namespace("SYNO.SDS.StorageManager.HotSpare");SYNO.SDS.StorageManager.HotSpare.SupportedRaidLevel=["raid_1","raid_5","raid_6","raid_10","raid_f1","shr_with_1_disk_protect","shr_with_2_disk_protect"];Ext.define("SYNO.SDS.StorageManager.Wizard.ManageSpare",{extend:"SYNO.SDS.Wizard.ModalWindow",constructor:function(a){var c=this,b;c.isDataChanged=false;c.appWin=a.appWin;c.owner=a.owner;b={title:_T("volume","volume_spare_manage_wizard_title"),width:910,height:580,border:false,cls:"sm-manage-spare",layout:"fit",steps:[]};b.steps.push(new SYNO.SDS.StorageManager.Wizard.ConfigSpare({appWin:c.appWin,itemId:"edit",nextId:null}));c.callParent([Ext.apply(b,a)])},applySettings:function(a){var b=this;b.setStatusBusy({text:_T("common","saving")});b.sendWebAPI({api:a.api,method:a.method,version:a.version,params:a.params,scope:b,callback:function(e,d,c){b.clearStatusBusy();if(!e){b.getMsgBox().alert(b.title,d.text?d.text:_T("common","error_system"));return}b.isDataChanged=true;b.close()}})}});Ext.define("SYNO.SDS.StorageManager.Wizard.ConfigSpare",{extend:"SYNO.ux.Panel",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.spares=c.appWin.hotSpares.getAll();c.createTreeNode();c.initRaidGroupPanel();c.initDiskPanel();c.supportRaidCross=("yes"===_D("supportraidcross","no"));b={headline:_T("volume","volume_spare_manage_title"),description:_T("volume","volume_spare_manage_desc"),layout:{type:"hbox",align:"stretch"},bwrapCfg:{cls:"x-panel-bwrap",style:{padding:"8px 20px 4px 20px"}},border:false,items:[c.raidGroupPanel,new Ext.Panel({width:10,bodyStyle:{"border-top":"0","border-left":"1px solid #C8D2Dc","border-bottom":"0","border-right":"0"}}),c.diskPanel]};c.callParent([Ext.apply(b,a)])},initRaidGroupPanel:function(){this.raidGroupView=new Ext.DataView({store:new Ext.data.JsonStore({autoDestory:true,root:"pools",idProperty:"id",fields:["id","name","status","type","available","count","desc","sparedDisk"]}),tpl:this.getRaidGroupTpl(),autoHeight:true,itemSelector:"div.sds-space-spare-group-wrapper"});this.raidGroupPanel=new Ext.Panel({itemId:"raidGroup",title:_T("volume","volume_raid_group_status"),border:false,width:544,items:this.raidGroupView,autoScroll:true})},getRaidGroupTpl:function(){var a=new Ext.XTemplate('<div style="line-height:28px;">','<div style="float:left;width:120px;"><div class="sm-manage-spare-illustrate-spared"></div><div>'+_T("volume","volume_spared")+"</div></div>",'<div style="float:left;width:120px;"><div class="sm-manage-spare-illustrate-available"></div><div>'+_T("volume","volume_spare_available")+"</div></div>",'<div style="float:left;width:200px;"><div class="sm-manage-spare-illustrate-not-available"></div><div>'+_T("volume","volume_spare_not_available")+"</div></div>","</div>",'<div class="x-clear"></div>',"<div>",'<tpl for=".">','<div class="sm-spare-mgr-spare-wrapper">','<div class="sm-spare-mgr-spare-bg sm-spare-mgr-spare-bg-{status}">','<div class="sm-spare-mgr-spare-fg sm-spare-mgr-spare-fg-{status}"></div>',"</div>",'<div class="sm-spare-mgr-space-name">{name}</div>','<div ext:qtip="{[Ext.util.Format.htmlEncode(values.desc)]}" class="sm-spare-mgr-space-desc">{desc}</div>','<div class="sm-spare-mgr-space-type">{type}</div>',"<tpl if=\"available == 'yes'\">",'<div class="sm-spare-mgr-spared-count">{sparedDisk}</div>','<div class="sm-spare-mgr-spared-string">'+_T("volume","volume_spared_hdd")+"</div>","</tpl>","<tpl if=\"available == 'no'\">",'<div class="sm-spare-mgr-not-available">'+_T("volume","volume_spare_not_available")+"</div>","</tpl>","</div>","</tpl>","</div>","</div>");return a},initDiskPanel:function(){this.diskPanel=new Ext.tree.TreePanel({autoFlexcroll:true,itemId:"disks",title:_T("volume","volume_available_disks"),cls:"sds-space-spare sds-space-spare-available-disks",useArrows:true,border:false,width:310,animate:false,bodyStyle:"overflow-x: hidden;overflow-y:auto;",enableDD:false,rootVisible:false,listeners:{click:this.onClick,dblclick:function(b,c){b.ui.checkbox.checked=b.ui.anchor.hasClassName("x-tree-node-anchor-checked")},scope:this}});var a=new Ext.tree.AsyncTreeNode({draggable:false,expanded:true,id:"fm_root",allowDrop:false,checked:"unchecked",leaf:false,children:this.containers});this.diskPanel.setRootNode(a)},createTreeNode:function(){var d=this,a=[],e={},c,b;Ext.each(d.appWin.disks.getAll(),function(f){if((f.isNormalTray()&&f.isFree()&&f.notUsedBySpace())||f.inSpare(this.appWin.hotSpares.data)){a.push(f)}},d);Ext.each(a,function(k){var g="internal"===k.get("container").type?_S("hostname"):k.get("container").str;var f=e[g];if(!f){f={};f.htmlEncode=false;f.text=String.format('<span style="font-weight:bold">{0}</span>',g);f.id=g;f.leaf=false;f.expanded=true;f.checked=true;f.children=[];f.order=(k.get("container").order)?parseInt(k.get("container").order,10):0;e[g]=f}var j=false,i=false;var h=this.appWin.hotSpares.data[k.get("id")];if(h){j=true;if("standby"!==h.get("status").type){i=true}}b=String.format("{0} - {1} {2} {3} {4}",SYNO.SDS.StorageUtils.DiskDisplayNameGet(k),k.get("diskType"),k.get("isSsd")?"SSD":"HDD",SYNO.SDS.StorageUtils.SizeRender(k.get("size_total")),k.get("is4Kn")?String.format("({0})",_T("volume","4kn")):"");f.checked=f.checked&&j;f.children.push({text:b,id:k.get("id"),leaf:true,checked:j,disabled:i,qtip:b,numId:k.get("num_id"),pciSlot:k.get("pciSlot"),portType:k.get("portType"),ctnOrder:parseInt(k.get("container").order,10)});f.children.sort(SYNO.SDS.StorageUtils.DiskSort)},d);d.containers=[];for(c in e){if(e.hasOwnProperty(c)){d.containers.push(e[c])}}d.containers.sort(function(g,f){return(g.order>f.order)?1:((g.order===f.order)?0:-1)})},activate:function(){this.processStoragePool();this.raidGroupView.getStore().loadData(this.data,false);this.setDiskCheckUI();if(0===this.data.pools.length){this.getComponent("raidGroup").body.mask(_T("volume","volume_no_raid_with_protection"),"syno-ux-mask-info")}else{this.getComponent("raidGroup").body.unmask()}if(0===this.containers.length){this.getComponent("disks").bwrap.mask(_T("volume","volume_no_available_disks"),"syno-ux-mask-info")}else{this.getComponent("disks").body.unmask()}},setDiskCheckUI:function(){this.diskPanel.root.childNodes.each(function(b){var a;if(b.ui.checkbox.checked){a=new Ext.Element(b.ui.anchor);a.addClass("x-tree-node-anchor-checked")}b.childNodes.each(function(c){if(c.ui.checkbox.checked){a=new Ext.Element(c.ui.anchor);a.addClass("x-tree-node-anchor-checked")}},this)},this)},processStoragePool:function(){var h=this,i=SYNO.SDS.StorageUtils,e,f,a,g=h.appWin.hotSpareConf.disable_repair;var c=this.supportRaidCross&&this.appWin.hotSpareConf.cross_repair;var d=SYNO.SDS.StorageManager.HotSpare.SupportedRaidLevel;var b=h.appWin.storagePools.getMatched(function(){return this.canRepair(g)},h);h.data={pools:[]};Ext.each(b,function(m){m.spare={};if(-1===d.indexOf(m.get("device_type"))){return true}if("crashed"===m.get("status")){return true}if("SSD"!==m.getDriveType()&&"HDD"!==m.getDriveType()){return true}e={};e.type="pool";e.order=m.get("num_id");e.id=m.id;e.name=i.SpaceIDParser(m.id).str;e.desc=m.get("desc");e.raidType=i.RaidLevelRender(m.get("device_type"));a=true;e.sparedDisk=0;e.disks=m.get("disks");e.container=m.get("container");e.driveType=m.getDriveType();var k=h.appWin.disks.getMatched("notUsedBySpace");var n=h.appWin.hotSpares.getAll();var l=(-1!==m.get("device_type").indexOf("shr"));var j;if(l){e.minDiskSize=m.get("minimal_disk_size");if(0<e.disks.length){j=this.appWin.disks.data[e.disks[0]]}n.each(function(o){var p=this.appWin.disks.data[o.id];if(!j){return false}if(!c){if("cross"===e.container||("internal"===e.container&&"internal"!==p.get("container").type)||("ebox"===e.container&&j.get("container").order!==p.get("container").order)){return true}}if("Hybrid"===e.driveType||"Unknown"===e.driveType||("SSD"===e.driveType&&p&&!p.get("isSsd"))||("HDD"===e.driveType&&p&&p.get("isSsd"))){return true}if(p&&parseInt(p.get("size_total"),10)>=parseInt(e.minDiskSize,10)&&p.get("diskType")==="SATA"&&"standby"===o.get("status").type&&p.is4Kn()===j.is4Kn()){if(!m.spare[o.id]){m.spare[o.id]=1;e.sparedDisk++}}},h);Ext.each(k,function(o){if(parseInt(o.get("size_total"),10)>=parseInt(e.minDiskSize,10)&&o.get("diskType")==="SATA"&&o.is4Kn()===j.is4Kn()){e.available="yes";return false}},h)}else{if(0<e.disks.length){j=this.appWin.disks.data[e.disks[0]]}Ext.each(m.get("raids"),function(p){if(a){for(var o=0;o<p.devices.length;++o){f=this.appWin.disks.data[p.devices[o].id];if(!f){continue}break}e.hddType=f?f.get("diskType"):"";e.is4Kn=f.is4Kn();a=false}n.each(function(q){var r=h.appWin.disks.data[q.id];if(!c){if("cross"===e.container||("internal"===e.container&&"internal"!==r.get("container").type)||("ebox"===e.container&&j.get("container").order!==r.get("container").order)){return true}}if("Hybrid"===e.driveType||"Unknown"===e.driveType||("SSD"===e.driveType&&r&&!r.get("isSsd"))||("HDD"===e.driveType&&r&&r.get("isSsd"))){return true}if(r&&parseInt(r.get("size_total"),10)>=parseInt(p.minDevSize,10)&&r.get("diskType")===e.hddType&&r.is4Kn()===e.is4Kn&&"standby"===q.get("status").type){if(!m.spare[q.id]){m.spare[q.id]=1;e.sparedDisk++}}},this);Ext.each(k,function(q){if(parseInt(q.get("size_total"),10)>=parseInt(p.minDevSize,10)&&q.get("diskType")===h.appWin.disks.data[m.get("disks")[0]].get("diskType")&&q.is4Kn()===h.appWin.disks.data[m.get("disks")[0]].is4Kn()){e.available="yes";return false}},h)},h)}delete m.spare;e.orgSparedDisk=e.sparedDisk;e.available=e.available||"no";if(0<e.sparedDisk){e.status="spared"}else{if("yes"===e.available){e.status="available"}else{e.status="not-available"}}e.type=String.format("{0} {1} / {2}",l?"SATA":e.hddType,m.getDriveTypeStr(),e.raidType);h.data.pools.push(e)},h);h.data.pools.sort(function(k,j){if(k.order>j.order){return 1}if(k.order<j.order){return -1}return 0})},onClick:function(d,g){var b=new Ext.Element(d.ui.anchor);var c;if(d instanceof Ext.tree.AsyncTreeNode){b.toggleClass("x-tree-node-anchor-checked");c=b.hasClass("x-tree-node-anchor-checked");d.ui.checkbox.checked=c;d.childNodes.each(function(h){var e=new Ext.Element(h.ui.anchor);if(h.disabled){return true}h.ui.checkbox.checked=c;if(c&&!e.hasClass("x-tree-node-anchor-checked")){e.addClass("x-tree-node-anchor-checked")}else{if(!c){e.removeClass("x-tree-node-anchor-checked")}}})}else{b.toggleClass("x-tree-node-anchor-checked");c=b.hasClass("x-tree-node-anchor-checked");d.ui.checkbox.checked=c;var f=new Ext.Element(d.parentNode.ui.anchor);if(!c){d.parentNode.ui.checkbox.checked=false;f.removeClass("x-tree-node-anchor-checked")}else{var a=true;d.parentNode.childNodes.each(function(e){if(!e.ui.checkbox.checked){a=false;return false}});if(a){d.parentNode.ui.checkbox.checked=true;f.addClass("x-tree-node-anchor-checked")}}}this.checkSpareCoverage()},checkSpareCoverage:function(){var c=this,a=[];var b=this.supportRaidCross&&this.appWin.hotSpareConf.cross_repair;this.diskPanel.root.childNodes.each(function(e){e.childNodes.each(function(f){if(f.ui.checkbox.checked&&!f.disabled){a.push(f.id)}},this)},this);var d=c.appWin.hotSpares;Ext.each(this.data.pools,function(h){var f=c.appWin.storagePools.getById(h.id);var g=(-1!==f.get("device_type").indexOf("shr"));var e;h.sparedDisk=0;h.spare={};if(g){Ext.each(a,function(k){var j=c.appWin.disks.data[k];var i=d[k];if(0===h.disks.length){return true}e=c.appWin.disks.data[h.disks[0]];if(!b){if("cross"===h.container||("internal"===h.container&&"internal"!==j.get("container").type)||("ebox"===h.container&&e.get("container").order!==j.get("container").order)){return true}}if("Hybrid"===h.driveType||"Unknown"===h.driveType||("SSD"===h.driveType&&!j.get("isSsd"))||("HDD"===h.driveType&&j.get("isSsd"))){return true}if(j&&parseInt(j.get("size_total"),10)>=parseInt(h.minDiskSize,10)&&j.get("diskType")==="SATA"&&(!i||"standby"===i.get("status").type)&&j.is4Kn()===e.is4Kn()){if(!h.spare[k]){h.spare[k]=1;h.sparedDisk++}}},this)}else{if(0<h.disks.length){e=this.appWin.disks.data[h.disks[0]]}Ext.each(f.get("raids"),function(i){var j;if(!i.devices||0===i.devices.length){return true}j=c.appWin.disks.data[i.devices[0].id];Ext.each(a,function(m){var l=c.appWin.disks.data[m];var k=d.getById(m);if(!b){if("cross"===h.container||("internal"===h.container&&"internal"!==l.get("container").type)||("ebox"===h.container&&e.get("container").order!==l.get("container").order)){return true}}if("Hybrid"===h.driveType||"Unknown"===h.driveType||("SSD"===h.driveType&&!l.get("isSsd"))||("HDD"===h.driveType&&l.get("isSsd"))){return true}if(l&&parseInt(l.get("size_total"),10)>=parseInt(i.minDevSize,10)&&l.get("diskType")===h.hddType&&(!k||"standby"===k.get("status").type)&&l.is4Kn()===j.is4Kn()){if(!h.spare[m]){h.spare[m]=1;h.sparedDisk++}}},this)},this)}delete h.spare;if(0<h.sparedDisk){h.status="spared"}else{if("yes"===h.available){h.status="available"}else{h.status="not-available"}}},this);this.raidGroupView.getStore().loadData(this.data,false)},getNext:function(){var d=false;var c=[];var a={};this.diskPanel.root.childNodes.each(function(e){e.childNodes.each(function(f){if(f.ui.checkbox.checked){if(!this.appWin.hotSpares[f.id]){d=true}a[f.id]=true;c.push({path:"/dev/"+f.id,model:this.appWin.disks.data[f.id].get("model")})}},this)},this);if(!d){Ext.each(this.appWin.hotSpares.getAll(),function(e){if(!a[e.id]){d=true;return false}},this)}if(!d){this.owner.close();return false}var b={api:"SYNO.Storage.CGI.Spare",method:"set",version:1,params:{spares:c}};if(0<c.length){this.owner.getMsgBox({btnStyle:"red"}).confirm(this.owner.title,_T("volume","volume_adddisk_type_two_warning"),function(e){if("yes"===e){this.owner.applySettings(b)}},this)}else{this.owner.applySettings(b)}return false}});Ext.define("SYNO.SDS.StorageManager.Wizard.AdvSetSpare",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var d=this,c,b=[];d.supportRaidCross=("yes"===_D("supportraidcross","no"));d.isDataChanged=false;b.push({xtype:"syno_formpanel",trackResetOnLoad:true,title:_T("volume","volume_raid_group"),appWin:a.appWin,owner:a.owner,width:610,height:375,items:[{xtype:"syno_displayfield",value:_T("volume","spare_trg_desc_raid_group")},d.grid=d.createSpaceGrid()]});if(d.supportRaidCross){b.push({xtype:"syno_formpanel",trackResetOnLoad:true,title:_T("volume","spare_cross"),appWin:a.appWin,owner:a.owner,itemId:"spare_cross",items:[{xtype:"syno_checkbox",boxLabel:_T("volume","spare_cross_enable"),itemId:"cross_repair"},{xtype:"syno_displayfield",indent:1,value:_T("volume","spare_cross_desc_raid_group")}]})}c={title:_T("volume","spare_setting_title"),width:650,height:500,resizable:false,layout:"fit",border:false,items:[{xtype:"syno_tabpanel",activeTab:0,itemId:"spare_conf",items:b}],buttons:[{xtype:"syno_button",btnStyle:"blue",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","alt_apply"),scope:d,handler:d.onSave},{xtype:"syno_button",text:_T("common","alt_cancel"),scope:d,handler:d.onCancel}]};d.callParent([Ext.apply(c,a)])},createSpaceGrid:function(){var b=new SYNO.ux.EnableColumn({dataIndex:"enabled",id:"enable",bindRowClick:true,sortable:true,align:"center"});var a=Ext.apply({enableHdMenu:false,enableColumnMove:false,layout:"fit",width:590,height:320,style:{padding:"5px 0px 0px 0px"},cls:"without-dirty-red-grid",plugins:b,columns:[b,{header:_T("common","name"),dataIndex:"name",width:200},{header:_T("volume","volume_raid_type"),dataIndex:"raidType",width:150},{header:_T("volume","volume_disk_type"),dataIndex:"diskType",width:150}],store:new Ext.data.JsonStore({autoDestroy:true,fields:["id","enabled","name","raidType","diskType","space_path"],idProperty:"id",root:"spaces"})});return new SYNO.ux.GridPanel(a)},getTabForm:function(a){return this.getComponent("spare_conf").getComponent(a).form},getSpaces:function(){var e=this;var b=SYNO.SDS.StorageManager.HotSpare.SupportedRaidLevel;var a=SYNO.SDS.StorageUtils;var c=e.appWin.storagePools.getAll();e.spaceData={spaces:[]};for(var d=0;d<c.length;++d){var g={},f=c[d];if(-1===b.indexOf(f.get("device_type"))){continue}if("SSD"!==f.getDriveType()&&"HDD"!==f.getDriveType()){continue}g.id=f.id;g.enabled=true;g.name=a.SpaceIDParser(f.id).str;g.raidType=a.RaidLevelRender(f.get("device_type"));g.diskType=e.appWin.disks.data[f.get("disks")[0]].get("diskType")+" "+f.getDriveTypeStr();g.space_path=f.get("space_path");e.appWin.hotSpareConf.disable_repair.each(function(h){if(h===g.space_path){g.enabled=false;return false}},e);e.spaceData.spaces.push(g)}e.spaceData.spaces.sort(function(i,h){if(i.id>h.id){return 1}if(i.id<h.id){return -1}return 0})},onOpen:function(){var a=this;a.callParent(arguments);if(a.supportRaidCross){a.getTabForm("spare_cross").setValues(a.appWin.hotSpareConf)}a.getSpaces();a.grid.getStore().loadData(a.spaceData,false)},onSave:function(){var d=this,e={},a=d.grid.getStore(),b=[];if(d.supportRaidCross&&!d.getTabForm("spare_cross").isDirty()&&0===a.getModifiedRecords().length){d.close();return}for(var c=0;c<a.getCount();++c){if(!a.getAt(c).get("enabled")){b.push(a.getAt(c).get("space_path"))}}if(d.supportRaidCross){e.cross_repair=d.getTabForm("spare_cross").findField("cross_repair").getValue()}e.disable_repair=b;d.sendWebAPI({api:"SYNO.Storage.CGI.Spare.Conf",method:"set",version:1,params:e,scope:d,callback:function(h,g,f){d.clearStatusBusy();if(!h){d.getMsgBox().alert(_T("volume","spare_setting_title"),g.text?g.text:_T("common","error_system"));return}d.isDataChanged=true;d.close()}})},onCancel:function(){this.close()}});Ext.define("SYNO.SDS.StorageManager.Spare.Store",{extend:"Ext.data.JsonStore",constructor:function(a){var c=this,b;b={autoDestroy:true,idProperty:"id",fields:["numId","id","iconCls","statusIconCls","displayName","summaryStatus","desc","property","spaces","ctnOrder","portType","pciSlot"]};c.callParent([Ext.apply(b,a)])}});Ext.define("SYNO.SDS.StorageManager.HotSpare.Main",{extend:"SYNO.ux.Panel",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.appWin;c.createView();b={itemId:"hot_spare",border:false,layout:"fit",tbar:{defaultType:"syno_button",items:[{itemId:"manage",text:_T("volume","volume_manage"),handler:this.onManage,scope:this},{itemId:"advset",text:_T("common","configure"),handler:this.onAdvSet,scope:this}]},items:c.view,listeners:{activate:c.onActivate,scope:c}};c.callParent([Ext.apply(b,a)])},getHelpParam:function(){return"StorageManager/hotspare.html"},getColumns:function(){var a=[];a.push({header:_T("common","name"),dataIndex:"name"});if(this.appWin.supportRaidGroup){a.push({header:_T("volume","volume_raid_subgroup"),dataIndex:"number"})}a.push.apply(a,[{header:_T("volume","volume_raid_title"),dataIndex:"raidLevel"},{header:_T("volume","volume_diskstatus"),dataIndex:"status"}]);return a},createView:function(){var d=this,c,b,a;c=new SYNO.SDS.StorageManager.ListTpl({scope:"spaces",title:_T("volume","volume_spare_protected_raid"),emptyText:_T("volume","volume_spare_no_protected_raid"),columns:this.getColumns()});b=new Ext.XTemplate('<div class="item-detail-inner">',c.html,"</div>");a={appWin:d.appWin,owner:d,dataType:"hotSpares",itemId:"spareView",multiSelect:false,singleSelect:false,selectedClass:"",store:new SYNO.SDS.StorageManager.Spare.Store()};d.view=new SYNO.SDS.StorageManager.DataView(a)},prepareUiData:function(){var b=this,d=b.appWin.hotSpares.getAll(),a,c;delete b.uiData;b.uiData=[];for(a=0;a<d.length;++a){c={};b.prepareSummary(d[a],c);b.prepareSpaces(d[a],c);b.uiData.push(c)}b.uiData.sort(SYNO.SDS.StorageUtils.DiskSort)},prepareSummary:function(b,e){var d=this,c=d.appWin.disks.data[b.id],a=parseInt(c.get("size_total"),10),f,g;e.id=c.get("id");e.displayName=SYNO.SDS.StorageUtils.DiskDisplayNameGet(c);e.summaryStatus=String.format("&nbsp;-&nbsp;{0}",d.getStatusString(b));f=String.format("{0} {1}",(a/1024/1024/1024).toFixed(2),_T("status","status_disk_size_unit"));if(d.appWin.supportSas){g=String.format("{0} / {1}",c.get("diskType"),(c.get("isSsd"))?"SSD":"HDD")}else{g=(c.get("isSsd"))?"SSD":"HDD"}e.desc=String.format("{0} {1}",f,g);e.iconCls="sm-list-icon-spare";e.numId=c.get("num_id");e.pciSlot=c.get("pciSlot");e.portType=c.get("portType");e.ctnOrder=parseInt(c.get("container").order,10)},prepareSpaces:function(e,c){var b=["raid_1","raid_5","raid_6","raid_10","raid_f1","shr_with_1_disk_protect","shr_with_2_disk_protect"];var f=SYNO.SDS.StorageUtils;var g=this.appWin.storagePools.getAll();var d=this.appWin.disks.data;var a=this.appWin.hotSpareConf.disable_repair;var h=("repairing"===e.get("status").type);var i=d[e.id];if(undefined===i){return}c.spaces=[];Ext.each(g,function(k){var l=0;var j=k.get("space_path");var m=k.get("device_type");if(0>b.indexOf(m)){return true}if(-1<a.indexOf(j)){return true}if(h&&e.get("status").space_path!==j){return true}Ext.each(k.get("raids"),function(o){var n;++l;Ext.each(o.devices,function(p){n=d[p.id];if(n){return false}});if(!n){return true}if(n.get("diskType")!==i.get("diskType")){return true}if(!this.appWin.isSupportRaidCross()&&n.get("container").type!==i.get("container").type){return true}if(parseInt(o.minDevSize,10)<=parseInt(e.get("size"),10)){c.spaces.push({name:f.SpaceIDParser(k.get("id")).str,number:1===k.get("raids").length?"-":l,raidLevel:f.SpaceTypeRender(m),status:f.StatusRender(k.get("status"),k.get("progress"))})}if(k.isSHR()){return false}},this)},this)},getStatusString:function(g){var e=this,j=SYNO.SDS.StorageUtils,c,a,f,h,d,k,b=false;c=g.get("status");if(e.appWin.supportRaidGroup){if("repairing"===c.type){a=e.appWin.storagePools.getMatched(function(){return g.get("status").space_path===this.get("space_path")});if(0<a.length){b=(-1!==a[0].get("device_type").indexOf("shr"));f=j.SpaceIDParser(a[0].get("id")).str;if(!b){h=a[0].get("raids");for(d=0;d<h.length;++d){if(h[d].raidPath===g.get("status").raid_path){k=(d+1).toString();break}}}}}return b?j.SpareStatusRender(c.type,f):j.SpareStatusRender(c.type,f,k)}else{if("repairing"===g.get("status").type){a=e.findSpace(g.get("status").space_path);if(a){f=j.SpaceIDParser(a.get("id")).str}}return j.SpareStatusRender(c.type,f)}},findSpace:function(g){var e=this,b,d=e.appWin.storagePools.getAll(),f,c,a;f=e.appWin.volumes.getMatched(function(){return !this.isLogicalVolume()});c=e.appWin.iscsiLuns.getMatched(function(){return !this.isLogicalVolume()});a=d.concat(f,c);Ext.each(a,function(h){if(g===h.get("space_path")){b=h;return false}},e);return b},setMask:function(){if(this.isVisible()&&0===this.view.getStore().getCount()){this.body.mask(_T("volume","volume_no_spare"),"syno-ux-mask-info")}if(0<this.view.getStore().getCount()){this.body.unmask()}},onActivate:function(){var b=this,a=b.view.store;b.prepareUiData();a.suspendEvents(true);a.loadData(b.uiData,false);a.resumeEvents();if(0<b.view.store.getCount()&&0===b.view.getSelectedItemIds().length){b.view.select(0,true,true)}b.setMask()},onManage:function(){var b=this;var a=new SYNO.SDS.StorageManager.Wizard.ManageSpare({appWin:b.appWin,owner:b.owner});b.appWin.stopPollTask();a.mon(a,"close",function(){if(Ext.isFunction(a.hideFromOwner)){a.hideFromOwner()}if(a.isDataChanged){this.owner.setStatusBusy();this.body.unmask();this.owner.cleanMask=true}this.appWin.startPollTask()},this,{single:true});a.open()},onAdvSet:function(){var b=this;var a=new SYNO.SDS.StorageManager.Wizard.AdvSetSpare({appWin:b.appWin,owner:b.owner});b.appWin.stopPollTask();a.mon(a,"close",function(){if(Ext.isFunction(a.hideFromOwner)){a.hideFromOwner()}if(a.isDataChanged){this.owner.setStatusBusy();this.owner.cleanMask=true}this.appWin.startPollTask()},this,{single:true});a.open()}});Ext.define("SYNO.SDS.StorageManager.Wizard.CreateSsdCache",{extend:"SYNO.SDS.Wizard.ModalWindow",isDataChanged:false,diskStepWarningMsgs:[],estimateMemWarningMsgs:[],constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;b={title:_T("volume","volume_ssd_create_wizard_title"),width:640,height:520,minHeight:475,minWidth:640,resizable:true,border:false,steps:[]};if("yes"===_D("support_write_cache","no")){b.steps.push(new SYNO.SDS.StorageManager.Wizard.CacheModeStep({appWin:c.appWin,freeSSDs:a.freeSSDs,itemId:"cacheMode",nextId:"choose"}))}b.steps.push(new SYNO.SDS.StorageManager.Wizard.CreateChooseSsdStep({appWin:c.appWin,volumes:a.volumes,luns:a.luns,freeSSDs:a.freeSSDs,itemId:"choose"}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.SsdRaidTypeStep({appWin:c.appWin,itemId:"raidType"}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.CacheSizeStep({appWin:c.appWin,itemId:"size",nextId:null}));c.callParent([Ext.apply(b,a)])},applySettings:function(b,a){this.setStatusBusy();SYNO.API.Request({api:"SYNO.Storage.CGI.Flashcache",method:b,version:1,params:a,callback:function(f,e,d,c){var g={};this.clearStatusBusy();if(!f){if(SYNO.SDS.StorageUtils.IsFeasibilityFail(e,g)){SYNO.SDS.StorageUtils.ConfirmFeasibilityFail(this,g,this.applySettings,b,Ext.applyIf({force:true},d))}else{SYNO.SDS.StorageUtils.HARemoteCheckErrParsing(e);SYNO.SDS.StorageUtils.ReportWebapiFailure(this,e)}return}this.getButton("next").enable();this.getButton("next").setText(_T("common","alt_finish"));this.isDataChanged=true;this.close()},scope:this})},getCacheMode:function(){var a=this;if(a.inHistory("cacheMode")){return a.getStep("cacheMode").getCacheMode()}else{return"readCache"}},getTargetSpaceId:function(){return this.getStep("choose").getComponent("target").getValue()},getDiskIds:function(){return this.getStep("choose").getIds()},getRaidType:function(){var a=this;if(a.inHistory("raidType")||(a.inHistory("cacheMode")&&"writeCache"===this.getStep("cacheMode").getForm().getValues().cacheMode)){return a.getStep("raidType").getForm().getValues().raid}else{return"raid_0"}},estimateMem:function(){var c=this,b=c.getTargetSpaceId(),a,d;c.estimateMemWarningMsgs=[];if("yes"===_D("support_write_cache","no")){a=c.getCacheMode();if("writeCache"===a){c.estimateMemWarningMsgs.push(_T("volume","write_cache_protection_warning"))}}else{a="readCache"}d={cacheMode:a,cache_devices:c.getDiskIds(),reference_path:b,raidType:c.getRaidType()};c.setStatusBusy();SYNO.API.Request({api:"SYNO.Storage.CGI.Flashcache",method:"estimate_mem_size",version:1,params:d,callback:function(h,g,f,e){c.clearStatusBusy();if(!h){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,g);return}if(!g.canCreate){c.getMsgBox().alert(c.title,_T("volume","not_enough_mem_for_cache"));return}c.maxCacheSizeGB=Math.floor(SYNO.SDS.StorageUtils.GetSizeGB(parseInt(g.allowedCacheSize,10),0));c.maxCacheSizeByte=g.allowedCacheSize;c.goNext("size")},scope:c})}});Ext.define("SYNO.SDS.StorageManager.Wizard.CacheModeStep",{extend:"SYNO.ux.FormPanel",constructor:function(a){var c=this,b;c.freeSSDs=a.freeSSDs||[];b={headline:_T("volume","volume_add_mode_title"),labelWidth:200,items:[{xtype:"syno_radio",boxLabel:_T("volume","write_cache_option"),name:"cacheMode",itemId:"writeCache",inputValue:"writeCache",disabled:(1>=c.freeSSDs.length)?true:false,checked:(1<c.freeSSDs.length)?true:false},{xtype:"syno_displayfield",indent:1,value:_T("volume","write_cache_desc")},{xtype:"syno_displayfield",indent:1,htmlEncode:false,value:String.format("{0}{1}",'<span class="syno-ux-note">'+_T("common","note")+_T("common","colon")+" </span>",_T("volume","write_cache_warning"))},{xtype:"syno_displayfield",cls:"sm-empty-line"},{xtype:"syno_radio",boxLabel:_T("volume","read_cache_option"),name:"cacheMode",itemId:"readCache",inputValue:"readCache",checked:(1<c.freeSSDs.length)?false:true},{xtype:"syno_displayfield",indent:1,value:_T("volume","read_cache_desc_new")}]};c.callParent([Ext.apply(b,a)])},getCacheMode:function(){return this.getForm().getValues().cacheMode}});Ext.define("SYNO.SDS.StorageManager.Wizard.CreateChooseSsdStep",{extend:"SYNO.ux.FormPanel",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;c.freeSSDs=a.freeSSDs||[];c.volumes=a.volumes||null;c.luns=a.luns||null;c.maxSSD=12;b={headline:_T("volume","volume_ssd_create_wizard_headline"),labelWidth:140,items:[{xtype:"syno_storage_combobox",itemId:"target",name:"target",hiddenName:"target",width:180,displayField:"display",descriptionField:"desc",valueField:"id",emptyText:_T("volume","ssd_cache_selection_hint"),fieldLabel:_T("volume","ssd_cache_on"),tpl:new Ext.XTemplate('<tpl for=".">',"<tpl if=\"type == 'volume'\">",'<div ext:qtip="{tooltip:htmlEncode}" class="x-combo-list-item {[values.conflict?"sm-ssd-combo-disabled-list-item":""]}" style="height: 52px">',"</tpl>","<tpl if=\"type == 'lun'\">",'<div ext:qtip="{tooltip:htmlEncode}" class="x-combo-list-item">',"</tpl>",'<div ext:qtip="{tooltip:htmlEncode}" class="sds-combo-list-item-name">{display}</div>','<div ext:qtip="{tooltip:htmlEncode}" class="sds-combo-list-item-description">{desc}</div>',"</div>","</tpl>"),store:new Ext.data.JsonStore({autoDestroy:true,idProperty:"id",fields:["id","display","type","desc","tooltip","conflict"]}),listeners:{select:function(){this.checkState()},beforeselect:function(f,d,e){if(d.data.conflict){return false}},scope:this}},c.disks=new SYNO.SDS.StorageManager.Wizard.SsdGrid({appWin:c.appWin,owner:c,itemId:"disks"})]};c.callParent([Ext.apply(b,a)])},loadDisks:function(){var b=this,a,d,c=[];for(a=0;a<b.freeSSDs.length;a++){d=b.freeSSDs[a];c.push({enabled:false,id:d.id,numId:d.get("num_id"),name:SYNO.SDS.StorageUtils.DiskDisplayNameGet(d),model:d.get("model"),size_total:d.get("size_total"),container:d.get("container"),ctnOrder:parseInt(d.get("container").order,10),diskType:d.get("diskType"),support:d.get("support"),isSsd:d.get("isSsd"),pciSlot:d.get("pciSlot"),portType:d.get("portType")})}c.sort(SYNO.SDS.StorageUtils.DiskSort);b.getComponent("disks").setHeight(45+c.length*28);b.disks.getStore().loadData({disks:c},false)},getIds:function(){var a=[];this.disks.getStore().each(function(b){if(b.get("enabled")){a.push(b.id)}});return a},getDiskNums:function(){var a=[];this.disks.getStore().each(function(b){if(b.get("enabled")){a.push(b.get("numId"))}});return a},getNames:function(){var a=[];this.disks.getStore().each(function(b){if(b.get("enabled")){a.push(b.get("name"))}});return a},getDisks:function(){var a=[];this.disks.getStore().each(function(b){if(b.get("enabled")){a.push(b)}});return a},getStore:function(){return this.disks.getStore()},activate:function(){var b=this,a=0,c=b.getComponent("target"),d=c.getStore();c.clearValue();d.loadData(b.prepareTargetData(),false);while(a<d.getCount()){if(!d.getAt(a).data.conflict){c.setValue(d.getAt(a).id);break}a++}b.loadDisks()},prepareTargetData:function(){var a=[],c;var b=_T("volume","ssd_cache_conflict_with_timebackup");if("yes"===_D("support_write_cache","no")){c=("writeCache"===this.owner.getStep("cacheMode").getForm().getValues().cacheMode)}else{c=false}this.volumes.each(function(d){var f=SYNO.SDS.StorageUtils.SpaceIDParser(d.get("id")).str;var e=c&&d.get("timebackup");var g=d.get("desc");a.push({id:d.get("id"),display:f,type:"volume",desc:g,tooltip:e?String.format(b,f):g,conflict:e})});this.luns.each(function(e){var d=e.get("iscsi_lun").name;a.push({id:e.get("id"),display:d,type:"lun",desc:"",tooltip:d,conflict:false})});return a},checkState:function(){var c=this.getComponent("target"),a=0,b;if("yes"===_D("support_write_cache","no")){b=("writeCache"===this.owner.getStep("cacheMode").getForm().getValues().cacheMode)}else{b=false}SYNO.SDS.Wizard.Step.prototype.checkState.apply(this,arguments);this.disks.getStore().each(function(d){if(d.get("enabled")){++a}});if(0===a||this.maxSSD<a||(1===a&&b)||""===c.getValue()){this.owner.getButton("next").disable()}else{this.owner.getButton("next").enable()}},deactivate:function(){this.owner.getButton("next").enable()},getNext:function(){var f=this,e=[],c,h=false,i="size",g=true,b=[],d=[];var k,a;var j;if(""===f.owner.getTargetSpaceId()){return}b.push(f.owner.getTargetSpaceId());if(SYNO.SDS.StorageUtils.isExistRunningvDSM(f.volumes,b)){f.owner.getMsgBox().alert(f.owner.title,_TT("SYNO.SDS.Virtualization.Application","vm","exist_alive_vm_err"));return false}f.owner.diskStepWarningMsgs=[];if("yes"===_D("support_write_cache","no")&&"writeCache"===f.owner.getCacheMode()){h=true;i="raidType"}f.disks.getStore().each(function(l){if(l.get("enabled")){e.push(l)}});if(0===e.length||this.maxSSD<e.length||(1===e.length&&h)){return false}c=e[0].get("container").type;Ext.each(e,function(l){if(c!==l.get("container").type){f.owner.diskStepWarningMsgs.push(_T("volume","ssd_mix_disks_warning"));return false}},f);k=function(){f.owner.setStatusBusy();SYNO.API.Request({api:"SYNO.Storage.CGI.Flashcache",method:"check_system_raid",version:1,params:{cache_devices:f.getIds()},callback:function(q,p,o,n){var m,l;f.owner.clearStatusBusy();if(!q){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,p);return}if("warning"===p.sysRaidAct){f.owner.diskStepWarningMsgs.push(_T("volume","volume_sys_raid_remove_warning"))}if("repair"===p.sysRaidAct){m=String.format('<a class="link-font" href="#" id="{0}">{1}</a>',"gotoOverview",_T("helptoc","overview"));l=String.format(_T("volume","volume_sys_raid_repair"),m);f.owner.getMsgBox().alert(f.owner.title,l);f.mon(Ext.fly("gotoOverview"),"click",function(){f.appWin.selectPage("SYNO.SDS.StorageManager.Overview.Main");f.owner.close()},f);return}if(!h){f.owner.estimateMem()}else{f.owner.goNext(i)}},scope:f})};a=function(){if(1<e.length){var l=e[0].get("model"),m=e[0].get("size");e.each(function(n){if(l!=n.get("model")||m!=n.get("size")){g=false;return}},f)}if(!g){f.owner.getMsgBox().confirm(f.owner.title,_T("volume","hybrid_ssd_warning"),function(n){if("yes"===n){k()}},f)}else{k()}};Ext.each(e,function(l){d.push(l.id)});f.owner.setStatusBusy();this.sendWebAPI({api:"SYNO.Core.Storage.Disk",version:1,method:"get_synoblock",params:{disk_id:d},callback:function(p,o,n,m){var l=false;f.owner.clearStatusBusy();if(!p){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,o);return}Ext.each(o,function(q){if(q.found&&q.synoblock.space_type==="ssd_cache"){switch(q.synoblock.cache_mode){case"back":case"bypass":case"crash":l=true;return false;default:return true}}});if(!l){a()}else{j=new SYNO.SDS.StorageManager.Dialog.Confirm({owner:f.owner,title:f.owner.title,message:_T("volume","cache_create_existing_data_warning"),winHeight:20,confirmText:_T("volume","format_hd_confirm"),callback:function(){a()}});j.open()}},scope:this});return false},getTargetSpaceInfo:function(){var a=this.getComponent("target"),b;if(!a){return undefined}b=a.getStore().getById(a.getValue());return{type:b.get("type"),id:b.get("id")}}});Ext.define("SYNO.SDS.StorageManager.Wizard.SsdRaidTypeStep",{extend:"SYNO.ux.FormPanel",constructor:function(a){var c=this,b={headline:_T("volume","volume_add_levelselect"),items:[{xtype:"syno_radio",boxLabel:_T("volume","volume_type_raid_1"),name:"raid",itemId:"raid_1",inputValue:"raid_1"},{xtype:"syno_radio",boxLabel:_T("volume","volume_type_raid_5"),name:"raid",itemId:"raid_5",inputValue:"raid_5"},{xtype:"syno_radio",boxLabel:_T("volume","volume_type_raid_6"),name:"raid",itemId:"raid_6",inputValue:"raid_6"}]};b=Ext.apply(b,a);c.callParent([b])},activate:function(){var a=this,b=a.owner.getDiskIds();a.getComponent("raid_1").enable();a.getComponent("raid_5").disable();a.getComponent("raid_6").disable();a.getComponent("raid_1").setValue(true);if(b.length>=3){a.getComponent("raid_5").enable()}if(b.length>=4){a.getComponent("raid_1").disable();a.getComponent("raid_5").setValue(true);a.getComponent("raid_6").enable()}},getNext:function(){this.owner.estimateMem();return false}});Ext.define("SYNO.SDS.StorageManager.Wizard.CacheSizeStep",{extend:"SYNO.ux.FormPanel",constructor:function(a){var e=this,c,d,b;var f=("yes"===_D("cache_support_skip_seq_io","no"))?true:false;e.appWin=a.appWin;e.minCacheSizeGB=10;d=[{xtype:"syno_displayfield",value:(-1<_D("unique").indexOf("alpine"))?_T("volume","ssd_cache_size_mem_desc_new"):_T("volume","ssd_cache_size_mem_desc_new2")},{layout:"hbox",itemId:"size",border:false,fieldLabel:String.format("{0} ({1})",_T("volume","volume_allocate_size_field_name"),_T("common","size_gb")),items:[{xtype:"syno_numberfield",allowDecimals:false,validateOnBlur:true,width:150,itemId:"size_value",minValue:e.minCacheSizeGB,maxlength:e.minCacheSizeGB,enableKeyEvents:true,listeners:{keyup:function(h,g){e.updateMemField()},scope:e}},{xtype:"syno_displayfield",width:10,value:" "},{xtype:"syno_button",itemId:"size_max",text:_T("common","max"),handler:function(h,g){e.sizeCmp.setValue(e.sizeCmp.maxValue);e.updateMemField()},scope:e}]},{xtype:"syno_displayfield",itemId:"consumed_mem",fieldLabel:_T("volume","required_mem_size")}];b=[{xtype:"syno_checkbox",htmlEncode:false,boxLabel:_T("volume","cache_skip_seq_io")+"</br>"+_T("volume","cache_skip_seq_io_desc"),name:"skip_seq_io",hidden:!f}];c={labelWidth:200,headline:_T("volume","cache_configuration"),items:[d,b]};e.callParent([Ext.apply(c,a)]);e.sizeCmp=e.getComponent("size").getComponent("size_value");e.memCmp=e.getComponent("consumed_mem")},activate:function(){var c=this,d=c.owner.getStep("choose"),a,b;c.sizeCmp.setValue(c.owner.maxCacheSizeGB);c.sizeCmp.maxValue=c.owner.maxCacheSizeGB;if(c.minCacheSizeGB>c.owner.maxCacheSizeGB){c.sizeCmp.minValue=c.owner.maxCacheSizeGB}c.updateMemField();a=d.getTargetSpaceInfo();if(!a){return}if("lun"===a.type){b=c.owner.appWin.iscsiLuns.data[a.id]}else{b=c.owner.appWin.volumes.data[a.id]}if(!b){return}if(""!==b.get("pool_path")&&!(b=c.owner.appWin.storagePools.data[b.get("pool_path")])){return}if(parseInt(_D("cache_skip_seq_io_min_num_disk","999"),10)<=b.get("disks").length){c.getForm().setValues({skip_seq_io:true})}else{c.getForm().setValues({skip_seq_io:false})}},updateMemField:function(){var d=this,c=SYNO.SDS.StorageUtils.GetSizeUnit,b,a=d.sizeCmp.getValue();a=(""===a)?"0":a;b=c(a*1024*416);d.memCmp.setValue(String.format("{0} {1}",b.size,b.unit));if(!d.getForm().isValid()){d.owner.getButton("next").disable()}else{d.owner.getButton("next").enable()}},getNext:function(){this.applyCache();return false},applyCache:function(f){var k=this,m=k.owner.getStep("choose"),p,a,n=m.getComponent("target"),h=n.getStore().getById(n.getValue()),g,c,l=[],j=false,d,e;if("yes"===_D("support_write_cache","no")){a=k.owner.getStep("cacheMode").getForm().getValues().cacheMode}else{a="readCache"}var b=k.owner.getStep("size").getForm().getValues().skip_seq_io==="true"?true:false;if(k.sizeCmp.getValue()===k.sizeCmp.maxValue){p=k.owner.maxCacheSizeByte;j=true}else{p=parseInt(k.sizeCmp.getValue(),10)*1024*1024*1024}d={cacheMode:a,disk_id:m.getIds(),size:p.toString(),skipSeqIO:b,isMax:j,reference_path:h.get("id"),raidType:k.owner.getRaidType()};g=k.owner.diskStepWarningMsgs.concat(k.owner.estimateMemWarningMsgs);if(0===g.length){c=_T("volume","volume_stop_all_service")}else{l.push(_T("volume","confirm_following_notice")+"<br/><br />");for(e=0;e<g.length;++e){l.push(String.format("{0}. {1} <br/>",e+1,g[e]))}l.push(String.format("{0}. {1} <br/>",e+1,_T("volume","cache_create_stop_service_warn_desc")));c=l.join("")}var o=new SYNO.SDS.StorageManager.Dialog.Confirm({owner:k.owner,title:k.owner.title,message:c,winHeight:(0===g.length)?80:g.length*80,confirmText:_T("volume","format_hd_confirm"),callback:function(){k.owner.applySettings.defer(1,k.owner,["create",d])}});o.open()}});Ext.define("SYNO.SDS.StorageManager.Wizard.CacheAdvisor",{extend:"SYNO.SDS.Wizard.ModalWindow",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;b={title:_T("volume","ssd_cache_advisor"),width:840,height:604,border:false,closable:false,steps:[]};b.steps.push(new SYNO.SDS.StorageManager.Wizard.SelectVolStep({appWin:c.appWin,itemId:"selectVol",nextId:"statResult",checkState:function(){SYNO.SDS.Wizard.Step.prototype.checkState.apply(this,arguments);this.owner.getButton("next").show();if(!this.volSelected){this.owner.getButton("next").setDisabled(true)}else{this.owner.getButton("next").setDisabled(false)}this.owner.getButton("cancel").setText(_T("common","close"))}}));b.steps.push(new SYNO.SDS.StorageManager.Wizard.StatResultStep({appWin:c.appWin,itemId:"statResult",nextId:null,checkState:function(){SYNO.SDS.Wizard.Step.prototype.checkState.apply(this,arguments);this.owner.getButton("back").show();this.owner.getButton("back").setDisabled(true);this.owner.getButton("next").hide();this.owner.getButton("cancel").setText(_T("common","close"))}}));c.callParent([Ext.apply(b,a)])}});Ext.define("SYNO.SDS.StorageManager.Wizard.SelectVolStep",{extend:"Ext.form.FormPanel",volSelected:false,constructor:function(a){var f=this,c,b;var g='<div style="height:162px;position: relative;"><div class="sm-ssd-advisor-frame">{0}{1}</div></div>';var e='<div style="font-weight: bold;line-height: 20px;padding: 8px 12px 4px 12px;">'+_T("volume","ssd_cache_benefit")+"</div>";var d='<div style="width: 776px;line-height: 18px;padding: 0px 12px 8px 12px">'+_T("volume","ssd_cache_benefit_desc")+"</div>";c={headline:_T("volume","ssd_cache_advisor"),description:_T("volume","cache_advisor_sel_vol_step"),labelWidth:300,fieldWidth:300,items:[{xtype:"syno_displayfield",value:_T("volume","cache_advisor_sel_vol_desc"),height:58},{xtype:"syno_storage_combobox",itemId:"spaceId",displayField:"display",descriptionField:"desc",valueField:"id",emptyText:_T("tree","leaf_volume"),fieldLabel:_T("tree","leaf_volume"),store:new Ext.data.JsonStore({autoDestroy:true,idProperty:"id",fields:["id","display","desc"]}),listeners:{select:f.onVolumeChange,scope:f}},{xtype:"syno_displayfield",fieldLabel:_T("volume","cache_enabled"),id:"cacheEnabled"},{xtype:"syno_displayfield",fieldLabel:_T("volume","cache_size"),id:"cacheSize"},{xtype:"syno_displayfield",fieldLabel:_T("volume","cache_write_mode"),id:"cacheMode"},{html:String.format(g,e,d),border:false}]};f.callParent([Ext.apply(c,a)]);b=f.getSpaceIdCmp().getStore();f.mon(b,"load",function(){if(0<b.getCount()&&!f.volSelected){f.getSpaceIdCmp().setValue(b.getAt(0).id);f.onVolumeChange(f.getSpaceIdCmp(),b.getAt(0),0);f.volSelected=true}},f)},activate:function(){var a=this,b=[];if(!a.volSelected){Ext.each(a.appWin.volumes.getMatched("notUsedByGlusterFs"),function(c){b.push({id:c.get("id"),display:SYNO.SDS.StorageUtils.SpaceIDParser(c.get("id")).str,desc:c.get("desc")})});a.getSpaceIdCmp().getStore().loadData(b,false)}},onVolumeChange:function(d,e,a){var c=this,b;c.owner.volId=e.get("id");c.owner.targetCache=undefined;c.appWin.ssdCaches.dataArray.each(function(f){if(c.owner.volId===f.get("mountSpaceId")){b=f;c.owner.targetCache=f;return}});if(undefined!==b){c.owner.cacheRaidId=b.get("SSDPath").substr(b.get("SSDPath").lastIndexOf("/")+1);Ext.getCmp("cacheEnabled").setValue(_T("common","yes"));Ext.getCmp("cacheSize").setValue(SYNO.SDS.StorageUtils.SizeRender(parseInt(b.get("size").total,10)));if("read"===b.get("mode")){Ext.getCmp("cacheMode").setValue(_T("volume","cache_mode_read_only"))}else{Ext.getCmp("cacheMode").setValue(_T("volume","cache_mode_read_write"))}}else{c.owner.cacheRaidId="";Ext.getCmp("cacheEnabled").setValue(_T("common","no"));Ext.getCmp("cacheSize").setValue("--");Ext.getCmp("cacheMode").setValue("--")}},getSpaceIdCmp:function(){return this.getComponent("spaceId")}});Ext.define("SYNO.SDS.StorageManager.Wizard.StatResultStep",{extend:"Ext.form.FormPanel",constructor:function(a){var f=this,c;var g='<div class="sm-ssd-advisor-frame"><div class="sm-ssd-advisor-recomm-range"><div class="sm-ssd-advisor-recomm-left" id="recomm_left">{0}{1}</div><div class="sm-ssd-advisor-recomm-right" id="recomm_right">{2}</div></div></div>';var e='<div style="height: 20px;font-weight: bold;line-height: 20px;padding-bottom: 4px;">'+_T("common","recommendations")+"</div>";var d='<div style="line-height: 18px;" id="recomm_msg"></div>';var b='<div style="padding-top: 14px;height: 20px;line-height: 20px;">'+_T("volume","recomm_size")+'</div><div style="height: 40px;line-height: 40px;"><span style="font-size: 32px;color: #399EE6;" id="recomm_size">0</span><span style="font-size: 16px;color: #399EE6;" id="recomm_unit"> GB</span></div>';c={headline:_T("volume","ssd_cache_advisor"),description:_T("volume","cache_advisor_result_step"),border:false,items:[{layout:"vbox",border:false,items:[{border:false,height:247,width:800,padding:"0px 0px 8px 0px",items:[f.createUpperPanel()]},{border:false,height:140,width:800,html:String.format(g,e,d,b)}]}]};f.callParent([Ext.apply(c,a)]);f.ssdHeatStoreData={heatMap:[{name:_T("volume","data_accessed_hot"),value:0,color:"#FA575D",size:0,unit:"KB",period:_T("volume","data_accessed_in_one_day")},{name:_T("volume","data_accessed_warm"),value:0,color:"#FABB00",size:0,unit:"KB",period:_T("volume","data_accessed_in_one_week")},{name:_T("volume","data_accessed_cold"),value:0,color:"#399EE6",size:0,unit:"KB",period:_T("volume","data_accessed_in_one_month")},{name:_T("volume","data_accessed_archive"),value:0,color:"#8C96A0",size:0,unit:"KB",period:_T("volume","data_accessed_before_one_month")}]};f.mon(f,"activate",function(){if(f.owner.volId){f.description=String.format(_T("volume","cache_advisor_result_step"),SYNO.SDS.StorageUtils.SpaceIDParser(f.owner.volId).str)}},f)},createUpperPanel:function(){var b=this,a;var c='<div class="sm-ssd-heat-property"><div style="float: left;width: 70%;" id="{name}"><div style="background-color: {color}" class="sm-ssd-heat-color"></div><div style="float: left;font-size: 12px">{name}</div></div><div style="float: left;width: 30%;text-align: right;line-height: 24px;height: 24px;"><span style="font-size: 14px;font-weight: bold;">{size}</span><span style="padding-right: 10px;font-size: 12px;"> {unit}</span></div></div>';a={height:240,layout:"hbox",items:[new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">','<div style="height: 240px;width: 220px;padding-right: 19px;border-right-style: solid;border-right-width: 1px;border-right-color: #D8E1EC;">','<div id="sm_cache_heat_map" class="sm-ssd-heat-map"></div>','<tpl for="heatMap">',c,"</tpl>","</div>","</div>","</tpl>"),height:240,width:240,store:b.ssdHeatStore=new Ext.data.JsonStore({autoDestroy:true,fields:["heatMap"]})}),new SYNO.ux.Panel({width:560,height:240,border:false,items:[{border:false,html:'<div style="line-height: 28px;font-size: 15px;font-weight: normal;color: #0077CC;padding: 0px 0px 8px 20px;">'+_T("volume","recently_accessed_file_size")+"</div>"},{xtype:"syno_gridpanel",itemId:"reportGrid",border:false,padding:"0px 0px 0px 20px",columns:[{header:_T("volume","ssd_cache_static_day"),dataIndex:"access_day",width:180,sortable:false},{header:_T("volume","ssd_cache_static_file_count"),dataIndex:"file_count",width:180,sortable:false},{header:_T("volume","ssd_cache_static_total_file_size"),dataIndex:"file_size",width:180,renderer:SYNO.SDS.StorageUtils.SizeRender,sortable:false}],enableHdMenu:false,store:b.ssdStatStore=new Ext.data.JsonStore({autoDestroy:true,fields:["access_day","file_count","file_size"],listeners:{load:function(d,e){d.sort("access_day","DESC");if(d.getAt(6)){d.remove(d.getAt(6))}},scope:this}})}]})]};return new SYNO.ux.Panel(a)},activate:function(){this.getEl().mask(_T("common","loading"),"x-mask-loading");Ext.get("recomm_right").setStyle({display:"none"});Ext.get("recomm_left").removeClass("sm-ssd-advisor-recomm-left");Ext.get("recomm_left").addClass("sm-ssd-advisor-recomm-all");this.statCheckTask(false)},statCheckTask:function(a){var b=this;if(b.isDestroyed){return}b.owner.getButton("back").setDisabled(true);SYNO.API.Request({api:"SYNO.Storage.CGI.Flashcache",method:"statistics_check",version:1,params:{cacheRaidId:b.owner.cacheRaidId,volumeId:b.owner.volId},recalculate:a,callback:function(g,f,e,d){var c=this;if(c.isDestroyed){return}if(!g){c.owner.close();return}if(!g){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,f);c.owner.close();return}c.memCacheRatio=1*1024*1024/f.cache_mem_ratio;if(f.statisticsInfo&&f.statisticsInfo.is_processing){if(!d.recalculate){c.getEl().mask(_T("volume","volume_wait_calc_stat"),"x-mask-loading");c.owner.getMsgBox().alert(_T("volume","ssd_cache_advisor"),_T("volume","stat_task_processing_warn"),function(){c.statCheckTask.defer(5000,c,[true])},c)}else{c.statCheckTask.defer(5000,c,[true])}}else{c.getEl().unmask();c.owner.getButton("back").setDisabled(false);c.updateHandler(d,g,f)}},scope:b})},updateHandler:function(a,d,c){var b=this;if(this.isDestroyed){return}if(!d){b.owner.close();return}if(!d){b.owner.close();return}if(undefined===c.statisticsResult){return}if(0<c.statisticsResult.length){b.ssdStatStore.loadData(c.statisticsResult,false);if(!a.recalculate){b.owner.getMsgBox().confirm(_T("volume","ssd_cache_advisor"),String.format(_T("volume","stat_task_recalculate"),c.statisticsTime),function(e){if("yes"===e){b.onCalculate()}},b)}}else{b.onCalculate()}b.updateUI(c,SYNO.API.DecodeParams(a.params))},updateUI:function(u,q){var s=this,o=u.heatMap,m,j,r,e,n,g,w,v,t;var d,k={};var b=SYNO.SDS.StorageUtils.SpaceIDParser(s.owner.volId).str;var f=SYNO.SDS.StorageUtils.GetSizeUnit;var a=String.format('<div class="sm-ssd-advisor-note"><span class="syno-ux-note">{0}{1} </span>{2}</div>',_T("common","note"),_T("common","colon"),"{0}");var l=this.appWin.volumes.data[this.owner.volId];var p=(l&&Ext.isFunction(l.isBtrfsVolume))?l.isBtrfsVolume():false;if(undefined===o){return}r=s.ssdHeatStoreData.heatMap;for(m=0;m<r.length;++m){j="Level_"+m.toString();if(undefined!==o[j]&&"0"!==o[j]){r[m].value=o[j];w=f(o[j]);r[m].size=Math.floor(w.size);r[m].unit=w.unit}else{r[m].value=0;r[m].size=0;r[m].unit="KB"}}e=parseInt(r[0].value,10);n=parseInt(r[1].value,10);s.ssdHeatStore.loadData([s.ssdHeatStoreData],false);s.drawChart();for(m=0;m<r.length;++m){Ext.get(r[m].name).dom.qtip=r[m].period}if(s.isVolumeDisksAllSSD()){Ext.get("recomm_msg").dom.innerHTML=String.format(_T("volume","recomm_msg_ssd_vol"),b)}else{if(undefined===s.owner.targetCache){if(e+n<u.memAllowedMaxCacheSize){g=e+n}else{if(e<u.memAllowedMaxCacheSize){g=e}else{g=u.memAllowedMaxCacheSize}}if(0===u.memAllowedMaxCacheSize){Ext.get("recomm_msg").dom.innerHTML=String.format(_T("volume","recomm_msg_cannot_create_cache"),b)}else{v=f(g);Ext.get("recomm_right").setStyle({display:"block"});Ext.get("recomm_left").removeClass("sm-ssd-advisor-recomm-all");Ext.get("recomm_left").addClass("sm-ssd-advisor-recomm-left");Ext.get("recomm_size").dom.innerHTML=v.size;Ext.get("recomm_unit").dom.innerHTML=" "+v.unit;if(g<=u.memAllowedCacheSize){Ext.get("recomm_msg").dom.innerHTML=String.format(_T("volume","recomm_msg_create_cache"),b,v.size+" "+v.unit)}else{t=f((g-u.memAllowedCacheSize)/s.memCacheRatio);Ext.get("recomm_msg").dom.innerHTML=String.format(_T("volume","recomm_msg_mem_not_enough"),b,Math.ceil(t.size)+" "+t.unit)}}}else{d=u.histData.FlashCache;s.updateHistData(d,"Current",q.cacheRaidId,0,k);s.updateHistData(d,"Minutely",q.cacheRaidId,k.Current,k);s.updateHistData(d,"Daily",q.cacheRaidId,k.Minutely,k);s.updateHistData(d,"Weekly",q.cacheRaidId,k.Daily,k);s.updateHistData(d,"Monthly",q.cacheRaidId,k.Weekly,k);if(40>k.Monthly){Ext.get("recomm_msg").dom.innerHTML=String.format(_T("volume","recomm_msg_low_hit_rate"),b,k.Monthly)}else{Ext.get("recomm_msg").dom.innerHTML=String.format(_T("volume","recomm_msg_high_hit_rate"),b,k.Monthly)}}}if(p&&this.isVolumeContainLUN()){var h=Ext.get("recomm_msg").dom.innerHTML;var c=String.format(a,_T("volume","cache_advisor_scan_file_scope_desc"));h=String.format("{0}<br>{1}",h,c);Ext.get("recomm_msg").dom.innerHTML=h}},updateHistData:function(c,a,f,b,e){var d;e[a]=b;if(c[a]&&c[a].success&&c[a][f]){d=c[a][f];if(d.success&&d.read_total>0){e[a]=Math.ceil(d.read_hit*100/d.read_total);if(100<e[a]){e[a]=100}}}},onCalculate:function(){var a=this;a.getEl().mask(_T("volume","volume_wait_calc_stat"),"x-mask-loading");a.owner.getButton("back").setDisabled(true);SYNO.API.Request({api:"SYNO.Storage.CGI.Flashcache",method:"statistics",version:1,params:{volumeId:a.owner.volId},callback:function(e,d,c,b){if(a.isDestroyed){return}if(!e){a.owner.close();return}if(!e){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,d);a.owner.close();return}this.statCheckTask(true)},scope:a})},drawChart:function(){var b=this,a;a=new SYNO.SDS.StorageManager.FlotrPieChart({collapsible:false,store:b.ssdHeatStore,height:120,hideMode:"offsets",border:false,totalRecords:0,chartType:{grid:{verticalLines:false,horizontalLines:false,outlineWidth:0,labelMargin:0},xaxis:{showLabels:false},yaxis:{showLabels:false},pie:{show:true,lineWidth:0,explode:0,sizeRatio:0.98,fill:true,fillOpacity:1,startAngle:3/4,labelFormatter:function(c){return""}},shadowSize:0,legend:{show:false}},renderTo:"sm_cache_heat_map"})},isVolumeContainLUN:function(){var a=this.appWin.iscsiLuns.dataArray;var c=this.owner.volId;var b=false;Ext.each(a,function(d){if(!Ext.isObject(d)||!Ext.isObject(d.json)||!Ext.isObject(d.json.iscsi_lun)){return true}if(d.json.iscsi_lun.location===c){b=true;return false}});return b},isVolumeDisksAllSSD:function(){var c=this;var a=c.appWin.disks;var b=true;var d,e;d=c.appWin.volumes.data[c.owner.volId].get("pool_path");e=c.appWin.storagePools.data[d].get("disks");if(0===e.length){return false}else{e.each(function(f){if(!a.data[f].isSSD()){b=false;return}})}return b}});Ext.define("SYNO.SDS.StorageManager.Wizard.SsdGrid",{extend:"SYNO.ux.GridPanel",MAX_SSD_NUM:12,constructor:function(b){var d=this,a=b.owner,f,c,e;if(isNaN(e=parseInt(_D("max_ssd_number",""),10))){e=d.MAX_SSD_NUM}f=new SYNO.ux.EnableColumn({disableSelectAll:true,dataIndex:"enabled",id:"enable",bindRowClick:true,width:40,sortable:false,align:"center",onCellClick:function(h,i,k){var j=h.getStore(),g=0;j=h.getStore();this.toggleRec(j.getAt(i));j.each(function(l){if(l.get("enabled")){++g}});if(e<g){j.getAt(i).set("enabled",false)}if(this.commitChanges){j.commitChanges()}}});c=Ext.apply({enableHdMenu:false,cls:"without-dirty-red-grid",plugins:f,layout:"fit",columns:[f,{header:_T("volume","volume_disknumber"),dataIndex:"name",width:170},{header:_T("volume","volume_disk_type"),dataIndex:"diskType",width:80,renderer:function(i,g,h){return SYNO.SDS.StorageUtils.DiskTypeRender(h,d.appWin.supportSas)}},{header:_T("volume","volume_diskcapacity"),dataIndex:"size_total",width:80,renderer:SYNO.SDS.StorageUtils.SizeRender},{header:_T("volume","volume_diskmodel"),dataIndex:"model",width:120}],store:new Ext.data.JsonStore({autoDestroy:true,root:"disks",fields:["id","numId","enabled","name","model","size_total","container","diskType","support","isSsd"],listeners:{update:function(g,h,i){if(Ext.data.Record.EDIT!==i){return}if(!this.allowBlank){a.checkState()}},scope:this}})},b);d.callParent([c])}});Ext.define("SYNO.SDS.StorageManager.Wizard.RepairSsdCache",{extend:"SYNO.SDS.Wizard.ModalWindow",constructor:function(a){var c=this,b;c.isDataChanged=false;c.appWin=a.appWin;c.owner=a.owner;c.fail_disk_count=a.fail_disk_count;b={title:_T("volume","ssd_cache_repair_wizard_title"),width:600,height:475,minWidth:600,minHeight:475,resizable:true,border:false,steps:[]};b.steps.push(new SYNO.SDS.StorageManager.Wizard.RepairChooseSsdStep({appWin:c.appWin,owner:c.owner,freeSSDs:a.freeSSDs,space_id:a.space_id,ssd_id:a.ssd_id,ssd_path:a.ssd_path,itemId:"disks",nextId:null}));c.callParent([Ext.apply(b,a)])},applySettings:function(b,a){this.setStatusBusy();SYNO.API.Request({api:"SYNO.Storage.CGI.Flashcache",method:b,version:1,params:a,callback:function(f,e,d,c){var g={};this.clearStatusBusy();if(!f){if(SYNO.SDS.StorageUtils.IsFeasibilityFail(e,g)){SYNO.SDS.StorageUtils.ConfirmFeasibilityFail(this,g,this.applySettings,b,Ext.applyIf({force:true},d))}else{SYNO.SDS.StorageUtils.HARemoteCheckErrParsing(e);SYNO.SDS.StorageUtils.ReportWebapiFailure(this,e)}return}this.getButton("next").enable();this.getButton("next").setText(_T("common","alt_finish"));this.isDataChanged=true;this.close()},scope:this})}});Ext.define("SYNO.SDS.StorageManager.Wizard.RepairChooseSsdStep",{extend:"SYNO.ux.FormPanel",warningMsgs:null,constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;c.freeSSDs=a.freeSSDs||[];c.space_id=a.space_id;c.ssd_id=a.ssd_id;c.ssd_path=a.ssd_path;b={headline:_T("volume","ssd_cache_repair_headline"),labelWidth:200,items:c.disks=new SYNO.SDS.StorageManager.Wizard.SsdGrid({owner:c,appWin:c.appWin,itemId:"disks"})};c.callParent([Ext.apply(b,a)])},getIds:function(){var a=[];this.disks.getStore().each(function(b){if(b.get("enabled")){a.push(b.id)}});return a},getDiskNums:function(){var a=[];this.disks.getStore().each(function(b){if(b.get("enabled")){a.push(b.get("numId"))}});return a},getNames:function(){var a=[];this.disks.getStore().each(function(b){if(b.get("enabled")){a.push(b.get("name"))}});return a},getDisks:function(){var a=[];this.disks.getStore().each(function(b){if(b.get("enabled")){a.push(b)}});return a},getStore:function(){return this.disks.getStore()},activate:function(){this.loadDisks()},loadDisks:function(){var a,c,b=[];for(a=0;a<this.freeSSDs.length;a++){c=this.freeSSDs[a];b.push({enabled:false,id:c.id,numId:c.get("num_id"),name:SYNO.SDS.StorageUtils.DiskDisplayNameGet(c),model:c.get("model"),size_total:c.get("size_total"),container:c.get("container"),ctnOrder:parseInt(c.get("container").order,10),diskType:c.get("diskType"),support:c.get("support"),isSsd:c.get("isSsd"),pciSlot:c.get("pciSlot"),portType:c.get("portType")})}b.sort(SYNO.SDS.StorageUtils.DiskSort);this.getComponent("disks").setHeight(45+b.length*28);this.disks.getStore().loadData({disks:b},false)},checkState:function(){var b=this,a=0;SYNO.SDS.Wizard.Step.prototype.checkState.apply(b,arguments);b.disks.getStore().each(function(c){if(c.get("enabled")){++a}});if(0===a||b.owner.fail_disk_count<a){b.owner.getButton("next").disable()}else{b.owner.getButton("next").enable()}},deactivate:function(){this.owner.getButton("next").enable()},getNext:function(){var c=this,d,b,a;c.warningMsgs="";d={action:"estimate_repair_cache",cache_devices:c.getIds(),reference_path:c.space_id,ssd_id:c.ssd_id,ssd_path:c.ssd_path};c.owner.setStatusBusy();SYNO.API.Request({api:"SYNO.Storage.CGI.Flashcache",method:"estimate_repair",version:1,params:d,callback:function(h,g,f,e){c.owner.clearStatusBusy();if(!h){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,g);return}if(g.sysRaidAct&&"none"!==g.sysRaidAct){if("warning"===g.sysRaidAct){c.warningMsgs=_T("volume","volume_sys_raid_remove_warning");c.openConfirmDialog()}else{if("repair"===g.sysRaidAct){b=String.format('<a class="link-font" href="#" id="{0}">{1}</a>',"gotoOverview",_T("helptoc","overview"));a=String.format(_T("volume","volume_sys_raid_repair"),b);c.owner.getMsgBox().alert(c.owner.title,a);c.mon(Ext.fly("gotoOverview"),"click",function(){c.owner.owner.setActiveFunction("overview");c.owner.close()},c)}}}else{c.openConfirmDialog()}},scope:c.appWin});return false},openConfirmDialog:function(){var a=this,c={disk_id:a.getIds(),reference_path:a.space_id,ssd_id:a.ssd_id,ssd_path:a.ssd_path};var b=new SYNO.SDS.StorageManager.Dialog.Confirm({owner:a.owner,title:a.owner.title,message:(""===a.warningMsgs)?" ":a.warningMsgs,winHeight:0,confirmText:_T("volume","ssd_repair_format_confirm"),callback:function(){a.owner.applySettings.defer(1,a.owner,["repair",c])}});b.open()}});Ext.define("SYNO.SDS.StorageManager.Wizard.CacheSetting",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;c.skipSeqIO=a.skipSeqIO;c.ssdPath=a.ssdPath;c.mountSpaceId=a.mountSpaceId;b={title:_T("common","configure"),width:450,height:180,minWidth:450,minHeight:180,layout:"fit",items:[{xtype:"syno_formpanel",itemId:"main",border:false,trackResetOnLoad:true,items:[{xtype:"syno_checkbox",name:"skip_seq_io",htmlEncode:false,boxLabel:_T("volume","cache_skip_seq_io")+"</br>"+_T("volume","cache_skip_seq_io_desc"),value:0}]}],buttons:[{xtype:"syno_button",btnStyle:"blue",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","alt_apply"),scope:this,handler:this.onSave},{xtype:"syno_button",text:_T("common","alt_cancel"),scope:this,handler:this.onCancel}]};c.callParent([Ext.apply(b,a)])},getForm:function(){return this.getComponent("main").getForm()},onOpen:function(){var a=this;a.callParent(arguments);a.getForm().setValues({skip_seq_io:a.skipSeqIO})},onSave:function(){var a=this;if(!this.getForm().isDirty()){this.close();return}if(!this.getForm().isValid()){return}this.setStatusBusy();SYNO.API.Request({api:"SYNO.Storage.CGI.Flashcache",method:"configure",version:1,params:{ssdPath:a.ssdPath,mountSpaceId:a.mountSpaceId,skipSeqIO:Boolean(a.getForm().findField("skip_seq_io").getValue())},callback:function(e,d,c,b){this.clearStatusBusy();if(!e){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,d);return}this.isDataChanged=true;this.close()},scope:this})},onCancel:function(){if(this.getForm().isDirty()){this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(a){if("yes"===a){this.close()}},this);return}this.close()}});Ext.define("SYNO.SDS.StorageManager.FlotrPieChart",{extend:"Ext.Panel",initialChartType:null,chartType:null,flotr:null,constructor:function(b){var a={margins:{top:0,right:0,bottom:0,left:0},border:false};this.initialChartType=SYNO.SDS.Utils.clone(b.chartType);Ext.apply(a,b);this.callParent([a])},initEvents:function(){this.callParent(arguments);this.mon(this,"afterlayout",function(){if(!this.collapsed&&!this.flotr){this.drawChart()}},this)},genSeries:function(c){var b,a,d=true;if(undefined===this.store||undefined===(a=this.store.getAt(0).data.heatMap)){return}a.each(function(e){if(0!==e.value){d=false;return}});if(!d){for(b=0;b<a.length;b++){c[b]={};c[b].data=[];c[b].data.push([a[b].name,a[b].value]);c[b].Label=a[b].name;c[b].color=a[b].color}}else{c[0]={data:[[_T("volume","data_accessed_archive"),100]],Lable:_T("volume","data_accessed_archive"),color:"#8C96A0"}}},drawChart:function(){var a=[];this.genSeries(a);this.flotr=Flotr.draw(this.body.dom,a,this.chartType)},onResize:function(){this.callParent(arguments);this.drawChart()}});Ext.define("SYNO.SDS.StorageManager.SsdCache.Store",{extend:"Ext.data.JsonStore",constructor:function(a){var c=this,b;c.sortField="numId";c.sortDir="ASC";b={autoDestroy:true,idProperty:"id",fields:["numId","id","iconCls","statusIconCls","displayName","desc","summaryStatus","property","devices","spaces","spaceTitle"],listeners:{load:function(){c.sort(c.sortField,c.sortDir)},scope:c}};c.callParent([Ext.apply(b,a)])}});Ext.define("SYNO.SDS.StorageManager.SsdCache.Object",{extend:"SYNO.SDS.StorageManager.Space",isCrashed:function(){var a=this.get("mode");return"crashed"===this.get("status")||"write_bypass"===a||"write_crash"===a},isNormal:function(){return"normal"===this.get("status")},isSpaceMissing:function(){return"space_missing"===this.get("cacheStatus")},isRepairing:function(){return"repairing"===this.get("status")},getStatus:function(){if(this.isSpaceMissing()){return"space_missing"}else{if(!this.isActioning()&&this.isCrashed()){return"crashed"}else{return this.get("status")}}},getStatusStr:function(){return SYNO.SDS.StorageUtils.StatusRender(this.getStatus(),this.get("progress"))}});Ext.define("SYNO.SDS.StorageManager.SsdCache.Main",{extend:"SYNO.ux.Panel",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.appWin;c.ssdStore=new SYNO.SDS.StorageManager.SsdCache.Store();c.createListPanel();c.createDetailPanel();b={border:false,layout:"card",activeItem:"listPanel",items:[c.listPanel,c.detailPanel],listeners:{activate:c.onActivate,deactivate:c.onDeactivate,nextDetail:function(){var d=c.listView.getSelectedItem();if(undefined!==d&&"umount_ssd"!==d.get("status")){c.detailView.onActivate();c.getLayout().setActiveItem("detailPanel");c.detailView.updateDevListScrollBar()}},prevList:function(){c.getLayout().setActiveItem("listPanel");c.detailView.onDeactivate()},scope:c}};c.callParent([Ext.apply(b,a)])},getHelpParam:function(){return"StorageManager/genericssdcache.html"},createListPanel:function(){var b=this,a;a={appWin:b.appWin,owner:b,dataType:"ssdCaches",itemId:"cacheView",multiSelect:false,singleSelect:true,isCardLayout:true,store:b.ssdStore};b.listView=new SYNO.SDS.StorageManager.DataView(a);b.listPanel=new Ext.Panel({itemId:"listPanel",border:false,items:b.listView,layout:"fit",tbar:{defaultType:"syno_button",items:[{itemId:"create",text:_T("common","create"),handler:b.onCreate,scope:b},{itemId:"repair",text:_T("volume","volume_adddisk2_type_repair"),handler:b.onRepair,scope:b},{itemId:"remove",text:_T("common","remove"),handler:b.onDelete,scope:b},{itemId:"configure",text:_T("common","configure"),hidden:("yes"!==_D("cache_support_skip_seq_io","no")),handler:b.onConfigure,scope:b},{itemId:"statistic",text:_T("volume","ssd_cache_advisor"),handler:b.onStatistic,scope:b}]}})},createDetailPanel:function(){var b=this,a;a={appWin:b.appWin,owner:b,dataType:"ssdCaches",itemId:"detailView"};b.detailView=new SYNO.SDS.StorageManager.DetailView(a);b.detailFieldSet=new SYNO.SDS.StorageManager.FieldSet({title:_T("common","main_page"),items:b.detailView});b.detailPanel=new Ext.Panel({itemId:"detailPanel",border:false,items:b.detailFieldSet})},prepareUiData:function(){var b=this,a=b.appWin.ssdCaches.getAll(),c;delete b.uiData;b.uiData=[];Ext.each(a,function(d){c={};b.prepareSummary(d,c);b.prepareDevices(d,c);b.prepareSpaces(d,c);b.uiData.push(c)},b)},prepareSummary:function(d,e){var b=SYNO.SDS.StorageUtils,c,a=parseInt(d.get("size").total,10);c=d.id.split("_");if(2===c.length){e.numId=parseInt(c[1],10)}else{e.numId=0}e.id=d.id;e.displayName=b.SpaceIDParser(d.id).str;e.summaryStatus=String.format("&nbsp;-&nbsp;{0}",d.getStatusStr());e.desc=String.format("{0} {1}",(a/1024/1024/1024).toFixed(2),_T("status","status_disk_size_unit"));e.iconCls="sm-list-icon-ssdCache";if(d.isActioning()){e.statusIconCls="sm-list-status-icon-acting"}else{if(d.isCrashed()||d.isDegrade()){e.statusIconCls="sm-list-status-icon-crashed"}}},prepareDevices:function(c,e){var b=this,a=SYNO.SDS.StorageUtils,d;e.devices=[];Ext.each(c.get("disks"),function(f){d=b.appWin.disks.data[f];if(!d){return true}e.devices.push({container:d.get("container").str,name:d.get("name"),size:a.SizeRender(d.get("size_total")),status:a.DiskStatusRender(d.get("status")),numId:d.get("num_id"),ctnOrder:parseInt(d.get("container").order,10),pciSlot:d.get("pciSlot"),portType:d.get("portType")})},b);e.devices.sort(SYNO.SDS.StorageUtils.DiskSort)},prepareSpaces:function(i,c){var d=this,f=SYNO.SDS.StorageUtils,e=i.get("mountSpaceId"),b=f.SpaceIDParser(e),a=("volume"===b.type)?d.appWin.volumes.data[e]:d.appWin.iscsiLuns.data[e],g,h;c.spaces=[];if("volume"===b.type){g=parseInt(a.get("size").total,10);h=parseInt(a.get("size").used,10);c.spaces.push({name:b.str,usedSize:f.SizeRender(h),freeSize:f.SizeRenderWithFloor(g-h),status:f.SizeRender(g)});c.spaceTitle=_T("volume","volume_mount_volume_info")}else{if("iscsi"===b.type){c.spaces.push({name:a.get("iscsi_lun").name,usedSize:"-",freeSize:"-",status:f.SizeRender(parseInt(a.get("iscsi_lun").size,10))});c.spaceTitle=_T("volume","volume_mount_lun_info")}else{return}}},setMask:function(){var a=this.getMaskMsg();if(this.isVisible()&&0===this.listView.getStore().getCount()){this.listView.getEl().mask(a,"syno-ux-mask-info")}if(0<this.listView.getStore().getCount()){this.listView.getEl().unmask()}},getMaskMsg:function(){var b=this,d=b.appWin.disks.getMatched("isSSD","isFree","isSupported"),c,a;if(0===d.length){return _T("volume","cache_no_ssd")}c=b.appWin.volumes.getAll();a=b.appWin.iscsiLuns.getAll();if(0===c.length&&0===a.length){return _T("volume","cache_no_vol")}return _T("volume","volume_no_ssd_caches")},onActivate:function(){var b=this,a=b.listView.store;b.prepareUiData();a.suspendEvents(true);a.loadData(b.uiData,false);a.resumeEvents();b.resetBtnStatus();if(0<a.getCount()&&0===b.listView.getSelectedItemIds().length){b.listView.select(0,true,true);if(1===a.data.length&&true===b.listView.singleExpanded&&true!==b.firstTimeStepIn){b.fireEvent("nextDetail")}}b.firstTimeStepIn=true;b.onSelectChange();b.setMask();b.detailView.onActivate()},onDeactivate:function(){this.detailView.onDeactivate()},onSelectChange:function(){var b=this,a=b.listView.getSelectedItem();b.getButton("remove").hide();b.getButton("repair").hide();b.getButton("configure").hide();if(!a){return}b.getButton("remove").show();b.enableButton("remove",b.canDelete(a));if("yes"===_D("cache_support_skip_seq_io","no")){b.getButton("configure").show();b.enableButton("configure",b.canConfigure(a))}if("yes"===_D("support_write_cache","no")){b.getButton("repair").show();b.enableButton("repair",b.canRepair(a))}},onCreate:function(){var c=this,f,b,e={},d,a;f=c.appWin.disks.getMatched("isSSD","isFree","isSupported");b=function(){if(this.isFileLun&&this.isFileLun()){return false}if(this.isActioning()){return false}if(!this.get("vspace_can_do").flashcache.apply.can_do){return false}if("crashed"===this.get("status")){return false}if(this.usedByGlusterFs()){return false}if(e[this.get("id")]){return false}return true};Ext.each(c.appWin.ssdCaches.getAll(),function(g){e[g.get("mountSpaceId")]=true});d=c.appWin.volumes.getMatched(b);a=c.appWin.iscsiLuns.getMatched(b);c.openWizard("CreateSsdCache",{volumes:d,luns:a,freeSSDs:f})},checkVolumeCrashed:function(a){var c=this,b;b=function(){if(this.isCrashed()&&this.get("cache")&&a.get("id")===this.get("cache").id){return true}return false};if(0!==c.appWin.volumes.getMatched(b).length){return true}return false},onDelete:function(){var g=this,e,c=g.listView.getSelectedItem(),h=g.appWin.volumes.getAll(),a=[],f,b,d,i;if(!c){return}f=c.get("mountSpaceId");b=SYNO.SDS.Utils.StorageUtils.SpaceIDParser(c.get("mountSpaceId")).str;a.push(f);if(SYNO.SDS.StorageUtils.isExistRunningvDSM(h,a)){g.owner.getMsgBox().alert(g.owner.title,_TT("SYNO.SDS.Virtualization.Application","vm","exist_alive_vm_err"));return false}d={reference_path:f,ssd_id:c.get("id"),ssd_path:c.get("SSDPath")};if(c.isSpaceMissing()||!c.get("loaded")){i=new SYNO.SDS.StorageManager.Dialog.Confirm({owner:g.owner,title:g.owner.title,message:_T("volume","cache_remove_space_missing_cache_warning"),winHeight:20,confirmText:_T("volume","cache_remove_space_missing_cache_confirm"),callback:function(){delete d.reference_path;g.applySettings("remove",d)}})}else{e="1. "+String.format(_T("volume","ssd_cache_deattach_confirm"),b)+" <br/>";e+="2. "+_T("volume","cache_stop_services_warn_desc");if("write"===c.get("mode")){e+=" <br/>";e+="3. "+_T("volume","ssd_rw_cache_remove_long_time_warning")}i=new SYNO.SDS.StorageManager.Dialog.Confirm({owner:g.owner,message:e,confirmBtnStyle:"red",winHeight:20,confirmText:_T("volume","cache_confirm_service_stop_desc"),callback:function(){if((c.isCrashed()&&100!==c.get("protectProgress")&&"read"!==c.get("mode"))||(100!==c.get("protectProgress")&&g.checkVolumeCrashed(c))){var j=new SYNO.SDS.StorageManager.Dialog.Confirm({owner:g.owner,message:_T("volume","cache_confirm_remove_crashed_cache_desc"),confirmBtnStyle:"red",winHeight:20,confirmText:_T("volume","cache_decide_remove_crashed_cache_desc"),callback:function(){if("detailPanel"===g.getLayout().activeItem.itemId){g.fireEvent("prevList")}g.applySettings("remove",d)}});j.open()}else{if("detailPanel"===g.getLayout().activeItem.itemId){g.fireEvent("prevList")}g.applySettings("remove",d)}}})}i.open()},onConfigure:function(){var c=this;var b=c.listView.getSelectedItem();if(!b){return}var d=b.get("skipSeqIO");var a=b.get("SSDPath");var e=b.get("mountSpaceId");c.openWizard("CacheSetting",{skipSeqIO:d,ssdPath:a,mountSpaceId:e})},onRepair:function(){var b=this,a=b.listView.getSelectedItem();b.openWizard("RepairSsdCache",{freeSSDs:b.getAvailableDisks(a),space_id:a.get("mountSpaceId"),ssd_id:a.id,ssd_path:a.get("SSDPath"),fail_disk_count:a.get("can_do").repair})},onStatistic:function(){var b=this,a;a=new SYNO.SDS.StorageManager.Wizard.CacheAdvisor({appWin:b.appWin,owner:b.owner});b.appWin.stopPollTask();a.mon(a,"close",function(){b.appWin.startPollTask()},b,{single:true});a.open()},onSort:function(b,a){var c;if(0>b.itemId.indexOf("_")){return}c=b.itemId.split("_")[1];c="id"===c?"num_id":c;if(this.listView.store.sortCriteria!==c){this.listView.store.sortCriteria=c;this.listView.store.sortOrder="ASC"}else{this.listView.store.sortOrder="ASC"===this.listView.store.sortOrder?"DESC":"ASC"}this.getTopToolbar().getComponent("sort").menu.items.each(function(d){d.setIconClass(d.itemId===b.itemId?"sds-space-sort-item-checked":"")});this.listView.store.sort();this.restoreUIState()},resetBtnStatus:function(){var a=this;a.enableButton("create",a.canCreate());a.enableButton("statistic",a.canStatistic())},setFocus:function(c){var a=this.listView.select(c);if(!a){return}var b=this.scroll.top+a.getXY()[1]-this.body.getXY()[1];this.body.scrollTo("top",b)},canCreate:function(){var e=this,h,f=e.appWin.volumes.getAll(),d=e.appWin.iscsiLuns.getAll(),c=e.appWin.ssdCaches.getAll(),b=false,a=false,g={};if(e.owner.env.settingSwap){return false}h=e.appWin.disks.getMatched("isSSD","isFree","isSupported");if(0===h.length){return false}Ext.each(c,function(i){g[i.get("mountSpaceId")]=true;if(i.isActioning()){b=true;return false}});if(b){return false}f.each(function(i){if(i.isActioning()){return true}if(!i.get("vspace_can_do").flashcache.apply.can_do){return true}if("crashed"===i.get("status")){return true}if(i.usedByGlusterFs()){return true}if(g[i.get("id")]){return true}a=true;return false});if(!a){d.each(function(i){if(i.isFileLun()){return true}if(i.isActioning()){return true}if(!i.get("vspace_can_do").flashcache.apply.can_do){return true}if("crashed"===i.get("status")){return true}if(g[i.get("id")]){return true}a=true;return false})}return a},canDelete:function(a){var b=this,e,d,c;if(a.isActioning()){return false}e=a.get("mountSpaceId");if("-"===e){return true}if(-1<e.indexOf("volume")){d=b.appWin.volumes.data[e]}else{d=b.appWin.iscsiLuns.data[e]}if(d.isActioning()){return false}c=d.get("vspace_can_do");if(!Ext.isDefined(c.flashcache)||!c.flashcache.remove){return false}return true},canRepair:function(b){var c=this,a;if(b.isActioning()||b.isSpaceMissing()){return false}if(!Ext.isDefined(b.get("can_do").repair)){return false}if("write_bypass"===b.get("mode")){return false}if(0===b.get("disks").length){return false}a=c.getAvailableDisks(b);return(0<a.length)},canConfigure:function(a){if("umount_ssd"===a.get("status")||"mount_ssd"===a.get("status")){return false}return true},canStatistic:function(){var a=this,b=a.appWin.volumes.getAll();return(0<b.length)},getAvailableDisks:function(b){var c=this,a,d;d=b.get("minimal_disk_size");a=c.appWin.disks.getMatched(function(){var e=this;if(!e.isFree()){return false}if(c.appWin.hotSpares[e.id]){return false}if(!e.isSSD()){return false}if(parseInt(d,10)>parseInt(e.get("size_total"),10)){return false}return true});return a},openWizard:function(b,a){var c=this,e;if(c.appWin.isUpToBatchTaskCount()){e=_T("volume","volume_max_batch_task_count").replace("_MAX_TASK_",c.appWin.getMaxBatchTaskCount());c.appWin.getMsgBox().alert(c.title,e,function(){},c);return}var d=new SYNO.SDS.StorageManager.Wizard[b](Ext.apply({appWin:c.appWin,owner:c.owner},a));c.appWin.stopPollTask();c.mon(d,"close",function(){if(Ext.isFunction(d.hideFromOwner)){d.hideFromOwner()}if(d.isDataChanged){c.owner.setStatusBusy();c.listView.getEl().unmask();c.owner.cleanMask=true}c.appWin.startPollTask()},c,{single:true});d.open()},disableButtons:function(){Ext.each(arguments,function(d,a,c){var b=this.getButton(d);if(!b){throw Error("could not get button of id: "+d)}b.disable()},this)},getButton:function(a){return this.listPanel.getTopToolbar().getComponent(a)},enableButton:function(c,a){var b=this.getButton(c);if(!b){throw Error("could not get button of id: "+c)}return a?b.enable():b.disable()},applySettings:function(c,b){var a=this;a.owner.setStatusBusy();a.owner.cleanMask=true;a.appWin.stopPollTask();SYNO.API.Request({api:"SYNO.Storage.CGI.Flashcache",method:c,version:1,params:b,callback:function(g,f,e,d){var h={};a.appWin.startPollTask();if(!g){if(SYNO.SDS.StorageUtils.IsFeasibilityFail(f,h)){SYNO.SDS.StorageUtils.ConfirmFeasibilityFail(this,h,this.applySettings,c,Ext.applyIf({force:true},e))}else{SYNO.SDS.StorageUtils.ReportWebapiFailure(this,f)}return}},scope:a})}});Ext.define("SYNO.SDS.StorageManager.DetailView",{extend:"SYNO.ux.Panel",ssdBlkNum:100,round:1,lightMSec:200,darkMSec:100,constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;c.statusDesc={healthy:_T("volume","cache_healthy_desc"),caution:_T("volume","cache_degraded_desc"),attention:_T("volume","cache_crashed_desc")};c.ssdStore=new Ext.data.JsonStore({autoDestroy:true,fields:["status","name","desc","displayMountOn","mode","memSize","nameStatus","used","available","total","ratio","devInfos","dev_count","raidType","protectStatus"]});c.healthPanel=c.createHealthPanel();c.infoPanel=c.createInfoPanel();c.hitPanel=c.createHitPanel();b={border:false,layout:"anchor",padding:"0 0 0 0",autoFlexcroll:true,height:522,items:[{id:c.healthPanelId=Ext.id(),border:false,style:"padding-top: 8px;padding-bottom: 16px;",items:c.healthPanel},{border:false,style:"padding-bottom: 12px;",items:c.infoPanel},{height:138,border:false,items:c.hitPanel}]};c.callParent([Ext.apply(b,a)]);c.mon(c,"afterlayout",c.onAfterlayout,c);c.createSSDBlks();c.initBlinkTask()},onAfterlayout:function(){var a=0;a+=(Ext.get(this.nameStatusId))?Ext.get(this.nameStatusId).getHeight():0;a+=(Ext.get(this.descId))?Ext.get(this.descId).getHeight():0;a+=(Ext.get(this.protectStatusId))?Ext.get(this.protectStatusId).getHeight():0;a+=(Ext.get(this.mountOnId))?Ext.get(this.mountOnId).getHeight():0;a+=(Ext.get(this.cacheModeId))?Ext.get(this.cacheModeId).getHeight():0;a+=(Ext.get(this.raidTypeId))?Ext.get(this.raidTypeId).getHeight():0;a+=(Ext.get(this.repairBtnId))?Ext.get(this.repairBtnId).getHeight():0;if(Ext.get(this.propertyTextId)){Ext.get(this.propertyTextId).setHeight(((a-20)>124)?a-20:124)}if(this.ssdProperty){this.ssdProperty.setHeight(((a+8)>152)?a+8:152)}if(Ext.get(this.healthPanelId)){Ext.get(this.healthPanelId).setHeight(((a+32)>176)?a+32:176)}},createHealthPanel:function(){var b=this,a,d;var c='<div style="line-height: 20px;width:500px;"><div style="float:left;width:180px;"><div style="font-weight: bold;">{0}:</div></div><div id="{2}" style="float:left;width:310px;white-space: wrap;text-overflow:ellipsis;overflow:hidden;"><div>{1}</div></div></div>';b.ssdCacheHealth=new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">','<div style="height:152px;">','<div class="sm-ssd-health-icon sm-ssd-health-icon-{status}"></div>',"</div>","</tpl>"),store:b.ssdStore});d={itemId:"property",padding:"0 0 0 0",border:false,items:[new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">',String.format('<div id="{0}" style="padding-bottom:8px;">',b.propertyTextId=Ext.id()),String.format('<div id="{0}" class="sm-ssd-name-status-text">{nameStatus}</div>',b.nameStatusId=Ext.id()),String.format('<div id="{0}" class="sm-ssd-name-desc">{desc}</div>',b.descId=Ext.id()),'<tpl if="protectStatus">',String.format(c,_T("volume","cache_auto_protect_mechanism"),"{protectStatus}",b.protectStatusId=Ext.id()),"</tpl>",String.format(c,_T("volume","ssd_cache_on"),"{displayMountOn}",b.mountOnId=Ext.id()),String.format(c,_T("volume","cache_write_mode"),"{mode}",b.cacheModeId=Ext.id()),String.format(c,_T("volume","volume_raid_title"),"{raidType}",b.raidTypeId=Ext.id()),"</div>","</tpl>"),store:b.ssdStore}),{xtype:"syno_button",id:b.repairBtnId=Ext.id(),text:_T("volume","volume_adddisk2_type_repair"),handler:b.onRepair,scope:b},{xtype:"syno_button",id:b.removeBtnId=Ext.id(),text:_T("common","remove"),handler:b.onDelete,scope:b}]};b.ssdProperty=new SYNO.ux.FormPanel(d);a={border:false,layout:"hbox",align:"top",padding:"0 0 0 0",items:[{width:176,border:false,items:b.ssdCacheHealth},{width:500,border:false,items:b.ssdProperty}]};return new SYNO.ux.Panel(a)},createInfoPanel:function(){var d=this,b;var a='<div class="sm-ssd-usage-property" style="top: {2}px;">{0}: {1}</div>';var c='<div class="sm-ssd-dev-icon"><div class="sm-ssd-dev-status-{status}"></div></div><div class="sm-ssd-dev-info"><span style="font-weight:bold;">{name}</span></div><div class="sm-ssd-dev-info">{size}</div>';var e='<div class="sm-ssd-mini-dev-icon"><div class="sm-ssd-mini-dev-status-{status}"></div></div><div style="float: left"><div class="sm-ssd-mini-dev-info">{name}</div></div><div style="float: left; right: 18px; position: absolute;"><div class="sm-ssd-mini-dev-info">{size}</div></div>';b={itemId:"info",width:716,padding:"1px 1px 1px 1px",items:[d.deviceInfo=new Ext.DataView({cls:"sm-ssd-info-panel",tpl:new Ext.XTemplate('<tpl for=".">','<div style="margin-left: 1px;" class="sm-ssd-info-box">','<tpl if="this.getLength(devInfos) <= 2">','<div style="font-size:15px;line-height: 24px;">',_T("volume","ssd_device_info"),"</div>","</tpl>",'<tpl if="this.getLength(devInfos) &gt; 2">','<div style="font-size:15px;line-height: 24px; margin-bottom: 8px">',_T("volume","ssd_device_info"),"</div>",'<div id="ssdMiniDevList" style="height: 112px; padding-bottom: 6px">',"</tpl>",'<tpl for="devInfos">','<tpl if="xcount === 1">','<div style="width: 100%;" align="center">',c,"</div>","</tpl>",'<tpl if="xcount === 2">','<tpl if="xindex === 1">','<div style="float: left; width: 50%;" align="center">',c,"</div>","</tpl>",'<tpl if="xindex === 2">','<div style="float: left; width: 50%;" align="center">',c,"</div>","</tpl>","</tpl>",'<tpl if="xcount &gt; 2">','<div class="sm-ssd-dev-list">',e,"</div>","</tpl>","</tpl>",'<tpl if="this.getLength(devInfos) &gt; 2">',"</div>","</tpl>","</div>",'<div style="display:table-cell; width:12px;">',"</div>",'<div class="sm-ssd-info-box">','<div style="font-size:15px;line-height: 24px;">',_T("volume","cache_usage"),"</div>",'<div id="sm_cache_usage_chart" class="sm-ssd-usage-pie"></div>','<div style="font-size:15px;line-height: 24px;font-weight: bold;position: absolute;top: 53px;left: 132px;">{name}</div>',String.format(a,_T("volume","volume_usedsize"),"{used}","77"),String.format(a,_T("volume","unused_size"),"{available}","97"),String.format(a,_T("volume","ssd_cache_static_total"),"{total}","117"),"</div>","</tpl>",{getLength:function(f){return f.length||0}}),store:d.ssdStore})]};return new SYNO.ux.Panel(b)},createHitPanel:function(){var c=this,b;var a='<span style="font-size: 32px;color: #1CA600;" id="{0}">{1}</span><span style="font-size: 16px;color: #1CA600;">%</span>';var d='<div class="sm-ssd-hit-property"><span style="padding-left: 10px;">{0}</span><span style="padding-left: 8px;font-size: 20px;color: #0086E5;" id="{1}">{2}</span><span style="font-size: 12px;color: #0086E5;">%</span></div>';b={itemId:"info",width:716,height:138,padding:"1px 1px 1px 1px",items:[c.deviceInfo=new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">','<div style="margin-left: 1px;" class="sm-ssd-hit-box">','<div style="font-size:15px;line-height: 24px;">',_T("volume","read_hit_rate"),"</div>",'<div style="position: absolute;left: 20px;top: 42px;height: 48px;width: 550px;">','<tpl for="ssdblocks">','<div class="sm-ssd-blk sm-ssd-blk-cold" id="{id}"></div>',"</tpl>","</div>",'<div style="position: absolute;left: 582px;top: 38px;height: 52px;width: 4px;background-color: #D8E1EC;"></div>','<div style="position: absolute;left: 598px;top: 38px;height: 18px;width: 94px;">',_T("rsrcmonitor","realtime"),"</div>",'<div style="position: absolute;left: 598px;top: 56px;height: 34px;width: 94px;">',String.format(a,"Current","{Current}"),"</div>",'<div style="position: absolute;left: 20px;bottom: 10px;height: 28px;width: 672px;">',String.format(d,_T("rsrcmonitor","last_24_hours"),"Daily","{Daily}"),String.format(d,_T("rsrcmonitor","last_7_days"),"Weekly","{Weekly}"),String.format(d,_T("rsrcmonitor","last_30_days"),"Monthly","{Monthly}"),"</div>","</div>","</tpl>"),store:c.ssdHitStore=new Ext.data.JsonStore({autoDestroy:true,fields:["ssdblocks","Current","Daily","Weekly","Monthly"]})})]};return new SYNO.ux.Panel(b)},initBlinkTask:function(){var b=this,a=0,c=[],d;b.blkBlinkTarget0=[];b.blkBlinkTarget1=[];b.blkTrgBase0=[];b.blkTrgBase1=[];while(c.length<b.ssdBlkNum){d=Math.floor(Math.random()*b.ssdBlkNum);if(-1!==c.indexOf(d)){continue}c.push(d)}for(a=0;a<c.length;++a){if(a%2===0){b.blkTrgBase0.push(c[a])}else{b.blkTrgBase1.push(c[a])}}b.counter0=0;b.counter1=0},createSSDBlks:function(){var b=this,a,c;b.hitData={};b.hitData.ssdblocks=[];c=b.hitData.ssdblocks;for(a=0;a<this.ssdBlkNum;++a){c.push({id:"ssdBlk_"+a})}},onActivate:function(){var b=this,d={},c=b.owner.listView.getSelectedItem();var a=Ext.get("ssdMiniDevList");if(!b.appWin.loaded){return}if(!c){b.owner.fireEvent("prevList");return}if(a&&a.dom.fleXdata){b.devScrolled=a.dom.fleXdata.scrollPosition[1][0]}b.targetSSD=c;b.prepareSsdCachedata(d);b.ssdStore.loadData([d],false);window.fleXenv.fleXcrollMain("ssdMiniDevList");a=Ext.get("ssdMiniDevList");if(b.devScrolled&&a&&a.dom&&a.dom.fleXcroll){a.dom.fleXcroll.setScrollPos(false,b.devScrolled)}b.prepareHitData();b.doLayout();b.updateUI(d);b.mon(Ext.fly(b.volLinkId),"click",b.linkTargetElement,b,{single:true});b.blinkTaskStart()},updateDevListScrollBar:function(){window.fleXenv.fleXcrollMain("ssdMiniDevList");this.doLayout()},onDeactivate:function(){var a=this;a.blinkTaskStop();if(a.loadHistPollTask){a.loadHistPollTask.stop();delete a.loadHistPollTask}a.resetUI()},resetUI:function(){var a=this;delete a.hitData;a.createSSDBlks();a.hitData.Current=0;a.hitData.Minutely=0;a.hitData.Daily=0;a.hitData.Weekly=0;a.hitData.Monthly=0;a.ssdHitStore.loadData([a.hitData],false)},blinkTaskStart:function(){var a=this;if(!a.isBlinking){a.isBlinking=true;a.blkLightTask0();a.blkLightTask1.defer(a.round*(a.lightMSec+a.darkMSec)/2,a)}},blinkTaskStop:function(){this.isBlinking=false},prepareHitData:function(){var b=this,a=b.targetSSD;if(a.isSpaceMissing()){return}if(!b.loadHistPollTask){b.loadHistPollTask=b.addWebAPITask({api:"SYNO.Storage.CGI.Flashcache",method:"load_history_data",version:1,interval:2000,params:{cacheRaidId:a.get("SSDPath").substr(a.get("SSDPath").lastIndexOf("/")+1)},callback:function(i,h,g,d){var c=this,e,f=g.cacheRaidId;if(c.isDestroyed||!i){return}if(!i||!h.histData||!h.histData.FlashCache){SYNO.SDS.StorageUtils.ReportWebapiFailure(this,h);return}e=h.histData.FlashCache;c.updateHistData(e,"Current",f,0);c.updateHistData(e,"Minutely",f,c.hitData.Current);c.updateHistData(e,"Daily",f,c.hitData.Minutely);c.updateHistData(e,"Weekly",f,c.hitData.Daily);c.updateHistData(e,"Monthly",f,c.hitData.Weekly);if(true!==c.initHitPanel){c.ssdHitStore.loadData([c.hitData],false);c.initHitPanel=true}},scope:b});b.loadHistPollTask.start()}},updateHistData:function(d,a,f,c){var b=this,e;b.hitData[a]=c;if(d[a]&&d[a].success&&d[a][f]){e=d[a][f];if(e.success&&e.read_total>0){b.hitData[a]=Math.ceil(e.read_hit*100/e.read_total);if(100<b.hitData[a]){b.hitData[a]=100}}}else{b.hitData[a]="--"}if(Ext.get(a)){Ext.get(a).dom.innerHTML=b.hitData[a]}},prepareSsdCachedata:function(g){var l=this,n=SYNO.SDS.StorageUtils,a=l.targetSSD;var m='<a class="{3}" {4} id="{0}" space_id="{1}">{2}</a>';var b='<div style="display:inline" ext:qtip="{0}">{1}</div>';var j=n.SpaceIDParser(a.id).str;var k=parseInt(a.get("size").total,10);var e=parseInt(a.get("size").used,10);var h,d,i,f,o,c;l.volLinkId=Ext.id();if("read"===a.get("mode")){g.mode=_T("volume","cache_mode_read_only")}else{g.mode=_T("volume","cache_mode_read_write")}g.protectStatus="";c=a.get("protectProgress");if(a.isCrashed()){f="attention"}else{if(a.isDegrade()){f="caution";if(100==c){g.protectStatus=_T("volume","cache_degrade_sync_done_desc")}else{g.protectStatus=String.format(_T("volume","cache_degrade_sync_progress_desc"),(Ext.isNumber(c)?Math.round(c*100)/100:0)+"%")}}else{f="healthy"}}if(a.isSpaceMissing()){o=a.getStatusStr()}else{if(a.isRepairing()){o=String.format(_T("volume","cache_repairing_desc"),j)+" "+n.ProgressRender(a.get("progress"))}else{if(a.isCrashed()){if("read"===a.get("mode")){o=String.format(_T("volume","cache_cached_read_only_desc"),j)}else{if(100==a.get("protectProgress")){o=String.format(_T("volume","cache_safe_crash_desc"),j);g.protectStatus=_T("volume","cache_degrade_sync_done_desc")}else{o=String.format(_T("volume","cache_unsafe_crash_desc"),j);g.protectStatus=_T("volume","cache_sync_fail_desc")}}}else{o=String.format(l.statusDesc[f],j)}}}g.name=j;g.nameStatus=String.format("{0} ({1})",j,a.getStatusStr());g.desc=o;g.raidType=n.SpaceTypeRender(a.get("device_type"));g.total=n.SizeRender(k);if(!a.isSpaceMissing()&&(a.isNormal()||a.isDegrade())){g.used=n.SizeRender(e);g.available=n.SizeRenderWithFloor(k-e);g.ratio=e/k}else{g.used="--";g.available="--";g.ratio=0}g.status=f;g.dev_count=a.get("dev_count");if(a.isSpaceMissing()||"-"===a.get("mountSpaceId")){d=String.format(m,l.volLinkId,a.get("mountSpaceId"),"--","normal-font","")}else{d=String.format(m,l.volLinkId,a.get("mountSpaceId"),Ext.util.Format.ellipsis(n.SpaceIDParser(a.get("mountSpaceId")).str,28),"link-font",'href="#"')}h=l.appWin.volumes.data[a.get("mountSpaceId")];if(h&&h.get("desc")){i=h.get("desc");g.displayMountOn=String.format("{0} ({1})",d,String.format(b,Ext.util.Format.htmlEncode(i),i))}else{g.displayMountOn=d}l.getDeviceInfo(g,a.get("disks"))},getDeviceInfo:function(e,d){var c,a=this.owner.owner.disks,b;if(!a){return}e.devInfos=[];for(c=0;c<d.length;++c){b=a.data[d[c]];if(undefined!==b){e.devInfos.push({name:SYNO.SDS.StorageUtils.DiskDisplayNameGet(b),size:SYNO.SDS.StorageUtils.SizeRender(parseInt(b.get("size_total"),10)),status:b.get("status"),numId:b.get("num_id"),pciSlot:b.get("pciSlot"),portType:b.get("portType"),ctnOrder:parseInt(b.get("container").order,10)})}}e.devInfos.sort(SYNO.SDS.StorageUtils.DiskSort);while(e.devInfos.length<e.dev_count){e.devInfos.push({name:_T("volume","volume_unknown_expansion"),size:"--",status:"crashed"})}},updateUI:function(a){this.checkBtnStatus(this.targetSSD);this.drawPieChart(a.ratio)},checkBtnStatus:function(a){Ext.getCmp(this.repairBtnId).setDisabled(!this.owner.canRepair(a));Ext.getCmp(this.removeBtnId).setDisabled(!this.owner.canDelete(a))},drawPieChart:function(b){var a=new SYNO.SDS.Utils.canvas.circlegradient({radius:48,gradientWidth:16,height:96,width:96,canvasConfig:{height:96,width:96},renderTo:"sm_cache_usage_chart"});a.draw(Math.min(b,1))},resetBlinkTarget:function(d,b){var c=this,f,a,e=[];if(undefined===c.hitData||undefined===c.hitData.Current){return e}if(100<c.hitData.Current){c.hitData.Current=100}if(b){f=Math.ceil(c.hitData.Current/2)}else{f=Math.floor(c.hitData.Current/2)}while(e.length<f){a=Math.floor(Math.random()*c.ssdBlkNum/2);if(-1!==e.indexOf(d[a])){continue}e.push(d[a])}return e},blkLightTask0:function(){var b=this,a=0;b.blkBlinkTarget0=b.resetBlinkTarget(b.blkTrgBase0,true);if(undefined===b.blkBlinkTarget0||0===b.blkBlinkTarget0.length){if(b.isBlinking){b.blkLightTask0.defer(1000,b)}return}for(a=0;a<b.blkBlinkTarget0.length;a++){if(a===b.blkBlinkTarget0.length-1){b.blkLight(b.blkBlinkTarget0[a],0,true,true)}else{b.blkLight(b.blkBlinkTarget0[a],0,false,true)}}},blkLightTask1:function(){var b=this,a=0;b.blkBlinkTarget1=b.resetBlinkTarget(b.blkTrgBase1,false);if(undefined===b.blkBlinkTarget1||0===b.blkBlinkTarget1.length){if(b.isBlinking){b.blkLightTask1.defer(1000,b)}return}for(a=0;a<b.blkBlinkTarget1.length;a++){if(a===b.blkBlinkTarget1.length-1){b.blkLight(b.blkBlinkTarget1[a],0,true,false)}else{b.blkLight(b.blkBlinkTarget1[a],0,false,false)}}},blkLight:function(f,a,e,b){var d=this,c=Ext.get("ssdBlk_"+f.toString());if(c){c.addClass("sm-ssd-blk-hit");c.removeClass("sm-ssd-blk-cold");if(b){d.blkDarken.defer(d.lightMSec,d,[f,a,e,b])}else{d.blkDarken.defer(d.lightMSec,d,[f,a,e,b])}}},blkDarken:function(f,a,e,b){var d=this,c=Ext.get("ssdBlk_"+f.toString());if(c){c.removeClass("sm-ssd-blk-hit");c.addClass("sm-ssd-blk-cold")}if(!d.isBlinking){return}if(a<d.round-1){d.blkLight.defer(d.darkMSec,d,[f,++a,e,b])}else{if(e){if(b){d.blkLightTask0()}else{d.blkLightTask1()}}}},linkTargetElement:function(g,f){var d=this,c=new Ext.Element(f),h=c.getAttribute("space_id");var a=function(j){var e=d.appWin.iscsiLuns;if(!e||e.count<=0){return""}var i=e.getById(j);if(!i||!i.get("iscsi_lun")||!i.get("iscsi_lun").uuid){return""}return i.get("iscsi_lun").uuid};if("-"===h){return}if(-1!==h.indexOf("volume_")){d.appWin.selectPage("SYNO.SDS.StorageManager.Volume.Main");d.appWin.getActivePage().setFocus(h)}else{var b=a(h);if(!b){return}SYNO.SDS.AppLaunch("SYNO.SDS.iSCSI.Application",{dlg:"FocusLun",params:{lun_uuid:b}})}},onRepair:function(){this.owner.onRepair()},onDelete:function(){this.owner.onDelete()}});Ext.namespace("SYNO.SDS.StorageManager.StorageOverview");Ext.namespace("SYNO.SDS.StorageManager.StorageOverview.DrawData");SYNO.SDS.StorageManager.StorageOverview.DrawData.Info={height:48,left:18,modelNameLeft:36,portWidth:36,portHeight:16,portGap:6,outPortLeft:183,outPortTop:26,hostOutPortTop:16,outLinkLeft:289,outLinkTop:32,hostOutLinkTop:21,inPortLeft:183,inPortTop:5,linkWidth:6,linkHeight:42,hostlinkHeight:52,linkGap:33,iconWidth:16,iconHeight:16};SYNO.SDS.StorageManager.StorageOverview.DrawData.Hdd={width:52,height:11,initLeft:16,initTop:2,hGap:6,vGap:5};SYNO.SDS.StorageManager.StorageOverview.DrawData.LcmHost={width:260,height:52,left:0,top:0,hddCount:10,hddLayout:[3,3,4],hdd:SYNO.SDS.StorageManager.StorageOverview.DrawData.Hdd,gap:4,info:SYNO.SDS.StorageManager.StorageOverview.DrawData.Info,lightHeight:24,lightLeft:322};SYNO.SDS.StorageManager.StorageOverview.DrawData.Enclosure={width:260,height:52,left:0,top:0,hddCount:12,hddLayout:[4,4,4],hdd:SYNO.SDS.StorageManager.StorageOverview.DrawData.Hdd,gap:4,info:SYNO.SDS.StorageManager.StorageOverview.DrawData.Info,lightHeight:24,lightLeft:322};Ext.define("SYNO.SDS.StorageManager.Enclosure",{check:SYNO.SDS.StorageUtils.check,get:function(a){if(this.json){return this.json[a]}return undefined}});Ext.define("SYNO.SDS.StorageManager.StorageOverview.Main",{extend:"SYNO.ux.Panel",pollTask:null,hdds:null,displayDiskNum:false,constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.appWin;b={title:_T("helptoc","Enclosure"),itemId:"storage_overview",border:false,autoFlexcroll:true,tbar:{items:[{xtype:"syno_button",itemId:"DiskNumToggle",text:_T("volume","volume_display_disk_num"),handler:c.onDiskNumber,scope:c}]},items:c.canvas=new Ext.Panel({border:false,height:520}),listeners:{activate:c.onActivate,deactivate:c.onDeactivate,scope:c}};c.callParent([Ext.apply(b,a)])},getHelpParam:function(){return"StorageManager/storage_overview.html"},initEvents:function(){this.callParent(arguments);this.createPollTask()},createPollTask:function(){this.pollTask=this.addWebAPITask({webapi:{api:"SYNO.Storage.CGI.Enclosure",method:"load",version:1},interval:6000,scope:this,callback:this.pollTaskHandler})},startPollTask:function(){this.pollTask.start()},stopPollTask:function(){this.pollTask.stop()},pollTaskHandler:function(e,c,d,b){if(this.owner.cleanMask){this.owner.clearStatusBusy();this.owner.cleanMask=false}if(!e){return}var a=c.enclosures;if(!a){return}if(this.checkAndSetMask(a)){return}a=this.findTopology(a);this.renderEnclosure(a)},checkAndSetMask:function(a){var c=0;for(var b=0;b<a.length;b++){c+=a[b].ports.length}if(0===c){this.getEl().mask(_T("volume","volume_no_expansion"),"syno-ux-mask-info");this.canvas.setHeight(0);return true}else{this.getEl().unmask();this.canvas.setHeight(520);return false}},renderEnclosure:function(b){this.canvas.body.update("");delete this.hdds;this.hdds=[];var c=9;var e;var j=_D("sas_enclosure_max")-1;var f={top:c,left:4};var d=false;if(0<b.length){if(b[0].isLcm){d=false}else{d=true}}Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:(d)?"sm-storage-overview-bg-light-upper":"sm-storage-overview-bg-upper",style:{top:"5px"}});for(var h=0;h<j;h++){e=63+56*h;Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:(d)?"sm-storage-overview-bg-light-mid":"sm-storage-overview-bg-mid",style:{top:e+"px"}})}e=63+56*j;Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:(d)?"sm-storage-overview-bg-light-bottom":"sm-storage-overview-bg-bottom",style:{top:e+"px"}});if(e>520){this.canvas.setHeight(e+70)}for(h=0;h<b.length;h++){var a;if(b[h].isLcm){a=SYNO.SDS.StorageManager.StorageOverview.DrawData.LcmHost}else{a=SYNO.SDS.StorageManager.StorageOverview.DrawData.Enclosure}if(!a){continue}a.left=f.left;a.top=f.top;var g=h===b.length-1;this.checkSystemStatus(b[h]);this.renderHardwareAndStatus(b[h],a,d);this.renderPortAndLink(b[h],a,g);this.renderHdd(b[h],a);this.renderSystemLight(b[h],a);f.top+=a.gap+a.height}this.doLayout()},checkSystemStatus:function(c){var a,b=true;for(a=0;a<c.powers.length;a++){if(0===c.powers[a].status){b=false;break}}if(b){for(a=0;a<c.fans.length;a++){if(0===c.fans[a].status){b=false;break}}}c.isGood=b},renderHardwareAndStatus:function(j,a,e){var m=j.isLcm?"sds-enclosures2-host-lcm":((e)?"sds-enclosures2-enclosure-dark":"sds-enclosures2-enclosure");var l=j.isGood?"good":"bad";var c=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:m,style:{left:a.left+"px",top:a.top+"px"}}));var d,k,h,g;a.width=c.getWidth();a.height=c.getHeight();var i=a.top+a.height/2-a.info.height/2;m=String.format("sds-enclosures2-infoleft-{0}",l);d=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:m,style:{top:i+"px"}}));m=String.format("sds-enclosures2-infocenter-{0}",l);k=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:m,style:{top:i+"px"}}));m=String.format("sds-enclosures2-inforight-{0}",l);h=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:m,style:{top:i+"px"}}));m=j.isGood?"sds-enclosures2-info-modelName-good":"sds-enclosures2-info-modelName-bad";var f=j.modelName.replace("Synology-","");var b=j.isInternal?_S("hostname"):String.format("{0} {1}",f,j.id);g=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",html:b,cls:m,style:{top:i+"px"},"ext:qtip":b}))},renderPortAndLink:function(h,a,f){var n=a.left+a.width+a.info.left;var j=a.top+a.height/2-a.info.height/2;var m,b,c,d,l,k,g;if(h.isInternal){Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sds-enclosures2-info-port-out",style:{top:j+a.info.hostOutPortTop+"px"}})}else{Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sds-enclosures2-info-port-in",style:{top:j+a.info.inPortTop+"px"}});Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sds-enclosures2-info-port-out",style:{top:j+a.info.outPortTop+"px"}})}for(var e=0;e<h.ports.length;e++){if((2===h.ports.length&&e<1&&!h.isInternal)||(4===h.ports.length&&e<2&&!h.isInternal)){continue}d=false;if(h.isInternal){if(f){if(1===h.ports.length&&"0"===h.ports[0].linkId||2===h.ports.length&&"0"===h.ports[0].linkId&&"0"===h.ports[1].linkId){continue}m="sds-enclosures2-info-disconnected-long";b=a.info.hostOutLinkTop;c=a.info.hostlinkHeight}else{d=2===h.ports[e].portType&&h.ports[e].linkPortNum===h.ports[e].portNum;m=d?"sds-enclosures2-info-connected-long":"sds-enclosures2-info-disconnected-long";b=a.info.hostOutLinkTop;c=a.info.hostlinkHeight}}else{if(f){if(2===h.ports.length&&"0"===h.ports[1].linkId||4===h.ports.length&&"0"===h.ports[2].linkId&&"0"===h.ports[3].linkId){continue}m="sds-enclosures2-info-disconnected";b=a.info.outLinkTop;c=a.info.linkHeight}else{d=2===h.ports[e].portType&&h.ports[e].linkPortNum+2===h.ports[e].portNum;m=d?"sds-enclosures2-info-connected":"sds-enclosures2-info-disconnected";b=a.info.outLinkTop;c=a.info.linkHeight}}l=a.info.linkWidth*(e%2)+a.info.linkGap*(e%2);Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:m,style:{left:n+a.info.outLinkLeft+l+"px",top:j+b+"px"}});if(!d){k=n+a.info.outLinkLeft+l+a.info.linkWidth/2-a.info.iconWidth/2-1;g=j+b+c/2-a.info.iconHeight/2;Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sds-enclosures2-info-disconnected-icon",style:{left:k+"px",top:g+"px"}})}}},renderHdd:function(k,a){var l,h=a.hdd.initTop+a.top;var g=0;for(var d=0;d<a.hddLayout.length;d++){l=a.hdd.initLeft+a.left;for(var c=0;c<a.hddLayout[d];c++){var f=Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sds-enclosures2-hdd",style:{left:l+"px",top:h+"px","font-size":"11px"}});var b=new Ext.Element(f);b.owner=this;b.order=g+1;b.status=(g<k.disks.length&&0!==k.disks[g].id)?1:0;if(this.displayDiskNum&&0!==b.status){var e=b.order<10?"0"+b.order:b.order;f.innerHTML=e;f.style.border="2px solid"}this.hdds.push(b);l+=a.hdd.hGap+a.hdd.width;g++}h+=a.hdd.vGap+a.hdd.height}},renderSystemLight:function(d,b){var c=this,a;a=new Ext.Element(Ext.DomHelper.append(c.canvas.body,{tag:"div",cls:d.isGood?"sds-enclosures2-info-light-good":"sds-enclosures2-info-light-bad",style:{top:b.top+b.height/2-b.lightHeight/2+"px"}}));a.on("click",c.onShowSysInfo,{appWin:c.appWin,owner:c.owner,panel:c,data:d})},onActivate:function(){var a=this;a.canvas.body.update("");a.owner.setStatusBusy();a.owner.cleanMask=true;a.appWin.stopPollTask();a.startPollTask()},onDeactivate:function(){this.appWin.startPollTask();this.stopPollTask()},onDiskNumber:function(){this.displayDiskNum=!this.displayDiskNum;var d=this.displayDiskNum?_T("volume","volume_hide_disk_num"):_T("volume","volume_display_disk_num");this.getTopToolbar().getComponent("DiskNumToggle").setText(d);for(var b=0;b<this.hdds.length;b++){if(0!==this.hdds[b].status){var a=this.hdds[b].order<10?"0"+this.hdds[b].order:this.hdds[b].order;var c=this.hdds[b].dom;c.innerHTML=this.displayDiskNum?a:"";c.style.border=this.displayDiskNum?"2px solid":""}}},onShowSysInfo:function(){var d=[],c,a,b;var e=String.format("{0} {1} / {2} {3}",this.data.temperature,_T("status","celsius"),this.panel.C2F(this.data.temperature).toFixed(0),_T("status","fahrenheit"));d.push({item:_T("status","temperature"),status:e});for(c=0;c<this.data.powers.length;c++){a=1===this.data.powers[c].status?'<font class="green-status">'+_T("volume","volume_status_normal")+"</font>":'<font class="red-status">'+_T("common","status_abnormal")+"</font>";d.push({item:_T("tree","leaf_powermgr")+this.data.powers[c].num,status:a})}for(c=0;c<this.data.fans.length;c++){a=1===this.data.fans[c].status?'<font class="green-status">'+_T("volume","volume_status_normal")+"</font>":'<font class="red-status">'+_T("common","status_abnormal")+"</font>";d.push({item:_T("system","system_fan")+this.data.fans[c].num,status:a})}b=new SYNO.SDS.StorageManager.Wizard.StorageOverviewInfo({appWin:this.appWin,owner:this.owner,panel:this.panel,data:d});this.panel.mon(b,"close",function(){this.panel.startPollTask()},this,{single:true});this.panel.stopPollTask();b.open()},findTopology:function(b){var f,h,c=0,j={};for(f=0;f<b.length;f++){if(b[f].isInternal){h=b[f];break}}var l=h.uniqueId,d=null;for(f=0;f<h.ports.length;f++){h.ports[f].portType="0"===h.ports[f].linkId?3:2;if(!d&&2===h.ports[f].portType){d=h.ports[f].linkId}}if(2<=h.ports.length){if(3!==h.ports[0].portType&&3!==h.ports[1].portType&&h.ports[0].linkId!==h.ports[1].linkId){h.ports[1].portType=4}}j[l]=true;var g=[];g.push(h);do{if(1===b.length){break}var m=false;for(f=0;f<b.length;f++){if(b[f].uniqueId===d&&undefined===j[d]){h=b[f];m=true;break}}if(!m){break}var k=h.ports,e=0;for(f=0;f<k.length;f++){if(k[f].linkId===l&&2>e){k[f].portType=1;e++}else{if(k[f].linkId===l&&2<=e){k[f].portType=4}else{if("0"===k[f].linkId){k[f].portType=3}else{k[f].portType=-1}}}}d="0";e=0;for(f=0;f<k.length;f++){if(-1===k[f].portType){if("0"===d){d=k[f].linkId}if(k[f].linkId===d){k[f].portType=2}else{k[f].portType=4}}}g.push(h);l=h.uniqueId;j[l]=true;c++;var a=true;for(f=0;f<k.length;f++){if(1===k[f].portType&&!k[f].valid){a=false;break}}if(!a){break}}while(c<b.length-1);return g},C2F:function(a){return(a*9/5+32)}});Ext.define("SYNO.SDS.StorageManager.Wizard.StorageOverviewInfo",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;b={title:_T("home","home_subject"),width:400,height:320,layout:"fit",dsmStyle:"v5",border:false,items:[{layout:"fit",xtype:"syno_gridpanel",border:false,columns:[{header:_T("smart","smart_attribute"),dataIndex:"item",width:200,sortable:false},{header:_T("relayservice","status"),dataIndex:"status",width:200,useHtmlEncodeRender:false,sortable:false}],store:new Ext.data.JsonStore({autoDestroy:true,fields:["item","status"],data:a.data})}],buttons:[{xtype:"syno_button",text:_T("common","alt_close"),handler:this.close,scope:this}]};c.callParent([Ext.apply(b,a)])}});Ext.namespace("SYNO.SDS.StorageManager.StorageDualHeadOverview");Ext.namespace("SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData");SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData.Info={height:48,left:18,modelNameLeft:36,portWidth:36,portHeight:16,portGap:6,outPortLeft:183,outPortTop:26,hostOutPortTop:16,outLinkLeft:289,outLinkTop:32,hostOutLinkTop:21,inPortLeft:183,inPortTop:5,linkWidth:6,linkHeight:42,hostlinkHeight:52,linkGap:33,iconWidth:16,iconHeight:16};SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData.Hdd={width:52,height:11,initLeft:16,initTop:2,hGap:6,vGap:5};SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData.Host={width:260,height:52,left:0,top:0,gap:4,info:SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData.Info,lightHeight:24,lightLeft:322,firstOffsetLeft:534};SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData.RS10613xsp={width:260,height:52,left:0,top:0,hddCount:10,hddLayout:[3,3,4],hdd:SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData.Hdd,gap:4,info:SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData.Info,lightHeight:24,lightLeft:322};SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData.Enclosure={width:260,height:52,left:0,top:0,hddCount:12,hddLayout:[4,4,4],hdd:SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData.Hdd,gap:4,info:SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData.Info,lightHeight:24,lightLeft:322};Ext.define("SYNO.SDS.StorageManager.StorageDualHeadOverview.Main",{extend:"SYNO.ux.Panel",pollTask:null,hdds:null,displayDiskNum:false,constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.appWin;b={itemId:"storage_overview",border:false,autoFlexcroll:true,tbar:{items:[{xtype:"syno_button",itemId:"DiskNumToggle",text:_T("volume","volume_display_disk_num"),handler:c.onDiskNumber,scope:c}]},items:c.canvas=new Ext.Panel({border:false,height:975}),listeners:{activate:c.onActivate,deactivate:c.onDeactivate,scope:c}};c.callParent([Ext.apply(b,a)])},getHelpParam:function(){return"StorageManager/storage_overview.html"},initEvents:function(){this.callParent(arguments);this.createPollTask()},createPollTask:function(){this.pollTask=this.addWebAPITask({webapi:{api:"SYNO.Storage.CGI.DualEnclosure",method:"load",version:1},interval:6000,scope:this,callback:this.pollTaskHandler})},startPollTask:function(){this.pollTask.start()},stopPollTask:function(){this.pollTask.stop()},pollTaskHandler:function(e,c,d,b){if(this.owner.cleanMask){this.owner.clearStatusBusy();this.owner.cleanMask=false}if(!e){return}var a=c.AHAInfo;if(!a){return}this.renderEnclosure(a)},renderSlots:function(a){var b=a.enc_cnt+a.host_cnt-2;var c;Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sm-storage-overview-bg-light-upper",style:{top:"5px"}});for(var d=0;d<b;d++){c=58+56*d;Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sm-storage-overview-bg-light-mid",style:{top:c+"px"}})}c=58+56*b;Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sm-storage-overview-bg-light-bottom",style:{top:c+"px"}})},renderEnclosure:function(c){this.canvas.body.update("");delete this.hdds;this.hdds=[];var d=9;var e={top:d,left:4};var j=[];var b=c.enclosures;var g;var k;var h;var a;var l;var f;this.renderSlots(c);for(g=0;g<c.host_cnt;++g){k=(c.hosts[g].host_type&24)>>3;j[k-1]=c.hosts[g]}for(g=1;g>=0;g--){h="Host";a=SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData[h];l=0===g%2;f=g===c.enc_cnt-1;if(!a||!j[g]||!j[g].host_type||j[g].modelname.empty()){continue}a.left=e.left;a.top=e.top+13;j[g].offsetLeft=(1==g)?true:false;j[g].isInternal=true;j[g].isGood=true;j[g].isSingle=(c.host_cnt==2)?false:true;this.checkSystemStatus(j[g]);this.renderHardwareAndStatus(j[g],a,l);this.renderPortAndLink(j[g],a,f);this.renderHostSystemLight(j[g],a);e.top+=a.gap+a.height+26}for(g=0;g<c.enc_cnt;g++){h="Enclosure";a=SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData[h];if(!a){continue}a.left=e.left;a.top=e.top;l=0===g%2;f=g===c.enc_cnt-1;b[g].isInternal=false;b[g].id=g+1;this.checkSystemStatus(b[g]);this.renderHardwareAndStatus(b[g],a,l);this.renderPortAndLink(b[g],a,f);this.renderHdd(b[g],a);this.renderSystemLight(b[g],a);e.top+=a.gap+a.height}this.setCanvasHeight(c,b,e.top);this.doLayout()},setCanvasHeight:function(c,g,a){var f=0;var b="Enclosure";var e=SYNO.SDS.StorageManager.StorageDualHeadOverview.DrawData[b];for(var d=0;d<g[c.enc_cnt-1].links.length;d++){if(0!==g[c.enc_cnt-1].links[d]){f=e.info.linkHeight;break}}this.canvas.setHeight(a+f)},checkSystemStatus:function(c){var a,b=true;for(a=0;a<c.powers.length;a++){if(0===c.powers[a]){b=false;break}}if(b){for(a=0;a<c.fans.length;a++){if(0===c.fans[a]||-1===c.fans[a]){b=false;break}}}c.isGood=b},renderHardwareAndStatus:function(h,a,k){var l=h.isInternal?"sds-enclosures-dual-host":"sds-enclosures2-enclosure-dark";var j=h.isGood?"good":"bad";var c=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:l,style:{left:a.left+"px",top:a.top+"px"}}));var d,i,f,e;a.width=c.getWidth();a.height=c.getHeight();var g=a.top+a.height/2-a.info.height/2;l=String.format("sds-enclosures2-infoleft-{0}",j);d=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:l,style:{top:g+"px"}}));l=String.format("sds-enclosures2-infocenter-{0}",j);i=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:l,style:{top:g+"px"}}));l=String.format("sds-enclosures2-inforight-{0}",j);f=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:l,style:{top:g+"px"}}));l=h.isGood?"sds-dual-enclosures2-info-modelName-good":"sds-dual-enclosures2-info-modelName-bad";var b=h.isInternal?h.modelname:h.model+" "+h.id;e=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",html:b,cls:l,style:{top:g+"px"},"ext:qtip":b}))},renderPortAndLink:function(m,a,h){var r=a.left+a.width+a.info.left;var n=a.top+a.height/2-a.info.height/2;var q,b,d,f,p,o,k;var e,l;if(m.isInternal){var j=Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sds-enclosures2-info-port-out1U-2",style:{top:n+a.info.hostOutPortTop+"px"}});if(m.offsetLeft){j.style.left=a.firstOffsetLeft+"px";j.className="sds-enclosures2-info-port-out1U-1"}}else{Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sds-enclosures2-info-port-in",style:{top:n+a.info.inPortTop+"px"}});Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sds-enclosures2-info-port-out",style:{top:n+a.info.outPortTop+"px"}})}for(var g=0;g<m.links.length;g++){var c=g;f=false;if(m.isInternal){if(h){if(0===m.links[0]){continue}f=(2===m.links[g]);e=f?"sds-enclosures2-info-connected-long":"sds-enclosures2-info-disconnected-long";l=f?"sds-enclosures2-info-connected-long1U":"sds-enclosures2-info-disconnected-long1U";q=(m.offsetLeft&&!m.isSingle)?l:e;c=(m.offsetLeft)?g+1:g;b=a.info.hostOutLinkTop;d=a.info.hostlinkHeight}else{f=(2===m.links[g]);e=f?"sds-enclosures2-info-connected-long":"sds-enclosures2-info-disconnected-long";l=f?"sds-enclosures2-info-connected-long1U":"sds-enclosures2-info-disconnected-long1U";q=(m.offsetLeft&&!m.isSingle)?l:e;c=(m.offsetLeft)?g+1:g;b=a.info.hostOutLinkTop;d=a.info.hostlinkHeight}}else{if(h){if(0===m.links[g]){continue}f=(2===m.links[g]);q=f?"sds-enclosures2-info-connected-long":"sds-enclosures2-info-disconnected-long";b=a.info.outLinkTop;d=a.info.linkHeight}else{f=(2===m.links[g]);q=f?"sds-enclosures2-info-connected":"sds-enclosures2-info-disconnected";b=a.info.outLinkTop;d=a.info.linkHeight}}p=a.info.linkWidth*(c%2)+a.info.linkGap*(c%2);Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:q,style:{left:r+a.info.outLinkLeft+p+"px",top:n+b+"px"}});if(!f){o=r+a.info.outLinkLeft+p+a.info.linkWidth/2-a.info.iconWidth/2-1;k=n+b+d/2-a.info.iconHeight/2;Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sds-enclosures2-info-disconnected-icon",style:{left:o+"px",top:k+"px"}})}}},renderHdd:function(m,a){var n,l=a.hdd.initTop+a.top;var k=0;for(var f=0;f<a.hddLayout.length;f++){n=a.hdd.initLeft+a.left;for(var e=0;e<a.hddLayout[f];e++){var o,h,b;var c=1;var d=8;if(m.disks[k]&d||m.disks[k]&c){o="sds-enclosures2-hdd"}h=Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:o,style:{left:n+"px",top:l+"px","font-size":"11px"}});b=new Ext.Element(h);b.owner=this;b.order=k+1;b.status=!!m.disks[k];if(this.displayDiskNum&&b.status){var g=b.order<10?"0"+b.order:b.order;h.innerHTML=g;h.style.border="2px solid"}this.hdds.push(b);n+=a.hdd.hGap+a.hdd.width;k++}l+=a.hdd.vGap+a.hdd.height}},renderSystemLight:function(d,b){var c=this,a;a=new Ext.Element(Ext.DomHelper.append(c.canvas.body,{tag:"div",cls:d.isGood?"sds-enclosures2-info-light-good":"sds-enclosures2-info-light-bad",style:{top:b.top+b.height/2-b.lightHeight/2+"px"}}));a.on("click",c.onShowSysInfo,{appWin:c.appWin,owner:c.owner,panel:c,data:d})},renderHostSystemLight:function(d,b){var c=this,a;a=new Ext.Element(Ext.DomHelper.append(c.canvas.body,{tag:"div",cls:d.isGood?"sds-enclosures2-info-light-good":"sds-enclosures2-info-light-bad",style:{top:b.top+b.height/2-b.lightHeight/2+"px"}}));a.on("click",c.onShowHostSysInfo,{appWin:c.appWin,owner:c.owner,panel:c,data:d})},onActivate:function(){var a=this;a.canvas.body.update("");a.owner.setStatusBusy();a.owner.cleanMask=true;a.appWin.stopPollTask();a.startPollTask()},onDeactivate:function(){this.appWin.startPollTask();this.stopPollTask()},onDiskNumber:function(){this.displayDiskNum=!this.displayDiskNum;var d=this.displayDiskNum?_T("volume","volume_hide_disk_num"):_T("volume","volume_display_disk_num");this.getTopToolbar().getComponent("DiskNumToggle").setText(d);for(var b=0;b<this.hdds.length;b++){if(this.hdds[b].status){var a=this.hdds[b].order<10?"0"+this.hdds[b].order:this.hdds[b].order;var c=this.hdds[b].dom;c.innerHTML=this.displayDiskNum?a:"";c.style.border=this.displayDiskNum?"2px solid":""}}},onShowSysInfo:function(){var g=[],e,c,b,d;var a=2;var f=this.data.fans.length/2;g.push({item:_T("common","enc_serial"),status:this.data.sn});var h=String.format("{0} {1} / {2} {3}",this.data.temperature,_T("status","celsius"),this.panel.C2F(this.data.temperature).toFixed(0),_T("status","fahrenheit"));g.push({item:_T("status","temperature"),status:h});for(e=0;e<this.data.powers.length;e++){b=1===this.data.powers[e]?'<font class="green-status">'+_T("volume","volume_status_normal")+"</font>":'<font class="red-status">'+_T("common","status_abnormal")+"</font>";g.push({item:_T("tree","leaf_powermgr")+(e+1),status:b})}for(e=0;(e+a-1)<this.data.fans.length;e+=a){b='<font class="green-status">'+_T("volume","volume_status_normal")+"</font>";for(c=0;c<a;c++){if(1!=this.data.fans[e+c]){b='<font class="red-status">'+_T("common","status_abnormal")+"</font>";break}}g.push({item:String.format(_T("system","system_module_fan"),(e<f)?1:2,((e%f)/a)+1),status:b})}d=new SYNO.SDS.StorageManager.Wizard.StorageDualHeadOverviewInfo({appWin:this.appWin,owner:this.owner,panel:this.panel,data:g});this.panel.mon(d,"close",function(){this.panel.startPollTask()},this,{single:true});this.panel.stopPollTask();d.open()},onShowHostSysInfo:function(){var c=[],a,b;c.push({item:_T("common","enc_serial"),status:this.data.sn});var d=String.format("{0} {1} / {2} {3}",this.data.temperature,_T("status","celsius"),this.panel.C2F(this.data.temperature).toFixed(0),_T("status","fahrenheit"));c.push({item:_T("status","temperature"),status:d});a=1===this.data.powers[0]?'<font class="green-status">'+_T("volume","volume_status_normal")+"</font>":'<font class="red-status">'+_T("common","status_abnormal")+"</font>";c.push({item:_T("tree","leaf_powermgr"),status:a});a=1===this.data.fans[0]?'<font class="green-status">'+_T("volume","volume_status_normal")+"</font>":'<font class="red-status">'+_T("common","status_abnormal")+"</font>";c.push({item:_T("system","fan_status"),status:a});b=new SYNO.SDS.StorageManager.Wizard.StorageDualHeadOverviewInfo({appWin:this.appWin,owner:this.owner,panel:this.panel,data:c});this.panel.mon(b,"close",function(){this.panel.startPollTask()},this,{single:true});this.panel.stopPollTask();b.open()},C2F:function(a){return(a*9/5+32)}});Ext.define("SYNO.SDS.StorageManager.Wizard.StorageDualHeadOverviewInfo",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;b={title:_T("home","home_subject"),width:400,height:126+28*a.data.length,resizable:false,layout:"fit",dsmStyle:"v5",border:false,items:[{layout:"fit",xtype:"syno_gridpanel",border:false,columns:[{header:_T("smart","smart_attribute"),dataIndex:"item",width:200,sortable:false},{header:_T("relayservice","status"),dataIndex:"status",width:200,useHtmlEncodeRender:false,sortable:false}],store:new Ext.data.JsonStore({autoDestroy:true,fields:["item","status"],data:a.data})}],buttons:[{xtype:"syno_button",text:_T("common","alt_close"),handler:this.close,scope:this}]};c.callParent([Ext.apply(b,a)])}});Ext.namespace("SYNO.SDS.StorageManager.Limits");SYNO.SDS.StorageManager.Limits.MAX_SNAPSHOT_ACTIONING_COUNT=8;Ext.Loader.load("webman/modules/Utils/circleGradient.js");Ext.define("SYNO.SDS.StorageManager.Store",{constructor:function(a){var b=this;b.count=0;b.data={};b.dataArray=[];b.callParent([a])},getAll:function(){return this.dataArray},getMatched:function(){var c=this,b,e,a=arguments,d=[];for(b in c.data){if(c.data.hasOwnProperty(b)){e=c.data[b];if(e.check.apply(e,a)){d.push(e)}}}d.sort(function(g,f){g=g.get("id");f=f.get("id");return(g>f)?1:((g<f)?-1:0)});return d},isAnyMatched:function(){var a=arguments;return(undefined!==this.findBy(function(b){return b.check.apply(b,a)}))},findBy:function(a){var c=this,b,d;for(b in c.data){if(c.data.hasOwnProperty(b)){d=c.data[b];if(a(d)){return d}}}return undefined},getById:function(a){return this.data[a]},prepareArray:function(){var b=this,a;for(a in b.data){if(b.data.hasOwnProperty(a)){b.dataArray.push(b.data[a])}}b.dataArray.sort(function(d,c){return(d.get("num_id")>c.get("num_id"))?1:((d.get("num_id")===c.get("num_id"))?0:-1)})}});Ext.define("SYNO.SDS.StorageManager.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.StorageManager.MainWindow",shouldNotifyMsg:function(a,b){return !this.window||this.window.isDestroyed||!this.window.isVisible()||this.window.shouldNotifyMsg(a,b)}});Ext.define("SYNO.SDS.StorageManager.MainWindow",{extend:"SYNO.SDS.PageListAppWindow",activePage:"SYNO.SDS.StorageManager.Overview.Main",constructorMap:{volumes:SYNO.SDS.StorageManager.Space,storagePools:SYNO.SDS.StorageManager.Space,iscsiLuns:SYNO.SDS.StorageManager.Space,ssdCaches:SYNO.SDS.StorageManager.SsdCache.Object,disks:SYNO.SDS.StorageManager.Disk.Object,hotSpares:SYNO.SDS.StorageManager.Disk.Object,enclosures:SYNO.SDS.StorageManager.Enclosure},smartStatusCache:{},constructor:function(a){var c=this,b,d,e;c.supportRaid=("yes"===_D("supportraid","no"));c.supportDiffRaid=("yes"===_D("support_diffraid","no"));c.supportSas=("yes"===_D("supportsas","no"));c.supportRaidGroup=("yes"===_D("supportraidgroup","no"));c.supportHotSpare=("yes"===_D("support_hotspare","no"));c.supportSsdCache=("yes"===_D("support_ssd_cache","no"));c.supportHA=("yes"===_D("support_ha","no"));c.supportBtrfs=("yes"===_D("support_btrfs","no"));c.disableSnapUI=("yes"===_D("support_dr_snap","no"));c.isVDSM=("kvmx64"===_D("synobios")||"nextkvmx64"===_D("synobios"));c.sdrRecoverySite=("recovery_site"===_S("systemdr_role"));c.sdrRunning=_S("systemdr_running");e=_D("host_wide_port_count",0);c.supportStorageOverviewUI=(c.supportSas&&2<=e)||("yes"===_D("support_dual_head","no"));c.cleanMask=false;c.update_err_count=0;c.lunblockcount=0;c.activeModule=undefined;c.loaded=false;c.env=undefined;c.initStore("volumes");c.initStore("storagePools");c.initStore("disks");c.initStore("iscsiLuns");c.initStore("hotSpares");c.initStore("ssdCaches");c.initStore("enclosures");d=c.getListItems();b={cls:"syno-app-storage-manager",dsmStyle:"v5",width:1000,height:600,minWidth:1000,minHeight:600,listItems:d};b=Ext.apply(b,a);c.callParent([b]);Ext.each(d,function(g){var f=Ext.getClassByName(g.fn);c.pageCt.items.add(new f({itemId:g.fn,appWin:c,owner:c}))},c)},getListItems:function(){var b=this,d=[];var e,a;e={text:_T("tree","leaf_volume"),iconCls:"icon-volume",fn:"SYNO.SDS.StorageManager.Volume.Main"};a={text:_T("volume","volume_storage_pool"),iconCls:"icon-raid-group",fn:"SYNO.SDS.StorageManager.Pool.Main"};d=[{text:_T("helptoc","overview"),iconCls:"icon-overview",fn:"SYNO.SDS.StorageManager.Overview.Main"}];if(b.supportRaidGroup){d.push(a);d.push(e)}else{d.push(e);d.push(a)}if(!b.isVDSM){d.push({text:_T("tree","leaf_hddmgr"),iconCls:"icon-hdd-management",fn:"SYNO.SDS.StorageManager.Disk.Main"})}if(b.supportHotSpare){d.push({text:_T("volume","volume_hot_spare"),iconCls:"icon-hot-spare",fn:"SYNO.SDS.StorageManager.HotSpare.Main"})}if(b.supportStorageOverviewUI){var c;if("yes"===_D("support_dual_head","no")){c="SYNO.SDS.StorageManager.StorageDualHeadOverview.Main"}else{if(_S("is_dual_chain")){c="SYNO.SDS.StorageManager.StorageDualChainOverview.Main"}else{c="SYNO.SDS.StorageManager.StorageOverview.Main"}}d.push({text:_T("volume","volume_storage_overview"),iconCls:"icon-expansion",fn:c})}if(b.supportSsdCache){d.push({text:_T("volume","ssd_cache"),iconCls:"icon-ssd-cache",fn:"SYNO.SDS.StorageManager.SsdCache.Main"})}return d},launchPageOnOpenCallBack:function(a){var b=this;b.deferOpen=false;if(b.selectPage(a)){b.openParams=null}},launchPageOnOpen:function(c){var b=this,a;if(b.checkModalOrMask()){return}if(!b.loaded&&c&&"SsdCacheAdvisor"===c.dlg){a=b.activePage}else{if(c&&c.fn){a=c.fn}else{a=b.activePage}}b.openParams=c;if(b.loaded){b.launchPageOnOpenCallBack(a)}else{b.deferOpen=true;b.deferFn=a}},onOpen:function(b){var c=this,a=false;c.callParent(arguments);c.pollTask=c.createPollTask(c.pollResultHandler.createSequence(function(g,d,f,e){if(b&&!a){if(b.tabname){c.onOpenHDDWCacheForm()}else{if(b.fn&&(b.fn!==c.activePage)){c.selectPage(b.fn);if("SsdCacheAdvisor"===b.dlg){c.activePage.onStatistic()}}}a=true}},c));c.mon(SYNO.SDS.StatusNotifier,"redirect",c.stopPollTask,c);c.mon(SYNO.SDS.StatusNotifier,"logout",c.stopPollTask,c);c.mon(SYNO.SDS.StatusNotifier,"halt",c.stopPollTask,c);c.setStatusBusy();c.cleanMask=true;c.pollTask.start();c.updatePageList()},onRequest:function(a){this.callParent(arguments);if(a&&a.tabname){this.onOpenHDDWCacheForm()}},onOpenHDDWCacheForm:function(){this.selectPage("SYNO.SDS.StorageManager.Disk.Main")},onClose:function(){var a=this.callParent(arguments);this.pollTask.stop();if(this.getPage("SYNO.SDS.StorageManager.SsdCache.Main")){this.getPage("SYNO.SDS.StorageManager.SsdCache.Main").onDeactivate()}return a},getPage:function(a){return this.pageCt.getComponent(a)},getDesktopHeight:function(){return SYNO.SDS.Desktop.getEl().getHeight()},createPollTask:function(a){return this.addWebAPITask({webapi:{api:"SYNO.Storage.CGI.Storage",method:"load_info",version:1,timeout:600000},interval:6000,callback:a||this.pollResultHandler,scope:this})},stopPollTask:function(){var a=this;if(a.pollTask){a.pollTask.stop()}},startPollTask:function(){var a=this;if(a.pollTask){a.pollTask.start()}},pollResultHandler:function(h,g,f,b){var d=this,e,a;if(d.cleanMask){d.clearStatusBusy();d.cleanMask=false}if(!h){this.update_err_count+=1;if(this.update_err_count<3){SYNO.Debug("tolerant connection fail, retry");return}}else{this.update_err_count=0}if(!h){var c=(g&&g.text)?g.text:_T("common","commfail");d.getMsgBox().alert(d.title,c,d.close,d);d.pollTask.stop();return}if(d.supportRaid&&g.env.status.system_crashed&&!SYNO.SDS.StorageManager.SystemCrashWarned){SYNO.SDS.StorageManager.SystemCrashWarned=true;d.getMsgBox().alert(d.title,_T("error","error_system_abnormal_steps"))}e=d.volumes.count;a=d.storagePools.count;delete d.env;delete d.detailUsage;delete d.spaceUsedByGluster;delete d.AHAInfo;d.env=g.env;d.AHAInfo=g.AHAInfo;d.detailUsage={};d.spaceUsedByGluster={};d.lunblockcount=0;d.processData(g);d.updatePageList();if(d.volumes.count<e||d.storagePools.count<a){SYNO.SDS.StatusNotifier.fireEvent("thirdpartychanged")}d.loaded=true;if(d.deferOpen){d.launchPageOnOpenCallBack(d.deferFn)}else{d.getActivePage().onActivate()}},updatePageList:function(){var b="SYNO.SDS.StorageManager.Pool.Main";var d="SYNO.SDS.StorageManager.Overview.Main";var a=this.getPageList();if(this.supportRaid||this.isSingleBayWithEbox()){a.setModuleVisible(b,true)}else{a.setModuleVisible(b,false);var c=this.getActivePage();if(c&&c.itemId===b){this.selectPage(d)}}},processData:function(c){var b=this,a;b.env=c.env;b.hotSpareConf=c.hotSpareConf;for(a in c){if(c.hasOwnProperty(a)){if("env"===a||"success"===a||"AHAInfo"===a||"hotSpareConf"===a){continue}if(c[a]){if("volumes"===a){b.processVolume(a,c[a])}else{if("iscsiLuns"===a){b.processIscsiLun(a,c[a])}else{if("ports"===a){b.processPort(c[a]);continue}else{b.processOthers(a,c[a])}}}b[a].count=c[a].length}}}Ext.each(b.storagePools.getAll(),function(d){d.json.used_by_gluster=b.spaceUsedByGluster[d.get("id")]||false},b)},initStore:function(a){var b=this;delete b[a];b[a]=new SYNO.SDS.StorageManager.Store()},processVolume:function(f,h){var e=this,a,g,j,c,d=e.constructorMap.volumes;e.initStore(f);for(var b=0;b<h.length;++b){a=h[b];g=a.pool_path;j=parseInt(a.size.total_device,10);if(!e.detailUsage[g]){e.detailUsage[g]={lun:0,volume:0}}e.detailUsage[g].volume+=j;if(a.used_by_gluster){e.spaceUsedByGluster[g]=true}a.desc=Ext.util.Format.htmlDecode(a.desc);a.desc=Ext.util.Format.htmlEncode(a.desc);c=new d();c.json=a;c.id=a.id;e.volumes.data[a.id]=c}e.volumes.prepareArray();e.volumes.count=h.length},processIscsiLun:function(e,g){var d=this,h,f,j,b,c=d.constructorMap.iscsiLuns;d.initStore(e);d.lunblockcount=0;for(var a=0;a<g.length;++a){h=g[a];f="";j=0;if("block"===h.iscsi_lun.device_type){f=h.pool_path;j=parseInt(h.iscsi_lun.size,10);d.lunblockcount++;if(!d.detailUsage[f]){d.detailUsage[f]={lun:0,volume:0}}d.detailUsage[f].lun+=j}b=new c();b.json=h;b.id=h.id;d.iscsiLuns.data[h.id]=b}d.iscsiLuns.prepareArray();d.iscsiLuns.count=g.length},processPort:function(a){var d=this,c,e,f,b={},h,g=d.constructorMap.disks;for(c=0;c<a.length;c++){e=a[c];f=new g();f.json={};b.order=0;b.str=e.port_type;b.type="internal";f.json.container=b;f.json.size_total="0";f.json.status=e.port_type;f.json.used_by=e.port_type;f.json.portType=e.port_type;f.json.id=e.port_name;f.json.num_id=e.port_num;f.json.order=e.port_num;h=e.port_name;f.id=e.port_name;d.disks.data[h]=f}d.disks.dataArray=[];d.disks.prepareArray();d.disks.count+=a.length},processOthers:function(b,a){var d=this,c,e,f,h,g=d.constructorMap[b];d.initStore(b);for(c=0;c<a.length;++c){e=a[c];if(g){f=new g()}else{f={}}f.json=e;f.id=e.id;h=e.id;if("disks"===b){if(!e.smart_status&&d.smartStatusCache[h]){f.json.smart_status=d.smartStatusCache[h]}else{d.smartStatusCache[h]=e.smart_status}}if("storagePools"===b){e.desc=Ext.util.Format.htmlDecode(e.desc);e.desc=Ext.util.Format.htmlEncode(e.desc)}d[b].data[h]=f}d[b].prepareArray();d[b].count=a.length},isSingleBay:function(){var a=parseInt(_D("maxdisks",1),10);return(1===a)},isSingleBayWithEbox:function(){return this.isSingleBay()&&this.isSupportEbox()&&this.isEboxPluged()},isSupportSHR:function(){return this.env&&this.env.support.sysdef},isUpToVolumeMaxCount:function(){var b=this,a=parseInt(_D("max_volumes",10),10);if(!b.volumes){return false}return(b.volumes.count>=a)},isUpToHASpaceMaxCount:function(){var b=this,a=parseInt(_D("max_ha_spacecount",10),10);if(!b.volumes){return(b.lunblockcount>=a)}return(b.volumes.count+b.lunblockcount>=a)},isUpToBatchTaskCount:function(){if(this.env&&this.env.batchtask){if(Ext.isDefined(this.env.batchtask.remain_task)&&(0===this.env.batchtask.remain_task)){return true}}return false},getMaxBatchTaskCount:function(){if(this.env&&this.env.batchtask&&Ext.isDefined(this.env.batchtask.max_task)){return this.env.batchtask.max_task}return undefined},isSupportRaidCross:function(){return this.env&&this.env.support.raid_cross},isSupportEbox:function(){return this.env&&this.env.support.ebox},isSupportSysRaidCustomization:function(){return("yes"===_D("support_dual_head","no"))||(5<=this.getBayNumber())},isEboxPluged:function(){return this.env&&this.env.ebox&&this.env.ebox.length},getBayNumber:function(){return this.env?parseInt(this.env.bay_number,10):1},getMaxVolumeSize:function(){var a=this;if(!a.env){return 0}if("yes"===_D("unlimited_volume_size")){return 65536*1024*1024*1024*1024}if(a.supportRaidGroup&&a.env.ram_enough_for_fs_high_end){return parseInt(a.env.max_fs_bytes_high_end,10)}else{return parseInt(a.env.max_fs_bytes,10)}},getUniqueKey:function(){return this.env?this.env.unique_key:""},shouldNotifyMsg:function(a,b){return true},isAnyStorageActioning:function(a){var b;if(!a){return false}for(b=0;b<a.length;++b){if(a[b].isActioning()){return true}}return false}});Ext.namespace("SYNO.SDS.StorageManager.StorageDualChainOverview");Ext.namespace("SYNO.SDS.StorageManager.StorageDualChainOverview.DrawData");SYNO.SDS.StorageManager.StorageDualChainOverview.DrawData.LinkInfo={height:48,left:18,inPortTop:5,linkWidth:6,linkGap:33,iconWidth:16,iconHeight:16,outPortTop:26,outLinkTop:31,longLinkHeight:98,shortLinkHeight:42,hostOutPortTop:16,hostOutLinkTop:21,hostLongLinkHeight:52,hostShortLinkHeight:108,chain1PortLeft:172,chain2PortLeft:264,chain1LinkLeft:197,chain2LinkLeft:289};SYNO.SDS.StorageManager.StorageDualChainOverview.DrawData.Rack={top:5,upperHeight:58,midHeight:56,bottomHeight:62,bottomWhite:7};SYNO.SDS.StorageManager.StorageDualChainOverview.DrawData.Hdd={width:52,height:11,initLeft:16,initTop:2,hGap:6,vGap:5};SYNO.SDS.StorageManager.StorageDualChainOverview.DrawData.Enclosure={width:260,height:52,left:4,top:0,topOffset:9,hddCount:12,hddLayout:[4,4,4],hdd:SYNO.SDS.StorageManager.StorageDualChainOverview.DrawData.Hdd,gap:4,linkInfo:SYNO.SDS.StorageManager.StorageDualChainOverview.DrawData.LinkInfo,lightHeight:24,lightLeft:322};SYNO.SDS.StorageManager.StorageDualChainOverview.LinkType={UNCHECK:-1,IN:1,OUT:2,NO:3,ILLEGAL:4};Ext.define("SYNO.SDS.StorageManager.StorageDualChainOverview.Main",{extend:"SYNO.ux.Panel",pollTask:null,hdds:null,displayDiskNum:false,constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.appWin;b={title:_T("helptoc","Enclosure"),itemId:"storage_overview",border:false,autoFlexcroll:true,tbar:{items:[{xtype:"syno_button",itemId:"DiskNumToggle",text:_T("volume","volume_display_disk_num"),handler:c.onDiskNumber,scope:c}]},items:c.canvas=new Ext.Panel({border:false}),listeners:{activate:c.onActivate,deactivate:c.onDeactivate,scope:c}};c.callParent([Ext.apply(b,a)])},getHelpParam:function(){return"StorageManager/storage_overview.html"},initEvents:function(){this.callParent(arguments);this.createPollTask()},createPollTask:function(){this.pollTask=this.addWebAPITask({webapi:{api:"SYNO.Storage.CGI.Enclosure",method:"load",version:1},interval:6000,scope:this,callback:this.pollTaskHandler})},startPollTask:function(){this.pollTask.start()},stopPollTask:function(){this.pollTask.stop()},pollTaskHandler:function(j,e,c,a){if(this.owner.cleanMask){this.owner.clearStatusBusy();this.owner.cleanMask=false}if(!j){return}var b=e.enclosures;if(!b){return}this.renderRack();var h=this.findTopology(b,1);var g=this.findTopology(b,2);var i=h.length<g.length?h.length:g.length;var d=h.length>1;var f=g.length>1;this.renderHost(b,d,f);this.renderExternal(h,i);this.renderExternal(g,i);this.doLayout()},renderRack:function(){this.canvas.body.update("");var d=SYNO.SDS.StorageManager.StorageDualChainOverview.DrawData.Rack;delete this.hdds;this.hdds=[];var b=d.top;var a=_D("sas_enclosure_max")-1;Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sm-storage-overview-bg-light-upper",style:{top:b+"px"}});b+=d.upperHeight;for(var c=0;c<a;c++){Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sm-storage-overview-bg-light-mid",style:{top:b+"px"}});b+=d.midHeight}Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sm-storage-overview-bg-light-bottom",style:{top:b+"px"}});b+=d.bottomHeight;this.canvas.setHeight(b+d.bottomWhite)},renderHost:function(c,b,a){var e=SYNO.SDS.StorageManager.StorageDualChainOverview.DrawData.Enclosure;e.top=e.topOffset;for(var d=0;d<c.length;d++){if(!c[d].isInternal){continue}if(c[d].chain==1){this.checkSystemStatus(c[d]);this.renderHardwareAndStatus(c[d],e);this.renderPort(c[d],e);this.renderHostLink(c[d],e,b,a);this.renderHdd(c[d],e);this.renderSystemLight(c[d],e)}else{this.renderHostLink(c[d],e,a,b)}}},renderExternal:function(c,g){var e=SYNO.SDS.StorageManager.StorageDualChainOverview.DrawData.Enclosure;var a,b;for(var d=0;d<c.length;d++){if(c[d].isInternal){continue}b=false;if(c[d].chain==1){if(d<g){a=2*d-1;b=true}else{a=g+d-1}}else{if(d<g-1){a=2*d;b=true}else{a=g+d-1}}e.top=e.topOffset+(e.gap+e.height)*a;var f=d===c.length-1;this.checkSystemStatus(c[d]);this.renderHardwareAndStatus(c[d],e);this.renderPort(c[d],e);this.renderLink(c[d],e,f,b);this.renderHdd(c[d],e);this.renderSystemLight(c[d],e)}},checkSystemStatus:function(c){var a,b=true;for(a=0;a<c.powers.length;a++){if(0===c.powers[a].status){b=false;break}}if(b){for(a=0;a<c.fans.length;a++){if(0===c.fans[a].status){b=false;break}}}c.isGood=b},renderHardwareAndStatus:function(h,a){var k="sds-enclosures2-enclosure";var j=h.isGood?"good":"bad";Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:k,style:{left:a.left+"px",top:a.top+"px"}});var c,i,f,e;var g=a.top+a.height/2-a.linkInfo.height/2;k=String.format("sds-enclosures2-infoleft-{0}",j);c=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:k,style:{top:g+"px"}}));k=String.format("sds-enclosures2-infocenter-{0}",j);i=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:k,style:{top:g+"px"}}));k=String.format("sds-enclosures2-inforight-{0}",j);f=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:k,style:{top:g+"px"}}));k=h.isGood?"sds-enclosures2-info-modelName-good":"sds-enclosures2-info-modelName-bad";var d=h.modelName.replace("Synology-","");var b=h.isInternal?_S("hostname"):String.format("{0} {1}",d,h.id);e=new Ext.Element(Ext.DomHelper.append(this.canvas.body,{tag:"div",html:b,cls:k,style:{top:g+"px"},"ext:qtip":b}))},renderPort:function(f,c){var b=c.top+c.height/2-c.linkInfo.height/2;var e=c.left+c.width+c.linkInfo.left;var a=1===f.chain?c.linkInfo.chain1PortLeft:c.linkInfo.chain2PortLeft;var d="sds-enclosures2-info-port-out-short";var g="sds-enclosures2-info-port-in-short";if(f.isInternal){Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:d,style:{top:b+c.linkInfo.hostOutPortTop+"px",left:e+c.linkInfo.chain1PortLeft+"px"}});Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:d,style:{top:b+c.linkInfo.hostOutPortTop+"px",left:e+c.linkInfo.chain2PortLeft+"px"}})}else{Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:g,style:{top:b+c.linkInfo.inPortTop+"px",left:e+a+"px"}});Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:d,style:{top:b+c.linkInfo.outPortTop+"px",left:e+a+"px"}})}},renderHostLink:function(m,b,e,a){var j=b.left+b.width+b.linkInfo.left;var o=b.top+b.height/2-b.linkInfo.height/2;var n=m.chain;var s=1===n?b.linkInfo.chain1LinkLeft:b.linkInfo.chain2LinkLeft;var c,g,f,r,d,k,l,q;var h=SYNO.SDS.StorageManager.StorageDualChainOverview.LinkType;if(2===n&&a){q=true}else{q=false}for(var p=0;p<m.ports.length;p++){r=false;if(!e){if(1===m.ports.length&&"0"===m.ports[0].linkId||2===m.ports.length&&"0"===m.ports[0].linkId&&"0"===m.ports[1].linkId){continue}c=q?"sds-enclosures2-info-disconnected-long1U":"sds-enclosures2-info-disconnected-long"}else{r=h.OUT===m.ports[p].portType&&m.ports[p].linkPortNum===m.ports[p].portNum;if(r){c=q?"sds-enclosures2-info-connected-long1U":"sds-enclosures2-info-connected-long"}else{c=q?"sds-enclosures2-info-disconnected-long1U":"sds-enclosures2-info-disconnected-long"}}g=b.linkInfo.hostOutLinkTop;f=q?b.linkInfo.hostLongLinkHeight:b.linkInfo.hostShortLinkHeight;d=b.linkInfo.linkWidth*(p%2)+b.linkInfo.linkGap*(p%2);Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:c,style:{left:j+s+d+"px",top:o+g+"px"}});if(!r){k=j+s+d+b.linkInfo.linkWidth/2-b.linkInfo.iconWidth/2-1;l=o+g+f/2-b.linkInfo.iconHeight/2;Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sds-enclosures2-info-disconnected-icon",style:{left:k+"px",top:l+"px"}})}}},renderLink:function(k,a,h,e){var q=a.left+a.width+a.linkInfo.left;var m=a.top+a.height/2-a.linkInfo.height/2;var b=1===k.chain?a.linkInfo.chain1LinkLeft:a.linkInfo.chain2LinkLeft;var l=SYNO.SDS.StorageManager.StorageDualChainOverview.LinkType;var p,c,d,f,o,n,j;for(var g=0;g<k.ports.length;g++){if((g<2&&!k.isInternal)){continue}f=false;if(h){if(2===k.ports.length&&"0"===k.ports[1].linkId||4===k.ports.length&&"0"===k.ports[2].linkId&&"0"===k.ports[3].linkId){continue}}else{f=l.OUT===k.ports[g].portType&&k.ports[g].linkPortNum+2===k.ports[g].portNum}if(e){p=f?"sds-enclosures2-info-connected-sas":"sds-enclosures2-info-disconnected-sas"}else{p=f?"sds-enclosures2-info-connected":"sds-enclosures2-info-disconnected"}c=a.linkInfo.outLinkTop;d=e?a.linkInfo.longLinkHeight:a.linkInfo.shortLinkHeight;o=a.linkInfo.linkWidth*(g%2)+a.linkInfo.linkGap*(g%2);Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:p,style:{left:q+b+o+"px",top:m+c+"px"}});if(!f){n=q+b+o+a.linkInfo.linkWidth/2-a.linkInfo.iconWidth/2-1;j=m+c+d/2-a.linkInfo.iconHeight/2;Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sds-enclosures2-info-disconnected-icon",style:{left:n+"px",top:j+"px"}})}}},renderHdd:function(k,a){var l,h=a.hdd.initTop+a.top;var g=0;for(var d=0;d<a.hddLayout.length;d++){l=a.hdd.initLeft+a.left;for(var c=0;c<a.hddLayout[d];c++){var f=Ext.DomHelper.append(this.canvas.body,{tag:"div",cls:"sds-enclosures2-hdd",style:{left:l+"px",top:h+"px","font-size":"11px"}});var b=new Ext.Element(f);b.owner=this;b.order=g+1;b.status=0!==k.disks[g].id?1:0;if(this.displayDiskNum&&0!==b.status){var e=b.order<10?"0"+b.order:b.order;f.innerHTML=e;f.style.border="2px solid"}this.hdds.push(b);l+=a.hdd.hGap+a.hdd.width;g++}h+=a.hdd.vGap+a.hdd.height}},renderSystemLight:function(d,b){var c=this,a;a=new Ext.Element(Ext.DomHelper.append(c.canvas.body,{tag:"div",cls:d.isGood?"sds-enclosures2-info-light-good":"sds-enclosures2-info-light-bad",style:{top:b.top+b.height/2-b.lightHeight/2+"px"}}));a.on("click",c.onShowSysInfo,{appWin:c.appWin,owner:c.owner,panel:c,data:d})},onActivate:function(){var a=this;a.canvas.body.update("");a.owner.setStatusBusy();a.owner.cleanMask=true;a.appWin.stopPollTask();a.startPollTask()},onDeactivate:function(){this.appWin.startPollTask();this.stopPollTask()},onDiskNumber:function(){this.displayDiskNum=!this.displayDiskNum;var d=this.displayDiskNum?_T("volume","volume_hide_disk_num"):_T("volume","volume_display_disk_num");this.getTopToolbar().getComponent("DiskNumToggle").setText(d);for(var b=0;b<this.hdds.length;b++){if(0!==this.hdds[b].status){var a=this.hdds[b].order<10?"0"+this.hdds[b].order:this.hdds[b].order;var c=this.hdds[b].dom;c.innerHTML=this.displayDiskNum?a:"";c.style.border=this.displayDiskNum?"2px solid":""}}},onShowSysInfo:function(){var d=[],c,a,b;var e=String.format("{0} {1} / {2} {3}",this.data.temperature,_T("status","celsius"),this.panel.C2F(this.data.temperature).toFixed(0),_T("status","fahrenheit"));d.push({item:_T("status","temperature"),status:e});for(c=0;c<this.data.powers.length;c++){a=1===this.data.powers[c].status?'<font class="green-status">'+_T("volume","volume_status_normal")+"</font>":'<font class="red-status">'+_T("common","status_abnormal")+"</font>";d.push({item:_T("tree","leaf_powermgr")+this.data.powers[c].num,status:a})}for(c=0;c<this.data.fans.length;c++){a=1===this.data.fans[c].status?'<font class="green-status">'+_T("volume","volume_status_normal")+"</font>":'<font class="red-status">'+_T("common","status_abnormal")+"</font>";d.push({item:_T("system","system_fan")+this.data.fans[c].num,status:a})}b=new SYNO.SDS.StorageManager.Wizard.StorageOverviewInfo({appWin:this.appWin,owner:this.owner,panel:this.panel,data:d});this.panel.mon(b,"close",function(){this.panel.startPollTask()},this,{single:true});this.panel.stopPollTask();b.open()},findTopology:function(c,b){var g,j,d=0,k={};var m=SYNO.SDS.StorageManager.StorageDualChainOverview.LinkType;for(g=0;g<c.length;g++){if(c[g].isInternal&&c[g].chain==b){j=c[g];break}}var n=j.uniqueId,e=null;for(g=0;g<j.ports.length;g++){j.ports[g].portType="0"===j.ports[g].linkId?m.NO:m.OUT;if(!e&&m.OUT===j.ports[g].portType){e=j.ports[g].linkId}}if(2===j.ports.length&&m.NO!==j.ports[0].portType&&m.NO!==j.ports[1].portType&&j.ports[0].linkId!==j.ports[1].linkId){j.ports[1].portType=m.ILLEGAL}k[n]=true;var h=[];h.push(j);do{if(1===c.length){break}var o=false;for(g=0;g<c.length;g++){if(c[g].uniqueId===e&&undefined===k[e]){j=c[g];o=true;break}}if(!o){break}var l=j.ports,f=0;for(g=0;g<l.length;g++){if(l[g].linkId===n&&2>f){l[g].portType=m.IN;f++}else{if(l[g].linkId===n&&2<=f){l[g].portType=m.ILLEGAL}else{if("0"===l[g].linkId){l[g].portType=m.NO}else{l[g].portType=m.UNCHECK}}}}e="0";f=0;for(g=0;g<l.length;g++){if(m.UNCHECK===l[g].portType){if("0"===e){e=l[g].linkId}if(l[g].linkId===e){l[g].portType=m.OUT}else{l[g].portType=m.ILLEGAL}}}h.push(j);n=j.uniqueId;k[n]=true;d++;var a=true;for(g=0;g<l.length;g++){if(m.IN===l[g].portType&&!l[g].valid){a=false;break}}if(!a){break}}while(d<c.length-1);return h},C2F:function(a){return(a*9/5+32)}});Ext.define("SYNO.SDS.StorageManager.Wizard.StorageOverviewInfo",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){var c=this,b;c.appWin=a.appWin;c.owner=a.owner;b={title:_T("home","home_subject"),width:400,height:320,layout:"fit",dsmStyle:"v5",border:false,items:[{layout:"fit",xtype:"syno_gridpanel",border:false,columns:[{header:_T("smart","smart_attribute"),dataIndex:"item",width:200,sortable:false},{header:_T("relayservice","status"),dataIndex:"status",width:200,useHtmlEncodeRender:false,sortable:false}],store:new Ext.data.JsonStore({autoDestroy:true,fields:["item","status"],data:a.data})}],buttons:[{xtype:"syno_button",text:_T("common","alt_close"),handler:this.close,scope:this}]};c.callParent([Ext.apply(b,a)])}});