#!/bin/sh

DualheadCantInstallMsg()
{
if [ "x${SupportDualhead}" != "xyes" ]; then
	return;
fi
cat <<EOF
Expires: Mon, 26 Jul 1990 05:00:00 GMT
Cache-Control: no-store, no-cache, must-revalidate
Pragma: no-cache
Content-type: text/plain; charset="UTF-8"

EOF

cat <<EOF
{
	"success": true,
	"data": {
		"dsinfo": {
			"product": "${product}",
			"model": "${upnpmodelname}",
			"serial": "`cat /proc/sys/kernel/syno_serial`",
			"build_num": ${buildnumber},
			"build_ver": "${majorversion}.${minorversion}-${buildnumber}",
			"is_local_third_host": ${is_local_third_host},
			"is_remote_third_host": ${is_remote_third_host},
			"remote_ip_list": [${remote_ip_list}],
			"support_dual_head": "${SupportDualhead}",
			"remote_role": "${remote_role}",
			"install_status": "${install_status}"
		}
	}
}
EOF

exit 0;
}

dual_check_remote_info() {
	partition=`/usr/syno/bin/synodiskport -eunit`
	IsThirdHost="/dual_glibc"`/usr/sbin/chroot /dual_glibc /usr/syno/synoaha/bin/synoahastr --local-is-third-host`
	if [ "xyes" = "x`/bin/get_key_value /dual_glibc/tmp/aha/ha.status is_local_the_third_host`" -o -f $IsThirdHost ]; then
		is_local_third_host="true";
	else
		is_local_third_host="false"
	fi
	if [ "xyes" = "x`/bin/get_key_value /dual_glibc/tmp/aha/ha.status is_remote_the_third_host`" ]; then
		is_remote_third_host="true";
	else
		is_remote_third_host="false"
	fi
	remote_ip=`/bin/get_key_value /dual_glibc/tmp/aha/ha.status remote_host_IP | /dual_glibc/bin/sed 's/,/","/g'`
	if [ "x${remote_ip}" = "x" ]; then
		remote_ip_list=""
	else
		remote_ip_list="\"${remote_ip}\""
	fi

	remote_role=`/usr/sbin/chroot /dual_glibc/ /usr/syno/synoaha/bin/synoaha --get-remote-role`

	if [ "`/usr/sbin/chroot /dual_glibc/ /usr/syno/synoaha/bin/synoahastr --role-active`" = "${remote_role}" ]; then
		remote_role="active"
	elif [ "`/usr/sbin/chroot /dual_glibc/ /usr/syno/synoaha/bin/synoahastr --role-passive`" = "${remote_role}" ]; then 
		remote_role="passive"
	else
		remote_role="unknown"
	fi

	if [ "true" = ${dual_is_check_stage} -o "true" = ${dual_is_passive_stage} ]; then
		return
	fi

	install_status_output=`/usr/sbin/chroot /dual_glibc/ /usr/syno/synoaha/bin/synoaha --check-install-status`
	install_status=`/bin/echo $install_status_output | cut -d ' ' -f 1`;
	has_sata_disk=`/bin/echo $install_status_output | cut -d ' ' -f 2`;

	if [ "can_install" != "${install_status}" ]; then
		DualheadCantInstallMsg
	fi
}

dual_check_boot_error() {
	DUAL_EXEC="/usr/sbin/chroot /dual_glibc"
	DUAL_EXEC_SYNOAHA="$DUAL_EXEC /usr/syno/synoaha/bin/synoaha"
	DUAL_EXEC_SYNOAHASTR="$DUAL_EXEC /usr/syno/synoaha/bin/synoahastr"

	dual_is_check_stage="false";
	dual_is_passive_stage="false";

	if [ -f "/dual_glibc/check_stage" ]; then
		$DUAL_EXEC_SYNOAHA --is-booting-done
		boot_done=$?
		if [ "$boot_done" == "0" ]; then
			dual_is_check_stage="true";
		elif [ "$boot_done" == "1" ]; then
			dual_is_passive_stage="true";
		fi

		CHECK_STAGE_ERROR_FILE="/dual_glibc/`$DUAL_EXEC_SYNOAHASTR --check-stage-error-file`"
		CHECK_STAGE_ERROR_KEY=`$DUAL_EXEC_SYNOAHASTR --check-stage-error-key`
		if [ -f "$CHECK_STAGE_ERROR_FILE" ]; then
			dual_check_link_error=`/bin/get_key_value "$CHECK_STAGE_ERROR_FILE" "$CHECK_STAGE_ERROR_KEY"`
		else
			dual_check_link_error=""
		fi
		PASSIVE_UI_MSG_FILE="/dual_glibc/`$DUAL_EXEC_SYNOAHASTR --passive-ui-msg-file`"
		PASSIVE_UI_TITLE_KEY=`$DUAL_EXEC_SYNOAHASTR --passive-ui-title-key`
		PASSIVE_UI_DES_KEY=`$DUAL_EXEC_SYNOAHASTR --passive-ui-des-key`
		if [ -f "$PASSIVE_UI_MSG_FILE" ]; then
			dual_passive_ui_title=`/bin/get_key_value "$PASSIVE_UI_MSG_FILE" "$PASSIVE_UI_TITLE_KEY"`
			dual_passive_ui_des=`/bin/get_key_value "$PASSIVE_UI_MSG_FILE" "$PASSIVE_UI_DES_KEY"`
		else
			dual_passive_ui_title="title_unknown_error"
			dual_passive_ui_des="title_unknown_error"
		fi
	fi
}
