#!/bin/sh

# This script is used by ErrFHOSTDoFdiskFormat
# must specify the install type (-r or/and -d)
# -r: format root partition
# -d: format data partition (only for 1-bay)
. /etc/rc.subr

RaidTool="/sbin/raidtool"
PROCPARTITION="/proc/partitions"
SupportRAID=`/bin/get_key_value /etc/synoinfo.conf supportraid`
SupportDualhead=`/bin/get_key_value /etc.defaults/synoinfo.conf support_dual_head`
SYNOBIOS=`/bin/get_key_value /etc/synoinfo.conf synobios`
DefaultFS=`/bin/get_key_value /etc/synoinfo.conf defaultfs`
SystemFS=`/bin/get_key_value /etc/synoinfo.conf systemfs`
SupportBuildinStorage=`/bin/get_key_value /etc.defaults/synoinfo.conf support_buildin_storage`
UniqueRD=`/bin/get_key_value /etc.defaults/synoinfo.conf unique | cut -d"_" -f2`
EmmcBoot=`/bin/get_key_value /etc.defaults/synoinfo.conf support_emmc_boot`
SupportLocalInstall=`/bin/get_key_value /etc.defaults/synoinfo.conf support_localinstall`
if [ "$SupportRAID" = "yes" ]; then
   DISKNODE="/dev/md"
   PARTNO_ROOT="0"
   PARTNO_SWAP="1"
   PARTNO_DATA="2"
else
   DISKNODE="/dev/sda"
   PARTNO_ROOT="1"
   PARTNO_SWAP="2"
   PARTNO_DATA="3"
fi
WRITEABLE_SIZE=4980480
SWAP_SIZE=4194304
ROOT_SKIP=2048
SWAP_SKIP=0
DATA_SKIP=260352
DATA_SIZE=-1
LINUX_FS_TYPE=83
LINUX_SWAP_TYPE=82
Sfdisk="/sbin/sfdisk"
Mount="/bin/mount"
Umount="/bin/umount"
FS_Opt=""
ErrorFile="/tmp/installer.error"
HaveDisk=0

DO_CLEAN_ROOT="no"
DO_CLEAN_DATA="no"
CREATE_DATA="no"
DO_CLEAN_INSTALL="no"

if [ "yes" = "${EmmcBoot}" ]; then
	PARTNO_PATCH="4"
	WRITEABLE_SIZE=2097152
	DATA_SIZE=5105569
	PATCH_SIZE=524288
	DATA_SKIP=0
	PATCH_SKIP=0
fi

if [ "${SYNOBIOS}" = "vs960hd" ]; then
	WRITEABLE_SIZE=4194304
	DATA_SIZE=2432148
	PATCH_SIZE=-1
fi

###########################################################

# stop all burn-in test (memtester or DMA test) before install
/usr/sbin/burnin_test -f &> /dev/null

/bin/echo "Check new disk..."
for i
do
	case "${i}"
	in
		-r)
			DO_CLEAN_ROOT="yes"
			shift
		;;
		-d)
			DO_CLEAN_DATA="yes"
			CREATE_DATA="yes"
			shift
		;;
		-c)
			DO_CLEAN_INSTALL="yes"
			shift
		;;esac
done

/bin/rm ${ErrorFile}

if [ "$SYNOBIOS" = "kvmx64" -o "$SYNOBIOS" = "nextkvmx64" ]; then
	CREATE_DATA="no"
fi

if [ "$SupportRAID" = "yes" ]; then
	if [ "$SupportDualhead" = "yes" ]; then
		diskIdxList=`/usr/syno/bin/synodiskport -eunit`
	else
		diskIdxList=`/usr/syno/bin/synodiskport -internal`
	fi
	for DiskIdx in ${diskIdxList} ; do
		/bin/dd if=/dev/${DiskIdx} of=/dev/null count=1 > /dev/null 2>&1
		if [ $? = "0" ]; then
			HaveDisk=1
		fi
	done

	if [ "0" = "${HaveDisk}" ]; then
		IfErrorThenExit "NODISK" 1 ${ErrorFile}
	fi
else
	/bin/dd if=/dev/sda of=/dev/null count=1 > /dev/null 2>&1
	if [ $? != "0" ]; then
		IfErrorThenExit "NODISK" 1 ${ErrorFile}
	fi
fi

/bin/umount /volume1
if [ "yes" != "${EmmcBoot}" ]; then
	/sbin/swapoff ${DISKNODE}${PARTNO_SWAP}
fi

if [ "$DO_CLEAN_ROOT" = "no" ]; then
    Res=0
    # Notify Assistant to skip format system partition
    /bin/touch "/.skip_format_sys"
    /bin/echo "touching /.skip_format_sys"
else
	if [ "$SupportRAID" = "yes" ]; then
		for RaidVol in 0 1; do
		    /bin/echo "${RaidTool} destroy ${RaidVol}"
		    ${RaidTool} destroy ${RaidVol}
	    done

        #For NVR-series, it supports USB local installation.
        #If this installation comes from local installation, clean all disks for "not install" status.
        #The reason to do this is if disks is derived from other DiskStation, crash volume may exist and
        #SurveillanceStation won't be installed.
        if [ "x${SupportLocalInstall}" == "xyes" -a "x${DO_CLEAN_INSTALL}" == "xyes" ]; then
            for DiskIdx in ${diskIdxList} ; do
                ${Sfdisk} -M1 /dev/${DiskIdx}
                ${Sfdisk} "--fast-delete" "-1" "/dev/${DiskIdx}"
                /bin/dd if=/dev/zero of=/dev/${DiskIdx} bs=1M count=1 > /dev/null 2>&1
            done
        fi

	    ${RaidTool} initsys
	    IfErrorThenExit "CREATE" $? ${ErrorFile}
	elif [ "$DO_CLEAN_DATA" = "yes" ]; then
		diskIdxList=`/usr/syno/bin/synodiskport -internal`
		for DiskIdx in ${diskIdxList} ; do
			${Sfdisk} -M1 /dev/${DiskIdx}
			ResFdisk=$?
			IfErrorThenExit "FDISK" $ResFdisk ${ErrorFile}
			/bin/echo "Clean disk ${DiskIdx}"
			${Sfdisk} "--fast-delete" "-1" "/dev/${DiskIdx}"
			IfErrorThenExit "CLEAN" $? ${ErrorFile}
		done

		if [ "${SYNOBIOS}" = "vs960hd" ]; then
			/bin/dd if=/dev/zero of=${DISKNODE} bs=1M count=1 > /dev/null 2>&1
			${Sfdisk} -M1 ${DISKNODE}
		fi

	    CreatePartition ${PARTNO_ROOT} ${WRITEABLE_SIZE} ${LINUX_FS_TYPE} ${ROOT_SKIP} ${DISKNODE}
	    IfErrorThenExit "CREATE" $? ${ErrorFile}
	    if [ "yes" != "${EmmcBoot}" ]; then
		    CreatePartition ${PARTNO_SWAP} ${SWAP_SIZE} ${LINUX_SWAP_TYPE} ${SWAP_SKIP} ${DISKNODE}
		    IfErrorThenExit "CREATE" $? ${ErrorFile}
	    fi
	    if [ "yes" = "${EmmcBoot}" ]; then
		    CreatePartition ${PARTNO_DATA} ${DATA_SIZE} ${LINUX_FS_TYPE} ${DATA_SKIP} ${DISKNODE}
		    IfErrorThenExit "CREATE" $? ${ErrorFile}

	        CreatePartition ${PARTNO_PATCH} ${PATCH_SIZE} ${LINUX_FS_TYPE} ${PATCH_SKIP} ${DISKNODE}
	        IfErrorThenExit "CREATE" $? ${ErrorFile}
	    fi
		sleep 1
	    if [ "yes" != "${EmmcBoot}" -a "$SYNOBIOS" != "kvmx64" -a "$SYNOBIOS" != "nextkvmx64" ]; then
	        synodd ${DISKNODE}${PARTNO_ROOT} ${DISKNODE}${PARTNO_SWAP}
	        IfErrorThenExit "SYNODD" $? ${ErrorFile}
	    else
	        echo "1/1" > /tmp/synodd.sda
	    fi
	fi

	if [ "yes" != "${EmmcBoot}" ]; then
		/bin/echo "mkswap ${DISKNODE}${PARTNO_SWAP}"
		/sbin/mkswap ${DISKNODE}${PARTNO_SWAP}
		IfErrorThenExit "MKSWAP" $? ${ErrorFile}
	fi

    FS_Opt=$( get_mkfs_option ${SystemFS} )
    /sbin/mkfs.${SystemFS} ${FS_Opt} ${DISKNODE}${PARTNO_ROOT}
    Res=$?
    IfErrorThenExit "MKFS" $Res ${ErrorFile}

	if [ "yes" = "${EmmcBoot}" ]; then
		/sbin/mkfs.${DefaultFS} ${DISKNODE}${PARTNO_DATA}
		Res=$?
		IfErrorThenExit "MKFS" $Res ${ErrorFile}

		/sbin/mkfs.${SystemFS} ${DISKNODE}${PARTNO_PATCH}
		Res=$?
		IfErrorThenExit "MKFS" $Res ${ErrorFile}
	fi
fi

if [ $Res -eq 0 -a "$SupportDualhead" = "yes" ]; then
	/usr/sbin/chroot /dual_glibc /usr/syno/synoaha/bin/synoaha --prepare-for-install
	Res=$?
fi

if [ $Res -eq 0 ]; then
	/bin/mount ${DISKNODE}${PARTNO_ROOT} /mnt
	/bin/touch /mnt/.noroot
	/bin/umount /mnt
fi

if [ -x /usr/syno/bin/mantool ]; then
	/usr/syno/bin/mantool -auto_poweron_disable
fi

if [ "$SupportRAID" = "yes" -o $CREATE_DATA = "no" ]; then
	exit 0
fi

# ##########################################################
# originally in newdisk.sh, only execute when 1-bay not installed

if [ "yes" = "${EmmcBoot}" ]; then
	echo "1/1" > /tmp/mkfs.progress.sda3
	echo "Support eMMC boot. Do nothing."
	exit 0
else
	echo "New disk. Begin initialization."
fi

# Create data partition
CreatePartition ${PARTNO_DATA} ${DATA_SIZE} ${LINUX_FS_TYPE} ${DATA_SKIP} ${DISKNODE}
IfErrorThenExit "CREATE" $? ${ErrorFile}

# swap on to prevent out of memory when making fs of data volume
swapon ${DISKNODE}${PARTNO_SWAP}
FS_Opt=$( get_mkfs_option ${DefaultFS} )
mkfs.${DefaultFS} ${FS_Opt} ${DISKNODE}${PARTNO_DATA}
Res=$?
IfErrorThenExit "MKFS" $Res ${ErrorFile}
swapoff ${DISKNODE}${PARTNO_SWAP}
