#!/bin/sh
# Copyright (c) 2000-2015 Synology Inc. All rights reserved.
dump_sas_disk_map()
{
	supportSAS=`/bin/get_key_value /etc.defaults/synoinfo.conf supportsas`
	if [ "xyes" == "x${supportSAS}" -o "xYES" == "x${supportSAS}" ]; then
		sleep 15
		/usr/syno/bin/synoenc --dump_enc_disk /tmp/sasdiskmaps
		cat /tmp/sasdiskmaps >> /var/log/messages
	fi
}

dump_cache_slot_info()
{
	local disk_info=`synodisk --enum -t cache | egrep "Slot id|Disk id|Disk path"`
	local output=""

	if [ -z $disk_info ]; then
		return
	fi

	output="******  Cache Slot info *******\n"
	while read -r line
	do
		line=`echo $line | cut -c 4-`
		output="$output$line"
		if [[ `echo $line | grep "Disk path"` ]]; then
			output="$output \n"
		else
			output="$output, "
		fi
	done <<< "$disk_info"

	echo -e "$output" >> /var/log/messages
}

dump_disk_info()
{
	dump_cache_slot_info
	dump_sas_disk_map
}

usage() {
	cat << EOF
Usage: $(basename $0) [start]
EOF
}

start()
{
	if [ -x /usr/syno/bin/synofstool ]; then
		/usr/syno/bin/synofstool --dump-fscache &
	fi

	dump_disk_info &

	#Change permission of /dev/fuse
	if [ -e "/dev/fuse" ]; then
		/bin/chown root:users /dev/fuse
		/bin/chmod 0666 /dev/fuse
	fi

	# the file was touched in /etc/rc
	if [ -f /tmp/.ImproperShutdown ]; then
		/usr/syno/bin/synologset1 sys warn 0x11100001
		/usr/syno/bin/synonotify ImproperShutdown
		rm -f /tmp/.ImproperShutdown
	fi

	if [ "yes" = "`/bin/get_key_value /etc/synoinfo.conf runha`" ] &&
		[ "Passive" = "`/usr/syno/synoha/sbin/synoha --local-role`" ]; then
		# do nothing after upgrade on passive, active will do these things
		:;
	elif [ -f /.updater ] || [ -f /var/.UpgradeBootup ]; then
		/usr/syno/bin/synopkg upgradeall true &
		/usr/syno/bin/synoselfcheck -o "dsmupdate_$(date "+%Y%m%d_%H%M%S").result" dsm full &
	elif [ -f /var/.SmallupdateBootup ]; then
		/usr/syno/bin/synopkg upgradeall true &
		/usr/syno/bin/synoselfcheck -o "smallupdate_$(date "+%Y%m%d_%H%M%S").result" dsm full &
	fi

	# In VDSM, we will ask host to initialize guest here.
	if [ -x /usr/syno/synovdsm/scripts/initializeVdsm.sh ]; then
		/usr/syno/synovdsm/scripts/initializeVdsm.sh
	fi

	#Remove updater and version files for first-bootup of upgrade
	rm -f /.updater
	rm -f /var/.UpgradeBootup
	rm -f /var/.SmallupdateBootup

	# clean up migrate backup file
	rm -rf /.syno/update_bkp/
}

case "$1" in
	start) start;;
	*) usage >&2; exit 1;;
esac
